package software.amazon.awscdk.services.ec2;

/**
 * Props for a PlacementGroup.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * InstanceType instanceType;
 * PlacementGroup pg = PlacementGroup.Builder.create(this, "test-pg")
 *         .strategy(PlacementGroupStrategy.SPREAD)
 *         .build();
 * Instance.Builder.create(this, "Instance")
 *         .vpc(vpc)
 *         .instanceType(instanceType)
 *         .machineImage(MachineImage.latestAmazonLinux2023())
 *         .placementGroup(pg)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:24:57.336Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.PlacementGroupProps")
@software.amazon.jsii.Jsii.Proxy(PlacementGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PlacementGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The number of partitions.
     * <p>
     * Valid only when Strategy is set to partition.
     * <p>
     * Default: 0
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPartitions() {
        return null;
    }

    /**
     * the name of this placement group.
     * <p>
     * Default: - generated by CFN
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPlacementGroupName() {
        return null;
    }

    /**
     * Places instances on distinct hardware.
     * <p>
     * Spread placement groups are recommended for applications
     * that have a small number of critical instances that should be kept separate from each other.
     * Launching instances in a spread level placement group reduces the risk of simultaneous failures
     * that might occur when instances share the same equipment.
     * Spread level placement groups provide access to distinct hardware,
     * and are therefore suitable for mixing instance types or launching instances over time.
     * If you start or launch an instance in a spread placement group and there is insufficient
     * unique hardware to fulfill the request, the request fails. Amazon EC2 makes more distinct hardware
     * available over time, so you can try your request again later.
     * Placement groups can spread instances across racks or hosts.
     * You can use host level spread placement groups only with AWS Outposts.
     * <p>
     * Default: - no spread level
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.PlacementGroupSpreadLevel getSpreadLevel() {
        return null;
    }

    /**
     * Which strategy to use when launching instances.
     * <p>
     * Default: - `PlacementGroupStrategy.PARTITION` if `partitions` is defined, `CLUSTER` otherwise
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.PlacementGroupStrategy getStrategy() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link PlacementGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PlacementGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PlacementGroupProps> {
        java.lang.Number partitions;
        java.lang.String placementGroupName;
        software.amazon.awscdk.services.ec2.PlacementGroupSpreadLevel spreadLevel;
        software.amazon.awscdk.services.ec2.PlacementGroupStrategy strategy;

        /**
         * Sets the value of {@link PlacementGroupProps#getPartitions}
         * @param partitions The number of partitions.
         *                   Valid only when Strategy is set to partition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder partitions(java.lang.Number partitions) {
            this.partitions = partitions;
            return this;
        }

        /**
         * Sets the value of {@link PlacementGroupProps#getPlacementGroupName}
         * @param placementGroupName the name of this placement group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder placementGroupName(java.lang.String placementGroupName) {
            this.placementGroupName = placementGroupName;
            return this;
        }

        /**
         * Sets the value of {@link PlacementGroupProps#getSpreadLevel}
         * @param spreadLevel Places instances on distinct hardware.
         *                    Spread placement groups are recommended for applications
         *                    that have a small number of critical instances that should be kept separate from each other.
         *                    Launching instances in a spread level placement group reduces the risk of simultaneous failures
         *                    that might occur when instances share the same equipment.
         *                    Spread level placement groups provide access to distinct hardware,
         *                    and are therefore suitable for mixing instance types or launching instances over time.
         *                    If you start or launch an instance in a spread placement group and there is insufficient
         *                    unique hardware to fulfill the request, the request fails. Amazon EC2 makes more distinct hardware
         *                    available over time, so you can try your request again later.
         *                    Placement groups can spread instances across racks or hosts.
         *                    You can use host level spread placement groups only with AWS Outposts.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spreadLevel(software.amazon.awscdk.services.ec2.PlacementGroupSpreadLevel spreadLevel) {
            this.spreadLevel = spreadLevel;
            return this;
        }

        /**
         * Sets the value of {@link PlacementGroupProps#getStrategy}
         * @param strategy Which strategy to use when launching instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder strategy(software.amazon.awscdk.services.ec2.PlacementGroupStrategy strategy) {
            this.strategy = strategy;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PlacementGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PlacementGroupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PlacementGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PlacementGroupProps {
        private final java.lang.Number partitions;
        private final java.lang.String placementGroupName;
        private final software.amazon.awscdk.services.ec2.PlacementGroupSpreadLevel spreadLevel;
        private final software.amazon.awscdk.services.ec2.PlacementGroupStrategy strategy;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.partitions = software.amazon.jsii.Kernel.get(this, "partitions", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.placementGroupName = software.amazon.jsii.Kernel.get(this, "placementGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.spreadLevel = software.amazon.jsii.Kernel.get(this, "spreadLevel", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.PlacementGroupSpreadLevel.class));
            this.strategy = software.amazon.jsii.Kernel.get(this, "strategy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.PlacementGroupStrategy.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.partitions = builder.partitions;
            this.placementGroupName = builder.placementGroupName;
            this.spreadLevel = builder.spreadLevel;
            this.strategy = builder.strategy;
        }

        @Override
        public final java.lang.Number getPartitions() {
            return this.partitions;
        }

        @Override
        public final java.lang.String getPlacementGroupName() {
            return this.placementGroupName;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.PlacementGroupSpreadLevel getSpreadLevel() {
            return this.spreadLevel;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.PlacementGroupStrategy getStrategy() {
            return this.strategy;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getPartitions() != null) {
                data.set("partitions", om.valueToTree(this.getPartitions()));
            }
            if (this.getPlacementGroupName() != null) {
                data.set("placementGroupName", om.valueToTree(this.getPlacementGroupName()));
            }
            if (this.getSpreadLevel() != null) {
                data.set("spreadLevel", om.valueToTree(this.getSpreadLevel()));
            }
            if (this.getStrategy() != null) {
                data.set("strategy", om.valueToTree(this.getStrategy()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.PlacementGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PlacementGroupProps.Jsii$Proxy that = (PlacementGroupProps.Jsii$Proxy) o;

            if (this.partitions != null ? !this.partitions.equals(that.partitions) : that.partitions != null) return false;
            if (this.placementGroupName != null ? !this.placementGroupName.equals(that.placementGroupName) : that.placementGroupName != null) return false;
            if (this.spreadLevel != null ? !this.spreadLevel.equals(that.spreadLevel) : that.spreadLevel != null) return false;
            return this.strategy != null ? this.strategy.equals(that.strategy) : that.strategy == null;
        }

        @Override
        public final int hashCode() {
            int result = this.partitions != null ? this.partitions.hashCode() : 0;
            result = 31 * result + (this.placementGroupName != null ? this.placementGroupName.hashCode() : 0);
            result = 31 * result + (this.spreadLevel != null ? this.spreadLevel.hashCode() : 0);
            result = 31 * result + (this.strategy != null ? this.strategy.hashCode() : 0);
            return result;
        }
    }
}
