package software.amazon.awscdk.services.ecs;

/**
 * The interface for Runtime Platform.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * ApplicationLoadBalancedFargateService applicationLoadBalancedFargateService = ApplicationLoadBalancedFargateService.Builder.create(this, "Service")
 *         .cluster(cluster)
 *         .memoryLimitMiB(512)
 *         .taskImageOptions(ApplicationLoadBalancedTaskImageOptions.builder()
 *                 .image(ContainerImage.fromRegistry("amazon/amazon-ecs-sample"))
 *                 .build())
 *         .minHealthyPercent(100)
 *         .runtimePlatform(RuntimePlatform.builder()
 *                 .cpuArchitecture(CpuArchitecture.ARM64)
 *                 .operatingSystemFamily(OperatingSystemFamily.LINUX)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:24:57.769Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.RuntimePlatform")
@software.amazon.jsii.Jsii.Proxy(RuntimePlatform.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RuntimePlatform extends software.amazon.jsii.JsiiSerializable {

    /**
     * The CpuArchitecture for Fargate Runtime Platform.
     * <p>
     * Default: - Undefined.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.CpuArchitecture getCpuArchitecture() {
        return null;
    }

    /**
     * The operating system for Fargate Runtime Platform.
     * <p>
     * Default: - Undefined.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.OperatingSystemFamily getOperatingSystemFamily() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link RuntimePlatform}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RuntimePlatform}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RuntimePlatform> {
        software.amazon.awscdk.services.ecs.CpuArchitecture cpuArchitecture;
        software.amazon.awscdk.services.ecs.OperatingSystemFamily operatingSystemFamily;

        /**
         * Sets the value of {@link RuntimePlatform#getCpuArchitecture}
         * @param cpuArchitecture The CpuArchitecture for Fargate Runtime Platform.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cpuArchitecture(software.amazon.awscdk.services.ecs.CpuArchitecture cpuArchitecture) {
            this.cpuArchitecture = cpuArchitecture;
            return this;
        }

        /**
         * Sets the value of {@link RuntimePlatform#getOperatingSystemFamily}
         * @param operatingSystemFamily The operating system for Fargate Runtime Platform.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder operatingSystemFamily(software.amazon.awscdk.services.ecs.OperatingSystemFamily operatingSystemFamily) {
            this.operatingSystemFamily = operatingSystemFamily;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RuntimePlatform}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RuntimePlatform build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RuntimePlatform}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuntimePlatform {
        private final software.amazon.awscdk.services.ecs.CpuArchitecture cpuArchitecture;
        private final software.amazon.awscdk.services.ecs.OperatingSystemFamily operatingSystemFamily;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cpuArchitecture = software.amazon.jsii.Kernel.get(this, "cpuArchitecture", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.CpuArchitecture.class));
            this.operatingSystemFamily = software.amazon.jsii.Kernel.get(this, "operatingSystemFamily", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.OperatingSystemFamily.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cpuArchitecture = builder.cpuArchitecture;
            this.operatingSystemFamily = builder.operatingSystemFamily;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.CpuArchitecture getCpuArchitecture() {
            return this.cpuArchitecture;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.OperatingSystemFamily getOperatingSystemFamily() {
            return this.operatingSystemFamily;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCpuArchitecture() != null) {
                data.set("cpuArchitecture", om.valueToTree(this.getCpuArchitecture()));
            }
            if (this.getOperatingSystemFamily() != null) {
                data.set("operatingSystemFamily", om.valueToTree(this.getOperatingSystemFamily()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.RuntimePlatform"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RuntimePlatform.Jsii$Proxy that = (RuntimePlatform.Jsii$Proxy) o;

            if (this.cpuArchitecture != null ? !this.cpuArchitecture.equals(that.cpuArchitecture) : that.cpuArchitecture != null) return false;
            return this.operatingSystemFamily != null ? this.operatingSystemFamily.equals(that.operatingSystemFamily) : that.operatingSystemFamily == null;
        }

        @Override
        public final int hashCode() {
            int result = this.cpuArchitecture != null ? this.cpuArchitecture.hashCode() : 0;
            result = 31 * result + (this.operatingSystemFamily != null ? this.operatingSystemFamily.hashCode() : 0);
            return result;
        }
    }
}
