package software.amazon.awscdk.services.ecs.patterns;

/**
 * The base class for QueueProcessingEc2Service and QueueProcessingFargateService services.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:24:57.896Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs_patterns.QueueProcessingServiceBase")
public abstract class QueueProcessingServiceBase extends software.constructs.Construct {

    protected QueueProcessingServiceBase(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected QueueProcessingServiceBase(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Constructs a new instance of the QueueProcessingServiceBase class.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected QueueProcessingServiceBase(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.patterns.QueueProcessingServiceBaseProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Configure autoscaling based off of CPU utilization as well as the number of messages visible in the SQS queue.
     * <p>
     * @param service the ECS/Fargate service for which to apply the autoscaling rules to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void configureAutoscalingForService(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.BaseService service) {
        software.amazon.jsii.Kernel.call(this, "configureAutoscalingForService", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(service, "service is required") });
    }

    /**
     * Returns the default cluster.
     * <p>
     * @param scope This parameter is required.
     * @param vpc
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.Cluster getDefaultCluster(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IVpc vpc) {
        return software.amazon.jsii.Kernel.call(this, "getDefaultCluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.Cluster.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), vpc });
    }

    /**
     * Returns the default cluster.
     * <p>
     * @param scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.Cluster getDefaultCluster(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope) {
        return software.amazon.jsii.Kernel.call(this, "getDefaultCluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.Cluster.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
    }

    /**
     * Grant SQS permissions to an ECS service.
     * <p>
     * @param service the ECS/Fargate service to which to grant SQS permissions. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected void grantPermissionsToService(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.BaseService service) {
        software.amazon.jsii.Kernel.call(this, "grantPermissionsToService", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(service, "service is required") });
    }

    /**
     * The cluster where your service will be deployed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ICluster getCluster() {
        return software.amazon.jsii.Kernel.get(this, "cluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ICluster.class));
    }

    /**
     * Environment variables that will include the queue name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The maximum number of instances for autoscaling to scale up to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getMaxCapacity() {
        return software.amazon.jsii.Kernel.get(this, "maxCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The minimum number of instances for autoscaling to scale down to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getMinCapacity() {
        return software.amazon.jsii.Kernel.get(this, "minCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The scaling interval for autoscaling based off an SQS Queue size.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.applicationautoscaling.ScalingInterval> getScalingSteps() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "scalingSteps", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.applicationautoscaling.ScalingInterval.class))));
    }

    /**
     * The SQS queue that the service will process from.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sqs.IQueue getSqsQueue() {
        return software.amazon.jsii.Kernel.get(this, "sqsQueue", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sqs.IQueue.class));
    }

    /**
     * The dead letter queue for the primary SQS queue.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sqs.IQueue getDeadLetterQueue() {
        return software.amazon.jsii.Kernel.get(this, "deadLetterQueue", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sqs.IQueue.class));
    }

    /**
     * The AwsLogDriver to use for logging if logging is enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.LogDriver getLogDriver() {
        return software.amazon.jsii.Kernel.get(this, "logDriver", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.LogDriver.class));
    }

    /**
     * The secret environment variables.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret> getSecrets() {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret>)(software.amazon.jsii.Kernel.get(this, "secrets", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.Secret.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.ecs.patterns.QueueProcessingServiceBase implements software.constructs.IConstruct.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }
    }
}
