package software.amazon.awscdk.services.ecs.patterns;

/**
 * The properties for the base ScheduledEc2Task or ScheduledFargateTask task.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.applicationautoscaling.*;
 * import software.amazon.awscdk.services.ec2.*;
 * import software.amazon.awscdk.services.ecs.*;
 * import software.amazon.awscdk.services.ecs.patterns.*;
 * Cluster cluster;
 * Schedule schedule;
 * SecurityGroup securityGroup;
 * Subnet subnet;
 * SubnetFilter subnetFilter;
 * Vpc vpc;
 * ScheduledTaskBaseProps scheduledTaskBaseProps = ScheduledTaskBaseProps.builder()
 *         .schedule(schedule)
 *         // the properties below are optional
 *         .cluster(cluster)
 *         .desiredTaskCount(123)
 *         .enabled(false)
 *         .propagateTags(PropagatedTagSource.SERVICE)
 *         .ruleName("ruleName")
 *         .securityGroups(List.of(securityGroup))
 *         .subnetSelection(SubnetSelection.builder()
 *                 .availabilityZones(List.of("availabilityZones"))
 *                 .onePerAz(false)
 *                 .subnetFilters(List.of(subnetFilter))
 *                 .subnetGroupName("subnetGroupName")
 *                 .subnets(List.of(subnet))
 *                 .subnetType(SubnetType.PRIVATE_ISOLATED)
 *                 .build())
 *         .tags(List.of(Tag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .vpc(vpc)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:24:57.916Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs_patterns.ScheduledTaskBaseProps")
@software.amazon.jsii.Jsii.Proxy(ScheduledTaskBaseProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ScheduledTaskBaseProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The schedule or rate (frequency) that determines when CloudWatch Events runs the rule.
     * <p>
     * For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html">Schedule Expression Syntax for Rules</a>
     * in the Amazon CloudWatch User Guide.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.applicationautoscaling.Schedule getSchedule();

    /**
     * The name of the cluster that hosts the service.
     * <p>
     * If a cluster is specified, the vpc construct should be omitted. Alternatively, you can omit both cluster and vpc.
     * <p>
     * Default: - create a new cluster; if both cluster and vpc are omitted, a new VPC will be created for you.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.ICluster getCluster() {
        return null;
    }

    /**
     * The desired number of instantiations of the task definition to keep running on the service.
     * <p>
     * Default: 1
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getDesiredTaskCount() {
        return null;
    }

    /**
     * Indicates whether the rule is enabled.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnabled() {
        return null;
    }

    /**
     * Specifies whether to propagate the tags from the task definition to the task.
     * <p>
     * If no value is specified, the tags are not propagated.
     * <p>
     * Default: - Tags will not be propagated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.PropagatedTagSource getPropagateTags() {
        return null;
    }

    /**
     * A name for the rule.
     * <p>
     * Default: - AWS CloudFormation generates a unique physical ID and uses that ID
     * for the rule name. For more information, see [Name Type](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRuleName() {
        return null;
    }

    /**
     * Existing security groups to use for your service.
     * <p>
     * Default: - a new security group will be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
        return null;
    }

    /**
     * In what subnets to place the task's ENIs.
     * <p>
     * (Only applicable in case the TaskDefinition is configured for AwsVpc networking)
     * <p>
     * Default: Private subnets
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection getSubnetSelection() {
        return null;
    }

    /**
     * The metadata that you apply to the task to help you categorize and organize them.
     * <p>
     * Each tag consists of a key and an optional value, both of which you define.
     * <p>
     * Default: - No tags are applied to the task
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.events.targets.Tag> getTags() {
        return null;
    }

    /**
     * The VPC where the container instances will be launched or the elastic network interfaces (ENIs) will be deployed.
     * <p>
     * If a vpc is specified, the cluster construct should be omitted. Alternatively, you can omit both vpc and cluster.
     * <p>
     * Default: - uses the VPC defined in the cluster or creates a new VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IVpc getVpc() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ScheduledTaskBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ScheduledTaskBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ScheduledTaskBaseProps> {
        software.amazon.awscdk.services.applicationautoscaling.Schedule schedule;
        software.amazon.awscdk.services.ecs.ICluster cluster;
        java.lang.Number desiredTaskCount;
        java.lang.Boolean enabled;
        software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTags;
        java.lang.String ruleName;
        java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection;
        java.util.List<software.amazon.awscdk.services.events.targets.Tag> tags;
        software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Sets the value of {@link ScheduledTaskBaseProps#getSchedule}
         * @param schedule The schedule or rate (frequency) that determines when CloudWatch Events runs the rule. This parameter is required.
         *                 For more information, see
         *                 <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html">Schedule Expression Syntax for Rules</a>
         *                 in the Amazon CloudWatch User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(software.amazon.awscdk.services.applicationautoscaling.Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        /**
         * Sets the value of {@link ScheduledTaskBaseProps#getCluster}
         * @param cluster The name of the cluster that hosts the service.
         *                If a cluster is specified, the vpc construct should be omitted. Alternatively, you can omit both cluster and vpc.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(software.amazon.awscdk.services.ecs.ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        /**
         * Sets the value of {@link ScheduledTaskBaseProps#getDesiredTaskCount}
         * @param desiredTaskCount The desired number of instantiations of the task definition to keep running on the service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder desiredTaskCount(java.lang.Number desiredTaskCount) {
            this.desiredTaskCount = desiredTaskCount;
            return this;
        }

        /**
         * Sets the value of {@link ScheduledTaskBaseProps#getEnabled}
         * @param enabled Indicates whether the rule is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link ScheduledTaskBaseProps#getPropagateTags}
         * @param propagateTags Specifies whether to propagate the tags from the task definition to the task.
         *                      If no value is specified, the tags are not propagated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propagateTags(software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTags) {
            this.propagateTags = propagateTags;
            return this;
        }

        /**
         * Sets the value of {@link ScheduledTaskBaseProps#getRuleName}
         * @param ruleName A name for the rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleName(java.lang.String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        /**
         * Sets the value of {@link ScheduledTaskBaseProps#getSecurityGroups}
         * @param securityGroups Existing security groups to use for your service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder securityGroups(java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)securityGroups;
            return this;
        }

        /**
         * Sets the value of {@link ScheduledTaskBaseProps#getSubnetSelection}
         * @param subnetSelection In what subnets to place the task's ENIs.
         *                        (Only applicable in case the TaskDefinition is configured for AwsVpc networking)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetSelection(software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection) {
            this.subnetSelection = subnetSelection;
            return this;
        }

        /**
         * Sets the value of {@link ScheduledTaskBaseProps#getTags}
         * @param tags The metadata that you apply to the task to help you categorize and organize them.
         *             Each tag consists of a key and an optional value, both of which you define.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.services.events.targets.Tag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.services.events.targets.Tag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link ScheduledTaskBaseProps#getVpc}
         * @param vpc The VPC where the container instances will be launched or the elastic network interfaces (ENIs) will be deployed.
         *            If a vpc is specified, the cluster construct should be omitted. Alternatively, you can omit both vpc and cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ScheduledTaskBaseProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ScheduledTaskBaseProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ScheduledTaskBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScheduledTaskBaseProps {
        private final software.amazon.awscdk.services.applicationautoscaling.Schedule schedule;
        private final software.amazon.awscdk.services.ecs.ICluster cluster;
        private final java.lang.Number desiredTaskCount;
        private final java.lang.Boolean enabled;
        private final software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTags;
        private final java.lang.String ruleName;
        private final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        private final software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection;
        private final java.util.List<software.amazon.awscdk.services.events.targets.Tag> tags;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.schedule = software.amazon.jsii.Kernel.get(this, "schedule", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.applicationautoscaling.Schedule.class));
            this.cluster = software.amazon.jsii.Kernel.get(this, "cluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ICluster.class));
            this.desiredTaskCount = software.amazon.jsii.Kernel.get(this, "desiredTaskCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.propagateTags = software.amazon.jsii.Kernel.get(this, "propagateTags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.PropagatedTagSource.class));
            this.ruleName = software.amazon.jsii.Kernel.get(this, "ruleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class)));
            this.subnetSelection = software.amazon.jsii.Kernel.get(this, "subnetSelection", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.targets.Tag.class)));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.schedule = java.util.Objects.requireNonNull(builder.schedule, "schedule is required");
            this.cluster = builder.cluster;
            this.desiredTaskCount = builder.desiredTaskCount;
            this.enabled = builder.enabled;
            this.propagateTags = builder.propagateTags;
            this.ruleName = builder.ruleName;
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)builder.securityGroups;
            this.subnetSelection = builder.subnetSelection;
            this.tags = (java.util.List<software.amazon.awscdk.services.events.targets.Tag>)builder.tags;
            this.vpc = builder.vpc;
        }

        @Override
        public final software.amazon.awscdk.services.applicationautoscaling.Schedule getSchedule() {
            return this.schedule;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.ICluster getCluster() {
            return this.cluster;
        }

        @Override
        public final java.lang.Number getDesiredTaskCount() {
            return this.desiredTaskCount;
        }

        @Override
        public final java.lang.Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.PropagatedTagSource getPropagateTags() {
            return this.propagateTags;
        }

        @Override
        public final java.lang.String getRuleName() {
            return this.ruleName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SubnetSelection getSubnetSelection() {
            return this.subnetSelection;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.events.targets.Tag> getTags() {
            return this.tags;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("schedule", om.valueToTree(this.getSchedule()));
            if (this.getCluster() != null) {
                data.set("cluster", om.valueToTree(this.getCluster()));
            }
            if (this.getDesiredTaskCount() != null) {
                data.set("desiredTaskCount", om.valueToTree(this.getDesiredTaskCount()));
            }
            if (this.getEnabled() != null) {
                data.set("enabled", om.valueToTree(this.getEnabled()));
            }
            if (this.getPropagateTags() != null) {
                data.set("propagateTags", om.valueToTree(this.getPropagateTags()));
            }
            if (this.getRuleName() != null) {
                data.set("ruleName", om.valueToTree(this.getRuleName()));
            }
            if (this.getSecurityGroups() != null) {
                data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            }
            if (this.getSubnetSelection() != null) {
                data.set("subnetSelection", om.valueToTree(this.getSubnetSelection()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getVpc() != null) {
                data.set("vpc", om.valueToTree(this.getVpc()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs_patterns.ScheduledTaskBaseProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ScheduledTaskBaseProps.Jsii$Proxy that = (ScheduledTaskBaseProps.Jsii$Proxy) o;

            if (!schedule.equals(that.schedule)) return false;
            if (this.cluster != null ? !this.cluster.equals(that.cluster) : that.cluster != null) return false;
            if (this.desiredTaskCount != null ? !this.desiredTaskCount.equals(that.desiredTaskCount) : that.desiredTaskCount != null) return false;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
            if (this.propagateTags != null ? !this.propagateTags.equals(that.propagateTags) : that.propagateTags != null) return false;
            if (this.ruleName != null ? !this.ruleName.equals(that.ruleName) : that.ruleName != null) return false;
            if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) return false;
            if (this.subnetSelection != null ? !this.subnetSelection.equals(that.subnetSelection) : that.subnetSelection != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.vpc != null ? this.vpc.equals(that.vpc) : that.vpc == null;
        }

        @Override
        public final int hashCode() {
            int result = this.schedule.hashCode();
            result = 31 * result + (this.cluster != null ? this.cluster.hashCode() : 0);
            result = 31 * result + (this.desiredTaskCount != null ? this.desiredTaskCount.hashCode() : 0);
            result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
            result = 31 * result + (this.propagateTags != null ? this.propagateTags.hashCode() : 0);
            result = 31 * result + (this.ruleName != null ? this.ruleName.hashCode() : 0);
            result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
            result = 31 * result + (this.subnetSelection != null ? this.subnetSelection.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
            return result;
        }
    }
}
