package software.amazon.awscdk.services.efs;

/**
 * Properties for configuring ReplicationConfiguration to replicate to an existing file system.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.efs.*;
 * FileSystem fileSystem;
 * ExistingFileSystemProps existingFileSystemProps = ExistingFileSystemProps.builder()
 *         .destinationFileSystem(fileSystem)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:24:57.936Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_efs.ExistingFileSystemProps")
@software.amazon.jsii.Jsii.Proxy(ExistingFileSystemProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ExistingFileSystemProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The existing destination file system for the replication.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.efs.IFileSystem getDestinationFileSystem();

    /**
     * @return a {@link Builder} of {@link ExistingFileSystemProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ExistingFileSystemProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ExistingFileSystemProps> {
        software.amazon.awscdk.services.efs.IFileSystem destinationFileSystem;

        /**
         * Sets the value of {@link ExistingFileSystemProps#getDestinationFileSystem}
         * @param destinationFileSystem The existing destination file system for the replication. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationFileSystem(software.amazon.awscdk.services.efs.IFileSystem destinationFileSystem) {
            this.destinationFileSystem = destinationFileSystem;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ExistingFileSystemProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ExistingFileSystemProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ExistingFileSystemProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExistingFileSystemProps {
        private final software.amazon.awscdk.services.efs.IFileSystem destinationFileSystem;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.destinationFileSystem = software.amazon.jsii.Kernel.get(this, "destinationFileSystem", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.efs.IFileSystem.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.destinationFileSystem = java.util.Objects.requireNonNull(builder.destinationFileSystem, "destinationFileSystem is required");
        }

        @Override
        public final software.amazon.awscdk.services.efs.IFileSystem getDestinationFileSystem() {
            return this.destinationFileSystem;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("destinationFileSystem", om.valueToTree(this.getDestinationFileSystem()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_efs.ExistingFileSystemProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ExistingFileSystemProps.Jsii$Proxy that = (ExistingFileSystemProps.Jsii$Proxy) o;

            return this.destinationFileSystem.equals(that.destinationFileSystem);
        }

        @Override
        public final int hashCode() {
            int result = this.destinationFileSystem.hashCode();
            return result;
        }
    }
}
