package software.amazon.awscdk.services.efs;

/**
 * EFS Out Of Infrequent Access Policy, if a file is accessed given times, it will move back to primary storage class.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * FileSystem fileSystem = FileSystem.Builder.create(this, "MyEfsFileSystem")
 *         .vpc(new Vpc(this, "VPC"))
 *         .lifecyclePolicy(LifecyclePolicy.AFTER_14_DAYS) // files are not transitioned to infrequent access (IA) storage by default
 *         .performanceMode(PerformanceMode.GENERAL_PURPOSE) // default
 *         .outOfInfrequentAccessPolicy(OutOfInfrequentAccessPolicy.AFTER_1_ACCESS) // files are not transitioned back from (infrequent access) IA to primary storage by default
 *         .transitionToArchivePolicy(LifecyclePolicy.AFTER_14_DAYS) // files are not transitioned to Archive by default
 *         .replicationOverwriteProtection(ReplicationOverwriteProtection.ENABLED)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-lifecyclepolicy.html#cfn-efs-filesystem-lifecyclepolicy-transitiontoprimarystorageclass">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-lifecyclepolicy.html#cfn-efs-filesystem-lifecyclepolicy-transitiontoprimarystorageclass</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:24:57.955Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_efs.OutOfInfrequentAccessPolicy")
public enum OutOfInfrequentAccessPolicy {
    /**
     * After 1 access.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AFTER_1_ACCESS,
}
