package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Specifies a listener rule.
 * <p>
 * The listener must be associated with an Application Load Balancer. Each rule consists of a priority, one or more actions, and one or more conditions.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-limits.html">Quotas for your Application Load Balancers</a> in the <em>User Guide for Application Load Balancers</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
 * CfnListenerRule cfnListenerRule = CfnListenerRule.Builder.create(this, "MyCfnListenerRule")
 *         .actions(List.of(ActionProperty.builder()
 *                 .type("type")
 *                 // the properties below are optional
 *                 .authenticateCognitoConfig(AuthenticateCognitoConfigProperty.builder()
 *                         .userPoolArn("userPoolArn")
 *                         .userPoolClientId("userPoolClientId")
 *                         .userPoolDomain("userPoolDomain")
 *                         // the properties below are optional
 *                         .authenticationRequestExtraParams(Map.of(
 *                                 "authenticationRequestExtraParamsKey", "authenticationRequestExtraParams"))
 *                         .onUnauthenticatedRequest("onUnauthenticatedRequest")
 *                         .scope("scope")
 *                         .sessionCookieName("sessionCookieName")
 *                         .sessionTimeout(123)
 *                         .build())
 *                 .authenticateOidcConfig(AuthenticateOidcConfigProperty.builder()
 *                         .authorizationEndpoint("authorizationEndpoint")
 *                         .clientId("clientId")
 *                         .issuer("issuer")
 *                         .tokenEndpoint("tokenEndpoint")
 *                         .userInfoEndpoint("userInfoEndpoint")
 *                         // the properties below are optional
 *                         .authenticationRequestExtraParams(Map.of(
 *                                 "authenticationRequestExtraParamsKey", "authenticationRequestExtraParams"))
 *                         .clientSecret("clientSecret")
 *                         .onUnauthenticatedRequest("onUnauthenticatedRequest")
 *                         .scope("scope")
 *                         .sessionCookieName("sessionCookieName")
 *                         .sessionTimeout(123)
 *                         .useExistingClientSecret(false)
 *                         .build())
 *                 .fixedResponseConfig(FixedResponseConfigProperty.builder()
 *                         .statusCode("statusCode")
 *                         // the properties below are optional
 *                         .contentType("contentType")
 *                         .messageBody("messageBody")
 *                         .build())
 *                 .forwardConfig(ForwardConfigProperty.builder()
 *                         .targetGroups(List.of(TargetGroupTupleProperty.builder()
 *                                 .targetGroupArn("targetGroupArn")
 *                                 .weight(123)
 *                                 .build()))
 *                         .targetGroupStickinessConfig(TargetGroupStickinessConfigProperty.builder()
 *                                 .durationSeconds(123)
 *                                 .enabled(false)
 *                                 .build())
 *                         .build())
 *                 .order(123)
 *                 .redirectConfig(RedirectConfigProperty.builder()
 *                         .statusCode("statusCode")
 *                         // the properties below are optional
 *                         .host("host")
 *                         .path("path")
 *                         .port("port")
 *                         .protocol("protocol")
 *                         .query("query")
 *                         .build())
 *                 .targetGroupArn("targetGroupArn")
 *                 .build()))
 *         .conditions(List.of(RuleConditionProperty.builder()
 *                 .field("field")
 *                 .hostHeaderConfig(HostHeaderConfigProperty.builder()
 *                         .values(List.of("values"))
 *                         .build())
 *                 .httpHeaderConfig(HttpHeaderConfigProperty.builder()
 *                         .httpHeaderName("httpHeaderName")
 *                         .values(List.of("values"))
 *                         .build())
 *                 .httpRequestMethodConfig(HttpRequestMethodConfigProperty.builder()
 *                         .values(List.of("values"))
 *                         .build())
 *                 .pathPatternConfig(PathPatternConfigProperty.builder()
 *                         .values(List.of("values"))
 *                         .build())
 *                 .queryStringConfig(QueryStringConfigProperty.builder()
 *                         .values(List.of(QueryStringKeyValueProperty.builder()
 *                                 .key("key")
 *                                 .value("value")
 *                                 .build()))
 *                         .build())
 *                 .sourceIpConfig(SourceIpConfigProperty.builder()
 *                         .values(List.of("values"))
 *                         .build())
 *                 .values(List.of("values"))
 *                 .build()))
 *         .priority(123)
 *         // the properties below are optional
 *         .listenerArn("listenerArn")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:24:58.301Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.CfnListenerRule")
public class CfnListenerRule extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnListenerRule(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnListenerRule(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnListenerRule(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRuleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * Indicates whether this is the default rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrIsDefault() {
        return software.amazon.jsii.Kernel.get(this, "attrIsDefault", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrRuleArn() {
        return software.amazon.jsii.Kernel.get(this, "attrRuleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The actions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getActions() {
        return software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The actions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setActions(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "actions", java.util.Objects.requireNonNull(value, "actions is required"));
    }

    /**
     * The actions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setActions(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.ActionProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.ActionProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "actions", java.util.Objects.requireNonNull(value, "actions is required"));
    }

    /**
     * The conditions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getConditions() {
        return software.amazon.jsii.Kernel.get(this, "conditions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The conditions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConditions(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "conditions", java.util.Objects.requireNonNull(value, "conditions is required"));
    }

    /**
     * The conditions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConditions(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.RuleConditionProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.RuleConditionProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "conditions", java.util.Objects.requireNonNull(value, "conditions is required"));
    }

    /**
     * The rule priority.
     * <p>
     * A listener can't have multiple rules with the same priority.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getPriority() {
        return software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The rule priority.
     * <p>
     * A listener can't have multiple rules with the same priority.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPriority(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "priority", java.util.Objects.requireNonNull(value, "priority is required"));
    }

    /**
     * The Amazon Resource Name (ARN) of the listener.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getListenerArn() {
        return software.amazon.jsii.Kernel.get(this, "listenerArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the listener.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setListenerArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "listenerArn", value);
    }
    /**
     * Specifies an action for a listener rule.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
     * ActionProperty actionProperty = ActionProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .authenticateCognitoConfig(AuthenticateCognitoConfigProperty.builder()
     *                 .userPoolArn("userPoolArn")
     *                 .userPoolClientId("userPoolClientId")
     *                 .userPoolDomain("userPoolDomain")
     *                 // the properties below are optional
     *                 .authenticationRequestExtraParams(Map.of(
     *                         "authenticationRequestExtraParamsKey", "authenticationRequestExtraParams"))
     *                 .onUnauthenticatedRequest("onUnauthenticatedRequest")
     *                 .scope("scope")
     *                 .sessionCookieName("sessionCookieName")
     *                 .sessionTimeout(123)
     *                 .build())
     *         .authenticateOidcConfig(AuthenticateOidcConfigProperty.builder()
     *                 .authorizationEndpoint("authorizationEndpoint")
     *                 .clientId("clientId")
     *                 .issuer("issuer")
     *                 .tokenEndpoint("tokenEndpoint")
     *                 .userInfoEndpoint("userInfoEndpoint")
     *                 // the properties below are optional
     *                 .authenticationRequestExtraParams(Map.of(
     *                         "authenticationRequestExtraParamsKey", "authenticationRequestExtraParams"))
     *                 .clientSecret("clientSecret")
     *                 .onUnauthenticatedRequest("onUnauthenticatedRequest")
     *                 .scope("scope")
     *                 .sessionCookieName("sessionCookieName")
     *                 .sessionTimeout(123)
     *                 .useExistingClientSecret(false)
     *                 .build())
     *         .fixedResponseConfig(FixedResponseConfigProperty.builder()
     *                 .statusCode("statusCode")
     *                 // the properties below are optional
     *                 .contentType("contentType")
     *                 .messageBody("messageBody")
     *                 .build())
     *         .forwardConfig(ForwardConfigProperty.builder()
     *                 .targetGroups(List.of(TargetGroupTupleProperty.builder()
     *                         .targetGroupArn("targetGroupArn")
     *                         .weight(123)
     *                         .build()))
     *                 .targetGroupStickinessConfig(TargetGroupStickinessConfigProperty.builder()
     *                         .durationSeconds(123)
     *                         .enabled(false)
     *                         .build())
     *                 .build())
     *         .order(123)
     *         .redirectConfig(RedirectConfigProperty.builder()
     *                 .statusCode("statusCode")
     *                 // the properties below are optional
     *                 .host("host")
     *                 .path("path")
     *                 .port("port")
     *                 .protocol("protocol")
     *                 .query("query")
     *                 .build())
     *         .targetGroupArn("targetGroupArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-action.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-action.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.CfnListenerRule.ActionProperty")
    @software.amazon.jsii.Jsii.Proxy(ActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-action.html#cfn-elasticloadbalancingv2-listenerrule-action-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-action.html#cfn-elasticloadbalancingv2-listenerrule-action-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * [HTTPS listeners] Information for using Amazon Cognito to authenticate users.
         * <p>
         * Specify only when <code>Type</code> is <code>authenticate-cognito</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-action.html#cfn-elasticloadbalancingv2-listenerrule-action-authenticatecognitoconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-action.html#cfn-elasticloadbalancingv2-listenerrule-action-authenticatecognitoconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAuthenticateCognitoConfig() {
            return null;
        }

        /**
         * [HTTPS listeners] Information about an identity provider that is compliant with OpenID Connect (OIDC).
         * <p>
         * Specify only when <code>Type</code> is <code>authenticate-oidc</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-action.html#cfn-elasticloadbalancingv2-listenerrule-action-authenticateoidcconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-action.html#cfn-elasticloadbalancingv2-listenerrule-action-authenticateoidcconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAuthenticateOidcConfig() {
            return null;
        }

        /**
         * [Application Load Balancer] Information for creating an action that returns a custom HTTP response.
         * <p>
         * Specify only when <code>Type</code> is <code>fixed-response</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-action.html#cfn-elasticloadbalancingv2-listenerrule-action-fixedresponseconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-action.html#cfn-elasticloadbalancingv2-listenerrule-action-fixedresponseconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFixedResponseConfig() {
            return null;
        }

        /**
         * Information for creating an action that distributes requests among one or more target groups.
         * <p>
         * For Network Load Balancers, you can specify a single target group. Specify only when <code>Type</code> is <code>forward</code> . If you specify both <code>ForwardConfig</code> and <code>TargetGroupArn</code> , you can specify only one target group using <code>ForwardConfig</code> and it must be the same target group specified in <code>TargetGroupArn</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-action.html#cfn-elasticloadbalancingv2-listenerrule-action-forwardconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-action.html#cfn-elasticloadbalancingv2-listenerrule-action-forwardconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getForwardConfig() {
            return null;
        }

        /**
         * The order for the action.
         * <p>
         * This value is required for rules with multiple actions. The action with the lowest value for order is performed first.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-action.html#cfn-elasticloadbalancingv2-listenerrule-action-order">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-action.html#cfn-elasticloadbalancingv2-listenerrule-action-order</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getOrder() {
            return null;
        }

        /**
         * [Application Load Balancer] Information for creating a redirect action.
         * <p>
         * Specify only when <code>Type</code> is <code>redirect</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-action.html#cfn-elasticloadbalancingv2-listenerrule-action-redirectconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-action.html#cfn-elasticloadbalancingv2-listenerrule-action-redirectconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRedirectConfig() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the target group.
         * <p>
         * Specify only when <code>Type</code> is <code>forward</code> and you want to route to a single target group. To route to one or more target groups, use <code>ForwardConfig</code> instead.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-action.html#cfn-elasticloadbalancingv2-listenerrule-action-targetgrouparn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-action.html#cfn-elasticloadbalancingv2-listenerrule-action-targetgrouparn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTargetGroupArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ActionProperty> {
            java.lang.String type;
            java.lang.Object authenticateCognitoConfig;
            java.lang.Object authenticateOidcConfig;
            java.lang.Object fixedResponseConfig;
            java.lang.Object forwardConfig;
            java.lang.Number order;
            java.lang.Object redirectConfig;
            java.lang.String targetGroupArn;

            /**
             * Sets the value of {@link ActionProperty#getType}
             * @param type The type of action. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getAuthenticateCognitoConfig}
             * @param authenticateCognitoConfig [HTTPS listeners] Information for using Amazon Cognito to authenticate users.
             *                                  Specify only when <code>Type</code> is <code>authenticate-cognito</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authenticateCognitoConfig(software.amazon.awscdk.IResolvable authenticateCognitoConfig) {
                this.authenticateCognitoConfig = authenticateCognitoConfig;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getAuthenticateCognitoConfig}
             * @param authenticateCognitoConfig [HTTPS listeners] Information for using Amazon Cognito to authenticate users.
             *                                  Specify only when <code>Type</code> is <code>authenticate-cognito</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authenticateCognitoConfig(software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.AuthenticateCognitoConfigProperty authenticateCognitoConfig) {
                this.authenticateCognitoConfig = authenticateCognitoConfig;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getAuthenticateOidcConfig}
             * @param authenticateOidcConfig [HTTPS listeners] Information about an identity provider that is compliant with OpenID Connect (OIDC).
             *                               Specify only when <code>Type</code> is <code>authenticate-oidc</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authenticateOidcConfig(software.amazon.awscdk.IResolvable authenticateOidcConfig) {
                this.authenticateOidcConfig = authenticateOidcConfig;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getAuthenticateOidcConfig}
             * @param authenticateOidcConfig [HTTPS listeners] Information about an identity provider that is compliant with OpenID Connect (OIDC).
             *                               Specify only when <code>Type</code> is <code>authenticate-oidc</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authenticateOidcConfig(software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.AuthenticateOidcConfigProperty authenticateOidcConfig) {
                this.authenticateOidcConfig = authenticateOidcConfig;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getFixedResponseConfig}
             * @param fixedResponseConfig [Application Load Balancer] Information for creating an action that returns a custom HTTP response.
             *                            Specify only when <code>Type</code> is <code>fixed-response</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fixedResponseConfig(software.amazon.awscdk.IResolvable fixedResponseConfig) {
                this.fixedResponseConfig = fixedResponseConfig;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getFixedResponseConfig}
             * @param fixedResponseConfig [Application Load Balancer] Information for creating an action that returns a custom HTTP response.
             *                            Specify only when <code>Type</code> is <code>fixed-response</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fixedResponseConfig(software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.FixedResponseConfigProperty fixedResponseConfig) {
                this.fixedResponseConfig = fixedResponseConfig;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getForwardConfig}
             * @param forwardConfig Information for creating an action that distributes requests among one or more target groups.
             *                      For Network Load Balancers, you can specify a single target group. Specify only when <code>Type</code> is <code>forward</code> . If you specify both <code>ForwardConfig</code> and <code>TargetGroupArn</code> , you can specify only one target group using <code>ForwardConfig</code> and it must be the same target group specified in <code>TargetGroupArn</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder forwardConfig(software.amazon.awscdk.IResolvable forwardConfig) {
                this.forwardConfig = forwardConfig;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getForwardConfig}
             * @param forwardConfig Information for creating an action that distributes requests among one or more target groups.
             *                      For Network Load Balancers, you can specify a single target group. Specify only when <code>Type</code> is <code>forward</code> . If you specify both <code>ForwardConfig</code> and <code>TargetGroupArn</code> , you can specify only one target group using <code>ForwardConfig</code> and it must be the same target group specified in <code>TargetGroupArn</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder forwardConfig(software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.ForwardConfigProperty forwardConfig) {
                this.forwardConfig = forwardConfig;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getOrder}
             * @param order The order for the action.
             *              This value is required for rules with multiple actions. The action with the lowest value for order is performed first.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder order(java.lang.Number order) {
                this.order = order;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getRedirectConfig}
             * @param redirectConfig [Application Load Balancer] Information for creating a redirect action.
             *                       Specify only when <code>Type</code> is <code>redirect</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redirectConfig(software.amazon.awscdk.IResolvable redirectConfig) {
                this.redirectConfig = redirectConfig;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getRedirectConfig}
             * @param redirectConfig [Application Load Balancer] Information for creating a redirect action.
             *                       Specify only when <code>Type</code> is <code>redirect</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redirectConfig(software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.RedirectConfigProperty redirectConfig) {
                this.redirectConfig = redirectConfig;
                return this;
            }

            /**
             * Sets the value of {@link ActionProperty#getTargetGroupArn}
             * @param targetGroupArn The Amazon Resource Name (ARN) of the target group.
             *                       Specify only when <code>Type</code> is <code>forward</code> and you want to route to a single target group. To route to one or more target groups, use <code>ForwardConfig</code> instead.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetGroupArn(java.lang.String targetGroupArn) {
                this.targetGroupArn = targetGroupArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ActionProperty {
            private final java.lang.String type;
            private final java.lang.Object authenticateCognitoConfig;
            private final java.lang.Object authenticateOidcConfig;
            private final java.lang.Object fixedResponseConfig;
            private final java.lang.Object forwardConfig;
            private final java.lang.Number order;
            private final java.lang.Object redirectConfig;
            private final java.lang.String targetGroupArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.authenticateCognitoConfig = software.amazon.jsii.Kernel.get(this, "authenticateCognitoConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.authenticateOidcConfig = software.amazon.jsii.Kernel.get(this, "authenticateOidcConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.fixedResponseConfig = software.amazon.jsii.Kernel.get(this, "fixedResponseConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.forwardConfig = software.amazon.jsii.Kernel.get(this, "forwardConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.order = software.amazon.jsii.Kernel.get(this, "order", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.redirectConfig = software.amazon.jsii.Kernel.get(this, "redirectConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.targetGroupArn = software.amazon.jsii.Kernel.get(this, "targetGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.authenticateCognitoConfig = builder.authenticateCognitoConfig;
                this.authenticateOidcConfig = builder.authenticateOidcConfig;
                this.fixedResponseConfig = builder.fixedResponseConfig;
                this.forwardConfig = builder.forwardConfig;
                this.order = builder.order;
                this.redirectConfig = builder.redirectConfig;
                this.targetGroupArn = builder.targetGroupArn;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Object getAuthenticateCognitoConfig() {
                return this.authenticateCognitoConfig;
            }

            @Override
            public final java.lang.Object getAuthenticateOidcConfig() {
                return this.authenticateOidcConfig;
            }

            @Override
            public final java.lang.Object getFixedResponseConfig() {
                return this.fixedResponseConfig;
            }

            @Override
            public final java.lang.Object getForwardConfig() {
                return this.forwardConfig;
            }

            @Override
            public final java.lang.Number getOrder() {
                return this.order;
            }

            @Override
            public final java.lang.Object getRedirectConfig() {
                return this.redirectConfig;
            }

            @Override
            public final java.lang.String getTargetGroupArn() {
                return this.targetGroupArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getAuthenticateCognitoConfig() != null) {
                    data.set("authenticateCognitoConfig", om.valueToTree(this.getAuthenticateCognitoConfig()));
                }
                if (this.getAuthenticateOidcConfig() != null) {
                    data.set("authenticateOidcConfig", om.valueToTree(this.getAuthenticateOidcConfig()));
                }
                if (this.getFixedResponseConfig() != null) {
                    data.set("fixedResponseConfig", om.valueToTree(this.getFixedResponseConfig()));
                }
                if (this.getForwardConfig() != null) {
                    data.set("forwardConfig", om.valueToTree(this.getForwardConfig()));
                }
                if (this.getOrder() != null) {
                    data.set("order", om.valueToTree(this.getOrder()));
                }
                if (this.getRedirectConfig() != null) {
                    data.set("redirectConfig", om.valueToTree(this.getRedirectConfig()));
                }
                if (this.getTargetGroupArn() != null) {
                    data.set("targetGroupArn", om.valueToTree(this.getTargetGroupArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticloadbalancingv2.CfnListenerRule.ActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ActionProperty.Jsii$Proxy that = (ActionProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                if (this.authenticateCognitoConfig != null ? !this.authenticateCognitoConfig.equals(that.authenticateCognitoConfig) : that.authenticateCognitoConfig != null) return false;
                if (this.authenticateOidcConfig != null ? !this.authenticateOidcConfig.equals(that.authenticateOidcConfig) : that.authenticateOidcConfig != null) return false;
                if (this.fixedResponseConfig != null ? !this.fixedResponseConfig.equals(that.fixedResponseConfig) : that.fixedResponseConfig != null) return false;
                if (this.forwardConfig != null ? !this.forwardConfig.equals(that.forwardConfig) : that.forwardConfig != null) return false;
                if (this.order != null ? !this.order.equals(that.order) : that.order != null) return false;
                if (this.redirectConfig != null ? !this.redirectConfig.equals(that.redirectConfig) : that.redirectConfig != null) return false;
                return this.targetGroupArn != null ? this.targetGroupArn.equals(that.targetGroupArn) : that.targetGroupArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.authenticateCognitoConfig != null ? this.authenticateCognitoConfig.hashCode() : 0);
                result = 31 * result + (this.authenticateOidcConfig != null ? this.authenticateOidcConfig.hashCode() : 0);
                result = 31 * result + (this.fixedResponseConfig != null ? this.fixedResponseConfig.hashCode() : 0);
                result = 31 * result + (this.forwardConfig != null ? this.forwardConfig.hashCode() : 0);
                result = 31 * result + (this.order != null ? this.order.hashCode() : 0);
                result = 31 * result + (this.redirectConfig != null ? this.redirectConfig.hashCode() : 0);
                result = 31 * result + (this.targetGroupArn != null ? this.targetGroupArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies information required when integrating with Amazon Cognito to authenticate users.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
     * AuthenticateCognitoConfigProperty authenticateCognitoConfigProperty = AuthenticateCognitoConfigProperty.builder()
     *         .userPoolArn("userPoolArn")
     *         .userPoolClientId("userPoolClientId")
     *         .userPoolDomain("userPoolDomain")
     *         // the properties below are optional
     *         .authenticationRequestExtraParams(Map.of(
     *                 "authenticationRequestExtraParamsKey", "authenticationRequestExtraParams"))
     *         .onUnauthenticatedRequest("onUnauthenticatedRequest")
     *         .scope("scope")
     *         .sessionCookieName("sessionCookieName")
     *         .sessionTimeout(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.CfnListenerRule.AuthenticateCognitoConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(AuthenticateCognitoConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AuthenticateCognitoConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the Amazon Cognito user pool.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-userpoolarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-userpoolarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUserPoolArn();

        /**
         * The ID of the Amazon Cognito user pool client.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-userpoolclientid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-userpoolclientid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUserPoolClientId();

        /**
         * The domain prefix or fully-qualified domain name of the Amazon Cognito user pool.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-userpooldomain">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-userpooldomain</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUserPoolDomain();

        /**
         * The query parameters (up to 10) to include in the redirect request to the authorization endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-authenticationrequestextraparams">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-authenticationrequestextraparams</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAuthenticationRequestExtraParams() {
            return null;
        }

        /**
         * The behavior if the user is not authenticated. The following are possible values:.
         * <p>
         * <ul>
         * <li>deny `` - Return an HTTP 401 Unauthorized error.</li>
         * <li>allow `` - Allow the request to be forwarded to the target.</li>
         * <li>authenticate `` - Redirect the request to the IdP authorization endpoint. This is the default value.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-onunauthenticatedrequest">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-onunauthenticatedrequest</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOnUnauthenticatedRequest() {
            return null;
        }

        /**
         * The set of user claims to be requested from the IdP. The default is <code>openid</code> .
         * <p>
         * To verify which scope values your IdP supports and how to separate multiple values, see the documentation for your IdP.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-scope">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-scope</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getScope() {
            return null;
        }

        /**
         * The name of the cookie used to maintain session information.
         * <p>
         * The default is AWSELBAuthSessionCookie.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-sessioncookiename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-sessioncookiename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSessionCookieName() {
            return null;
        }

        /**
         * The maximum duration of the authentication session, in seconds.
         * <p>
         * The default is 604800 seconds (7 days).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-sessiontimeout">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticatecognitoconfig-sessiontimeout</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSessionTimeout() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AuthenticateCognitoConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AuthenticateCognitoConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AuthenticateCognitoConfigProperty> {
            java.lang.String userPoolArn;
            java.lang.String userPoolClientId;
            java.lang.String userPoolDomain;
            java.lang.Object authenticationRequestExtraParams;
            java.lang.String onUnauthenticatedRequest;
            java.lang.String scope;
            java.lang.String sessionCookieName;
            java.lang.Number sessionTimeout;

            /**
             * Sets the value of {@link AuthenticateCognitoConfigProperty#getUserPoolArn}
             * @param userPoolArn The Amazon Resource Name (ARN) of the Amazon Cognito user pool. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userPoolArn(java.lang.String userPoolArn) {
                this.userPoolArn = userPoolArn;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateCognitoConfigProperty#getUserPoolClientId}
             * @param userPoolClientId The ID of the Amazon Cognito user pool client. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userPoolClientId(java.lang.String userPoolClientId) {
                this.userPoolClientId = userPoolClientId;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateCognitoConfigProperty#getUserPoolDomain}
             * @param userPoolDomain The domain prefix or fully-qualified domain name of the Amazon Cognito user pool. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userPoolDomain(java.lang.String userPoolDomain) {
                this.userPoolDomain = userPoolDomain;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateCognitoConfigProperty#getAuthenticationRequestExtraParams}
             * @param authenticationRequestExtraParams The query parameters (up to 10) to include in the redirect request to the authorization endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authenticationRequestExtraParams(java.util.Map<java.lang.String, java.lang.String> authenticationRequestExtraParams) {
                this.authenticationRequestExtraParams = authenticationRequestExtraParams;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateCognitoConfigProperty#getAuthenticationRequestExtraParams}
             * @param authenticationRequestExtraParams The query parameters (up to 10) to include in the redirect request to the authorization endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authenticationRequestExtraParams(software.amazon.awscdk.IResolvable authenticationRequestExtraParams) {
                this.authenticationRequestExtraParams = authenticationRequestExtraParams;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateCognitoConfigProperty#getOnUnauthenticatedRequest}
             * @param onUnauthenticatedRequest The behavior if the user is not authenticated. The following are possible values:.
             *                                 <ul>
             *                                 <li>deny `` - Return an HTTP 401 Unauthorized error.</li>
             *                                 <li>allow `` - Allow the request to be forwarded to the target.</li>
             *                                 <li>authenticate `` - Redirect the request to the IdP authorization endpoint. This is the default value.</li>
             *                                 </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onUnauthenticatedRequest(java.lang.String onUnauthenticatedRequest) {
                this.onUnauthenticatedRequest = onUnauthenticatedRequest;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateCognitoConfigProperty#getScope}
             * @param scope The set of user claims to be requested from the IdP. The default is <code>openid</code> .
             *              To verify which scope values your IdP supports and how to separate multiple values, see the documentation for your IdP.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scope(java.lang.String scope) {
                this.scope = scope;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateCognitoConfigProperty#getSessionCookieName}
             * @param sessionCookieName The name of the cookie used to maintain session information.
             *                          The default is AWSELBAuthSessionCookie.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sessionCookieName(java.lang.String sessionCookieName) {
                this.sessionCookieName = sessionCookieName;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateCognitoConfigProperty#getSessionTimeout}
             * @param sessionTimeout The maximum duration of the authentication session, in seconds.
             *                       The default is 604800 seconds (7 days).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sessionTimeout(java.lang.Number sessionTimeout) {
                this.sessionTimeout = sessionTimeout;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AuthenticateCognitoConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AuthenticateCognitoConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AuthenticateCognitoConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AuthenticateCognitoConfigProperty {
            private final java.lang.String userPoolArn;
            private final java.lang.String userPoolClientId;
            private final java.lang.String userPoolDomain;
            private final java.lang.Object authenticationRequestExtraParams;
            private final java.lang.String onUnauthenticatedRequest;
            private final java.lang.String scope;
            private final java.lang.String sessionCookieName;
            private final java.lang.Number sessionTimeout;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.userPoolArn = software.amazon.jsii.Kernel.get(this, "userPoolArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.userPoolClientId = software.amazon.jsii.Kernel.get(this, "userPoolClientId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.userPoolDomain = software.amazon.jsii.Kernel.get(this, "userPoolDomain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.authenticationRequestExtraParams = software.amazon.jsii.Kernel.get(this, "authenticationRequestExtraParams", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.onUnauthenticatedRequest = software.amazon.jsii.Kernel.get(this, "onUnauthenticatedRequest", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.scope = software.amazon.jsii.Kernel.get(this, "scope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sessionCookieName = software.amazon.jsii.Kernel.get(this, "sessionCookieName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sessionTimeout = software.amazon.jsii.Kernel.get(this, "sessionTimeout", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.userPoolArn = java.util.Objects.requireNonNull(builder.userPoolArn, "userPoolArn is required");
                this.userPoolClientId = java.util.Objects.requireNonNull(builder.userPoolClientId, "userPoolClientId is required");
                this.userPoolDomain = java.util.Objects.requireNonNull(builder.userPoolDomain, "userPoolDomain is required");
                this.authenticationRequestExtraParams = builder.authenticationRequestExtraParams;
                this.onUnauthenticatedRequest = builder.onUnauthenticatedRequest;
                this.scope = builder.scope;
                this.sessionCookieName = builder.sessionCookieName;
                this.sessionTimeout = builder.sessionTimeout;
            }

            @Override
            public final java.lang.String getUserPoolArn() {
                return this.userPoolArn;
            }

            @Override
            public final java.lang.String getUserPoolClientId() {
                return this.userPoolClientId;
            }

            @Override
            public final java.lang.String getUserPoolDomain() {
                return this.userPoolDomain;
            }

            @Override
            public final java.lang.Object getAuthenticationRequestExtraParams() {
                return this.authenticationRequestExtraParams;
            }

            @Override
            public final java.lang.String getOnUnauthenticatedRequest() {
                return this.onUnauthenticatedRequest;
            }

            @Override
            public final java.lang.String getScope() {
                return this.scope;
            }

            @Override
            public final java.lang.String getSessionCookieName() {
                return this.sessionCookieName;
            }

            @Override
            public final java.lang.Number getSessionTimeout() {
                return this.sessionTimeout;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("userPoolArn", om.valueToTree(this.getUserPoolArn()));
                data.set("userPoolClientId", om.valueToTree(this.getUserPoolClientId()));
                data.set("userPoolDomain", om.valueToTree(this.getUserPoolDomain()));
                if (this.getAuthenticationRequestExtraParams() != null) {
                    data.set("authenticationRequestExtraParams", om.valueToTree(this.getAuthenticationRequestExtraParams()));
                }
                if (this.getOnUnauthenticatedRequest() != null) {
                    data.set("onUnauthenticatedRequest", om.valueToTree(this.getOnUnauthenticatedRequest()));
                }
                if (this.getScope() != null) {
                    data.set("scope", om.valueToTree(this.getScope()));
                }
                if (this.getSessionCookieName() != null) {
                    data.set("sessionCookieName", om.valueToTree(this.getSessionCookieName()));
                }
                if (this.getSessionTimeout() != null) {
                    data.set("sessionTimeout", om.valueToTree(this.getSessionTimeout()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticloadbalancingv2.CfnListenerRule.AuthenticateCognitoConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AuthenticateCognitoConfigProperty.Jsii$Proxy that = (AuthenticateCognitoConfigProperty.Jsii$Proxy) o;

                if (!userPoolArn.equals(that.userPoolArn)) return false;
                if (!userPoolClientId.equals(that.userPoolClientId)) return false;
                if (!userPoolDomain.equals(that.userPoolDomain)) return false;
                if (this.authenticationRequestExtraParams != null ? !this.authenticationRequestExtraParams.equals(that.authenticationRequestExtraParams) : that.authenticationRequestExtraParams != null) return false;
                if (this.onUnauthenticatedRequest != null ? !this.onUnauthenticatedRequest.equals(that.onUnauthenticatedRequest) : that.onUnauthenticatedRequest != null) return false;
                if (this.scope != null ? !this.scope.equals(that.scope) : that.scope != null) return false;
                if (this.sessionCookieName != null ? !this.sessionCookieName.equals(that.sessionCookieName) : that.sessionCookieName != null) return false;
                return this.sessionTimeout != null ? this.sessionTimeout.equals(that.sessionTimeout) : that.sessionTimeout == null;
            }

            @Override
            public final int hashCode() {
                int result = this.userPoolArn.hashCode();
                result = 31 * result + (this.userPoolClientId.hashCode());
                result = 31 * result + (this.userPoolDomain.hashCode());
                result = 31 * result + (this.authenticationRequestExtraParams != null ? this.authenticationRequestExtraParams.hashCode() : 0);
                result = 31 * result + (this.onUnauthenticatedRequest != null ? this.onUnauthenticatedRequest.hashCode() : 0);
                result = 31 * result + (this.scope != null ? this.scope.hashCode() : 0);
                result = 31 * result + (this.sessionCookieName != null ? this.sessionCookieName.hashCode() : 0);
                result = 31 * result + (this.sessionTimeout != null ? this.sessionTimeout.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies information required using an identity provide (IdP) that is compliant with OpenID Connect (OIDC) to authenticate users.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
     * AuthenticateOidcConfigProperty authenticateOidcConfigProperty = AuthenticateOidcConfigProperty.builder()
     *         .authorizationEndpoint("authorizationEndpoint")
     *         .clientId("clientId")
     *         .issuer("issuer")
     *         .tokenEndpoint("tokenEndpoint")
     *         .userInfoEndpoint("userInfoEndpoint")
     *         // the properties below are optional
     *         .authenticationRequestExtraParams(Map.of(
     *                 "authenticationRequestExtraParamsKey", "authenticationRequestExtraParams"))
     *         .clientSecret("clientSecret")
     *         .onUnauthenticatedRequest("onUnauthenticatedRequest")
     *         .scope("scope")
     *         .sessionCookieName("sessionCookieName")
     *         .sessionTimeout(123)
     *         .useExistingClientSecret(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.CfnListenerRule.AuthenticateOidcConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(AuthenticateOidcConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AuthenticateOidcConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The authorization endpoint of the IdP.
         * <p>
         * This must be a full URL, including the HTTPS protocol, the domain, and the path.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-authorizationendpoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-authorizationendpoint</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAuthorizationEndpoint();

        /**
         * The OAuth 2.0 client identifier.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-clientid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-clientid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClientId();

        /**
         * The OIDC issuer identifier of the IdP.
         * <p>
         * This must be a full URL, including the HTTPS protocol, the domain, and the path.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-issuer">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-issuer</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIssuer();

        /**
         * The token endpoint of the IdP.
         * <p>
         * This must be a full URL, including the HTTPS protocol, the domain, and the path.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-tokenendpoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-tokenendpoint</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTokenEndpoint();

        /**
         * The user info endpoint of the IdP.
         * <p>
         * This must be a full URL, including the HTTPS protocol, the domain, and the path.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-userinfoendpoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-userinfoendpoint</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUserInfoEndpoint();

        /**
         * The query parameters (up to 10) to include in the redirect request to the authorization endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-authenticationrequestextraparams">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-authenticationrequestextraparams</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAuthenticationRequestExtraParams() {
            return null;
        }

        /**
         * The OAuth 2.0 client secret. This parameter is required if you are creating a rule. If you are modifying a rule, you can omit this parameter if you set <code>UseExistingClientSecret</code> to true.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-clientsecret">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-clientsecret</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getClientSecret() {
            return null;
        }

        /**
         * The behavior if the user is not authenticated. The following are possible values:.
         * <p>
         * <ul>
         * <li>deny `` - Return an HTTP 401 Unauthorized error.</li>
         * <li>allow `` - Allow the request to be forwarded to the target.</li>
         * <li>authenticate `` - Redirect the request to the IdP authorization endpoint. This is the default value.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-onunauthenticatedrequest">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-onunauthenticatedrequest</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOnUnauthenticatedRequest() {
            return null;
        }

        /**
         * The set of user claims to be requested from the IdP. The default is <code>openid</code> .
         * <p>
         * To verify which scope values your IdP supports and how to separate multiple values, see the documentation for your IdP.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-scope">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-scope</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getScope() {
            return null;
        }

        /**
         * The name of the cookie used to maintain session information.
         * <p>
         * The default is AWSELBAuthSessionCookie.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-sessioncookiename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-sessioncookiename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSessionCookieName() {
            return null;
        }

        /**
         * The maximum duration of the authentication session, in seconds.
         * <p>
         * The default is 604800 seconds (7 days).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-sessiontimeout">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-sessiontimeout</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSessionTimeout() {
            return null;
        }

        /**
         * Indicates whether to use the existing client secret when modifying a rule.
         * <p>
         * If you are creating a rule, you can omit this parameter or set it to false.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-useexistingclientsecret">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listenerrule-authenticateoidcconfig-useexistingclientsecret</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUseExistingClientSecret() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AuthenticateOidcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AuthenticateOidcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AuthenticateOidcConfigProperty> {
            java.lang.String authorizationEndpoint;
            java.lang.String clientId;
            java.lang.String issuer;
            java.lang.String tokenEndpoint;
            java.lang.String userInfoEndpoint;
            java.lang.Object authenticationRequestExtraParams;
            java.lang.String clientSecret;
            java.lang.String onUnauthenticatedRequest;
            java.lang.String scope;
            java.lang.String sessionCookieName;
            java.lang.Number sessionTimeout;
            java.lang.Object useExistingClientSecret;

            /**
             * Sets the value of {@link AuthenticateOidcConfigProperty#getAuthorizationEndpoint}
             * @param authorizationEndpoint The authorization endpoint of the IdP. This parameter is required.
             *                              This must be a full URL, including the HTTPS protocol, the domain, and the path.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authorizationEndpoint(java.lang.String authorizationEndpoint) {
                this.authorizationEndpoint = authorizationEndpoint;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateOidcConfigProperty#getClientId}
             * @param clientId The OAuth 2.0 client identifier. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientId(java.lang.String clientId) {
                this.clientId = clientId;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateOidcConfigProperty#getIssuer}
             * @param issuer The OIDC issuer identifier of the IdP. This parameter is required.
             *               This must be a full URL, including the HTTPS protocol, the domain, and the path.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder issuer(java.lang.String issuer) {
                this.issuer = issuer;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateOidcConfigProperty#getTokenEndpoint}
             * @param tokenEndpoint The token endpoint of the IdP. This parameter is required.
             *                      This must be a full URL, including the HTTPS protocol, the domain, and the path.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tokenEndpoint(java.lang.String tokenEndpoint) {
                this.tokenEndpoint = tokenEndpoint;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateOidcConfigProperty#getUserInfoEndpoint}
             * @param userInfoEndpoint The user info endpoint of the IdP. This parameter is required.
             *                         This must be a full URL, including the HTTPS protocol, the domain, and the path.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userInfoEndpoint(java.lang.String userInfoEndpoint) {
                this.userInfoEndpoint = userInfoEndpoint;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateOidcConfigProperty#getAuthenticationRequestExtraParams}
             * @param authenticationRequestExtraParams The query parameters (up to 10) to include in the redirect request to the authorization endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authenticationRequestExtraParams(java.util.Map<java.lang.String, java.lang.String> authenticationRequestExtraParams) {
                this.authenticationRequestExtraParams = authenticationRequestExtraParams;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateOidcConfigProperty#getAuthenticationRequestExtraParams}
             * @param authenticationRequestExtraParams The query parameters (up to 10) to include in the redirect request to the authorization endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authenticationRequestExtraParams(software.amazon.awscdk.IResolvable authenticationRequestExtraParams) {
                this.authenticationRequestExtraParams = authenticationRequestExtraParams;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateOidcConfigProperty#getClientSecret}
             * @param clientSecret The OAuth 2.0 client secret. This parameter is required if you are creating a rule. If you are modifying a rule, you can omit this parameter if you set <code>UseExistingClientSecret</code> to true.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientSecret(java.lang.String clientSecret) {
                this.clientSecret = clientSecret;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateOidcConfigProperty#getOnUnauthenticatedRequest}
             * @param onUnauthenticatedRequest The behavior if the user is not authenticated. The following are possible values:.
             *                                 <ul>
             *                                 <li>deny `` - Return an HTTP 401 Unauthorized error.</li>
             *                                 <li>allow `` - Allow the request to be forwarded to the target.</li>
             *                                 <li>authenticate `` - Redirect the request to the IdP authorization endpoint. This is the default value.</li>
             *                                 </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onUnauthenticatedRequest(java.lang.String onUnauthenticatedRequest) {
                this.onUnauthenticatedRequest = onUnauthenticatedRequest;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateOidcConfigProperty#getScope}
             * @param scope The set of user claims to be requested from the IdP. The default is <code>openid</code> .
             *              To verify which scope values your IdP supports and how to separate multiple values, see the documentation for your IdP.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scope(java.lang.String scope) {
                this.scope = scope;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateOidcConfigProperty#getSessionCookieName}
             * @param sessionCookieName The name of the cookie used to maintain session information.
             *                          The default is AWSELBAuthSessionCookie.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sessionCookieName(java.lang.String sessionCookieName) {
                this.sessionCookieName = sessionCookieName;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateOidcConfigProperty#getSessionTimeout}
             * @param sessionTimeout The maximum duration of the authentication session, in seconds.
             *                       The default is 604800 seconds (7 days).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sessionTimeout(java.lang.Number sessionTimeout) {
                this.sessionTimeout = sessionTimeout;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateOidcConfigProperty#getUseExistingClientSecret}
             * @param useExistingClientSecret Indicates whether to use the existing client secret when modifying a rule.
             *                                If you are creating a rule, you can omit this parameter or set it to false.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useExistingClientSecret(java.lang.Boolean useExistingClientSecret) {
                this.useExistingClientSecret = useExistingClientSecret;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticateOidcConfigProperty#getUseExistingClientSecret}
             * @param useExistingClientSecret Indicates whether to use the existing client secret when modifying a rule.
             *                                If you are creating a rule, you can omit this parameter or set it to false.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useExistingClientSecret(software.amazon.awscdk.IResolvable useExistingClientSecret) {
                this.useExistingClientSecret = useExistingClientSecret;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AuthenticateOidcConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AuthenticateOidcConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AuthenticateOidcConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AuthenticateOidcConfigProperty {
            private final java.lang.String authorizationEndpoint;
            private final java.lang.String clientId;
            private final java.lang.String issuer;
            private final java.lang.String tokenEndpoint;
            private final java.lang.String userInfoEndpoint;
            private final java.lang.Object authenticationRequestExtraParams;
            private final java.lang.String clientSecret;
            private final java.lang.String onUnauthenticatedRequest;
            private final java.lang.String scope;
            private final java.lang.String sessionCookieName;
            private final java.lang.Number sessionTimeout;
            private final java.lang.Object useExistingClientSecret;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authorizationEndpoint = software.amazon.jsii.Kernel.get(this, "authorizationEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.clientId = software.amazon.jsii.Kernel.get(this, "clientId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.issuer = software.amazon.jsii.Kernel.get(this, "issuer", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tokenEndpoint = software.amazon.jsii.Kernel.get(this, "tokenEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.userInfoEndpoint = software.amazon.jsii.Kernel.get(this, "userInfoEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.authenticationRequestExtraParams = software.amazon.jsii.Kernel.get(this, "authenticationRequestExtraParams", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.clientSecret = software.amazon.jsii.Kernel.get(this, "clientSecret", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.onUnauthenticatedRequest = software.amazon.jsii.Kernel.get(this, "onUnauthenticatedRequest", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.scope = software.amazon.jsii.Kernel.get(this, "scope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sessionCookieName = software.amazon.jsii.Kernel.get(this, "sessionCookieName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sessionTimeout = software.amazon.jsii.Kernel.get(this, "sessionTimeout", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.useExistingClientSecret = software.amazon.jsii.Kernel.get(this, "useExistingClientSecret", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authorizationEndpoint = java.util.Objects.requireNonNull(builder.authorizationEndpoint, "authorizationEndpoint is required");
                this.clientId = java.util.Objects.requireNonNull(builder.clientId, "clientId is required");
                this.issuer = java.util.Objects.requireNonNull(builder.issuer, "issuer is required");
                this.tokenEndpoint = java.util.Objects.requireNonNull(builder.tokenEndpoint, "tokenEndpoint is required");
                this.userInfoEndpoint = java.util.Objects.requireNonNull(builder.userInfoEndpoint, "userInfoEndpoint is required");
                this.authenticationRequestExtraParams = builder.authenticationRequestExtraParams;
                this.clientSecret = builder.clientSecret;
                this.onUnauthenticatedRequest = builder.onUnauthenticatedRequest;
                this.scope = builder.scope;
                this.sessionCookieName = builder.sessionCookieName;
                this.sessionTimeout = builder.sessionTimeout;
                this.useExistingClientSecret = builder.useExistingClientSecret;
            }

            @Override
            public final java.lang.String getAuthorizationEndpoint() {
                return this.authorizationEndpoint;
            }

            @Override
            public final java.lang.String getClientId() {
                return this.clientId;
            }

            @Override
            public final java.lang.String getIssuer() {
                return this.issuer;
            }

            @Override
            public final java.lang.String getTokenEndpoint() {
                return this.tokenEndpoint;
            }

            @Override
            public final java.lang.String getUserInfoEndpoint() {
                return this.userInfoEndpoint;
            }

            @Override
            public final java.lang.Object getAuthenticationRequestExtraParams() {
                return this.authenticationRequestExtraParams;
            }

            @Override
            public final java.lang.String getClientSecret() {
                return this.clientSecret;
            }

            @Override
            public final java.lang.String getOnUnauthenticatedRequest() {
                return this.onUnauthenticatedRequest;
            }

            @Override
            public final java.lang.String getScope() {
                return this.scope;
            }

            @Override
            public final java.lang.String getSessionCookieName() {
                return this.sessionCookieName;
            }

            @Override
            public final java.lang.Number getSessionTimeout() {
                return this.sessionTimeout;
            }

            @Override
            public final java.lang.Object getUseExistingClientSecret() {
                return this.useExistingClientSecret;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("authorizationEndpoint", om.valueToTree(this.getAuthorizationEndpoint()));
                data.set("clientId", om.valueToTree(this.getClientId()));
                data.set("issuer", om.valueToTree(this.getIssuer()));
                data.set("tokenEndpoint", om.valueToTree(this.getTokenEndpoint()));
                data.set("userInfoEndpoint", om.valueToTree(this.getUserInfoEndpoint()));
                if (this.getAuthenticationRequestExtraParams() != null) {
                    data.set("authenticationRequestExtraParams", om.valueToTree(this.getAuthenticationRequestExtraParams()));
                }
                if (this.getClientSecret() != null) {
                    data.set("clientSecret", om.valueToTree(this.getClientSecret()));
                }
                if (this.getOnUnauthenticatedRequest() != null) {
                    data.set("onUnauthenticatedRequest", om.valueToTree(this.getOnUnauthenticatedRequest()));
                }
                if (this.getScope() != null) {
                    data.set("scope", om.valueToTree(this.getScope()));
                }
                if (this.getSessionCookieName() != null) {
                    data.set("sessionCookieName", om.valueToTree(this.getSessionCookieName()));
                }
                if (this.getSessionTimeout() != null) {
                    data.set("sessionTimeout", om.valueToTree(this.getSessionTimeout()));
                }
                if (this.getUseExistingClientSecret() != null) {
                    data.set("useExistingClientSecret", om.valueToTree(this.getUseExistingClientSecret()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticloadbalancingv2.CfnListenerRule.AuthenticateOidcConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AuthenticateOidcConfigProperty.Jsii$Proxy that = (AuthenticateOidcConfigProperty.Jsii$Proxy) o;

                if (!authorizationEndpoint.equals(that.authorizationEndpoint)) return false;
                if (!clientId.equals(that.clientId)) return false;
                if (!issuer.equals(that.issuer)) return false;
                if (!tokenEndpoint.equals(that.tokenEndpoint)) return false;
                if (!userInfoEndpoint.equals(that.userInfoEndpoint)) return false;
                if (this.authenticationRequestExtraParams != null ? !this.authenticationRequestExtraParams.equals(that.authenticationRequestExtraParams) : that.authenticationRequestExtraParams != null) return false;
                if (this.clientSecret != null ? !this.clientSecret.equals(that.clientSecret) : that.clientSecret != null) return false;
                if (this.onUnauthenticatedRequest != null ? !this.onUnauthenticatedRequest.equals(that.onUnauthenticatedRequest) : that.onUnauthenticatedRequest != null) return false;
                if (this.scope != null ? !this.scope.equals(that.scope) : that.scope != null) return false;
                if (this.sessionCookieName != null ? !this.sessionCookieName.equals(that.sessionCookieName) : that.sessionCookieName != null) return false;
                if (this.sessionTimeout != null ? !this.sessionTimeout.equals(that.sessionTimeout) : that.sessionTimeout != null) return false;
                return this.useExistingClientSecret != null ? this.useExistingClientSecret.equals(that.useExistingClientSecret) : that.useExistingClientSecret == null;
            }

            @Override
            public final int hashCode() {
                int result = this.authorizationEndpoint.hashCode();
                result = 31 * result + (this.clientId.hashCode());
                result = 31 * result + (this.issuer.hashCode());
                result = 31 * result + (this.tokenEndpoint.hashCode());
                result = 31 * result + (this.userInfoEndpoint.hashCode());
                result = 31 * result + (this.authenticationRequestExtraParams != null ? this.authenticationRequestExtraParams.hashCode() : 0);
                result = 31 * result + (this.clientSecret != null ? this.clientSecret.hashCode() : 0);
                result = 31 * result + (this.onUnauthenticatedRequest != null ? this.onUnauthenticatedRequest.hashCode() : 0);
                result = 31 * result + (this.scope != null ? this.scope.hashCode() : 0);
                result = 31 * result + (this.sessionCookieName != null ? this.sessionCookieName.hashCode() : 0);
                result = 31 * result + (this.sessionTimeout != null ? this.sessionTimeout.hashCode() : 0);
                result = 31 * result + (this.useExistingClientSecret != null ? this.useExistingClientSecret.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies information required when returning a custom HTTP response.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
     * FixedResponseConfigProperty fixedResponseConfigProperty = FixedResponseConfigProperty.builder()
     *         .statusCode("statusCode")
     *         // the properties below are optional
     *         .contentType("contentType")
     *         .messageBody("messageBody")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-fixedresponseconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-fixedresponseconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.CfnListenerRule.FixedResponseConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(FixedResponseConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FixedResponseConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The HTTP response code (2XX, 4XX, or 5XX).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listenerrule-fixedresponseconfig-statuscode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listenerrule-fixedresponseconfig-statuscode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStatusCode();

        /**
         * The content type.
         * <p>
         * Valid Values: text/plain | text/css | text/html | application/javascript | application/json
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listenerrule-fixedresponseconfig-contenttype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listenerrule-fixedresponseconfig-contenttype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getContentType() {
            return null;
        }

        /**
         * The message.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listenerrule-fixedresponseconfig-messagebody">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listenerrule-fixedresponseconfig-messagebody</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMessageBody() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FixedResponseConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FixedResponseConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FixedResponseConfigProperty> {
            java.lang.String statusCode;
            java.lang.String contentType;
            java.lang.String messageBody;

            /**
             * Sets the value of {@link FixedResponseConfigProperty#getStatusCode}
             * @param statusCode The HTTP response code (2XX, 4XX, or 5XX). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statusCode(java.lang.String statusCode) {
                this.statusCode = statusCode;
                return this;
            }

            /**
             * Sets the value of {@link FixedResponseConfigProperty#getContentType}
             * @param contentType The content type.
             *                    Valid Values: text/plain | text/css | text/html | application/javascript | application/json
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contentType(java.lang.String contentType) {
                this.contentType = contentType;
                return this;
            }

            /**
             * Sets the value of {@link FixedResponseConfigProperty#getMessageBody}
             * @param messageBody The message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder messageBody(java.lang.String messageBody) {
                this.messageBody = messageBody;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FixedResponseConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FixedResponseConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FixedResponseConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FixedResponseConfigProperty {
            private final java.lang.String statusCode;
            private final java.lang.String contentType;
            private final java.lang.String messageBody;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.statusCode = software.amazon.jsii.Kernel.get(this, "statusCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.contentType = software.amazon.jsii.Kernel.get(this, "contentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.messageBody = software.amazon.jsii.Kernel.get(this, "messageBody", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.statusCode = java.util.Objects.requireNonNull(builder.statusCode, "statusCode is required");
                this.contentType = builder.contentType;
                this.messageBody = builder.messageBody;
            }

            @Override
            public final java.lang.String getStatusCode() {
                return this.statusCode;
            }

            @Override
            public final java.lang.String getContentType() {
                return this.contentType;
            }

            @Override
            public final java.lang.String getMessageBody() {
                return this.messageBody;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("statusCode", om.valueToTree(this.getStatusCode()));
                if (this.getContentType() != null) {
                    data.set("contentType", om.valueToTree(this.getContentType()));
                }
                if (this.getMessageBody() != null) {
                    data.set("messageBody", om.valueToTree(this.getMessageBody()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticloadbalancingv2.CfnListenerRule.FixedResponseConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FixedResponseConfigProperty.Jsii$Proxy that = (FixedResponseConfigProperty.Jsii$Proxy) o;

                if (!statusCode.equals(that.statusCode)) return false;
                if (this.contentType != null ? !this.contentType.equals(that.contentType) : that.contentType != null) return false;
                return this.messageBody != null ? this.messageBody.equals(that.messageBody) : that.messageBody == null;
            }

            @Override
            public final int hashCode() {
                int result = this.statusCode.hashCode();
                result = 31 * result + (this.contentType != null ? this.contentType.hashCode() : 0);
                result = 31 * result + (this.messageBody != null ? this.messageBody.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information for creating an action that distributes requests among one or more target groups.
     * <p>
     * For Network Load Balancers, you can specify a single target group. Specify only when <code>Type</code> is <code>forward</code> . If you specify both <code>ForwardConfig</code> and <code>TargetGroupArn</code> , you can specify only one target group using <code>ForwardConfig</code> and it must be the same target group specified in <code>TargetGroupArn</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
     * ForwardConfigProperty forwardConfigProperty = ForwardConfigProperty.builder()
     *         .targetGroups(List.of(TargetGroupTupleProperty.builder()
     *                 .targetGroupArn("targetGroupArn")
     *                 .weight(123)
     *                 .build()))
     *         .targetGroupStickinessConfig(TargetGroupStickinessConfigProperty.builder()
     *                 .durationSeconds(123)
     *                 .enabled(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-forwardconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-forwardconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.CfnListenerRule.ForwardConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ForwardConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ForwardConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Information about how traffic will be distributed between multiple target groups in a forward rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-forwardconfig.html#cfn-elasticloadbalancingv2-listenerrule-forwardconfig-targetgroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-forwardconfig.html#cfn-elasticloadbalancingv2-listenerrule-forwardconfig-targetgroups</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTargetGroups() {
            return null;
        }

        /**
         * Information about the target group stickiness for a rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-forwardconfig.html#cfn-elasticloadbalancingv2-listenerrule-forwardconfig-targetgroupstickinessconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-forwardconfig.html#cfn-elasticloadbalancingv2-listenerrule-forwardconfig-targetgroupstickinessconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTargetGroupStickinessConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ForwardConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ForwardConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ForwardConfigProperty> {
            java.lang.Object targetGroups;
            java.lang.Object targetGroupStickinessConfig;

            /**
             * Sets the value of {@link ForwardConfigProperty#getTargetGroups}
             * @param targetGroups Information about how traffic will be distributed between multiple target groups in a forward rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetGroups(software.amazon.awscdk.IResolvable targetGroups) {
                this.targetGroups = targetGroups;
                return this;
            }

            /**
             * Sets the value of {@link ForwardConfigProperty#getTargetGroups}
             * @param targetGroups Information about how traffic will be distributed between multiple target groups in a forward rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetGroups(java.util.List<? extends java.lang.Object> targetGroups) {
                this.targetGroups = targetGroups;
                return this;
            }

            /**
             * Sets the value of {@link ForwardConfigProperty#getTargetGroupStickinessConfig}
             * @param targetGroupStickinessConfig Information about the target group stickiness for a rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetGroupStickinessConfig(software.amazon.awscdk.IResolvable targetGroupStickinessConfig) {
                this.targetGroupStickinessConfig = targetGroupStickinessConfig;
                return this;
            }

            /**
             * Sets the value of {@link ForwardConfigProperty#getTargetGroupStickinessConfig}
             * @param targetGroupStickinessConfig Information about the target group stickiness for a rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetGroupStickinessConfig(software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.TargetGroupStickinessConfigProperty targetGroupStickinessConfig) {
                this.targetGroupStickinessConfig = targetGroupStickinessConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ForwardConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ForwardConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ForwardConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ForwardConfigProperty {
            private final java.lang.Object targetGroups;
            private final java.lang.Object targetGroupStickinessConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.targetGroups = software.amazon.jsii.Kernel.get(this, "targetGroups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.targetGroupStickinessConfig = software.amazon.jsii.Kernel.get(this, "targetGroupStickinessConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.targetGroups = builder.targetGroups;
                this.targetGroupStickinessConfig = builder.targetGroupStickinessConfig;
            }

            @Override
            public final java.lang.Object getTargetGroups() {
                return this.targetGroups;
            }

            @Override
            public final java.lang.Object getTargetGroupStickinessConfig() {
                return this.targetGroupStickinessConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getTargetGroups() != null) {
                    data.set("targetGroups", om.valueToTree(this.getTargetGroups()));
                }
                if (this.getTargetGroupStickinessConfig() != null) {
                    data.set("targetGroupStickinessConfig", om.valueToTree(this.getTargetGroupStickinessConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticloadbalancingv2.CfnListenerRule.ForwardConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ForwardConfigProperty.Jsii$Proxy that = (ForwardConfigProperty.Jsii$Proxy) o;

                if (this.targetGroups != null ? !this.targetGroups.equals(that.targetGroups) : that.targetGroups != null) return false;
                return this.targetGroupStickinessConfig != null ? this.targetGroupStickinessConfig.equals(that.targetGroupStickinessConfig) : that.targetGroupStickinessConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.targetGroups != null ? this.targetGroups.hashCode() : 0;
                result = 31 * result + (this.targetGroupStickinessConfig != null ? this.targetGroupStickinessConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about a host header condition.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
     * HostHeaderConfigProperty hostHeaderConfigProperty = HostHeaderConfigProperty.builder()
     *         .values(List.of("values"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-hostheaderconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-hostheaderconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.CfnListenerRule.HostHeaderConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(HostHeaderConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HostHeaderConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The host names.
         * <p>
         * The maximum size of each name is 128 characters. The comparison is case insensitive. The following wildcard characters are supported: * (matches 0 or more characters) and ? (matches exactly 1 character).
         * <p>
         * If you specify multiple strings, the condition is satisfied if one of the strings matches the host name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-hostheaderconfig.html#cfn-elasticloadbalancingv2-listenerrule-hostheaderconfig-values">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-hostheaderconfig.html#cfn-elasticloadbalancingv2-listenerrule-hostheaderconfig-values</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getValues() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HostHeaderConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HostHeaderConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HostHeaderConfigProperty> {
            java.util.List<java.lang.String> values;

            /**
             * Sets the value of {@link HostHeaderConfigProperty#getValues}
             * @param values The host names.
             *               The maximum size of each name is 128 characters. The comparison is case insensitive. The following wildcard characters are supported: * (matches 0 or more characters) and ? (matches exactly 1 character).
             *               <p>
             *               If you specify multiple strings, the condition is satisfied if one of the strings matches the host name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<java.lang.String> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HostHeaderConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HostHeaderConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HostHeaderConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HostHeaderConfigProperty {
            private final java.util.List<java.lang.String> values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.values = builder.values;
            }

            @Override
            public final java.util.List<java.lang.String> getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getValues() != null) {
                    data.set("values", om.valueToTree(this.getValues()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticloadbalancingv2.CfnListenerRule.HostHeaderConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HostHeaderConfigProperty.Jsii$Proxy that = (HostHeaderConfigProperty.Jsii$Proxy) o;

                return this.values != null ? this.values.equals(that.values) : that.values == null;
            }

            @Override
            public final int hashCode() {
                int result = this.values != null ? this.values.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Information about an HTTP header condition.
     * <p>
     * There is a set of standard HTTP header fields. You can also define custom HTTP header fields.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
     * HttpHeaderConfigProperty httpHeaderConfigProperty = HttpHeaderConfigProperty.builder()
     *         .httpHeaderName("httpHeaderName")
     *         .values(List.of("values"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-httpheaderconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-httpheaderconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.CfnListenerRule.HttpHeaderConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(HttpHeaderConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HttpHeaderConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the HTTP header field.
         * <p>
         * The maximum size is 40 characters. The header name is case insensitive. The allowed characters are specified by RFC 7230. Wildcards are not supported.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-httpheaderconfig.html#cfn-elasticloadbalancingv2-listenerrule-httpheaderconfig-httpheadername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-httpheaderconfig.html#cfn-elasticloadbalancingv2-listenerrule-httpheaderconfig-httpheadername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHttpHeaderName() {
            return null;
        }

        /**
         * The strings to compare against the value of the HTTP header.
         * <p>
         * The maximum size of each string is 128 characters. The comparison strings are case insensitive. The following wildcard characters are supported: * (matches 0 or more characters) and ? (matches exactly 1 character).
         * <p>
         * If the same header appears multiple times in the request, we search them in order until a match is found.
         * <p>
         * If you specify multiple strings, the condition is satisfied if one of the strings matches the value of the HTTP header. To require that all of the strings are a match, create one condition per string.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-httpheaderconfig.html#cfn-elasticloadbalancingv2-listenerrule-httpheaderconfig-values">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-httpheaderconfig.html#cfn-elasticloadbalancingv2-listenerrule-httpheaderconfig-values</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getValues() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HttpHeaderConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HttpHeaderConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HttpHeaderConfigProperty> {
            java.lang.String httpHeaderName;
            java.util.List<java.lang.String> values;

            /**
             * Sets the value of {@link HttpHeaderConfigProperty#getHttpHeaderName}
             * @param httpHeaderName The name of the HTTP header field.
             *                       The maximum size is 40 characters. The header name is case insensitive. The allowed characters are specified by RFC 7230. Wildcards are not supported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpHeaderName(java.lang.String httpHeaderName) {
                this.httpHeaderName = httpHeaderName;
                return this;
            }

            /**
             * Sets the value of {@link HttpHeaderConfigProperty#getValues}
             * @param values The strings to compare against the value of the HTTP header.
             *               The maximum size of each string is 128 characters. The comparison strings are case insensitive. The following wildcard characters are supported: * (matches 0 or more characters) and ? (matches exactly 1 character).
             *               <p>
             *               If the same header appears multiple times in the request, we search them in order until a match is found.
             *               <p>
             *               If you specify multiple strings, the condition is satisfied if one of the strings matches the value of the HTTP header. To require that all of the strings are a match, create one condition per string.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<java.lang.String> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HttpHeaderConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HttpHeaderConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HttpHeaderConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpHeaderConfigProperty {
            private final java.lang.String httpHeaderName;
            private final java.util.List<java.lang.String> values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.httpHeaderName = software.amazon.jsii.Kernel.get(this, "httpHeaderName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.httpHeaderName = builder.httpHeaderName;
                this.values = builder.values;
            }

            @Override
            public final java.lang.String getHttpHeaderName() {
                return this.httpHeaderName;
            }

            @Override
            public final java.util.List<java.lang.String> getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getHttpHeaderName() != null) {
                    data.set("httpHeaderName", om.valueToTree(this.getHttpHeaderName()));
                }
                if (this.getValues() != null) {
                    data.set("values", om.valueToTree(this.getValues()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticloadbalancingv2.CfnListenerRule.HttpHeaderConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HttpHeaderConfigProperty.Jsii$Proxy that = (HttpHeaderConfigProperty.Jsii$Proxy) o;

                if (this.httpHeaderName != null ? !this.httpHeaderName.equals(that.httpHeaderName) : that.httpHeaderName != null) return false;
                return this.values != null ? this.values.equals(that.values) : that.values == null;
            }

            @Override
            public final int hashCode() {
                int result = this.httpHeaderName != null ? this.httpHeaderName.hashCode() : 0;
                result = 31 * result + (this.values != null ? this.values.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about an HTTP method condition.
     * <p>
     * HTTP defines a set of request methods, also referred to as HTTP verbs. For more information, see the <a href="https://docs.aws.amazon.com/https://www.iana.org/assignments/http-methods/http-methods.xhtml">HTTP Method Registry</a> . You can also define custom HTTP methods.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
     * HttpRequestMethodConfigProperty httpRequestMethodConfigProperty = HttpRequestMethodConfigProperty.builder()
     *         .values(List.of("values"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-httprequestmethodconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-httprequestmethodconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.CfnListenerRule.HttpRequestMethodConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(HttpRequestMethodConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HttpRequestMethodConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the request method.
         * <p>
         * The maximum size is 40 characters. The allowed characters are A-Z, hyphen (-), and underscore (_). The comparison is case sensitive. Wildcards are not supported; therefore, the method name must be an exact match.
         * <p>
         * If you specify multiple strings, the condition is satisfied if one of the strings matches the HTTP request method. We recommend that you route GET and HEAD requests in the same way, because the response to a HEAD request may be cached.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-httprequestmethodconfig.html#cfn-elasticloadbalancingv2-listenerrule-httprequestmethodconfig-values">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-httprequestmethodconfig.html#cfn-elasticloadbalancingv2-listenerrule-httprequestmethodconfig-values</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getValues() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HttpRequestMethodConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HttpRequestMethodConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HttpRequestMethodConfigProperty> {
            java.util.List<java.lang.String> values;

            /**
             * Sets the value of {@link HttpRequestMethodConfigProperty#getValues}
             * @param values The name of the request method.
             *               The maximum size is 40 characters. The allowed characters are A-Z, hyphen (-), and underscore (_). The comparison is case sensitive. Wildcards are not supported; therefore, the method name must be an exact match.
             *               <p>
             *               If you specify multiple strings, the condition is satisfied if one of the strings matches the HTTP request method. We recommend that you route GET and HEAD requests in the same way, because the response to a HEAD request may be cached.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<java.lang.String> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HttpRequestMethodConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HttpRequestMethodConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HttpRequestMethodConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpRequestMethodConfigProperty {
            private final java.util.List<java.lang.String> values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.values = builder.values;
            }

            @Override
            public final java.util.List<java.lang.String> getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getValues() != null) {
                    data.set("values", om.valueToTree(this.getValues()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticloadbalancingv2.CfnListenerRule.HttpRequestMethodConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HttpRequestMethodConfigProperty.Jsii$Proxy that = (HttpRequestMethodConfigProperty.Jsii$Proxy) o;

                return this.values != null ? this.values.equals(that.values) : that.values == null;
            }

            @Override
            public final int hashCode() {
                int result = this.values != null ? this.values.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Information about a path pattern condition.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
     * PathPatternConfigProperty pathPatternConfigProperty = PathPatternConfigProperty.builder()
     *         .values(List.of("values"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-pathpatternconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-pathpatternconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.CfnListenerRule.PathPatternConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(PathPatternConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PathPatternConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The path patterns to compare against the request URL.
         * <p>
         * The maximum size of each string is 128 characters. The comparison is case sensitive. The following wildcard characters are supported: * (matches 0 or more characters) and ? (matches exactly 1 character).
         * <p>
         * If you specify multiple strings, the condition is satisfied if one of them matches the request URL. The path pattern is compared only to the path of the URL, not to its query string.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-pathpatternconfig.html#cfn-elasticloadbalancingv2-listenerrule-pathpatternconfig-values">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-pathpatternconfig.html#cfn-elasticloadbalancingv2-listenerrule-pathpatternconfig-values</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getValues() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PathPatternConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PathPatternConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PathPatternConfigProperty> {
            java.util.List<java.lang.String> values;

            /**
             * Sets the value of {@link PathPatternConfigProperty#getValues}
             * @param values The path patterns to compare against the request URL.
             *               The maximum size of each string is 128 characters. The comparison is case sensitive. The following wildcard characters are supported: * (matches 0 or more characters) and ? (matches exactly 1 character).
             *               <p>
             *               If you specify multiple strings, the condition is satisfied if one of them matches the request URL. The path pattern is compared only to the path of the URL, not to its query string.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<java.lang.String> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PathPatternConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PathPatternConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PathPatternConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PathPatternConfigProperty {
            private final java.util.List<java.lang.String> values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.values = builder.values;
            }

            @Override
            public final java.util.List<java.lang.String> getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getValues() != null) {
                    data.set("values", om.valueToTree(this.getValues()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticloadbalancingv2.CfnListenerRule.PathPatternConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PathPatternConfigProperty.Jsii$Proxy that = (PathPatternConfigProperty.Jsii$Proxy) o;

                return this.values != null ? this.values.equals(that.values) : that.values == null;
            }

            @Override
            public final int hashCode() {
                int result = this.values != null ? this.values.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Information about a query string condition.
     * <p>
     * The query string component of a URI starts after the first '?' character and is terminated by either a '#' character or the end of the URI. A typical query string contains key/value pairs separated by '&amp;' characters. The allowed characters are specified by RFC 3986. Any character can be percentage encoded.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
     * QueryStringConfigProperty queryStringConfigProperty = QueryStringConfigProperty.builder()
     *         .values(List.of(QueryStringKeyValueProperty.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-querystringconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-querystringconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.CfnListenerRule.QueryStringConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(QueryStringConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface QueryStringConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The key/value pairs or values to find in the query string.
         * <p>
         * The maximum size of each string is 128 characters. The comparison is case insensitive. The following wildcard characters are supported: * (matches 0 or more characters) and ? (matches exactly 1 character). To search for a literal '*' or '?' character in a query string, you must escape these characters in <code>Values</code> using a '' character.
         * <p>
         * If you specify multiple key/value pairs or values, the condition is satisfied if one of them is found in the query string.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-querystringconfig.html#cfn-elasticloadbalancingv2-listenerrule-querystringconfig-values">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-querystringconfig.html#cfn-elasticloadbalancingv2-listenerrule-querystringconfig-values</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getValues() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link QueryStringConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link QueryStringConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<QueryStringConfigProperty> {
            java.lang.Object values;

            /**
             * Sets the value of {@link QueryStringConfigProperty#getValues}
             * @param values The key/value pairs or values to find in the query string.
             *               The maximum size of each string is 128 characters. The comparison is case insensitive. The following wildcard characters are supported: * (matches 0 or more characters) and ? (matches exactly 1 character). To search for a literal '*' or '?' character in a query string, you must escape these characters in <code>Values</code> using a '' character.
             *               <p>
             *               If you specify multiple key/value pairs or values, the condition is satisfied if one of them is found in the query string.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(software.amazon.awscdk.IResolvable values) {
                this.values = values;
                return this;
            }

            /**
             * Sets the value of {@link QueryStringConfigProperty#getValues}
             * @param values The key/value pairs or values to find in the query string.
             *               The maximum size of each string is 128 characters. The comparison is case insensitive. The following wildcard characters are supported: * (matches 0 or more characters) and ? (matches exactly 1 character). To search for a literal '*' or '?' character in a query string, you must escape these characters in <code>Values</code> using a '' character.
             *               <p>
             *               If you specify multiple key/value pairs or values, the condition is satisfied if one of them is found in the query string.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<? extends java.lang.Object> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link QueryStringConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public QueryStringConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link QueryStringConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements QueryStringConfigProperty {
            private final java.lang.Object values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.values = builder.values;
            }

            @Override
            public final java.lang.Object getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getValues() != null) {
                    data.set("values", om.valueToTree(this.getValues()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticloadbalancingv2.CfnListenerRule.QueryStringConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                QueryStringConfigProperty.Jsii$Proxy that = (QueryStringConfigProperty.Jsii$Proxy) o;

                return this.values != null ? this.values.equals(that.values) : that.values == null;
            }

            @Override
            public final int hashCode() {
                int result = this.values != null ? this.values.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Information about a key/value pair.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
     * QueryStringKeyValueProperty queryStringKeyValueProperty = QueryStringKeyValueProperty.builder()
     *         .key("key")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-querystringkeyvalue.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-querystringkeyvalue.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.CfnListenerRule.QueryStringKeyValueProperty")
    @software.amazon.jsii.Jsii.Proxy(QueryStringKeyValueProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface QueryStringKeyValueProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The key.
         * <p>
         * You can omit the key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-querystringkeyvalue.html#cfn-elasticloadbalancingv2-listenerrule-querystringkeyvalue-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-querystringkeyvalue.html#cfn-elasticloadbalancingv2-listenerrule-querystringkeyvalue-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKey() {
            return null;
        }

        /**
         * The value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-querystringkeyvalue.html#cfn-elasticloadbalancingv2-listenerrule-querystringkeyvalue-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-querystringkeyvalue.html#cfn-elasticloadbalancingv2-listenerrule-querystringkeyvalue-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link QueryStringKeyValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link QueryStringKeyValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<QueryStringKeyValueProperty> {
            java.lang.String key;
            java.lang.String value;

            /**
             * Sets the value of {@link QueryStringKeyValueProperty#getKey}
             * @param key The key.
             *            You can omit the key.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link QueryStringKeyValueProperty#getValue}
             * @param value The value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link QueryStringKeyValueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public QueryStringKeyValueProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link QueryStringKeyValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements QueryStringKeyValueProperty {
            private final java.lang.String key;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = builder.key;
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getKey() != null) {
                    data.set("key", om.valueToTree(this.getKey()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticloadbalancingv2.CfnListenerRule.QueryStringKeyValueProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                QueryStringKeyValueProperty.Jsii$Proxy that = (QueryStringKeyValueProperty.Jsii$Proxy) o;

                if (this.key != null ? !this.key.equals(that.key) : that.key != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.key != null ? this.key.hashCode() : 0;
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about a redirect action.
     * <p>
     * A URI consists of the following components: protocol://hostname:port/path?query. You must modify at least one of the following components to avoid a redirect loop: protocol, hostname, port, or path. Any components that you do not modify retain their original values.
     * <p>
     * You can reuse URI components using the following reserved keywords:
     * <p>
     * <ul>
     * <li>#{protocol}</li>
     * <li>#{host}</li>
     * <li>#{port}</li>
     * <li>#{path} (the leading "/" is removed)</li>
     * <li>#{query}</li>
     * </ul>
     * <p>
     * For example, you can change the path to "/new/#{path}", the hostname to "example.#{host}", or the query to "#{query}&amp;value=xyz".
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
     * RedirectConfigProperty redirectConfigProperty = RedirectConfigProperty.builder()
     *         .statusCode("statusCode")
     *         // the properties below are optional
     *         .host("host")
     *         .path("path")
     *         .port("port")
     *         .protocol("protocol")
     *         .query("query")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-redirectconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-redirectconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.CfnListenerRule.RedirectConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(RedirectConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RedirectConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The HTTP redirect code.
         * <p>
         * The redirect is either permanent (HTTP 301) or temporary (HTTP 302).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-redirectconfig.html#cfn-elasticloadbalancingv2-listenerrule-redirectconfig-statuscode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-redirectconfig.html#cfn-elasticloadbalancingv2-listenerrule-redirectconfig-statuscode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStatusCode();

        /**
         * The hostname.
         * <p>
         * This component is not percent-encoded. The hostname can contain #{host}.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-redirectconfig.html#cfn-elasticloadbalancingv2-listenerrule-redirectconfig-host">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-redirectconfig.html#cfn-elasticloadbalancingv2-listenerrule-redirectconfig-host</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHost() {
            return null;
        }

        /**
         * The absolute path, starting with the leading "/".
         * <p>
         * This component is not percent-encoded. The path can contain #{host}, #{path}, and #{port}.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-redirectconfig.html#cfn-elasticloadbalancingv2-listenerrule-redirectconfig-path">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-redirectconfig.html#cfn-elasticloadbalancingv2-listenerrule-redirectconfig-path</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPath() {
            return null;
        }

        /**
         * The port.
         * <p>
         * You can specify a value from 1 to 65535 or #{port}.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-redirectconfig.html#cfn-elasticloadbalancingv2-listenerrule-redirectconfig-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-redirectconfig.html#cfn-elasticloadbalancingv2-listenerrule-redirectconfig-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPort() {
            return null;
        }

        /**
         * The protocol.
         * <p>
         * You can specify HTTP, HTTPS, or #{protocol}. You can redirect HTTP to HTTP, HTTP to HTTPS, and HTTPS to HTTPS. You can't redirect HTTPS to HTTP.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-redirectconfig.html#cfn-elasticloadbalancingv2-listenerrule-redirectconfig-protocol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-redirectconfig.html#cfn-elasticloadbalancingv2-listenerrule-redirectconfig-protocol</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProtocol() {
            return null;
        }

        /**
         * The query parameters, URL-encoded when necessary, but not percent-encoded.
         * <p>
         * Do not include the leading "?", as it is automatically added. You can specify any of the reserved keywords.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-redirectconfig.html#cfn-elasticloadbalancingv2-listenerrule-redirectconfig-query">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-redirectconfig.html#cfn-elasticloadbalancingv2-listenerrule-redirectconfig-query</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getQuery() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RedirectConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RedirectConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RedirectConfigProperty> {
            java.lang.String statusCode;
            java.lang.String host;
            java.lang.String path;
            java.lang.String port;
            java.lang.String protocol;
            java.lang.String query;

            /**
             * Sets the value of {@link RedirectConfigProperty#getStatusCode}
             * @param statusCode The HTTP redirect code. This parameter is required.
             *                   The redirect is either permanent (HTTP 301) or temporary (HTTP 302).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statusCode(java.lang.String statusCode) {
                this.statusCode = statusCode;
                return this;
            }

            /**
             * Sets the value of {@link RedirectConfigProperty#getHost}
             * @param host The hostname.
             *             This component is not percent-encoded. The hostname can contain #{host}.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder host(java.lang.String host) {
                this.host = host;
                return this;
            }

            /**
             * Sets the value of {@link RedirectConfigProperty#getPath}
             * @param path The absolute path, starting with the leading "/".
             *             This component is not percent-encoded. The path can contain #{host}, #{path}, and #{port}.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder path(java.lang.String path) {
                this.path = path;
                return this;
            }

            /**
             * Sets the value of {@link RedirectConfigProperty#getPort}
             * @param port The port.
             *             You can specify a value from 1 to 65535 or #{port}.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.String port) {
                this.port = port;
                return this;
            }

            /**
             * Sets the value of {@link RedirectConfigProperty#getProtocol}
             * @param protocol The protocol.
             *                 You can specify HTTP, HTTPS, or #{protocol}. You can redirect HTTP to HTTP, HTTP to HTTPS, and HTTPS to HTTPS. You can't redirect HTTPS to HTTP.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder protocol(java.lang.String protocol) {
                this.protocol = protocol;
                return this;
            }

            /**
             * Sets the value of {@link RedirectConfigProperty#getQuery}
             * @param query The query parameters, URL-encoded when necessary, but not percent-encoded.
             *              Do not include the leading "?", as it is automatically added. You can specify any of the reserved keywords.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder query(java.lang.String query) {
                this.query = query;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedirectConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RedirectConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RedirectConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedirectConfigProperty {
            private final java.lang.String statusCode;
            private final java.lang.String host;
            private final java.lang.String path;
            private final java.lang.String port;
            private final java.lang.String protocol;
            private final java.lang.String query;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.statusCode = software.amazon.jsii.Kernel.get(this, "statusCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.host = software.amazon.jsii.Kernel.get(this, "host", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.query = software.amazon.jsii.Kernel.get(this, "query", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.statusCode = java.util.Objects.requireNonNull(builder.statusCode, "statusCode is required");
                this.host = builder.host;
                this.path = builder.path;
                this.port = builder.port;
                this.protocol = builder.protocol;
                this.query = builder.query;
            }

            @Override
            public final java.lang.String getStatusCode() {
                return this.statusCode;
            }

            @Override
            public final java.lang.String getHost() {
                return this.host;
            }

            @Override
            public final java.lang.String getPath() {
                return this.path;
            }

            @Override
            public final java.lang.String getPort() {
                return this.port;
            }

            @Override
            public final java.lang.String getProtocol() {
                return this.protocol;
            }

            @Override
            public final java.lang.String getQuery() {
                return this.query;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("statusCode", om.valueToTree(this.getStatusCode()));
                if (this.getHost() != null) {
                    data.set("host", om.valueToTree(this.getHost()));
                }
                if (this.getPath() != null) {
                    data.set("path", om.valueToTree(this.getPath()));
                }
                if (this.getPort() != null) {
                    data.set("port", om.valueToTree(this.getPort()));
                }
                if (this.getProtocol() != null) {
                    data.set("protocol", om.valueToTree(this.getProtocol()));
                }
                if (this.getQuery() != null) {
                    data.set("query", om.valueToTree(this.getQuery()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticloadbalancingv2.CfnListenerRule.RedirectConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RedirectConfigProperty.Jsii$Proxy that = (RedirectConfigProperty.Jsii$Proxy) o;

                if (!statusCode.equals(that.statusCode)) return false;
                if (this.host != null ? !this.host.equals(that.host) : that.host != null) return false;
                if (this.path != null ? !this.path.equals(that.path) : that.path != null) return false;
                if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
                if (this.protocol != null ? !this.protocol.equals(that.protocol) : that.protocol != null) return false;
                return this.query != null ? this.query.equals(that.query) : that.query == null;
            }

            @Override
            public final int hashCode() {
                int result = this.statusCode.hashCode();
                result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
                result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
                result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
                result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
                result = 31 * result + (this.query != null ? this.query.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies a condition for a listener rule.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
     * RuleConditionProperty ruleConditionProperty = RuleConditionProperty.builder()
     *         .field("field")
     *         .hostHeaderConfig(HostHeaderConfigProperty.builder()
     *                 .values(List.of("values"))
     *                 .build())
     *         .httpHeaderConfig(HttpHeaderConfigProperty.builder()
     *                 .httpHeaderName("httpHeaderName")
     *                 .values(List.of("values"))
     *                 .build())
     *         .httpRequestMethodConfig(HttpRequestMethodConfigProperty.builder()
     *                 .values(List.of("values"))
     *                 .build())
     *         .pathPatternConfig(PathPatternConfigProperty.builder()
     *                 .values(List.of("values"))
     *                 .build())
     *         .queryStringConfig(QueryStringConfigProperty.builder()
     *                 .values(List.of(QueryStringKeyValueProperty.builder()
     *                         .key("key")
     *                         .value("value")
     *                         .build()))
     *                 .build())
     *         .sourceIpConfig(SourceIpConfigProperty.builder()
     *                 .values(List.of("values"))
     *                 .build())
     *         .values(List.of("values"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-rulecondition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-rulecondition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.CfnListenerRule.RuleConditionProperty")
    @software.amazon.jsii.Jsii.Proxy(RuleConditionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RuleConditionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The field in the HTTP request. The following are the possible values:.
         * <p>
         * <ul>
         * <li><code>http-header</code></li>
         * <li><code>http-request-method</code></li>
         * <li><code>host-header</code></li>
         * <li><code>path-pattern</code></li>
         * <li><code>query-string</code></li>
         * <li><code>source-ip</code></li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-rulecondition.html#cfn-elasticloadbalancingv2-listenerrule-rulecondition-field">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-rulecondition.html#cfn-elasticloadbalancingv2-listenerrule-rulecondition-field</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getField() {
            return null;
        }

        /**
         * Information for a host header condition.
         * <p>
         * Specify only when <code>Field</code> is <code>host-header</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-rulecondition.html#cfn-elasticloadbalancingv2-listenerrule-rulecondition-hostheaderconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-rulecondition.html#cfn-elasticloadbalancingv2-listenerrule-rulecondition-hostheaderconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHostHeaderConfig() {
            return null;
        }

        /**
         * Information for an HTTP header condition.
         * <p>
         * Specify only when <code>Field</code> is <code>http-header</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-rulecondition.html#cfn-elasticloadbalancingv2-listenerrule-rulecondition-httpheaderconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-rulecondition.html#cfn-elasticloadbalancingv2-listenerrule-rulecondition-httpheaderconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHttpHeaderConfig() {
            return null;
        }

        /**
         * Information for an HTTP method condition.
         * <p>
         * Specify only when <code>Field</code> is <code>http-request-method</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-rulecondition.html#cfn-elasticloadbalancingv2-listenerrule-rulecondition-httprequestmethodconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-rulecondition.html#cfn-elasticloadbalancingv2-listenerrule-rulecondition-httprequestmethodconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHttpRequestMethodConfig() {
            return null;
        }

        /**
         * Information for a path pattern condition.
         * <p>
         * Specify only when <code>Field</code> is <code>path-pattern</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-rulecondition.html#cfn-elasticloadbalancingv2-listenerrule-rulecondition-pathpatternconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-rulecondition.html#cfn-elasticloadbalancingv2-listenerrule-rulecondition-pathpatternconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPathPatternConfig() {
            return null;
        }

        /**
         * Information for a query string condition.
         * <p>
         * Specify only when <code>Field</code> is <code>query-string</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-rulecondition.html#cfn-elasticloadbalancingv2-listenerrule-rulecondition-querystringconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-rulecondition.html#cfn-elasticloadbalancingv2-listenerrule-rulecondition-querystringconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getQueryStringConfig() {
            return null;
        }

        /**
         * Information for a source IP condition.
         * <p>
         * Specify only when <code>Field</code> is <code>source-ip</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-rulecondition.html#cfn-elasticloadbalancingv2-listenerrule-rulecondition-sourceipconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-rulecondition.html#cfn-elasticloadbalancingv2-listenerrule-rulecondition-sourceipconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSourceIpConfig() {
            return null;
        }

        /**
         * The condition value.
         * <p>
         * Specify only when <code>Field</code> is <code>host-header</code> or <code>path-pattern</code> . Alternatively, to specify multiple host names or multiple path patterns, use <code>HostHeaderConfig</code> or <code>PathPatternConfig</code> .
         * <p>
         * If <code>Field</code> is <code>host-header</code> and you're not using <code>HostHeaderConfig</code> , you can specify a single host name (for example, my.example.com). A host name is case insensitive, can be up to 128 characters in length, and can contain any of the following characters.
         * <p>
         * <ul>
         * <li>A-Z, a-z, 0-9</li>
         * <li><ul>
         * <li>.</li>
         * </ul></li>
         * <li><ul>
         * <li>(matches 0 or more characters)</li>
         * </ul></li>
         * <li>? (matches exactly 1 character)</li>
         * </ul>
         * <p>
         * If <code>Field</code> is <code>path-pattern</code> and you're not using <code>PathPatternConfig</code> , you can specify a single path pattern (for example, /img/*). A path pattern is case-sensitive, can be up to 128 characters in length, and can contain any of the following characters.
         * <p>
         * <ul>
         * <li>A-Z, a-z, 0-9</li>
         * <li>_ - . $ / ~ " ' &#64; : +</li>
         * <li>&amp; (using &amp;)</li>
         * <li><ul>
         * <li>(matches 0 or more characters)</li>
         * </ul></li>
         * <li>? (matches exactly 1 character)</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-rulecondition.html#cfn-elasticloadbalancingv2-listenerrule-rulecondition-values">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-rulecondition.html#cfn-elasticloadbalancingv2-listenerrule-rulecondition-values</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getValues() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RuleConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RuleConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RuleConditionProperty> {
            java.lang.String field;
            java.lang.Object hostHeaderConfig;
            java.lang.Object httpHeaderConfig;
            java.lang.Object httpRequestMethodConfig;
            java.lang.Object pathPatternConfig;
            java.lang.Object queryStringConfig;
            java.lang.Object sourceIpConfig;
            java.util.List<java.lang.String> values;

            /**
             * Sets the value of {@link RuleConditionProperty#getField}
             * @param field The field in the HTTP request. The following are the possible values:.
             *              <ul>
             *              <li><code>http-header</code></li>
             *              <li><code>http-request-method</code></li>
             *              <li><code>host-header</code></li>
             *              <li><code>path-pattern</code></li>
             *              <li><code>query-string</code></li>
             *              <li><code>source-ip</code></li>
             *              </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder field(java.lang.String field) {
                this.field = field;
                return this;
            }

            /**
             * Sets the value of {@link RuleConditionProperty#getHostHeaderConfig}
             * @param hostHeaderConfig Information for a host header condition.
             *                         Specify only when <code>Field</code> is <code>host-header</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostHeaderConfig(software.amazon.awscdk.IResolvable hostHeaderConfig) {
                this.hostHeaderConfig = hostHeaderConfig;
                return this;
            }

            /**
             * Sets the value of {@link RuleConditionProperty#getHostHeaderConfig}
             * @param hostHeaderConfig Information for a host header condition.
             *                         Specify only when <code>Field</code> is <code>host-header</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostHeaderConfig(software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.HostHeaderConfigProperty hostHeaderConfig) {
                this.hostHeaderConfig = hostHeaderConfig;
                return this;
            }

            /**
             * Sets the value of {@link RuleConditionProperty#getHttpHeaderConfig}
             * @param httpHeaderConfig Information for an HTTP header condition.
             *                         Specify only when <code>Field</code> is <code>http-header</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpHeaderConfig(software.amazon.awscdk.IResolvable httpHeaderConfig) {
                this.httpHeaderConfig = httpHeaderConfig;
                return this;
            }

            /**
             * Sets the value of {@link RuleConditionProperty#getHttpHeaderConfig}
             * @param httpHeaderConfig Information for an HTTP header condition.
             *                         Specify only when <code>Field</code> is <code>http-header</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpHeaderConfig(software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.HttpHeaderConfigProperty httpHeaderConfig) {
                this.httpHeaderConfig = httpHeaderConfig;
                return this;
            }

            /**
             * Sets the value of {@link RuleConditionProperty#getHttpRequestMethodConfig}
             * @param httpRequestMethodConfig Information for an HTTP method condition.
             *                                Specify only when <code>Field</code> is <code>http-request-method</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpRequestMethodConfig(software.amazon.awscdk.IResolvable httpRequestMethodConfig) {
                this.httpRequestMethodConfig = httpRequestMethodConfig;
                return this;
            }

            /**
             * Sets the value of {@link RuleConditionProperty#getHttpRequestMethodConfig}
             * @param httpRequestMethodConfig Information for an HTTP method condition.
             *                                Specify only when <code>Field</code> is <code>http-request-method</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpRequestMethodConfig(software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.HttpRequestMethodConfigProperty httpRequestMethodConfig) {
                this.httpRequestMethodConfig = httpRequestMethodConfig;
                return this;
            }

            /**
             * Sets the value of {@link RuleConditionProperty#getPathPatternConfig}
             * @param pathPatternConfig Information for a path pattern condition.
             *                          Specify only when <code>Field</code> is <code>path-pattern</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pathPatternConfig(software.amazon.awscdk.IResolvable pathPatternConfig) {
                this.pathPatternConfig = pathPatternConfig;
                return this;
            }

            /**
             * Sets the value of {@link RuleConditionProperty#getPathPatternConfig}
             * @param pathPatternConfig Information for a path pattern condition.
             *                          Specify only when <code>Field</code> is <code>path-pattern</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pathPatternConfig(software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.PathPatternConfigProperty pathPatternConfig) {
                this.pathPatternConfig = pathPatternConfig;
                return this;
            }

            /**
             * Sets the value of {@link RuleConditionProperty#getQueryStringConfig}
             * @param queryStringConfig Information for a query string condition.
             *                          Specify only when <code>Field</code> is <code>query-string</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryStringConfig(software.amazon.awscdk.IResolvable queryStringConfig) {
                this.queryStringConfig = queryStringConfig;
                return this;
            }

            /**
             * Sets the value of {@link RuleConditionProperty#getQueryStringConfig}
             * @param queryStringConfig Information for a query string condition.
             *                          Specify only when <code>Field</code> is <code>query-string</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryStringConfig(software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.QueryStringConfigProperty queryStringConfig) {
                this.queryStringConfig = queryStringConfig;
                return this;
            }

            /**
             * Sets the value of {@link RuleConditionProperty#getSourceIpConfig}
             * @param sourceIpConfig Information for a source IP condition.
             *                       Specify only when <code>Field</code> is <code>source-ip</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceIpConfig(software.amazon.awscdk.IResolvable sourceIpConfig) {
                this.sourceIpConfig = sourceIpConfig;
                return this;
            }

            /**
             * Sets the value of {@link RuleConditionProperty#getSourceIpConfig}
             * @param sourceIpConfig Information for a source IP condition.
             *                       Specify only when <code>Field</code> is <code>source-ip</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceIpConfig(software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.SourceIpConfigProperty sourceIpConfig) {
                this.sourceIpConfig = sourceIpConfig;
                return this;
            }

            /**
             * Sets the value of {@link RuleConditionProperty#getValues}
             * @param values The condition value.
             *               Specify only when <code>Field</code> is <code>host-header</code> or <code>path-pattern</code> . Alternatively, to specify multiple host names or multiple path patterns, use <code>HostHeaderConfig</code> or <code>PathPatternConfig</code> .
             *               <p>
             *               If <code>Field</code> is <code>host-header</code> and you're not using <code>HostHeaderConfig</code> , you can specify a single host name (for example, my.example.com). A host name is case insensitive, can be up to 128 characters in length, and can contain any of the following characters.
             *               <p>
             *               <ul>
             *               <li>A-Z, a-z, 0-9</li>
             *               <li><ul>
             *               <li>.</li>
             *               </ul></li>
             *               <li><ul>
             *               <li>(matches 0 or more characters)</li>
             *               </ul></li>
             *               <li>? (matches exactly 1 character)</li>
             *               </ul>
             *               <p>
             *               If <code>Field</code> is <code>path-pattern</code> and you're not using <code>PathPatternConfig</code> , you can specify a single path pattern (for example, /img/*). A path pattern is case-sensitive, can be up to 128 characters in length, and can contain any of the following characters.
             *               <p>
             *               <ul>
             *               <li>A-Z, a-z, 0-9</li>
             *               <li>_ - . $ / ~ " ' &#64; : +</li>
             *               <li>&amp; (using &amp;)</li>
             *               <li><ul>
             *               <li>(matches 0 or more characters)</li>
             *               </ul></li>
             *               <li>? (matches exactly 1 character)</li>
             *               </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<java.lang.String> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RuleConditionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RuleConditionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RuleConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuleConditionProperty {
            private final java.lang.String field;
            private final java.lang.Object hostHeaderConfig;
            private final java.lang.Object httpHeaderConfig;
            private final java.lang.Object httpRequestMethodConfig;
            private final java.lang.Object pathPatternConfig;
            private final java.lang.Object queryStringConfig;
            private final java.lang.Object sourceIpConfig;
            private final java.util.List<java.lang.String> values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.field = software.amazon.jsii.Kernel.get(this, "field", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.hostHeaderConfig = software.amazon.jsii.Kernel.get(this, "hostHeaderConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.httpHeaderConfig = software.amazon.jsii.Kernel.get(this, "httpHeaderConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.httpRequestMethodConfig = software.amazon.jsii.Kernel.get(this, "httpRequestMethodConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.pathPatternConfig = software.amazon.jsii.Kernel.get(this, "pathPatternConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.queryStringConfig = software.amazon.jsii.Kernel.get(this, "queryStringConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sourceIpConfig = software.amazon.jsii.Kernel.get(this, "sourceIpConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.field = builder.field;
                this.hostHeaderConfig = builder.hostHeaderConfig;
                this.httpHeaderConfig = builder.httpHeaderConfig;
                this.httpRequestMethodConfig = builder.httpRequestMethodConfig;
                this.pathPatternConfig = builder.pathPatternConfig;
                this.queryStringConfig = builder.queryStringConfig;
                this.sourceIpConfig = builder.sourceIpConfig;
                this.values = builder.values;
            }

            @Override
            public final java.lang.String getField() {
                return this.field;
            }

            @Override
            public final java.lang.Object getHostHeaderConfig() {
                return this.hostHeaderConfig;
            }

            @Override
            public final java.lang.Object getHttpHeaderConfig() {
                return this.httpHeaderConfig;
            }

            @Override
            public final java.lang.Object getHttpRequestMethodConfig() {
                return this.httpRequestMethodConfig;
            }

            @Override
            public final java.lang.Object getPathPatternConfig() {
                return this.pathPatternConfig;
            }

            @Override
            public final java.lang.Object getQueryStringConfig() {
                return this.queryStringConfig;
            }

            @Override
            public final java.lang.Object getSourceIpConfig() {
                return this.sourceIpConfig;
            }

            @Override
            public final java.util.List<java.lang.String> getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getField() != null) {
                    data.set("field", om.valueToTree(this.getField()));
                }
                if (this.getHostHeaderConfig() != null) {
                    data.set("hostHeaderConfig", om.valueToTree(this.getHostHeaderConfig()));
                }
                if (this.getHttpHeaderConfig() != null) {
                    data.set("httpHeaderConfig", om.valueToTree(this.getHttpHeaderConfig()));
                }
                if (this.getHttpRequestMethodConfig() != null) {
                    data.set("httpRequestMethodConfig", om.valueToTree(this.getHttpRequestMethodConfig()));
                }
                if (this.getPathPatternConfig() != null) {
                    data.set("pathPatternConfig", om.valueToTree(this.getPathPatternConfig()));
                }
                if (this.getQueryStringConfig() != null) {
                    data.set("queryStringConfig", om.valueToTree(this.getQueryStringConfig()));
                }
                if (this.getSourceIpConfig() != null) {
                    data.set("sourceIpConfig", om.valueToTree(this.getSourceIpConfig()));
                }
                if (this.getValues() != null) {
                    data.set("values", om.valueToTree(this.getValues()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticloadbalancingv2.CfnListenerRule.RuleConditionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RuleConditionProperty.Jsii$Proxy that = (RuleConditionProperty.Jsii$Proxy) o;

                if (this.field != null ? !this.field.equals(that.field) : that.field != null) return false;
                if (this.hostHeaderConfig != null ? !this.hostHeaderConfig.equals(that.hostHeaderConfig) : that.hostHeaderConfig != null) return false;
                if (this.httpHeaderConfig != null ? !this.httpHeaderConfig.equals(that.httpHeaderConfig) : that.httpHeaderConfig != null) return false;
                if (this.httpRequestMethodConfig != null ? !this.httpRequestMethodConfig.equals(that.httpRequestMethodConfig) : that.httpRequestMethodConfig != null) return false;
                if (this.pathPatternConfig != null ? !this.pathPatternConfig.equals(that.pathPatternConfig) : that.pathPatternConfig != null) return false;
                if (this.queryStringConfig != null ? !this.queryStringConfig.equals(that.queryStringConfig) : that.queryStringConfig != null) return false;
                if (this.sourceIpConfig != null ? !this.sourceIpConfig.equals(that.sourceIpConfig) : that.sourceIpConfig != null) return false;
                return this.values != null ? this.values.equals(that.values) : that.values == null;
            }

            @Override
            public final int hashCode() {
                int result = this.field != null ? this.field.hashCode() : 0;
                result = 31 * result + (this.hostHeaderConfig != null ? this.hostHeaderConfig.hashCode() : 0);
                result = 31 * result + (this.httpHeaderConfig != null ? this.httpHeaderConfig.hashCode() : 0);
                result = 31 * result + (this.httpRequestMethodConfig != null ? this.httpRequestMethodConfig.hashCode() : 0);
                result = 31 * result + (this.pathPatternConfig != null ? this.pathPatternConfig.hashCode() : 0);
                result = 31 * result + (this.queryStringConfig != null ? this.queryStringConfig.hashCode() : 0);
                result = 31 * result + (this.sourceIpConfig != null ? this.sourceIpConfig.hashCode() : 0);
                result = 31 * result + (this.values != null ? this.values.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about a source IP condition.
     * <p>
     * You can use this condition to route based on the IP address of the source that connects to the load balancer. If a client is behind a proxy, this is the IP address of the proxy not the IP address of the client.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
     * SourceIpConfigProperty sourceIpConfigProperty = SourceIpConfigProperty.builder()
     *         .values(List.of("values"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-sourceipconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-sourceipconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.CfnListenerRule.SourceIpConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(SourceIpConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SourceIpConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The source IP addresses, in CIDR format. You can use both IPv4 and IPv6 addresses. Wildcards are not supported.
         * <p>
         * If you specify multiple addresses, the condition is satisfied if the source IP address of the request matches one of the CIDR blocks. This condition is not satisfied by the addresses in the X-Forwarded-For header.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-sourceipconfig.html#cfn-elasticloadbalancingv2-listenerrule-sourceipconfig-values">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-sourceipconfig.html#cfn-elasticloadbalancingv2-listenerrule-sourceipconfig-values</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getValues() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SourceIpConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SourceIpConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SourceIpConfigProperty> {
            java.util.List<java.lang.String> values;

            /**
             * Sets the value of {@link SourceIpConfigProperty#getValues}
             * @param values The source IP addresses, in CIDR format. You can use both IPv4 and IPv6 addresses. Wildcards are not supported.
             *               If you specify multiple addresses, the condition is satisfied if the source IP address of the request matches one of the CIDR blocks. This condition is not satisfied by the addresses in the X-Forwarded-For header.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<java.lang.String> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceIpConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SourceIpConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SourceIpConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceIpConfigProperty {
            private final java.util.List<java.lang.String> values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.values = builder.values;
            }

            @Override
            public final java.util.List<java.lang.String> getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getValues() != null) {
                    data.set("values", om.valueToTree(this.getValues()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticloadbalancingv2.CfnListenerRule.SourceIpConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SourceIpConfigProperty.Jsii$Proxy that = (SourceIpConfigProperty.Jsii$Proxy) o;

                return this.values != null ? this.values.equals(that.values) : that.values == null;
            }

            @Override
            public final int hashCode() {
                int result = this.values != null ? this.values.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Information about the target group stickiness for a rule.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
     * TargetGroupStickinessConfigProperty targetGroupStickinessConfigProperty = TargetGroupStickinessConfigProperty.builder()
     *         .durationSeconds(123)
     *         .enabled(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-targetgroupstickinessconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-targetgroupstickinessconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.CfnListenerRule.TargetGroupStickinessConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(TargetGroupStickinessConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TargetGroupStickinessConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The time period, in seconds, during which requests from a client should be routed to the same target group.
         * <p>
         * The range is 1-604800 seconds (7 days).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-targetgroupstickinessconfig.html#cfn-elasticloadbalancingv2-listenerrule-targetgroupstickinessconfig-durationseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-targetgroupstickinessconfig.html#cfn-elasticloadbalancingv2-listenerrule-targetgroupstickinessconfig-durationseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDurationSeconds() {
            return null;
        }

        /**
         * Indicates whether target group stickiness is enabled.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-targetgroupstickinessconfig.html#cfn-elasticloadbalancingv2-listenerrule-targetgroupstickinessconfig-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-targetgroupstickinessconfig.html#cfn-elasticloadbalancingv2-listenerrule-targetgroupstickinessconfig-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TargetGroupStickinessConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TargetGroupStickinessConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TargetGroupStickinessConfigProperty> {
            java.lang.Number durationSeconds;
            java.lang.Object enabled;

            /**
             * Sets the value of {@link TargetGroupStickinessConfigProperty#getDurationSeconds}
             * @param durationSeconds The time period, in seconds, during which requests from a client should be routed to the same target group.
             *                        The range is 1-604800 seconds (7 days).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder durationSeconds(java.lang.Number durationSeconds) {
                this.durationSeconds = durationSeconds;
                return this;
            }

            /**
             * Sets the value of {@link TargetGroupStickinessConfigProperty#getEnabled}
             * @param enabled Indicates whether target group stickiness is enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link TargetGroupStickinessConfigProperty#getEnabled}
             * @param enabled Indicates whether target group stickiness is enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetGroupStickinessConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TargetGroupStickinessConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TargetGroupStickinessConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetGroupStickinessConfigProperty {
            private final java.lang.Number durationSeconds;
            private final java.lang.Object enabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.durationSeconds = software.amazon.jsii.Kernel.get(this, "durationSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.durationSeconds = builder.durationSeconds;
                this.enabled = builder.enabled;
            }

            @Override
            public final java.lang.Number getDurationSeconds() {
                return this.durationSeconds;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDurationSeconds() != null) {
                    data.set("durationSeconds", om.valueToTree(this.getDurationSeconds()));
                }
                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticloadbalancingv2.CfnListenerRule.TargetGroupStickinessConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TargetGroupStickinessConfigProperty.Jsii$Proxy that = (TargetGroupStickinessConfigProperty.Jsii$Proxy) o;

                if (this.durationSeconds != null ? !this.durationSeconds.equals(that.durationSeconds) : that.durationSeconds != null) return false;
                return this.enabled != null ? this.enabled.equals(that.enabled) : that.enabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.durationSeconds != null ? this.durationSeconds.hashCode() : 0;
                result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about how traffic will be distributed between multiple target groups in a forward rule.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
     * TargetGroupTupleProperty targetGroupTupleProperty = TargetGroupTupleProperty.builder()
     *         .targetGroupArn("targetGroupArn")
     *         .weight(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-targetgrouptuple.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-targetgrouptuple.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.CfnListenerRule.TargetGroupTupleProperty")
    @software.amazon.jsii.Jsii.Proxy(TargetGroupTupleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TargetGroupTupleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the target group.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-targetgrouptuple.html#cfn-elasticloadbalancingv2-listenerrule-targetgrouptuple-targetgrouparn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-targetgrouptuple.html#cfn-elasticloadbalancingv2-listenerrule-targetgrouptuple-targetgrouparn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTargetGroupArn() {
            return null;
        }

        /**
         * The weight.
         * <p>
         * The range is 0 to 999.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-targetgrouptuple.html#cfn-elasticloadbalancingv2-listenerrule-targetgrouptuple-weight">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listenerrule-targetgrouptuple.html#cfn-elasticloadbalancingv2-listenerrule-targetgrouptuple-weight</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getWeight() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TargetGroupTupleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TargetGroupTupleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TargetGroupTupleProperty> {
            java.lang.String targetGroupArn;
            java.lang.Number weight;

            /**
             * Sets the value of {@link TargetGroupTupleProperty#getTargetGroupArn}
             * @param targetGroupArn The Amazon Resource Name (ARN) of the target group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetGroupArn(java.lang.String targetGroupArn) {
                this.targetGroupArn = targetGroupArn;
                return this;
            }

            /**
             * Sets the value of {@link TargetGroupTupleProperty#getWeight}
             * @param weight The weight.
             *               The range is 0 to 999.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weight(java.lang.Number weight) {
                this.weight = weight;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetGroupTupleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TargetGroupTupleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TargetGroupTupleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetGroupTupleProperty {
            private final java.lang.String targetGroupArn;
            private final java.lang.Number weight;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.targetGroupArn = software.amazon.jsii.Kernel.get(this, "targetGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.weight = software.amazon.jsii.Kernel.get(this, "weight", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.targetGroupArn = builder.targetGroupArn;
                this.weight = builder.weight;
            }

            @Override
            public final java.lang.String getTargetGroupArn() {
                return this.targetGroupArn;
            }

            @Override
            public final java.lang.Number getWeight() {
                return this.weight;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getTargetGroupArn() != null) {
                    data.set("targetGroupArn", om.valueToTree(this.getTargetGroupArn()));
                }
                if (this.getWeight() != null) {
                    data.set("weight", om.valueToTree(this.getWeight()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticloadbalancingv2.CfnListenerRule.TargetGroupTupleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TargetGroupTupleProperty.Jsii$Proxy that = (TargetGroupTupleProperty.Jsii$Proxy) o;

                if (this.targetGroupArn != null ? !this.targetGroupArn.equals(that.targetGroupArn) : that.targetGroupArn != null) return false;
                return this.weight != null ? this.weight.equals(that.weight) : that.weight == null;
            }

            @Override
            public final int hashCode() {
                int result = this.targetGroupArn != null ? this.targetGroupArn.hashCode() : 0;
                result = 31 * result + (this.weight != null ? this.weight.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRuleProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRuleProps.Builder();
        }

        /**
         * The actions.
         * <p>
         * The rule must include exactly one of the following types of actions: <code>forward</code> , <code>fixed-response</code> , or <code>redirect</code> , and it must be the last action to be performed. If the rule is for an HTTPS listener, it can also optionally include an authentication action.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-actions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-actions</a>
         * @param actions The actions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actions(final software.amazon.awscdk.IResolvable actions) {
            this.props.actions(actions);
            return this;
        }
        /**
         * The actions.
         * <p>
         * The rule must include exactly one of the following types of actions: <code>forward</code> , <code>fixed-response</code> , or <code>redirect</code> , and it must be the last action to be performed. If the rule is for an HTTPS listener, it can also optionally include an authentication action.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-actions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-actions</a>
         * @param actions The actions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actions(final java.util.List<? extends java.lang.Object> actions) {
            this.props.actions(actions);
            return this;
        }

        /**
         * The conditions.
         * <p>
         * The rule can optionally include up to one of each of the following conditions: <code>http-request-method</code> , <code>host-header</code> , <code>path-pattern</code> , and <code>source-ip</code> . A rule can also optionally include one or more of each of the following conditions: <code>http-header</code> and <code>query-string</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-conditions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-conditions</a>
         * @param conditions The conditions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder conditions(final software.amazon.awscdk.IResolvable conditions) {
            this.props.conditions(conditions);
            return this;
        }
        /**
         * The conditions.
         * <p>
         * The rule can optionally include up to one of each of the following conditions: <code>http-request-method</code> , <code>host-header</code> , <code>path-pattern</code> , and <code>source-ip</code> . A rule can also optionally include one or more of each of the following conditions: <code>http-header</code> and <code>query-string</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-conditions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-conditions</a>
         * @param conditions The conditions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder conditions(final java.util.List<? extends java.lang.Object> conditions) {
            this.props.conditions(conditions);
            return this;
        }

        /**
         * The rule priority. A listener can't have multiple rules with the same priority.
         * <p>
         * If you try to reorder rules by updating their priorities, do not specify a new priority if an existing rule already uses this priority, as this can cause an error. If you need to reuse a priority with a different rule, you must remove it as a priority first, and then specify it in a subsequent update.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-priority">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-priority</a>
         * @param priority The rule priority. A listener can't have multiple rules with the same priority. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder priority(final java.lang.Number priority) {
            this.props.priority(priority);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the listener.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-listenerarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenerrule.html#cfn-elasticloadbalancingv2-listenerrule-listenerarn</a>
         * @param listenerArn The Amazon Resource Name (ARN) of the listener. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder listenerArn(final java.lang.String listenerArn) {
            this.props.listenerArn(listenerArn);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule build() {
            return new software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
