package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Result of attaching a target to load balancer.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
 * Object targetJson;
 * LoadBalancerTargetProps loadBalancerTargetProps = LoadBalancerTargetProps.builder()
 *         .targetType(TargetType.INSTANCE)
 *         // the properties below are optional
 *         .targetJson(targetJson)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:24:58.374Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.LoadBalancerTargetProps")
@software.amazon.jsii.Jsii.Proxy(LoadBalancerTargetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LoadBalancerTargetProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * What kind of target this is.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.TargetType getTargetType();

    /**
     * JSON representing the target's direct addition to the TargetGroup list.
     * <p>
     * May be omitted if the target is going to register itself later.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTargetJson() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LoadBalancerTargetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LoadBalancerTargetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LoadBalancerTargetProps> {
        software.amazon.awscdk.services.elasticloadbalancingv2.TargetType targetType;
        java.lang.Object targetJson;

        /**
         * Sets the value of {@link LoadBalancerTargetProps#getTargetType}
         * @param targetType What kind of target this is. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetType(software.amazon.awscdk.services.elasticloadbalancingv2.TargetType targetType) {
            this.targetType = targetType;
            return this;
        }

        /**
         * Sets the value of {@link LoadBalancerTargetProps#getTargetJson}
         * @param targetJson JSON representing the target's direct addition to the TargetGroup list.
         *                   May be omitted if the target is going to register itself later.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetJson(java.lang.Object targetJson) {
            this.targetJson = targetJson;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LoadBalancerTargetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LoadBalancerTargetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LoadBalancerTargetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoadBalancerTargetProps {
        private final software.amazon.awscdk.services.elasticloadbalancingv2.TargetType targetType;
        private final java.lang.Object targetJson;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.targetType = software.amazon.jsii.Kernel.get(this, "targetType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.TargetType.class));
            this.targetJson = software.amazon.jsii.Kernel.get(this, "targetJson", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.targetType = java.util.Objects.requireNonNull(builder.targetType, "targetType is required");
            this.targetJson = builder.targetJson;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancingv2.TargetType getTargetType() {
            return this.targetType;
        }

        @Override
        public final java.lang.Object getTargetJson() {
            return this.targetJson;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("targetType", om.valueToTree(this.getTargetType()));
            if (this.getTargetJson() != null) {
                data.set("targetJson", om.valueToTree(this.getTargetJson()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticloadbalancingv2.LoadBalancerTargetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LoadBalancerTargetProps.Jsii$Proxy that = (LoadBalancerTargetProps.Jsii$Proxy) o;

            if (!targetType.equals(that.targetType)) return false;
            return this.targetJson != null ? this.targetJson.equals(that.targetJson) : that.targetJson == null;
        }

        @Override
        public final int hashCode() {
            int result = this.targetType.hashCode();
            result = 31 * result + (this.targetJson != null ? this.targetJson.hashCode() : 0);
            return result;
        }
    }
}
