package software.amazon.awscdk.services.emr;

/**
 * Use <code>InstanceFleetConfig</code> to define instance fleets for an EMR cluster.
 * <p>
 * A cluster can not use both instance fleets and instance groups. For more information, see <a href="https://docs.aws.amazon.com//emr/latest/ManagementGuide/emr-instance-group-configuration.html">Configure Instance Fleets</a> in the <em>Amazon EMR Management Guide</em> .
 * <p>
 * <blockquote>
 * <p>
 * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions. &gt; You can currently only add a task instance fleet to a cluster with this resource. If you use this resource, CloudFormation waits for the cluster launch to complete before adding the task instance fleet to the cluster. In order to add a task instance fleet to the cluster as part of the cluster launch and minimize delays in provisioning task nodes, use the <code>TaskInstanceFleets</code> subproperty for the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticmapreduce-cluster-jobflowinstancesconfig.html">AWS::EMR::Cluster JobFlowInstancesConfig</a> property instead. To use this subproperty, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticmapreduce-cluster.html">AWS::EMR::Cluster</a> for examples.
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.emr.*;
 * ConfigurationProperty configurationProperty_;
 * CfnInstanceFleetConfig cfnInstanceFleetConfig = CfnInstanceFleetConfig.Builder.create(this, "MyCfnInstanceFleetConfig")
 *         .clusterId("clusterId")
 *         .instanceFleetType("instanceFleetType")
 *         // the properties below are optional
 *         .instanceTypeConfigs(List.of(InstanceTypeConfigProperty.builder()
 *                 .instanceType("instanceType")
 *                 // the properties below are optional
 *                 .bidPrice("bidPrice")
 *                 .bidPriceAsPercentageOfOnDemandPrice(123)
 *                 .configurations(List.of(ConfigurationProperty.builder()
 *                         .classification("classification")
 *                         .configurationProperties(Map.of(
 *                                 "configurationPropertiesKey", "configurationProperties"))
 *                         .configurations(List.of(configurationProperty_))
 *                         .build()))
 *                 .customAmiId("customAmiId")
 *                 .ebsConfiguration(EbsConfigurationProperty.builder()
 *                         .ebsBlockDeviceConfigs(List.of(EbsBlockDeviceConfigProperty.builder()
 *                                 .volumeSpecification(VolumeSpecificationProperty.builder()
 *                                         .sizeInGb(123)
 *                                         .volumeType("volumeType")
 *                                         // the properties below are optional
 *                                         .iops(123)
 *                                         .throughput(123)
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .volumesPerInstance(123)
 *                                 .build()))
 *                         .ebsOptimized(false)
 *                         .build())
 *                 .priority(123)
 *                 .weightedCapacity(123)
 *                 .build()))
 *         .launchSpecifications(InstanceFleetProvisioningSpecificationsProperty.builder()
 *                 .onDemandSpecification(OnDemandProvisioningSpecificationProperty.builder()
 *                         .allocationStrategy("allocationStrategy")
 *                         // the properties below are optional
 *                         .capacityReservationOptions(OnDemandCapacityReservationOptionsProperty.builder()
 *                                 .capacityReservationPreference("capacityReservationPreference")
 *                                 .capacityReservationResourceGroupArn("capacityReservationResourceGroupArn")
 *                                 .usageStrategy("usageStrategy")
 *                                 .build())
 *                         .build())
 *                 .spotSpecification(SpotProvisioningSpecificationProperty.builder()
 *                         .timeoutAction("timeoutAction")
 *                         .timeoutDurationMinutes(123)
 *                         // the properties below are optional
 *                         .allocationStrategy("allocationStrategy")
 *                         .blockDurationMinutes(123)
 *                         .build())
 *                 .build())
 *         .name("name")
 *         .resizeSpecifications(InstanceFleetResizingSpecificationsProperty.builder()
 *                 .onDemandResizeSpecification(OnDemandResizingSpecificationProperty.builder()
 *                         .allocationStrategy("allocationStrategy")
 *                         .capacityReservationOptions(OnDemandCapacityReservationOptionsProperty.builder()
 *                                 .capacityReservationPreference("capacityReservationPreference")
 *                                 .capacityReservationResourceGroupArn("capacityReservationResourceGroupArn")
 *                                 .usageStrategy("usageStrategy")
 *                                 .build())
 *                         .timeoutDurationMinutes(123)
 *                         .build())
 *                 .spotResizeSpecification(SpotResizingSpecificationProperty.builder()
 *                         .allocationStrategy("allocationStrategy")
 *                         .timeoutDurationMinutes(123)
 *                         .build())
 *                 .build())
 *         .targetOnDemandCapacity(123)
 *         .targetSpotCapacity(123)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancefleetconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancefleetconfig.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:24:58.513Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emr.CfnInstanceFleetConfig")
public class CfnInstanceFleetConfig extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnInstanceFleetConfig(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnInstanceFleetConfig(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.emr.CfnInstanceFleetConfig.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnInstanceFleetConfig(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.emr.CfnInstanceFleetConfigProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The unique identifier of the EMR cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getClusterId() {
        return software.amazon.jsii.Kernel.get(this, "clusterId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier of the EMR cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClusterId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "clusterId", java.util.Objects.requireNonNull(value, "clusterId is required"));
    }

    /**
     * The node type that the instance fleet hosts.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getInstanceFleetType() {
        return software.amazon.jsii.Kernel.get(this, "instanceFleetType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The node type that the instance fleet hosts.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceFleetType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "instanceFleetType", java.util.Objects.requireNonNull(value, "instanceFleetType is required"));
    }

    /**
     * <code>InstanceTypeConfigs</code> determine the EC2 instances that Amazon EMR attempts to provision to fulfill On-Demand and Spot target capacities.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getInstanceTypeConfigs() {
        return software.amazon.jsii.Kernel.get(this, "instanceTypeConfigs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * <code>InstanceTypeConfigs</code> determine the EC2 instances that Amazon EMR attempts to provision to fulfill On-Demand and Spot target capacities.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceTypeConfigs(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "instanceTypeConfigs", value);
    }

    /**
     * <code>InstanceTypeConfigs</code> determine the EC2 instances that Amazon EMR attempts to provision to fulfill On-Demand and Spot target capacities.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInstanceTypeConfigs(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.emr.CfnInstanceFleetConfig.InstanceTypeConfigProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.emr.CfnInstanceFleetConfig.InstanceTypeConfigProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "instanceTypeConfigs", value);
    }

    /**
     * The launch specification for the instance fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLaunchSpecifications() {
        return software.amazon.jsii.Kernel.get(this, "launchSpecifications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The launch specification for the instance fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLaunchSpecifications(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "launchSpecifications", value);
    }

    /**
     * The launch specification for the instance fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLaunchSpecifications(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.emr.CfnInstanceFleetConfig.InstanceFleetProvisioningSpecificationsProperty value) {
        software.amazon.jsii.Kernel.set(this, "launchSpecifications", value);
    }

    /**
     * The friendly name of the instance fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The friendly name of the instance fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * The resize specification for the instance fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getResizeSpecifications() {
        return software.amazon.jsii.Kernel.get(this, "resizeSpecifications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The resize specification for the instance fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResizeSpecifications(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "resizeSpecifications", value);
    }

    /**
     * The resize specification for the instance fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResizeSpecifications(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.emr.CfnInstanceFleetConfig.InstanceFleetResizingSpecificationsProperty value) {
        software.amazon.jsii.Kernel.set(this, "resizeSpecifications", value);
    }

    /**
     * The target capacity of On-Demand units for the instance fleet, which determines how many On-Demand instances to provision.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getTargetOnDemandCapacity() {
        return software.amazon.jsii.Kernel.get(this, "targetOnDemandCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The target capacity of On-Demand units for the instance fleet, which determines how many On-Demand instances to provision.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargetOnDemandCapacity(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "targetOnDemandCapacity", value);
    }

    /**
     * The target capacity of Spot units for the instance fleet, which determines how many Spot instances to provision.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getTargetSpotCapacity() {
        return software.amazon.jsii.Kernel.get(this, "targetSpotCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The target capacity of Spot units for the instance fleet, which determines how many Spot instances to provision.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargetSpotCapacity(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "targetSpotCapacity", value);
    }
    /**
     * <blockquote><p>Used only with Amazon EMR release 4.0 and later.<p></blockquote>
     * <p>
     * <code>Configuration</code> specifies optional configurations for customizing open-source big data applications and environment parameters. A configuration consists of a classification, properties, and optional nested configurations. A classification refers to an application-specific configuration file. Properties are the settings you want to change in that file. For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-configure-apps.html">Configuring Applications</a> in the <em>Amazon EMR Release Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * ConfigurationProperty configurationProperty_;
     * ConfigurationProperty configurationProperty = ConfigurationProperty.builder()
     *         .classification("classification")
     *         .configurationProperties(Map.of(
     *                 "configurationPropertiesKey", "configurationProperties"))
     *         .configurations(List.of(configurationProperty_))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-configuration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-configuration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emr.CfnInstanceFleetConfig.ConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The classification within a configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-configuration.html#cfn-emr-instancefleetconfig-configuration-classification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-configuration.html#cfn-emr-instancefleetconfig-configuration-classification</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getClassification() {
            return null;
        }

        /**
         * Within a configuration classification, a set of properties that represent the settings that you want to change in the configuration file.
         * <p>
         * Duplicates not allowed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-configuration.html#cfn-emr-instancefleetconfig-configuration-configurationproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-configuration.html#cfn-emr-instancefleetconfig-configuration-configurationproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConfigurationProperties() {
            return null;
        }

        /**
         * A list of additional configurations to apply within a configuration object.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-configuration.html#cfn-emr-instancefleetconfig-configuration-configurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-configuration.html#cfn-emr-instancefleetconfig-configuration-configurations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConfigurations() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConfigurationProperty> {
            java.lang.String classification;
            java.lang.Object configurationProperties;
            java.lang.Object configurations;

            /**
             * Sets the value of {@link ConfigurationProperty#getClassification}
             * @param classification The classification within a configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder classification(java.lang.String classification) {
                this.classification = classification;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationProperty#getConfigurationProperties}
             * @param configurationProperties Within a configuration classification, a set of properties that represent the settings that you want to change in the configuration file.
             *                                Duplicates not allowed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configurationProperties(java.util.Map<java.lang.String, java.lang.String> configurationProperties) {
                this.configurationProperties = configurationProperties;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationProperty#getConfigurationProperties}
             * @param configurationProperties Within a configuration classification, a set of properties that represent the settings that you want to change in the configuration file.
             *                                Duplicates not allowed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configurationProperties(software.amazon.awscdk.IResolvable configurationProperties) {
                this.configurationProperties = configurationProperties;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationProperty#getConfigurations}
             * @param configurations A list of additional configurations to apply within a configuration object.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configurations(software.amazon.awscdk.IResolvable configurations) {
                this.configurations = configurations;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationProperty#getConfigurations}
             * @param configurations A list of additional configurations to apply within a configuration object.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configurations(java.util.List<? extends java.lang.Object> configurations) {
                this.configurations = configurations;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConfigurationProperty {
            private final java.lang.String classification;
            private final java.lang.Object configurationProperties;
            private final java.lang.Object configurations;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.classification = software.amazon.jsii.Kernel.get(this, "classification", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.configurationProperties = software.amazon.jsii.Kernel.get(this, "configurationProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.configurations = software.amazon.jsii.Kernel.get(this, "configurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.classification = builder.classification;
                this.configurationProperties = builder.configurationProperties;
                this.configurations = builder.configurations;
            }

            @Override
            public final java.lang.String getClassification() {
                return this.classification;
            }

            @Override
            public final java.lang.Object getConfigurationProperties() {
                return this.configurationProperties;
            }

            @Override
            public final java.lang.Object getConfigurations() {
                return this.configurations;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getClassification() != null) {
                    data.set("classification", om.valueToTree(this.getClassification()));
                }
                if (this.getConfigurationProperties() != null) {
                    data.set("configurationProperties", om.valueToTree(this.getConfigurationProperties()));
                }
                if (this.getConfigurations() != null) {
                    data.set("configurations", om.valueToTree(this.getConfigurations()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emr.CfnInstanceFleetConfig.ConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConfigurationProperty.Jsii$Proxy that = (ConfigurationProperty.Jsii$Proxy) o;

                if (this.classification != null ? !this.classification.equals(that.classification) : that.classification != null) return false;
                if (this.configurationProperties != null ? !this.configurationProperties.equals(that.configurationProperties) : that.configurationProperties != null) return false;
                return this.configurations != null ? this.configurations.equals(that.configurations) : that.configurations == null;
            }

            @Override
            public final int hashCode() {
                int result = this.classification != null ? this.classification.hashCode() : 0;
                result = 31 * result + (this.configurationProperties != null ? this.configurationProperties.hashCode() : 0);
                result = 31 * result + (this.configurations != null ? this.configurations.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <code>EbsBlockDeviceConfig</code> is a subproperty of the <code>EbsConfiguration</code> property type.
     * <p>
     * <code>EbsBlockDeviceConfig</code> defines the number and type of EBS volumes to associate with all EC2 instances in an EMR cluster.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * EbsBlockDeviceConfigProperty ebsBlockDeviceConfigProperty = EbsBlockDeviceConfigProperty.builder()
     *         .volumeSpecification(VolumeSpecificationProperty.builder()
     *                 .sizeInGb(123)
     *                 .volumeType("volumeType")
     *                 // the properties below are optional
     *                 .iops(123)
     *                 .throughput(123)
     *                 .build())
     *         // the properties below are optional
     *         .volumesPerInstance(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-ebsblockdeviceconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-ebsblockdeviceconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emr.CfnInstanceFleetConfig.EbsBlockDeviceConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(EbsBlockDeviceConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EbsBlockDeviceConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * EBS volume specifications such as volume type, IOPS, size (GiB) and throughput (MiB/s) that are requested for the EBS volume attached to an Amazon EC2 instance in the cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-ebsblockdeviceconfig.html#cfn-emr-instancefleetconfig-ebsblockdeviceconfig-volumespecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-ebsblockdeviceconfig.html#cfn-emr-instancefleetconfig-ebsblockdeviceconfig-volumespecification</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getVolumeSpecification();

        /**
         * Number of EBS volumes with a specific volume configuration that are associated with every instance in the instance group.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-ebsblockdeviceconfig.html#cfn-emr-instancefleetconfig-ebsblockdeviceconfig-volumesperinstance">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-ebsblockdeviceconfig.html#cfn-emr-instancefleetconfig-ebsblockdeviceconfig-volumesperinstance</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getVolumesPerInstance() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EbsBlockDeviceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EbsBlockDeviceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EbsBlockDeviceConfigProperty> {
            java.lang.Object volumeSpecification;
            java.lang.Number volumesPerInstance;

            /**
             * Sets the value of {@link EbsBlockDeviceConfigProperty#getVolumeSpecification}
             * @param volumeSpecification EBS volume specifications such as volume type, IOPS, size (GiB) and throughput (MiB/s) that are requested for the EBS volume attached to an Amazon EC2 instance in the cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeSpecification(software.amazon.awscdk.IResolvable volumeSpecification) {
                this.volumeSpecification = volumeSpecification;
                return this;
            }

            /**
             * Sets the value of {@link EbsBlockDeviceConfigProperty#getVolumeSpecification}
             * @param volumeSpecification EBS volume specifications such as volume type, IOPS, size (GiB) and throughput (MiB/s) that are requested for the EBS volume attached to an Amazon EC2 instance in the cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeSpecification(software.amazon.awscdk.services.emr.CfnInstanceFleetConfig.VolumeSpecificationProperty volumeSpecification) {
                this.volumeSpecification = volumeSpecification;
                return this;
            }

            /**
             * Sets the value of {@link EbsBlockDeviceConfigProperty#getVolumesPerInstance}
             * @param volumesPerInstance Number of EBS volumes with a specific volume configuration that are associated with every instance in the instance group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumesPerInstance(java.lang.Number volumesPerInstance) {
                this.volumesPerInstance = volumesPerInstance;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EbsBlockDeviceConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EbsBlockDeviceConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EbsBlockDeviceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EbsBlockDeviceConfigProperty {
            private final java.lang.Object volumeSpecification;
            private final java.lang.Number volumesPerInstance;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.volumeSpecification = software.amazon.jsii.Kernel.get(this, "volumeSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.volumesPerInstance = software.amazon.jsii.Kernel.get(this, "volumesPerInstance", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.volumeSpecification = java.util.Objects.requireNonNull(builder.volumeSpecification, "volumeSpecification is required");
                this.volumesPerInstance = builder.volumesPerInstance;
            }

            @Override
            public final java.lang.Object getVolumeSpecification() {
                return this.volumeSpecification;
            }

            @Override
            public final java.lang.Number getVolumesPerInstance() {
                return this.volumesPerInstance;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("volumeSpecification", om.valueToTree(this.getVolumeSpecification()));
                if (this.getVolumesPerInstance() != null) {
                    data.set("volumesPerInstance", om.valueToTree(this.getVolumesPerInstance()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emr.CfnInstanceFleetConfig.EbsBlockDeviceConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EbsBlockDeviceConfigProperty.Jsii$Proxy that = (EbsBlockDeviceConfigProperty.Jsii$Proxy) o;

                if (!volumeSpecification.equals(that.volumeSpecification)) return false;
                return this.volumesPerInstance != null ? this.volumesPerInstance.equals(that.volumesPerInstance) : that.volumesPerInstance == null;
            }

            @Override
            public final int hashCode() {
                int result = this.volumeSpecification.hashCode();
                result = 31 * result + (this.volumesPerInstance != null ? this.volumesPerInstance.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <code>EbsConfiguration</code> determines the EBS volumes to attach to EMR cluster instances.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * EbsConfigurationProperty ebsConfigurationProperty = EbsConfigurationProperty.builder()
     *         .ebsBlockDeviceConfigs(List.of(EbsBlockDeviceConfigProperty.builder()
     *                 .volumeSpecification(VolumeSpecificationProperty.builder()
     *                         .sizeInGb(123)
     *                         .volumeType("volumeType")
     *                         // the properties below are optional
     *                         .iops(123)
     *                         .throughput(123)
     *                         .build())
     *                 // the properties below are optional
     *                 .volumesPerInstance(123)
     *                 .build()))
     *         .ebsOptimized(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-ebsconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-ebsconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emr.CfnInstanceFleetConfig.EbsConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(EbsConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EbsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An array of Amazon EBS volume specifications attached to a cluster instance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-ebsconfiguration.html#cfn-emr-instancefleetconfig-ebsconfiguration-ebsblockdeviceconfigs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-ebsconfiguration.html#cfn-emr-instancefleetconfig-ebsconfiguration-ebsblockdeviceconfigs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEbsBlockDeviceConfigs() {
            return null;
        }

        /**
         * Indicates whether an Amazon EBS volume is EBS-optimized.
         * <p>
         * The default is false. You should explicitly set this value to true to enable the Amazon EBS-optimized setting for an EC2 instance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-ebsconfiguration.html#cfn-emr-instancefleetconfig-ebsconfiguration-ebsoptimized">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-ebsconfiguration.html#cfn-emr-instancefleetconfig-ebsconfiguration-ebsoptimized</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEbsOptimized() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EbsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EbsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EbsConfigurationProperty> {
            java.lang.Object ebsBlockDeviceConfigs;
            java.lang.Object ebsOptimized;

            /**
             * Sets the value of {@link EbsConfigurationProperty#getEbsBlockDeviceConfigs}
             * @param ebsBlockDeviceConfigs An array of Amazon EBS volume specifications attached to a cluster instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebsBlockDeviceConfigs(software.amazon.awscdk.IResolvable ebsBlockDeviceConfigs) {
                this.ebsBlockDeviceConfigs = ebsBlockDeviceConfigs;
                return this;
            }

            /**
             * Sets the value of {@link EbsConfigurationProperty#getEbsBlockDeviceConfigs}
             * @param ebsBlockDeviceConfigs An array of Amazon EBS volume specifications attached to a cluster instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebsBlockDeviceConfigs(java.util.List<? extends java.lang.Object> ebsBlockDeviceConfigs) {
                this.ebsBlockDeviceConfigs = ebsBlockDeviceConfigs;
                return this;
            }

            /**
             * Sets the value of {@link EbsConfigurationProperty#getEbsOptimized}
             * @param ebsOptimized Indicates whether an Amazon EBS volume is EBS-optimized.
             *                     The default is false. You should explicitly set this value to true to enable the Amazon EBS-optimized setting for an EC2 instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebsOptimized(java.lang.Boolean ebsOptimized) {
                this.ebsOptimized = ebsOptimized;
                return this;
            }

            /**
             * Sets the value of {@link EbsConfigurationProperty#getEbsOptimized}
             * @param ebsOptimized Indicates whether an Amazon EBS volume is EBS-optimized.
             *                     The default is false. You should explicitly set this value to true to enable the Amazon EBS-optimized setting for an EC2 instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebsOptimized(software.amazon.awscdk.IResolvable ebsOptimized) {
                this.ebsOptimized = ebsOptimized;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EbsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EbsConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EbsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EbsConfigurationProperty {
            private final java.lang.Object ebsBlockDeviceConfigs;
            private final java.lang.Object ebsOptimized;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ebsBlockDeviceConfigs = software.amazon.jsii.Kernel.get(this, "ebsBlockDeviceConfigs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ebsOptimized = software.amazon.jsii.Kernel.get(this, "ebsOptimized", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ebsBlockDeviceConfigs = builder.ebsBlockDeviceConfigs;
                this.ebsOptimized = builder.ebsOptimized;
            }

            @Override
            public final java.lang.Object getEbsBlockDeviceConfigs() {
                return this.ebsBlockDeviceConfigs;
            }

            @Override
            public final java.lang.Object getEbsOptimized() {
                return this.ebsOptimized;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEbsBlockDeviceConfigs() != null) {
                    data.set("ebsBlockDeviceConfigs", om.valueToTree(this.getEbsBlockDeviceConfigs()));
                }
                if (this.getEbsOptimized() != null) {
                    data.set("ebsOptimized", om.valueToTree(this.getEbsOptimized()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emr.CfnInstanceFleetConfig.EbsConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EbsConfigurationProperty.Jsii$Proxy that = (EbsConfigurationProperty.Jsii$Proxy) o;

                if (this.ebsBlockDeviceConfigs != null ? !this.ebsBlockDeviceConfigs.equals(that.ebsBlockDeviceConfigs) : that.ebsBlockDeviceConfigs != null) return false;
                return this.ebsOptimized != null ? this.ebsOptimized.equals(that.ebsOptimized) : that.ebsOptimized == null;
            }

            @Override
            public final int hashCode() {
                int result = this.ebsBlockDeviceConfigs != null ? this.ebsBlockDeviceConfigs.hashCode() : 0;
                result = 31 * result + (this.ebsOptimized != null ? this.ebsOptimized.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <blockquote><p>The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.<p></blockquote>
     * <p>
     * <code>InstanceTypeConfig</code> is a sub-property of <code>InstanceFleetConfig</code> . <code>InstanceTypeConfig</code> determines the EC2 instances that Amazon EMR attempts to provision to fulfill On-Demand and Spot target capacities.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * InstanceFleetProvisioningSpecificationsProperty instanceFleetProvisioningSpecificationsProperty = InstanceFleetProvisioningSpecificationsProperty.builder()
     *         .onDemandSpecification(OnDemandProvisioningSpecificationProperty.builder()
     *                 .allocationStrategy("allocationStrategy")
     *                 // the properties below are optional
     *                 .capacityReservationOptions(OnDemandCapacityReservationOptionsProperty.builder()
     *                         .capacityReservationPreference("capacityReservationPreference")
     *                         .capacityReservationResourceGroupArn("capacityReservationResourceGroupArn")
     *                         .usageStrategy("usageStrategy")
     *                         .build())
     *                 .build())
     *         .spotSpecification(SpotProvisioningSpecificationProperty.builder()
     *                 .timeoutAction("timeoutAction")
     *                 .timeoutDurationMinutes(123)
     *                 // the properties below are optional
     *                 .allocationStrategy("allocationStrategy")
     *                 .blockDurationMinutes(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-instancefleetprovisioningspecifications.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-instancefleetprovisioningspecifications.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emr.CfnInstanceFleetConfig.InstanceFleetProvisioningSpecificationsProperty")
    @software.amazon.jsii.Jsii.Proxy(InstanceFleetProvisioningSpecificationsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InstanceFleetProvisioningSpecificationsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The launch specification for On-Demand Instances in the instance fleet, which determines the allocation strategy and capacity reservation options.
         * <p>
         * <blockquote>
         * <p>
         * The instance fleet configuration is available only in Amazon EMR releases 4.8.0 and later, excluding 5.0.x versions. On-Demand Instances allocation strategy is available in Amazon EMR releases 5.12.1 and later.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-instancefleetprovisioningspecifications.html#cfn-emr-instancefleetconfig-instancefleetprovisioningspecifications-ondemandspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-instancefleetprovisioningspecifications.html#cfn-emr-instancefleetconfig-instancefleetprovisioningspecifications-ondemandspecification</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOnDemandSpecification() {
            return null;
        }

        /**
         * The launch specification for Spot instances in the fleet, which determines the allocation strategy, defined duration, and provisioning timeout behavior.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-instancefleetprovisioningspecifications.html#cfn-emr-instancefleetconfig-instancefleetprovisioningspecifications-spotspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-instancefleetprovisioningspecifications.html#cfn-emr-instancefleetconfig-instancefleetprovisioningspecifications-spotspecification</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSpotSpecification() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InstanceFleetProvisioningSpecificationsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InstanceFleetProvisioningSpecificationsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InstanceFleetProvisioningSpecificationsProperty> {
            java.lang.Object onDemandSpecification;
            java.lang.Object spotSpecification;

            /**
             * Sets the value of {@link InstanceFleetProvisioningSpecificationsProperty#getOnDemandSpecification}
             * @param onDemandSpecification The launch specification for On-Demand Instances in the instance fleet, which determines the allocation strategy and capacity reservation options.
             *                              <blockquote>
             *                              <p>
             *                              The instance fleet configuration is available only in Amazon EMR releases 4.8.0 and later, excluding 5.0.x versions. On-Demand Instances allocation strategy is available in Amazon EMR releases 5.12.1 and later.
             *                              <p>
             *                              </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onDemandSpecification(software.amazon.awscdk.IResolvable onDemandSpecification) {
                this.onDemandSpecification = onDemandSpecification;
                return this;
            }

            /**
             * Sets the value of {@link InstanceFleetProvisioningSpecificationsProperty#getOnDemandSpecification}
             * @param onDemandSpecification The launch specification for On-Demand Instances in the instance fleet, which determines the allocation strategy and capacity reservation options.
             *                              <blockquote>
             *                              <p>
             *                              The instance fleet configuration is available only in Amazon EMR releases 4.8.0 and later, excluding 5.0.x versions. On-Demand Instances allocation strategy is available in Amazon EMR releases 5.12.1 and later.
             *                              <p>
             *                              </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onDemandSpecification(software.amazon.awscdk.services.emr.CfnInstanceFleetConfig.OnDemandProvisioningSpecificationProperty onDemandSpecification) {
                this.onDemandSpecification = onDemandSpecification;
                return this;
            }

            /**
             * Sets the value of {@link InstanceFleetProvisioningSpecificationsProperty#getSpotSpecification}
             * @param spotSpecification The launch specification for Spot instances in the fleet, which determines the allocation strategy, defined duration, and provisioning timeout behavior.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spotSpecification(software.amazon.awscdk.IResolvable spotSpecification) {
                this.spotSpecification = spotSpecification;
                return this;
            }

            /**
             * Sets the value of {@link InstanceFleetProvisioningSpecificationsProperty#getSpotSpecification}
             * @param spotSpecification The launch specification for Spot instances in the fleet, which determines the allocation strategy, defined duration, and provisioning timeout behavior.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spotSpecification(software.amazon.awscdk.services.emr.CfnInstanceFleetConfig.SpotProvisioningSpecificationProperty spotSpecification) {
                this.spotSpecification = spotSpecification;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceFleetProvisioningSpecificationsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InstanceFleetProvisioningSpecificationsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InstanceFleetProvisioningSpecificationsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceFleetProvisioningSpecificationsProperty {
            private final java.lang.Object onDemandSpecification;
            private final java.lang.Object spotSpecification;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.onDemandSpecification = software.amazon.jsii.Kernel.get(this, "onDemandSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.spotSpecification = software.amazon.jsii.Kernel.get(this, "spotSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.onDemandSpecification = builder.onDemandSpecification;
                this.spotSpecification = builder.spotSpecification;
            }

            @Override
            public final java.lang.Object getOnDemandSpecification() {
                return this.onDemandSpecification;
            }

            @Override
            public final java.lang.Object getSpotSpecification() {
                return this.spotSpecification;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getOnDemandSpecification() != null) {
                    data.set("onDemandSpecification", om.valueToTree(this.getOnDemandSpecification()));
                }
                if (this.getSpotSpecification() != null) {
                    data.set("spotSpecification", om.valueToTree(this.getSpotSpecification()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emr.CfnInstanceFleetConfig.InstanceFleetProvisioningSpecificationsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InstanceFleetProvisioningSpecificationsProperty.Jsii$Proxy that = (InstanceFleetProvisioningSpecificationsProperty.Jsii$Proxy) o;

                if (this.onDemandSpecification != null ? !this.onDemandSpecification.equals(that.onDemandSpecification) : that.onDemandSpecification != null) return false;
                return this.spotSpecification != null ? this.spotSpecification.equals(that.spotSpecification) : that.spotSpecification == null;
            }

            @Override
            public final int hashCode() {
                int result = this.onDemandSpecification != null ? this.onDemandSpecification.hashCode() : 0;
                result = 31 * result + (this.spotSpecification != null ? this.spotSpecification.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The resize specification for On-Demand and Spot Instances in the fleet.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * InstanceFleetResizingSpecificationsProperty instanceFleetResizingSpecificationsProperty = InstanceFleetResizingSpecificationsProperty.builder()
     *         .onDemandResizeSpecification(OnDemandResizingSpecificationProperty.builder()
     *                 .allocationStrategy("allocationStrategy")
     *                 .capacityReservationOptions(OnDemandCapacityReservationOptionsProperty.builder()
     *                         .capacityReservationPreference("capacityReservationPreference")
     *                         .capacityReservationResourceGroupArn("capacityReservationResourceGroupArn")
     *                         .usageStrategy("usageStrategy")
     *                         .build())
     *                 .timeoutDurationMinutes(123)
     *                 .build())
     *         .spotResizeSpecification(SpotResizingSpecificationProperty.builder()
     *                 .allocationStrategy("allocationStrategy")
     *                 .timeoutDurationMinutes(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-instancefleetresizingspecifications.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-instancefleetresizingspecifications.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emr.CfnInstanceFleetConfig.InstanceFleetResizingSpecificationsProperty")
    @software.amazon.jsii.Jsii.Proxy(InstanceFleetResizingSpecificationsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InstanceFleetResizingSpecificationsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The resize specification for On-Demand Instances in the instance fleet, which contains the allocation strategy, capacity reservation options, and the resize timeout period.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-instancefleetresizingspecifications.html#cfn-emr-instancefleetconfig-instancefleetresizingspecifications-ondemandresizespecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-instancefleetresizingspecifications.html#cfn-emr-instancefleetconfig-instancefleetresizingspecifications-ondemandresizespecification</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOnDemandResizeSpecification() {
            return null;
        }

        /**
         * The resize specification for Spot Instances in the instance fleet, which contains the allocation strategy and the resize timeout period.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-instancefleetresizingspecifications.html#cfn-emr-instancefleetconfig-instancefleetresizingspecifications-spotresizespecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-instancefleetresizingspecifications.html#cfn-emr-instancefleetconfig-instancefleetresizingspecifications-spotresizespecification</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSpotResizeSpecification() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InstanceFleetResizingSpecificationsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InstanceFleetResizingSpecificationsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InstanceFleetResizingSpecificationsProperty> {
            java.lang.Object onDemandResizeSpecification;
            java.lang.Object spotResizeSpecification;

            /**
             * Sets the value of {@link InstanceFleetResizingSpecificationsProperty#getOnDemandResizeSpecification}
             * @param onDemandResizeSpecification The resize specification for On-Demand Instances in the instance fleet, which contains the allocation strategy, capacity reservation options, and the resize timeout period.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onDemandResizeSpecification(software.amazon.awscdk.IResolvable onDemandResizeSpecification) {
                this.onDemandResizeSpecification = onDemandResizeSpecification;
                return this;
            }

            /**
             * Sets the value of {@link InstanceFleetResizingSpecificationsProperty#getOnDemandResizeSpecification}
             * @param onDemandResizeSpecification The resize specification for On-Demand Instances in the instance fleet, which contains the allocation strategy, capacity reservation options, and the resize timeout period.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onDemandResizeSpecification(software.amazon.awscdk.services.emr.CfnInstanceFleetConfig.OnDemandResizingSpecificationProperty onDemandResizeSpecification) {
                this.onDemandResizeSpecification = onDemandResizeSpecification;
                return this;
            }

            /**
             * Sets the value of {@link InstanceFleetResizingSpecificationsProperty#getSpotResizeSpecification}
             * @param spotResizeSpecification The resize specification for Spot Instances in the instance fleet, which contains the allocation strategy and the resize timeout period.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spotResizeSpecification(software.amazon.awscdk.IResolvable spotResizeSpecification) {
                this.spotResizeSpecification = spotResizeSpecification;
                return this;
            }

            /**
             * Sets the value of {@link InstanceFleetResizingSpecificationsProperty#getSpotResizeSpecification}
             * @param spotResizeSpecification The resize specification for Spot Instances in the instance fleet, which contains the allocation strategy and the resize timeout period.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spotResizeSpecification(software.amazon.awscdk.services.emr.CfnInstanceFleetConfig.SpotResizingSpecificationProperty spotResizeSpecification) {
                this.spotResizeSpecification = spotResizeSpecification;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceFleetResizingSpecificationsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InstanceFleetResizingSpecificationsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InstanceFleetResizingSpecificationsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceFleetResizingSpecificationsProperty {
            private final java.lang.Object onDemandResizeSpecification;
            private final java.lang.Object spotResizeSpecification;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.onDemandResizeSpecification = software.amazon.jsii.Kernel.get(this, "onDemandResizeSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.spotResizeSpecification = software.amazon.jsii.Kernel.get(this, "spotResizeSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.onDemandResizeSpecification = builder.onDemandResizeSpecification;
                this.spotResizeSpecification = builder.spotResizeSpecification;
            }

            @Override
            public final java.lang.Object getOnDemandResizeSpecification() {
                return this.onDemandResizeSpecification;
            }

            @Override
            public final java.lang.Object getSpotResizeSpecification() {
                return this.spotResizeSpecification;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getOnDemandResizeSpecification() != null) {
                    data.set("onDemandResizeSpecification", om.valueToTree(this.getOnDemandResizeSpecification()));
                }
                if (this.getSpotResizeSpecification() != null) {
                    data.set("spotResizeSpecification", om.valueToTree(this.getSpotResizeSpecification()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emr.CfnInstanceFleetConfig.InstanceFleetResizingSpecificationsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InstanceFleetResizingSpecificationsProperty.Jsii$Proxy that = (InstanceFleetResizingSpecificationsProperty.Jsii$Proxy) o;

                if (this.onDemandResizeSpecification != null ? !this.onDemandResizeSpecification.equals(that.onDemandResizeSpecification) : that.onDemandResizeSpecification != null) return false;
                return this.spotResizeSpecification != null ? this.spotResizeSpecification.equals(that.spotResizeSpecification) : that.spotResizeSpecification == null;
            }

            @Override
            public final int hashCode() {
                int result = this.onDemandResizeSpecification != null ? this.onDemandResizeSpecification.hashCode() : 0;
                result = 31 * result + (this.spotResizeSpecification != null ? this.spotResizeSpecification.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <code>InstanceType</code> config is a subproperty of <code>InstanceFleetConfig</code> .
     * <p>
     * An instance type configuration specifies each instance type in an instance fleet. The configuration determines the EC2 instances Amazon EMR attempts to provision to fulfill On-Demand and Spot target capacities.
     * <p>
     * <blockquote>
     * <p>
     * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * ConfigurationProperty configurationProperty_;
     * InstanceTypeConfigProperty instanceTypeConfigProperty = InstanceTypeConfigProperty.builder()
     *         .instanceType("instanceType")
     *         // the properties below are optional
     *         .bidPrice("bidPrice")
     *         .bidPriceAsPercentageOfOnDemandPrice(123)
     *         .configurations(List.of(ConfigurationProperty.builder()
     *                 .classification("classification")
     *                 .configurationProperties(Map.of(
     *                         "configurationPropertiesKey", "configurationProperties"))
     *                 .configurations(List.of(configurationProperty_))
     *                 .build()))
     *         .customAmiId("customAmiId")
     *         .ebsConfiguration(EbsConfigurationProperty.builder()
     *                 .ebsBlockDeviceConfigs(List.of(EbsBlockDeviceConfigProperty.builder()
     *                         .volumeSpecification(VolumeSpecificationProperty.builder()
     *                                 .sizeInGb(123)
     *                                 .volumeType("volumeType")
     *                                 // the properties below are optional
     *                                 .iops(123)
     *                                 .throughput(123)
     *                                 .build())
     *                         // the properties below are optional
     *                         .volumesPerInstance(123)
     *                         .build()))
     *                 .ebsOptimized(false)
     *                 .build())
     *         .priority(123)
     *         .weightedCapacity(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-instancetypeconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-instancetypeconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emr.CfnInstanceFleetConfig.InstanceTypeConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(InstanceTypeConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InstanceTypeConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An Amazon EC2 instance type, such as <code>m3.xlarge</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-instancetypeconfig.html#cfn-emr-instancefleetconfig-instancetypeconfig-instancetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-instancetypeconfig.html#cfn-emr-instancefleetconfig-instancetypeconfig-instancetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInstanceType();

        /**
         * The bid price for each Amazon EC2 Spot Instance type as defined by <code>InstanceType</code> .
         * <p>
         * Expressed in USD. If neither <code>BidPrice</code> nor <code>BidPriceAsPercentageOfOnDemandPrice</code> is provided, <code>BidPriceAsPercentageOfOnDemandPrice</code> defaults to 100%.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-instancetypeconfig.html#cfn-emr-instancefleetconfig-instancetypeconfig-bidprice">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-instancetypeconfig.html#cfn-emr-instancefleetconfig-instancetypeconfig-bidprice</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBidPrice() {
            return null;
        }

        /**
         * The bid price, as a percentage of On-Demand price, for each Amazon EC2 Spot Instance as defined by <code>InstanceType</code> .
         * <p>
         * Expressed as a number (for example, 20 specifies 20%). If neither <code>BidPrice</code> nor <code>BidPriceAsPercentageOfOnDemandPrice</code> is provided, <code>BidPriceAsPercentageOfOnDemandPrice</code> defaults to 100%.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-instancetypeconfig.html#cfn-emr-instancefleetconfig-instancetypeconfig-bidpriceaspercentageofondemandprice">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-instancetypeconfig.html#cfn-emr-instancefleetconfig-instancetypeconfig-bidpriceaspercentageofondemandprice</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBidPriceAsPercentageOfOnDemandPrice() {
            return null;
        }

        /**
         * <blockquote><p>Amazon EMR releases 4.x or later.<p></blockquote>
         * <p>
         * An optional configuration specification to be used when provisioning cluster instances, which can include configurations for applications and software bundled with Amazon EMR. A configuration consists of a classification, properties, and optional nested configurations. A classification refers to an application-specific configuration file. Properties are the settings you want to change in that file. For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-configure-apps.html">Configuring Applications</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-instancetypeconfig.html#cfn-emr-instancefleetconfig-instancetypeconfig-configurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-instancetypeconfig.html#cfn-emr-instancefleetconfig-instancetypeconfig-configurations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConfigurations() {
            return null;
        }

        /**
         * The custom AMI ID to use for the instance type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-instancetypeconfig.html#cfn-emr-instancefleetconfig-instancetypeconfig-customamiid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-instancetypeconfig.html#cfn-emr-instancefleetconfig-instancetypeconfig-customamiid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCustomAmiId() {
            return null;
        }

        /**
         * The configuration of Amazon Elastic Block Store (Amazon EBS) attached to each instance as defined by <code>InstanceType</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-instancetypeconfig.html#cfn-emr-instancefleetconfig-instancetypeconfig-ebsconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-instancetypeconfig.html#cfn-emr-instancefleetconfig-instancetypeconfig-ebsconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEbsConfiguration() {
            return null;
        }

        /**
         * The priority at which Amazon EMR launches the Amazon EC2 instances with this instance type.
         * <p>
         * Priority starts at 0, which is the highest priority. Amazon EMR considers the highest priority first.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-instancetypeconfig.html#cfn-emr-instancefleetconfig-instancetypeconfig-priority">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-instancetypeconfig.html#cfn-emr-instancefleetconfig-instancetypeconfig-priority</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPriority() {
            return null;
        }

        /**
         * The number of units that a provisioned instance of this type provides toward fulfilling the target capacities defined in <code>InstanceFleetConfig</code> .
         * <p>
         * This value is 1 for a master instance fleet, and must be 1 or greater for core and task instance fleets. Defaults to 1 if not specified.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-instancetypeconfig.html#cfn-emr-instancefleetconfig-instancetypeconfig-weightedcapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-instancetypeconfig.html#cfn-emr-instancefleetconfig-instancetypeconfig-weightedcapacity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getWeightedCapacity() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InstanceTypeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InstanceTypeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InstanceTypeConfigProperty> {
            java.lang.String instanceType;
            java.lang.String bidPrice;
            java.lang.Number bidPriceAsPercentageOfOnDemandPrice;
            java.lang.Object configurations;
            java.lang.String customAmiId;
            java.lang.Object ebsConfiguration;
            java.lang.Number priority;
            java.lang.Number weightedCapacity;

            /**
             * Sets the value of {@link InstanceTypeConfigProperty#getInstanceType}
             * @param instanceType An Amazon EC2 instance type, such as <code>m3.xlarge</code> . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceType(java.lang.String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            /**
             * Sets the value of {@link InstanceTypeConfigProperty#getBidPrice}
             * @param bidPrice The bid price for each Amazon EC2 Spot Instance type as defined by <code>InstanceType</code> .
             *                 Expressed in USD. If neither <code>BidPrice</code> nor <code>BidPriceAsPercentageOfOnDemandPrice</code> is provided, <code>BidPriceAsPercentageOfOnDemandPrice</code> defaults to 100%.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bidPrice(java.lang.String bidPrice) {
                this.bidPrice = bidPrice;
                return this;
            }

            /**
             * Sets the value of {@link InstanceTypeConfigProperty#getBidPriceAsPercentageOfOnDemandPrice}
             * @param bidPriceAsPercentageOfOnDemandPrice The bid price, as a percentage of On-Demand price, for each Amazon EC2 Spot Instance as defined by <code>InstanceType</code> .
             *                                            Expressed as a number (for example, 20 specifies 20%). If neither <code>BidPrice</code> nor <code>BidPriceAsPercentageOfOnDemandPrice</code> is provided, <code>BidPriceAsPercentageOfOnDemandPrice</code> defaults to 100%.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bidPriceAsPercentageOfOnDemandPrice(java.lang.Number bidPriceAsPercentageOfOnDemandPrice) {
                this.bidPriceAsPercentageOfOnDemandPrice = bidPriceAsPercentageOfOnDemandPrice;
                return this;
            }

            /**
             * Sets the value of {@link InstanceTypeConfigProperty#getConfigurations}
             * @param configurations <blockquote><p>Amazon EMR releases 4.x or later.<p></blockquote>
             *                       An optional configuration specification to be used when provisioning cluster instances, which can include configurations for applications and software bundled with Amazon EMR. A configuration consists of a classification, properties, and optional nested configurations. A classification refers to an application-specific configuration file. Properties are the settings you want to change in that file. For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-configure-apps.html">Configuring Applications</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configurations(software.amazon.awscdk.IResolvable configurations) {
                this.configurations = configurations;
                return this;
            }

            /**
             * Sets the value of {@link InstanceTypeConfigProperty#getConfigurations}
             * @param configurations <blockquote><p>Amazon EMR releases 4.x or later.<p></blockquote>
             *                       An optional configuration specification to be used when provisioning cluster instances, which can include configurations for applications and software bundled with Amazon EMR. A configuration consists of a classification, properties, and optional nested configurations. A classification refers to an application-specific configuration file. Properties are the settings you want to change in that file. For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-configure-apps.html">Configuring Applications</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configurations(java.util.List<? extends java.lang.Object> configurations) {
                this.configurations = configurations;
                return this;
            }

            /**
             * Sets the value of {@link InstanceTypeConfigProperty#getCustomAmiId}
             * @param customAmiId The custom AMI ID to use for the instance type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customAmiId(java.lang.String customAmiId) {
                this.customAmiId = customAmiId;
                return this;
            }

            /**
             * Sets the value of {@link InstanceTypeConfigProperty#getEbsConfiguration}
             * @param ebsConfiguration The configuration of Amazon Elastic Block Store (Amazon EBS) attached to each instance as defined by <code>InstanceType</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebsConfiguration(software.amazon.awscdk.IResolvable ebsConfiguration) {
                this.ebsConfiguration = ebsConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link InstanceTypeConfigProperty#getEbsConfiguration}
             * @param ebsConfiguration The configuration of Amazon Elastic Block Store (Amazon EBS) attached to each instance as defined by <code>InstanceType</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebsConfiguration(software.amazon.awscdk.services.emr.CfnInstanceFleetConfig.EbsConfigurationProperty ebsConfiguration) {
                this.ebsConfiguration = ebsConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link InstanceTypeConfigProperty#getPriority}
             * @param priority The priority at which Amazon EMR launches the Amazon EC2 instances with this instance type.
             *                 Priority starts at 0, which is the highest priority. Amazon EMR considers the highest priority first.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder priority(java.lang.Number priority) {
                this.priority = priority;
                return this;
            }

            /**
             * Sets the value of {@link InstanceTypeConfigProperty#getWeightedCapacity}
             * @param weightedCapacity The number of units that a provisioned instance of this type provides toward fulfilling the target capacities defined in <code>InstanceFleetConfig</code> .
             *                         This value is 1 for a master instance fleet, and must be 1 or greater for core and task instance fleets. Defaults to 1 if not specified.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weightedCapacity(java.lang.Number weightedCapacity) {
                this.weightedCapacity = weightedCapacity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InstanceTypeConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InstanceTypeConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InstanceTypeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceTypeConfigProperty {
            private final java.lang.String instanceType;
            private final java.lang.String bidPrice;
            private final java.lang.Number bidPriceAsPercentageOfOnDemandPrice;
            private final java.lang.Object configurations;
            private final java.lang.String customAmiId;
            private final java.lang.Object ebsConfiguration;
            private final java.lang.Number priority;
            private final java.lang.Number weightedCapacity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bidPrice = software.amazon.jsii.Kernel.get(this, "bidPrice", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bidPriceAsPercentageOfOnDemandPrice = software.amazon.jsii.Kernel.get(this, "bidPriceAsPercentageOfOnDemandPrice", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.configurations = software.amazon.jsii.Kernel.get(this, "configurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.customAmiId = software.amazon.jsii.Kernel.get(this, "customAmiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ebsConfiguration = software.amazon.jsii.Kernel.get(this, "ebsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.priority = software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.weightedCapacity = software.amazon.jsii.Kernel.get(this, "weightedCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.instanceType = java.util.Objects.requireNonNull(builder.instanceType, "instanceType is required");
                this.bidPrice = builder.bidPrice;
                this.bidPriceAsPercentageOfOnDemandPrice = builder.bidPriceAsPercentageOfOnDemandPrice;
                this.configurations = builder.configurations;
                this.customAmiId = builder.customAmiId;
                this.ebsConfiguration = builder.ebsConfiguration;
                this.priority = builder.priority;
                this.weightedCapacity = builder.weightedCapacity;
            }

            @Override
            public final java.lang.String getInstanceType() {
                return this.instanceType;
            }

            @Override
            public final java.lang.String getBidPrice() {
                return this.bidPrice;
            }

            @Override
            public final java.lang.Number getBidPriceAsPercentageOfOnDemandPrice() {
                return this.bidPriceAsPercentageOfOnDemandPrice;
            }

            @Override
            public final java.lang.Object getConfigurations() {
                return this.configurations;
            }

            @Override
            public final java.lang.String getCustomAmiId() {
                return this.customAmiId;
            }

            @Override
            public final java.lang.Object getEbsConfiguration() {
                return this.ebsConfiguration;
            }

            @Override
            public final java.lang.Number getPriority() {
                return this.priority;
            }

            @Override
            public final java.lang.Number getWeightedCapacity() {
                return this.weightedCapacity;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("instanceType", om.valueToTree(this.getInstanceType()));
                if (this.getBidPrice() != null) {
                    data.set("bidPrice", om.valueToTree(this.getBidPrice()));
                }
                if (this.getBidPriceAsPercentageOfOnDemandPrice() != null) {
                    data.set("bidPriceAsPercentageOfOnDemandPrice", om.valueToTree(this.getBidPriceAsPercentageOfOnDemandPrice()));
                }
                if (this.getConfigurations() != null) {
                    data.set("configurations", om.valueToTree(this.getConfigurations()));
                }
                if (this.getCustomAmiId() != null) {
                    data.set("customAmiId", om.valueToTree(this.getCustomAmiId()));
                }
                if (this.getEbsConfiguration() != null) {
                    data.set("ebsConfiguration", om.valueToTree(this.getEbsConfiguration()));
                }
                if (this.getPriority() != null) {
                    data.set("priority", om.valueToTree(this.getPriority()));
                }
                if (this.getWeightedCapacity() != null) {
                    data.set("weightedCapacity", om.valueToTree(this.getWeightedCapacity()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emr.CfnInstanceFleetConfig.InstanceTypeConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InstanceTypeConfigProperty.Jsii$Proxy that = (InstanceTypeConfigProperty.Jsii$Proxy) o;

                if (!instanceType.equals(that.instanceType)) return false;
                if (this.bidPrice != null ? !this.bidPrice.equals(that.bidPrice) : that.bidPrice != null) return false;
                if (this.bidPriceAsPercentageOfOnDemandPrice != null ? !this.bidPriceAsPercentageOfOnDemandPrice.equals(that.bidPriceAsPercentageOfOnDemandPrice) : that.bidPriceAsPercentageOfOnDemandPrice != null) return false;
                if (this.configurations != null ? !this.configurations.equals(that.configurations) : that.configurations != null) return false;
                if (this.customAmiId != null ? !this.customAmiId.equals(that.customAmiId) : that.customAmiId != null) return false;
                if (this.ebsConfiguration != null ? !this.ebsConfiguration.equals(that.ebsConfiguration) : that.ebsConfiguration != null) return false;
                if (this.priority != null ? !this.priority.equals(that.priority) : that.priority != null) return false;
                return this.weightedCapacity != null ? this.weightedCapacity.equals(that.weightedCapacity) : that.weightedCapacity == null;
            }

            @Override
            public final int hashCode() {
                int result = this.instanceType.hashCode();
                result = 31 * result + (this.bidPrice != null ? this.bidPrice.hashCode() : 0);
                result = 31 * result + (this.bidPriceAsPercentageOfOnDemandPrice != null ? this.bidPriceAsPercentageOfOnDemandPrice.hashCode() : 0);
                result = 31 * result + (this.configurations != null ? this.configurations.hashCode() : 0);
                result = 31 * result + (this.customAmiId != null ? this.customAmiId.hashCode() : 0);
                result = 31 * result + (this.ebsConfiguration != null ? this.ebsConfiguration.hashCode() : 0);
                result = 31 * result + (this.priority != null ? this.priority.hashCode() : 0);
                result = 31 * result + (this.weightedCapacity != null ? this.weightedCapacity.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes the strategy for using unused Capacity Reservations for fulfilling On-Demand capacity.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * OnDemandCapacityReservationOptionsProperty onDemandCapacityReservationOptionsProperty = OnDemandCapacityReservationOptionsProperty.builder()
     *         .capacityReservationPreference("capacityReservationPreference")
     *         .capacityReservationResourceGroupArn("capacityReservationResourceGroupArn")
     *         .usageStrategy("usageStrategy")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-ondemandcapacityreservationoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-ondemandcapacityreservationoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emr.CfnInstanceFleetConfig.OnDemandCapacityReservationOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(OnDemandCapacityReservationOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OnDemandCapacityReservationOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates the instance's Capacity Reservation preferences. Possible preferences include:.
         * <p>
         * <ul>
         * <li><code>open</code> - The instance can run in any open Capacity Reservation that has matching attributes (instance type, platform, Availability Zone).</li>
         * <li><code>none</code> - The instance avoids running in a Capacity Reservation even if one is available. The instance runs as an On-Demand Instance.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-ondemandcapacityreservationoptions.html#cfn-emr-instancefleetconfig-ondemandcapacityreservationoptions-capacityreservationpreference">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-ondemandcapacityreservationoptions.html#cfn-emr-instancefleetconfig-ondemandcapacityreservationoptions-capacityreservationpreference</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCapacityReservationPreference() {
            return null;
        }

        /**
         * The ARN of the Capacity Reservation resource group in which to run the instance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-ondemandcapacityreservationoptions.html#cfn-emr-instancefleetconfig-ondemandcapacityreservationoptions-capacityreservationresourcegrouparn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-ondemandcapacityreservationoptions.html#cfn-emr-instancefleetconfig-ondemandcapacityreservationoptions-capacityreservationresourcegrouparn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCapacityReservationResourceGroupArn() {
            return null;
        }

        /**
         * Indicates whether to use unused Capacity Reservations for fulfilling On-Demand capacity.
         * <p>
         * If you specify <code>use-capacity-reservations-first</code> , the fleet uses unused Capacity Reservations to fulfill On-Demand capacity up to the target On-Demand capacity. If multiple instance pools have unused Capacity Reservations, the On-Demand allocation strategy ( <code>lowest-price</code> ) is applied. If the number of unused Capacity Reservations is less than the On-Demand target capacity, the remaining On-Demand target capacity is launched according to the On-Demand allocation strategy ( <code>lowest-price</code> ).
         * <p>
         * If you do not specify a value, the fleet fulfills the On-Demand capacity according to the chosen On-Demand allocation strategy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-ondemandcapacityreservationoptions.html#cfn-emr-instancefleetconfig-ondemandcapacityreservationoptions-usagestrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-ondemandcapacityreservationoptions.html#cfn-emr-instancefleetconfig-ondemandcapacityreservationoptions-usagestrategy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUsageStrategy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OnDemandCapacityReservationOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OnDemandCapacityReservationOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OnDemandCapacityReservationOptionsProperty> {
            java.lang.String capacityReservationPreference;
            java.lang.String capacityReservationResourceGroupArn;
            java.lang.String usageStrategy;

            /**
             * Sets the value of {@link OnDemandCapacityReservationOptionsProperty#getCapacityReservationPreference}
             * @param capacityReservationPreference Indicates the instance's Capacity Reservation preferences. Possible preferences include:.
             *                                      <ul>
             *                                      <li><code>open</code> - The instance can run in any open Capacity Reservation that has matching attributes (instance type, platform, Availability Zone).</li>
             *                                      <li><code>none</code> - The instance avoids running in a Capacity Reservation even if one is available. The instance runs as an On-Demand Instance.</li>
             *                                      </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityReservationPreference(java.lang.String capacityReservationPreference) {
                this.capacityReservationPreference = capacityReservationPreference;
                return this;
            }

            /**
             * Sets the value of {@link OnDemandCapacityReservationOptionsProperty#getCapacityReservationResourceGroupArn}
             * @param capacityReservationResourceGroupArn The ARN of the Capacity Reservation resource group in which to run the instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityReservationResourceGroupArn(java.lang.String capacityReservationResourceGroupArn) {
                this.capacityReservationResourceGroupArn = capacityReservationResourceGroupArn;
                return this;
            }

            /**
             * Sets the value of {@link OnDemandCapacityReservationOptionsProperty#getUsageStrategy}
             * @param usageStrategy Indicates whether to use unused Capacity Reservations for fulfilling On-Demand capacity.
             *                      If you specify <code>use-capacity-reservations-first</code> , the fleet uses unused Capacity Reservations to fulfill On-Demand capacity up to the target On-Demand capacity. If multiple instance pools have unused Capacity Reservations, the On-Demand allocation strategy ( <code>lowest-price</code> ) is applied. If the number of unused Capacity Reservations is less than the On-Demand target capacity, the remaining On-Demand target capacity is launched according to the On-Demand allocation strategy ( <code>lowest-price</code> ).
             *                      <p>
             *                      If you do not specify a value, the fleet fulfills the On-Demand capacity according to the chosen On-Demand allocation strategy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder usageStrategy(java.lang.String usageStrategy) {
                this.usageStrategy = usageStrategy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OnDemandCapacityReservationOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OnDemandCapacityReservationOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OnDemandCapacityReservationOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OnDemandCapacityReservationOptionsProperty {
            private final java.lang.String capacityReservationPreference;
            private final java.lang.String capacityReservationResourceGroupArn;
            private final java.lang.String usageStrategy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.capacityReservationPreference = software.amazon.jsii.Kernel.get(this, "capacityReservationPreference", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.capacityReservationResourceGroupArn = software.amazon.jsii.Kernel.get(this, "capacityReservationResourceGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.usageStrategy = software.amazon.jsii.Kernel.get(this, "usageStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.capacityReservationPreference = builder.capacityReservationPreference;
                this.capacityReservationResourceGroupArn = builder.capacityReservationResourceGroupArn;
                this.usageStrategy = builder.usageStrategy;
            }

            @Override
            public final java.lang.String getCapacityReservationPreference() {
                return this.capacityReservationPreference;
            }

            @Override
            public final java.lang.String getCapacityReservationResourceGroupArn() {
                return this.capacityReservationResourceGroupArn;
            }

            @Override
            public final java.lang.String getUsageStrategy() {
                return this.usageStrategy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCapacityReservationPreference() != null) {
                    data.set("capacityReservationPreference", om.valueToTree(this.getCapacityReservationPreference()));
                }
                if (this.getCapacityReservationResourceGroupArn() != null) {
                    data.set("capacityReservationResourceGroupArn", om.valueToTree(this.getCapacityReservationResourceGroupArn()));
                }
                if (this.getUsageStrategy() != null) {
                    data.set("usageStrategy", om.valueToTree(this.getUsageStrategy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emr.CfnInstanceFleetConfig.OnDemandCapacityReservationOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OnDemandCapacityReservationOptionsProperty.Jsii$Proxy that = (OnDemandCapacityReservationOptionsProperty.Jsii$Proxy) o;

                if (this.capacityReservationPreference != null ? !this.capacityReservationPreference.equals(that.capacityReservationPreference) : that.capacityReservationPreference != null) return false;
                if (this.capacityReservationResourceGroupArn != null ? !this.capacityReservationResourceGroupArn.equals(that.capacityReservationResourceGroupArn) : that.capacityReservationResourceGroupArn != null) return false;
                return this.usageStrategy != null ? this.usageStrategy.equals(that.usageStrategy) : that.usageStrategy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.capacityReservationPreference != null ? this.capacityReservationPreference.hashCode() : 0;
                result = 31 * result + (this.capacityReservationResourceGroupArn != null ? this.capacityReservationResourceGroupArn.hashCode() : 0);
                result = 31 * result + (this.usageStrategy != null ? this.usageStrategy.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The launch specification for On-Demand Instances in the instance fleet, which determines the allocation strategy.
     * <p>
     * <blockquote>
     * <p>
     * The instance fleet configuration is available only in Amazon EMR releases 4.8.0 and later, excluding 5.0.x versions. On-Demand Instances allocation strategy is available in Amazon EMR releases 5.12.1 and later.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * OnDemandProvisioningSpecificationProperty onDemandProvisioningSpecificationProperty = OnDemandProvisioningSpecificationProperty.builder()
     *         .allocationStrategy("allocationStrategy")
     *         // the properties below are optional
     *         .capacityReservationOptions(OnDemandCapacityReservationOptionsProperty.builder()
     *                 .capacityReservationPreference("capacityReservationPreference")
     *                 .capacityReservationResourceGroupArn("capacityReservationResourceGroupArn")
     *                 .usageStrategy("usageStrategy")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-ondemandprovisioningspecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-ondemandprovisioningspecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emr.CfnInstanceFleetConfig.OnDemandProvisioningSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(OnDemandProvisioningSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OnDemandProvisioningSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the strategy to use in launching On-Demand instance fleets.
         * <p>
         * Available options are <code>lowest-price</code> and <code>prioritized</code> . <code>lowest-price</code> specifies to launch the instances with the lowest price first, and <code>prioritized</code> specifies that Amazon EMR should launch the instances with the highest priority first. The default is <code>lowest-price</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-ondemandprovisioningspecification.html#cfn-emr-instancefleetconfig-ondemandprovisioningspecification-allocationstrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-ondemandprovisioningspecification.html#cfn-emr-instancefleetconfig-ondemandprovisioningspecification-allocationstrategy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAllocationStrategy();

        /**
         * The launch specification for On-Demand instances in the instance fleet, which determines the allocation strategy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-ondemandprovisioningspecification.html#cfn-emr-instancefleetconfig-ondemandprovisioningspecification-capacityreservationoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-ondemandprovisioningspecification.html#cfn-emr-instancefleetconfig-ondemandprovisioningspecification-capacityreservationoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCapacityReservationOptions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OnDemandProvisioningSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OnDemandProvisioningSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OnDemandProvisioningSpecificationProperty> {
            java.lang.String allocationStrategy;
            java.lang.Object capacityReservationOptions;

            /**
             * Sets the value of {@link OnDemandProvisioningSpecificationProperty#getAllocationStrategy}
             * @param allocationStrategy Specifies the strategy to use in launching On-Demand instance fleets. This parameter is required.
             *                           Available options are <code>lowest-price</code> and <code>prioritized</code> . <code>lowest-price</code> specifies to launch the instances with the lowest price first, and <code>prioritized</code> specifies that Amazon EMR should launch the instances with the highest priority first. The default is <code>lowest-price</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allocationStrategy(java.lang.String allocationStrategy) {
                this.allocationStrategy = allocationStrategy;
                return this;
            }

            /**
             * Sets the value of {@link OnDemandProvisioningSpecificationProperty#getCapacityReservationOptions}
             * @param capacityReservationOptions The launch specification for On-Demand instances in the instance fleet, which determines the allocation strategy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityReservationOptions(software.amazon.awscdk.IResolvable capacityReservationOptions) {
                this.capacityReservationOptions = capacityReservationOptions;
                return this;
            }

            /**
             * Sets the value of {@link OnDemandProvisioningSpecificationProperty#getCapacityReservationOptions}
             * @param capacityReservationOptions The launch specification for On-Demand instances in the instance fleet, which determines the allocation strategy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityReservationOptions(software.amazon.awscdk.services.emr.CfnInstanceFleetConfig.OnDemandCapacityReservationOptionsProperty capacityReservationOptions) {
                this.capacityReservationOptions = capacityReservationOptions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OnDemandProvisioningSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OnDemandProvisioningSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OnDemandProvisioningSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OnDemandProvisioningSpecificationProperty {
            private final java.lang.String allocationStrategy;
            private final java.lang.Object capacityReservationOptions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allocationStrategy = software.amazon.jsii.Kernel.get(this, "allocationStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.capacityReservationOptions = software.amazon.jsii.Kernel.get(this, "capacityReservationOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allocationStrategy = java.util.Objects.requireNonNull(builder.allocationStrategy, "allocationStrategy is required");
                this.capacityReservationOptions = builder.capacityReservationOptions;
            }

            @Override
            public final java.lang.String getAllocationStrategy() {
                return this.allocationStrategy;
            }

            @Override
            public final java.lang.Object getCapacityReservationOptions() {
                return this.capacityReservationOptions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("allocationStrategy", om.valueToTree(this.getAllocationStrategy()));
                if (this.getCapacityReservationOptions() != null) {
                    data.set("capacityReservationOptions", om.valueToTree(this.getCapacityReservationOptions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emr.CfnInstanceFleetConfig.OnDemandProvisioningSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OnDemandProvisioningSpecificationProperty.Jsii$Proxy that = (OnDemandProvisioningSpecificationProperty.Jsii$Proxy) o;

                if (!allocationStrategy.equals(that.allocationStrategy)) return false;
                return this.capacityReservationOptions != null ? this.capacityReservationOptions.equals(that.capacityReservationOptions) : that.capacityReservationOptions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.allocationStrategy.hashCode();
                result = 31 * result + (this.capacityReservationOptions != null ? this.capacityReservationOptions.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The resize specification for On-Demand Instances in the instance fleet, which contains the resize timeout period.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * OnDemandResizingSpecificationProperty onDemandResizingSpecificationProperty = OnDemandResizingSpecificationProperty.builder()
     *         .allocationStrategy("allocationStrategy")
     *         .capacityReservationOptions(OnDemandCapacityReservationOptionsProperty.builder()
     *                 .capacityReservationPreference("capacityReservationPreference")
     *                 .capacityReservationResourceGroupArn("capacityReservationResourceGroupArn")
     *                 .usageStrategy("usageStrategy")
     *                 .build())
     *         .timeoutDurationMinutes(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-ondemandresizingspecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-ondemandresizingspecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emr.CfnInstanceFleetConfig.OnDemandResizingSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(OnDemandResizingSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OnDemandResizingSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the allocation strategy to use to launch On-Demand instances during a resize.
         * <p>
         * The default is <code>lowest-price</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-ondemandresizingspecification.html#cfn-emr-instancefleetconfig-ondemandresizingspecification-allocationstrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-ondemandresizingspecification.html#cfn-emr-instancefleetconfig-ondemandresizingspecification-allocationstrategy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAllocationStrategy() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-ondemandresizingspecification.html#cfn-emr-instancefleetconfig-ondemandresizingspecification-capacityreservationoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-ondemandresizingspecification.html#cfn-emr-instancefleetconfig-ondemandresizingspecification-capacityreservationoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCapacityReservationOptions() {
            return null;
        }

        /**
         * On-Demand resize timeout in minutes.
         * <p>
         * If On-Demand Instances are not provisioned within this time, the resize workflow stops. The minimum value is 5 minutes, and the maximum value is 10,080 minutes (7 days). The timeout applies to all resize workflows on the Instance Fleet. The resize could be triggered by Amazon EMR Managed Scaling or by the customer (via Amazon EMR Console, Amazon EMR CLI modify-instance-fleet or Amazon EMR SDK ModifyInstanceFleet API) or by Amazon EMR due to Amazon EC2 Spot Reclamation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-ondemandresizingspecification.html#cfn-emr-instancefleetconfig-ondemandresizingspecification-timeoutdurationminutes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-ondemandresizingspecification.html#cfn-emr-instancefleetconfig-ondemandresizingspecification-timeoutdurationminutes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTimeoutDurationMinutes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OnDemandResizingSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OnDemandResizingSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OnDemandResizingSpecificationProperty> {
            java.lang.String allocationStrategy;
            java.lang.Object capacityReservationOptions;
            java.lang.Number timeoutDurationMinutes;

            /**
             * Sets the value of {@link OnDemandResizingSpecificationProperty#getAllocationStrategy}
             * @param allocationStrategy Specifies the allocation strategy to use to launch On-Demand instances during a resize.
             *                           The default is <code>lowest-price</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allocationStrategy(java.lang.String allocationStrategy) {
                this.allocationStrategy = allocationStrategy;
                return this;
            }

            /**
             * Sets the value of {@link OnDemandResizingSpecificationProperty#getCapacityReservationOptions}
             * @param capacityReservationOptions the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityReservationOptions(software.amazon.awscdk.IResolvable capacityReservationOptions) {
                this.capacityReservationOptions = capacityReservationOptions;
                return this;
            }

            /**
             * Sets the value of {@link OnDemandResizingSpecificationProperty#getCapacityReservationOptions}
             * @param capacityReservationOptions the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityReservationOptions(software.amazon.awscdk.services.emr.CfnInstanceFleetConfig.OnDemandCapacityReservationOptionsProperty capacityReservationOptions) {
                this.capacityReservationOptions = capacityReservationOptions;
                return this;
            }

            /**
             * Sets the value of {@link OnDemandResizingSpecificationProperty#getTimeoutDurationMinutes}
             * @param timeoutDurationMinutes On-Demand resize timeout in minutes.
             *                               If On-Demand Instances are not provisioned within this time, the resize workflow stops. The minimum value is 5 minutes, and the maximum value is 10,080 minutes (7 days). The timeout applies to all resize workflows on the Instance Fleet. The resize could be triggered by Amazon EMR Managed Scaling or by the customer (via Amazon EMR Console, Amazon EMR CLI modify-instance-fleet or Amazon EMR SDK ModifyInstanceFleet API) or by Amazon EMR due to Amazon EC2 Spot Reclamation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeoutDurationMinutes(java.lang.Number timeoutDurationMinutes) {
                this.timeoutDurationMinutes = timeoutDurationMinutes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OnDemandResizingSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OnDemandResizingSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OnDemandResizingSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OnDemandResizingSpecificationProperty {
            private final java.lang.String allocationStrategy;
            private final java.lang.Object capacityReservationOptions;
            private final java.lang.Number timeoutDurationMinutes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allocationStrategy = software.amazon.jsii.Kernel.get(this, "allocationStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.capacityReservationOptions = software.amazon.jsii.Kernel.get(this, "capacityReservationOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.timeoutDurationMinutes = software.amazon.jsii.Kernel.get(this, "timeoutDurationMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allocationStrategy = builder.allocationStrategy;
                this.capacityReservationOptions = builder.capacityReservationOptions;
                this.timeoutDurationMinutes = builder.timeoutDurationMinutes;
            }

            @Override
            public final java.lang.String getAllocationStrategy() {
                return this.allocationStrategy;
            }

            @Override
            public final java.lang.Object getCapacityReservationOptions() {
                return this.capacityReservationOptions;
            }

            @Override
            public final java.lang.Number getTimeoutDurationMinutes() {
                return this.timeoutDurationMinutes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAllocationStrategy() != null) {
                    data.set("allocationStrategy", om.valueToTree(this.getAllocationStrategy()));
                }
                if (this.getCapacityReservationOptions() != null) {
                    data.set("capacityReservationOptions", om.valueToTree(this.getCapacityReservationOptions()));
                }
                if (this.getTimeoutDurationMinutes() != null) {
                    data.set("timeoutDurationMinutes", om.valueToTree(this.getTimeoutDurationMinutes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emr.CfnInstanceFleetConfig.OnDemandResizingSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OnDemandResizingSpecificationProperty.Jsii$Proxy that = (OnDemandResizingSpecificationProperty.Jsii$Proxy) o;

                if (this.allocationStrategy != null ? !this.allocationStrategy.equals(that.allocationStrategy) : that.allocationStrategy != null) return false;
                if (this.capacityReservationOptions != null ? !this.capacityReservationOptions.equals(that.capacityReservationOptions) : that.capacityReservationOptions != null) return false;
                return this.timeoutDurationMinutes != null ? this.timeoutDurationMinutes.equals(that.timeoutDurationMinutes) : that.timeoutDurationMinutes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.allocationStrategy != null ? this.allocationStrategy.hashCode() : 0;
                result = 31 * result + (this.capacityReservationOptions != null ? this.capacityReservationOptions.hashCode() : 0);
                result = 31 * result + (this.timeoutDurationMinutes != null ? this.timeoutDurationMinutes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <code>SpotProvisioningSpecification</code> is a subproperty of the <code>InstanceFleetProvisioningSpecifications</code> property type.
     * <p>
     * <code>SpotProvisioningSpecification</code> determines the launch specification for Spot instances in the instance fleet, which includes the defined duration and provisioning timeout behavior.
     * <p>
     * <blockquote>
     * <p>
     * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * SpotProvisioningSpecificationProperty spotProvisioningSpecificationProperty = SpotProvisioningSpecificationProperty.builder()
     *         .timeoutAction("timeoutAction")
     *         .timeoutDurationMinutes(123)
     *         // the properties below are optional
     *         .allocationStrategy("allocationStrategy")
     *         .blockDurationMinutes(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-spotprovisioningspecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-spotprovisioningspecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emr.CfnInstanceFleetConfig.SpotProvisioningSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(SpotProvisioningSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SpotProvisioningSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The action to take when <code>TargetSpotCapacity</code> has not been fulfilled when the <code>TimeoutDurationMinutes</code> has expired;
         * <p>
         * that is, when all Spot Instances could not be provisioned within the Spot provisioning timeout. Valid values are <code>TERMINATE_CLUSTER</code> and <code>SWITCH_TO_ON_DEMAND</code> . SWITCH_TO_ON_DEMAND specifies that if no Spot Instances are available, On-Demand Instances should be provisioned to fulfill any remaining Spot capacity.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-spotprovisioningspecification.html#cfn-emr-instancefleetconfig-spotprovisioningspecification-timeoutaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-spotprovisioningspecification.html#cfn-emr-instancefleetconfig-spotprovisioningspecification-timeoutaction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTimeoutAction();

        /**
         * The Spot provisioning timeout period in minutes.
         * <p>
         * If Spot Instances are not provisioned within this time period, the <code>TimeOutAction</code> is taken. Minimum value is 5 and maximum value is 1440. The timeout applies only during initial provisioning, when the cluster is first created.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-spotprovisioningspecification.html#cfn-emr-instancefleetconfig-spotprovisioningspecification-timeoutdurationminutes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-spotprovisioningspecification.html#cfn-emr-instancefleetconfig-spotprovisioningspecification-timeoutdurationminutes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getTimeoutDurationMinutes();

        /**
         * Specifies one of the following strategies to launch Spot Instance fleets: <code>capacity-optimized</code> , <code>price-capacity-optimized</code> , <code>lowest-price</code> , or <code>diversified</code> , and <code>capacity-optimized-prioritized</code> .
         * <p>
         * For more information on the provisioning strategies, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-allocation-strategy.html">Allocation strategies for Spot Instances</a> in the <em>Amazon EC2 User Guide for Linux Instances</em> .
         * <p>
         * <blockquote>
         * <p>
         * When you launch a Spot Instance fleet with the old console, it automatically launches with the <code>capacity-optimized</code> strategy. You can't change the allocation strategy from the old console.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-spotprovisioningspecification.html#cfn-emr-instancefleetconfig-spotprovisioningspecification-allocationstrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-spotprovisioningspecification.html#cfn-emr-instancefleetconfig-spotprovisioningspecification-allocationstrategy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAllocationStrategy() {
            return null;
        }

        /**
         * The defined duration for Spot Instances (also known as Spot blocks) in minutes.
         * <p>
         * When specified, the Spot Instance does not terminate before the defined duration expires, and defined duration pricing for Spot Instances applies. Valid values are 60, 120, 180, 240, 300, or 360. The duration period starts as soon as a Spot Instance receives its instance ID. At the end of the duration, Amazon EC2 marks the Spot Instance for termination and provides a Spot Instance termination notice, which gives the instance a two-minute warning before it terminates.
         * <p>
         * <blockquote>
         * <p>
         * Spot Instances with a defined duration (also known as Spot blocks) are no longer available to new customers from July 1, 2021. For customers who have previously used the feature, we will continue to support Spot Instances with a defined duration until December 31, 2022.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-spotprovisioningspecification.html#cfn-emr-instancefleetconfig-spotprovisioningspecification-blockdurationminutes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-spotprovisioningspecification.html#cfn-emr-instancefleetconfig-spotprovisioningspecification-blockdurationminutes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBlockDurationMinutes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SpotProvisioningSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SpotProvisioningSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SpotProvisioningSpecificationProperty> {
            java.lang.String timeoutAction;
            java.lang.Number timeoutDurationMinutes;
            java.lang.String allocationStrategy;
            java.lang.Number blockDurationMinutes;

            /**
             * Sets the value of {@link SpotProvisioningSpecificationProperty#getTimeoutAction}
             * @param timeoutAction The action to take when <code>TargetSpotCapacity</code> has not been fulfilled when the <code>TimeoutDurationMinutes</code> has expired;. This parameter is required.
             *                      that is, when all Spot Instances could not be provisioned within the Spot provisioning timeout. Valid values are <code>TERMINATE_CLUSTER</code> and <code>SWITCH_TO_ON_DEMAND</code> . SWITCH_TO_ON_DEMAND specifies that if no Spot Instances are available, On-Demand Instances should be provisioned to fulfill any remaining Spot capacity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeoutAction(java.lang.String timeoutAction) {
                this.timeoutAction = timeoutAction;
                return this;
            }

            /**
             * Sets the value of {@link SpotProvisioningSpecificationProperty#getTimeoutDurationMinutes}
             * @param timeoutDurationMinutes The Spot provisioning timeout period in minutes. This parameter is required.
             *                               If Spot Instances are not provisioned within this time period, the <code>TimeOutAction</code> is taken. Minimum value is 5 and maximum value is 1440. The timeout applies only during initial provisioning, when the cluster is first created.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeoutDurationMinutes(java.lang.Number timeoutDurationMinutes) {
                this.timeoutDurationMinutes = timeoutDurationMinutes;
                return this;
            }

            /**
             * Sets the value of {@link SpotProvisioningSpecificationProperty#getAllocationStrategy}
             * @param allocationStrategy Specifies one of the following strategies to launch Spot Instance fleets: <code>capacity-optimized</code> , <code>price-capacity-optimized</code> , <code>lowest-price</code> , or <code>diversified</code> , and <code>capacity-optimized-prioritized</code> .
             *                           For more information on the provisioning strategies, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-allocation-strategy.html">Allocation strategies for Spot Instances</a> in the <em>Amazon EC2 User Guide for Linux Instances</em> .
             *                           <p>
             *                           <blockquote>
             *                           <p>
             *                           When you launch a Spot Instance fleet with the old console, it automatically launches with the <code>capacity-optimized</code> strategy. You can't change the allocation strategy from the old console.
             *                           <p>
             *                           </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allocationStrategy(java.lang.String allocationStrategy) {
                this.allocationStrategy = allocationStrategy;
                return this;
            }

            /**
             * Sets the value of {@link SpotProvisioningSpecificationProperty#getBlockDurationMinutes}
             * @param blockDurationMinutes The defined duration for Spot Instances (also known as Spot blocks) in minutes.
             *                             When specified, the Spot Instance does not terminate before the defined duration expires, and defined duration pricing for Spot Instances applies. Valid values are 60, 120, 180, 240, 300, or 360. The duration period starts as soon as a Spot Instance receives its instance ID. At the end of the duration, Amazon EC2 marks the Spot Instance for termination and provides a Spot Instance termination notice, which gives the instance a two-minute warning before it terminates.
             *                             <p>
             *                             <blockquote>
             *                             <p>
             *                             Spot Instances with a defined duration (also known as Spot blocks) are no longer available to new customers from July 1, 2021. For customers who have previously used the feature, we will continue to support Spot Instances with a defined duration until December 31, 2022.
             *                             <p>
             *                             </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockDurationMinutes(java.lang.Number blockDurationMinutes) {
                this.blockDurationMinutes = blockDurationMinutes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpotProvisioningSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SpotProvisioningSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SpotProvisioningSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SpotProvisioningSpecificationProperty {
            private final java.lang.String timeoutAction;
            private final java.lang.Number timeoutDurationMinutes;
            private final java.lang.String allocationStrategy;
            private final java.lang.Number blockDurationMinutes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.timeoutAction = software.amazon.jsii.Kernel.get(this, "timeoutAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.timeoutDurationMinutes = software.amazon.jsii.Kernel.get(this, "timeoutDurationMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.allocationStrategy = software.amazon.jsii.Kernel.get(this, "allocationStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.blockDurationMinutes = software.amazon.jsii.Kernel.get(this, "blockDurationMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.timeoutAction = java.util.Objects.requireNonNull(builder.timeoutAction, "timeoutAction is required");
                this.timeoutDurationMinutes = java.util.Objects.requireNonNull(builder.timeoutDurationMinutes, "timeoutDurationMinutes is required");
                this.allocationStrategy = builder.allocationStrategy;
                this.blockDurationMinutes = builder.blockDurationMinutes;
            }

            @Override
            public final java.lang.String getTimeoutAction() {
                return this.timeoutAction;
            }

            @Override
            public final java.lang.Number getTimeoutDurationMinutes() {
                return this.timeoutDurationMinutes;
            }

            @Override
            public final java.lang.String getAllocationStrategy() {
                return this.allocationStrategy;
            }

            @Override
            public final java.lang.Number getBlockDurationMinutes() {
                return this.blockDurationMinutes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("timeoutAction", om.valueToTree(this.getTimeoutAction()));
                data.set("timeoutDurationMinutes", om.valueToTree(this.getTimeoutDurationMinutes()));
                if (this.getAllocationStrategy() != null) {
                    data.set("allocationStrategy", om.valueToTree(this.getAllocationStrategy()));
                }
                if (this.getBlockDurationMinutes() != null) {
                    data.set("blockDurationMinutes", om.valueToTree(this.getBlockDurationMinutes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emr.CfnInstanceFleetConfig.SpotProvisioningSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SpotProvisioningSpecificationProperty.Jsii$Proxy that = (SpotProvisioningSpecificationProperty.Jsii$Proxy) o;

                if (!timeoutAction.equals(that.timeoutAction)) return false;
                if (!timeoutDurationMinutes.equals(that.timeoutDurationMinutes)) return false;
                if (this.allocationStrategy != null ? !this.allocationStrategy.equals(that.allocationStrategy) : that.allocationStrategy != null) return false;
                return this.blockDurationMinutes != null ? this.blockDurationMinutes.equals(that.blockDurationMinutes) : that.blockDurationMinutes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.timeoutAction.hashCode();
                result = 31 * result + (this.timeoutDurationMinutes.hashCode());
                result = 31 * result + (this.allocationStrategy != null ? this.allocationStrategy.hashCode() : 0);
                result = 31 * result + (this.blockDurationMinutes != null ? this.blockDurationMinutes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The resize specification for Spot Instances in the instance fleet, which contains the resize timeout period.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * SpotResizingSpecificationProperty spotResizingSpecificationProperty = SpotResizingSpecificationProperty.builder()
     *         .allocationStrategy("allocationStrategy")
     *         .timeoutDurationMinutes(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-spotresizingspecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-spotresizingspecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emr.CfnInstanceFleetConfig.SpotResizingSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(SpotResizingSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SpotResizingSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the allocation strategy to use to launch Spot instances during a resize.
         * <p>
         * If you run Amazon EMR releases 6.9.0 or higher, the default is <code>price-capacity-optimized</code> . If you run Amazon EMR releases 6.8.0 or lower, the default is <code>capacity-optimized</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-spotresizingspecification.html#cfn-emr-instancefleetconfig-spotresizingspecification-allocationstrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-spotresizingspecification.html#cfn-emr-instancefleetconfig-spotresizingspecification-allocationstrategy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAllocationStrategy() {
            return null;
        }

        /**
         * Spot resize timeout in minutes.
         * <p>
         * If Spot Instances are not provisioned within this time, the resize workflow will stop provisioning of Spot instances. Minimum value is 5 minutes and maximum value is 10,080 minutes (7 days). The timeout applies to all resize workflows on the Instance Fleet. The resize could be triggered by Amazon EMR Managed Scaling or by the customer (via Amazon EMR Console, Amazon EMR CLI modify-instance-fleet or Amazon EMR SDK ModifyInstanceFleet API) or by Amazon EMR due to Amazon EC2 Spot Reclamation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-spotresizingspecification.html#cfn-emr-instancefleetconfig-spotresizingspecification-timeoutdurationminutes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-spotresizingspecification.html#cfn-emr-instancefleetconfig-spotresizingspecification-timeoutdurationminutes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTimeoutDurationMinutes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SpotResizingSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SpotResizingSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SpotResizingSpecificationProperty> {
            java.lang.String allocationStrategy;
            java.lang.Number timeoutDurationMinutes;

            /**
             * Sets the value of {@link SpotResizingSpecificationProperty#getAllocationStrategy}
             * @param allocationStrategy Specifies the allocation strategy to use to launch Spot instances during a resize.
             *                           If you run Amazon EMR releases 6.9.0 or higher, the default is <code>price-capacity-optimized</code> . If you run Amazon EMR releases 6.8.0 or lower, the default is <code>capacity-optimized</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allocationStrategy(java.lang.String allocationStrategy) {
                this.allocationStrategy = allocationStrategy;
                return this;
            }

            /**
             * Sets the value of {@link SpotResizingSpecificationProperty#getTimeoutDurationMinutes}
             * @param timeoutDurationMinutes Spot resize timeout in minutes.
             *                               If Spot Instances are not provisioned within this time, the resize workflow will stop provisioning of Spot instances. Minimum value is 5 minutes and maximum value is 10,080 minutes (7 days). The timeout applies to all resize workflows on the Instance Fleet. The resize could be triggered by Amazon EMR Managed Scaling or by the customer (via Amazon EMR Console, Amazon EMR CLI modify-instance-fleet or Amazon EMR SDK ModifyInstanceFleet API) or by Amazon EMR due to Amazon EC2 Spot Reclamation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeoutDurationMinutes(java.lang.Number timeoutDurationMinutes) {
                this.timeoutDurationMinutes = timeoutDurationMinutes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpotResizingSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SpotResizingSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SpotResizingSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SpotResizingSpecificationProperty {
            private final java.lang.String allocationStrategy;
            private final java.lang.Number timeoutDurationMinutes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allocationStrategy = software.amazon.jsii.Kernel.get(this, "allocationStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.timeoutDurationMinutes = software.amazon.jsii.Kernel.get(this, "timeoutDurationMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allocationStrategy = builder.allocationStrategy;
                this.timeoutDurationMinutes = builder.timeoutDurationMinutes;
            }

            @Override
            public final java.lang.String getAllocationStrategy() {
                return this.allocationStrategy;
            }

            @Override
            public final java.lang.Number getTimeoutDurationMinutes() {
                return this.timeoutDurationMinutes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAllocationStrategy() != null) {
                    data.set("allocationStrategy", om.valueToTree(this.getAllocationStrategy()));
                }
                if (this.getTimeoutDurationMinutes() != null) {
                    data.set("timeoutDurationMinutes", om.valueToTree(this.getTimeoutDurationMinutes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emr.CfnInstanceFleetConfig.SpotResizingSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SpotResizingSpecificationProperty.Jsii$Proxy that = (SpotResizingSpecificationProperty.Jsii$Proxy) o;

                if (this.allocationStrategy != null ? !this.allocationStrategy.equals(that.allocationStrategy) : that.allocationStrategy != null) return false;
                return this.timeoutDurationMinutes != null ? this.timeoutDurationMinutes.equals(that.timeoutDurationMinutes) : that.timeoutDurationMinutes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.allocationStrategy != null ? this.allocationStrategy.hashCode() : 0;
                result = 31 * result + (this.timeoutDurationMinutes != null ? this.timeoutDurationMinutes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <code>VolumeSpecification</code> is a subproperty of the <code>EbsBlockDeviceConfig</code> property type.
     * <p>
     * <code>VolumeSecification</code> determines the volume type, IOPS, and size (GiB) for EBS volumes attached to EC2 instances.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emr.*;
     * VolumeSpecificationProperty volumeSpecificationProperty = VolumeSpecificationProperty.builder()
     *         .sizeInGb(123)
     *         .volumeType("volumeType")
     *         // the properties below are optional
     *         .iops(123)
     *         .throughput(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-volumespecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-volumespecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emr.CfnInstanceFleetConfig.VolumeSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(VolumeSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VolumeSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The volume size, in gibibytes (GiB).
         * <p>
         * This can be a number from 1 - 1024. If the volume type is EBS-optimized, the minimum value is 10.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-volumespecification.html#cfn-emr-instancefleetconfig-volumespecification-sizeingb">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-volumespecification.html#cfn-emr-instancefleetconfig-volumespecification-sizeingb</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getSizeInGb();

        /**
         * The volume type.
         * <p>
         * Volume types supported are gp3, gp2, io1, st1, sc1, and standard.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-volumespecification.html#cfn-emr-instancefleetconfig-volumespecification-volumetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-volumespecification.html#cfn-emr-instancefleetconfig-volumespecification-volumetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getVolumeType();

        /**
         * The number of I/O operations per second (IOPS) that the volume supports.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-volumespecification.html#cfn-emr-instancefleetconfig-volumespecification-iops">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-volumespecification.html#cfn-emr-instancefleetconfig-volumespecification-iops</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIops() {
            return null;
        }

        /**
         * The throughput, in mebibyte per second (MiB/s).
         * <p>
         * This optional parameter can be a number from 125 - 1000 and is valid only for gp3 volumes.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-volumespecification.html#cfn-emr-instancefleetconfig-volumespecification-throughput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emr-instancefleetconfig-volumespecification.html#cfn-emr-instancefleetconfig-volumespecification-throughput</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getThroughput() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VolumeSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VolumeSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VolumeSpecificationProperty> {
            java.lang.Number sizeInGb;
            java.lang.String volumeType;
            java.lang.Number iops;
            java.lang.Number throughput;

            /**
             * Sets the value of {@link VolumeSpecificationProperty#getSizeInGb}
             * @param sizeInGb The volume size, in gibibytes (GiB). This parameter is required.
             *                 This can be a number from 1 - 1024. If the volume type is EBS-optimized, the minimum value is 10.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sizeInGb(java.lang.Number sizeInGb) {
                this.sizeInGb = sizeInGb;
                return this;
            }

            /**
             * Sets the value of {@link VolumeSpecificationProperty#getVolumeType}
             * @param volumeType The volume type. This parameter is required.
             *                   Volume types supported are gp3, gp2, io1, st1, sc1, and standard.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeType(java.lang.String volumeType) {
                this.volumeType = volumeType;
                return this;
            }

            /**
             * Sets the value of {@link VolumeSpecificationProperty#getIops}
             * @param iops The number of I/O operations per second (IOPS) that the volume supports.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iops(java.lang.Number iops) {
                this.iops = iops;
                return this;
            }

            /**
             * Sets the value of {@link VolumeSpecificationProperty#getThroughput}
             * @param throughput The throughput, in mebibyte per second (MiB/s).
             *                   This optional parameter can be a number from 125 - 1000 and is valid only for gp3 volumes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder throughput(java.lang.Number throughput) {
                this.throughput = throughput;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VolumeSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VolumeSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VolumeSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VolumeSpecificationProperty {
            private final java.lang.Number sizeInGb;
            private final java.lang.String volumeType;
            private final java.lang.Number iops;
            private final java.lang.Number throughput;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sizeInGb = software.amazon.jsii.Kernel.get(this, "sizeInGb", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.volumeType = software.amazon.jsii.Kernel.get(this, "volumeType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.iops = software.amazon.jsii.Kernel.get(this, "iops", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.throughput = software.amazon.jsii.Kernel.get(this, "throughput", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sizeInGb = java.util.Objects.requireNonNull(builder.sizeInGb, "sizeInGb is required");
                this.volumeType = java.util.Objects.requireNonNull(builder.volumeType, "volumeType is required");
                this.iops = builder.iops;
                this.throughput = builder.throughput;
            }

            @Override
            public final java.lang.Number getSizeInGb() {
                return this.sizeInGb;
            }

            @Override
            public final java.lang.String getVolumeType() {
                return this.volumeType;
            }

            @Override
            public final java.lang.Number getIops() {
                return this.iops;
            }

            @Override
            public final java.lang.Number getThroughput() {
                return this.throughput;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("sizeInGb", om.valueToTree(this.getSizeInGb()));
                data.set("volumeType", om.valueToTree(this.getVolumeType()));
                if (this.getIops() != null) {
                    data.set("iops", om.valueToTree(this.getIops()));
                }
                if (this.getThroughput() != null) {
                    data.set("throughput", om.valueToTree(this.getThroughput()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emr.CfnInstanceFleetConfig.VolumeSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VolumeSpecificationProperty.Jsii$Proxy that = (VolumeSpecificationProperty.Jsii$Proxy) o;

                if (!sizeInGb.equals(that.sizeInGb)) return false;
                if (!volumeType.equals(that.volumeType)) return false;
                if (this.iops != null ? !this.iops.equals(that.iops) : that.iops != null) return false;
                return this.throughput != null ? this.throughput.equals(that.throughput) : that.throughput == null;
            }

            @Override
            public final int hashCode() {
                int result = this.sizeInGb.hashCode();
                result = 31 * result + (this.volumeType.hashCode());
                result = 31 * result + (this.iops != null ? this.iops.hashCode() : 0);
                result = 31 * result + (this.throughput != null ? this.throughput.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.emr.CfnInstanceFleetConfig}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.emr.CfnInstanceFleetConfig> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.emr.CfnInstanceFleetConfigProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.emr.CfnInstanceFleetConfigProps.Builder();
        }

        /**
         * The unique identifier of the EMR cluster.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancefleetconfig.html#cfn-emr-instancefleetconfig-clusterid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancefleetconfig.html#cfn-emr-instancefleetconfig-clusterid</a>
         * @param clusterId The unique identifier of the EMR cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterId(final java.lang.String clusterId) {
            this.props.clusterId(clusterId);
            return this;
        }

        /**
         * The node type that the instance fleet hosts.
         * <p>
         * <em>Allowed Values</em> : TASK
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancefleetconfig.html#cfn-emr-instancefleetconfig-instancefleettype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancefleetconfig.html#cfn-emr-instancefleetconfig-instancefleettype</a>
         * @param instanceFleetType The node type that the instance fleet hosts. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceFleetType(final java.lang.String instanceFleetType) {
            this.props.instanceFleetType(instanceFleetType);
            return this;
        }

        /**
         * <code>InstanceTypeConfigs</code> determine the EC2 instances that Amazon EMR attempts to provision to fulfill On-Demand and Spot target capacities.
         * <p>
         * <blockquote>
         * <p>
         * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancefleetconfig.html#cfn-emr-instancefleetconfig-instancetypeconfigs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancefleetconfig.html#cfn-emr-instancefleetconfig-instancetypeconfigs</a>
         * @param instanceTypeConfigs <code>InstanceTypeConfigs</code> determine the EC2 instances that Amazon EMR attempts to provision to fulfill On-Demand and Spot target capacities. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceTypeConfigs(final software.amazon.awscdk.IResolvable instanceTypeConfigs) {
            this.props.instanceTypeConfigs(instanceTypeConfigs);
            return this;
        }
        /**
         * <code>InstanceTypeConfigs</code> determine the EC2 instances that Amazon EMR attempts to provision to fulfill On-Demand and Spot target capacities.
         * <p>
         * <blockquote>
         * <p>
         * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancefleetconfig.html#cfn-emr-instancefleetconfig-instancetypeconfigs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancefleetconfig.html#cfn-emr-instancefleetconfig-instancetypeconfigs</a>
         * @param instanceTypeConfigs <code>InstanceTypeConfigs</code> determine the EC2 instances that Amazon EMR attempts to provision to fulfill On-Demand and Spot target capacities. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceTypeConfigs(final java.util.List<? extends java.lang.Object> instanceTypeConfigs) {
            this.props.instanceTypeConfigs(instanceTypeConfigs);
            return this;
        }

        /**
         * The launch specification for the instance fleet.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancefleetconfig.html#cfn-emr-instancefleetconfig-launchspecifications">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancefleetconfig.html#cfn-emr-instancefleetconfig-launchspecifications</a>
         * @param launchSpecifications The launch specification for the instance fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchSpecifications(final software.amazon.awscdk.IResolvable launchSpecifications) {
            this.props.launchSpecifications(launchSpecifications);
            return this;
        }
        /**
         * The launch specification for the instance fleet.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancefleetconfig.html#cfn-emr-instancefleetconfig-launchspecifications">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancefleetconfig.html#cfn-emr-instancefleetconfig-launchspecifications</a>
         * @param launchSpecifications The launch specification for the instance fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchSpecifications(final software.amazon.awscdk.services.emr.CfnInstanceFleetConfig.InstanceFleetProvisioningSpecificationsProperty launchSpecifications) {
            this.props.launchSpecifications(launchSpecifications);
            return this;
        }

        /**
         * The friendly name of the instance fleet.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancefleetconfig.html#cfn-emr-instancefleetconfig-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancefleetconfig.html#cfn-emr-instancefleetconfig-name</a>
         * @param name The friendly name of the instance fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The resize specification for the instance fleet.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancefleetconfig.html#cfn-emr-instancefleetconfig-resizespecifications">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancefleetconfig.html#cfn-emr-instancefleetconfig-resizespecifications</a>
         * @param resizeSpecifications The resize specification for the instance fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resizeSpecifications(final software.amazon.awscdk.IResolvable resizeSpecifications) {
            this.props.resizeSpecifications(resizeSpecifications);
            return this;
        }
        /**
         * The resize specification for the instance fleet.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancefleetconfig.html#cfn-emr-instancefleetconfig-resizespecifications">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancefleetconfig.html#cfn-emr-instancefleetconfig-resizespecifications</a>
         * @param resizeSpecifications The resize specification for the instance fleet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resizeSpecifications(final software.amazon.awscdk.services.emr.CfnInstanceFleetConfig.InstanceFleetResizingSpecificationsProperty resizeSpecifications) {
            this.props.resizeSpecifications(resizeSpecifications);
            return this;
        }

        /**
         * The target capacity of On-Demand units for the instance fleet, which determines how many On-Demand instances to provision.
         * <p>
         * When the instance fleet launches, Amazon EMR tries to provision On-Demand instances as specified by <code>InstanceTypeConfig</code> . Each instance configuration has a specified <code>WeightedCapacity</code> . When an On-Demand instance is provisioned, the <code>WeightedCapacity</code> units count toward the target capacity. Amazon EMR provisions instances until the target capacity is totally fulfilled, even if this results in an overage. For example, if there are 2 units remaining to fulfill capacity, and Amazon EMR can only provision an instance with a <code>WeightedCapacity</code> of 5 units, the instance is provisioned, and the target capacity is exceeded by 3 units.
         * <p>
         * <blockquote>
         * <p>
         * If not specified or set to 0, only Spot instances are provisioned for the instance fleet using <code>TargetSpotCapacity</code> . At least one of <code>TargetSpotCapacity</code> and <code>TargetOnDemandCapacity</code> should be greater than 0. For a master instance fleet, only one of <code>TargetSpotCapacity</code> and <code>TargetOnDemandCapacity</code> can be specified, and its value must be 1.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancefleetconfig.html#cfn-emr-instancefleetconfig-targetondemandcapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancefleetconfig.html#cfn-emr-instancefleetconfig-targetondemandcapacity</a>
         * @param targetOnDemandCapacity The target capacity of On-Demand units for the instance fleet, which determines how many On-Demand instances to provision. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetOnDemandCapacity(final java.lang.Number targetOnDemandCapacity) {
            this.props.targetOnDemandCapacity(targetOnDemandCapacity);
            return this;
        }

        /**
         * The target capacity of Spot units for the instance fleet, which determines how many Spot instances to provision.
         * <p>
         * When the instance fleet launches, Amazon EMR tries to provision Spot instances as specified by <code>InstanceTypeConfig</code> . Each instance configuration has a specified <code>WeightedCapacity</code> . When a Spot instance is provisioned, the <code>WeightedCapacity</code> units count toward the target capacity. Amazon EMR provisions instances until the target capacity is totally fulfilled, even if this results in an overage. For example, if there are 2 units remaining to fulfill capacity, and Amazon EMR can only provision an instance with a <code>WeightedCapacity</code> of 5 units, the instance is provisioned, and the target capacity is exceeded by 3 units.
         * <p>
         * <blockquote>
         * <p>
         * If not specified or set to 0, only On-Demand instances are provisioned for the instance fleet. At least one of <code>TargetSpotCapacity</code> and <code>TargetOnDemandCapacity</code> should be greater than 0. For a master instance fleet, only one of <code>TargetSpotCapacity</code> and <code>TargetOnDemandCapacity</code> can be specified, and its value must be 1.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancefleetconfig.html#cfn-emr-instancefleetconfig-targetspotcapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emr-instancefleetconfig.html#cfn-emr-instancefleetconfig-targetspotcapacity</a>
         * @param targetSpotCapacity The target capacity of Spot units for the instance fleet, which determines how many Spot instances to provision. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetSpotCapacity(final java.lang.Number targetSpotCapacity) {
            this.props.targetSpotCapacity(targetSpotCapacity);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.emr.CfnInstanceFleetConfig}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.emr.CfnInstanceFleetConfig build() {
            return new software.amazon.awscdk.services.emr.CfnInstanceFleetConfig(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
