package software.amazon.awscdk.services.emrcontainers;

/**
 * Properties for defining a <code>CfnVirtualCluster</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.emrcontainers.*;
 * CfnVirtualClusterProps cfnVirtualClusterProps = CfnVirtualClusterProps.builder()
 *         .containerProvider(ContainerProviderProperty.builder()
 *                 .id("id")
 *                 .info(ContainerInfoProperty.builder()
 *                         .eksInfo(EksInfoProperty.builder()
 *                                 .namespace("namespace")
 *                                 .build())
 *                         .build())
 *                 .type("type")
 *                 .build())
 *         .name("name")
 *         // the properties below are optional
 *         .securityConfigurationId("securityConfigurationId")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrcontainers-virtualcluster.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrcontainers-virtualcluster.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:24:58.557Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emrcontainers.CfnVirtualClusterProps")
@software.amazon.jsii.Jsii.Proxy(CfnVirtualClusterProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnVirtualClusterProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The container provider of the virtual cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrcontainers-virtualcluster.html#cfn-emrcontainers-virtualcluster-containerprovider">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrcontainers-virtualcluster.html#cfn-emrcontainers-virtualcluster-containerprovider</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getContainerProvider();

    /**
     * The name of the virtual cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrcontainers-virtualcluster.html#cfn-emrcontainers-virtualcluster-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrcontainers-virtualcluster.html#cfn-emrcontainers-virtualcluster-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The ID of the security configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrcontainers-virtualcluster.html#cfn-emrcontainers-virtualcluster-securityconfigurationid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrcontainers-virtualcluster.html#cfn-emrcontainers-virtualcluster-securityconfigurationid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSecurityConfigurationId() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrcontainers-virtualcluster.html#cfn-emrcontainers-virtualcluster-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrcontainers-virtualcluster.html#cfn-emrcontainers-virtualcluster-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnVirtualClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnVirtualClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnVirtualClusterProps> {
        java.lang.Object containerProvider;
        java.lang.String name;
        java.lang.String securityConfigurationId;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnVirtualClusterProps#getContainerProvider}
         * @param containerProvider The container provider of the virtual cluster. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerProvider(software.amazon.awscdk.IResolvable containerProvider) {
            this.containerProvider = containerProvider;
            return this;
        }

        /**
         * Sets the value of {@link CfnVirtualClusterProps#getContainerProvider}
         * @param containerProvider The container provider of the virtual cluster. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerProvider(software.amazon.awscdk.services.emrcontainers.CfnVirtualCluster.ContainerProviderProperty containerProvider) {
            this.containerProvider = containerProvider;
            return this;
        }

        /**
         * Sets the value of {@link CfnVirtualClusterProps#getName}
         * @param name The name of the virtual cluster. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnVirtualClusterProps#getSecurityConfigurationId}
         * @param securityConfigurationId The ID of the security configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityConfigurationId(java.lang.String securityConfigurationId) {
            this.securityConfigurationId = securityConfigurationId;
            return this;
        }

        /**
         * Sets the value of {@link CfnVirtualClusterProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnVirtualClusterProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnVirtualClusterProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnVirtualClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnVirtualClusterProps {
        private final java.lang.Object containerProvider;
        private final java.lang.String name;
        private final java.lang.String securityConfigurationId;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.containerProvider = software.amazon.jsii.Kernel.get(this, "containerProvider", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.securityConfigurationId = software.amazon.jsii.Kernel.get(this, "securityConfigurationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.containerProvider = java.util.Objects.requireNonNull(builder.containerProvider, "containerProvider is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.securityConfigurationId = builder.securityConfigurationId;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getContainerProvider() {
            return this.containerProvider;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getSecurityConfigurationId() {
            return this.securityConfigurationId;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("containerProvider", om.valueToTree(this.getContainerProvider()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getSecurityConfigurationId() != null) {
                data.set("securityConfigurationId", om.valueToTree(this.getSecurityConfigurationId()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emrcontainers.CfnVirtualClusterProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnVirtualClusterProps.Jsii$Proxy that = (CfnVirtualClusterProps.Jsii$Proxy) o;

            if (!containerProvider.equals(that.containerProvider)) return false;
            if (!name.equals(that.name)) return false;
            if (this.securityConfigurationId != null ? !this.securityConfigurationId.equals(that.securityConfigurationId) : that.securityConfigurationId != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.containerProvider.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.securityConfigurationId != null ? this.securityConfigurationId.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
