package software.amazon.awscdk.services.emrserverless;

/**
 * The <code>AWS::EMRServerless::Application</code> resource specifies an EMR Serverless application.
 * <p>
 * An application uses open source analytics frameworks to run jobs that process data. To create an application, you must specify the release version for the open source framework version you want to use and the type of application you want, such as Apache Spark or Apache Hive. After you create an application, you can submit data processing jobs or interactive requests to it.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.emrserverless.*;
 * ConfigurationObjectProperty configurationObjectProperty_;
 * CfnApplication cfnApplication = CfnApplication.Builder.create(this, "MyCfnApplication")
 *         .releaseLabel("releaseLabel")
 *         .type("type")
 *         // the properties below are optional
 *         .architecture("architecture")
 *         .autoStartConfiguration(AutoStartConfigurationProperty.builder()
 *                 .enabled(false)
 *                 .build())
 *         .autoStopConfiguration(AutoStopConfigurationProperty.builder()
 *                 .enabled(false)
 *                 .idleTimeoutMinutes(123)
 *                 .build())
 *         .imageConfiguration(ImageConfigurationInputProperty.builder()
 *                 .imageUri("imageUri")
 *                 .build())
 *         .initialCapacity(List.of(InitialCapacityConfigKeyValuePairProperty.builder()
 *                 .key("key")
 *                 .value(InitialCapacityConfigProperty.builder()
 *                         .workerConfiguration(WorkerConfigurationProperty.builder()
 *                                 .cpu("cpu")
 *                                 .memory("memory")
 *                                 // the properties below are optional
 *                                 .disk("disk")
 *                                 .diskType("diskType")
 *                                 .build())
 *                         .workerCount(123)
 *                         .build())
 *                 .build()))
 *         .interactiveConfiguration(InteractiveConfigurationProperty.builder()
 *                 .livyEndpointEnabled(false)
 *                 .studioEnabled(false)
 *                 .build())
 *         .maximumCapacity(MaximumAllowedResourcesProperty.builder()
 *                 .cpu("cpu")
 *                 .memory("memory")
 *                 // the properties below are optional
 *                 .disk("disk")
 *                 .build())
 *         .monitoringConfiguration(MonitoringConfigurationProperty.builder()
 *                 .cloudWatchLoggingConfiguration(CloudWatchLoggingConfigurationProperty.builder()
 *                         .enabled(false)
 *                         .encryptionKeyArn("encryptionKeyArn")
 *                         .logGroupName("logGroupName")
 *                         .logStreamNamePrefix("logStreamNamePrefix")
 *                         .logTypeMap(List.of(LogTypeMapKeyValuePairProperty.builder()
 *                                 .key("key")
 *                                 .value(List.of("value"))
 *                                 .build()))
 *                         .build())
 *                 .managedPersistenceMonitoringConfiguration(ManagedPersistenceMonitoringConfigurationProperty.builder()
 *                         .enabled(false)
 *                         .encryptionKeyArn("encryptionKeyArn")
 *                         .build())
 *                 .prometheusMonitoringConfiguration(PrometheusMonitoringConfigurationProperty.builder()
 *                         .remoteWriteUrl("remoteWriteUrl")
 *                         .build())
 *                 .s3MonitoringConfiguration(S3MonitoringConfigurationProperty.builder()
 *                         .encryptionKeyArn("encryptionKeyArn")
 *                         .logUri("logUri")
 *                         .build())
 *                 .build())
 *         .name("name")
 *         .networkConfiguration(NetworkConfigurationProperty.builder()
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .subnetIds(List.of("subnetIds"))
 *                 .build())
 *         .runtimeConfiguration(List.of(ConfigurationObjectProperty.builder()
 *                 .classification("classification")
 *                 // the properties below are optional
 *                 .configurations(List.of(configurationObjectProperty_))
 *                 .properties(Map.of(
 *                         "propertiesKey", "properties"))
 *                 .build()))
 *         .schedulerConfiguration(SchedulerConfigurationProperty.builder()
 *                 .maxConcurrentRuns(123)
 *                 .queueTimeoutMinutes(123)
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .workerTypeSpecifications(Map.of(
 *                 "workerTypeSpecificationsKey", WorkerTypeSpecificationInputProperty.builder()
 *                         .imageConfiguration(ImageConfigurationInputProperty.builder()
 *                                 .imageUri("imageUri")
 *                                 .build())
 *                         .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:24:58.558Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emrserverless.CfnApplication")
public class CfnApplication extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnApplication(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnApplication(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.emrserverless.CfnApplication.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnApplication(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.emrserverless.CfnApplicationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ID of the application, such as <code>ab4rp1abcs8xz47n3x0example</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrApplicationId() {
        return software.amazon.jsii.Kernel.get(this, "attrApplicationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the project.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The EMR release associated with the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getReleaseLabel() {
        return software.amazon.jsii.Kernel.get(this, "releaseLabel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The EMR release associated with the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setReleaseLabel(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "releaseLabel", java.util.Objects.requireNonNull(value, "releaseLabel is required"));
    }

    /**
     * The type of application, such as Spark or Hive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of application, such as Spark or Hive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "type", java.util.Objects.requireNonNull(value, "type is required"));
    }

    /**
     * The CPU architecture of an application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getArchitecture() {
        return software.amazon.jsii.Kernel.get(this, "architecture", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The CPU architecture of an application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setArchitecture(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "architecture", value);
    }

    /**
     * The configuration for an application to automatically start on job submission.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAutoStartConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "autoStartConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration for an application to automatically start on job submission.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoStartConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "autoStartConfiguration", value);
    }

    /**
     * The configuration for an application to automatically start on job submission.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoStartConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.emrserverless.CfnApplication.AutoStartConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "autoStartConfiguration", value);
    }

    /**
     * The configuration for an application to automatically stop after a certain amount of time being idle.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAutoStopConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "autoStopConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration for an application to automatically stop after a certain amount of time being idle.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoStopConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "autoStopConfiguration", value);
    }

    /**
     * The configuration for an application to automatically stop after a certain amount of time being idle.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoStopConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.emrserverless.CfnApplication.AutoStopConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "autoStopConfiguration", value);
    }

    /**
     * The image configuration applied to all worker types.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getImageConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "imageConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The image configuration applied to all worker types.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setImageConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "imageConfiguration", value);
    }

    /**
     * The image configuration applied to all worker types.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setImageConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.emrserverless.CfnApplication.ImageConfigurationInputProperty value) {
        software.amazon.jsii.Kernel.set(this, "imageConfiguration", value);
    }

    /**
     * The initial capacity of the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getInitialCapacity() {
        return software.amazon.jsii.Kernel.get(this, "initialCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The initial capacity of the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInitialCapacity(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "initialCapacity", value);
    }

    /**
     * The initial capacity of the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInitialCapacity(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.emrserverless.CfnApplication.InitialCapacityConfigKeyValuePairProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.emrserverless.CfnApplication.InitialCapacityConfigKeyValuePairProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "initialCapacity", value);
    }

    /**
     * The interactive configuration object that enables the interactive use cases for an application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getInteractiveConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "interactiveConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The interactive configuration object that enables the interactive use cases for an application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInteractiveConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "interactiveConfiguration", value);
    }

    /**
     * The interactive configuration object that enables the interactive use cases for an application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInteractiveConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.emrserverless.CfnApplication.InteractiveConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "interactiveConfiguration", value);
    }

    /**
     * The maximum capacity of the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMaximumCapacity() {
        return software.amazon.jsii.Kernel.get(this, "maximumCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The maximum capacity of the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaximumCapacity(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "maximumCapacity", value);
    }

    /**
     * The maximum capacity of the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaximumCapacity(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.emrserverless.CfnApplication.MaximumAllowedResourcesProperty value) {
        software.amazon.jsii.Kernel.set(this, "maximumCapacity", value);
    }

    /**
     * A configuration specification to be used when provisioning an application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMonitoringConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "monitoringConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A configuration specification to be used when provisioning an application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMonitoringConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "monitoringConfiguration", value);
    }

    /**
     * A configuration specification to be used when provisioning an application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMonitoringConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.emrserverless.CfnApplication.MonitoringConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "monitoringConfiguration", value);
    }

    /**
     * The name of the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * The network configuration for customer VPC connectivity for the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getNetworkConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "networkConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The network configuration for customer VPC connectivity for the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNetworkConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "networkConfiguration", value);
    }

    /**
     * The network configuration for customer VPC connectivity for the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNetworkConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.emrserverless.CfnApplication.NetworkConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "networkConfiguration", value);
    }

    /**
     * The <a href="https://docs.aws.amazon.com/emr-serverless/latest/APIReference/API_Configuration.html">Configuration</a> specifications of an application. Each configuration consists of a classification and properties. You use this parameter when creating or updating an application. To see the runtimeConfiguration object of an application, run the <a href="https://docs.aws.amazon.com/emr-serverless/latest/APIReference/API_GetApplication.html">GetApplication</a> API operation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRuntimeConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "runtimeConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The <a href="https://docs.aws.amazon.com/emr-serverless/latest/APIReference/API_Configuration.html">Configuration</a> specifications of an application. Each configuration consists of a classification and properties. You use this parameter when creating or updating an application. To see the runtimeConfiguration object of an application, run the <a href="https://docs.aws.amazon.com/emr-serverless/latest/APIReference/API_GetApplication.html">GetApplication</a> API operation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRuntimeConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "runtimeConfiguration", value);
    }

    /**
     * The <a href="https://docs.aws.amazon.com/emr-serverless/latest/APIReference/API_Configuration.html">Configuration</a> specifications of an application. Each configuration consists of a classification and properties. You use this parameter when creating or updating an application. To see the runtimeConfiguration object of an application, run the <a href="https://docs.aws.amazon.com/emr-serverless/latest/APIReference/API_GetApplication.html">GetApplication</a> API operation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRuntimeConfiguration(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.emrserverless.CfnApplication.ConfigurationObjectProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.emrserverless.CfnApplication.ConfigurationObjectProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "runtimeConfiguration", value);
    }

    /**
     * The scheduler configuration for batch and streaming jobs running on this application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSchedulerConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "schedulerConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The scheduler configuration for batch and streaming jobs running on this application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchedulerConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "schedulerConfiguration", value);
    }

    /**
     * The scheduler configuration for batch and streaming jobs running on this application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchedulerConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.emrserverless.CfnApplication.SchedulerConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "schedulerConfiguration", value);
    }

    /**
     * The tags assigned to the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The tags assigned to the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * The specification applied to each worker type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getWorkerTypeSpecifications() {
        return software.amazon.jsii.Kernel.get(this, "workerTypeSpecifications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The specification applied to each worker type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWorkerTypeSpecifications(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "workerTypeSpecifications", value);
    }

    /**
     * The specification applied to each worker type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWorkerTypeSpecifications(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            if (!(value.keySet().toArray()[0] instanceof String)) {
                throw new IllegalArgumentException(
                    new java.lang.StringBuilder("Expected ")
                        .append("value").append(".keySet()")
                        .append(" to contain class String; received ")
                        .append(value.keySet().toArray()[0].getClass()).toString());
            }
            for (final java.util.Map.Entry<String, java.lang.Object> __item_ac66f0: value.entrySet()) {
                final java.lang.Object __val_ac66f0 = __item_ac66f0.getValue();
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.emrserverless.CfnApplication.WorkerTypeSpecificationInputProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(\"").append((__item_ac66f0.getKey())).append("\")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.emrserverless.CfnApplication.WorkerTypeSpecificationInputProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "workerTypeSpecifications", value);
    }
    /**
     * The configuration for an application to automatically start on job submission.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emrserverless.*;
     * AutoStartConfigurationProperty autoStartConfigurationProperty = AutoStartConfigurationProperty.builder()
     *         .enabled(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-autostartconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-autostartconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emrserverless.CfnApplication.AutoStartConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AutoStartConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AutoStartConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Enables the application to automatically start on job submission.
         * <p>
         * Default: - true
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-autostartconfiguration.html#cfn-emrserverless-application-autostartconfiguration-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-autostartconfiguration.html#cfn-emrserverless-application-autostartconfiguration-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AutoStartConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AutoStartConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AutoStartConfigurationProperty> {
            java.lang.Object enabled;

            /**
             * Sets the value of {@link AutoStartConfigurationProperty#getEnabled}
             * @param enabled Enables the application to automatically start on job submission.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link AutoStartConfigurationProperty#getEnabled}
             * @param enabled Enables the application to automatically start on job submission.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AutoStartConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AutoStartConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AutoStartConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AutoStartConfigurationProperty {
            private final java.lang.Object enabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = builder.enabled;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emrserverless.CfnApplication.AutoStartConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AutoStartConfigurationProperty.Jsii$Proxy that = (AutoStartConfigurationProperty.Jsii$Proxy) o;

                return this.enabled != null ? this.enabled.equals(that.enabled) : that.enabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The configuration for an application to automatically stop after a certain amount of time being idle.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emrserverless.*;
     * AutoStopConfigurationProperty autoStopConfigurationProperty = AutoStopConfigurationProperty.builder()
     *         .enabled(false)
     *         .idleTimeoutMinutes(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-autostopconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-autostopconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emrserverless.CfnApplication.AutoStopConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AutoStopConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AutoStopConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Enables the application to automatically stop after a certain amount of time being idle.
         * <p>
         * Defaults to true.
         * <p>
         * Default: - true
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-autostopconfiguration.html#cfn-emrserverless-application-autostopconfiguration-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-autostopconfiguration.html#cfn-emrserverless-application-autostopconfiguration-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * The amount of idle time in minutes after which your application will automatically stop.
         * <p>
         * Defaults to 15 minutes.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-autostopconfiguration.html#cfn-emrserverless-application-autostopconfiguration-idletimeoutminutes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-autostopconfiguration.html#cfn-emrserverless-application-autostopconfiguration-idletimeoutminutes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIdleTimeoutMinutes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AutoStopConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AutoStopConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AutoStopConfigurationProperty> {
            java.lang.Object enabled;
            java.lang.Number idleTimeoutMinutes;

            /**
             * Sets the value of {@link AutoStopConfigurationProperty#getEnabled}
             * @param enabled Enables the application to automatically stop after a certain amount of time being idle.
             *                Defaults to true.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link AutoStopConfigurationProperty#getEnabled}
             * @param enabled Enables the application to automatically stop after a certain amount of time being idle.
             *                Defaults to true.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link AutoStopConfigurationProperty#getIdleTimeoutMinutes}
             * @param idleTimeoutMinutes The amount of idle time in minutes after which your application will automatically stop.
             *                           Defaults to 15 minutes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder idleTimeoutMinutes(java.lang.Number idleTimeoutMinutes) {
                this.idleTimeoutMinutes = idleTimeoutMinutes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AutoStopConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AutoStopConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AutoStopConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AutoStopConfigurationProperty {
            private final java.lang.Object enabled;
            private final java.lang.Number idleTimeoutMinutes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.idleTimeoutMinutes = software.amazon.jsii.Kernel.get(this, "idleTimeoutMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = builder.enabled;
                this.idleTimeoutMinutes = builder.idleTimeoutMinutes;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.Number getIdleTimeoutMinutes() {
                return this.idleTimeoutMinutes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }
                if (this.getIdleTimeoutMinutes() != null) {
                    data.set("idleTimeoutMinutes", om.valueToTree(this.getIdleTimeoutMinutes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emrserverless.CfnApplication.AutoStopConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AutoStopConfigurationProperty.Jsii$Proxy that = (AutoStopConfigurationProperty.Jsii$Proxy) o;

                if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
                return this.idleTimeoutMinutes != null ? this.idleTimeoutMinutes.equals(that.idleTimeoutMinutes) : that.idleTimeoutMinutes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                result = 31 * result + (this.idleTimeoutMinutes != null ? this.idleTimeoutMinutes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The Amazon CloudWatch configuration for monitoring logs.
     * <p>
     * You can configure your jobs to send log information to CloudWatch.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emrserverless.*;
     * CloudWatchLoggingConfigurationProperty cloudWatchLoggingConfigurationProperty = CloudWatchLoggingConfigurationProperty.builder()
     *         .enabled(false)
     *         .encryptionKeyArn("encryptionKeyArn")
     *         .logGroupName("logGroupName")
     *         .logStreamNamePrefix("logStreamNamePrefix")
     *         .logTypeMap(List.of(LogTypeMapKeyValuePairProperty.builder()
     *                 .key("key")
     *                 .value(List.of("value"))
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-cloudwatchloggingconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-cloudwatchloggingconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emrserverless.CfnApplication.CloudWatchLoggingConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(CloudWatchLoggingConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CloudWatchLoggingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Enables CloudWatch logging.
         * <p>
         * Default: - false
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-cloudwatchloggingconfiguration.html#cfn-emrserverless-application-cloudwatchloggingconfiguration-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-cloudwatchloggingconfiguration.html#cfn-emrserverless-application-cloudwatchloggingconfiguration-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * The AWS Key Management Service (KMS) key ARN to encrypt the logs that you store in CloudWatch Logs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-cloudwatchloggingconfiguration.html#cfn-emrserverless-application-cloudwatchloggingconfiguration-encryptionkeyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-cloudwatchloggingconfiguration.html#cfn-emrserverless-application-cloudwatchloggingconfiguration-encryptionkeyarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEncryptionKeyArn() {
            return null;
        }

        /**
         * The name of the log group in Amazon CloudWatch Logs where you want to publish your logs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-cloudwatchloggingconfiguration.html#cfn-emrserverless-application-cloudwatchloggingconfiguration-loggroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-cloudwatchloggingconfiguration.html#cfn-emrserverless-application-cloudwatchloggingconfiguration-loggroupname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLogGroupName() {
            return null;
        }

        /**
         * Prefix for the CloudWatch log stream name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-cloudwatchloggingconfiguration.html#cfn-emrserverless-application-cloudwatchloggingconfiguration-logstreamnameprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-cloudwatchloggingconfiguration.html#cfn-emrserverless-application-cloudwatchloggingconfiguration-logstreamnameprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLogStreamNamePrefix() {
            return null;
        }

        /**
         * The specific log-streams which need to be uploaded to CloudWatch.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-cloudwatchloggingconfiguration.html#cfn-emrserverless-application-cloudwatchloggingconfiguration-logtypemap">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-cloudwatchloggingconfiguration.html#cfn-emrserverless-application-cloudwatchloggingconfiguration-logtypemap</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLogTypeMap() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CloudWatchLoggingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CloudWatchLoggingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CloudWatchLoggingConfigurationProperty> {
            java.lang.Object enabled;
            java.lang.String encryptionKeyArn;
            java.lang.String logGroupName;
            java.lang.String logStreamNamePrefix;
            java.lang.Object logTypeMap;

            /**
             * Sets the value of {@link CloudWatchLoggingConfigurationProperty#getEnabled}
             * @param enabled Enables CloudWatch logging.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchLoggingConfigurationProperty#getEnabled}
             * @param enabled Enables CloudWatch logging.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchLoggingConfigurationProperty#getEncryptionKeyArn}
             * @param encryptionKeyArn The AWS Key Management Service (KMS) key ARN to encrypt the logs that you store in CloudWatch Logs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionKeyArn(java.lang.String encryptionKeyArn) {
                this.encryptionKeyArn = encryptionKeyArn;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchLoggingConfigurationProperty#getLogGroupName}
             * @param logGroupName The name of the log group in Amazon CloudWatch Logs where you want to publish your logs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logGroupName(java.lang.String logGroupName) {
                this.logGroupName = logGroupName;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchLoggingConfigurationProperty#getLogStreamNamePrefix}
             * @param logStreamNamePrefix Prefix for the CloudWatch log stream name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logStreamNamePrefix(java.lang.String logStreamNamePrefix) {
                this.logStreamNamePrefix = logStreamNamePrefix;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchLoggingConfigurationProperty#getLogTypeMap}
             * @param logTypeMap The specific log-streams which need to be uploaded to CloudWatch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logTypeMap(software.amazon.awscdk.IResolvable logTypeMap) {
                this.logTypeMap = logTypeMap;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchLoggingConfigurationProperty#getLogTypeMap}
             * @param logTypeMap The specific log-streams which need to be uploaded to CloudWatch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logTypeMap(java.util.List<? extends java.lang.Object> logTypeMap) {
                this.logTypeMap = logTypeMap;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CloudWatchLoggingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CloudWatchLoggingConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CloudWatchLoggingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudWatchLoggingConfigurationProperty {
            private final java.lang.Object enabled;
            private final java.lang.String encryptionKeyArn;
            private final java.lang.String logGroupName;
            private final java.lang.String logStreamNamePrefix;
            private final java.lang.Object logTypeMap;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.encryptionKeyArn = software.amazon.jsii.Kernel.get(this, "encryptionKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.logGroupName = software.amazon.jsii.Kernel.get(this, "logGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.logStreamNamePrefix = software.amazon.jsii.Kernel.get(this, "logStreamNamePrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.logTypeMap = software.amazon.jsii.Kernel.get(this, "logTypeMap", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = builder.enabled;
                this.encryptionKeyArn = builder.encryptionKeyArn;
                this.logGroupName = builder.logGroupName;
                this.logStreamNamePrefix = builder.logStreamNamePrefix;
                this.logTypeMap = builder.logTypeMap;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.String getEncryptionKeyArn() {
                return this.encryptionKeyArn;
            }

            @Override
            public final java.lang.String getLogGroupName() {
                return this.logGroupName;
            }

            @Override
            public final java.lang.String getLogStreamNamePrefix() {
                return this.logStreamNamePrefix;
            }

            @Override
            public final java.lang.Object getLogTypeMap() {
                return this.logTypeMap;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }
                if (this.getEncryptionKeyArn() != null) {
                    data.set("encryptionKeyArn", om.valueToTree(this.getEncryptionKeyArn()));
                }
                if (this.getLogGroupName() != null) {
                    data.set("logGroupName", om.valueToTree(this.getLogGroupName()));
                }
                if (this.getLogStreamNamePrefix() != null) {
                    data.set("logStreamNamePrefix", om.valueToTree(this.getLogStreamNamePrefix()));
                }
                if (this.getLogTypeMap() != null) {
                    data.set("logTypeMap", om.valueToTree(this.getLogTypeMap()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emrserverless.CfnApplication.CloudWatchLoggingConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CloudWatchLoggingConfigurationProperty.Jsii$Proxy that = (CloudWatchLoggingConfigurationProperty.Jsii$Proxy) o;

                if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
                if (this.encryptionKeyArn != null ? !this.encryptionKeyArn.equals(that.encryptionKeyArn) : that.encryptionKeyArn != null) return false;
                if (this.logGroupName != null ? !this.logGroupName.equals(that.logGroupName) : that.logGroupName != null) return false;
                if (this.logStreamNamePrefix != null ? !this.logStreamNamePrefix.equals(that.logStreamNamePrefix) : that.logStreamNamePrefix != null) return false;
                return this.logTypeMap != null ? this.logTypeMap.equals(that.logTypeMap) : that.logTypeMap == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                result = 31 * result + (this.encryptionKeyArn != null ? this.encryptionKeyArn.hashCode() : 0);
                result = 31 * result + (this.logGroupName != null ? this.logGroupName.hashCode() : 0);
                result = 31 * result + (this.logStreamNamePrefix != null ? this.logStreamNamePrefix.hashCode() : 0);
                result = 31 * result + (this.logTypeMap != null ? this.logTypeMap.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A configuration specification to be used when provisioning an application.
     * <p>
     * A configuration consists of a classification, properties, and optional nested configurations. A classification refers to an application-specific configuration file. Properties are the settings you want to change in that file.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emrserverless.*;
     * ConfigurationObjectProperty configurationObjectProperty_;
     * ConfigurationObjectProperty configurationObjectProperty = ConfigurationObjectProperty.builder()
     *         .classification("classification")
     *         // the properties below are optional
     *         .configurations(List.of(configurationObjectProperty_))
     *         .properties(Map.of(
     *                 "propertiesKey", "properties"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-configurationobject.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-configurationobject.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emrserverless.CfnApplication.ConfigurationObjectProperty")
    @software.amazon.jsii.Jsii.Proxy(ConfigurationObjectProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConfigurationObjectProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The classification within a configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-configurationobject.html#cfn-emrserverless-application-configurationobject-classification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-configurationobject.html#cfn-emrserverless-application-configurationobject-classification</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClassification();

        /**
         * A list of additional configurations to apply within a configuration object.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-configurationobject.html#cfn-emrserverless-application-configurationobject-configurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-configurationobject.html#cfn-emrserverless-application-configurationobject-configurations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConfigurations() {
            return null;
        }

        /**
         * A set of properties specified within a configuration classification.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-configurationobject.html#cfn-emrserverless-application-configurationobject-properties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-configurationobject.html#cfn-emrserverless-application-configurationobject-properties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProperties() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConfigurationObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConfigurationObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConfigurationObjectProperty> {
            java.lang.String classification;
            java.lang.Object configurations;
            java.lang.Object properties;

            /**
             * Sets the value of {@link ConfigurationObjectProperty#getClassification}
             * @param classification The classification within a configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder classification(java.lang.String classification) {
                this.classification = classification;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationObjectProperty#getConfigurations}
             * @param configurations A list of additional configurations to apply within a configuration object.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configurations(software.amazon.awscdk.IResolvable configurations) {
                this.configurations = configurations;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationObjectProperty#getConfigurations}
             * @param configurations A list of additional configurations to apply within a configuration object.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configurations(java.util.List<? extends java.lang.Object> configurations) {
                this.configurations = configurations;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationObjectProperty#getProperties}
             * @param properties A set of properties specified within a configuration classification.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder properties(java.util.Map<java.lang.String, java.lang.String> properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationObjectProperty#getProperties}
             * @param properties A set of properties specified within a configuration classification.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder properties(software.amazon.awscdk.IResolvable properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConfigurationObjectProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConfigurationObjectProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConfigurationObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConfigurationObjectProperty {
            private final java.lang.String classification;
            private final java.lang.Object configurations;
            private final java.lang.Object properties;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.classification = software.amazon.jsii.Kernel.get(this, "classification", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.configurations = software.amazon.jsii.Kernel.get(this, "configurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.properties = software.amazon.jsii.Kernel.get(this, "properties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.classification = java.util.Objects.requireNonNull(builder.classification, "classification is required");
                this.configurations = builder.configurations;
                this.properties = builder.properties;
            }

            @Override
            public final java.lang.String getClassification() {
                return this.classification;
            }

            @Override
            public final java.lang.Object getConfigurations() {
                return this.configurations;
            }

            @Override
            public final java.lang.Object getProperties() {
                return this.properties;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("classification", om.valueToTree(this.getClassification()));
                if (this.getConfigurations() != null) {
                    data.set("configurations", om.valueToTree(this.getConfigurations()));
                }
                if (this.getProperties() != null) {
                    data.set("properties", om.valueToTree(this.getProperties()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emrserverless.CfnApplication.ConfigurationObjectProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConfigurationObjectProperty.Jsii$Proxy that = (ConfigurationObjectProperty.Jsii$Proxy) o;

                if (!classification.equals(that.classification)) return false;
                if (this.configurations != null ? !this.configurations.equals(that.configurations) : that.configurations != null) return false;
                return this.properties != null ? this.properties.equals(that.properties) : that.properties == null;
            }

            @Override
            public final int hashCode() {
                int result = this.classification.hashCode();
                result = 31 * result + (this.configurations != null ? this.configurations.hashCode() : 0);
                result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The image configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emrserverless.*;
     * ImageConfigurationInputProperty imageConfigurationInputProperty = ImageConfigurationInputProperty.builder()
     *         .imageUri("imageUri")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-imageconfigurationinput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-imageconfigurationinput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emrserverless.CfnApplication.ImageConfigurationInputProperty")
    @software.amazon.jsii.Jsii.Proxy(ImageConfigurationInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ImageConfigurationInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The URI of an image in the Amazon ECR registry.
         * <p>
         * This field is required when you create a new application. If you leave this field blank in an update, Amazon EMR will remove the image configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-imageconfigurationinput.html#cfn-emrserverless-application-imageconfigurationinput-imageuri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-imageconfigurationinput.html#cfn-emrserverless-application-imageconfigurationinput-imageuri</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getImageUri() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ImageConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ImageConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ImageConfigurationInputProperty> {
            java.lang.String imageUri;

            /**
             * Sets the value of {@link ImageConfigurationInputProperty#getImageUri}
             * @param imageUri The URI of an image in the Amazon ECR registry.
             *                 This field is required when you create a new application. If you leave this field blank in an update, Amazon EMR will remove the image configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageUri(java.lang.String imageUri) {
                this.imageUri = imageUri;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ImageConfigurationInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ImageConfigurationInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ImageConfigurationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ImageConfigurationInputProperty {
            private final java.lang.String imageUri;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.imageUri = software.amazon.jsii.Kernel.get(this, "imageUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.imageUri = builder.imageUri;
            }

            @Override
            public final java.lang.String getImageUri() {
                return this.imageUri;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getImageUri() != null) {
                    data.set("imageUri", om.valueToTree(this.getImageUri()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emrserverless.CfnApplication.ImageConfigurationInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ImageConfigurationInputProperty.Jsii$Proxy that = (ImageConfigurationInputProperty.Jsii$Proxy) o;

                return this.imageUri != null ? this.imageUri.equals(that.imageUri) : that.imageUri == null;
            }

            @Override
            public final int hashCode() {
                int result = this.imageUri != null ? this.imageUri.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emrserverless.*;
     * InitialCapacityConfigKeyValuePairProperty initialCapacityConfigKeyValuePairProperty = InitialCapacityConfigKeyValuePairProperty.builder()
     *         .key("key")
     *         .value(InitialCapacityConfigProperty.builder()
     *                 .workerConfiguration(WorkerConfigurationProperty.builder()
     *                         .cpu("cpu")
     *                         .memory("memory")
     *                         // the properties below are optional
     *                         .disk("disk")
     *                         .diskType("diskType")
     *                         .build())
     *                 .workerCount(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-initialcapacityconfigkeyvaluepair.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-initialcapacityconfigkeyvaluepair.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emrserverless.CfnApplication.InitialCapacityConfigKeyValuePairProperty")
    @software.amazon.jsii.Jsii.Proxy(InitialCapacityConfigKeyValuePairProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InitialCapacityConfigKeyValuePairProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Worker type for an analytics framework.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-initialcapacityconfigkeyvaluepair.html#cfn-emrserverless-application-initialcapacityconfigkeyvaluepair-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-initialcapacityconfigkeyvaluepair.html#cfn-emrserverless-application-initialcapacityconfigkeyvaluepair-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-initialcapacityconfigkeyvaluepair.html#cfn-emrserverless-application-initialcapacityconfigkeyvaluepair-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-initialcapacityconfigkeyvaluepair.html#cfn-emrserverless-application-initialcapacityconfigkeyvaluepair-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getValue();

        /**
         * @return a {@link Builder} of {@link InitialCapacityConfigKeyValuePairProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InitialCapacityConfigKeyValuePairProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InitialCapacityConfigKeyValuePairProperty> {
            java.lang.String key;
            java.lang.Object value;

            /**
             * Sets the value of {@link InitialCapacityConfigKeyValuePairProperty#getKey}
             * @param key Worker type for an analytics framework. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link InitialCapacityConfigKeyValuePairProperty#getValue}
             * @param value the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(software.amazon.awscdk.IResolvable value) {
                this.value = value;
                return this;
            }

            /**
             * Sets the value of {@link InitialCapacityConfigKeyValuePairProperty#getValue}
             * @param value the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(software.amazon.awscdk.services.emrserverless.CfnApplication.InitialCapacityConfigProperty value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InitialCapacityConfigKeyValuePairProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InitialCapacityConfigKeyValuePairProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InitialCapacityConfigKeyValuePairProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InitialCapacityConfigKeyValuePairProperty {
            private final java.lang.String key;
            private final java.lang.Object value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.Object getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emrserverless.CfnApplication.InitialCapacityConfigKeyValuePairProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InitialCapacityConfigKeyValuePairProperty.Jsii$Proxy that = (InitialCapacityConfigKeyValuePairProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * The initial capacity configuration per worker.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emrserverless.*;
     * InitialCapacityConfigProperty initialCapacityConfigProperty = InitialCapacityConfigProperty.builder()
     *         .workerConfiguration(WorkerConfigurationProperty.builder()
     *                 .cpu("cpu")
     *                 .memory("memory")
     *                 // the properties below are optional
     *                 .disk("disk")
     *                 .diskType("diskType")
     *                 .build())
     *         .workerCount(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-initialcapacityconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-initialcapacityconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emrserverless.CfnApplication.InitialCapacityConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(InitialCapacityConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InitialCapacityConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The resource configuration of the initial capacity configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-initialcapacityconfig.html#cfn-emrserverless-application-initialcapacityconfig-workerconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-initialcapacityconfig.html#cfn-emrserverless-application-initialcapacityconfig-workerconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getWorkerConfiguration();

        /**
         * The number of workers in the initial capacity configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-initialcapacityconfig.html#cfn-emrserverless-application-initialcapacityconfig-workercount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-initialcapacityconfig.html#cfn-emrserverless-application-initialcapacityconfig-workercount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getWorkerCount();

        /**
         * @return a {@link Builder} of {@link InitialCapacityConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InitialCapacityConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InitialCapacityConfigProperty> {
            java.lang.Object workerConfiguration;
            java.lang.Number workerCount;

            /**
             * Sets the value of {@link InitialCapacityConfigProperty#getWorkerConfiguration}
             * @param workerConfiguration The resource configuration of the initial capacity configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder workerConfiguration(software.amazon.awscdk.IResolvable workerConfiguration) {
                this.workerConfiguration = workerConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link InitialCapacityConfigProperty#getWorkerConfiguration}
             * @param workerConfiguration The resource configuration of the initial capacity configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder workerConfiguration(software.amazon.awscdk.services.emrserverless.CfnApplication.WorkerConfigurationProperty workerConfiguration) {
                this.workerConfiguration = workerConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link InitialCapacityConfigProperty#getWorkerCount}
             * @param workerCount The number of workers in the initial capacity configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder workerCount(java.lang.Number workerCount) {
                this.workerCount = workerCount;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InitialCapacityConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InitialCapacityConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InitialCapacityConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InitialCapacityConfigProperty {
            private final java.lang.Object workerConfiguration;
            private final java.lang.Number workerCount;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.workerConfiguration = software.amazon.jsii.Kernel.get(this, "workerConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.workerCount = software.amazon.jsii.Kernel.get(this, "workerCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.workerConfiguration = java.util.Objects.requireNonNull(builder.workerConfiguration, "workerConfiguration is required");
                this.workerCount = java.util.Objects.requireNonNull(builder.workerCount, "workerCount is required");
            }

            @Override
            public final java.lang.Object getWorkerConfiguration() {
                return this.workerConfiguration;
            }

            @Override
            public final java.lang.Number getWorkerCount() {
                return this.workerCount;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("workerConfiguration", om.valueToTree(this.getWorkerConfiguration()));
                data.set("workerCount", om.valueToTree(this.getWorkerCount()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emrserverless.CfnApplication.InitialCapacityConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InitialCapacityConfigProperty.Jsii$Proxy that = (InitialCapacityConfigProperty.Jsii$Proxy) o;

                if (!workerConfiguration.equals(that.workerConfiguration)) return false;
                return this.workerCount.equals(that.workerCount);
            }

            @Override
            public final int hashCode() {
                int result = this.workerConfiguration.hashCode();
                result = 31 * result + (this.workerCount.hashCode());
                return result;
            }
        }
    }
    /**
     * The configuration to use to enable the different types of interactive use cases in an application.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emrserverless.*;
     * InteractiveConfigurationProperty interactiveConfigurationProperty = InteractiveConfigurationProperty.builder()
     *         .livyEndpointEnabled(false)
     *         .studioEnabled(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-interactiveconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-interactiveconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emrserverless.CfnApplication.InteractiveConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(InteractiveConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InteractiveConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Enables an Apache Livy endpoint that you can connect to and run interactive jobs.
         * <p>
         * Default: - false
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-interactiveconfiguration.html#cfn-emrserverless-application-interactiveconfiguration-livyendpointenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-interactiveconfiguration.html#cfn-emrserverless-application-interactiveconfiguration-livyendpointenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLivyEndpointEnabled() {
            return null;
        }

        /**
         * Enables you to connect an application to Amazon EMR Studio to run interactive workloads in a notebook.
         * <p>
         * Default: - false
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-interactiveconfiguration.html#cfn-emrserverless-application-interactiveconfiguration-studioenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-interactiveconfiguration.html#cfn-emrserverless-application-interactiveconfiguration-studioenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStudioEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InteractiveConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InteractiveConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InteractiveConfigurationProperty> {
            java.lang.Object livyEndpointEnabled;
            java.lang.Object studioEnabled;

            /**
             * Sets the value of {@link InteractiveConfigurationProperty#getLivyEndpointEnabled}
             * @param livyEndpointEnabled Enables an Apache Livy endpoint that you can connect to and run interactive jobs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder livyEndpointEnabled(java.lang.Boolean livyEndpointEnabled) {
                this.livyEndpointEnabled = livyEndpointEnabled;
                return this;
            }

            /**
             * Sets the value of {@link InteractiveConfigurationProperty#getLivyEndpointEnabled}
             * @param livyEndpointEnabled Enables an Apache Livy endpoint that you can connect to and run interactive jobs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder livyEndpointEnabled(software.amazon.awscdk.IResolvable livyEndpointEnabled) {
                this.livyEndpointEnabled = livyEndpointEnabled;
                return this;
            }

            /**
             * Sets the value of {@link InteractiveConfigurationProperty#getStudioEnabled}
             * @param studioEnabled Enables you to connect an application to Amazon EMR Studio to run interactive workloads in a notebook.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder studioEnabled(java.lang.Boolean studioEnabled) {
                this.studioEnabled = studioEnabled;
                return this;
            }

            /**
             * Sets the value of {@link InteractiveConfigurationProperty#getStudioEnabled}
             * @param studioEnabled Enables you to connect an application to Amazon EMR Studio to run interactive workloads in a notebook.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder studioEnabled(software.amazon.awscdk.IResolvable studioEnabled) {
                this.studioEnabled = studioEnabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InteractiveConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InteractiveConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InteractiveConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InteractiveConfigurationProperty {
            private final java.lang.Object livyEndpointEnabled;
            private final java.lang.Object studioEnabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.livyEndpointEnabled = software.amazon.jsii.Kernel.get(this, "livyEndpointEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.studioEnabled = software.amazon.jsii.Kernel.get(this, "studioEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.livyEndpointEnabled = builder.livyEndpointEnabled;
                this.studioEnabled = builder.studioEnabled;
            }

            @Override
            public final java.lang.Object getLivyEndpointEnabled() {
                return this.livyEndpointEnabled;
            }

            @Override
            public final java.lang.Object getStudioEnabled() {
                return this.studioEnabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLivyEndpointEnabled() != null) {
                    data.set("livyEndpointEnabled", om.valueToTree(this.getLivyEndpointEnabled()));
                }
                if (this.getStudioEnabled() != null) {
                    data.set("studioEnabled", om.valueToTree(this.getStudioEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emrserverless.CfnApplication.InteractiveConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InteractiveConfigurationProperty.Jsii$Proxy that = (InteractiveConfigurationProperty.Jsii$Proxy) o;

                if (this.livyEndpointEnabled != null ? !this.livyEndpointEnabled.equals(that.livyEndpointEnabled) : that.livyEndpointEnabled != null) return false;
                return this.studioEnabled != null ? this.studioEnabled.equals(that.studioEnabled) : that.studioEnabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.livyEndpointEnabled != null ? this.livyEndpointEnabled.hashCode() : 0;
                result = 31 * result + (this.studioEnabled != null ? this.studioEnabled.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emrserverless.*;
     * LogTypeMapKeyValuePairProperty logTypeMapKeyValuePairProperty = LogTypeMapKeyValuePairProperty.builder()
     *         .key("key")
     *         .value(List.of("value"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-logtypemapkeyvaluepair.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-logtypemapkeyvaluepair.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emrserverless.CfnApplication.LogTypeMapKeyValuePairProperty")
    @software.amazon.jsii.Jsii.Proxy(LogTypeMapKeyValuePairProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LogTypeMapKeyValuePairProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-logtypemapkeyvaluepair.html#cfn-emrserverless-application-logtypemapkeyvaluepair-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-logtypemapkeyvaluepair.html#cfn-emrserverless-application-logtypemapkeyvaluepair-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * List of Applicable values: [STDOUT, STDERR, HIVE_LOG, TEZ_AM, SYSTEM_LOGS].
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-logtypemapkeyvaluepair.html#cfn-emrserverless-application-logtypemapkeyvaluepair-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-logtypemapkeyvaluepair.html#cfn-emrserverless-application-logtypemapkeyvaluepair-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getValue();

        /**
         * @return a {@link Builder} of {@link LogTypeMapKeyValuePairProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LogTypeMapKeyValuePairProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LogTypeMapKeyValuePairProperty> {
            java.lang.String key;
            java.util.List<java.lang.String> value;

            /**
             * Sets the value of {@link LogTypeMapKeyValuePairProperty#getKey}
             * @param key the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link LogTypeMapKeyValuePairProperty#getValue}
             * @param value List of Applicable values: [STDOUT, STDERR, HIVE_LOG, TEZ_AM, SYSTEM_LOGS]. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.util.List<java.lang.String> value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LogTypeMapKeyValuePairProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LogTypeMapKeyValuePairProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LogTypeMapKeyValuePairProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogTypeMapKeyValuePairProperty {
            private final java.lang.String key;
            private final java.util.List<java.lang.String> value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.util.List<java.lang.String> getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emrserverless.CfnApplication.LogTypeMapKeyValuePairProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LogTypeMapKeyValuePairProperty.Jsii$Proxy that = (LogTypeMapKeyValuePairProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * The managed log persistence configuration for a job run.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emrserverless.*;
     * ManagedPersistenceMonitoringConfigurationProperty managedPersistenceMonitoringConfigurationProperty = ManagedPersistenceMonitoringConfigurationProperty.builder()
     *         .enabled(false)
     *         .encryptionKeyArn("encryptionKeyArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-managedpersistencemonitoringconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-managedpersistencemonitoringconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emrserverless.CfnApplication.ManagedPersistenceMonitoringConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ManagedPersistenceMonitoringConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ManagedPersistenceMonitoringConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Enables managed logging and defaults to true.
         * <p>
         * If set to false, managed logging will be turned off.
         * <p>
         * Default: - true
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-managedpersistencemonitoringconfiguration.html#cfn-emrserverless-application-managedpersistencemonitoringconfiguration-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-managedpersistencemonitoringconfiguration.html#cfn-emrserverless-application-managedpersistencemonitoringconfiguration-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * The KMS key ARN to encrypt the logs stored in managed log persistence.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-managedpersistencemonitoringconfiguration.html#cfn-emrserverless-application-managedpersistencemonitoringconfiguration-encryptionkeyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-managedpersistencemonitoringconfiguration.html#cfn-emrserverless-application-managedpersistencemonitoringconfiguration-encryptionkeyarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEncryptionKeyArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ManagedPersistenceMonitoringConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ManagedPersistenceMonitoringConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ManagedPersistenceMonitoringConfigurationProperty> {
            java.lang.Object enabled;
            java.lang.String encryptionKeyArn;

            /**
             * Sets the value of {@link ManagedPersistenceMonitoringConfigurationProperty#getEnabled}
             * @param enabled Enables managed logging and defaults to true.
             *                If set to false, managed logging will be turned off.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link ManagedPersistenceMonitoringConfigurationProperty#getEnabled}
             * @param enabled Enables managed logging and defaults to true.
             *                If set to false, managed logging will be turned off.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link ManagedPersistenceMonitoringConfigurationProperty#getEncryptionKeyArn}
             * @param encryptionKeyArn The KMS key ARN to encrypt the logs stored in managed log persistence.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionKeyArn(java.lang.String encryptionKeyArn) {
                this.encryptionKeyArn = encryptionKeyArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ManagedPersistenceMonitoringConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ManagedPersistenceMonitoringConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ManagedPersistenceMonitoringConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ManagedPersistenceMonitoringConfigurationProperty {
            private final java.lang.Object enabled;
            private final java.lang.String encryptionKeyArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.encryptionKeyArn = software.amazon.jsii.Kernel.get(this, "encryptionKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = builder.enabled;
                this.encryptionKeyArn = builder.encryptionKeyArn;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.String getEncryptionKeyArn() {
                return this.encryptionKeyArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }
                if (this.getEncryptionKeyArn() != null) {
                    data.set("encryptionKeyArn", om.valueToTree(this.getEncryptionKeyArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emrserverless.CfnApplication.ManagedPersistenceMonitoringConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ManagedPersistenceMonitoringConfigurationProperty.Jsii$Proxy that = (ManagedPersistenceMonitoringConfigurationProperty.Jsii$Proxy) o;

                if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
                return this.encryptionKeyArn != null ? this.encryptionKeyArn.equals(that.encryptionKeyArn) : that.encryptionKeyArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                result = 31 * result + (this.encryptionKeyArn != null ? this.encryptionKeyArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The maximum allowed cumulative resources for an application.
     * <p>
     * No new resources will be created once the limit is hit.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emrserverless.*;
     * MaximumAllowedResourcesProperty maximumAllowedResourcesProperty = MaximumAllowedResourcesProperty.builder()
     *         .cpu("cpu")
     *         .memory("memory")
     *         // the properties below are optional
     *         .disk("disk")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-maximumallowedresources.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-maximumallowedresources.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emrserverless.CfnApplication.MaximumAllowedResourcesProperty")
    @software.amazon.jsii.Jsii.Proxy(MaximumAllowedResourcesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MaximumAllowedResourcesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum allowed CPU for an application.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-maximumallowedresources.html#cfn-emrserverless-application-maximumallowedresources-cpu">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-maximumallowedresources.html#cfn-emrserverless-application-maximumallowedresources-cpu</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCpu();

        /**
         * The maximum allowed resources for an application.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-maximumallowedresources.html#cfn-emrserverless-application-maximumallowedresources-memory">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-maximumallowedresources.html#cfn-emrserverless-application-maximumallowedresources-memory</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMemory();

        /**
         * The maximum allowed disk for an application.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-maximumallowedresources.html#cfn-emrserverless-application-maximumallowedresources-disk">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-maximumallowedresources.html#cfn-emrserverless-application-maximumallowedresources-disk</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDisk() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MaximumAllowedResourcesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MaximumAllowedResourcesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MaximumAllowedResourcesProperty> {
            java.lang.String cpu;
            java.lang.String memory;
            java.lang.String disk;

            /**
             * Sets the value of {@link MaximumAllowedResourcesProperty#getCpu}
             * @param cpu The maximum allowed CPU for an application. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cpu(java.lang.String cpu) {
                this.cpu = cpu;
                return this;
            }

            /**
             * Sets the value of {@link MaximumAllowedResourcesProperty#getMemory}
             * @param memory The maximum allowed resources for an application. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memory(java.lang.String memory) {
                this.memory = memory;
                return this;
            }

            /**
             * Sets the value of {@link MaximumAllowedResourcesProperty#getDisk}
             * @param disk The maximum allowed disk for an application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disk(java.lang.String disk) {
                this.disk = disk;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MaximumAllowedResourcesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MaximumAllowedResourcesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MaximumAllowedResourcesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MaximumAllowedResourcesProperty {
            private final java.lang.String cpu;
            private final java.lang.String memory;
            private final java.lang.String disk;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cpu = software.amazon.jsii.Kernel.get(this, "cpu", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.memory = software.amazon.jsii.Kernel.get(this, "memory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.disk = software.amazon.jsii.Kernel.get(this, "disk", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cpu = java.util.Objects.requireNonNull(builder.cpu, "cpu is required");
                this.memory = java.util.Objects.requireNonNull(builder.memory, "memory is required");
                this.disk = builder.disk;
            }

            @Override
            public final java.lang.String getCpu() {
                return this.cpu;
            }

            @Override
            public final java.lang.String getMemory() {
                return this.memory;
            }

            @Override
            public final java.lang.String getDisk() {
                return this.disk;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("cpu", om.valueToTree(this.getCpu()));
                data.set("memory", om.valueToTree(this.getMemory()));
                if (this.getDisk() != null) {
                    data.set("disk", om.valueToTree(this.getDisk()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emrserverless.CfnApplication.MaximumAllowedResourcesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MaximumAllowedResourcesProperty.Jsii$Proxy that = (MaximumAllowedResourcesProperty.Jsii$Proxy) o;

                if (!cpu.equals(that.cpu)) return false;
                if (!memory.equals(that.memory)) return false;
                return this.disk != null ? this.disk.equals(that.disk) : that.disk == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cpu.hashCode();
                result = 31 * result + (this.memory.hashCode());
                result = 31 * result + (this.disk != null ? this.disk.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration setting for monitoring logs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emrserverless.*;
     * MonitoringConfigurationProperty monitoringConfigurationProperty = MonitoringConfigurationProperty.builder()
     *         .cloudWatchLoggingConfiguration(CloudWatchLoggingConfigurationProperty.builder()
     *                 .enabled(false)
     *                 .encryptionKeyArn("encryptionKeyArn")
     *                 .logGroupName("logGroupName")
     *                 .logStreamNamePrefix("logStreamNamePrefix")
     *                 .logTypeMap(List.of(LogTypeMapKeyValuePairProperty.builder()
     *                         .key("key")
     *                         .value(List.of("value"))
     *                         .build()))
     *                 .build())
     *         .managedPersistenceMonitoringConfiguration(ManagedPersistenceMonitoringConfigurationProperty.builder()
     *                 .enabled(false)
     *                 .encryptionKeyArn("encryptionKeyArn")
     *                 .build())
     *         .prometheusMonitoringConfiguration(PrometheusMonitoringConfigurationProperty.builder()
     *                 .remoteWriteUrl("remoteWriteUrl")
     *                 .build())
     *         .s3MonitoringConfiguration(S3MonitoringConfigurationProperty.builder()
     *                 .encryptionKeyArn("encryptionKeyArn")
     *                 .logUri("logUri")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-monitoringconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-monitoringconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emrserverless.CfnApplication.MonitoringConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(MonitoringConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MonitoringConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon CloudWatch configuration for monitoring logs.
         * <p>
         * You can configure your jobs to send log information to CloudWatch.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-monitoringconfiguration.html#cfn-emrserverless-application-monitoringconfiguration-cloudwatchloggingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-monitoringconfiguration.html#cfn-emrserverless-application-monitoringconfiguration-cloudwatchloggingconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudWatchLoggingConfiguration() {
            return null;
        }

        /**
         * The managed log persistence configuration for a job run.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-monitoringconfiguration.html#cfn-emrserverless-application-monitoringconfiguration-managedpersistencemonitoringconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-monitoringconfiguration.html#cfn-emrserverless-application-monitoringconfiguration-managedpersistencemonitoringconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getManagedPersistenceMonitoringConfiguration() {
            return null;
        }

        /**
         * The monitoring configuration object you can configure to send metrics to Amazon Managed Service for Prometheus for a job run.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-monitoringconfiguration.html#cfn-emrserverless-application-monitoringconfiguration-prometheusmonitoringconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-monitoringconfiguration.html#cfn-emrserverless-application-monitoringconfiguration-prometheusmonitoringconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPrometheusMonitoringConfiguration() {
            return null;
        }

        /**
         * The Amazon S3 configuration for monitoring log publishing.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-monitoringconfiguration.html#cfn-emrserverless-application-monitoringconfiguration-s3monitoringconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-monitoringconfiguration.html#cfn-emrserverless-application-monitoringconfiguration-s3monitoringconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3MonitoringConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MonitoringConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MonitoringConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MonitoringConfigurationProperty> {
            java.lang.Object cloudWatchLoggingConfiguration;
            java.lang.Object managedPersistenceMonitoringConfiguration;
            java.lang.Object prometheusMonitoringConfiguration;
            java.lang.Object s3MonitoringConfiguration;

            /**
             * Sets the value of {@link MonitoringConfigurationProperty#getCloudWatchLoggingConfiguration}
             * @param cloudWatchLoggingConfiguration The Amazon CloudWatch configuration for monitoring logs.
             *                                       You can configure your jobs to send log information to CloudWatch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLoggingConfiguration(software.amazon.awscdk.IResolvable cloudWatchLoggingConfiguration) {
                this.cloudWatchLoggingConfiguration = cloudWatchLoggingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringConfigurationProperty#getCloudWatchLoggingConfiguration}
             * @param cloudWatchLoggingConfiguration The Amazon CloudWatch configuration for monitoring logs.
             *                                       You can configure your jobs to send log information to CloudWatch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLoggingConfiguration(software.amazon.awscdk.services.emrserverless.CfnApplication.CloudWatchLoggingConfigurationProperty cloudWatchLoggingConfiguration) {
                this.cloudWatchLoggingConfiguration = cloudWatchLoggingConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringConfigurationProperty#getManagedPersistenceMonitoringConfiguration}
             * @param managedPersistenceMonitoringConfiguration The managed log persistence configuration for a job run.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder managedPersistenceMonitoringConfiguration(software.amazon.awscdk.IResolvable managedPersistenceMonitoringConfiguration) {
                this.managedPersistenceMonitoringConfiguration = managedPersistenceMonitoringConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringConfigurationProperty#getManagedPersistenceMonitoringConfiguration}
             * @param managedPersistenceMonitoringConfiguration The managed log persistence configuration for a job run.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder managedPersistenceMonitoringConfiguration(software.amazon.awscdk.services.emrserverless.CfnApplication.ManagedPersistenceMonitoringConfigurationProperty managedPersistenceMonitoringConfiguration) {
                this.managedPersistenceMonitoringConfiguration = managedPersistenceMonitoringConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringConfigurationProperty#getPrometheusMonitoringConfiguration}
             * @param prometheusMonitoringConfiguration The monitoring configuration object you can configure to send metrics to Amazon Managed Service for Prometheus for a job run.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prometheusMonitoringConfiguration(software.amazon.awscdk.IResolvable prometheusMonitoringConfiguration) {
                this.prometheusMonitoringConfiguration = prometheusMonitoringConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringConfigurationProperty#getPrometheusMonitoringConfiguration}
             * @param prometheusMonitoringConfiguration The monitoring configuration object you can configure to send metrics to Amazon Managed Service for Prometheus for a job run.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prometheusMonitoringConfiguration(software.amazon.awscdk.services.emrserverless.CfnApplication.PrometheusMonitoringConfigurationProperty prometheusMonitoringConfiguration) {
                this.prometheusMonitoringConfiguration = prometheusMonitoringConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringConfigurationProperty#getS3MonitoringConfiguration}
             * @param s3MonitoringConfiguration The Amazon S3 configuration for monitoring log publishing.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3MonitoringConfiguration(software.amazon.awscdk.IResolvable s3MonitoringConfiguration) {
                this.s3MonitoringConfiguration = s3MonitoringConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link MonitoringConfigurationProperty#getS3MonitoringConfiguration}
             * @param s3MonitoringConfiguration The Amazon S3 configuration for monitoring log publishing.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3MonitoringConfiguration(software.amazon.awscdk.services.emrserverless.CfnApplication.S3MonitoringConfigurationProperty s3MonitoringConfiguration) {
                this.s3MonitoringConfiguration = s3MonitoringConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MonitoringConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MonitoringConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MonitoringConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MonitoringConfigurationProperty {
            private final java.lang.Object cloudWatchLoggingConfiguration;
            private final java.lang.Object managedPersistenceMonitoringConfiguration;
            private final java.lang.Object prometheusMonitoringConfiguration;
            private final java.lang.Object s3MonitoringConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cloudWatchLoggingConfiguration = software.amazon.jsii.Kernel.get(this, "cloudWatchLoggingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.managedPersistenceMonitoringConfiguration = software.amazon.jsii.Kernel.get(this, "managedPersistenceMonitoringConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.prometheusMonitoringConfiguration = software.amazon.jsii.Kernel.get(this, "prometheusMonitoringConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3MonitoringConfiguration = software.amazon.jsii.Kernel.get(this, "s3MonitoringConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cloudWatchLoggingConfiguration = builder.cloudWatchLoggingConfiguration;
                this.managedPersistenceMonitoringConfiguration = builder.managedPersistenceMonitoringConfiguration;
                this.prometheusMonitoringConfiguration = builder.prometheusMonitoringConfiguration;
                this.s3MonitoringConfiguration = builder.s3MonitoringConfiguration;
            }

            @Override
            public final java.lang.Object getCloudWatchLoggingConfiguration() {
                return this.cloudWatchLoggingConfiguration;
            }

            @Override
            public final java.lang.Object getManagedPersistenceMonitoringConfiguration() {
                return this.managedPersistenceMonitoringConfiguration;
            }

            @Override
            public final java.lang.Object getPrometheusMonitoringConfiguration() {
                return this.prometheusMonitoringConfiguration;
            }

            @Override
            public final java.lang.Object getS3MonitoringConfiguration() {
                return this.s3MonitoringConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCloudWatchLoggingConfiguration() != null) {
                    data.set("cloudWatchLoggingConfiguration", om.valueToTree(this.getCloudWatchLoggingConfiguration()));
                }
                if (this.getManagedPersistenceMonitoringConfiguration() != null) {
                    data.set("managedPersistenceMonitoringConfiguration", om.valueToTree(this.getManagedPersistenceMonitoringConfiguration()));
                }
                if (this.getPrometheusMonitoringConfiguration() != null) {
                    data.set("prometheusMonitoringConfiguration", om.valueToTree(this.getPrometheusMonitoringConfiguration()));
                }
                if (this.getS3MonitoringConfiguration() != null) {
                    data.set("s3MonitoringConfiguration", om.valueToTree(this.getS3MonitoringConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emrserverless.CfnApplication.MonitoringConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MonitoringConfigurationProperty.Jsii$Proxy that = (MonitoringConfigurationProperty.Jsii$Proxy) o;

                if (this.cloudWatchLoggingConfiguration != null ? !this.cloudWatchLoggingConfiguration.equals(that.cloudWatchLoggingConfiguration) : that.cloudWatchLoggingConfiguration != null) return false;
                if (this.managedPersistenceMonitoringConfiguration != null ? !this.managedPersistenceMonitoringConfiguration.equals(that.managedPersistenceMonitoringConfiguration) : that.managedPersistenceMonitoringConfiguration != null) return false;
                if (this.prometheusMonitoringConfiguration != null ? !this.prometheusMonitoringConfiguration.equals(that.prometheusMonitoringConfiguration) : that.prometheusMonitoringConfiguration != null) return false;
                return this.s3MonitoringConfiguration != null ? this.s3MonitoringConfiguration.equals(that.s3MonitoringConfiguration) : that.s3MonitoringConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cloudWatchLoggingConfiguration != null ? this.cloudWatchLoggingConfiguration.hashCode() : 0;
                result = 31 * result + (this.managedPersistenceMonitoringConfiguration != null ? this.managedPersistenceMonitoringConfiguration.hashCode() : 0);
                result = 31 * result + (this.prometheusMonitoringConfiguration != null ? this.prometheusMonitoringConfiguration.hashCode() : 0);
                result = 31 * result + (this.s3MonitoringConfiguration != null ? this.s3MonitoringConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The network configuration for customer VPC connectivity.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emrserverless.*;
     * NetworkConfigurationProperty networkConfigurationProperty = NetworkConfigurationProperty.builder()
     *         .securityGroupIds(List.of("securityGroupIds"))
     *         .subnetIds(List.of("subnetIds"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-networkconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-networkconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emrserverless.CfnApplication.NetworkConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(NetworkConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NetworkConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The array of security group Ids for customer VPC connectivity.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-networkconfiguration.html#cfn-emrserverless-application-networkconfiguration-securitygroupids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-networkconfiguration.html#cfn-emrserverless-application-networkconfiguration-securitygroupids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroupIds() {
            return null;
        }

        /**
         * The array of subnet Ids for customer VPC connectivity.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-networkconfiguration.html#cfn-emrserverless-application-networkconfiguration-subnetids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-networkconfiguration.html#cfn-emrserverless-application-networkconfiguration-subnetids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSubnetIds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NetworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NetworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NetworkConfigurationProperty> {
            java.util.List<java.lang.String> securityGroupIds;
            java.util.List<java.lang.String> subnetIds;

            /**
             * Sets the value of {@link NetworkConfigurationProperty#getSecurityGroupIds}
             * @param securityGroupIds The array of security group Ids for customer VPC connectivity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            /**
             * Sets the value of {@link NetworkConfigurationProperty#getSubnetIds}
             * @param subnetIds The array of subnet Ids for customer VPC connectivity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnetIds(java.util.List<java.lang.String> subnetIds) {
                this.subnetIds = subnetIds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NetworkConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NetworkConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NetworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkConfigurationProperty {
            private final java.util.List<java.lang.String> securityGroupIds;
            private final java.util.List<java.lang.String> subnetIds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.securityGroupIds = software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.subnetIds = software.amazon.jsii.Kernel.get(this, "subnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.securityGroupIds = builder.securityGroupIds;
                this.subnetIds = builder.subnetIds;
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroupIds() {
                return this.securityGroupIds;
            }

            @Override
            public final java.util.List<java.lang.String> getSubnetIds() {
                return this.subnetIds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSecurityGroupIds() != null) {
                    data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                }
                if (this.getSubnetIds() != null) {
                    data.set("subnetIds", om.valueToTree(this.getSubnetIds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emrserverless.CfnApplication.NetworkConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NetworkConfigurationProperty.Jsii$Proxy that = (NetworkConfigurationProperty.Jsii$Proxy) o;

                if (this.securityGroupIds != null ? !this.securityGroupIds.equals(that.securityGroupIds) : that.securityGroupIds != null) return false;
                return this.subnetIds != null ? this.subnetIds.equals(that.subnetIds) : that.subnetIds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.securityGroupIds != null ? this.securityGroupIds.hashCode() : 0;
                result = 31 * result + (this.subnetIds != null ? this.subnetIds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The monitoring configuration object you can configure to send metrics to Amazon Managed Service for Prometheus for a job run.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emrserverless.*;
     * PrometheusMonitoringConfigurationProperty prometheusMonitoringConfigurationProperty = PrometheusMonitoringConfigurationProperty.builder()
     *         .remoteWriteUrl("remoteWriteUrl")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-prometheusmonitoringconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-prometheusmonitoringconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emrserverless.CfnApplication.PrometheusMonitoringConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(PrometheusMonitoringConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PrometheusMonitoringConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The remote write URL in the Amazon Managed Service for Prometheus workspace to send metrics to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-prometheusmonitoringconfiguration.html#cfn-emrserverless-application-prometheusmonitoringconfiguration-remotewriteurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-prometheusmonitoringconfiguration.html#cfn-emrserverless-application-prometheusmonitoringconfiguration-remotewriteurl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRemoteWriteUrl() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PrometheusMonitoringConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PrometheusMonitoringConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PrometheusMonitoringConfigurationProperty> {
            java.lang.String remoteWriteUrl;

            /**
             * Sets the value of {@link PrometheusMonitoringConfigurationProperty#getRemoteWriteUrl}
             * @param remoteWriteUrl The remote write URL in the Amazon Managed Service for Prometheus workspace to send metrics to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder remoteWriteUrl(java.lang.String remoteWriteUrl) {
                this.remoteWriteUrl = remoteWriteUrl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PrometheusMonitoringConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PrometheusMonitoringConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PrometheusMonitoringConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PrometheusMonitoringConfigurationProperty {
            private final java.lang.String remoteWriteUrl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.remoteWriteUrl = software.amazon.jsii.Kernel.get(this, "remoteWriteUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.remoteWriteUrl = builder.remoteWriteUrl;
            }

            @Override
            public final java.lang.String getRemoteWriteUrl() {
                return this.remoteWriteUrl;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getRemoteWriteUrl() != null) {
                    data.set("remoteWriteUrl", om.valueToTree(this.getRemoteWriteUrl()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emrserverless.CfnApplication.PrometheusMonitoringConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PrometheusMonitoringConfigurationProperty.Jsii$Proxy that = (PrometheusMonitoringConfigurationProperty.Jsii$Proxy) o;

                return this.remoteWriteUrl != null ? this.remoteWriteUrl.equals(that.remoteWriteUrl) : that.remoteWriteUrl == null;
            }

            @Override
            public final int hashCode() {
                int result = this.remoteWriteUrl != null ? this.remoteWriteUrl.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The Amazon S3 configuration for monitoring log publishing.
     * <p>
     * You can configure your jobs to send log information to Amazon S3.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emrserverless.*;
     * S3MonitoringConfigurationProperty s3MonitoringConfigurationProperty = S3MonitoringConfigurationProperty.builder()
     *         .encryptionKeyArn("encryptionKeyArn")
     *         .logUri("logUri")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-s3monitoringconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-s3monitoringconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emrserverless.CfnApplication.S3MonitoringConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(S3MonitoringConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3MonitoringConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The KMS key ARN to encrypt the logs published to the given Amazon S3 destination.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-s3monitoringconfiguration.html#cfn-emrserverless-application-s3monitoringconfiguration-encryptionkeyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-s3monitoringconfiguration.html#cfn-emrserverless-application-s3monitoringconfiguration-encryptionkeyarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEncryptionKeyArn() {
            return null;
        }

        /**
         * The Amazon S3 destination URI for log publishing.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-s3monitoringconfiguration.html#cfn-emrserverless-application-s3monitoringconfiguration-loguri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-s3monitoringconfiguration.html#cfn-emrserverless-application-s3monitoringconfiguration-loguri</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLogUri() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3MonitoringConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3MonitoringConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3MonitoringConfigurationProperty> {
            java.lang.String encryptionKeyArn;
            java.lang.String logUri;

            /**
             * Sets the value of {@link S3MonitoringConfigurationProperty#getEncryptionKeyArn}
             * @param encryptionKeyArn The KMS key ARN to encrypt the logs published to the given Amazon S3 destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionKeyArn(java.lang.String encryptionKeyArn) {
                this.encryptionKeyArn = encryptionKeyArn;
                return this;
            }

            /**
             * Sets the value of {@link S3MonitoringConfigurationProperty#getLogUri}
             * @param logUri The Amazon S3 destination URI for log publishing.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logUri(java.lang.String logUri) {
                this.logUri = logUri;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3MonitoringConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3MonitoringConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3MonitoringConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3MonitoringConfigurationProperty {
            private final java.lang.String encryptionKeyArn;
            private final java.lang.String logUri;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.encryptionKeyArn = software.amazon.jsii.Kernel.get(this, "encryptionKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.logUri = software.amazon.jsii.Kernel.get(this, "logUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.encryptionKeyArn = builder.encryptionKeyArn;
                this.logUri = builder.logUri;
            }

            @Override
            public final java.lang.String getEncryptionKeyArn() {
                return this.encryptionKeyArn;
            }

            @Override
            public final java.lang.String getLogUri() {
                return this.logUri;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEncryptionKeyArn() != null) {
                    data.set("encryptionKeyArn", om.valueToTree(this.getEncryptionKeyArn()));
                }
                if (this.getLogUri() != null) {
                    data.set("logUri", om.valueToTree(this.getLogUri()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emrserverless.CfnApplication.S3MonitoringConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3MonitoringConfigurationProperty.Jsii$Proxy that = (S3MonitoringConfigurationProperty.Jsii$Proxy) o;

                if (this.encryptionKeyArn != null ? !this.encryptionKeyArn.equals(that.encryptionKeyArn) : that.encryptionKeyArn != null) return false;
                return this.logUri != null ? this.logUri.equals(that.logUri) : that.logUri == null;
            }

            @Override
            public final int hashCode() {
                int result = this.encryptionKeyArn != null ? this.encryptionKeyArn.hashCode() : 0;
                result = 31 * result + (this.logUri != null ? this.logUri.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The scheduler configuration for batch and streaming jobs running on this application.
     * <p>
     * Supported with release labels emr-7.0.0 and above.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emrserverless.*;
     * SchedulerConfigurationProperty schedulerConfigurationProperty = SchedulerConfigurationProperty.builder()
     *         .maxConcurrentRuns(123)
     *         .queueTimeoutMinutes(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-schedulerconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-schedulerconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emrserverless.CfnApplication.SchedulerConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SchedulerConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SchedulerConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum concurrent job runs on this application.
         * <p>
         * If scheduler configuration is enabled on your application, the default value is 15. The valid range is 1 to 1000.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-schedulerconfiguration.html#cfn-emrserverless-application-schedulerconfiguration-maxconcurrentruns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-schedulerconfiguration.html#cfn-emrserverless-application-schedulerconfiguration-maxconcurrentruns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxConcurrentRuns() {
            return null;
        }

        /**
         * The maximum duration in minutes for the job in QUEUED state.
         * <p>
         * If scheduler configuration is enabled on your application, the default value is 360 minutes (6 hours). The valid range is from 15 to 720.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-schedulerconfiguration.html#cfn-emrserverless-application-schedulerconfiguration-queuetimeoutminutes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-schedulerconfiguration.html#cfn-emrserverless-application-schedulerconfiguration-queuetimeoutminutes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getQueueTimeoutMinutes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SchedulerConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SchedulerConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SchedulerConfigurationProperty> {
            java.lang.Number maxConcurrentRuns;
            java.lang.Number queueTimeoutMinutes;

            /**
             * Sets the value of {@link SchedulerConfigurationProperty#getMaxConcurrentRuns}
             * @param maxConcurrentRuns The maximum concurrent job runs on this application.
             *                          If scheduler configuration is enabled on your application, the default value is 15. The valid range is 1 to 1000.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxConcurrentRuns(java.lang.Number maxConcurrentRuns) {
                this.maxConcurrentRuns = maxConcurrentRuns;
                return this;
            }

            /**
             * Sets the value of {@link SchedulerConfigurationProperty#getQueueTimeoutMinutes}
             * @param queueTimeoutMinutes The maximum duration in minutes for the job in QUEUED state.
             *                            If scheduler configuration is enabled on your application, the default value is 360 minutes (6 hours). The valid range is from 15 to 720.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queueTimeoutMinutes(java.lang.Number queueTimeoutMinutes) {
                this.queueTimeoutMinutes = queueTimeoutMinutes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SchedulerConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SchedulerConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SchedulerConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SchedulerConfigurationProperty {
            private final java.lang.Number maxConcurrentRuns;
            private final java.lang.Number queueTimeoutMinutes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxConcurrentRuns = software.amazon.jsii.Kernel.get(this, "maxConcurrentRuns", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.queueTimeoutMinutes = software.amazon.jsii.Kernel.get(this, "queueTimeoutMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxConcurrentRuns = builder.maxConcurrentRuns;
                this.queueTimeoutMinutes = builder.queueTimeoutMinutes;
            }

            @Override
            public final java.lang.Number getMaxConcurrentRuns() {
                return this.maxConcurrentRuns;
            }

            @Override
            public final java.lang.Number getQueueTimeoutMinutes() {
                return this.queueTimeoutMinutes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMaxConcurrentRuns() != null) {
                    data.set("maxConcurrentRuns", om.valueToTree(this.getMaxConcurrentRuns()));
                }
                if (this.getQueueTimeoutMinutes() != null) {
                    data.set("queueTimeoutMinutes", om.valueToTree(this.getQueueTimeoutMinutes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emrserverless.CfnApplication.SchedulerConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SchedulerConfigurationProperty.Jsii$Proxy that = (SchedulerConfigurationProperty.Jsii$Proxy) o;

                if (this.maxConcurrentRuns != null ? !this.maxConcurrentRuns.equals(that.maxConcurrentRuns) : that.maxConcurrentRuns != null) return false;
                return this.queueTimeoutMinutes != null ? this.queueTimeoutMinutes.equals(that.queueTimeoutMinutes) : that.queueTimeoutMinutes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maxConcurrentRuns != null ? this.maxConcurrentRuns.hashCode() : 0;
                result = 31 * result + (this.queueTimeoutMinutes != null ? this.queueTimeoutMinutes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration of a worker.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/emr/latest/EMR-Serverless-UserGuide/app-behavior.html#worker-configs">Supported worker configurations</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emrserverless.*;
     * WorkerConfigurationProperty workerConfigurationProperty = WorkerConfigurationProperty.builder()
     *         .cpu("cpu")
     *         .memory("memory")
     *         // the properties below are optional
     *         .disk("disk")
     *         .diskType("diskType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-workerconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-workerconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emrserverless.CfnApplication.WorkerConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(WorkerConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WorkerConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The CPU requirements of the worker configuration.
         * <p>
         * Each worker can have 1, 2, 4, 8, or 16 vCPUs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-workerconfiguration.html#cfn-emrserverless-application-workerconfiguration-cpu">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-workerconfiguration.html#cfn-emrserverless-application-workerconfiguration-cpu</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCpu();

        /**
         * The memory requirements of the worker configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-workerconfiguration.html#cfn-emrserverless-application-workerconfiguration-memory">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-workerconfiguration.html#cfn-emrserverless-application-workerconfiguration-memory</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMemory();

        /**
         * The disk requirements of the worker configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-workerconfiguration.html#cfn-emrserverless-application-workerconfiguration-disk">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-workerconfiguration.html#cfn-emrserverless-application-workerconfiguration-disk</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDisk() {
            return null;
        }

        /**
         * The disk type for every worker instance of the work type.
         * <p>
         * Shuffle optimized disks have higher performance characteristics and are better for shuffle heavy workloads. Default is <code>STANDARD</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-workerconfiguration.html#cfn-emrserverless-application-workerconfiguration-disktype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-workerconfiguration.html#cfn-emrserverless-application-workerconfiguration-disktype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDiskType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link WorkerConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WorkerConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WorkerConfigurationProperty> {
            java.lang.String cpu;
            java.lang.String memory;
            java.lang.String disk;
            java.lang.String diskType;

            /**
             * Sets the value of {@link WorkerConfigurationProperty#getCpu}
             * @param cpu The CPU requirements of the worker configuration. This parameter is required.
             *            Each worker can have 1, 2, 4, 8, or 16 vCPUs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cpu(java.lang.String cpu) {
                this.cpu = cpu;
                return this;
            }

            /**
             * Sets the value of {@link WorkerConfigurationProperty#getMemory}
             * @param memory The memory requirements of the worker configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memory(java.lang.String memory) {
                this.memory = memory;
                return this;
            }

            /**
             * Sets the value of {@link WorkerConfigurationProperty#getDisk}
             * @param disk The disk requirements of the worker configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disk(java.lang.String disk) {
                this.disk = disk;
                return this;
            }

            /**
             * Sets the value of {@link WorkerConfigurationProperty#getDiskType}
             * @param diskType The disk type for every worker instance of the work type.
             *                 Shuffle optimized disks have higher performance characteristics and are better for shuffle heavy workloads. Default is <code>STANDARD</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder diskType(java.lang.String diskType) {
                this.diskType = diskType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WorkerConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WorkerConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WorkerConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WorkerConfigurationProperty {
            private final java.lang.String cpu;
            private final java.lang.String memory;
            private final java.lang.String disk;
            private final java.lang.String diskType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cpu = software.amazon.jsii.Kernel.get(this, "cpu", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.memory = software.amazon.jsii.Kernel.get(this, "memory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.disk = software.amazon.jsii.Kernel.get(this, "disk", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.diskType = software.amazon.jsii.Kernel.get(this, "diskType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cpu = java.util.Objects.requireNonNull(builder.cpu, "cpu is required");
                this.memory = java.util.Objects.requireNonNull(builder.memory, "memory is required");
                this.disk = builder.disk;
                this.diskType = builder.diskType;
            }

            @Override
            public final java.lang.String getCpu() {
                return this.cpu;
            }

            @Override
            public final java.lang.String getMemory() {
                return this.memory;
            }

            @Override
            public final java.lang.String getDisk() {
                return this.disk;
            }

            @Override
            public final java.lang.String getDiskType() {
                return this.diskType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("cpu", om.valueToTree(this.getCpu()));
                data.set("memory", om.valueToTree(this.getMemory()));
                if (this.getDisk() != null) {
                    data.set("disk", om.valueToTree(this.getDisk()));
                }
                if (this.getDiskType() != null) {
                    data.set("diskType", om.valueToTree(this.getDiskType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emrserverless.CfnApplication.WorkerConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WorkerConfigurationProperty.Jsii$Proxy that = (WorkerConfigurationProperty.Jsii$Proxy) o;

                if (!cpu.equals(that.cpu)) return false;
                if (!memory.equals(that.memory)) return false;
                if (this.disk != null ? !this.disk.equals(that.disk) : that.disk != null) return false;
                return this.diskType != null ? this.diskType.equals(that.diskType) : that.diskType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cpu.hashCode();
                result = 31 * result + (this.memory.hashCode());
                result = 31 * result + (this.disk != null ? this.disk.hashCode() : 0);
                result = 31 * result + (this.diskType != null ? this.diskType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The specifications for a worker type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.emrserverless.*;
     * WorkerTypeSpecificationInputProperty workerTypeSpecificationInputProperty = WorkerTypeSpecificationInputProperty.builder()
     *         .imageConfiguration(ImageConfigurationInputProperty.builder()
     *                 .imageUri("imageUri")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-workertypespecificationinput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-workertypespecificationinput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emrserverless.CfnApplication.WorkerTypeSpecificationInputProperty")
    @software.amazon.jsii.Jsii.Proxy(WorkerTypeSpecificationInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WorkerTypeSpecificationInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The image configuration for a worker type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-workertypespecificationinput.html#cfn-emrserverless-application-workertypespecificationinput-imageconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-emrserverless-application-workertypespecificationinput.html#cfn-emrserverless-application-workertypespecificationinput-imageconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getImageConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link WorkerTypeSpecificationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WorkerTypeSpecificationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WorkerTypeSpecificationInputProperty> {
            java.lang.Object imageConfiguration;

            /**
             * Sets the value of {@link WorkerTypeSpecificationInputProperty#getImageConfiguration}
             * @param imageConfiguration The image configuration for a worker type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageConfiguration(software.amazon.awscdk.IResolvable imageConfiguration) {
                this.imageConfiguration = imageConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link WorkerTypeSpecificationInputProperty#getImageConfiguration}
             * @param imageConfiguration The image configuration for a worker type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageConfiguration(software.amazon.awscdk.services.emrserverless.CfnApplication.ImageConfigurationInputProperty imageConfiguration) {
                this.imageConfiguration = imageConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WorkerTypeSpecificationInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WorkerTypeSpecificationInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WorkerTypeSpecificationInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WorkerTypeSpecificationInputProperty {
            private final java.lang.Object imageConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.imageConfiguration = software.amazon.jsii.Kernel.get(this, "imageConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.imageConfiguration = builder.imageConfiguration;
            }

            @Override
            public final java.lang.Object getImageConfiguration() {
                return this.imageConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getImageConfiguration() != null) {
                    data.set("imageConfiguration", om.valueToTree(this.getImageConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emrserverless.CfnApplication.WorkerTypeSpecificationInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WorkerTypeSpecificationInputProperty.Jsii$Proxy that = (WorkerTypeSpecificationInputProperty.Jsii$Proxy) o;

                return this.imageConfiguration != null ? this.imageConfiguration.equals(that.imageConfiguration) : that.imageConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.imageConfiguration != null ? this.imageConfiguration.hashCode() : 0;
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.emrserverless.CfnApplication}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.emrserverless.CfnApplication> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.emrserverless.CfnApplicationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.emrserverless.CfnApplicationProps.Builder();
        }

        /**
         * The EMR release associated with the application.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-releaselabel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-releaselabel</a>
         * @param releaseLabel The EMR release associated with the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder releaseLabel(final java.lang.String releaseLabel) {
            this.props.releaseLabel(releaseLabel);
            return this;
        }

        /**
         * The type of application, such as Spark or Hive.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-type</a>
         * @param type The type of application, such as Spark or Hive. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final java.lang.String type) {
            this.props.type(type);
            return this;
        }

        /**
         * The CPU architecture of an application.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-architecture">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-architecture</a>
         * @param architecture The CPU architecture of an application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder architecture(final java.lang.String architecture) {
            this.props.architecture(architecture);
            return this;
        }

        /**
         * The configuration for an application to automatically start on job submission.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-autostartconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-autostartconfiguration</a>
         * @param autoStartConfiguration The configuration for an application to automatically start on job submission. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoStartConfiguration(final software.amazon.awscdk.IResolvable autoStartConfiguration) {
            this.props.autoStartConfiguration(autoStartConfiguration);
            return this;
        }
        /**
         * The configuration for an application to automatically start on job submission.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-autostartconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-autostartconfiguration</a>
         * @param autoStartConfiguration The configuration for an application to automatically start on job submission. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoStartConfiguration(final software.amazon.awscdk.services.emrserverless.CfnApplication.AutoStartConfigurationProperty autoStartConfiguration) {
            this.props.autoStartConfiguration(autoStartConfiguration);
            return this;
        }

        /**
         * The configuration for an application to automatically stop after a certain amount of time being idle.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-autostopconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-autostopconfiguration</a>
         * @param autoStopConfiguration The configuration for an application to automatically stop after a certain amount of time being idle. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoStopConfiguration(final software.amazon.awscdk.IResolvable autoStopConfiguration) {
            this.props.autoStopConfiguration(autoStopConfiguration);
            return this;
        }
        /**
         * The configuration for an application to automatically stop after a certain amount of time being idle.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-autostopconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-autostopconfiguration</a>
         * @param autoStopConfiguration The configuration for an application to automatically stop after a certain amount of time being idle. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoStopConfiguration(final software.amazon.awscdk.services.emrserverless.CfnApplication.AutoStopConfigurationProperty autoStopConfiguration) {
            this.props.autoStopConfiguration(autoStopConfiguration);
            return this;
        }

        /**
         * The image configuration applied to all worker types.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-imageconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-imageconfiguration</a>
         * @param imageConfiguration The image configuration applied to all worker types. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageConfiguration(final software.amazon.awscdk.IResolvable imageConfiguration) {
            this.props.imageConfiguration(imageConfiguration);
            return this;
        }
        /**
         * The image configuration applied to all worker types.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-imageconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-imageconfiguration</a>
         * @param imageConfiguration The image configuration applied to all worker types. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageConfiguration(final software.amazon.awscdk.services.emrserverless.CfnApplication.ImageConfigurationInputProperty imageConfiguration) {
            this.props.imageConfiguration(imageConfiguration);
            return this;
        }

        /**
         * The initial capacity of the application.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-initialcapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-initialcapacity</a>
         * @param initialCapacity The initial capacity of the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder initialCapacity(final software.amazon.awscdk.IResolvable initialCapacity) {
            this.props.initialCapacity(initialCapacity);
            return this;
        }
        /**
         * The initial capacity of the application.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-initialcapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-initialcapacity</a>
         * @param initialCapacity The initial capacity of the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder initialCapacity(final java.util.List<? extends java.lang.Object> initialCapacity) {
            this.props.initialCapacity(initialCapacity);
            return this;
        }

        /**
         * The interactive configuration object that enables the interactive use cases for an application.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-interactiveconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-interactiveconfiguration</a>
         * @param interactiveConfiguration The interactive configuration object that enables the interactive use cases for an application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder interactiveConfiguration(final software.amazon.awscdk.IResolvable interactiveConfiguration) {
            this.props.interactiveConfiguration(interactiveConfiguration);
            return this;
        }
        /**
         * The interactive configuration object that enables the interactive use cases for an application.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-interactiveconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-interactiveconfiguration</a>
         * @param interactiveConfiguration The interactive configuration object that enables the interactive use cases for an application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder interactiveConfiguration(final software.amazon.awscdk.services.emrserverless.CfnApplication.InteractiveConfigurationProperty interactiveConfiguration) {
            this.props.interactiveConfiguration(interactiveConfiguration);
            return this;
        }

        /**
         * The maximum capacity of the application.
         * <p>
         * This is cumulative across all workers at any given point in time during the lifespan of the application is created. No new resources will be created once any one of the defined limits is hit.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-maximumcapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-maximumcapacity</a>
         * @param maximumCapacity The maximum capacity of the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maximumCapacity(final software.amazon.awscdk.IResolvable maximumCapacity) {
            this.props.maximumCapacity(maximumCapacity);
            return this;
        }
        /**
         * The maximum capacity of the application.
         * <p>
         * This is cumulative across all workers at any given point in time during the lifespan of the application is created. No new resources will be created once any one of the defined limits is hit.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-maximumcapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-maximumcapacity</a>
         * @param maximumCapacity The maximum capacity of the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maximumCapacity(final software.amazon.awscdk.services.emrserverless.CfnApplication.MaximumAllowedResourcesProperty maximumCapacity) {
            this.props.maximumCapacity(maximumCapacity);
            return this;
        }

        /**
         * A configuration specification to be used when provisioning an application.
         * <p>
         * A configuration consists of a classification, properties, and optional nested configurations. A classification refers to an application-specific configuration file. Properties are the settings you want to change in that file.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-monitoringconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-monitoringconfiguration</a>
         * @param monitoringConfiguration A configuration specification to be used when provisioning an application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitoringConfiguration(final software.amazon.awscdk.IResolvable monitoringConfiguration) {
            this.props.monitoringConfiguration(monitoringConfiguration);
            return this;
        }
        /**
         * A configuration specification to be used when provisioning an application.
         * <p>
         * A configuration consists of a classification, properties, and optional nested configurations. A classification refers to an application-specific configuration file. Properties are the settings you want to change in that file.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-monitoringconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-monitoringconfiguration</a>
         * @param monitoringConfiguration A configuration specification to be used when provisioning an application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder monitoringConfiguration(final software.amazon.awscdk.services.emrserverless.CfnApplication.MonitoringConfigurationProperty monitoringConfiguration) {
            this.props.monitoringConfiguration(monitoringConfiguration);
            return this;
        }

        /**
         * The name of the application.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-name</a>
         * @param name The name of the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The network configuration for customer VPC connectivity for the application.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-networkconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-networkconfiguration</a>
         * @param networkConfiguration The network configuration for customer VPC connectivity for the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkConfiguration(final software.amazon.awscdk.IResolvable networkConfiguration) {
            this.props.networkConfiguration(networkConfiguration);
            return this;
        }
        /**
         * The network configuration for customer VPC connectivity for the application.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-networkconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-networkconfiguration</a>
         * @param networkConfiguration The network configuration for customer VPC connectivity for the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkConfiguration(final software.amazon.awscdk.services.emrserverless.CfnApplication.NetworkConfigurationProperty networkConfiguration) {
            this.props.networkConfiguration(networkConfiguration);
            return this;
        }

        /**
         * The <a href="https://docs.aws.amazon.com/emr-serverless/latest/APIReference/API_Configuration.html">Configuration</a> specifications of an application. Each configuration consists of a classification and properties. You use this parameter when creating or updating an application. To see the runtimeConfiguration object of an application, run the <a href="https://docs.aws.amazon.com/emr-serverless/latest/APIReference/API_GetApplication.html">GetApplication</a> API operation.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-runtimeconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-runtimeconfiguration</a>
         * @param runtimeConfiguration The <a href="https://docs.aws.amazon.com/emr-serverless/latest/APIReference/API_Configuration.html">Configuration</a> specifications of an application. Each configuration consists of a classification and properties. You use this parameter when creating or updating an application. To see the runtimeConfiguration object of an application, run the <a href="https://docs.aws.amazon.com/emr-serverless/latest/APIReference/API_GetApplication.html">GetApplication</a> API operation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtimeConfiguration(final software.amazon.awscdk.IResolvable runtimeConfiguration) {
            this.props.runtimeConfiguration(runtimeConfiguration);
            return this;
        }
        /**
         * The <a href="https://docs.aws.amazon.com/emr-serverless/latest/APIReference/API_Configuration.html">Configuration</a> specifications of an application. Each configuration consists of a classification and properties. You use this parameter when creating or updating an application. To see the runtimeConfiguration object of an application, run the <a href="https://docs.aws.amazon.com/emr-serverless/latest/APIReference/API_GetApplication.html">GetApplication</a> API operation.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-runtimeconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-runtimeconfiguration</a>
         * @param runtimeConfiguration The <a href="https://docs.aws.amazon.com/emr-serverless/latest/APIReference/API_Configuration.html">Configuration</a> specifications of an application. Each configuration consists of a classification and properties. You use this parameter when creating or updating an application. To see the runtimeConfiguration object of an application, run the <a href="https://docs.aws.amazon.com/emr-serverless/latest/APIReference/API_GetApplication.html">GetApplication</a> API operation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtimeConfiguration(final java.util.List<? extends java.lang.Object> runtimeConfiguration) {
            this.props.runtimeConfiguration(runtimeConfiguration);
            return this;
        }

        /**
         * The scheduler configuration for batch and streaming jobs running on this application.
         * <p>
         * Supported with release labels emr-7.0.0 and above.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-schedulerconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-schedulerconfiguration</a>
         * @param schedulerConfiguration The scheduler configuration for batch and streaming jobs running on this application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedulerConfiguration(final software.amazon.awscdk.IResolvable schedulerConfiguration) {
            this.props.schedulerConfiguration(schedulerConfiguration);
            return this;
        }
        /**
         * The scheduler configuration for batch and streaming jobs running on this application.
         * <p>
         * Supported with release labels emr-7.0.0 and above.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-schedulerconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-schedulerconfiguration</a>
         * @param schedulerConfiguration The scheduler configuration for batch and streaming jobs running on this application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedulerConfiguration(final software.amazon.awscdk.services.emrserverless.CfnApplication.SchedulerConfigurationProperty schedulerConfiguration) {
            this.props.schedulerConfiguration(schedulerConfiguration);
            return this;
        }

        /**
         * The tags assigned to the application.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-tags</a>
         * @param tags The tags assigned to the application. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The specification applied to each worker type.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-workertypespecifications">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-workertypespecifications</a>
         * @param workerTypeSpecifications The specification applied to each worker type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workerTypeSpecifications(final software.amazon.awscdk.IResolvable workerTypeSpecifications) {
            this.props.workerTypeSpecifications(workerTypeSpecifications);
            return this;
        }
        /**
         * The specification applied to each worker type.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-workertypespecifications">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-emrserverless-application.html#cfn-emrserverless-application-workertypespecifications</a>
         * @param workerTypeSpecifications The specification applied to each worker type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workerTypeSpecifications(final java.util.Map<java.lang.String, ? extends java.lang.Object> workerTypeSpecifications) {
            this.props.workerTypeSpecifications(workerTypeSpecifications);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.emrserverless.CfnApplication}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.emrserverless.CfnApplication build() {
            return new software.amazon.awscdk.services.emrserverless.CfnApplication(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
