package software.amazon.awscdk.services.events;

/**
 * Defines an EventBridge Rule in this stack.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lambda.*;
 * Function fn = Function.Builder.create(this, "MyFunc")
 *         .runtime(Runtime.NODEJS_LATEST)
 *         .handler("index.handler")
 *         .code(Code.fromInline("exports.handler = handler.toString()"))
 *         .build();
 * Rule rule = Rule.Builder.create(this, "rule")
 *         .eventPattern(EventPattern.builder()
 *                 .source(List.of("aws.ec2"))
 *                 .build())
 *         .build();
 * Queue queue = new Queue(this, "Queue");
 * rule.addTarget(LambdaFunction.Builder.create(fn)
 *         .deadLetterQueue(queue) // Optional: add a dead letter queue
 *         .maxEventAge(Duration.hours(2)) // Optional: set the maxEventAge retry policy
 *         .retryAttempts(2)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:24:58.686Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events.Rule")
public class Rule extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.events.IRule {

    protected Rule(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Rule(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Rule(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.RuleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Rule(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Import an existing EventBridge Rule provided an ARN.
     * <p>
     * @param scope The parent creating construct (usually <code>this</code>). This parameter is required.
     * @param id The construct's name. This parameter is required.
     * @param eventRuleArn Event Rule ARN (i.e. arn:aws:events:<region>:<account-id>:rule/MyScheduledRule). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IRule fromEventRuleArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String eventRuleArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.events.Rule.class, "fromEventRuleArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.IRule.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(eventRuleArn, "eventRuleArn is required") });
    }

    /**
     * Adds an event pattern filter to this rule.
     * <p>
     * If a pattern was already specified,
     * these values are merged into the existing pattern.
     * <p>
     * For example, if the rule already contains the pattern:
     * <p>
     * {
     * "resources": [ "r1" ],
     * "detail": {
     * "hello": [ 1 ]
     * }
     * }
     * <p>
     * And <code>addEventPattern</code> is called with the pattern:
     * <p>
     * {
     * "resources": [ "r2" ],
     * "detail": {
     * "foo": [ "bar" ]
     * }
     * }
     * <p>
     * The resulting event pattern will be:
     * <p>
     * {
     * "resources": [ "r1", "r2" ],
     * "detail": {
     * "hello": [ 1 ],
     * "foo": [ "bar" ]
     * }
     * }
     * <p>
     * @param eventPattern
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addEventPattern(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.EventPattern eventPattern) {
        software.amazon.jsii.Kernel.call(this, "addEventPattern", software.amazon.jsii.NativeType.VOID, new Object[] { eventPattern });
    }

    /**
     * Adds an event pattern filter to this rule.
     * <p>
     * If a pattern was already specified,
     * these values are merged into the existing pattern.
     * <p>
     * For example, if the rule already contains the pattern:
     * <p>
     * {
     * "resources": [ "r1" ],
     * "detail": {
     * "hello": [ 1 ]
     * }
     * }
     * <p>
     * And <code>addEventPattern</code> is called with the pattern:
     * <p>
     * {
     * "resources": [ "r2" ],
     * "detail": {
     * "foo": [ "bar" ]
     * }
     * }
     * <p>
     * The resulting event pattern will be:
     * <p>
     * {
     * "resources": [ "r1", "r2" ],
     * "detail": {
     * "hello": [ 1 ],
     * "foo": [ "bar" ]
     * }
     * }
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addEventPattern() {
        software.amazon.jsii.Kernel.call(this, "addEventPattern", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * Adds a target to the rule. The abstract class RuleTarget can be extended to define new targets.
     * <p>
     * No-op if target is undefined.
     * <p>
     * @param target
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addTarget(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.IRuleTarget target) {
        software.amazon.jsii.Kernel.call(this, "addTarget", software.amazon.jsii.NativeType.VOID, new Object[] { target });
    }

    /**
     * Adds a target to the rule. The abstract class RuleTarget can be extended to define new targets.
     * <p>
     * No-op if target is undefined.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addTarget() {
        software.amazon.jsii.Kernel.call(this, "addTarget", software.amazon.jsii.NativeType.VOID);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> validateRule() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "validateRule", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The value of the event rule Amazon Resource Name (ARN), such as arn:aws:events:us-east-2:123456789012:rule/example.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRuleArn() {
        return software.amazon.jsii.Kernel.get(this, "ruleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name event rule.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRuleName() {
        return software.amazon.jsii.Kernel.get(this, "ruleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.events.Rule}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.events.Rule> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.events.RuleProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The scope to use if the source of the rule and its target are in different Stacks (but in the same account &amp; region).
         * <p>
         * This helps dealing with cycles that often arise in these situations.
         * <p>
         * Default: - none (the main scope will be used, even for cross-stack Events)
         * <p>
         * @return {@code this}
         * @param crossStackScope The scope to use if the source of the rule and its target are in different Stacks (but in the same account &amp; region). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder crossStackScope(final software.constructs.Construct crossStackScope) {
            this.props().crossStackScope(crossStackScope);
            return this;
        }

        /**
         * A description of the rule's purpose.
         * <p>
         * Default: - No description
         * <p>
         * @return {@code this}
         * @param description A description of the rule's purpose. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * Additional restrictions for the event to route to the specified target.
         * <p>
         * The method that generates the rule probably imposes some type of event
         * filtering. The filtering implied by what you pass here is added
         * on top of that filtering.
         * <p>
         * Default: - No additional filtering based on an event pattern.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html</a>
         * @param eventPattern Additional restrictions for the event to route to the specified target. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventPattern(final software.amazon.awscdk.services.events.EventPattern eventPattern) {
            this.props().eventPattern(eventPattern);
            return this;
        }

        /**
         * A name for the rule.
         * <p>
         * Default: AWS CloudFormation generates a unique physical ID.
         * <p>
         * @return {@code this}
         * @param ruleName A name for the rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleName(final java.lang.String ruleName) {
            this.props().ruleName(ruleName);
            return this;
        }

        /**
         * Indicates whether the rule is enabled.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param enabled Indicates whether the rule is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(final java.lang.Boolean enabled) {
            this.props().enabled(enabled);
            return this;
        }

        /**
         * The event bus to associate with this rule.
         * <p>
         * Default: - The default event bus.
         * <p>
         * @return {@code this}
         * @param eventBus The event bus to associate with this rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventBus(final software.amazon.awscdk.services.events.IEventBus eventBus) {
            this.props().eventBus(eventBus);
            return this;
        }

        /**
         * The schedule or rate (frequency) that determines when EventBridge runs the rule.
         * <p>
         * You must specify this property, the <code>eventPattern</code> property, or both.
         * <p>
         * For more information, see Schedule Expression Syntax for
         * Rules in the Amazon EventBridge User Guide.
         * <p>
         * Default: - None.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/scheduled-events.html">https://docs.aws.amazon.com/eventbridge/latest/userguide/scheduled-events.html</a>
         * @param schedule The schedule or rate (frequency) that determines when EventBridge runs the rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(final software.amazon.awscdk.services.events.Schedule schedule) {
            this.props().schedule(schedule);
            return this;
        }

        /**
         * Targets to invoke when this rule matches an event.
         * <p>
         * Input will be the full matched event. If you wish to specify custom
         * target input, use <code>addTarget(target[, inputOptions])</code>.
         * <p>
         * Default: - No targets.
         * <p>
         * @return {@code this}
         * @param targets Targets to invoke when this rule matches an event. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targets(final java.util.List<? extends software.amazon.awscdk.services.events.IRuleTarget> targets) {
            this.props().targets(targets);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.events.Rule}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.events.Rule build() {
            return new software.amazon.awscdk.services.events.Rule(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.events.RuleProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.events.RuleProps.Builder();
            }
            return this.props;
        }
    }
}
