package software.amazon.awscdk.services.gameliftstreams;

/**
 * Properties for defining a <code>CfnApplication</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.gameliftstreams.*;
 * CfnApplicationProps cfnApplicationProps = CfnApplicationProps.builder()
 *         .applicationSourceUri("applicationSourceUri")
 *         .description("description")
 *         .executablePath("executablePath")
 *         .runtimeEnvironment(RuntimeEnvironmentProperty.builder()
 *                 .type("type")
 *                 .version("version")
 *                 .build())
 *         // the properties below are optional
 *         .applicationLogOutputUri("applicationLogOutputUri")
 *         .applicationLogPaths(List.of("applicationLogPaths"))
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-application.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-application.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:24:59.035Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gameliftstreams.CfnApplicationProps")
@software.amazon.jsii.Jsii.Proxy(CfnApplicationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnApplicationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-application.html#cfn-gameliftstreams-application-applicationsourceuri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-application.html#cfn-gameliftstreams-application-applicationsourceuri</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApplicationSourceUri();

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-application.html#cfn-gameliftstreams-application-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-application.html#cfn-gameliftstreams-application-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDescription();

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-application.html#cfn-gameliftstreams-application-executablepath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-application.html#cfn-gameliftstreams-application-executablepath</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getExecutablePath();

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-application.html#cfn-gameliftstreams-application-runtimeenvironment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-application.html#cfn-gameliftstreams-application-runtimeenvironment</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getRuntimeEnvironment();

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-application.html#cfn-gameliftstreams-application-applicationlogoutputuri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-application.html#cfn-gameliftstreams-application-applicationlogoutputuri</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getApplicationLogOutputUri() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-application.html#cfn-gameliftstreams-application-applicationlogpaths">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-application.html#cfn-gameliftstreams-application-applicationlogpaths</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getApplicationLogPaths() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-application.html#cfn-gameliftstreams-application-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-gameliftstreams-application.html#cfn-gameliftstreams-application-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnApplicationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnApplicationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnApplicationProps> {
        java.lang.String applicationSourceUri;
        java.lang.String description;
        java.lang.String executablePath;
        java.lang.Object runtimeEnvironment;
        java.lang.String applicationLogOutputUri;
        java.util.List<java.lang.String> applicationLogPaths;
        java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Sets the value of {@link CfnApplicationProps#getApplicationSourceUri}
         * @param applicationSourceUri the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationSourceUri(java.lang.String applicationSourceUri) {
            this.applicationSourceUri = applicationSourceUri;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getDescription}
         * @param description the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getExecutablePath}
         * @param executablePath the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executablePath(java.lang.String executablePath) {
            this.executablePath = executablePath;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getRuntimeEnvironment}
         * @param runtimeEnvironment the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtimeEnvironment(software.amazon.awscdk.IResolvable runtimeEnvironment) {
            this.runtimeEnvironment = runtimeEnvironment;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getRuntimeEnvironment}
         * @param runtimeEnvironment the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtimeEnvironment(software.amazon.awscdk.services.gameliftstreams.CfnApplication.RuntimeEnvironmentProperty runtimeEnvironment) {
            this.runtimeEnvironment = runtimeEnvironment;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getApplicationLogOutputUri}
         * @param applicationLogOutputUri the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationLogOutputUri(java.lang.String applicationLogOutputUri) {
            this.applicationLogOutputUri = applicationLogOutputUri;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getApplicationLogPaths}
         * @param applicationLogPaths the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationLogPaths(java.util.List<java.lang.String> applicationLogPaths) {
            this.applicationLogPaths = applicationLogPaths;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getTags}
         * @param tags the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnApplicationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnApplicationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnApplicationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnApplicationProps {
        private final java.lang.String applicationSourceUri;
        private final java.lang.String description;
        private final java.lang.String executablePath;
        private final java.lang.Object runtimeEnvironment;
        private final java.lang.String applicationLogOutputUri;
        private final java.util.List<java.lang.String> applicationLogPaths;
        private final java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.applicationSourceUri = software.amazon.jsii.Kernel.get(this, "applicationSourceUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.executablePath = software.amazon.jsii.Kernel.get(this, "executablePath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.runtimeEnvironment = software.amazon.jsii.Kernel.get(this, "runtimeEnvironment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.applicationLogOutputUri = software.amazon.jsii.Kernel.get(this, "applicationLogOutputUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.applicationLogPaths = software.amazon.jsii.Kernel.get(this, "applicationLogPaths", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.applicationSourceUri = java.util.Objects.requireNonNull(builder.applicationSourceUri, "applicationSourceUri is required");
            this.description = java.util.Objects.requireNonNull(builder.description, "description is required");
            this.executablePath = java.util.Objects.requireNonNull(builder.executablePath, "executablePath is required");
            this.runtimeEnvironment = java.util.Objects.requireNonNull(builder.runtimeEnvironment, "runtimeEnvironment is required");
            this.applicationLogOutputUri = builder.applicationLogOutputUri;
            this.applicationLogPaths = builder.applicationLogPaths;
            this.tags = builder.tags;
        }

        @Override
        public final java.lang.String getApplicationSourceUri() {
            return this.applicationSourceUri;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getExecutablePath() {
            return this.executablePath;
        }

        @Override
        public final java.lang.Object getRuntimeEnvironment() {
            return this.runtimeEnvironment;
        }

        @Override
        public final java.lang.String getApplicationLogOutputUri() {
            return this.applicationLogOutputUri;
        }

        @Override
        public final java.util.List<java.lang.String> getApplicationLogPaths() {
            return this.applicationLogPaths;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("applicationSourceUri", om.valueToTree(this.getApplicationSourceUri()));
            data.set("description", om.valueToTree(this.getDescription()));
            data.set("executablePath", om.valueToTree(this.getExecutablePath()));
            data.set("runtimeEnvironment", om.valueToTree(this.getRuntimeEnvironment()));
            if (this.getApplicationLogOutputUri() != null) {
                data.set("applicationLogOutputUri", om.valueToTree(this.getApplicationLogOutputUri()));
            }
            if (this.getApplicationLogPaths() != null) {
                data.set("applicationLogPaths", om.valueToTree(this.getApplicationLogPaths()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_gameliftstreams.CfnApplicationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnApplicationProps.Jsii$Proxy that = (CfnApplicationProps.Jsii$Proxy) o;

            if (!applicationSourceUri.equals(that.applicationSourceUri)) return false;
            if (!description.equals(that.description)) return false;
            if (!executablePath.equals(that.executablePath)) return false;
            if (!runtimeEnvironment.equals(that.runtimeEnvironment)) return false;
            if (this.applicationLogOutputUri != null ? !this.applicationLogOutputUri.equals(that.applicationLogOutputUri) : that.applicationLogOutputUri != null) return false;
            if (this.applicationLogPaths != null ? !this.applicationLogPaths.equals(that.applicationLogPaths) : that.applicationLogPaths != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.applicationSourceUri.hashCode();
            result = 31 * result + (this.description.hashCode());
            result = 31 * result + (this.executablePath.hashCode());
            result = 31 * result + (this.runtimeEnvironment.hashCode());
            result = 31 * result + (this.applicationLogOutputUri != null ? this.applicationLogOutputUri.hashCode() : 0);
            result = 31 * result + (this.applicationLogPaths != null ? this.applicationLogPaths.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
