package software.amazon.awscdk.services.globalaccelerator;

/**
 * The Accelerator construct.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Create an Accelerator
 * Accelerator accelerator = new Accelerator(this, "Accelerator");
 * // Create a Listener
 * Listener listener = accelerator.addListener("Listener", ListenerOptions.builder()
 *         .portRanges(List.of(PortRange.builder().fromPort(80).build(), PortRange.builder().fromPort(443).build()))
 *         .build());
 * // Import the Load Balancers
 * INetworkLoadBalancer nlb1 = NetworkLoadBalancer.fromNetworkLoadBalancerAttributes(this, "NLB1", NetworkLoadBalancerAttributes.builder()
 *         .loadBalancerArn("arn:aws:elasticloadbalancing:us-west-2:111111111111:loadbalancer/app/my-load-balancer1/e16bef66805b")
 *         .build());
 * INetworkLoadBalancer nlb2 = NetworkLoadBalancer.fromNetworkLoadBalancerAttributes(this, "NLB2", NetworkLoadBalancerAttributes.builder()
 *         .loadBalancerArn("arn:aws:elasticloadbalancing:ap-south-1:111111111111:loadbalancer/app/my-load-balancer2/5513dc2ea8a1")
 *         .build());
 * // Add one EndpointGroup for each Region we are targeting
 * listener.addEndpointGroup("Group1", EndpointGroupOptions.builder()
 *         .endpoints(List.of(new NetworkLoadBalancerEndpoint(nlb1)))
 *         .build());
 * listener.addEndpointGroup("Group2", EndpointGroupOptions.builder()
 *         // Imported load balancers automatically calculate their Region from the ARN.
 *         // If you are load balancing to other resources, you must also pass a `region`
 *         // parameter here.
 *         .endpoints(List.of(new NetworkLoadBalancerEndpoint(nlb2)))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:24:59.039Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_globalaccelerator.Accelerator")
public class Accelerator extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.globalaccelerator.IAccelerator {

    protected Accelerator(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Accelerator(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Accelerator(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.globalaccelerator.AcceleratorProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Accelerator(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * import from attributes.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.globalaccelerator.IAccelerator fromAcceleratorAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.globalaccelerator.AcceleratorAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.globalaccelerator.Accelerator.class, "fromAcceleratorAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.globalaccelerator.IAccelerator.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Add a listener to the accelerator.
     * <p>
     * @param id This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.globalaccelerator.Listener addListener(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.globalaccelerator.ListenerOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addListener", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.globalaccelerator.Listener.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * The ARN of the accelerator.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAcceleratorArn() {
        return software.amazon.jsii.Kernel.get(this, "acceleratorArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Domain Name System (DNS) name that Global Accelerator creates that points to your accelerator's static IP addresses.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDnsName() {
        return software.amazon.jsii.Kernel.get(this, "dnsName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The DNS name that points to the dual-stack accelerator's four static IP addresses: two IPv4 addresses and two IPv6 addresses.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDualStackDnsName() {
        return software.amazon.jsii.Kernel.get(this, "dualStackDnsName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The array of IPv4 addresses in the IP address set.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIpv4Addresses() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "ipv4Addresses", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The array of IPv6 addresses in the IP address set.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIpv6Addresses() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "ipv6Addresses", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.globalaccelerator.Accelerator}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.globalaccelerator.Accelerator> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.globalaccelerator.AcceleratorProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The name of the accelerator.
         * <p>
         * Default: - resource ID
         * <p>
         * @return {@code this}
         * @param acceleratorName The name of the accelerator. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder acceleratorName(final java.lang.String acceleratorName) {
            this.props().acceleratorName(acceleratorName);
            return this;
        }

        /**
         * Indicates whether the accelerator is enabled.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param enabled Indicates whether the accelerator is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(final java.lang.Boolean enabled) {
            this.props().enabled(enabled);
            return this;
        }

        /**
         * IP addresses associated with the accelerator.
         * <p>
         * Optionally, if you've added your own IP address pool to Global Accelerator (BYOIP), you can choose IP
         * addresses from your own pool to use for the accelerator's static IP addresses when you create an accelerator.
         * You can specify one or two addresses, separated by a comma. Do not include the /32 suffix.
         * <p>
         * Only one IP address from each of your IP address ranges can be used for each accelerator. If you specify
         * only one IP address from your IP address range, Global Accelerator assigns a second static IP address for
         * the accelerator from the AWS IP address pool.
         * <p>
         * Note that you can't update IP addresses for an existing accelerator. To change them, you must create a
         * new accelerator with the new addresses.
         * <p>
         * Default: - undefined. IP addresses will be from Amazon's pool of IP addresses.
         * <p>
         * @return {@code this}
         * @param ipAddresses IP addresses associated with the accelerator. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipAddresses(final java.util.List<java.lang.String> ipAddresses) {
            this.props().ipAddresses(ipAddresses);
            return this;
        }

        /**
         * The IP address type that an accelerator supports.
         * <p>
         * For a standard accelerator, the value can be IPV4 or DUAL_STACK.
         * <p>
         * Default: - "IPV4"
         * <p>
         * @return {@code this}
         * @param ipAddressType The IP address type that an accelerator supports. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipAddressType(final software.amazon.awscdk.services.globalaccelerator.IpAddressType ipAddressType) {
            this.props().ipAddressType(ipAddressType);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.globalaccelerator.Accelerator}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.globalaccelerator.Accelerator build() {
            return new software.amazon.awscdk.services.globalaccelerator.Accelerator(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.globalaccelerator.AcceleratorProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.globalaccelerator.AcceleratorProps.Builder();
            }
            return this.props;
        }
    }
}
