package software.amazon.awscdk.services.kinesis;

/**
 * A reference to a StreamConsumer, which can be imported using <code>StreamConsumer.fromStreamConsumerAttributes</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.kinesis.*;
 * StreamConsumerAttributes streamConsumerAttributes = StreamConsumerAttributes.builder()
 *         .streamConsumerArn("streamConsumerArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:25:00.207Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesis.StreamConsumerAttributes")
@software.amazon.jsii.Jsii.Proxy(StreamConsumerAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface StreamConsumerAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) of the stream consumer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStreamConsumerArn();

    /**
     * @return a {@link Builder} of {@link StreamConsumerAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StreamConsumerAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<StreamConsumerAttributes> {
        java.lang.String streamConsumerArn;

        /**
         * Sets the value of {@link StreamConsumerAttributes#getStreamConsumerArn}
         * @param streamConsumerArn The Amazon Resource Name (ARN) of the stream consumer. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamConsumerArn(java.lang.String streamConsumerArn) {
            this.streamConsumerArn = streamConsumerArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StreamConsumerAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public StreamConsumerAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link StreamConsumerAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StreamConsumerAttributes {
        private final java.lang.String streamConsumerArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.streamConsumerArn = software.amazon.jsii.Kernel.get(this, "streamConsumerArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.streamConsumerArn = java.util.Objects.requireNonNull(builder.streamConsumerArn, "streamConsumerArn is required");
        }

        @Override
        public final java.lang.String getStreamConsumerArn() {
            return this.streamConsumerArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("streamConsumerArn", om.valueToTree(this.getStreamConsumerArn()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesis.StreamConsumerAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StreamConsumerAttributes.Jsii$Proxy that = (StreamConsumerAttributes.Jsii$Proxy) o;

            return this.streamConsumerArn.equals(that.streamConsumerArn);
        }

        @Override
        public final int hashCode() {
            int result = this.streamConsumerArn.hashCode();
            return result;
        }
    }
}
