package software.amazon.awscdk.services.kinesisanalyticsv2;

/**
 * Properties for defining a <code>CfnApplication</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.kinesisanalyticsv2.*;
 * CfnApplicationProps cfnApplicationProps = CfnApplicationProps.builder()
 *         .runtimeEnvironment("runtimeEnvironment")
 *         .serviceExecutionRole("serviceExecutionRole")
 *         // the properties below are optional
 *         .applicationConfiguration(ApplicationConfigurationProperty.builder()
 *                 .applicationCodeConfiguration(ApplicationCodeConfigurationProperty.builder()
 *                         .codeContent(CodeContentProperty.builder()
 *                                 .s3ContentLocation(S3ContentLocationProperty.builder()
 *                                         .bucketArn("bucketArn")
 *                                         .fileKey("fileKey")
 *                                         // the properties below are optional
 *                                         .objectVersion("objectVersion")
 *                                         .build())
 *                                 .textContent("textContent")
 *                                 .zipFileContent("zipFileContent")
 *                                 .build())
 *                         .codeContentType("codeContentType")
 *                         .build())
 *                 .applicationSnapshotConfiguration(ApplicationSnapshotConfigurationProperty.builder()
 *                         .snapshotsEnabled(false)
 *                         .build())
 *                 .applicationSystemRollbackConfiguration(ApplicationSystemRollbackConfigurationProperty.builder()
 *                         .rollbackEnabled(false)
 *                         .build())
 *                 .environmentProperties(EnvironmentPropertiesProperty.builder()
 *                         .propertyGroups(List.of(PropertyGroupProperty.builder()
 *                                 .propertyGroupId("propertyGroupId")
 *                                 .propertyMap(Map.of(
 *                                         "propertyMapKey", "propertyMap"))
 *                                 .build()))
 *                         .build())
 *                 .flinkApplicationConfiguration(FlinkApplicationConfigurationProperty.builder()
 *                         .checkpointConfiguration(CheckpointConfigurationProperty.builder()
 *                                 .configurationType("configurationType")
 *                                 // the properties below are optional
 *                                 .checkpointingEnabled(false)
 *                                 .checkpointInterval(123)
 *                                 .minPauseBetweenCheckpoints(123)
 *                                 .build())
 *                         .monitoringConfiguration(MonitoringConfigurationProperty.builder()
 *                                 .configurationType("configurationType")
 *                                 // the properties below are optional
 *                                 .logLevel("logLevel")
 *                                 .metricsLevel("metricsLevel")
 *                                 .build())
 *                         .parallelismConfiguration(ParallelismConfigurationProperty.builder()
 *                                 .configurationType("configurationType")
 *                                 // the properties below are optional
 *                                 .autoScalingEnabled(false)
 *                                 .parallelism(123)
 *                                 .parallelismPerKpu(123)
 *                                 .build())
 *                         .build())
 *                 .sqlApplicationConfiguration(SqlApplicationConfigurationProperty.builder()
 *                         .inputs(List.of(InputProperty.builder()
 *                                 .inputSchema(InputSchemaProperty.builder()
 *                                         .recordColumns(List.of(RecordColumnProperty.builder()
 *                                                 .name("name")
 *                                                 .sqlType("sqlType")
 *                                                 // the properties below are optional
 *                                                 .mapping("mapping")
 *                                                 .build()))
 *                                         .recordFormat(RecordFormatProperty.builder()
 *                                                 .recordFormatType("recordFormatType")
 *                                                 // the properties below are optional
 *                                                 .mappingParameters(MappingParametersProperty.builder()
 *                                                         .csvMappingParameters(CSVMappingParametersProperty.builder()
 *                                                                 .recordColumnDelimiter("recordColumnDelimiter")
 *                                                                 .recordRowDelimiter("recordRowDelimiter")
 *                                                                 .build())
 *                                                         .jsonMappingParameters(JSONMappingParametersProperty.builder()
 *                                                                 .recordRowPath("recordRowPath")
 *                                                                 .build())
 *                                                         .build())
 *                                                 .build())
 *                                         // the properties below are optional
 *                                         .recordEncoding("recordEncoding")
 *                                         .build())
 *                                 .namePrefix("namePrefix")
 *                                 // the properties below are optional
 *                                 .inputParallelism(InputParallelismProperty.builder()
 *                                         .count(123)
 *                                         .build())
 *                                 .inputProcessingConfiguration(InputProcessingConfigurationProperty.builder()
 *                                         .inputLambdaProcessor(InputLambdaProcessorProperty.builder()
 *                                                 .resourceArn("resourceArn")
 *                                                 .build())
 *                                         .build())
 *                                 .kinesisFirehoseInput(KinesisFirehoseInputProperty.builder()
 *                                         .resourceArn("resourceArn")
 *                                         .build())
 *                                 .kinesisStreamsInput(KinesisStreamsInputProperty.builder()
 *                                         .resourceArn("resourceArn")
 *                                         .build())
 *                                 .build()))
 *                         .build())
 *                 .vpcConfigurations(List.of(VpcConfigurationProperty.builder()
 *                         .securityGroupIds(List.of("securityGroupIds"))
 *                         .subnetIds(List.of("subnetIds"))
 *                         .build()))
 *                 .zeppelinApplicationConfiguration(ZeppelinApplicationConfigurationProperty.builder()
 *                         .catalogConfiguration(CatalogConfigurationProperty.builder()
 *                                 .glueDataCatalogConfiguration(GlueDataCatalogConfigurationProperty.builder()
 *                                         .databaseArn("databaseArn")
 *                                         .build())
 *                                 .build())
 *                         .customArtifactsConfiguration(List.of(CustomArtifactConfigurationProperty.builder()
 *                                 .artifactType("artifactType")
 *                                 // the properties below are optional
 *                                 .mavenReference(MavenReferenceProperty.builder()
 *                                         .artifactId("artifactId")
 *                                         .groupId("groupId")
 *                                         .version("version")
 *                                         .build())
 *                                 .s3ContentLocation(S3ContentLocationProperty.builder()
 *                                         .bucketArn("bucketArn")
 *                                         .fileKey("fileKey")
 *                                         // the properties below are optional
 *                                         .objectVersion("objectVersion")
 *                                         .build())
 *                                 .build()))
 *                         .deployAsApplicationConfiguration(DeployAsApplicationConfigurationProperty.builder()
 *                                 .s3ContentLocation(S3ContentBaseLocationProperty.builder()
 *                                         .bucketArn("bucketArn")
 *                                         // the properties below are optional
 *                                         .basePath("basePath")
 *                                         .build())
 *                                 .build())
 *                         .monitoringConfiguration(ZeppelinMonitoringConfigurationProperty.builder()
 *                                 .logLevel("logLevel")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .applicationDescription("applicationDescription")
 *         .applicationMaintenanceConfiguration(ApplicationMaintenanceConfigurationProperty.builder()
 *                 .applicationMaintenanceWindowStartTime("applicationMaintenanceWindowStartTime")
 *                 .build())
 *         .applicationMode("applicationMode")
 *         .applicationName("applicationName")
 *         .runConfiguration(RunConfigurationProperty.builder()
 *                 .applicationRestoreConfiguration(ApplicationRestoreConfigurationProperty.builder()
 *                         .applicationRestoreType("applicationRestoreType")
 *                         // the properties below are optional
 *                         .snapshotName("snapshotName")
 *                         .build())
 *                 .flinkRunConfiguration(FlinkRunConfigurationProperty.builder()
 *                         .allowNonRestoredState(false)
 *                         .build())
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:25:00.303Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplicationProps")
@software.amazon.jsii.Jsii.Proxy(CfnApplicationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnApplicationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The runtime environment for the application.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-runtimeenvironment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-runtimeenvironment</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRuntimeEnvironment();

    /**
     * Specifies the IAM role that the application uses to access external resources.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-serviceexecutionrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-serviceexecutionrole</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getServiceExecutionRole();

    /**
     * Use this parameter to configure the application.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-applicationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-applicationconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getApplicationConfiguration() {
        return null;
    }

    /**
     * The description of the application.
     * <p>
     * Default: - ""
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-applicationdescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-applicationdescription</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getApplicationDescription() {
        return null;
    }

    /**
     * Describes the maintenance configuration for the application.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-applicationmaintenanceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-applicationmaintenanceconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getApplicationMaintenanceConfiguration() {
        return null;
    }

    /**
     * To create a Kinesis Data Analytics Studio notebook, you must set the mode to <code>INTERACTIVE</code> .
     * <p>
     * However, for a Kinesis Data Analytics for Apache Flink application, the mode is optional.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-applicationmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-applicationmode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getApplicationMode() {
        return null;
    }

    /**
     * The name of the application.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-applicationname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-applicationname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getApplicationName() {
        return null;
    }

    /**
     * Describes the starting parameters for an Managed Service for Apache Flink application.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-runconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-runconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRunConfiguration() {
        return null;
    }

    /**
     * A list of one or more tags to assign to the application.
     * <p>
     * A tag is a key-value pair that identifies an application. Note that the maximum number of application tags includes system tags. The maximum number of user-defined application tags is 50.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalyticsv2-application.html#cfn-kinesisanalyticsv2-application-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnApplicationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnApplicationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnApplicationProps> {
        java.lang.String runtimeEnvironment;
        java.lang.String serviceExecutionRole;
        java.lang.Object applicationConfiguration;
        java.lang.String applicationDescription;
        java.lang.Object applicationMaintenanceConfiguration;
        java.lang.String applicationMode;
        java.lang.String applicationName;
        java.lang.Object runConfiguration;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnApplicationProps#getRuntimeEnvironment}
         * @param runtimeEnvironment The runtime environment for the application. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtimeEnvironment(java.lang.String runtimeEnvironment) {
            this.runtimeEnvironment = runtimeEnvironment;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getServiceExecutionRole}
         * @param serviceExecutionRole Specifies the IAM role that the application uses to access external resources. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceExecutionRole(java.lang.String serviceExecutionRole) {
            this.serviceExecutionRole = serviceExecutionRole;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getApplicationConfiguration}
         * @param applicationConfiguration Use this parameter to configure the application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationConfiguration(software.amazon.awscdk.IResolvable applicationConfiguration) {
            this.applicationConfiguration = applicationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getApplicationConfiguration}
         * @param applicationConfiguration Use this parameter to configure the application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationConfiguration(software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.ApplicationConfigurationProperty applicationConfiguration) {
            this.applicationConfiguration = applicationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getApplicationDescription}
         * @param applicationDescription The description of the application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationDescription(java.lang.String applicationDescription) {
            this.applicationDescription = applicationDescription;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getApplicationMaintenanceConfiguration}
         * @param applicationMaintenanceConfiguration Describes the maintenance configuration for the application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationMaintenanceConfiguration(software.amazon.awscdk.IResolvable applicationMaintenanceConfiguration) {
            this.applicationMaintenanceConfiguration = applicationMaintenanceConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getApplicationMaintenanceConfiguration}
         * @param applicationMaintenanceConfiguration Describes the maintenance configuration for the application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationMaintenanceConfiguration(software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.ApplicationMaintenanceConfigurationProperty applicationMaintenanceConfiguration) {
            this.applicationMaintenanceConfiguration = applicationMaintenanceConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getApplicationMode}
         * @param applicationMode To create a Kinesis Data Analytics Studio notebook, you must set the mode to <code>INTERACTIVE</code> .
         *                        However, for a Kinesis Data Analytics for Apache Flink application, the mode is optional.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationMode(java.lang.String applicationMode) {
            this.applicationMode = applicationMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getApplicationName}
         * @param applicationName The name of the application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationName(java.lang.String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getRunConfiguration}
         * @param runConfiguration Describes the starting parameters for an Managed Service for Apache Flink application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runConfiguration(software.amazon.awscdk.IResolvable runConfiguration) {
            this.runConfiguration = runConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getRunConfiguration}
         * @param runConfiguration Describes the starting parameters for an Managed Service for Apache Flink application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runConfiguration(software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.RunConfigurationProperty runConfiguration) {
            this.runConfiguration = runConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getTags}
         * @param tags A list of one or more tags to assign to the application.
         *             A tag is a key-value pair that identifies an application. Note that the maximum number of application tags includes system tags. The maximum number of user-defined application tags is 50.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnApplicationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnApplicationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnApplicationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnApplicationProps {
        private final java.lang.String runtimeEnvironment;
        private final java.lang.String serviceExecutionRole;
        private final java.lang.Object applicationConfiguration;
        private final java.lang.String applicationDescription;
        private final java.lang.Object applicationMaintenanceConfiguration;
        private final java.lang.String applicationMode;
        private final java.lang.String applicationName;
        private final java.lang.Object runConfiguration;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.runtimeEnvironment = software.amazon.jsii.Kernel.get(this, "runtimeEnvironment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serviceExecutionRole = software.amazon.jsii.Kernel.get(this, "serviceExecutionRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.applicationConfiguration = software.amazon.jsii.Kernel.get(this, "applicationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.applicationDescription = software.amazon.jsii.Kernel.get(this, "applicationDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.applicationMaintenanceConfiguration = software.amazon.jsii.Kernel.get(this, "applicationMaintenanceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.applicationMode = software.amazon.jsii.Kernel.get(this, "applicationMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.applicationName = software.amazon.jsii.Kernel.get(this, "applicationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.runConfiguration = software.amazon.jsii.Kernel.get(this, "runConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.runtimeEnvironment = java.util.Objects.requireNonNull(builder.runtimeEnvironment, "runtimeEnvironment is required");
            this.serviceExecutionRole = java.util.Objects.requireNonNull(builder.serviceExecutionRole, "serviceExecutionRole is required");
            this.applicationConfiguration = builder.applicationConfiguration;
            this.applicationDescription = builder.applicationDescription;
            this.applicationMaintenanceConfiguration = builder.applicationMaintenanceConfiguration;
            this.applicationMode = builder.applicationMode;
            this.applicationName = builder.applicationName;
            this.runConfiguration = builder.runConfiguration;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getRuntimeEnvironment() {
            return this.runtimeEnvironment;
        }

        @Override
        public final java.lang.String getServiceExecutionRole() {
            return this.serviceExecutionRole;
        }

        @Override
        public final java.lang.Object getApplicationConfiguration() {
            return this.applicationConfiguration;
        }

        @Override
        public final java.lang.String getApplicationDescription() {
            return this.applicationDescription;
        }

        @Override
        public final java.lang.Object getApplicationMaintenanceConfiguration() {
            return this.applicationMaintenanceConfiguration;
        }

        @Override
        public final java.lang.String getApplicationMode() {
            return this.applicationMode;
        }

        @Override
        public final java.lang.String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final java.lang.Object getRunConfiguration() {
            return this.runConfiguration;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("runtimeEnvironment", om.valueToTree(this.getRuntimeEnvironment()));
            data.set("serviceExecutionRole", om.valueToTree(this.getServiceExecutionRole()));
            if (this.getApplicationConfiguration() != null) {
                data.set("applicationConfiguration", om.valueToTree(this.getApplicationConfiguration()));
            }
            if (this.getApplicationDescription() != null) {
                data.set("applicationDescription", om.valueToTree(this.getApplicationDescription()));
            }
            if (this.getApplicationMaintenanceConfiguration() != null) {
                data.set("applicationMaintenanceConfiguration", om.valueToTree(this.getApplicationMaintenanceConfiguration()));
            }
            if (this.getApplicationMode() != null) {
                data.set("applicationMode", om.valueToTree(this.getApplicationMode()));
            }
            if (this.getApplicationName() != null) {
                data.set("applicationName", om.valueToTree(this.getApplicationName()));
            }
            if (this.getRunConfiguration() != null) {
                data.set("runConfiguration", om.valueToTree(this.getRunConfiguration()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplicationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnApplicationProps.Jsii$Proxy that = (CfnApplicationProps.Jsii$Proxy) o;

            if (!runtimeEnvironment.equals(that.runtimeEnvironment)) return false;
            if (!serviceExecutionRole.equals(that.serviceExecutionRole)) return false;
            if (this.applicationConfiguration != null ? !this.applicationConfiguration.equals(that.applicationConfiguration) : that.applicationConfiguration != null) return false;
            if (this.applicationDescription != null ? !this.applicationDescription.equals(that.applicationDescription) : that.applicationDescription != null) return false;
            if (this.applicationMaintenanceConfiguration != null ? !this.applicationMaintenanceConfiguration.equals(that.applicationMaintenanceConfiguration) : that.applicationMaintenanceConfiguration != null) return false;
            if (this.applicationMode != null ? !this.applicationMode.equals(that.applicationMode) : that.applicationMode != null) return false;
            if (this.applicationName != null ? !this.applicationName.equals(that.applicationName) : that.applicationName != null) return false;
            if (this.runConfiguration != null ? !this.runConfiguration.equals(that.runConfiguration) : that.runConfiguration != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.runtimeEnvironment.hashCode();
            result = 31 * result + (this.serviceExecutionRole.hashCode());
            result = 31 * result + (this.applicationConfiguration != null ? this.applicationConfiguration.hashCode() : 0);
            result = 31 * result + (this.applicationDescription != null ? this.applicationDescription.hashCode() : 0);
            result = 31 * result + (this.applicationMaintenanceConfiguration != null ? this.applicationMaintenanceConfiguration.hashCode() : 0);
            result = 31 * result + (this.applicationMode != null ? this.applicationMode.hashCode() : 0);
            result = 31 * result + (this.applicationName != null ? this.applicationName.hashCode() : 0);
            result = 31 * result + (this.runConfiguration != null ? this.runConfiguration.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
