package software.amazon.awscdk.services.lakeformation;

/**
 * The <code>AWS::LakeFormation::TagAssociation</code> resource represents an assignment of an LF-tag to a Data Catalog resource (database, table, or column).
 * <p>
 * During a stack operation, CloudFormation calls AWS Lake Formation <code>AddLFTagsToResource</code> API to create a <code>TagAssociation</code> resource and calls the <code>RemoveLFTagsToResource</code> API to delete it.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.glue.alpha.S3Table;
 * import software.amazon.awscdk.services.glue.alpha.Database;
 * import software.amazon.awscdk.services.glue.alpha.DataFormat;
 * import software.amazon.awscdk.services.glue.alpha.Schema;
 * import software.amazon.awscdk.services.lakeformation.CfnDataLakeSettings;
 * import software.amazon.awscdk.services.lakeformation.CfnTag;
 * import software.amazon.awscdk.services.lakeformation.CfnTagAssociation;
 * Stack stack;
 * String accountId;
 * String tagKey = "aws";
 * String[] tagValues = List.of("dev");
 * Database database = new Database(this, "Database");
 * S3Table table = S3Table.Builder.create(this, "Table")
 *         .database(database)
 *         .columns(List.of(Column.builder()
 *                 .name("col1")
 *                 .type(Schema.STRING)
 *                 .build(), Column.builder()
 *                 .name("col2")
 *                 .type(Schema.STRING)
 *                 .build()))
 *         .dataFormat(DataFormat.CSV)
 *         .build();
 * DefaultStackSynthesizer synthesizer = (DefaultStackSynthesizer)stack.getSynthesizer();
 * CfnDataLakeSettings.Builder.create(this, "DataLakeSettings")
 *         .admins(List.of(DataLakePrincipalProperty.builder()
 *                 .dataLakePrincipalIdentifier(stack.formatArn(ArnComponents.builder()
 *                         .service("iam")
 *                         .resource("role")
 *                         .region("")
 *                         .account(accountId)
 *                         .resourceName("Admin")
 *                         .build()))
 *                 .build(), DataLakePrincipalProperty.builder()
 *                 // The CDK cloudformation execution role.
 *                 .dataLakePrincipalIdentifier(synthesizer.cloudFormationExecutionRoleArn.replace("${AWS::Partition}", "aws"))
 *                 .build()))
 *         .build();
 * CfnTag tag = CfnTag.Builder.create(this, "Tag")
 *         .catalogId(accountId)
 *         .tagKey(tagKey)
 *         .tagValues(tagValues)
 *         .build();
 * LFTagPairProperty lfTagPairProperty = LFTagPairProperty.builder()
 *         .catalogId(accountId)
 *         .tagKey(tagKey)
 *         .tagValues(tagValues)
 *         .build();
 * CfnTagAssociation tagAssociation = CfnTagAssociation.Builder.create(this, "TagAssociation")
 *         .lfTags(List.of(lfTagPairProperty))
 *         .resource(ResourceProperty.builder()
 *                 .tableWithColumns(TableWithColumnsResourceProperty.builder()
 *                         .databaseName(database.getDatabaseName())
 *                         .columnNames(List.of("col1", "col2"))
 *                         .catalogId(accountId)
 *                         .name(table.getTableName())
 *                         .build())
 *                 .build())
 *         .build();
 * tagAssociation.node.addDependency(tag);
 * tagAssociation.node.addDependency(table);
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-tagassociation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-tagassociation.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:25:00.476Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lakeformation.CfnTagAssociation")
public class CfnTagAssociation extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnTagAssociation(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnTagAssociation(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lakeformation.CfnTagAssociation.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnTagAssociation(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lakeformation.CfnTagAssociationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * Json encoding of the input resource.
     * <p>
     * <strong>Examples</strong> - Database: <code>{"Catalog":null,"Database":{"CatalogId":"123456789012","Name":"ExampleDbName"},"Table":null,"TableWithColumns":null}</code>
     * <p>
     * <ul>
     * <li>Table: <code>{"Catalog":null,"Database":null,"Table":{"CatalogId":"123456789012","DatabaseName":"ExampleDbName","Name":"ExampleTableName","TableWildcard":null},"TableWithColumns":null}</code></li>
     * <li>Columns: <code>{"Catalog":null,"Database":null,"Table":null,"TableWithColumns":{"CatalogId":"123456789012","DatabaseName":"ExampleDbName","Name":"ExampleTableName","ColumnNames":["ExampleColName1","ExampleColName2"]}}</code></li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrResourceIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "attrResourceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Json encoding of the input LFTags list.
     * <p>
     * For example: <code>[{"CatalogId":null,"TagKey":"tagKey1","TagValues":null},{"CatalogId":null,"TagKey":"tagKey2","TagValues":null}]</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrTagsIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "attrTagsIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A structure containing an LF-tag key-value pair.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getLfTags() {
        return software.amazon.jsii.Kernel.get(this, "lfTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A structure containing an LF-tag key-value pair.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLfTags(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "lfTags", java.util.Objects.requireNonNull(value, "lfTags is required"));
    }

    /**
     * A structure containing an LF-tag key-value pair.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLfTags(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.lakeformation.CfnTagAssociation.LFTagPairProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.lakeformation.CfnTagAssociation.LFTagPairProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "lfTags", java.util.Objects.requireNonNull(value, "lfTags is required"));
    }

    /**
     * UTF-8 string (valid values: <code>DATABASE | TABLE</code> ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getResource() {
        return software.amazon.jsii.Kernel.get(this, "resource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * UTF-8 string (valid values: <code>DATABASE | TABLE</code> ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "resource", java.util.Objects.requireNonNull(value, "resource is required"));
    }

    /**
     * UTF-8 string (valid values: <code>DATABASE | TABLE</code> ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lakeformation.CfnTagAssociation.ResourceProperty value) {
        software.amazon.jsii.Kernel.set(this, "resource", java.util.Objects.requireNonNull(value, "resource is required"));
    }
    /**
     * A structure for the database object.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lakeformation.*;
     * DatabaseResourceProperty databaseResourceProperty = DatabaseResourceProperty.builder()
     *         .catalogId("catalogId")
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-tagassociation-databaseresource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-tagassociation-databaseresource.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lakeformation.CfnTagAssociation.DatabaseResourceProperty")
    @software.amazon.jsii.Jsii.Proxy(DatabaseResourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DatabaseResourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The identifier for the Data Catalog .
         * <p>
         * By default, it should be the account ID of the caller.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-tagassociation-databaseresource.html#cfn-lakeformation-tagassociation-databaseresource-catalogid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-tagassociation-databaseresource.html#cfn-lakeformation-tagassociation-databaseresource-catalogid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCatalogId();

        /**
         * The name of the database resource.
         * <p>
         * Unique to the Data Catalog.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-tagassociation-databaseresource.html#cfn-lakeformation-tagassociation-databaseresource-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-tagassociation-databaseresource.html#cfn-lakeformation-tagassociation-databaseresource-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * @return a {@link Builder} of {@link DatabaseResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DatabaseResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DatabaseResourceProperty> {
            java.lang.String catalogId;
            java.lang.String name;

            /**
             * Sets the value of {@link DatabaseResourceProperty#getCatalogId}
             * @param catalogId The identifier for the Data Catalog . This parameter is required.
             *                  By default, it should be the account ID of the caller.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder catalogId(java.lang.String catalogId) {
                this.catalogId = catalogId;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseResourceProperty#getName}
             * @param name The name of the database resource. This parameter is required.
             *             Unique to the Data Catalog.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DatabaseResourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DatabaseResourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DatabaseResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatabaseResourceProperty {
            private final java.lang.String catalogId;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.catalogId = software.amazon.jsii.Kernel.get(this, "catalogId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.catalogId = java.util.Objects.requireNonNull(builder.catalogId, "catalogId is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            }

            @Override
            public final java.lang.String getCatalogId() {
                return this.catalogId;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("catalogId", om.valueToTree(this.getCatalogId()));
                data.set("name", om.valueToTree(this.getName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lakeformation.CfnTagAssociation.DatabaseResourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DatabaseResourceProperty.Jsii$Proxy that = (DatabaseResourceProperty.Jsii$Proxy) o;

                if (!catalogId.equals(that.catalogId)) return false;
                return this.name.equals(that.name);
            }

            @Override
            public final int hashCode() {
                int result = this.catalogId.hashCode();
                result = 31 * result + (this.name.hashCode());
                return result;
            }
        }
    }
    /**
     * A structure containing the catalog ID, tag key, and tag values of an LF-tag key-value pair.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * import software.amazon.awscdk.*;
     * import software.amazon.awscdk.services.glue.alpha.S3Table;
     * import software.amazon.awscdk.services.glue.alpha.Database;
     * import software.amazon.awscdk.services.glue.alpha.DataFormat;
     * import software.amazon.awscdk.services.glue.alpha.Schema;
     * import software.amazon.awscdk.services.lakeformation.CfnDataLakeSettings;
     * import software.amazon.awscdk.services.lakeformation.CfnTag;
     * import software.amazon.awscdk.services.lakeformation.CfnTagAssociation;
     * Stack stack;
     * String accountId;
     * String tagKey = "aws";
     * String[] tagValues = List.of("dev");
     * Database database = new Database(this, "Database");
     * S3Table table = S3Table.Builder.create(this, "Table")
     *         .database(database)
     *         .columns(List.of(Column.builder()
     *                 .name("col1")
     *                 .type(Schema.STRING)
     *                 .build(), Column.builder()
     *                 .name("col2")
     *                 .type(Schema.STRING)
     *                 .build()))
     *         .dataFormat(DataFormat.CSV)
     *         .build();
     * DefaultStackSynthesizer synthesizer = (DefaultStackSynthesizer)stack.getSynthesizer();
     * CfnDataLakeSettings.Builder.create(this, "DataLakeSettings")
     *         .admins(List.of(DataLakePrincipalProperty.builder()
     *                 .dataLakePrincipalIdentifier(stack.formatArn(ArnComponents.builder()
     *                         .service("iam")
     *                         .resource("role")
     *                         .region("")
     *                         .account(accountId)
     *                         .resourceName("Admin")
     *                         .build()))
     *                 .build(), DataLakePrincipalProperty.builder()
     *                 // The CDK cloudformation execution role.
     *                 .dataLakePrincipalIdentifier(synthesizer.cloudFormationExecutionRoleArn.replace("${AWS::Partition}", "aws"))
     *                 .build()))
     *         .build();
     * CfnTag tag = CfnTag.Builder.create(this, "Tag")
     *         .catalogId(accountId)
     *         .tagKey(tagKey)
     *         .tagValues(tagValues)
     *         .build();
     * LFTagPairProperty lfTagPairProperty = LFTagPairProperty.builder()
     *         .catalogId(accountId)
     *         .tagKey(tagKey)
     *         .tagValues(tagValues)
     *         .build();
     * CfnTagAssociation tagAssociation = CfnTagAssociation.Builder.create(this, "TagAssociation")
     *         .lfTags(List.of(lfTagPairProperty))
     *         .resource(ResourceProperty.builder()
     *                 .tableWithColumns(TableWithColumnsResourceProperty.builder()
     *                         .databaseName(database.getDatabaseName())
     *                         .columnNames(List.of("col1", "col2"))
     *                         .catalogId(accountId)
     *                         .name(table.getTableName())
     *                         .build())
     *                 .build())
     *         .build();
     * tagAssociation.node.addDependency(tag);
     * tagAssociation.node.addDependency(table);
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-tagassociation-lftagpair.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-tagassociation-lftagpair.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lakeformation.CfnTagAssociation.LFTagPairProperty")
    @software.amazon.jsii.Jsii.Proxy(LFTagPairProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LFTagPairProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The identifier for the Data Catalog .
         * <p>
         * By default, it is the account ID of the caller.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-tagassociation-lftagpair.html#cfn-lakeformation-tagassociation-lftagpair-catalogid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-tagassociation-lftagpair.html#cfn-lakeformation-tagassociation-lftagpair-catalogid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCatalogId();

        /**
         * The key-name for the LF-tag.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-tagassociation-lftagpair.html#cfn-lakeformation-tagassociation-lftagpair-tagkey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-tagassociation-lftagpair.html#cfn-lakeformation-tagassociation-lftagpair-tagkey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTagKey();

        /**
         * A list of possible values of the corresponding <code>TagKey</code> of an LF-tag key-value pair.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-tagassociation-lftagpair.html#cfn-lakeformation-tagassociation-lftagpair-tagvalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-tagassociation-lftagpair.html#cfn-lakeformation-tagassociation-lftagpair-tagvalues</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getTagValues();

        /**
         * @return a {@link Builder} of {@link LFTagPairProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LFTagPairProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LFTagPairProperty> {
            java.lang.String catalogId;
            java.lang.String tagKey;
            java.util.List<java.lang.String> tagValues;

            /**
             * Sets the value of {@link LFTagPairProperty#getCatalogId}
             * @param catalogId The identifier for the Data Catalog . This parameter is required.
             *                  By default, it is the account ID of the caller.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder catalogId(java.lang.String catalogId) {
                this.catalogId = catalogId;
                return this;
            }

            /**
             * Sets the value of {@link LFTagPairProperty#getTagKey}
             * @param tagKey The key-name for the LF-tag. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagKey(java.lang.String tagKey) {
                this.tagKey = tagKey;
                return this;
            }

            /**
             * Sets the value of {@link LFTagPairProperty#getTagValues}
             * @param tagValues A list of possible values of the corresponding <code>TagKey</code> of an LF-tag key-value pair. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagValues(java.util.List<java.lang.String> tagValues) {
                this.tagValues = tagValues;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LFTagPairProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LFTagPairProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LFTagPairProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LFTagPairProperty {
            private final java.lang.String catalogId;
            private final java.lang.String tagKey;
            private final java.util.List<java.lang.String> tagValues;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.catalogId = software.amazon.jsii.Kernel.get(this, "catalogId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tagKey = software.amazon.jsii.Kernel.get(this, "tagKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tagValues = software.amazon.jsii.Kernel.get(this, "tagValues", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.catalogId = java.util.Objects.requireNonNull(builder.catalogId, "catalogId is required");
                this.tagKey = java.util.Objects.requireNonNull(builder.tagKey, "tagKey is required");
                this.tagValues = java.util.Objects.requireNonNull(builder.tagValues, "tagValues is required");
            }

            @Override
            public final java.lang.String getCatalogId() {
                return this.catalogId;
            }

            @Override
            public final java.lang.String getTagKey() {
                return this.tagKey;
            }

            @Override
            public final java.util.List<java.lang.String> getTagValues() {
                return this.tagValues;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("catalogId", om.valueToTree(this.getCatalogId()));
                data.set("tagKey", om.valueToTree(this.getTagKey()));
                data.set("tagValues", om.valueToTree(this.getTagValues()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lakeformation.CfnTagAssociation.LFTagPairProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LFTagPairProperty.Jsii$Proxy that = (LFTagPairProperty.Jsii$Proxy) o;

                if (!catalogId.equals(that.catalogId)) return false;
                if (!tagKey.equals(that.tagKey)) return false;
                return this.tagValues.equals(that.tagValues);
            }

            @Override
            public final int hashCode() {
                int result = this.catalogId.hashCode();
                result = 31 * result + (this.tagKey.hashCode());
                result = 31 * result + (this.tagValues.hashCode());
                return result;
            }
        }
    }
    /**
     * A structure for the resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lakeformation.*;
     * Object catalog;
     * Object tableWildcard;
     * ResourceProperty resourceProperty = ResourceProperty.builder()
     *         .catalog(catalog)
     *         .database(DatabaseResourceProperty.builder()
     *                 .catalogId("catalogId")
     *                 .name("name")
     *                 .build())
     *         .table(TableResourceProperty.builder()
     *                 .catalogId("catalogId")
     *                 .databaseName("databaseName")
     *                 // the properties below are optional
     *                 .name("name")
     *                 .tableWildcard(tableWildcard)
     *                 .build())
     *         .tableWithColumns(TableWithColumnsResourceProperty.builder()
     *                 .catalogId("catalogId")
     *                 .columnNames(List.of("columnNames"))
     *                 .databaseName("databaseName")
     *                 .name("name")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-tagassociation-resource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-tagassociation-resource.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lakeformation.CfnTagAssociation.ResourceProperty")
    @software.amazon.jsii.Jsii.Proxy(ResourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The identifier for the Data Catalog.
         * <p>
         * By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-tagassociation-resource.html#cfn-lakeformation-tagassociation-resource-catalog">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-tagassociation-resource.html#cfn-lakeformation-tagassociation-resource-catalog</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCatalog() {
            return null;
        }

        /**
         * The database for the resource.
         * <p>
         * Unique to the Data Catalog. A database is a set of associated table definitions organized into a logical group. You can Grant and Revoke database permissions to a principal.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-tagassociation-resource.html#cfn-lakeformation-tagassociation-resource-database">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-tagassociation-resource.html#cfn-lakeformation-tagassociation-resource-database</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDatabase() {
            return null;
        }

        /**
         * The table for the resource.
         * <p>
         * A table is a metadata definition that represents your data. You can Grant and Revoke table privileges to a principal.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-tagassociation-resource.html#cfn-lakeformation-tagassociation-resource-table">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-tagassociation-resource.html#cfn-lakeformation-tagassociation-resource-table</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTable() {
            return null;
        }

        /**
         * The table with columns for the resource.
         * <p>
         * A principal with permissions to this resource can select metadata from the columns of a table in the Data Catalog and the underlying data in Amazon S3.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-tagassociation-resource.html#cfn-lakeformation-tagassociation-resource-tablewithcolumns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-tagassociation-resource.html#cfn-lakeformation-tagassociation-resource-tablewithcolumns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTableWithColumns() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResourceProperty> {
            java.lang.Object catalog;
            java.lang.Object database;
            java.lang.Object table;
            java.lang.Object tableWithColumns;

            /**
             * Sets the value of {@link ResourceProperty#getCatalog}
             * @param catalog The identifier for the Data Catalog.
             *                By default, the account ID. The Data Catalog is the persistent metadata store. It contains database definitions, table definitions, and other control information to manage your AWS Lake Formation environment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder catalog(java.lang.Object catalog) {
                this.catalog = catalog;
                return this;
            }

            /**
             * Sets the value of {@link ResourceProperty#getDatabase}
             * @param database The database for the resource.
             *                 Unique to the Data Catalog. A database is a set of associated table definitions organized into a logical group. You can Grant and Revoke database permissions to a principal.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder database(software.amazon.awscdk.IResolvable database) {
                this.database = database;
                return this;
            }

            /**
             * Sets the value of {@link ResourceProperty#getDatabase}
             * @param database The database for the resource.
             *                 Unique to the Data Catalog. A database is a set of associated table definitions organized into a logical group. You can Grant and Revoke database permissions to a principal.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder database(software.amazon.awscdk.services.lakeformation.CfnTagAssociation.DatabaseResourceProperty database) {
                this.database = database;
                return this;
            }

            /**
             * Sets the value of {@link ResourceProperty#getTable}
             * @param table The table for the resource.
             *              A table is a metadata definition that represents your data. You can Grant and Revoke table privileges to a principal.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder table(software.amazon.awscdk.IResolvable table) {
                this.table = table;
                return this;
            }

            /**
             * Sets the value of {@link ResourceProperty#getTable}
             * @param table The table for the resource.
             *              A table is a metadata definition that represents your data. You can Grant and Revoke table privileges to a principal.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder table(software.amazon.awscdk.services.lakeformation.CfnTagAssociation.TableResourceProperty table) {
                this.table = table;
                return this;
            }

            /**
             * Sets the value of {@link ResourceProperty#getTableWithColumns}
             * @param tableWithColumns The table with columns for the resource.
             *                         A principal with permissions to this resource can select metadata from the columns of a table in the Data Catalog and the underlying data in Amazon S3.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tableWithColumns(software.amazon.awscdk.IResolvable tableWithColumns) {
                this.tableWithColumns = tableWithColumns;
                return this;
            }

            /**
             * Sets the value of {@link ResourceProperty#getTableWithColumns}
             * @param tableWithColumns The table with columns for the resource.
             *                         A principal with permissions to this resource can select metadata from the columns of a table in the Data Catalog and the underlying data in Amazon S3.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tableWithColumns(software.amazon.awscdk.services.lakeformation.CfnTagAssociation.TableWithColumnsResourceProperty tableWithColumns) {
                this.tableWithColumns = tableWithColumns;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourceProperty {
            private final java.lang.Object catalog;
            private final java.lang.Object database;
            private final java.lang.Object table;
            private final java.lang.Object tableWithColumns;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.catalog = software.amazon.jsii.Kernel.get(this, "catalog", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.database = software.amazon.jsii.Kernel.get(this, "database", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.table = software.amazon.jsii.Kernel.get(this, "table", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.tableWithColumns = software.amazon.jsii.Kernel.get(this, "tableWithColumns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.catalog = builder.catalog;
                this.database = builder.database;
                this.table = builder.table;
                this.tableWithColumns = builder.tableWithColumns;
            }

            @Override
            public final java.lang.Object getCatalog() {
                return this.catalog;
            }

            @Override
            public final java.lang.Object getDatabase() {
                return this.database;
            }

            @Override
            public final java.lang.Object getTable() {
                return this.table;
            }

            @Override
            public final java.lang.Object getTableWithColumns() {
                return this.tableWithColumns;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCatalog() != null) {
                    data.set("catalog", om.valueToTree(this.getCatalog()));
                }
                if (this.getDatabase() != null) {
                    data.set("database", om.valueToTree(this.getDatabase()));
                }
                if (this.getTable() != null) {
                    data.set("table", om.valueToTree(this.getTable()));
                }
                if (this.getTableWithColumns() != null) {
                    data.set("tableWithColumns", om.valueToTree(this.getTableWithColumns()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lakeformation.CfnTagAssociation.ResourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResourceProperty.Jsii$Proxy that = (ResourceProperty.Jsii$Proxy) o;

                if (this.catalog != null ? !this.catalog.equals(that.catalog) : that.catalog != null) return false;
                if (this.database != null ? !this.database.equals(that.database) : that.database != null) return false;
                if (this.table != null ? !this.table.equals(that.table) : that.table != null) return false;
                return this.tableWithColumns != null ? this.tableWithColumns.equals(that.tableWithColumns) : that.tableWithColumns == null;
            }

            @Override
            public final int hashCode() {
                int result = this.catalog != null ? this.catalog.hashCode() : 0;
                result = 31 * result + (this.database != null ? this.database.hashCode() : 0);
                result = 31 * result + (this.table != null ? this.table.hashCode() : 0);
                result = 31 * result + (this.tableWithColumns != null ? this.tableWithColumns.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A structure for the table object.
     * <p>
     * A table is a metadata definition that represents your data. You can Grant and Revoke table privileges to a principal.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lakeformation.*;
     * Object tableWildcard;
     * TableResourceProperty tableResourceProperty = TableResourceProperty.builder()
     *         .catalogId("catalogId")
     *         .databaseName("databaseName")
     *         // the properties below are optional
     *         .name("name")
     *         .tableWildcard(tableWildcard)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-tagassociation-tableresource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-tagassociation-tableresource.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lakeformation.CfnTagAssociation.TableResourceProperty")
    @software.amazon.jsii.Jsii.Proxy(TableResourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TableResourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The identifier for the Data Catalog .
         * <p>
         * By default, it is the account ID of the caller.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-tagassociation-tableresource.html#cfn-lakeformation-tagassociation-tableresource-catalogid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-tagassociation-tableresource.html#cfn-lakeformation-tagassociation-tableresource-catalogid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCatalogId();

        /**
         * The name of the database for the table.
         * <p>
         * Unique to a Data Catalog. A database is a set of associated table definitions organized into a logical group. You can Grant and Revoke database privileges to a principal.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-tagassociation-tableresource.html#cfn-lakeformation-tagassociation-tableresource-databasename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-tagassociation-tableresource.html#cfn-lakeformation-tagassociation-tableresource-databasename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatabaseName();

        /**
         * The name of the table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-tagassociation-tableresource.html#cfn-lakeformation-tagassociation-tableresource-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-tagassociation-tableresource.html#cfn-lakeformation-tagassociation-tableresource-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * A wildcard object representing every table under a database.This is an object with no properties that effectively behaves as a true or false depending on whether not it is passed as a parameter. The valid inputs for a property with this type in either yaml or json is null or {}.
         * <p>
         * At least one of <code>TableResource$Name</code> or <code>TableResource$TableWildcard</code> is required.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-tagassociation-tableresource.html#cfn-lakeformation-tagassociation-tableresource-tablewildcard">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-tagassociation-tableresource.html#cfn-lakeformation-tagassociation-tableresource-tablewildcard</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTableWildcard() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TableResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TableResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TableResourceProperty> {
            java.lang.String catalogId;
            java.lang.String databaseName;
            java.lang.String name;
            java.lang.Object tableWildcard;

            /**
             * Sets the value of {@link TableResourceProperty#getCatalogId}
             * @param catalogId The identifier for the Data Catalog . This parameter is required.
             *                  By default, it is the account ID of the caller.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder catalogId(java.lang.String catalogId) {
                this.catalogId = catalogId;
                return this;
            }

            /**
             * Sets the value of {@link TableResourceProperty#getDatabaseName}
             * @param databaseName The name of the database for the table. This parameter is required.
             *                     Unique to a Data Catalog. A database is a set of associated table definitions organized into a logical group. You can Grant and Revoke database privileges to a principal.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseName(java.lang.String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            /**
             * Sets the value of {@link TableResourceProperty#getName}
             * @param name The name of the table.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link TableResourceProperty#getTableWildcard}
             * @param tableWildcard A wildcard object representing every table under a database.This is an object with no properties that effectively behaves as a true or false depending on whether not it is passed as a parameter. The valid inputs for a property with this type in either yaml or json is null or {}.
             *                      At least one of <code>TableResource$Name</code> or <code>TableResource$TableWildcard</code> is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tableWildcard(java.lang.Object tableWildcard) {
                this.tableWildcard = tableWildcard;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TableResourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TableResourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TableResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TableResourceProperty {
            private final java.lang.String catalogId;
            private final java.lang.String databaseName;
            private final java.lang.String name;
            private final java.lang.Object tableWildcard;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.catalogId = software.amazon.jsii.Kernel.get(this, "catalogId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tableWildcard = software.amazon.jsii.Kernel.get(this, "tableWildcard", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.catalogId = java.util.Objects.requireNonNull(builder.catalogId, "catalogId is required");
                this.databaseName = java.util.Objects.requireNonNull(builder.databaseName, "databaseName is required");
                this.name = builder.name;
                this.tableWildcard = builder.tableWildcard;
            }

            @Override
            public final java.lang.String getCatalogId() {
                return this.catalogId;
            }

            @Override
            public final java.lang.String getDatabaseName() {
                return this.databaseName;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getTableWildcard() {
                return this.tableWildcard;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("catalogId", om.valueToTree(this.getCatalogId()));
                data.set("databaseName", om.valueToTree(this.getDatabaseName()));
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getTableWildcard() != null) {
                    data.set("tableWildcard", om.valueToTree(this.getTableWildcard()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lakeformation.CfnTagAssociation.TableResourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TableResourceProperty.Jsii$Proxy that = (TableResourceProperty.Jsii$Proxy) o;

                if (!catalogId.equals(that.catalogId)) return false;
                if (!databaseName.equals(that.databaseName)) return false;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.tableWildcard != null ? this.tableWildcard.equals(that.tableWildcard) : that.tableWildcard == null;
            }

            @Override
            public final int hashCode() {
                int result = this.catalogId.hashCode();
                result = 31 * result + (this.databaseName.hashCode());
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.tableWildcard != null ? this.tableWildcard.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A structure for a table with columns object. This object is only used when granting a SELECT permission.
     * <p>
     * This object must take a value for at least one of <code>ColumnsNames</code> , <code>ColumnsIndexes</code> , or <code>ColumnsWildcard</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lakeformation.*;
     * TableWithColumnsResourceProperty tableWithColumnsResourceProperty = TableWithColumnsResourceProperty.builder()
     *         .catalogId("catalogId")
     *         .columnNames(List.of("columnNames"))
     *         .databaseName("databaseName")
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-tagassociation-tablewithcolumnsresource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-tagassociation-tablewithcolumnsresource.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lakeformation.CfnTagAssociation.TableWithColumnsResourceProperty")
    @software.amazon.jsii.Jsii.Proxy(TableWithColumnsResourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TableWithColumnsResourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A wildcard object representing every table under a database.
         * <p>
         * At least one of TableResource$Name or TableResource$TableWildcard is required.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-tagassociation-tablewithcolumnsresource.html#cfn-lakeformation-tagassociation-tablewithcolumnsresource-catalogid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-tagassociation-tablewithcolumnsresource.html#cfn-lakeformation-tagassociation-tablewithcolumnsresource-catalogid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCatalogId();

        /**
         * The list of column names for the table.
         * <p>
         * At least one of <code>ColumnNames</code> or <code>ColumnWildcard</code> is required.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-tagassociation-tablewithcolumnsresource.html#cfn-lakeformation-tagassociation-tablewithcolumnsresource-columnnames">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-tagassociation-tablewithcolumnsresource.html#cfn-lakeformation-tagassociation-tablewithcolumnsresource-columnnames</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getColumnNames();

        /**
         * The name of the database for the table with columns resource.
         * <p>
         * Unique to the Data Catalog. A database is a set of associated table definitions organized into a logical group. You can Grant and Revoke database privileges to a principal.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-tagassociation-tablewithcolumnsresource.html#cfn-lakeformation-tagassociation-tablewithcolumnsresource-databasename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-tagassociation-tablewithcolumnsresource.html#cfn-lakeformation-tagassociation-tablewithcolumnsresource-databasename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatabaseName();

        /**
         * The name of the table resource.
         * <p>
         * A table is a metadata definition that represents your data. You can Grant and Revoke table privileges to a principal.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-tagassociation-tablewithcolumnsresource.html#cfn-lakeformation-tagassociation-tablewithcolumnsresource-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-tagassociation-tablewithcolumnsresource.html#cfn-lakeformation-tagassociation-tablewithcolumnsresource-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * @return a {@link Builder} of {@link TableWithColumnsResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TableWithColumnsResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TableWithColumnsResourceProperty> {
            java.lang.String catalogId;
            java.util.List<java.lang.String> columnNames;
            java.lang.String databaseName;
            java.lang.String name;

            /**
             * Sets the value of {@link TableWithColumnsResourceProperty#getCatalogId}
             * @param catalogId A wildcard object representing every table under a database. This parameter is required.
             *                  At least one of TableResource$Name or TableResource$TableWildcard is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder catalogId(java.lang.String catalogId) {
                this.catalogId = catalogId;
                return this;
            }

            /**
             * Sets the value of {@link TableWithColumnsResourceProperty#getColumnNames}
             * @param columnNames The list of column names for the table. This parameter is required.
             *                    At least one of <code>ColumnNames</code> or <code>ColumnWildcard</code> is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columnNames(java.util.List<java.lang.String> columnNames) {
                this.columnNames = columnNames;
                return this;
            }

            /**
             * Sets the value of {@link TableWithColumnsResourceProperty#getDatabaseName}
             * @param databaseName The name of the database for the table with columns resource. This parameter is required.
             *                     Unique to the Data Catalog. A database is a set of associated table definitions organized into a logical group. You can Grant and Revoke database privileges to a principal.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseName(java.lang.String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            /**
             * Sets the value of {@link TableWithColumnsResourceProperty#getName}
             * @param name The name of the table resource. This parameter is required.
             *             A table is a metadata definition that represents your data. You can Grant and Revoke table privileges to a principal.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TableWithColumnsResourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TableWithColumnsResourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TableWithColumnsResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TableWithColumnsResourceProperty {
            private final java.lang.String catalogId;
            private final java.util.List<java.lang.String> columnNames;
            private final java.lang.String databaseName;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.catalogId = software.amazon.jsii.Kernel.get(this, "catalogId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.columnNames = software.amazon.jsii.Kernel.get(this, "columnNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.catalogId = java.util.Objects.requireNonNull(builder.catalogId, "catalogId is required");
                this.columnNames = java.util.Objects.requireNonNull(builder.columnNames, "columnNames is required");
                this.databaseName = java.util.Objects.requireNonNull(builder.databaseName, "databaseName is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            }

            @Override
            public final java.lang.String getCatalogId() {
                return this.catalogId;
            }

            @Override
            public final java.util.List<java.lang.String> getColumnNames() {
                return this.columnNames;
            }

            @Override
            public final java.lang.String getDatabaseName() {
                return this.databaseName;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("catalogId", om.valueToTree(this.getCatalogId()));
                data.set("columnNames", om.valueToTree(this.getColumnNames()));
                data.set("databaseName", om.valueToTree(this.getDatabaseName()));
                data.set("name", om.valueToTree(this.getName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lakeformation.CfnTagAssociation.TableWithColumnsResourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TableWithColumnsResourceProperty.Jsii$Proxy that = (TableWithColumnsResourceProperty.Jsii$Proxy) o;

                if (!catalogId.equals(that.catalogId)) return false;
                if (!columnNames.equals(that.columnNames)) return false;
                if (!databaseName.equals(that.databaseName)) return false;
                return this.name.equals(that.name);
            }

            @Override
            public final int hashCode() {
                int result = this.catalogId.hashCode();
                result = 31 * result + (this.columnNames.hashCode());
                result = 31 * result + (this.databaseName.hashCode());
                result = 31 * result + (this.name.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.lakeformation.CfnTagAssociation}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.lakeformation.CfnTagAssociation> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.lakeformation.CfnTagAssociationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.lakeformation.CfnTagAssociationProps.Builder();
        }

        /**
         * A structure containing an LF-tag key-value pair.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-tagassociation.html#cfn-lakeformation-tagassociation-lftags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-tagassociation.html#cfn-lakeformation-tagassociation-lftags</a>
         * @param lfTags A structure containing an LF-tag key-value pair. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lfTags(final software.amazon.awscdk.IResolvable lfTags) {
            this.props.lfTags(lfTags);
            return this;
        }
        /**
         * A structure containing an LF-tag key-value pair.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-tagassociation.html#cfn-lakeformation-tagassociation-lftags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-tagassociation.html#cfn-lakeformation-tagassociation-lftags</a>
         * @param lfTags A structure containing an LF-tag key-value pair. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lfTags(final java.util.List<? extends java.lang.Object> lfTags) {
            this.props.lfTags(lfTags);
            return this;
        }

        /**
         * UTF-8 string (valid values: <code>DATABASE | TABLE</code> ).
         * <p>
         * The resource for which the LF-tag policy applies.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-tagassociation.html#cfn-lakeformation-tagassociation-resource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-tagassociation.html#cfn-lakeformation-tagassociation-resource</a>
         * @param resource UTF-8 string (valid values: <code>DATABASE | TABLE</code> ). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resource(final software.amazon.awscdk.IResolvable resource) {
            this.props.resource(resource);
            return this;
        }
        /**
         * UTF-8 string (valid values: <code>DATABASE | TABLE</code> ).
         * <p>
         * The resource for which the LF-tag policy applies.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-tagassociation.html#cfn-lakeformation-tagassociation-resource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lakeformation-tagassociation.html#cfn-lakeformation-tagassociation-resource</a>
         * @param resource UTF-8 string (valid values: <code>DATABASE | TABLE</code> ). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resource(final software.amazon.awscdk.services.lakeformation.CfnTagAssociation.ResourceProperty resource) {
            this.props.resource(resource);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.lakeformation.CfnTagAssociation}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.lakeformation.CfnTagAssociation build() {
            return new software.amazon.awscdk.services.lakeformation.CfnTagAssociation(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
