package software.amazon.awscdk.services.lightsail;

/**
 * Properties for defining a <code>CfnContainer</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lightsail.*;
 * CfnContainerProps cfnContainerProps = CfnContainerProps.builder()
 *         .power("power")
 *         .scale(123)
 *         .serviceName("serviceName")
 *         // the properties below are optional
 *         .containerServiceDeployment(ContainerServiceDeploymentProperty.builder()
 *                 .containers(List.of(ContainerProperty.builder()
 *                         .command(List.of("command"))
 *                         .containerName("containerName")
 *                         .environment(List.of(EnvironmentVariableProperty.builder()
 *                                 .value("value")
 *                                 .variable("variable")
 *                                 .build()))
 *                         .image("image")
 *                         .ports(List.of(PortInfoProperty.builder()
 *                                 .port("port")
 *                                 .protocol("protocol")
 *                                 .build()))
 *                         .build()))
 *                 .publicEndpoint(PublicEndpointProperty.builder()
 *                         .containerName("containerName")
 *                         .containerPort(123)
 *                         .healthCheckConfig(HealthCheckConfigProperty.builder()
 *                                 .healthyThreshold(123)
 *                                 .intervalSeconds(123)
 *                                 .path("path")
 *                                 .successCodes("successCodes")
 *                                 .timeoutSeconds(123)
 *                                 .unhealthyThreshold(123)
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .isDisabled(false)
 *         .privateRegistryAccess(PrivateRegistryAccessProperty.builder()
 *                 .ecrImagePullerRole(EcrImagePullerRoleProperty.builder()
 *                         .isActive(false)
 *                         .principalArn("principalArn")
 *                         .build())
 *                 .build())
 *         .publicDomainNames(List.of(PublicDomainNameProperty.builder()
 *                 .certificateName("certificateName")
 *                 .domainNames(List.of("domainNames"))
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-container.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-container.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:25:00.869Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lightsail.CfnContainerProps")
@software.amazon.jsii.Jsii.Proxy(CfnContainerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnContainerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The power specification of the container service.
     * <p>
     * The power specifies the amount of RAM, the number of vCPUs, and the base price of the container service.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-container.html#cfn-lightsail-container-power">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-container.html#cfn-lightsail-container-power</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPower();

    /**
     * The scale specification of the container service.
     * <p>
     * The scale specifies the allocated compute nodes of the container service.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-container.html#cfn-lightsail-container-scale">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-container.html#cfn-lightsail-container-scale</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getScale();

    /**
     * The name of the container service.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-container.html#cfn-lightsail-container-servicename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-container.html#cfn-lightsail-container-servicename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getServiceName();

    /**
     * An object that describes the current container deployment of the container service.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-container.html#cfn-lightsail-container-containerservicedeployment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-container.html#cfn-lightsail-container-containerservicedeployment</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getContainerServiceDeployment() {
        return null;
    }

    /**
     * A Boolean value indicating whether the container service is disabled.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-container.html#cfn-lightsail-container-isdisabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-container.html#cfn-lightsail-container-isdisabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getIsDisabled() {
        return null;
    }

    /**
     * An object that describes the configuration for the container service to access private container image repositories, such as Amazon Elastic Container Registry ( Amazon ECR ) private repositories.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/lightsail/latest/userguide/amazon-lightsail-container-service-ecr-private-repo-access">Configuring access to an Amazon ECR private repository for an Amazon Lightsail container service</a> in the <em>Amazon Lightsail Developer Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-container.html#cfn-lightsail-container-privateregistryaccess">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-container.html#cfn-lightsail-container-privateregistryaccess</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPrivateRegistryAccess() {
        return null;
    }

    /**
     * The public domain name of the container service, such as <code>example.com</code> and <code>www.example.com</code> .
     * <p>
     * You can specify up to four public domain names for a container service. The domain names that you specify are used when you create a deployment with a container that is configured as the public endpoint of your container service.
     * <p>
     * If you don't specify public domain names, then you can use the default domain of the container service.
     * <p>
     * <blockquote>
     * <p>
     * You must create and validate an SSL/TLS certificate before you can use public domain names with your container service. Use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-certificate.html">AWS::Lightsail::Certificate</a> resource to create a certificate for the public domain names that you want to use with your container service.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-container.html#cfn-lightsail-container-publicdomainnames">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-container.html#cfn-lightsail-container-publicdomainnames</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPublicDomainNames() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> in the <em>AWS CloudFormation User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * The <code>Value</code> of <code>Tags</code> is optional for Lightsail resources.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-container.html#cfn-lightsail-container-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-container.html#cfn-lightsail-container-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnContainerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnContainerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnContainerProps> {
        java.lang.String power;
        java.lang.Number scale;
        java.lang.String serviceName;
        java.lang.Object containerServiceDeployment;
        java.lang.Object isDisabled;
        java.lang.Object privateRegistryAccess;
        java.lang.Object publicDomainNames;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnContainerProps#getPower}
         * @param power The power specification of the container service. This parameter is required.
         *              The power specifies the amount of RAM, the number of vCPUs, and the base price of the container service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder power(java.lang.String power) {
            this.power = power;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerProps#getScale}
         * @param scale The scale specification of the container service. This parameter is required.
         *              The scale specifies the allocated compute nodes of the container service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scale(java.lang.Number scale) {
            this.scale = scale;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerProps#getServiceName}
         * @param serviceName The name of the container service. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceName(java.lang.String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerProps#getContainerServiceDeployment}
         * @param containerServiceDeployment An object that describes the current container deployment of the container service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerServiceDeployment(software.amazon.awscdk.IResolvable containerServiceDeployment) {
            this.containerServiceDeployment = containerServiceDeployment;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerProps#getContainerServiceDeployment}
         * @param containerServiceDeployment An object that describes the current container deployment of the container service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerServiceDeployment(software.amazon.awscdk.services.lightsail.CfnContainer.ContainerServiceDeploymentProperty containerServiceDeployment) {
            this.containerServiceDeployment = containerServiceDeployment;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerProps#getIsDisabled}
         * @param isDisabled A Boolean value indicating whether the container service is disabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isDisabled(java.lang.Boolean isDisabled) {
            this.isDisabled = isDisabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerProps#getIsDisabled}
         * @param isDisabled A Boolean value indicating whether the container service is disabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isDisabled(software.amazon.awscdk.IResolvable isDisabled) {
            this.isDisabled = isDisabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerProps#getPrivateRegistryAccess}
         * @param privateRegistryAccess An object that describes the configuration for the container service to access private container image repositories, such as Amazon Elastic Container Registry ( Amazon ECR ) private repositories.
         *                              For more information, see <a href="https://docs.aws.amazon.com/lightsail/latest/userguide/amazon-lightsail-container-service-ecr-private-repo-access">Configuring access to an Amazon ECR private repository for an Amazon Lightsail container service</a> in the <em>Amazon Lightsail Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privateRegistryAccess(software.amazon.awscdk.IResolvable privateRegistryAccess) {
            this.privateRegistryAccess = privateRegistryAccess;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerProps#getPrivateRegistryAccess}
         * @param privateRegistryAccess An object that describes the configuration for the container service to access private container image repositories, such as Amazon Elastic Container Registry ( Amazon ECR ) private repositories.
         *                              For more information, see <a href="https://docs.aws.amazon.com/lightsail/latest/userguide/amazon-lightsail-container-service-ecr-private-repo-access">Configuring access to an Amazon ECR private repository for an Amazon Lightsail container service</a> in the <em>Amazon Lightsail Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privateRegistryAccess(software.amazon.awscdk.services.lightsail.CfnContainer.PrivateRegistryAccessProperty privateRegistryAccess) {
            this.privateRegistryAccess = privateRegistryAccess;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerProps#getPublicDomainNames}
         * @param publicDomainNames The public domain name of the container service, such as <code>example.com</code> and <code>www.example.com</code> .
         *                          You can specify up to four public domain names for a container service. The domain names that you specify are used when you create a deployment with a container that is configured as the public endpoint of your container service.
         *                          <p>
         *                          If you don't specify public domain names, then you can use the default domain of the container service.
         *                          <p>
         *                          <blockquote>
         *                          <p>
         *                          You must create and validate an SSL/TLS certificate before you can use public domain names with your container service. Use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-certificate.html">AWS::Lightsail::Certificate</a> resource to create a certificate for the public domain names that you want to use with your container service.
         *                          <p>
         *                          </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicDomainNames(software.amazon.awscdk.IResolvable publicDomainNames) {
            this.publicDomainNames = publicDomainNames;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerProps#getPublicDomainNames}
         * @param publicDomainNames The public domain name of the container service, such as <code>example.com</code> and <code>www.example.com</code> .
         *                          You can specify up to four public domain names for a container service. The domain names that you specify are used when you create a deployment with a container that is configured as the public endpoint of your container service.
         *                          <p>
         *                          If you don't specify public domain names, then you can use the default domain of the container service.
         *                          <p>
         *                          <blockquote>
         *                          <p>
         *                          You must create and validate an SSL/TLS certificate before you can use public domain names with your container service. Use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lightsail-certificate.html">AWS::Lightsail::Certificate</a> resource to create a certificate for the public domain names that you want to use with your container service.
         *                          <p>
         *                          </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicDomainNames(java.util.List<? extends java.lang.Object> publicDomainNames) {
            this.publicDomainNames = publicDomainNames;
            return this;
        }

        /**
         * Sets the value of {@link CfnContainerProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> in the <em>AWS CloudFormation User Guide</em> .
         *             <p>
         *             <blockquote>
         *             <p>
         *             The <code>Value</code> of <code>Tags</code> is optional for Lightsail resources.
         *             <p>
         *             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnContainerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnContainerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnContainerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnContainerProps {
        private final java.lang.String power;
        private final java.lang.Number scale;
        private final java.lang.String serviceName;
        private final java.lang.Object containerServiceDeployment;
        private final java.lang.Object isDisabled;
        private final java.lang.Object privateRegistryAccess;
        private final java.lang.Object publicDomainNames;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.power = software.amazon.jsii.Kernel.get(this, "power", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scale = software.amazon.jsii.Kernel.get(this, "scale", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.serviceName = software.amazon.jsii.Kernel.get(this, "serviceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.containerServiceDeployment = software.amazon.jsii.Kernel.get(this, "containerServiceDeployment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.isDisabled = software.amazon.jsii.Kernel.get(this, "isDisabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.privateRegistryAccess = software.amazon.jsii.Kernel.get(this, "privateRegistryAccess", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.publicDomainNames = software.amazon.jsii.Kernel.get(this, "publicDomainNames", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.power = java.util.Objects.requireNonNull(builder.power, "power is required");
            this.scale = java.util.Objects.requireNonNull(builder.scale, "scale is required");
            this.serviceName = java.util.Objects.requireNonNull(builder.serviceName, "serviceName is required");
            this.containerServiceDeployment = builder.containerServiceDeployment;
            this.isDisabled = builder.isDisabled;
            this.privateRegistryAccess = builder.privateRegistryAccess;
            this.publicDomainNames = builder.publicDomainNames;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getPower() {
            return this.power;
        }

        @Override
        public final java.lang.Number getScale() {
            return this.scale;
        }

        @Override
        public final java.lang.String getServiceName() {
            return this.serviceName;
        }

        @Override
        public final java.lang.Object getContainerServiceDeployment() {
            return this.containerServiceDeployment;
        }

        @Override
        public final java.lang.Object getIsDisabled() {
            return this.isDisabled;
        }

        @Override
        public final java.lang.Object getPrivateRegistryAccess() {
            return this.privateRegistryAccess;
        }

        @Override
        public final java.lang.Object getPublicDomainNames() {
            return this.publicDomainNames;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("power", om.valueToTree(this.getPower()));
            data.set("scale", om.valueToTree(this.getScale()));
            data.set("serviceName", om.valueToTree(this.getServiceName()));
            if (this.getContainerServiceDeployment() != null) {
                data.set("containerServiceDeployment", om.valueToTree(this.getContainerServiceDeployment()));
            }
            if (this.getIsDisabled() != null) {
                data.set("isDisabled", om.valueToTree(this.getIsDisabled()));
            }
            if (this.getPrivateRegistryAccess() != null) {
                data.set("privateRegistryAccess", om.valueToTree(this.getPrivateRegistryAccess()));
            }
            if (this.getPublicDomainNames() != null) {
                data.set("publicDomainNames", om.valueToTree(this.getPublicDomainNames()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lightsail.CfnContainerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnContainerProps.Jsii$Proxy that = (CfnContainerProps.Jsii$Proxy) o;

            if (!power.equals(that.power)) return false;
            if (!scale.equals(that.scale)) return false;
            if (!serviceName.equals(that.serviceName)) return false;
            if (this.containerServiceDeployment != null ? !this.containerServiceDeployment.equals(that.containerServiceDeployment) : that.containerServiceDeployment != null) return false;
            if (this.isDisabled != null ? !this.isDisabled.equals(that.isDisabled) : that.isDisabled != null) return false;
            if (this.privateRegistryAccess != null ? !this.privateRegistryAccess.equals(that.privateRegistryAccess) : that.privateRegistryAccess != null) return false;
            if (this.publicDomainNames != null ? !this.publicDomainNames.equals(that.publicDomainNames) : that.publicDomainNames != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.power.hashCode();
            result = 31 * result + (this.scale.hashCode());
            result = 31 * result + (this.serviceName.hashCode());
            result = 31 * result + (this.containerServiceDeployment != null ? this.containerServiceDeployment.hashCode() : 0);
            result = 31 * result + (this.isDisabled != null ? this.isDisabled.hashCode() : 0);
            result = 31 * result + (this.privateRegistryAccess != null ? this.privateRegistryAccess.hashCode() : 0);
            result = 31 * result + (this.publicDomainNames != null ? this.publicDomainNames.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
