package software.amazon.awscdk.services.logs;

/**
 * Creates or updates a <em>log transformer</em> for a single log group.
 * <p>
 * You use log transformers to transform log events into a different format, making them easier for you to process and analyze. You can also transform logs from different sources into standardized formats that contains relevant, source-specific information.
 * <p>
 * After you have created a transformer, CloudWatch Logs performs the transformations at the time of log ingestion. You can then refer to the transformed versions of the logs during operations such as querying with CloudWatch Logs Insights or creating metric filters or subscription filers.
 * <p>
 * You can also use a transformer to copy metadata from metadata keys into the log events themselves. This metadata can include log group name, log stream name, account ID and Region.
 * <p>
 * A transformer for a log group is a series of processors, where each processor applies one type of transformation to the log events ingested into this log group. The processors work one after another, in the order that you list them, like a pipeline. For more information about the available processors to use in a transformer, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-Processors">Processors that you can use</a> .
 * <p>
 * Having log events in standardized format enables visibility across your applications for your log analysis, reporting, and alarming needs. CloudWatch Logs provides transformation for common log types with out-of-the-box transformation templates for major AWS log sources such as VPC flow logs, Lambda, and Amazon RDS. You can use pre-built transformation templates or create custom transformation policies.
 * <p>
 * You can create transformers only for the log groups in the Standard log class.
 * <p>
 * You can also set up a transformer at the account level. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutAccountPolicy.html">PutAccountPolicy</a> . If there is both a log-group level transformer created with <code>PutTransformer</code> and an account-level transformer that could apply to the same log group, the log group uses only the log-group level transformer. It ignores the account-level transformer.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.logs.*;
 * CfnTransformer cfnTransformer = CfnTransformer.Builder.create(this, "MyCfnTransformer")
 *         .logGroupIdentifier("logGroupIdentifier")
 *         .transformerConfig(List.of(ProcessorProperty.builder()
 *                 .addKeys(AddKeysProperty.builder()
 *                         .entries(List.of(AddKeyEntryProperty.builder()
 *                                 .key("key")
 *                                 .value("value")
 *                                 // the properties below are optional
 *                                 .overwriteIfExists(false)
 *                                 .build()))
 *                         .build())
 *                 .copyValue(CopyValueProperty.builder()
 *                         .entries(List.of(CopyValueEntryProperty.builder()
 *                                 .source("source")
 *                                 .target("target")
 *                                 // the properties below are optional
 *                                 .overwriteIfExists(false)
 *                                 .build()))
 *                         .build())
 *                 .csv(CsvProperty.builder()
 *                         .columns(List.of("columns"))
 *                         .delimiter("delimiter")
 *                         .quoteCharacter("quoteCharacter")
 *                         .source("source")
 *                         .build())
 *                 .dateTimeConverter(DateTimeConverterProperty.builder()
 *                         .matchPatterns(List.of("matchPatterns"))
 *                         .source("source")
 *                         .target("target")
 *                         // the properties below are optional
 *                         .locale("locale")
 *                         .sourceTimezone("sourceTimezone")
 *                         .targetFormat("targetFormat")
 *                         .targetTimezone("targetTimezone")
 *                         .build())
 *                 .deleteKeys(DeleteKeysProperty.builder()
 *                         .withKeys(List.of("withKeys"))
 *                         .build())
 *                 .grok(GrokProperty.builder()
 *                         .match("match")
 *                         // the properties below are optional
 *                         .source("source")
 *                         .build())
 *                 .listToMap(ListToMapProperty.builder()
 *                         .key("key")
 *                         .source("source")
 *                         // the properties below are optional
 *                         .flatten(false)
 *                         .flattenedElement("flattenedElement")
 *                         .target("target")
 *                         .valueKey("valueKey")
 *                         .build())
 *                 .lowerCaseString(LowerCaseStringProperty.builder()
 *                         .withKeys(List.of("withKeys"))
 *                         .build())
 *                 .moveKeys(MoveKeysProperty.builder()
 *                         .entries(List.of(MoveKeyEntryProperty.builder()
 *                                 .source("source")
 *                                 .target("target")
 *                                 // the properties below are optional
 *                                 .overwriteIfExists(false)
 *                                 .build()))
 *                         .build())
 *                 .parseCloudfront(ParseCloudfrontProperty.builder()
 *                         .source("source")
 *                         .build())
 *                 .parseJson(ParseJSONProperty.builder()
 *                         .destination("destination")
 *                         .source("source")
 *                         .build())
 *                 .parseKeyValue(ParseKeyValueProperty.builder()
 *                         .destination("destination")
 *                         .fieldDelimiter("fieldDelimiter")
 *                         .keyPrefix("keyPrefix")
 *                         .keyValueDelimiter("keyValueDelimiter")
 *                         .nonMatchValue("nonMatchValue")
 *                         .overwriteIfExists(false)
 *                         .source("source")
 *                         .build())
 *                 .parsePostgres(ParsePostgresProperty.builder()
 *                         .source("source")
 *                         .build())
 *                 .parseRoute53(ParseRoute53Property.builder()
 *                         .source("source")
 *                         .build())
 *                 .parseVpc(ParseVPCProperty.builder()
 *                         .source("source")
 *                         .build())
 *                 .parseWaf(ParseWAFProperty.builder()
 *                         .source("source")
 *                         .build())
 *                 .renameKeys(RenameKeysProperty.builder()
 *                         .entries(List.of(RenameKeyEntryProperty.builder()
 *                                 .key("key")
 *                                 .renameTo("renameTo")
 *                                 // the properties below are optional
 *                                 .overwriteIfExists(false)
 *                                 .build()))
 *                         .build())
 *                 .splitString(SplitStringProperty.builder()
 *                         .entries(List.of(SplitStringEntryProperty.builder()
 *                                 .delimiter("delimiter")
 *                                 .source("source")
 *                                 .build()))
 *                         .build())
 *                 .substituteString(SubstituteStringProperty.builder()
 *                         .entries(List.of(SubstituteStringEntryProperty.builder()
 *                                 .from("from")
 *                                 .source("source")
 *                                 .to("to")
 *                                 .build()))
 *                         .build())
 *                 .trimString(TrimStringProperty.builder()
 *                         .withKeys(List.of("withKeys"))
 *                         .build())
 *                 .typeConverter(TypeConverterProperty.builder()
 *                         .entries(List.of(TypeConverterEntryProperty.builder()
 *                                 .key("key")
 *                                 .type("type")
 *                                 .build()))
 *                         .build())
 *                 .upperCaseString(UpperCaseStringProperty.builder()
 *                         .withKeys(List.of("withKeys"))
 *                         .build())
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-transformer.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-transformer.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:25:00.977Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.CfnTransformer")
public class CfnTransformer extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnTransformer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnTransformer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.CfnTransformer.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnTransformer(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.CfnTransformerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Specify either the name or ARN of the log group to create the transformer for.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getLogGroupIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "logGroupIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specify either the name or ARN of the log group to create the transformer for.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogGroupIdentifier(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "logGroupIdentifier", java.util.Objects.requireNonNull(value, "logGroupIdentifier is required"));
    }

    /**
     * This structure is an array that contains the configuration of this log transformer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getTransformerConfig() {
        return software.amazon.jsii.Kernel.get(this, "transformerConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * This structure is an array that contains the configuration of this log transformer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTransformerConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "transformerConfig", java.util.Objects.requireNonNull(value, "transformerConfig is required"));
    }

    /**
     * This structure is an array that contains the configuration of this log transformer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTransformerConfig(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.logs.CfnTransformer.ProcessorProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.logs.CfnTransformer.ProcessorProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "transformerConfig", java.util.Objects.requireNonNull(value, "transformerConfig is required"));
    }
    /**
     * This object defines one key that will be added with the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-addKey">addKeys</a> processor.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.logs.*;
     * AddKeyEntryProperty addKeyEntryProperty = AddKeyEntryProperty.builder()
     *         .key("key")
     *         .value("value")
     *         // the properties below are optional
     *         .overwriteIfExists(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-addkeyentry.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-addkeyentry.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.CfnTransformer.AddKeyEntryProperty")
    @software.amazon.jsii.Jsii.Proxy(AddKeyEntryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AddKeyEntryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The key of the new entry to be added to the log event.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-addkeyentry.html#cfn-logs-transformer-addkeyentry-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-addkeyentry.html#cfn-logs-transformer-addkeyentry-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * The value of the new entry to be added to the log event.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-addkeyentry.html#cfn-logs-transformer-addkeyentry-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-addkeyentry.html#cfn-logs-transformer-addkeyentry-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * Specifies whether to overwrite the value if the key already exists in the log event.
         * <p>
         * If you omit this, the default is <code>false</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-addkeyentry.html#cfn-logs-transformer-addkeyentry-overwriteifexists">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-addkeyentry.html#cfn-logs-transformer-addkeyentry-overwriteifexists</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOverwriteIfExists() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AddKeyEntryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AddKeyEntryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AddKeyEntryProperty> {
            java.lang.String key;
            java.lang.String value;
            java.lang.Object overwriteIfExists;

            /**
             * Sets the value of {@link AddKeyEntryProperty#getKey}
             * @param key The key of the new entry to be added to the log event. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link AddKeyEntryProperty#getValue}
             * @param value The value of the new entry to be added to the log event. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Sets the value of {@link AddKeyEntryProperty#getOverwriteIfExists}
             * @param overwriteIfExists Specifies whether to overwrite the value if the key already exists in the log event.
             *                          If you omit this, the default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overwriteIfExists(java.lang.Boolean overwriteIfExists) {
                this.overwriteIfExists = overwriteIfExists;
                return this;
            }

            /**
             * Sets the value of {@link AddKeyEntryProperty#getOverwriteIfExists}
             * @param overwriteIfExists Specifies whether to overwrite the value if the key already exists in the log event.
             *                          If you omit this, the default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overwriteIfExists(software.amazon.awscdk.IResolvable overwriteIfExists) {
                this.overwriteIfExists = overwriteIfExists;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AddKeyEntryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AddKeyEntryProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AddKeyEntryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AddKeyEntryProperty {
            private final java.lang.String key;
            private final java.lang.String value;
            private final java.lang.Object overwriteIfExists;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.overwriteIfExists = software.amazon.jsii.Kernel.get(this, "overwriteIfExists", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
                this.overwriteIfExists = builder.overwriteIfExists;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            public final java.lang.Object getOverwriteIfExists() {
                return this.overwriteIfExists;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                data.set("value", om.valueToTree(this.getValue()));
                if (this.getOverwriteIfExists() != null) {
                    data.set("overwriteIfExists", om.valueToTree(this.getOverwriteIfExists()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.CfnTransformer.AddKeyEntryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AddKeyEntryProperty.Jsii$Proxy that = (AddKeyEntryProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                if (!value.equals(that.value)) return false;
                return this.overwriteIfExists != null ? this.overwriteIfExists.equals(that.overwriteIfExists) : that.overwriteIfExists == null;
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.value.hashCode());
                result = 31 * result + (this.overwriteIfExists != null ? this.overwriteIfExists.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * This processor adds new key-value pairs to the log event.
     * <p>
     * For more information about this processor including examples, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-addKeys">addKeys</a> in the <em>CloudWatch Logs User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.logs.*;
     * AddKeysProperty addKeysProperty = AddKeysProperty.builder()
     *         .entries(List.of(AddKeyEntryProperty.builder()
     *                 .key("key")
     *                 .value("value")
     *                 // the properties below are optional
     *                 .overwriteIfExists(false)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-addkeys.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-addkeys.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.CfnTransformer.AddKeysProperty")
    @software.amazon.jsii.Jsii.Proxy(AddKeysProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AddKeysProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An array of objects, where each object contains the information about one key to add to the log event.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-addkeys.html#cfn-logs-transformer-addkeys-entries">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-addkeys.html#cfn-logs-transformer-addkeys-entries</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEntries();

        /**
         * @return a {@link Builder} of {@link AddKeysProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AddKeysProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AddKeysProperty> {
            java.lang.Object entries;

            /**
             * Sets the value of {@link AddKeysProperty#getEntries}
             * @param entries An array of objects, where each object contains the information about one key to add to the log event. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder entries(software.amazon.awscdk.IResolvable entries) {
                this.entries = entries;
                return this;
            }

            /**
             * Sets the value of {@link AddKeysProperty#getEntries}
             * @param entries An array of objects, where each object contains the information about one key to add to the log event. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder entries(java.util.List<? extends java.lang.Object> entries) {
                this.entries = entries;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AddKeysProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AddKeysProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AddKeysProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AddKeysProperty {
            private final java.lang.Object entries;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.entries = software.amazon.jsii.Kernel.get(this, "entries", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.entries = java.util.Objects.requireNonNull(builder.entries, "entries is required");
            }

            @Override
            public final java.lang.Object getEntries() {
                return this.entries;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("entries", om.valueToTree(this.getEntries()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.CfnTransformer.AddKeysProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AddKeysProperty.Jsii$Proxy that = (AddKeysProperty.Jsii$Proxy) o;

                return this.entries.equals(that.entries);
            }

            @Override
            public final int hashCode() {
                int result = this.entries.hashCode();
                return result;
            }
        }
    }
    /**
     * This object defines one value to be copied with the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-copyValue">copyValue</a> processor.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.logs.*;
     * CopyValueEntryProperty copyValueEntryProperty = CopyValueEntryProperty.builder()
     *         .source("source")
     *         .target("target")
     *         // the properties below are optional
     *         .overwriteIfExists(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-copyvalueentry.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-copyvalueentry.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.CfnTransformer.CopyValueEntryProperty")
    @software.amazon.jsii.Jsii.Proxy(CopyValueEntryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CopyValueEntryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The key to copy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-copyvalueentry.html#cfn-logs-transformer-copyvalueentry-source">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-copyvalueentry.html#cfn-logs-transformer-copyvalueentry-source</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSource();

        /**
         * The key of the field to copy the value to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-copyvalueentry.html#cfn-logs-transformer-copyvalueentry-target">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-copyvalueentry.html#cfn-logs-transformer-copyvalueentry-target</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTarget();

        /**
         * Specifies whether to overwrite the value if the destination key already exists.
         * <p>
         * If you omit this, the default is <code>false</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-copyvalueentry.html#cfn-logs-transformer-copyvalueentry-overwriteifexists">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-copyvalueentry.html#cfn-logs-transformer-copyvalueentry-overwriteifexists</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOverwriteIfExists() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CopyValueEntryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CopyValueEntryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CopyValueEntryProperty> {
            java.lang.String source;
            java.lang.String target;
            java.lang.Object overwriteIfExists;

            /**
             * Sets the value of {@link CopyValueEntryProperty#getSource}
             * @param source The key to copy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(java.lang.String source) {
                this.source = source;
                return this;
            }

            /**
             * Sets the value of {@link CopyValueEntryProperty#getTarget}
             * @param target The key of the field to copy the value to. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder target(java.lang.String target) {
                this.target = target;
                return this;
            }

            /**
             * Sets the value of {@link CopyValueEntryProperty#getOverwriteIfExists}
             * @param overwriteIfExists Specifies whether to overwrite the value if the destination key already exists.
             *                          If you omit this, the default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overwriteIfExists(java.lang.Boolean overwriteIfExists) {
                this.overwriteIfExists = overwriteIfExists;
                return this;
            }

            /**
             * Sets the value of {@link CopyValueEntryProperty#getOverwriteIfExists}
             * @param overwriteIfExists Specifies whether to overwrite the value if the destination key already exists.
             *                          If you omit this, the default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overwriteIfExists(software.amazon.awscdk.IResolvable overwriteIfExists) {
                this.overwriteIfExists = overwriteIfExists;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CopyValueEntryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CopyValueEntryProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CopyValueEntryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CopyValueEntryProperty {
            private final java.lang.String source;
            private final java.lang.String target;
            private final java.lang.Object overwriteIfExists;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.target = software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.overwriteIfExists = software.amazon.jsii.Kernel.get(this, "overwriteIfExists", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.source = java.util.Objects.requireNonNull(builder.source, "source is required");
                this.target = java.util.Objects.requireNonNull(builder.target, "target is required");
                this.overwriteIfExists = builder.overwriteIfExists;
            }

            @Override
            public final java.lang.String getSource() {
                return this.source;
            }

            @Override
            public final java.lang.String getTarget() {
                return this.target;
            }

            @Override
            public final java.lang.Object getOverwriteIfExists() {
                return this.overwriteIfExists;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("source", om.valueToTree(this.getSource()));
                data.set("target", om.valueToTree(this.getTarget()));
                if (this.getOverwriteIfExists() != null) {
                    data.set("overwriteIfExists", om.valueToTree(this.getOverwriteIfExists()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.CfnTransformer.CopyValueEntryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CopyValueEntryProperty.Jsii$Proxy that = (CopyValueEntryProperty.Jsii$Proxy) o;

                if (!source.equals(that.source)) return false;
                if (!target.equals(that.target)) return false;
                return this.overwriteIfExists != null ? this.overwriteIfExists.equals(that.overwriteIfExists) : that.overwriteIfExists == null;
            }

            @Override
            public final int hashCode() {
                int result = this.source.hashCode();
                result = 31 * result + (this.target.hashCode());
                result = 31 * result + (this.overwriteIfExists != null ? this.overwriteIfExists.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * This processor copies values within a log event.
     * <p>
     * You can also use this processor to add metadata to log events by copying the values of the following metadata keys into the log events: <code>&#64;logGroupName</code> , <code>&#64;logGroupStream</code> , <code>&#64;accountId</code> , <code>&#64;regionName</code> .
     * <p>
     * For more information about this processor including examples, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-copyValue">copyValue</a> in the <em>CloudWatch Logs User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.logs.*;
     * CopyValueProperty copyValueProperty = CopyValueProperty.builder()
     *         .entries(List.of(CopyValueEntryProperty.builder()
     *                 .source("source")
     *                 .target("target")
     *                 // the properties below are optional
     *                 .overwriteIfExists(false)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-copyvalue.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-copyvalue.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.CfnTransformer.CopyValueProperty")
    @software.amazon.jsii.Jsii.Proxy(CopyValueProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CopyValueProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An array of <code>CopyValueEntry</code> objects, where each object contains the information about one field value to copy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-copyvalue.html#cfn-logs-transformer-copyvalue-entries">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-copyvalue.html#cfn-logs-transformer-copyvalue-entries</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEntries();

        /**
         * @return a {@link Builder} of {@link CopyValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CopyValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CopyValueProperty> {
            java.lang.Object entries;

            /**
             * Sets the value of {@link CopyValueProperty#getEntries}
             * @param entries An array of <code>CopyValueEntry</code> objects, where each object contains the information about one field value to copy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder entries(software.amazon.awscdk.IResolvable entries) {
                this.entries = entries;
                return this;
            }

            /**
             * Sets the value of {@link CopyValueProperty#getEntries}
             * @param entries An array of <code>CopyValueEntry</code> objects, where each object contains the information about one field value to copy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder entries(java.util.List<? extends java.lang.Object> entries) {
                this.entries = entries;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CopyValueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CopyValueProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CopyValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CopyValueProperty {
            private final java.lang.Object entries;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.entries = software.amazon.jsii.Kernel.get(this, "entries", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.entries = java.util.Objects.requireNonNull(builder.entries, "entries is required");
            }

            @Override
            public final java.lang.Object getEntries() {
                return this.entries;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("entries", om.valueToTree(this.getEntries()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.CfnTransformer.CopyValueProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CopyValueProperty.Jsii$Proxy that = (CopyValueProperty.Jsii$Proxy) o;

                return this.entries.equals(that.entries);
            }

            @Override
            public final int hashCode() {
                int result = this.entries.hashCode();
                return result;
            }
        }
    }
    /**
     * The <code>CSV</code> processor parses comma-separated values (CSV) from the log events into columns.
     * <p>
     * For more information about this processor including examples, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-csv">csv</a> in the <em>CloudWatch Logs User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.logs.*;
     * CsvProperty csvProperty = CsvProperty.builder()
     *         .columns(List.of("columns"))
     *         .delimiter("delimiter")
     *         .quoteCharacter("quoteCharacter")
     *         .source("source")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-csv.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-csv.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.CfnTransformer.CsvProperty")
    @software.amazon.jsii.Jsii.Proxy(CsvProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CsvProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An array of names to use for the columns in the transformed log event.
         * <p>
         * If you omit this, default column names ( <code>[column_1, column_2 ...]</code> ) are used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-csv.html#cfn-logs-transformer-csv-columns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-csv.html#cfn-logs-transformer-csv-columns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getColumns() {
            return null;
        }

        /**
         * The character used to separate each column in the original comma-separated value log event.
         * <p>
         * If you omit this, the processor looks for the comma <code>,</code> character as the delimiter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-csv.html#cfn-logs-transformer-csv-delimiter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-csv.html#cfn-logs-transformer-csv-delimiter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDelimiter() {
            return null;
        }

        /**
         * The character used used as a text qualifier for a single column of data.
         * <p>
         * If you omit this, the double quotation mark <code>"</code> character is used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-csv.html#cfn-logs-transformer-csv-quotecharacter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-csv.html#cfn-logs-transformer-csv-quotecharacter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getQuoteCharacter() {
            return null;
        }

        /**
         * The path to the field in the log event that has the comma separated values to be parsed.
         * <p>
         * If you omit this value, the whole log message is processed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-csv.html#cfn-logs-transformer-csv-source">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-csv.html#cfn-logs-transformer-csv-source</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSource() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CsvProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CsvProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CsvProperty> {
            java.util.List<java.lang.String> columns;
            java.lang.String delimiter;
            java.lang.String quoteCharacter;
            java.lang.String source;

            /**
             * Sets the value of {@link CsvProperty#getColumns}
             * @param columns An array of names to use for the columns in the transformed log event.
             *                If you omit this, default column names ( <code>[column_1, column_2 ...]</code> ) are used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder columns(java.util.List<java.lang.String> columns) {
                this.columns = columns;
                return this;
            }

            /**
             * Sets the value of {@link CsvProperty#getDelimiter}
             * @param delimiter The character used to separate each column in the original comma-separated value log event.
             *                  If you omit this, the processor looks for the comma <code>,</code> character as the delimiter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder delimiter(java.lang.String delimiter) {
                this.delimiter = delimiter;
                return this;
            }

            /**
             * Sets the value of {@link CsvProperty#getQuoteCharacter}
             * @param quoteCharacter The character used used as a text qualifier for a single column of data.
             *                       If you omit this, the double quotation mark <code>"</code> character is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder quoteCharacter(java.lang.String quoteCharacter) {
                this.quoteCharacter = quoteCharacter;
                return this;
            }

            /**
             * Sets the value of {@link CsvProperty#getSource}
             * @param source The path to the field in the log event that has the comma separated values to be parsed.
             *               If you omit this value, the whole log message is processed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(java.lang.String source) {
                this.source = source;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CsvProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CsvProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CsvProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CsvProperty {
            private final java.util.List<java.lang.String> columns;
            private final java.lang.String delimiter;
            private final java.lang.String quoteCharacter;
            private final java.lang.String source;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.columns = software.amazon.jsii.Kernel.get(this, "columns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.delimiter = software.amazon.jsii.Kernel.get(this, "delimiter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.quoteCharacter = software.amazon.jsii.Kernel.get(this, "quoteCharacter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.columns = builder.columns;
                this.delimiter = builder.delimiter;
                this.quoteCharacter = builder.quoteCharacter;
                this.source = builder.source;
            }

            @Override
            public final java.util.List<java.lang.String> getColumns() {
                return this.columns;
            }

            @Override
            public final java.lang.String getDelimiter() {
                return this.delimiter;
            }

            @Override
            public final java.lang.String getQuoteCharacter() {
                return this.quoteCharacter;
            }

            @Override
            public final java.lang.String getSource() {
                return this.source;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getColumns() != null) {
                    data.set("columns", om.valueToTree(this.getColumns()));
                }
                if (this.getDelimiter() != null) {
                    data.set("delimiter", om.valueToTree(this.getDelimiter()));
                }
                if (this.getQuoteCharacter() != null) {
                    data.set("quoteCharacter", om.valueToTree(this.getQuoteCharacter()));
                }
                if (this.getSource() != null) {
                    data.set("source", om.valueToTree(this.getSource()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.CfnTransformer.CsvProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CsvProperty.Jsii$Proxy that = (CsvProperty.Jsii$Proxy) o;

                if (this.columns != null ? !this.columns.equals(that.columns) : that.columns != null) return false;
                if (this.delimiter != null ? !this.delimiter.equals(that.delimiter) : that.delimiter != null) return false;
                if (this.quoteCharacter != null ? !this.quoteCharacter.equals(that.quoteCharacter) : that.quoteCharacter != null) return false;
                return this.source != null ? this.source.equals(that.source) : that.source == null;
            }

            @Override
            public final int hashCode() {
                int result = this.columns != null ? this.columns.hashCode() : 0;
                result = 31 * result + (this.delimiter != null ? this.delimiter.hashCode() : 0);
                result = 31 * result + (this.quoteCharacter != null ? this.quoteCharacter.hashCode() : 0);
                result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * This processor converts a datetime string into a format that you specify.
     * <p>
     * For more information about this processor including examples, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-datetimeConverter">datetimeConverter</a> in the <em>CloudWatch Logs User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.logs.*;
     * DateTimeConverterProperty dateTimeConverterProperty = DateTimeConverterProperty.builder()
     *         .matchPatterns(List.of("matchPatterns"))
     *         .source("source")
     *         .target("target")
     *         // the properties below are optional
     *         .locale("locale")
     *         .sourceTimezone("sourceTimezone")
     *         .targetFormat("targetFormat")
     *         .targetTimezone("targetTimezone")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-datetimeconverter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-datetimeconverter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.CfnTransformer.DateTimeConverterProperty")
    @software.amazon.jsii.Jsii.Proxy(DateTimeConverterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DateTimeConverterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of patterns to match against the <code>source</code> field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-datetimeconverter.html#cfn-logs-transformer-datetimeconverter-matchpatterns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-datetimeconverter.html#cfn-logs-transformer-datetimeconverter-matchpatterns</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getMatchPatterns();

        /**
         * The key to apply the date conversion to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-datetimeconverter.html#cfn-logs-transformer-datetimeconverter-source">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-datetimeconverter.html#cfn-logs-transformer-datetimeconverter-source</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSource();

        /**
         * The JSON field to store the result in.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-datetimeconverter.html#cfn-logs-transformer-datetimeconverter-target">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-datetimeconverter.html#cfn-logs-transformer-datetimeconverter-target</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTarget();

        /**
         * The locale of the source field.
         * <p>
         * If you omit this, the default of <code>locale.ROOT</code> is used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-datetimeconverter.html#cfn-logs-transformer-datetimeconverter-locale">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-datetimeconverter.html#cfn-logs-transformer-datetimeconverter-locale</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLocale() {
            return null;
        }

        /**
         * The time zone of the source field.
         * <p>
         * If you omit this, the default used is the UTC zone.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-datetimeconverter.html#cfn-logs-transformer-datetimeconverter-sourcetimezone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-datetimeconverter.html#cfn-logs-transformer-datetimeconverter-sourcetimezone</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourceTimezone() {
            return null;
        }

        /**
         * The datetime format to use for the converted data in the target field.
         * <p>
         * If you omit this, the default of <code>yyyy-MM-dd'T'HH:mm:ss.SSS'Z</code> is used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-datetimeconverter.html#cfn-logs-transformer-datetimeconverter-targetformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-datetimeconverter.html#cfn-logs-transformer-datetimeconverter-targetformat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTargetFormat() {
            return null;
        }

        /**
         * The time zone of the target field.
         * <p>
         * If you omit this, the default used is the UTC zone.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-datetimeconverter.html#cfn-logs-transformer-datetimeconverter-targettimezone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-datetimeconverter.html#cfn-logs-transformer-datetimeconverter-targettimezone</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTargetTimezone() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DateTimeConverterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DateTimeConverterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DateTimeConverterProperty> {
            java.util.List<java.lang.String> matchPatterns;
            java.lang.String source;
            java.lang.String target;
            java.lang.String locale;
            java.lang.String sourceTimezone;
            java.lang.String targetFormat;
            java.lang.String targetTimezone;

            /**
             * Sets the value of {@link DateTimeConverterProperty#getMatchPatterns}
             * @param matchPatterns A list of patterns to match against the <code>source</code> field. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchPatterns(java.util.List<java.lang.String> matchPatterns) {
                this.matchPatterns = matchPatterns;
                return this;
            }

            /**
             * Sets the value of {@link DateTimeConverterProperty#getSource}
             * @param source The key to apply the date conversion to. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(java.lang.String source) {
                this.source = source;
                return this;
            }

            /**
             * Sets the value of {@link DateTimeConverterProperty#getTarget}
             * @param target The JSON field to store the result in. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder target(java.lang.String target) {
                this.target = target;
                return this;
            }

            /**
             * Sets the value of {@link DateTimeConverterProperty#getLocale}
             * @param locale The locale of the source field.
             *               If you omit this, the default of <code>locale.ROOT</code> is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder locale(java.lang.String locale) {
                this.locale = locale;
                return this;
            }

            /**
             * Sets the value of {@link DateTimeConverterProperty#getSourceTimezone}
             * @param sourceTimezone The time zone of the source field.
             *                       If you omit this, the default used is the UTC zone.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceTimezone(java.lang.String sourceTimezone) {
                this.sourceTimezone = sourceTimezone;
                return this;
            }

            /**
             * Sets the value of {@link DateTimeConverterProperty#getTargetFormat}
             * @param targetFormat The datetime format to use for the converted data in the target field.
             *                     If you omit this, the default of <code>yyyy-MM-dd'T'HH:mm:ss.SSS'Z</code> is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetFormat(java.lang.String targetFormat) {
                this.targetFormat = targetFormat;
                return this;
            }

            /**
             * Sets the value of {@link DateTimeConverterProperty#getTargetTimezone}
             * @param targetTimezone The time zone of the target field.
             *                       If you omit this, the default used is the UTC zone.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetTimezone(java.lang.String targetTimezone) {
                this.targetTimezone = targetTimezone;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DateTimeConverterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DateTimeConverterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DateTimeConverterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DateTimeConverterProperty {
            private final java.util.List<java.lang.String> matchPatterns;
            private final java.lang.String source;
            private final java.lang.String target;
            private final java.lang.String locale;
            private final java.lang.String sourceTimezone;
            private final java.lang.String targetFormat;
            private final java.lang.String targetTimezone;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.matchPatterns = software.amazon.jsii.Kernel.get(this, "matchPatterns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.target = software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.locale = software.amazon.jsii.Kernel.get(this, "locale", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sourceTimezone = software.amazon.jsii.Kernel.get(this, "sourceTimezone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetFormat = software.amazon.jsii.Kernel.get(this, "targetFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetTimezone = software.amazon.jsii.Kernel.get(this, "targetTimezone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.matchPatterns = java.util.Objects.requireNonNull(builder.matchPatterns, "matchPatterns is required");
                this.source = java.util.Objects.requireNonNull(builder.source, "source is required");
                this.target = java.util.Objects.requireNonNull(builder.target, "target is required");
                this.locale = builder.locale;
                this.sourceTimezone = builder.sourceTimezone;
                this.targetFormat = builder.targetFormat;
                this.targetTimezone = builder.targetTimezone;
            }

            @Override
            public final java.util.List<java.lang.String> getMatchPatterns() {
                return this.matchPatterns;
            }

            @Override
            public final java.lang.String getSource() {
                return this.source;
            }

            @Override
            public final java.lang.String getTarget() {
                return this.target;
            }

            @Override
            public final java.lang.String getLocale() {
                return this.locale;
            }

            @Override
            public final java.lang.String getSourceTimezone() {
                return this.sourceTimezone;
            }

            @Override
            public final java.lang.String getTargetFormat() {
                return this.targetFormat;
            }

            @Override
            public final java.lang.String getTargetTimezone() {
                return this.targetTimezone;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("matchPatterns", om.valueToTree(this.getMatchPatterns()));
                data.set("source", om.valueToTree(this.getSource()));
                data.set("target", om.valueToTree(this.getTarget()));
                if (this.getLocale() != null) {
                    data.set("locale", om.valueToTree(this.getLocale()));
                }
                if (this.getSourceTimezone() != null) {
                    data.set("sourceTimezone", om.valueToTree(this.getSourceTimezone()));
                }
                if (this.getTargetFormat() != null) {
                    data.set("targetFormat", om.valueToTree(this.getTargetFormat()));
                }
                if (this.getTargetTimezone() != null) {
                    data.set("targetTimezone", om.valueToTree(this.getTargetTimezone()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.CfnTransformer.DateTimeConverterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DateTimeConverterProperty.Jsii$Proxy that = (DateTimeConverterProperty.Jsii$Proxy) o;

                if (!matchPatterns.equals(that.matchPatterns)) return false;
                if (!source.equals(that.source)) return false;
                if (!target.equals(that.target)) return false;
                if (this.locale != null ? !this.locale.equals(that.locale) : that.locale != null) return false;
                if (this.sourceTimezone != null ? !this.sourceTimezone.equals(that.sourceTimezone) : that.sourceTimezone != null) return false;
                if (this.targetFormat != null ? !this.targetFormat.equals(that.targetFormat) : that.targetFormat != null) return false;
                return this.targetTimezone != null ? this.targetTimezone.equals(that.targetTimezone) : that.targetTimezone == null;
            }

            @Override
            public final int hashCode() {
                int result = this.matchPatterns.hashCode();
                result = 31 * result + (this.source.hashCode());
                result = 31 * result + (this.target.hashCode());
                result = 31 * result + (this.locale != null ? this.locale.hashCode() : 0);
                result = 31 * result + (this.sourceTimezone != null ? this.sourceTimezone.hashCode() : 0);
                result = 31 * result + (this.targetFormat != null ? this.targetFormat.hashCode() : 0);
                result = 31 * result + (this.targetTimezone != null ? this.targetTimezone.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * This processor deletes entries from a log event. These entries are key-value pairs.
     * <p>
     * For more information about this processor including examples, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-deleteKeys">deleteKeys</a> in the <em>CloudWatch Logs User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.logs.*;
     * DeleteKeysProperty deleteKeysProperty = DeleteKeysProperty.builder()
     *         .withKeys(List.of("withKeys"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-deletekeys.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-deletekeys.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.CfnTransformer.DeleteKeysProperty")
    @software.amazon.jsii.Jsii.Proxy(DeleteKeysProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeleteKeysProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The list of keys to delete.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-deletekeys.html#cfn-logs-transformer-deletekeys-withkeys">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-deletekeys.html#cfn-logs-transformer-deletekeys-withkeys</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getWithKeys();

        /**
         * @return a {@link Builder} of {@link DeleteKeysProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeleteKeysProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeleteKeysProperty> {
            java.util.List<java.lang.String> withKeys;

            /**
             * Sets the value of {@link DeleteKeysProperty#getWithKeys}
             * @param withKeys The list of keys to delete. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withKeys(java.util.List<java.lang.String> withKeys) {
                this.withKeys = withKeys;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeleteKeysProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeleteKeysProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeleteKeysProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeleteKeysProperty {
            private final java.util.List<java.lang.String> withKeys;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.withKeys = software.amazon.jsii.Kernel.get(this, "withKeys", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.withKeys = java.util.Objects.requireNonNull(builder.withKeys, "withKeys is required");
            }

            @Override
            public final java.util.List<java.lang.String> getWithKeys() {
                return this.withKeys;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("withKeys", om.valueToTree(this.getWithKeys()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.CfnTransformer.DeleteKeysProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeleteKeysProperty.Jsii$Proxy that = (DeleteKeysProperty.Jsii$Proxy) o;

                return this.withKeys.equals(that.withKeys);
            }

            @Override
            public final int hashCode() {
                int result = this.withKeys.hashCode();
                return result;
            }
        }
    }
    /**
     * This processor uses pattern matching to parse and structure unstructured data.
     * <p>
     * This processor can also extract fields from log messages.
     * <p>
     * For more information about this processor including examples, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-Grok">grok</a> in the <em>CloudWatch Logs User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.logs.*;
     * GrokProperty grokProperty = GrokProperty.builder()
     *         .match("match")
     *         // the properties below are optional
     *         .source("source")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-grok.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-grok.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.CfnTransformer.GrokProperty")
    @software.amazon.jsii.Jsii.Proxy(GrokProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GrokProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The grok pattern to match against the log event.
         * <p>
         * For a list of supported grok patterns, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#Grok-Patterns">Supported grok patterns</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-grok.html#cfn-logs-transformer-grok-match">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-grok.html#cfn-logs-transformer-grok-match</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMatch();

        /**
         * The path to the field in the log event that you want to parse.
         * <p>
         * If you omit this value, the whole log message is parsed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-grok.html#cfn-logs-transformer-grok-source">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-grok.html#cfn-logs-transformer-grok-source</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSource() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GrokProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GrokProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GrokProperty> {
            java.lang.String match;
            java.lang.String source;

            /**
             * Sets the value of {@link GrokProperty#getMatch}
             * @param match The grok pattern to match against the log event. This parameter is required.
             *              For a list of supported grok patterns, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#Grok-Patterns">Supported grok patterns</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder match(java.lang.String match) {
                this.match = match;
                return this;
            }

            /**
             * Sets the value of {@link GrokProperty#getSource}
             * @param source The path to the field in the log event that you want to parse.
             *               If you omit this value, the whole log message is parsed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(java.lang.String source) {
                this.source = source;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GrokProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GrokProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GrokProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GrokProperty {
            private final java.lang.String match;
            private final java.lang.String source;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.match = software.amazon.jsii.Kernel.get(this, "match", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.match = java.util.Objects.requireNonNull(builder.match, "match is required");
                this.source = builder.source;
            }

            @Override
            public final java.lang.String getMatch() {
                return this.match;
            }

            @Override
            public final java.lang.String getSource() {
                return this.source;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("match", om.valueToTree(this.getMatch()));
                if (this.getSource() != null) {
                    data.set("source", om.valueToTree(this.getSource()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.CfnTransformer.GrokProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GrokProperty.Jsii$Proxy that = (GrokProperty.Jsii$Proxy) o;

                if (!match.equals(that.match)) return false;
                return this.source != null ? this.source.equals(that.source) : that.source == null;
            }

            @Override
            public final int hashCode() {
                int result = this.match.hashCode();
                result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * This processor takes a list of objects that contain key fields, and converts them into a map of target keys.
     * <p>
     * For more information about this processor including examples, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-listToMap">listToMap</a> in the <em>CloudWatch Logs User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.logs.*;
     * ListToMapProperty listToMapProperty = ListToMapProperty.builder()
     *         .key("key")
     *         .source("source")
     *         // the properties below are optional
     *         .flatten(false)
     *         .flattenedElement("flattenedElement")
     *         .target("target")
     *         .valueKey("valueKey")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-listtomap.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-listtomap.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.CfnTransformer.ListToMapProperty")
    @software.amazon.jsii.Jsii.Proxy(ListToMapProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ListToMapProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The key of the field to be extracted as keys in the generated map.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-listtomap.html#cfn-logs-transformer-listtomap-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-listtomap.html#cfn-logs-transformer-listtomap-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * The key in the log event that has a list of objects that will be converted to a map.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-listtomap.html#cfn-logs-transformer-listtomap-source">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-listtomap.html#cfn-logs-transformer-listtomap-source</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSource();

        /**
         * A Boolean value to indicate whether the list will be flattened into single items.
         * <p>
         * Specify <code>true</code> to flatten the list. The default is <code>false</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-listtomap.html#cfn-logs-transformer-listtomap-flatten">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-listtomap.html#cfn-logs-transformer-listtomap-flatten</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFlatten() {
            return null;
        }

        /**
         * If you set <code>flatten</code> to <code>true</code> , use <code>flattenedElement</code> to specify which element, <code>first</code> or <code>last</code> , to keep.
         * <p>
         * You must specify this parameter if <code>flatten</code> is <code>true</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-listtomap.html#cfn-logs-transformer-listtomap-flattenedelement">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-listtomap.html#cfn-logs-transformer-listtomap-flattenedelement</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFlattenedElement() {
            return null;
        }

        /**
         * The key of the field that will hold the generated map.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-listtomap.html#cfn-logs-transformer-listtomap-target">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-listtomap.html#cfn-logs-transformer-listtomap-target</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTarget() {
            return null;
        }

        /**
         * If this is specified, the values that you specify in this parameter will be extracted from the <code>source</code> objects and put into the values of the generated map.
         * <p>
         * Otherwise, original objects in the source list will be put into the values of the generated map.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-listtomap.html#cfn-logs-transformer-listtomap-valuekey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-listtomap.html#cfn-logs-transformer-listtomap-valuekey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValueKey() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ListToMapProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ListToMapProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ListToMapProperty> {
            java.lang.String key;
            java.lang.String source;
            java.lang.Object flatten;
            java.lang.String flattenedElement;
            java.lang.String target;
            java.lang.String valueKey;

            /**
             * Sets the value of {@link ListToMapProperty#getKey}
             * @param key The key of the field to be extracted as keys in the generated map. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link ListToMapProperty#getSource}
             * @param source The key in the log event that has a list of objects that will be converted to a map. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(java.lang.String source) {
                this.source = source;
                return this;
            }

            /**
             * Sets the value of {@link ListToMapProperty#getFlatten}
             * @param flatten A Boolean value to indicate whether the list will be flattened into single items.
             *                Specify <code>true</code> to flatten the list. The default is <code>false</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder flatten(java.lang.Boolean flatten) {
                this.flatten = flatten;
                return this;
            }

            /**
             * Sets the value of {@link ListToMapProperty#getFlatten}
             * @param flatten A Boolean value to indicate whether the list will be flattened into single items.
             *                Specify <code>true</code> to flatten the list. The default is <code>false</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder flatten(software.amazon.awscdk.IResolvable flatten) {
                this.flatten = flatten;
                return this;
            }

            /**
             * Sets the value of {@link ListToMapProperty#getFlattenedElement}
             * @param flattenedElement If you set <code>flatten</code> to <code>true</code> , use <code>flattenedElement</code> to specify which element, <code>first</code> or <code>last</code> , to keep.
             *                         You must specify this parameter if <code>flatten</code> is <code>true</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder flattenedElement(java.lang.String flattenedElement) {
                this.flattenedElement = flattenedElement;
                return this;
            }

            /**
             * Sets the value of {@link ListToMapProperty#getTarget}
             * @param target The key of the field that will hold the generated map.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder target(java.lang.String target) {
                this.target = target;
                return this;
            }

            /**
             * Sets the value of {@link ListToMapProperty#getValueKey}
             * @param valueKey If this is specified, the values that you specify in this parameter will be extracted from the <code>source</code> objects and put into the values of the generated map.
             *                 Otherwise, original objects in the source list will be put into the values of the generated map.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder valueKey(java.lang.String valueKey) {
                this.valueKey = valueKey;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ListToMapProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ListToMapProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ListToMapProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ListToMapProperty {
            private final java.lang.String key;
            private final java.lang.String source;
            private final java.lang.Object flatten;
            private final java.lang.String flattenedElement;
            private final java.lang.String target;
            private final java.lang.String valueKey;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.flatten = software.amazon.jsii.Kernel.get(this, "flatten", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.flattenedElement = software.amazon.jsii.Kernel.get(this, "flattenedElement", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.target = software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.valueKey = software.amazon.jsii.Kernel.get(this, "valueKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.source = java.util.Objects.requireNonNull(builder.source, "source is required");
                this.flatten = builder.flatten;
                this.flattenedElement = builder.flattenedElement;
                this.target = builder.target;
                this.valueKey = builder.valueKey;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getSource() {
                return this.source;
            }

            @Override
            public final java.lang.Object getFlatten() {
                return this.flatten;
            }

            @Override
            public final java.lang.String getFlattenedElement() {
                return this.flattenedElement;
            }

            @Override
            public final java.lang.String getTarget() {
                return this.target;
            }

            @Override
            public final java.lang.String getValueKey() {
                return this.valueKey;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                data.set("source", om.valueToTree(this.getSource()));
                if (this.getFlatten() != null) {
                    data.set("flatten", om.valueToTree(this.getFlatten()));
                }
                if (this.getFlattenedElement() != null) {
                    data.set("flattenedElement", om.valueToTree(this.getFlattenedElement()));
                }
                if (this.getTarget() != null) {
                    data.set("target", om.valueToTree(this.getTarget()));
                }
                if (this.getValueKey() != null) {
                    data.set("valueKey", om.valueToTree(this.getValueKey()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.CfnTransformer.ListToMapProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ListToMapProperty.Jsii$Proxy that = (ListToMapProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                if (!source.equals(that.source)) return false;
                if (this.flatten != null ? !this.flatten.equals(that.flatten) : that.flatten != null) return false;
                if (this.flattenedElement != null ? !this.flattenedElement.equals(that.flattenedElement) : that.flattenedElement != null) return false;
                if (this.target != null ? !this.target.equals(that.target) : that.target != null) return false;
                return this.valueKey != null ? this.valueKey.equals(that.valueKey) : that.valueKey == null;
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.source.hashCode());
                result = 31 * result + (this.flatten != null ? this.flatten.hashCode() : 0);
                result = 31 * result + (this.flattenedElement != null ? this.flattenedElement.hashCode() : 0);
                result = 31 * result + (this.target != null ? this.target.hashCode() : 0);
                result = 31 * result + (this.valueKey != null ? this.valueKey.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * This processor converts a string to lowercase.
     * <p>
     * For more information about this processor including examples, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-lowerCaseString">lowerCaseString</a> in the <em>CloudWatch Logs User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.logs.*;
     * LowerCaseStringProperty lowerCaseStringProperty = LowerCaseStringProperty.builder()
     *         .withKeys(List.of("withKeys"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-lowercasestring.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-lowercasestring.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.CfnTransformer.LowerCaseStringProperty")
    @software.amazon.jsii.Jsii.Proxy(LowerCaseStringProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LowerCaseStringProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The array caontaining the keys of the fields to convert to lowercase.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-lowercasestring.html#cfn-logs-transformer-lowercasestring-withkeys">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-lowercasestring.html#cfn-logs-transformer-lowercasestring-withkeys</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getWithKeys();

        /**
         * @return a {@link Builder} of {@link LowerCaseStringProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LowerCaseStringProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LowerCaseStringProperty> {
            java.util.List<java.lang.String> withKeys;

            /**
             * Sets the value of {@link LowerCaseStringProperty#getWithKeys}
             * @param withKeys The array caontaining the keys of the fields to convert to lowercase. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withKeys(java.util.List<java.lang.String> withKeys) {
                this.withKeys = withKeys;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LowerCaseStringProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LowerCaseStringProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LowerCaseStringProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LowerCaseStringProperty {
            private final java.util.List<java.lang.String> withKeys;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.withKeys = software.amazon.jsii.Kernel.get(this, "withKeys", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.withKeys = java.util.Objects.requireNonNull(builder.withKeys, "withKeys is required");
            }

            @Override
            public final java.util.List<java.lang.String> getWithKeys() {
                return this.withKeys;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("withKeys", om.valueToTree(this.getWithKeys()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.CfnTransformer.LowerCaseStringProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LowerCaseStringProperty.Jsii$Proxy that = (LowerCaseStringProperty.Jsii$Proxy) o;

                return this.withKeys.equals(that.withKeys);
            }

            @Override
            public final int hashCode() {
                int result = this.withKeys.hashCode();
                return result;
            }
        }
    }
    /**
     * This object defines one key that will be moved with the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-moveKey">moveKey</a> processor.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.logs.*;
     * MoveKeyEntryProperty moveKeyEntryProperty = MoveKeyEntryProperty.builder()
     *         .source("source")
     *         .target("target")
     *         // the properties below are optional
     *         .overwriteIfExists(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-movekeyentry.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-movekeyentry.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.CfnTransformer.MoveKeyEntryProperty")
    @software.amazon.jsii.Jsii.Proxy(MoveKeyEntryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MoveKeyEntryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The key to move.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-movekeyentry.html#cfn-logs-transformer-movekeyentry-source">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-movekeyentry.html#cfn-logs-transformer-movekeyentry-source</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSource();

        /**
         * The key to move to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-movekeyentry.html#cfn-logs-transformer-movekeyentry-target">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-movekeyentry.html#cfn-logs-transformer-movekeyentry-target</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTarget();

        /**
         * Specifies whether to overwrite the value if the destination key already exists.
         * <p>
         * If you omit this, the default is <code>false</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-movekeyentry.html#cfn-logs-transformer-movekeyentry-overwriteifexists">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-movekeyentry.html#cfn-logs-transformer-movekeyentry-overwriteifexists</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOverwriteIfExists() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MoveKeyEntryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MoveKeyEntryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MoveKeyEntryProperty> {
            java.lang.String source;
            java.lang.String target;
            java.lang.Object overwriteIfExists;

            /**
             * Sets the value of {@link MoveKeyEntryProperty#getSource}
             * @param source The key to move. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(java.lang.String source) {
                this.source = source;
                return this;
            }

            /**
             * Sets the value of {@link MoveKeyEntryProperty#getTarget}
             * @param target The key to move to. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder target(java.lang.String target) {
                this.target = target;
                return this;
            }

            /**
             * Sets the value of {@link MoveKeyEntryProperty#getOverwriteIfExists}
             * @param overwriteIfExists Specifies whether to overwrite the value if the destination key already exists.
             *                          If you omit this, the default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overwriteIfExists(java.lang.Boolean overwriteIfExists) {
                this.overwriteIfExists = overwriteIfExists;
                return this;
            }

            /**
             * Sets the value of {@link MoveKeyEntryProperty#getOverwriteIfExists}
             * @param overwriteIfExists Specifies whether to overwrite the value if the destination key already exists.
             *                          If you omit this, the default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overwriteIfExists(software.amazon.awscdk.IResolvable overwriteIfExists) {
                this.overwriteIfExists = overwriteIfExists;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MoveKeyEntryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MoveKeyEntryProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MoveKeyEntryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MoveKeyEntryProperty {
            private final java.lang.String source;
            private final java.lang.String target;
            private final java.lang.Object overwriteIfExists;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.target = software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.overwriteIfExists = software.amazon.jsii.Kernel.get(this, "overwriteIfExists", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.source = java.util.Objects.requireNonNull(builder.source, "source is required");
                this.target = java.util.Objects.requireNonNull(builder.target, "target is required");
                this.overwriteIfExists = builder.overwriteIfExists;
            }

            @Override
            public final java.lang.String getSource() {
                return this.source;
            }

            @Override
            public final java.lang.String getTarget() {
                return this.target;
            }

            @Override
            public final java.lang.Object getOverwriteIfExists() {
                return this.overwriteIfExists;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("source", om.valueToTree(this.getSource()));
                data.set("target", om.valueToTree(this.getTarget()));
                if (this.getOverwriteIfExists() != null) {
                    data.set("overwriteIfExists", om.valueToTree(this.getOverwriteIfExists()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.CfnTransformer.MoveKeyEntryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MoveKeyEntryProperty.Jsii$Proxy that = (MoveKeyEntryProperty.Jsii$Proxy) o;

                if (!source.equals(that.source)) return false;
                if (!target.equals(that.target)) return false;
                return this.overwriteIfExists != null ? this.overwriteIfExists.equals(that.overwriteIfExists) : that.overwriteIfExists == null;
            }

            @Override
            public final int hashCode() {
                int result = this.source.hashCode();
                result = 31 * result + (this.target.hashCode());
                result = 31 * result + (this.overwriteIfExists != null ? this.overwriteIfExists.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * This processor moves a key from one field to another. The original key is deleted.
     * <p>
     * For more information about this processor including examples, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-moveKeys">moveKeys</a> in the <em>CloudWatch Logs User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.logs.*;
     * MoveKeysProperty moveKeysProperty = MoveKeysProperty.builder()
     *         .entries(List.of(MoveKeyEntryProperty.builder()
     *                 .source("source")
     *                 .target("target")
     *                 // the properties below are optional
     *                 .overwriteIfExists(false)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-movekeys.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-movekeys.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.CfnTransformer.MoveKeysProperty")
    @software.amazon.jsii.Jsii.Proxy(MoveKeysProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MoveKeysProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An array of objects, where each object contains the information about one key to move.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-movekeys.html#cfn-logs-transformer-movekeys-entries">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-movekeys.html#cfn-logs-transformer-movekeys-entries</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEntries();

        /**
         * @return a {@link Builder} of {@link MoveKeysProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MoveKeysProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MoveKeysProperty> {
            java.lang.Object entries;

            /**
             * Sets the value of {@link MoveKeysProperty#getEntries}
             * @param entries An array of objects, where each object contains the information about one key to move. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder entries(software.amazon.awscdk.IResolvable entries) {
                this.entries = entries;
                return this;
            }

            /**
             * Sets the value of {@link MoveKeysProperty#getEntries}
             * @param entries An array of objects, where each object contains the information about one key to move. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder entries(java.util.List<? extends java.lang.Object> entries) {
                this.entries = entries;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MoveKeysProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MoveKeysProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MoveKeysProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MoveKeysProperty {
            private final java.lang.Object entries;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.entries = software.amazon.jsii.Kernel.get(this, "entries", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.entries = java.util.Objects.requireNonNull(builder.entries, "entries is required");
            }

            @Override
            public final java.lang.Object getEntries() {
                return this.entries;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("entries", om.valueToTree(this.getEntries()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.CfnTransformer.MoveKeysProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MoveKeysProperty.Jsii$Proxy that = (MoveKeysProperty.Jsii$Proxy) o;

                return this.entries.equals(that.entries);
            }

            @Override
            public final int hashCode() {
                int result = this.entries.hashCode();
                return result;
            }
        }
    }
    /**
     * This processor parses CloudFront vended logs, extract fields, and convert them into JSON format.
     * <p>
     * Encoded field values are decoded. Values that are integers and doubles are treated as such. For more information about this processor including examples, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-parseCloudfront">parseCloudfront</a>
     * <p>
     * For more information about CloudFront log format, see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/AccessLogs.html">Configure and use standard logs (access logs)</a> .
     * <p>
     * If you use this processor, it must be the first processor in your transformer.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.logs.*;
     * ParseCloudfrontProperty parseCloudfrontProperty = ParseCloudfrontProperty.builder()
     *         .source("source")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-parsecloudfront.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-parsecloudfront.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.CfnTransformer.ParseCloudfrontProperty")
    @software.amazon.jsii.Jsii.Proxy(ParseCloudfrontProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ParseCloudfrontProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Omit this parameter and the whole log message will be processed by this processor.
         * <p>
         * No other value than <code>&#64;message</code> is allowed for <code>source</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-parsecloudfront.html#cfn-logs-transformer-parsecloudfront-source">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-parsecloudfront.html#cfn-logs-transformer-parsecloudfront-source</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSource() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ParseCloudfrontProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ParseCloudfrontProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ParseCloudfrontProperty> {
            java.lang.String source;

            /**
             * Sets the value of {@link ParseCloudfrontProperty#getSource}
             * @param source Omit this parameter and the whole log message will be processed by this processor.
             *               No other value than <code>&#64;message</code> is allowed for <code>source</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(java.lang.String source) {
                this.source = source;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ParseCloudfrontProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ParseCloudfrontProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ParseCloudfrontProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ParseCloudfrontProperty {
            private final java.lang.String source;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.source = builder.source;
            }

            @Override
            public final java.lang.String getSource() {
                return this.source;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSource() != null) {
                    data.set("source", om.valueToTree(this.getSource()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.CfnTransformer.ParseCloudfrontProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ParseCloudfrontProperty.Jsii$Proxy that = (ParseCloudfrontProperty.Jsii$Proxy) o;

                return this.source != null ? this.source.equals(that.source) : that.source == null;
            }

            @Override
            public final int hashCode() {
                int result = this.source != null ? this.source.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * This processor parses log events that are in JSON format.
     * <p>
     * It can extract JSON key-value pairs and place them under a destination that you specify.
     * <p>
     * Additionally, because you must have at least one parse-type processor in a transformer, you can use <code>ParseJSON</code> as that processor for JSON-format logs, so that you can also apply other processors, such as mutate processors, to these logs.
     * <p>
     * For more information about this processor including examples, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-parseJSON">parseJSON</a> in the <em>CloudWatch Logs User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.logs.*;
     * ParseJSONProperty parseJSONProperty = ParseJSONProperty.builder()
     *         .destination("destination")
     *         .source("source")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-parsejson.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-parsejson.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.CfnTransformer.ParseJSONProperty")
    @software.amazon.jsii.Jsii.Proxy(ParseJSONProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ParseJSONProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The location to put the parsed key value pair into.
         * <p>
         * If you omit this parameter, it is placed under the root node.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-parsejson.html#cfn-logs-transformer-parsejson-destination">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-parsejson.html#cfn-logs-transformer-parsejson-destination</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDestination() {
            return null;
        }

        /**
         * Path to the field in the log event that will be parsed.
         * <p>
         * Use dot notation to access child fields. For example, <code>store.book</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-parsejson.html#cfn-logs-transformer-parsejson-source">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-parsejson.html#cfn-logs-transformer-parsejson-source</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSource() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ParseJSONProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ParseJSONProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ParseJSONProperty> {
            java.lang.String destination;
            java.lang.String source;

            /**
             * Sets the value of {@link ParseJSONProperty#getDestination}
             * @param destination The location to put the parsed key value pair into.
             *                    If you omit this parameter, it is placed under the root node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destination(java.lang.String destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of {@link ParseJSONProperty#getSource}
             * @param source Path to the field in the log event that will be parsed.
             *               Use dot notation to access child fields. For example, <code>store.book</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(java.lang.String source) {
                this.source = source;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ParseJSONProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ParseJSONProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ParseJSONProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ParseJSONProperty {
            private final java.lang.String destination;
            private final java.lang.String source;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destination = software.amazon.jsii.Kernel.get(this, "destination", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destination = builder.destination;
                this.source = builder.source;
            }

            @Override
            public final java.lang.String getDestination() {
                return this.destination;
            }

            @Override
            public final java.lang.String getSource() {
                return this.source;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDestination() != null) {
                    data.set("destination", om.valueToTree(this.getDestination()));
                }
                if (this.getSource() != null) {
                    data.set("source", om.valueToTree(this.getSource()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.CfnTransformer.ParseJSONProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ParseJSONProperty.Jsii$Proxy that = (ParseJSONProperty.Jsii$Proxy) o;

                if (this.destination != null ? !this.destination.equals(that.destination) : that.destination != null) return false;
                return this.source != null ? this.source.equals(that.source) : that.source == null;
            }

            @Override
            public final int hashCode() {
                int result = this.destination != null ? this.destination.hashCode() : 0;
                result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * This processor parses a specified field in the original log event into key-value pairs.
     * <p>
     * For more information about this processor including examples, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-parseKeyValue">parseKeyValue</a> in the <em>CloudWatch Logs User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.logs.*;
     * ParseKeyValueProperty parseKeyValueProperty = ParseKeyValueProperty.builder()
     *         .destination("destination")
     *         .fieldDelimiter("fieldDelimiter")
     *         .keyPrefix("keyPrefix")
     *         .keyValueDelimiter("keyValueDelimiter")
     *         .nonMatchValue("nonMatchValue")
     *         .overwriteIfExists(false)
     *         .source("source")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-parsekeyvalue.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-parsekeyvalue.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.CfnTransformer.ParseKeyValueProperty")
    @software.amazon.jsii.Jsii.Proxy(ParseKeyValueProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ParseKeyValueProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The destination field to put the extracted key-value pairs into.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-parsekeyvalue.html#cfn-logs-transformer-parsekeyvalue-destination">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-parsekeyvalue.html#cfn-logs-transformer-parsekeyvalue-destination</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDestination() {
            return null;
        }

        /**
         * The field delimiter string that is used between key-value pairs in the original log events.
         * <p>
         * If you omit this, the ampersand <code>&amp;</code> character is used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-parsekeyvalue.html#cfn-logs-transformer-parsekeyvalue-fielddelimiter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-parsekeyvalue.html#cfn-logs-transformer-parsekeyvalue-fielddelimiter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFieldDelimiter() {
            return null;
        }

        /**
         * If you want to add a prefix to all transformed keys, specify it here.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-parsekeyvalue.html#cfn-logs-transformer-parsekeyvalue-keyprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-parsekeyvalue.html#cfn-logs-transformer-parsekeyvalue-keyprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKeyPrefix() {
            return null;
        }

        /**
         * The delimiter string to use between the key and value in each pair in the transformed log event.
         * <p>
         * If you omit this, the equal <code>=</code> character is used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-parsekeyvalue.html#cfn-logs-transformer-parsekeyvalue-keyvaluedelimiter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-parsekeyvalue.html#cfn-logs-transformer-parsekeyvalue-keyvaluedelimiter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKeyValueDelimiter() {
            return null;
        }

        /**
         * A value to insert into the value field in the result, when a key-value pair is not successfully split.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-parsekeyvalue.html#cfn-logs-transformer-parsekeyvalue-nonmatchvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-parsekeyvalue.html#cfn-logs-transformer-parsekeyvalue-nonmatchvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNonMatchValue() {
            return null;
        }

        /**
         * Specifies whether to overwrite the value if the destination key already exists.
         * <p>
         * If you omit this, the default is <code>false</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-parsekeyvalue.html#cfn-logs-transformer-parsekeyvalue-overwriteifexists">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-parsekeyvalue.html#cfn-logs-transformer-parsekeyvalue-overwriteifexists</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOverwriteIfExists() {
            return null;
        }

        /**
         * Path to the field in the log event that will be parsed.
         * <p>
         * Use dot notation to access child fields. For example, <code>store.book</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-parsekeyvalue.html#cfn-logs-transformer-parsekeyvalue-source">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-parsekeyvalue.html#cfn-logs-transformer-parsekeyvalue-source</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSource() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ParseKeyValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ParseKeyValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ParseKeyValueProperty> {
            java.lang.String destination;
            java.lang.String fieldDelimiter;
            java.lang.String keyPrefix;
            java.lang.String keyValueDelimiter;
            java.lang.String nonMatchValue;
            java.lang.Object overwriteIfExists;
            java.lang.String source;

            /**
             * Sets the value of {@link ParseKeyValueProperty#getDestination}
             * @param destination The destination field to put the extracted key-value pairs into.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destination(java.lang.String destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of {@link ParseKeyValueProperty#getFieldDelimiter}
             * @param fieldDelimiter The field delimiter string that is used between key-value pairs in the original log events.
             *                       If you omit this, the ampersand <code>&amp;</code> character is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldDelimiter(java.lang.String fieldDelimiter) {
                this.fieldDelimiter = fieldDelimiter;
                return this;
            }

            /**
             * Sets the value of {@link ParseKeyValueProperty#getKeyPrefix}
             * @param keyPrefix If you want to add a prefix to all transformed keys, specify it here.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyPrefix(java.lang.String keyPrefix) {
                this.keyPrefix = keyPrefix;
                return this;
            }

            /**
             * Sets the value of {@link ParseKeyValueProperty#getKeyValueDelimiter}
             * @param keyValueDelimiter The delimiter string to use between the key and value in each pair in the transformed log event.
             *                          If you omit this, the equal <code>=</code> character is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyValueDelimiter(java.lang.String keyValueDelimiter) {
                this.keyValueDelimiter = keyValueDelimiter;
                return this;
            }

            /**
             * Sets the value of {@link ParseKeyValueProperty#getNonMatchValue}
             * @param nonMatchValue A value to insert into the value field in the result, when a key-value pair is not successfully split.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nonMatchValue(java.lang.String nonMatchValue) {
                this.nonMatchValue = nonMatchValue;
                return this;
            }

            /**
             * Sets the value of {@link ParseKeyValueProperty#getOverwriteIfExists}
             * @param overwriteIfExists Specifies whether to overwrite the value if the destination key already exists.
             *                          If you omit this, the default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overwriteIfExists(java.lang.Boolean overwriteIfExists) {
                this.overwriteIfExists = overwriteIfExists;
                return this;
            }

            /**
             * Sets the value of {@link ParseKeyValueProperty#getOverwriteIfExists}
             * @param overwriteIfExists Specifies whether to overwrite the value if the destination key already exists.
             *                          If you omit this, the default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overwriteIfExists(software.amazon.awscdk.IResolvable overwriteIfExists) {
                this.overwriteIfExists = overwriteIfExists;
                return this;
            }

            /**
             * Sets the value of {@link ParseKeyValueProperty#getSource}
             * @param source Path to the field in the log event that will be parsed.
             *               Use dot notation to access child fields. For example, <code>store.book</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(java.lang.String source) {
                this.source = source;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ParseKeyValueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ParseKeyValueProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ParseKeyValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ParseKeyValueProperty {
            private final java.lang.String destination;
            private final java.lang.String fieldDelimiter;
            private final java.lang.String keyPrefix;
            private final java.lang.String keyValueDelimiter;
            private final java.lang.String nonMatchValue;
            private final java.lang.Object overwriteIfExists;
            private final java.lang.String source;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destination = software.amazon.jsii.Kernel.get(this, "destination", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fieldDelimiter = software.amazon.jsii.Kernel.get(this, "fieldDelimiter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.keyPrefix = software.amazon.jsii.Kernel.get(this, "keyPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.keyValueDelimiter = software.amazon.jsii.Kernel.get(this, "keyValueDelimiter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.nonMatchValue = software.amazon.jsii.Kernel.get(this, "nonMatchValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.overwriteIfExists = software.amazon.jsii.Kernel.get(this, "overwriteIfExists", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destination = builder.destination;
                this.fieldDelimiter = builder.fieldDelimiter;
                this.keyPrefix = builder.keyPrefix;
                this.keyValueDelimiter = builder.keyValueDelimiter;
                this.nonMatchValue = builder.nonMatchValue;
                this.overwriteIfExists = builder.overwriteIfExists;
                this.source = builder.source;
            }

            @Override
            public final java.lang.String getDestination() {
                return this.destination;
            }

            @Override
            public final java.lang.String getFieldDelimiter() {
                return this.fieldDelimiter;
            }

            @Override
            public final java.lang.String getKeyPrefix() {
                return this.keyPrefix;
            }

            @Override
            public final java.lang.String getKeyValueDelimiter() {
                return this.keyValueDelimiter;
            }

            @Override
            public final java.lang.String getNonMatchValue() {
                return this.nonMatchValue;
            }

            @Override
            public final java.lang.Object getOverwriteIfExists() {
                return this.overwriteIfExists;
            }

            @Override
            public final java.lang.String getSource() {
                return this.source;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDestination() != null) {
                    data.set("destination", om.valueToTree(this.getDestination()));
                }
                if (this.getFieldDelimiter() != null) {
                    data.set("fieldDelimiter", om.valueToTree(this.getFieldDelimiter()));
                }
                if (this.getKeyPrefix() != null) {
                    data.set("keyPrefix", om.valueToTree(this.getKeyPrefix()));
                }
                if (this.getKeyValueDelimiter() != null) {
                    data.set("keyValueDelimiter", om.valueToTree(this.getKeyValueDelimiter()));
                }
                if (this.getNonMatchValue() != null) {
                    data.set("nonMatchValue", om.valueToTree(this.getNonMatchValue()));
                }
                if (this.getOverwriteIfExists() != null) {
                    data.set("overwriteIfExists", om.valueToTree(this.getOverwriteIfExists()));
                }
                if (this.getSource() != null) {
                    data.set("source", om.valueToTree(this.getSource()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.CfnTransformer.ParseKeyValueProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ParseKeyValueProperty.Jsii$Proxy that = (ParseKeyValueProperty.Jsii$Proxy) o;

                if (this.destination != null ? !this.destination.equals(that.destination) : that.destination != null) return false;
                if (this.fieldDelimiter != null ? !this.fieldDelimiter.equals(that.fieldDelimiter) : that.fieldDelimiter != null) return false;
                if (this.keyPrefix != null ? !this.keyPrefix.equals(that.keyPrefix) : that.keyPrefix != null) return false;
                if (this.keyValueDelimiter != null ? !this.keyValueDelimiter.equals(that.keyValueDelimiter) : that.keyValueDelimiter != null) return false;
                if (this.nonMatchValue != null ? !this.nonMatchValue.equals(that.nonMatchValue) : that.nonMatchValue != null) return false;
                if (this.overwriteIfExists != null ? !this.overwriteIfExists.equals(that.overwriteIfExists) : that.overwriteIfExists != null) return false;
                return this.source != null ? this.source.equals(that.source) : that.source == null;
            }

            @Override
            public final int hashCode() {
                int result = this.destination != null ? this.destination.hashCode() : 0;
                result = 31 * result + (this.fieldDelimiter != null ? this.fieldDelimiter.hashCode() : 0);
                result = 31 * result + (this.keyPrefix != null ? this.keyPrefix.hashCode() : 0);
                result = 31 * result + (this.keyValueDelimiter != null ? this.keyValueDelimiter.hashCode() : 0);
                result = 31 * result + (this.nonMatchValue != null ? this.nonMatchValue.hashCode() : 0);
                result = 31 * result + (this.overwriteIfExists != null ? this.overwriteIfExists.hashCode() : 0);
                result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Use this processor to parse RDS for PostgreSQL vended logs, extract fields, and and convert them into a JSON format.
     * <p>
     * This processor always processes the entire log event message. For more information about this processor including examples, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-parsePostGres">parsePostGres</a> .
     * <p>
     * For more information about RDS for PostgreSQL log format, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.Concepts.PostgreSQL.html#USER_LogAccess.Concepts.PostgreSQL.Log_Format.log-line-prefix">RDS for PostgreSQL database log filesTCP flag sequence</a> .
     * <p>
     * <blockquote>
     * <p>
     * If you use this processor, it must be the first processor in your transformer.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.logs.*;
     * ParsePostgresProperty parsePostgresProperty = ParsePostgresProperty.builder()
     *         .source("source")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-parsepostgres.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-parsepostgres.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.CfnTransformer.ParsePostgresProperty")
    @software.amazon.jsii.Jsii.Proxy(ParsePostgresProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ParsePostgresProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Omit this parameter and the whole log message will be processed by this processor.
         * <p>
         * No other value than <code>&#64;message</code> is allowed for <code>source</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-parsepostgres.html#cfn-logs-transformer-parsepostgres-source">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-parsepostgres.html#cfn-logs-transformer-parsepostgres-source</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSource() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ParsePostgresProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ParsePostgresProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ParsePostgresProperty> {
            java.lang.String source;

            /**
             * Sets the value of {@link ParsePostgresProperty#getSource}
             * @param source Omit this parameter and the whole log message will be processed by this processor.
             *               No other value than <code>&#64;message</code> is allowed for <code>source</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(java.lang.String source) {
                this.source = source;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ParsePostgresProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ParsePostgresProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ParsePostgresProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ParsePostgresProperty {
            private final java.lang.String source;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.source = builder.source;
            }

            @Override
            public final java.lang.String getSource() {
                return this.source;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSource() != null) {
                    data.set("source", om.valueToTree(this.getSource()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.CfnTransformer.ParsePostgresProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ParsePostgresProperty.Jsii$Proxy that = (ParsePostgresProperty.Jsii$Proxy) o;

                return this.source != null ? this.source.equals(that.source) : that.source == null;
            }

            @Override
            public final int hashCode() {
                int result = this.source != null ? this.source.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Use this processor to parse Route 53 vended logs, extract fields, and and convert them into a JSON format.
     * <p>
     * This processor always processes the entire log event message. For more information about this processor including examples, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-parseRoute53">parseRoute53</a> .
     * <p>
     * <blockquote>
     * <p>
     * If you use this processor, it must be the first processor in your transformer.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.logs.*;
     * ParseRoute53Property parseRoute53Property = ParseRoute53Property.builder()
     *         .source("source")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-parseroute53.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-parseroute53.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.CfnTransformer.ParseRoute53Property")
    @software.amazon.jsii.Jsii.Proxy(ParseRoute53Property.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ParseRoute53Property extends software.amazon.jsii.JsiiSerializable {

        /**
         * Omit this parameter and the whole log message will be processed by this processor.
         * <p>
         * No other value than <code>&#64;message</code> is allowed for <code>source</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-parseroute53.html#cfn-logs-transformer-parseroute53-source">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-parseroute53.html#cfn-logs-transformer-parseroute53-source</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSource() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ParseRoute53Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ParseRoute53Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ParseRoute53Property> {
            java.lang.String source;

            /**
             * Sets the value of {@link ParseRoute53Property#getSource}
             * @param source Omit this parameter and the whole log message will be processed by this processor.
             *               No other value than <code>&#64;message</code> is allowed for <code>source</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(java.lang.String source) {
                this.source = source;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ParseRoute53Property}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ParseRoute53Property build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ParseRoute53Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ParseRoute53Property {
            private final java.lang.String source;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.source = builder.source;
            }

            @Override
            public final java.lang.String getSource() {
                return this.source;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSource() != null) {
                    data.set("source", om.valueToTree(this.getSource()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.CfnTransformer.ParseRoute53Property"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ParseRoute53Property.Jsii$Proxy that = (ParseRoute53Property.Jsii$Proxy) o;

                return this.source != null ? this.source.equals(that.source) : that.source == null;
            }

            @Override
            public final int hashCode() {
                int result = this.source != null ? this.source.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Use this processor to parse Amazon VPC vended logs, extract fields, and and convert them into a JSON format.
     * <p>
     * This processor always processes the entire log event message.
     * <p>
     * This processor doesn't support custom log formats, such as NAT gateway logs. For more information about custom log formats in Amazon VPC, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs-records-examples.html#flow-log-example-tcp-flag">parseVPC</a> For more information about this processor including examples, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-parseVPC">parseVPC</a> .
     * <p>
     * <blockquote>
     * <p>
     * If you use this processor, it must be the first processor in your transformer.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.logs.*;
     * ParseVPCProperty parseVPCProperty = ParseVPCProperty.builder()
     *         .source("source")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-parsevpc.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-parsevpc.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.CfnTransformer.ParseVPCProperty")
    @software.amazon.jsii.Jsii.Proxy(ParseVPCProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ParseVPCProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Omit this parameter and the whole log message will be processed by this processor.
         * <p>
         * No other value than <code>&#64;message</code> is allowed for <code>source</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-parsevpc.html#cfn-logs-transformer-parsevpc-source">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-parsevpc.html#cfn-logs-transformer-parsevpc-source</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSource() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ParseVPCProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ParseVPCProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ParseVPCProperty> {
            java.lang.String source;

            /**
             * Sets the value of {@link ParseVPCProperty#getSource}
             * @param source Omit this parameter and the whole log message will be processed by this processor.
             *               No other value than <code>&#64;message</code> is allowed for <code>source</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(java.lang.String source) {
                this.source = source;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ParseVPCProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ParseVPCProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ParseVPCProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ParseVPCProperty {
            private final java.lang.String source;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.source = builder.source;
            }

            @Override
            public final java.lang.String getSource() {
                return this.source;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSource() != null) {
                    data.set("source", om.valueToTree(this.getSource()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.CfnTransformer.ParseVPCProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ParseVPCProperty.Jsii$Proxy that = (ParseVPCProperty.Jsii$Proxy) o;

                return this.source != null ? this.source.equals(that.source) : that.source == null;
            }

            @Override
            public final int hashCode() {
                int result = this.source != null ? this.source.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Use this processor to parse AWS WAF vended logs, extract fields, and and convert them into a JSON format.
     * <p>
     * This processor always processes the entire log event message. For more information about this processor including examples, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-parsePostGres">parseWAF</a> .
     * <p>
     * For more information about AWS WAF log format, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/logging-examples.html">Log examples for web ACL traffic</a> .
     * <p>
     * <blockquote>
     * <p>
     * If you use this processor, it must be the first processor in your transformer.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.logs.*;
     * ParseWAFProperty parseWAFProperty = ParseWAFProperty.builder()
     *         .source("source")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-parsewaf.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-parsewaf.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.CfnTransformer.ParseWAFProperty")
    @software.amazon.jsii.Jsii.Proxy(ParseWAFProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ParseWAFProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Omit this parameter and the whole log message will be processed by this processor.
         * <p>
         * No other value than <code>&#64;message</code> is allowed for <code>source</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-parsewaf.html#cfn-logs-transformer-parsewaf-source">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-parsewaf.html#cfn-logs-transformer-parsewaf-source</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSource() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ParseWAFProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ParseWAFProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ParseWAFProperty> {
            java.lang.String source;

            /**
             * Sets the value of {@link ParseWAFProperty#getSource}
             * @param source Omit this parameter and the whole log message will be processed by this processor.
             *               No other value than <code>&#64;message</code> is allowed for <code>source</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(java.lang.String source) {
                this.source = source;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ParseWAFProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ParseWAFProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ParseWAFProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ParseWAFProperty {
            private final java.lang.String source;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.source = builder.source;
            }

            @Override
            public final java.lang.String getSource() {
                return this.source;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSource() != null) {
                    data.set("source", om.valueToTree(this.getSource()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.CfnTransformer.ParseWAFProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ParseWAFProperty.Jsii$Proxy that = (ParseWAFProperty.Jsii$Proxy) o;

                return this.source != null ? this.source.equals(that.source) : that.source == null;
            }

            @Override
            public final int hashCode() {
                int result = this.source != null ? this.source.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * This structure contains the information about one processor in a log transformer.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.logs.*;
     * ProcessorProperty processorProperty = ProcessorProperty.builder()
     *         .addKeys(AddKeysProperty.builder()
     *                 .entries(List.of(AddKeyEntryProperty.builder()
     *                         .key("key")
     *                         .value("value")
     *                         // the properties below are optional
     *                         .overwriteIfExists(false)
     *                         .build()))
     *                 .build())
     *         .copyValue(CopyValueProperty.builder()
     *                 .entries(List.of(CopyValueEntryProperty.builder()
     *                         .source("source")
     *                         .target("target")
     *                         // the properties below are optional
     *                         .overwriteIfExists(false)
     *                         .build()))
     *                 .build())
     *         .csv(CsvProperty.builder()
     *                 .columns(List.of("columns"))
     *                 .delimiter("delimiter")
     *                 .quoteCharacter("quoteCharacter")
     *                 .source("source")
     *                 .build())
     *         .dateTimeConverter(DateTimeConverterProperty.builder()
     *                 .matchPatterns(List.of("matchPatterns"))
     *                 .source("source")
     *                 .target("target")
     *                 // the properties below are optional
     *                 .locale("locale")
     *                 .sourceTimezone("sourceTimezone")
     *                 .targetFormat("targetFormat")
     *                 .targetTimezone("targetTimezone")
     *                 .build())
     *         .deleteKeys(DeleteKeysProperty.builder()
     *                 .withKeys(List.of("withKeys"))
     *                 .build())
     *         .grok(GrokProperty.builder()
     *                 .match("match")
     *                 // the properties below are optional
     *                 .source("source")
     *                 .build())
     *         .listToMap(ListToMapProperty.builder()
     *                 .key("key")
     *                 .source("source")
     *                 // the properties below are optional
     *                 .flatten(false)
     *                 .flattenedElement("flattenedElement")
     *                 .target("target")
     *                 .valueKey("valueKey")
     *                 .build())
     *         .lowerCaseString(LowerCaseStringProperty.builder()
     *                 .withKeys(List.of("withKeys"))
     *                 .build())
     *         .moveKeys(MoveKeysProperty.builder()
     *                 .entries(List.of(MoveKeyEntryProperty.builder()
     *                         .source("source")
     *                         .target("target")
     *                         // the properties below are optional
     *                         .overwriteIfExists(false)
     *                         .build()))
     *                 .build())
     *         .parseCloudfront(ParseCloudfrontProperty.builder()
     *                 .source("source")
     *                 .build())
     *         .parseJson(ParseJSONProperty.builder()
     *                 .destination("destination")
     *                 .source("source")
     *                 .build())
     *         .parseKeyValue(ParseKeyValueProperty.builder()
     *                 .destination("destination")
     *                 .fieldDelimiter("fieldDelimiter")
     *                 .keyPrefix("keyPrefix")
     *                 .keyValueDelimiter("keyValueDelimiter")
     *                 .nonMatchValue("nonMatchValue")
     *                 .overwriteIfExists(false)
     *                 .source("source")
     *                 .build())
     *         .parsePostgres(ParsePostgresProperty.builder()
     *                 .source("source")
     *                 .build())
     *         .parseRoute53(ParseRoute53Property.builder()
     *                 .source("source")
     *                 .build())
     *         .parseVpc(ParseVPCProperty.builder()
     *                 .source("source")
     *                 .build())
     *         .parseWaf(ParseWAFProperty.builder()
     *                 .source("source")
     *                 .build())
     *         .renameKeys(RenameKeysProperty.builder()
     *                 .entries(List.of(RenameKeyEntryProperty.builder()
     *                         .key("key")
     *                         .renameTo("renameTo")
     *                         // the properties below are optional
     *                         .overwriteIfExists(false)
     *                         .build()))
     *                 .build())
     *         .splitString(SplitStringProperty.builder()
     *                 .entries(List.of(SplitStringEntryProperty.builder()
     *                         .delimiter("delimiter")
     *                         .source("source")
     *                         .build()))
     *                 .build())
     *         .substituteString(SubstituteStringProperty.builder()
     *                 .entries(List.of(SubstituteStringEntryProperty.builder()
     *                         .from("from")
     *                         .source("source")
     *                         .to("to")
     *                         .build()))
     *                 .build())
     *         .trimString(TrimStringProperty.builder()
     *                 .withKeys(List.of("withKeys"))
     *                 .build())
     *         .typeConverter(TypeConverterProperty.builder()
     *                 .entries(List.of(TypeConverterEntryProperty.builder()
     *                         .key("key")
     *                         .type("type")
     *                         .build()))
     *                 .build())
     *         .upperCaseString(UpperCaseStringProperty.builder()
     *                 .withKeys(List.of("withKeys"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-processor.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-processor.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.CfnTransformer.ProcessorProperty")
    @software.amazon.jsii.Jsii.Proxy(ProcessorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProcessorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-addKeys">addKeys</a> processor in your transformer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-processor.html#cfn-logs-transformer-processor-addkeys">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-processor.html#cfn-logs-transformer-processor-addkeys</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAddKeys() {
            return null;
        }

        /**
         * Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-copyValue">copyValue</a> processor in your transformer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-processor.html#cfn-logs-transformer-processor-copyvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-processor.html#cfn-logs-transformer-processor-copyvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCopyValue() {
            return null;
        }

        /**
         * Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-CSV">CSV</a> processor in your transformer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-processor.html#cfn-logs-transformer-processor-csv">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-processor.html#cfn-logs-transformer-processor-csv</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCsv() {
            return null;
        }

        /**
         * Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-datetimeConverter">datetimeConverter</a> processor in your transformer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-processor.html#cfn-logs-transformer-processor-datetimeconverter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-processor.html#cfn-logs-transformer-processor-datetimeconverter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDateTimeConverter() {
            return null;
        }

        /**
         * Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-deleteKeys">deleteKeys</a> processor in your transformer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-processor.html#cfn-logs-transformer-processor-deletekeys">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-processor.html#cfn-logs-transformer-processor-deletekeys</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDeleteKeys() {
            return null;
        }

        /**
         * Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-grok">grok</a> processor in your transformer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-processor.html#cfn-logs-transformer-processor-grok">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-processor.html#cfn-logs-transformer-processor-grok</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGrok() {
            return null;
        }

        /**
         * Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-listToMap">listToMap</a> processor in your transformer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-processor.html#cfn-logs-transformer-processor-listtomap">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-processor.html#cfn-logs-transformer-processor-listtomap</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getListToMap() {
            return null;
        }

        /**
         * Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-lowerCaseString">lowerCaseString</a> processor in your transformer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-processor.html#cfn-logs-transformer-processor-lowercasestring">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-processor.html#cfn-logs-transformer-processor-lowercasestring</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLowerCaseString() {
            return null;
        }

        /**
         * Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-moveKeys">moveKeys</a> processor in your transformer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-processor.html#cfn-logs-transformer-processor-movekeys">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-processor.html#cfn-logs-transformer-processor-movekeys</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMoveKeys() {
            return null;
        }

        /**
         * Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-parseCloudfront">parseCloudfront</a> processor in your transformer.
         * <p>
         * If you use this processor, it must be the first processor in your transformer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-processor.html#cfn-logs-transformer-processor-parsecloudfront">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-processor.html#cfn-logs-transformer-processor-parsecloudfront</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getParseCloudfront() {
            return null;
        }

        /**
         * Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-parseJSON">parseJSON</a> processor in your transformer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-processor.html#cfn-logs-transformer-processor-parsejson">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-processor.html#cfn-logs-transformer-processor-parsejson</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getParseJson() {
            return null;
        }

        /**
         * Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-parseKeyValue">parseKeyValue</a> processor in your transformer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-processor.html#cfn-logs-transformer-processor-parsekeyvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-processor.html#cfn-logs-transformer-processor-parsekeyvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getParseKeyValue() {
            return null;
        }

        /**
         * Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-parsePostGres">parsePostGres</a> processor in your transformer.
         * <p>
         * If you use this processor, it must be the first processor in your transformer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-processor.html#cfn-logs-transformer-processor-parsepostgres">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-processor.html#cfn-logs-transformer-processor-parsepostgres</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getParsePostgres() {
            return null;
        }

        /**
         * Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-parseRoute53">parseRoute53</a> processor in your transformer.
         * <p>
         * If you use this processor, it must be the first processor in your transformer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-processor.html#cfn-logs-transformer-processor-parseroute53">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-processor.html#cfn-logs-transformer-processor-parseroute53</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getParseRoute53() {
            return null;
        }

        /**
         * Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-parseVPC">parseVPC</a> processor in your transformer.
         * <p>
         * If you use this processor, it must be the first processor in your transformer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-processor.html#cfn-logs-transformer-processor-parsevpc">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-processor.html#cfn-logs-transformer-processor-parsevpc</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getParseVpc() {
            return null;
        }

        /**
         * Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-parseWAF">parseWAF</a> processor in your transformer.
         * <p>
         * If you use this processor, it must be the first processor in your transformer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-processor.html#cfn-logs-transformer-processor-parsewaf">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-processor.html#cfn-logs-transformer-processor-parsewaf</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getParseWaf() {
            return null;
        }

        /**
         * Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-renameKeys">renameKeys</a> processor in your transformer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-processor.html#cfn-logs-transformer-processor-renamekeys">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-processor.html#cfn-logs-transformer-processor-renamekeys</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRenameKeys() {
            return null;
        }

        /**
         * Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-splitString">splitString</a> processor in your transformer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-processor.html#cfn-logs-transformer-processor-splitstring">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-processor.html#cfn-logs-transformer-processor-splitstring</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSplitString() {
            return null;
        }

        /**
         * Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-substituteString">substituteString</a> processor in your transformer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-processor.html#cfn-logs-transformer-processor-substitutestring">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-processor.html#cfn-logs-transformer-processor-substitutestring</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSubstituteString() {
            return null;
        }

        /**
         * Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-trimString">trimString</a> processor in your transformer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-processor.html#cfn-logs-transformer-processor-trimstring">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-processor.html#cfn-logs-transformer-processor-trimstring</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTrimString() {
            return null;
        }

        /**
         * Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-typeConverter">typeConverter</a> processor in your transformer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-processor.html#cfn-logs-transformer-processor-typeconverter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-processor.html#cfn-logs-transformer-processor-typeconverter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTypeConverter() {
            return null;
        }

        /**
         * Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-upperCaseString">upperCaseString</a> processor in your transformer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-processor.html#cfn-logs-transformer-processor-uppercasestring">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-processor.html#cfn-logs-transformer-processor-uppercasestring</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUpperCaseString() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ProcessorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProcessorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProcessorProperty> {
            java.lang.Object addKeys;
            java.lang.Object copyValue;
            java.lang.Object csv;
            java.lang.Object dateTimeConverter;
            java.lang.Object deleteKeys;
            java.lang.Object grok;
            java.lang.Object listToMap;
            java.lang.Object lowerCaseString;
            java.lang.Object moveKeys;
            java.lang.Object parseCloudfront;
            java.lang.Object parseJson;
            java.lang.Object parseKeyValue;
            java.lang.Object parsePostgres;
            java.lang.Object parseRoute53;
            java.lang.Object parseVpc;
            java.lang.Object parseWaf;
            java.lang.Object renameKeys;
            java.lang.Object splitString;
            java.lang.Object substituteString;
            java.lang.Object trimString;
            java.lang.Object typeConverter;
            java.lang.Object upperCaseString;

            /**
             * Sets the value of {@link ProcessorProperty#getAddKeys}
             * @param addKeys Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-addKeys">addKeys</a> processor in your transformer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder addKeys(software.amazon.awscdk.IResolvable addKeys) {
                this.addKeys = addKeys;
                return this;
            }

            /**
             * Sets the value of {@link ProcessorProperty#getAddKeys}
             * @param addKeys Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-addKeys">addKeys</a> processor in your transformer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder addKeys(software.amazon.awscdk.services.logs.CfnTransformer.AddKeysProperty addKeys) {
                this.addKeys = addKeys;
                return this;
            }

            /**
             * Sets the value of {@link ProcessorProperty#getCopyValue}
             * @param copyValue Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-copyValue">copyValue</a> processor in your transformer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder copyValue(software.amazon.awscdk.IResolvable copyValue) {
                this.copyValue = copyValue;
                return this;
            }

            /**
             * Sets the value of {@link ProcessorProperty#getCopyValue}
             * @param copyValue Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-copyValue">copyValue</a> processor in your transformer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder copyValue(software.amazon.awscdk.services.logs.CfnTransformer.CopyValueProperty copyValue) {
                this.copyValue = copyValue;
                return this;
            }

            /**
             * Sets the value of {@link ProcessorProperty#getCsv}
             * @param csv Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-CSV">CSV</a> processor in your transformer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder csv(software.amazon.awscdk.IResolvable csv) {
                this.csv = csv;
                return this;
            }

            /**
             * Sets the value of {@link ProcessorProperty#getCsv}
             * @param csv Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-CSV">CSV</a> processor in your transformer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder csv(software.amazon.awscdk.services.logs.CfnTransformer.CsvProperty csv) {
                this.csv = csv;
                return this;
            }

            /**
             * Sets the value of {@link ProcessorProperty#getDateTimeConverter}
             * @param dateTimeConverter Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-datetimeConverter">datetimeConverter</a> processor in your transformer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dateTimeConverter(software.amazon.awscdk.IResolvable dateTimeConverter) {
                this.dateTimeConverter = dateTimeConverter;
                return this;
            }

            /**
             * Sets the value of {@link ProcessorProperty#getDateTimeConverter}
             * @param dateTimeConverter Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-datetimeConverter">datetimeConverter</a> processor in your transformer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dateTimeConverter(software.amazon.awscdk.services.logs.CfnTransformer.DateTimeConverterProperty dateTimeConverter) {
                this.dateTimeConverter = dateTimeConverter;
                return this;
            }

            /**
             * Sets the value of {@link ProcessorProperty#getDeleteKeys}
             * @param deleteKeys Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-deleteKeys">deleteKeys</a> processor in your transformer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deleteKeys(software.amazon.awscdk.IResolvable deleteKeys) {
                this.deleteKeys = deleteKeys;
                return this;
            }

            /**
             * Sets the value of {@link ProcessorProperty#getDeleteKeys}
             * @param deleteKeys Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-deleteKeys">deleteKeys</a> processor in your transformer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deleteKeys(software.amazon.awscdk.services.logs.CfnTransformer.DeleteKeysProperty deleteKeys) {
                this.deleteKeys = deleteKeys;
                return this;
            }

            /**
             * Sets the value of {@link ProcessorProperty#getGrok}
             * @param grok Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-grok">grok</a> processor in your transformer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder grok(software.amazon.awscdk.IResolvable grok) {
                this.grok = grok;
                return this;
            }

            /**
             * Sets the value of {@link ProcessorProperty#getGrok}
             * @param grok Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-grok">grok</a> processor in your transformer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder grok(software.amazon.awscdk.services.logs.CfnTransformer.GrokProperty grok) {
                this.grok = grok;
                return this;
            }

            /**
             * Sets the value of {@link ProcessorProperty#getListToMap}
             * @param listToMap Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-listToMap">listToMap</a> processor in your transformer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder listToMap(software.amazon.awscdk.IResolvable listToMap) {
                this.listToMap = listToMap;
                return this;
            }

            /**
             * Sets the value of {@link ProcessorProperty#getListToMap}
             * @param listToMap Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-listToMap">listToMap</a> processor in your transformer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder listToMap(software.amazon.awscdk.services.logs.CfnTransformer.ListToMapProperty listToMap) {
                this.listToMap = listToMap;
                return this;
            }

            /**
             * Sets the value of {@link ProcessorProperty#getLowerCaseString}
             * @param lowerCaseString Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-lowerCaseString">lowerCaseString</a> processor in your transformer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lowerCaseString(software.amazon.awscdk.IResolvable lowerCaseString) {
                this.lowerCaseString = lowerCaseString;
                return this;
            }

            /**
             * Sets the value of {@link ProcessorProperty#getLowerCaseString}
             * @param lowerCaseString Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-lowerCaseString">lowerCaseString</a> processor in your transformer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lowerCaseString(software.amazon.awscdk.services.logs.CfnTransformer.LowerCaseStringProperty lowerCaseString) {
                this.lowerCaseString = lowerCaseString;
                return this;
            }

            /**
             * Sets the value of {@link ProcessorProperty#getMoveKeys}
             * @param moveKeys Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-moveKeys">moveKeys</a> processor in your transformer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder moveKeys(software.amazon.awscdk.IResolvable moveKeys) {
                this.moveKeys = moveKeys;
                return this;
            }

            /**
             * Sets the value of {@link ProcessorProperty#getMoveKeys}
             * @param moveKeys Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-moveKeys">moveKeys</a> processor in your transformer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder moveKeys(software.amazon.awscdk.services.logs.CfnTransformer.MoveKeysProperty moveKeys) {
                this.moveKeys = moveKeys;
                return this;
            }

            /**
             * Sets the value of {@link ProcessorProperty#getParseCloudfront}
             * @param parseCloudfront Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-parseCloudfront">parseCloudfront</a> processor in your transformer.
             *                        If you use this processor, it must be the first processor in your transformer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parseCloudfront(software.amazon.awscdk.IResolvable parseCloudfront) {
                this.parseCloudfront = parseCloudfront;
                return this;
            }

            /**
             * Sets the value of {@link ProcessorProperty#getParseCloudfront}
             * @param parseCloudfront Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-parseCloudfront">parseCloudfront</a> processor in your transformer.
             *                        If you use this processor, it must be the first processor in your transformer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parseCloudfront(software.amazon.awscdk.services.logs.CfnTransformer.ParseCloudfrontProperty parseCloudfront) {
                this.parseCloudfront = parseCloudfront;
                return this;
            }

            /**
             * Sets the value of {@link ProcessorProperty#getParseJson}
             * @param parseJson Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-parseJSON">parseJSON</a> processor in your transformer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parseJson(software.amazon.awscdk.IResolvable parseJson) {
                this.parseJson = parseJson;
                return this;
            }

            /**
             * Sets the value of {@link ProcessorProperty#getParseJson}
             * @param parseJson Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-parseJSON">parseJSON</a> processor in your transformer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parseJson(software.amazon.awscdk.services.logs.CfnTransformer.ParseJSONProperty parseJson) {
                this.parseJson = parseJson;
                return this;
            }

            /**
             * Sets the value of {@link ProcessorProperty#getParseKeyValue}
             * @param parseKeyValue Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-parseKeyValue">parseKeyValue</a> processor in your transformer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parseKeyValue(software.amazon.awscdk.IResolvable parseKeyValue) {
                this.parseKeyValue = parseKeyValue;
                return this;
            }

            /**
             * Sets the value of {@link ProcessorProperty#getParseKeyValue}
             * @param parseKeyValue Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-parseKeyValue">parseKeyValue</a> processor in your transformer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parseKeyValue(software.amazon.awscdk.services.logs.CfnTransformer.ParseKeyValueProperty parseKeyValue) {
                this.parseKeyValue = parseKeyValue;
                return this;
            }

            /**
             * Sets the value of {@link ProcessorProperty#getParsePostgres}
             * @param parsePostgres Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-parsePostGres">parsePostGres</a> processor in your transformer.
             *                      If you use this processor, it must be the first processor in your transformer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parsePostgres(software.amazon.awscdk.IResolvable parsePostgres) {
                this.parsePostgres = parsePostgres;
                return this;
            }

            /**
             * Sets the value of {@link ProcessorProperty#getParsePostgres}
             * @param parsePostgres Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-parsePostGres">parsePostGres</a> processor in your transformer.
             *                      If you use this processor, it must be the first processor in your transformer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parsePostgres(software.amazon.awscdk.services.logs.CfnTransformer.ParsePostgresProperty parsePostgres) {
                this.parsePostgres = parsePostgres;
                return this;
            }

            /**
             * Sets the value of {@link ProcessorProperty#getParseRoute53}
             * @param parseRoute53 Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-parseRoute53">parseRoute53</a> processor in your transformer.
             *                     If you use this processor, it must be the first processor in your transformer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parseRoute53(software.amazon.awscdk.IResolvable parseRoute53) {
                this.parseRoute53 = parseRoute53;
                return this;
            }

            /**
             * Sets the value of {@link ProcessorProperty#getParseRoute53}
             * @param parseRoute53 Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-parseRoute53">parseRoute53</a> processor in your transformer.
             *                     If you use this processor, it must be the first processor in your transformer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parseRoute53(software.amazon.awscdk.services.logs.CfnTransformer.ParseRoute53Property parseRoute53) {
                this.parseRoute53 = parseRoute53;
                return this;
            }

            /**
             * Sets the value of {@link ProcessorProperty#getParseVpc}
             * @param parseVpc Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-parseVPC">parseVPC</a> processor in your transformer.
             *                 If you use this processor, it must be the first processor in your transformer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parseVpc(software.amazon.awscdk.IResolvable parseVpc) {
                this.parseVpc = parseVpc;
                return this;
            }

            /**
             * Sets the value of {@link ProcessorProperty#getParseVpc}
             * @param parseVpc Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-parseVPC">parseVPC</a> processor in your transformer.
             *                 If you use this processor, it must be the first processor in your transformer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parseVpc(software.amazon.awscdk.services.logs.CfnTransformer.ParseVPCProperty parseVpc) {
                this.parseVpc = parseVpc;
                return this;
            }

            /**
             * Sets the value of {@link ProcessorProperty#getParseWaf}
             * @param parseWaf Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-parseWAF">parseWAF</a> processor in your transformer.
             *                 If you use this processor, it must be the first processor in your transformer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parseWaf(software.amazon.awscdk.IResolvable parseWaf) {
                this.parseWaf = parseWaf;
                return this;
            }

            /**
             * Sets the value of {@link ProcessorProperty#getParseWaf}
             * @param parseWaf Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-parseWAF">parseWAF</a> processor in your transformer.
             *                 If you use this processor, it must be the first processor in your transformer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parseWaf(software.amazon.awscdk.services.logs.CfnTransformer.ParseWAFProperty parseWaf) {
                this.parseWaf = parseWaf;
                return this;
            }

            /**
             * Sets the value of {@link ProcessorProperty#getRenameKeys}
             * @param renameKeys Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-renameKeys">renameKeys</a> processor in your transformer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder renameKeys(software.amazon.awscdk.IResolvable renameKeys) {
                this.renameKeys = renameKeys;
                return this;
            }

            /**
             * Sets the value of {@link ProcessorProperty#getRenameKeys}
             * @param renameKeys Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-renameKeys">renameKeys</a> processor in your transformer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder renameKeys(software.amazon.awscdk.services.logs.CfnTransformer.RenameKeysProperty renameKeys) {
                this.renameKeys = renameKeys;
                return this;
            }

            /**
             * Sets the value of {@link ProcessorProperty#getSplitString}
             * @param splitString Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-splitString">splitString</a> processor in your transformer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder splitString(software.amazon.awscdk.IResolvable splitString) {
                this.splitString = splitString;
                return this;
            }

            /**
             * Sets the value of {@link ProcessorProperty#getSplitString}
             * @param splitString Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-splitString">splitString</a> processor in your transformer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder splitString(software.amazon.awscdk.services.logs.CfnTransformer.SplitStringProperty splitString) {
                this.splitString = splitString;
                return this;
            }

            /**
             * Sets the value of {@link ProcessorProperty#getSubstituteString}
             * @param substituteString Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-substituteString">substituteString</a> processor in your transformer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder substituteString(software.amazon.awscdk.IResolvable substituteString) {
                this.substituteString = substituteString;
                return this;
            }

            /**
             * Sets the value of {@link ProcessorProperty#getSubstituteString}
             * @param substituteString Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-substituteString">substituteString</a> processor in your transformer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder substituteString(software.amazon.awscdk.services.logs.CfnTransformer.SubstituteStringProperty substituteString) {
                this.substituteString = substituteString;
                return this;
            }

            /**
             * Sets the value of {@link ProcessorProperty#getTrimString}
             * @param trimString Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-trimString">trimString</a> processor in your transformer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trimString(software.amazon.awscdk.IResolvable trimString) {
                this.trimString = trimString;
                return this;
            }

            /**
             * Sets the value of {@link ProcessorProperty#getTrimString}
             * @param trimString Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-trimString">trimString</a> processor in your transformer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trimString(software.amazon.awscdk.services.logs.CfnTransformer.TrimStringProperty trimString) {
                this.trimString = trimString;
                return this;
            }

            /**
             * Sets the value of {@link ProcessorProperty#getTypeConverter}
             * @param typeConverter Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-typeConverter">typeConverter</a> processor in your transformer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder typeConverter(software.amazon.awscdk.IResolvable typeConverter) {
                this.typeConverter = typeConverter;
                return this;
            }

            /**
             * Sets the value of {@link ProcessorProperty#getTypeConverter}
             * @param typeConverter Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-typeConverter">typeConverter</a> processor in your transformer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder typeConverter(software.amazon.awscdk.services.logs.CfnTransformer.TypeConverterProperty typeConverter) {
                this.typeConverter = typeConverter;
                return this;
            }

            /**
             * Sets the value of {@link ProcessorProperty#getUpperCaseString}
             * @param upperCaseString Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-upperCaseString">upperCaseString</a> processor in your transformer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder upperCaseString(software.amazon.awscdk.IResolvable upperCaseString) {
                this.upperCaseString = upperCaseString;
                return this;
            }

            /**
             * Sets the value of {@link ProcessorProperty#getUpperCaseString}
             * @param upperCaseString Use this parameter to include the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-upperCaseString">upperCaseString</a> processor in your transformer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder upperCaseString(software.amazon.awscdk.services.logs.CfnTransformer.UpperCaseStringProperty upperCaseString) {
                this.upperCaseString = upperCaseString;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProcessorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProcessorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProcessorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProcessorProperty {
            private final java.lang.Object addKeys;
            private final java.lang.Object copyValue;
            private final java.lang.Object csv;
            private final java.lang.Object dateTimeConverter;
            private final java.lang.Object deleteKeys;
            private final java.lang.Object grok;
            private final java.lang.Object listToMap;
            private final java.lang.Object lowerCaseString;
            private final java.lang.Object moveKeys;
            private final java.lang.Object parseCloudfront;
            private final java.lang.Object parseJson;
            private final java.lang.Object parseKeyValue;
            private final java.lang.Object parsePostgres;
            private final java.lang.Object parseRoute53;
            private final java.lang.Object parseVpc;
            private final java.lang.Object parseWaf;
            private final java.lang.Object renameKeys;
            private final java.lang.Object splitString;
            private final java.lang.Object substituteString;
            private final java.lang.Object trimString;
            private final java.lang.Object typeConverter;
            private final java.lang.Object upperCaseString;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.addKeys = software.amazon.jsii.Kernel.get(this, "addKeys", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.copyValue = software.amazon.jsii.Kernel.get(this, "copyValue", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.csv = software.amazon.jsii.Kernel.get(this, "csv", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dateTimeConverter = software.amazon.jsii.Kernel.get(this, "dateTimeConverter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.deleteKeys = software.amazon.jsii.Kernel.get(this, "deleteKeys", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.grok = software.amazon.jsii.Kernel.get(this, "grok", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.listToMap = software.amazon.jsii.Kernel.get(this, "listToMap", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.lowerCaseString = software.amazon.jsii.Kernel.get(this, "lowerCaseString", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.moveKeys = software.amazon.jsii.Kernel.get(this, "moveKeys", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.parseCloudfront = software.amazon.jsii.Kernel.get(this, "parseCloudfront", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.parseJson = software.amazon.jsii.Kernel.get(this, "parseJson", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.parseKeyValue = software.amazon.jsii.Kernel.get(this, "parseKeyValue", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.parsePostgres = software.amazon.jsii.Kernel.get(this, "parsePostgres", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.parseRoute53 = software.amazon.jsii.Kernel.get(this, "parseRoute53", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.parseVpc = software.amazon.jsii.Kernel.get(this, "parseVpc", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.parseWaf = software.amazon.jsii.Kernel.get(this, "parseWaf", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.renameKeys = software.amazon.jsii.Kernel.get(this, "renameKeys", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.splitString = software.amazon.jsii.Kernel.get(this, "splitString", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.substituteString = software.amazon.jsii.Kernel.get(this, "substituteString", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.trimString = software.amazon.jsii.Kernel.get(this, "trimString", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.typeConverter = software.amazon.jsii.Kernel.get(this, "typeConverter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.upperCaseString = software.amazon.jsii.Kernel.get(this, "upperCaseString", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.addKeys = builder.addKeys;
                this.copyValue = builder.copyValue;
                this.csv = builder.csv;
                this.dateTimeConverter = builder.dateTimeConverter;
                this.deleteKeys = builder.deleteKeys;
                this.grok = builder.grok;
                this.listToMap = builder.listToMap;
                this.lowerCaseString = builder.lowerCaseString;
                this.moveKeys = builder.moveKeys;
                this.parseCloudfront = builder.parseCloudfront;
                this.parseJson = builder.parseJson;
                this.parseKeyValue = builder.parseKeyValue;
                this.parsePostgres = builder.parsePostgres;
                this.parseRoute53 = builder.parseRoute53;
                this.parseVpc = builder.parseVpc;
                this.parseWaf = builder.parseWaf;
                this.renameKeys = builder.renameKeys;
                this.splitString = builder.splitString;
                this.substituteString = builder.substituteString;
                this.trimString = builder.trimString;
                this.typeConverter = builder.typeConverter;
                this.upperCaseString = builder.upperCaseString;
            }

            @Override
            public final java.lang.Object getAddKeys() {
                return this.addKeys;
            }

            @Override
            public final java.lang.Object getCopyValue() {
                return this.copyValue;
            }

            @Override
            public final java.lang.Object getCsv() {
                return this.csv;
            }

            @Override
            public final java.lang.Object getDateTimeConverter() {
                return this.dateTimeConverter;
            }

            @Override
            public final java.lang.Object getDeleteKeys() {
                return this.deleteKeys;
            }

            @Override
            public final java.lang.Object getGrok() {
                return this.grok;
            }

            @Override
            public final java.lang.Object getListToMap() {
                return this.listToMap;
            }

            @Override
            public final java.lang.Object getLowerCaseString() {
                return this.lowerCaseString;
            }

            @Override
            public final java.lang.Object getMoveKeys() {
                return this.moveKeys;
            }

            @Override
            public final java.lang.Object getParseCloudfront() {
                return this.parseCloudfront;
            }

            @Override
            public final java.lang.Object getParseJson() {
                return this.parseJson;
            }

            @Override
            public final java.lang.Object getParseKeyValue() {
                return this.parseKeyValue;
            }

            @Override
            public final java.lang.Object getParsePostgres() {
                return this.parsePostgres;
            }

            @Override
            public final java.lang.Object getParseRoute53() {
                return this.parseRoute53;
            }

            @Override
            public final java.lang.Object getParseVpc() {
                return this.parseVpc;
            }

            @Override
            public final java.lang.Object getParseWaf() {
                return this.parseWaf;
            }

            @Override
            public final java.lang.Object getRenameKeys() {
                return this.renameKeys;
            }

            @Override
            public final java.lang.Object getSplitString() {
                return this.splitString;
            }

            @Override
            public final java.lang.Object getSubstituteString() {
                return this.substituteString;
            }

            @Override
            public final java.lang.Object getTrimString() {
                return this.trimString;
            }

            @Override
            public final java.lang.Object getTypeConverter() {
                return this.typeConverter;
            }

            @Override
            public final java.lang.Object getUpperCaseString() {
                return this.upperCaseString;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAddKeys() != null) {
                    data.set("addKeys", om.valueToTree(this.getAddKeys()));
                }
                if (this.getCopyValue() != null) {
                    data.set("copyValue", om.valueToTree(this.getCopyValue()));
                }
                if (this.getCsv() != null) {
                    data.set("csv", om.valueToTree(this.getCsv()));
                }
                if (this.getDateTimeConverter() != null) {
                    data.set("dateTimeConverter", om.valueToTree(this.getDateTimeConverter()));
                }
                if (this.getDeleteKeys() != null) {
                    data.set("deleteKeys", om.valueToTree(this.getDeleteKeys()));
                }
                if (this.getGrok() != null) {
                    data.set("grok", om.valueToTree(this.getGrok()));
                }
                if (this.getListToMap() != null) {
                    data.set("listToMap", om.valueToTree(this.getListToMap()));
                }
                if (this.getLowerCaseString() != null) {
                    data.set("lowerCaseString", om.valueToTree(this.getLowerCaseString()));
                }
                if (this.getMoveKeys() != null) {
                    data.set("moveKeys", om.valueToTree(this.getMoveKeys()));
                }
                if (this.getParseCloudfront() != null) {
                    data.set("parseCloudfront", om.valueToTree(this.getParseCloudfront()));
                }
                if (this.getParseJson() != null) {
                    data.set("parseJson", om.valueToTree(this.getParseJson()));
                }
                if (this.getParseKeyValue() != null) {
                    data.set("parseKeyValue", om.valueToTree(this.getParseKeyValue()));
                }
                if (this.getParsePostgres() != null) {
                    data.set("parsePostgres", om.valueToTree(this.getParsePostgres()));
                }
                if (this.getParseRoute53() != null) {
                    data.set("parseRoute53", om.valueToTree(this.getParseRoute53()));
                }
                if (this.getParseVpc() != null) {
                    data.set("parseVpc", om.valueToTree(this.getParseVpc()));
                }
                if (this.getParseWaf() != null) {
                    data.set("parseWaf", om.valueToTree(this.getParseWaf()));
                }
                if (this.getRenameKeys() != null) {
                    data.set("renameKeys", om.valueToTree(this.getRenameKeys()));
                }
                if (this.getSplitString() != null) {
                    data.set("splitString", om.valueToTree(this.getSplitString()));
                }
                if (this.getSubstituteString() != null) {
                    data.set("substituteString", om.valueToTree(this.getSubstituteString()));
                }
                if (this.getTrimString() != null) {
                    data.set("trimString", om.valueToTree(this.getTrimString()));
                }
                if (this.getTypeConverter() != null) {
                    data.set("typeConverter", om.valueToTree(this.getTypeConverter()));
                }
                if (this.getUpperCaseString() != null) {
                    data.set("upperCaseString", om.valueToTree(this.getUpperCaseString()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.CfnTransformer.ProcessorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProcessorProperty.Jsii$Proxy that = (ProcessorProperty.Jsii$Proxy) o;

                if (this.addKeys != null ? !this.addKeys.equals(that.addKeys) : that.addKeys != null) return false;
                if (this.copyValue != null ? !this.copyValue.equals(that.copyValue) : that.copyValue != null) return false;
                if (this.csv != null ? !this.csv.equals(that.csv) : that.csv != null) return false;
                if (this.dateTimeConverter != null ? !this.dateTimeConverter.equals(that.dateTimeConverter) : that.dateTimeConverter != null) return false;
                if (this.deleteKeys != null ? !this.deleteKeys.equals(that.deleteKeys) : that.deleteKeys != null) return false;
                if (this.grok != null ? !this.grok.equals(that.grok) : that.grok != null) return false;
                if (this.listToMap != null ? !this.listToMap.equals(that.listToMap) : that.listToMap != null) return false;
                if (this.lowerCaseString != null ? !this.lowerCaseString.equals(that.lowerCaseString) : that.lowerCaseString != null) return false;
                if (this.moveKeys != null ? !this.moveKeys.equals(that.moveKeys) : that.moveKeys != null) return false;
                if (this.parseCloudfront != null ? !this.parseCloudfront.equals(that.parseCloudfront) : that.parseCloudfront != null) return false;
                if (this.parseJson != null ? !this.parseJson.equals(that.parseJson) : that.parseJson != null) return false;
                if (this.parseKeyValue != null ? !this.parseKeyValue.equals(that.parseKeyValue) : that.parseKeyValue != null) return false;
                if (this.parsePostgres != null ? !this.parsePostgres.equals(that.parsePostgres) : that.parsePostgres != null) return false;
                if (this.parseRoute53 != null ? !this.parseRoute53.equals(that.parseRoute53) : that.parseRoute53 != null) return false;
                if (this.parseVpc != null ? !this.parseVpc.equals(that.parseVpc) : that.parseVpc != null) return false;
                if (this.parseWaf != null ? !this.parseWaf.equals(that.parseWaf) : that.parseWaf != null) return false;
                if (this.renameKeys != null ? !this.renameKeys.equals(that.renameKeys) : that.renameKeys != null) return false;
                if (this.splitString != null ? !this.splitString.equals(that.splitString) : that.splitString != null) return false;
                if (this.substituteString != null ? !this.substituteString.equals(that.substituteString) : that.substituteString != null) return false;
                if (this.trimString != null ? !this.trimString.equals(that.trimString) : that.trimString != null) return false;
                if (this.typeConverter != null ? !this.typeConverter.equals(that.typeConverter) : that.typeConverter != null) return false;
                return this.upperCaseString != null ? this.upperCaseString.equals(that.upperCaseString) : that.upperCaseString == null;
            }

            @Override
            public final int hashCode() {
                int result = this.addKeys != null ? this.addKeys.hashCode() : 0;
                result = 31 * result + (this.copyValue != null ? this.copyValue.hashCode() : 0);
                result = 31 * result + (this.csv != null ? this.csv.hashCode() : 0);
                result = 31 * result + (this.dateTimeConverter != null ? this.dateTimeConverter.hashCode() : 0);
                result = 31 * result + (this.deleteKeys != null ? this.deleteKeys.hashCode() : 0);
                result = 31 * result + (this.grok != null ? this.grok.hashCode() : 0);
                result = 31 * result + (this.listToMap != null ? this.listToMap.hashCode() : 0);
                result = 31 * result + (this.lowerCaseString != null ? this.lowerCaseString.hashCode() : 0);
                result = 31 * result + (this.moveKeys != null ? this.moveKeys.hashCode() : 0);
                result = 31 * result + (this.parseCloudfront != null ? this.parseCloudfront.hashCode() : 0);
                result = 31 * result + (this.parseJson != null ? this.parseJson.hashCode() : 0);
                result = 31 * result + (this.parseKeyValue != null ? this.parseKeyValue.hashCode() : 0);
                result = 31 * result + (this.parsePostgres != null ? this.parsePostgres.hashCode() : 0);
                result = 31 * result + (this.parseRoute53 != null ? this.parseRoute53.hashCode() : 0);
                result = 31 * result + (this.parseVpc != null ? this.parseVpc.hashCode() : 0);
                result = 31 * result + (this.parseWaf != null ? this.parseWaf.hashCode() : 0);
                result = 31 * result + (this.renameKeys != null ? this.renameKeys.hashCode() : 0);
                result = 31 * result + (this.splitString != null ? this.splitString.hashCode() : 0);
                result = 31 * result + (this.substituteString != null ? this.substituteString.hashCode() : 0);
                result = 31 * result + (this.trimString != null ? this.trimString.hashCode() : 0);
                result = 31 * result + (this.typeConverter != null ? this.typeConverter.hashCode() : 0);
                result = 31 * result + (this.upperCaseString != null ? this.upperCaseString.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * This object defines one key that will be renamed with the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-renameKey">renameKey</a> processor.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.logs.*;
     * RenameKeyEntryProperty renameKeyEntryProperty = RenameKeyEntryProperty.builder()
     *         .key("key")
     *         .renameTo("renameTo")
     *         // the properties below are optional
     *         .overwriteIfExists(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-renamekeyentry.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-renamekeyentry.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.CfnTransformer.RenameKeyEntryProperty")
    @software.amazon.jsii.Jsii.Proxy(RenameKeyEntryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RenameKeyEntryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The key to rename.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-renamekeyentry.html#cfn-logs-transformer-renamekeyentry-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-renamekeyentry.html#cfn-logs-transformer-renamekeyentry-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * The string to use for the new key name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-renamekeyentry.html#cfn-logs-transformer-renamekeyentry-renameto">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-renamekeyentry.html#cfn-logs-transformer-renamekeyentry-renameto</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRenameTo();

        /**
         * Specifies whether to overwrite the existing value if the destination key already exists.
         * <p>
         * The default is <code>false</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-renamekeyentry.html#cfn-logs-transformer-renamekeyentry-overwriteifexists">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-renamekeyentry.html#cfn-logs-transformer-renamekeyentry-overwriteifexists</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOverwriteIfExists() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RenameKeyEntryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RenameKeyEntryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RenameKeyEntryProperty> {
            java.lang.String key;
            java.lang.String renameTo;
            java.lang.Object overwriteIfExists;

            /**
             * Sets the value of {@link RenameKeyEntryProperty#getKey}
             * @param key The key to rename. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link RenameKeyEntryProperty#getRenameTo}
             * @param renameTo The string to use for the new key name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder renameTo(java.lang.String renameTo) {
                this.renameTo = renameTo;
                return this;
            }

            /**
             * Sets the value of {@link RenameKeyEntryProperty#getOverwriteIfExists}
             * @param overwriteIfExists Specifies whether to overwrite the existing value if the destination key already exists.
             *                          The default is <code>false</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overwriteIfExists(java.lang.Boolean overwriteIfExists) {
                this.overwriteIfExists = overwriteIfExists;
                return this;
            }

            /**
             * Sets the value of {@link RenameKeyEntryProperty#getOverwriteIfExists}
             * @param overwriteIfExists Specifies whether to overwrite the existing value if the destination key already exists.
             *                          The default is <code>false</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overwriteIfExists(software.amazon.awscdk.IResolvable overwriteIfExists) {
                this.overwriteIfExists = overwriteIfExists;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RenameKeyEntryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RenameKeyEntryProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RenameKeyEntryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RenameKeyEntryProperty {
            private final java.lang.String key;
            private final java.lang.String renameTo;
            private final java.lang.Object overwriteIfExists;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.renameTo = software.amazon.jsii.Kernel.get(this, "renameTo", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.overwriteIfExists = software.amazon.jsii.Kernel.get(this, "overwriteIfExists", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.renameTo = java.util.Objects.requireNonNull(builder.renameTo, "renameTo is required");
                this.overwriteIfExists = builder.overwriteIfExists;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getRenameTo() {
                return this.renameTo;
            }

            @Override
            public final java.lang.Object getOverwriteIfExists() {
                return this.overwriteIfExists;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                data.set("renameTo", om.valueToTree(this.getRenameTo()));
                if (this.getOverwriteIfExists() != null) {
                    data.set("overwriteIfExists", om.valueToTree(this.getOverwriteIfExists()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.CfnTransformer.RenameKeyEntryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RenameKeyEntryProperty.Jsii$Proxy that = (RenameKeyEntryProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                if (!renameTo.equals(that.renameTo)) return false;
                return this.overwriteIfExists != null ? this.overwriteIfExists.equals(that.overwriteIfExists) : that.overwriteIfExists == null;
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.renameTo.hashCode());
                result = 31 * result + (this.overwriteIfExists != null ? this.overwriteIfExists.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Use this processor to rename keys in a log event.
     * <p>
     * For more information about this processor including examples, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-renameKeys">renameKeys</a> in the <em>CloudWatch Logs User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.logs.*;
     * RenameKeysProperty renameKeysProperty = RenameKeysProperty.builder()
     *         .entries(List.of(RenameKeyEntryProperty.builder()
     *                 .key("key")
     *                 .renameTo("renameTo")
     *                 // the properties below are optional
     *                 .overwriteIfExists(false)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-renamekeys.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-renamekeys.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.CfnTransformer.RenameKeysProperty")
    @software.amazon.jsii.Jsii.Proxy(RenameKeysProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RenameKeysProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An array of <code>RenameKeyEntry</code> objects, where each object contains the information about a single key to rename.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-renamekeys.html#cfn-logs-transformer-renamekeys-entries">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-renamekeys.html#cfn-logs-transformer-renamekeys-entries</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEntries();

        /**
         * @return a {@link Builder} of {@link RenameKeysProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RenameKeysProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RenameKeysProperty> {
            java.lang.Object entries;

            /**
             * Sets the value of {@link RenameKeysProperty#getEntries}
             * @param entries An array of <code>RenameKeyEntry</code> objects, where each object contains the information about a single key to rename. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder entries(software.amazon.awscdk.IResolvable entries) {
                this.entries = entries;
                return this;
            }

            /**
             * Sets the value of {@link RenameKeysProperty#getEntries}
             * @param entries An array of <code>RenameKeyEntry</code> objects, where each object contains the information about a single key to rename. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder entries(java.util.List<? extends java.lang.Object> entries) {
                this.entries = entries;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RenameKeysProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RenameKeysProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RenameKeysProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RenameKeysProperty {
            private final java.lang.Object entries;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.entries = software.amazon.jsii.Kernel.get(this, "entries", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.entries = java.util.Objects.requireNonNull(builder.entries, "entries is required");
            }

            @Override
            public final java.lang.Object getEntries() {
                return this.entries;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("entries", om.valueToTree(this.getEntries()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.CfnTransformer.RenameKeysProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RenameKeysProperty.Jsii$Proxy that = (RenameKeysProperty.Jsii$Proxy) o;

                return this.entries.equals(that.entries);
            }

            @Override
            public final int hashCode() {
                int result = this.entries.hashCode();
                return result;
            }
        }
    }
    /**
     * This object defines one log field that will be split with the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-splitString">splitString</a> processor.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.logs.*;
     * SplitStringEntryProperty splitStringEntryProperty = SplitStringEntryProperty.builder()
     *         .delimiter("delimiter")
     *         .source("source")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-splitstringentry.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-splitstringentry.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.CfnTransformer.SplitStringEntryProperty")
    @software.amazon.jsii.Jsii.Proxy(SplitStringEntryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SplitStringEntryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The separator characters to split the string entry on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-splitstringentry.html#cfn-logs-transformer-splitstringentry-delimiter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-splitstringentry.html#cfn-logs-transformer-splitstringentry-delimiter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDelimiter();

        /**
         * The key of the field to split.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-splitstringentry.html#cfn-logs-transformer-splitstringentry-source">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-splitstringentry.html#cfn-logs-transformer-splitstringentry-source</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSource();

        /**
         * @return a {@link Builder} of {@link SplitStringEntryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SplitStringEntryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SplitStringEntryProperty> {
            java.lang.String delimiter;
            java.lang.String source;

            /**
             * Sets the value of {@link SplitStringEntryProperty#getDelimiter}
             * @param delimiter The separator characters to split the string entry on. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder delimiter(java.lang.String delimiter) {
                this.delimiter = delimiter;
                return this;
            }

            /**
             * Sets the value of {@link SplitStringEntryProperty#getSource}
             * @param source The key of the field to split. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(java.lang.String source) {
                this.source = source;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SplitStringEntryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SplitStringEntryProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SplitStringEntryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SplitStringEntryProperty {
            private final java.lang.String delimiter;
            private final java.lang.String source;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.delimiter = software.amazon.jsii.Kernel.get(this, "delimiter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.delimiter = java.util.Objects.requireNonNull(builder.delimiter, "delimiter is required");
                this.source = java.util.Objects.requireNonNull(builder.source, "source is required");
            }

            @Override
            public final java.lang.String getDelimiter() {
                return this.delimiter;
            }

            @Override
            public final java.lang.String getSource() {
                return this.source;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("delimiter", om.valueToTree(this.getDelimiter()));
                data.set("source", om.valueToTree(this.getSource()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.CfnTransformer.SplitStringEntryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SplitStringEntryProperty.Jsii$Proxy that = (SplitStringEntryProperty.Jsii$Proxy) o;

                if (!delimiter.equals(that.delimiter)) return false;
                return this.source.equals(that.source);
            }

            @Override
            public final int hashCode() {
                int result = this.delimiter.hashCode();
                result = 31 * result + (this.source.hashCode());
                return result;
            }
        }
    }
    /**
     * Use this processor to split a field into an array of strings using a delimiting character.
     * <p>
     * For more information about this processor including examples, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-splitString">splitString</a> in the <em>CloudWatch Logs User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.logs.*;
     * SplitStringProperty splitStringProperty = SplitStringProperty.builder()
     *         .entries(List.of(SplitStringEntryProperty.builder()
     *                 .delimiter("delimiter")
     *                 .source("source")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-splitstring.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-splitstring.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.CfnTransformer.SplitStringProperty")
    @software.amazon.jsii.Jsii.Proxy(SplitStringProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SplitStringProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An array of <code>SplitStringEntry</code> objects, where each object contains the information about one field to split.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-splitstring.html#cfn-logs-transformer-splitstring-entries">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-splitstring.html#cfn-logs-transformer-splitstring-entries</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEntries();

        /**
         * @return a {@link Builder} of {@link SplitStringProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SplitStringProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SplitStringProperty> {
            java.lang.Object entries;

            /**
             * Sets the value of {@link SplitStringProperty#getEntries}
             * @param entries An array of <code>SplitStringEntry</code> objects, where each object contains the information about one field to split. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder entries(software.amazon.awscdk.IResolvable entries) {
                this.entries = entries;
                return this;
            }

            /**
             * Sets the value of {@link SplitStringProperty#getEntries}
             * @param entries An array of <code>SplitStringEntry</code> objects, where each object contains the information about one field to split. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder entries(java.util.List<? extends java.lang.Object> entries) {
                this.entries = entries;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SplitStringProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SplitStringProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SplitStringProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SplitStringProperty {
            private final java.lang.Object entries;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.entries = software.amazon.jsii.Kernel.get(this, "entries", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.entries = java.util.Objects.requireNonNull(builder.entries, "entries is required");
            }

            @Override
            public final java.lang.Object getEntries() {
                return this.entries;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("entries", om.valueToTree(this.getEntries()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.CfnTransformer.SplitStringProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SplitStringProperty.Jsii$Proxy that = (SplitStringProperty.Jsii$Proxy) o;

                return this.entries.equals(that.entries);
            }

            @Override
            public final int hashCode() {
                int result = this.entries.hashCode();
                return result;
            }
        }
    }
    /**
     * This object defines one log field key that will be replaced using the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-substituteString">substituteString</a> processor.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.logs.*;
     * SubstituteStringEntryProperty substituteStringEntryProperty = SubstituteStringEntryProperty.builder()
     *         .from("from")
     *         .source("source")
     *         .to("to")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-substitutestringentry.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-substitutestringentry.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.CfnTransformer.SubstituteStringEntryProperty")
    @software.amazon.jsii.Jsii.Proxy(SubstituteStringEntryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SubstituteStringEntryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The regular expression string to be replaced.
         * <p>
         * Special regex characters such as [ and ] must be escaped using \ when using double quotes and with \ when using single quotes. For more information, see <a href="https://docs.aws.amazon.com/https://docs.oracle.com/en/java/javase/17/docs/api/java.base/java/util/regex/Pattern.html">Class Pattern</a> on the Oracle web site.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-substitutestringentry.html#cfn-logs-transformer-substitutestringentry-from">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-substitutestringentry.html#cfn-logs-transformer-substitutestringentry-from</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFrom();

        /**
         * The key to modify.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-substitutestringentry.html#cfn-logs-transformer-substitutestringentry-source">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-substitutestringentry.html#cfn-logs-transformer-substitutestringentry-source</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSource();

        /**
         * The string to be substituted for each match of <code>from</code>.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-substitutestringentry.html#cfn-logs-transformer-substitutestringentry-to">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-substitutestringentry.html#cfn-logs-transformer-substitutestringentry-to</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTo();

        /**
         * @return a {@link Builder} of {@link SubstituteStringEntryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SubstituteStringEntryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SubstituteStringEntryProperty> {
            java.lang.String from;
            java.lang.String source;
            java.lang.String to;

            /**
             * Sets the value of {@link SubstituteStringEntryProperty#getFrom}
             * @param from The regular expression string to be replaced. This parameter is required.
             *             Special regex characters such as [ and ] must be escaped using \ when using double quotes and with \ when using single quotes. For more information, see <a href="https://docs.aws.amazon.com/https://docs.oracle.com/en/java/javase/17/docs/api/java.base/java/util/regex/Pattern.html">Class Pattern</a> on the Oracle web site.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder from(java.lang.String from) {
                this.from = from;
                return this;
            }

            /**
             * Sets the value of {@link SubstituteStringEntryProperty#getSource}
             * @param source The key to modify. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(java.lang.String source) {
                this.source = source;
                return this;
            }

            /**
             * Sets the value of {@link SubstituteStringEntryProperty#getTo}
             * @param to The string to be substituted for each match of <code>from</code>. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder to(java.lang.String to) {
                this.to = to;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SubstituteStringEntryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SubstituteStringEntryProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SubstituteStringEntryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SubstituteStringEntryProperty {
            private final java.lang.String from;
            private final java.lang.String source;
            private final java.lang.String to;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.from = software.amazon.jsii.Kernel.get(this, "from", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.to = software.amazon.jsii.Kernel.get(this, "to", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.from = java.util.Objects.requireNonNull(builder.from, "from is required");
                this.source = java.util.Objects.requireNonNull(builder.source, "source is required");
                this.to = java.util.Objects.requireNonNull(builder.to, "to is required");
            }

            @Override
            public final java.lang.String getFrom() {
                return this.from;
            }

            @Override
            public final java.lang.String getSource() {
                return this.source;
            }

            @Override
            public final java.lang.String getTo() {
                return this.to;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("from", om.valueToTree(this.getFrom()));
                data.set("source", om.valueToTree(this.getSource()));
                data.set("to", om.valueToTree(this.getTo()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.CfnTransformer.SubstituteStringEntryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SubstituteStringEntryProperty.Jsii$Proxy that = (SubstituteStringEntryProperty.Jsii$Proxy) o;

                if (!from.equals(that.from)) return false;
                if (!source.equals(that.source)) return false;
                return this.to.equals(that.to);
            }

            @Override
            public final int hashCode() {
                int result = this.from.hashCode();
                result = 31 * result + (this.source.hashCode());
                result = 31 * result + (this.to.hashCode());
                return result;
            }
        }
    }
    /**
     * This processor matches a key’s value against a regular expression and replaces all matches with a replacement string.
     * <p>
     * For more information about this processor including examples, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-substituteString">substituteString</a> in the <em>CloudWatch Logs User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.logs.*;
     * SubstituteStringProperty substituteStringProperty = SubstituteStringProperty.builder()
     *         .entries(List.of(SubstituteStringEntryProperty.builder()
     *                 .from("from")
     *                 .source("source")
     *                 .to("to")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-substitutestring.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-substitutestring.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.CfnTransformer.SubstituteStringProperty")
    @software.amazon.jsii.Jsii.Proxy(SubstituteStringProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SubstituteStringProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An array of objects, where each object contains the information about one key to match and replace.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-substitutestring.html#cfn-logs-transformer-substitutestring-entries">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-substitutestring.html#cfn-logs-transformer-substitutestring-entries</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEntries();

        /**
         * @return a {@link Builder} of {@link SubstituteStringProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SubstituteStringProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SubstituteStringProperty> {
            java.lang.Object entries;

            /**
             * Sets the value of {@link SubstituteStringProperty#getEntries}
             * @param entries An array of objects, where each object contains the information about one key to match and replace. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder entries(software.amazon.awscdk.IResolvable entries) {
                this.entries = entries;
                return this;
            }

            /**
             * Sets the value of {@link SubstituteStringProperty#getEntries}
             * @param entries An array of objects, where each object contains the information about one key to match and replace. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder entries(java.util.List<? extends java.lang.Object> entries) {
                this.entries = entries;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SubstituteStringProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SubstituteStringProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SubstituteStringProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SubstituteStringProperty {
            private final java.lang.Object entries;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.entries = software.amazon.jsii.Kernel.get(this, "entries", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.entries = java.util.Objects.requireNonNull(builder.entries, "entries is required");
            }

            @Override
            public final java.lang.Object getEntries() {
                return this.entries;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("entries", om.valueToTree(this.getEntries()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.CfnTransformer.SubstituteStringProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SubstituteStringProperty.Jsii$Proxy that = (SubstituteStringProperty.Jsii$Proxy) o;

                return this.entries.equals(that.entries);
            }

            @Override
            public final int hashCode() {
                int result = this.entries.hashCode();
                return result;
            }
        }
    }
    /**
     * Use this processor to remove leading and trailing whitespace.
     * <p>
     * For more information about this processor including examples, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-trimString">trimString</a> in the <em>CloudWatch Logs User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.logs.*;
     * TrimStringProperty trimStringProperty = TrimStringProperty.builder()
     *         .withKeys(List.of("withKeys"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-trimstring.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-trimstring.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.CfnTransformer.TrimStringProperty")
    @software.amazon.jsii.Jsii.Proxy(TrimStringProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TrimStringProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The array containing the keys of the fields to trim.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-trimstring.html#cfn-logs-transformer-trimstring-withkeys">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-trimstring.html#cfn-logs-transformer-trimstring-withkeys</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getWithKeys();

        /**
         * @return a {@link Builder} of {@link TrimStringProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TrimStringProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TrimStringProperty> {
            java.util.List<java.lang.String> withKeys;

            /**
             * Sets the value of {@link TrimStringProperty#getWithKeys}
             * @param withKeys The array containing the keys of the fields to trim. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withKeys(java.util.List<java.lang.String> withKeys) {
                this.withKeys = withKeys;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TrimStringProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TrimStringProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TrimStringProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TrimStringProperty {
            private final java.util.List<java.lang.String> withKeys;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.withKeys = software.amazon.jsii.Kernel.get(this, "withKeys", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.withKeys = java.util.Objects.requireNonNull(builder.withKeys, "withKeys is required");
            }

            @Override
            public final java.util.List<java.lang.String> getWithKeys() {
                return this.withKeys;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("withKeys", om.valueToTree(this.getWithKeys()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.CfnTransformer.TrimStringProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TrimStringProperty.Jsii$Proxy that = (TrimStringProperty.Jsii$Proxy) o;

                return this.withKeys.equals(that.withKeys);
            }

            @Override
            public final int hashCode() {
                int result = this.withKeys.hashCode();
                return result;
            }
        }
    }
    /**
     * This object defines one value type that will be converted using the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-typeConverter">typeConverter</a> processor.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.logs.*;
     * TypeConverterEntryProperty typeConverterEntryProperty = TypeConverterEntryProperty.builder()
     *         .key("key")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-typeconverterentry.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-typeconverterentry.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.CfnTransformer.TypeConverterEntryProperty")
    @software.amazon.jsii.Jsii.Proxy(TypeConverterEntryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TypeConverterEntryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The key with the value that is to be converted to a different type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-typeconverterentry.html#cfn-logs-transformer-typeconverterentry-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-typeconverterentry.html#cfn-logs-transformer-typeconverterentry-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * The type to convert the field value to.
         * <p>
         * Valid values are <code>integer</code> , <code>double</code> , <code>string</code> and <code>boolean</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-typeconverterentry.html#cfn-logs-transformer-typeconverterentry-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-typeconverterentry.html#cfn-logs-transformer-typeconverterentry-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link TypeConverterEntryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TypeConverterEntryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TypeConverterEntryProperty> {
            java.lang.String key;
            java.lang.String type;

            /**
             * Sets the value of {@link TypeConverterEntryProperty#getKey}
             * @param key The key with the value that is to be converted to a different type. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link TypeConverterEntryProperty#getType}
             * @param type The type to convert the field value to. This parameter is required.
             *             Valid values are <code>integer</code> , <code>double</code> , <code>string</code> and <code>boolean</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TypeConverterEntryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TypeConverterEntryProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TypeConverterEntryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TypeConverterEntryProperty {
            private final java.lang.String key;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.CfnTransformer.TypeConverterEntryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TypeConverterEntryProperty.Jsii$Proxy that = (TypeConverterEntryProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }
    /**
     * Use this processor to convert a value type associated with the specified key to the specified type.
     * <p>
     * It's a casting processor that changes the types of the specified fields. Values can be converted into one of the following datatypes: <code>integer</code> , <code>double</code> , <code>string</code> and <code>boolean</code> .
     * <p>
     * For more information about this processor including examples, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-trimString">trimString</a> in the <em>CloudWatch Logs User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.logs.*;
     * TypeConverterProperty typeConverterProperty = TypeConverterProperty.builder()
     *         .entries(List.of(TypeConverterEntryProperty.builder()
     *                 .key("key")
     *                 .type("type")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-typeconverter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-typeconverter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.CfnTransformer.TypeConverterProperty")
    @software.amazon.jsii.Jsii.Proxy(TypeConverterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TypeConverterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An array of <code>TypeConverterEntry</code> objects, where each object contains the information about one field to change the type of.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-typeconverter.html#cfn-logs-transformer-typeconverter-entries">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-typeconverter.html#cfn-logs-transformer-typeconverter-entries</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEntries();

        /**
         * @return a {@link Builder} of {@link TypeConverterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TypeConverterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TypeConverterProperty> {
            java.lang.Object entries;

            /**
             * Sets the value of {@link TypeConverterProperty#getEntries}
             * @param entries An array of <code>TypeConverterEntry</code> objects, where each object contains the information about one field to change the type of. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder entries(software.amazon.awscdk.IResolvable entries) {
                this.entries = entries;
                return this;
            }

            /**
             * Sets the value of {@link TypeConverterProperty#getEntries}
             * @param entries An array of <code>TypeConverterEntry</code> objects, where each object contains the information about one field to change the type of. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder entries(java.util.List<? extends java.lang.Object> entries) {
                this.entries = entries;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TypeConverterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TypeConverterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TypeConverterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TypeConverterProperty {
            private final java.lang.Object entries;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.entries = software.amazon.jsii.Kernel.get(this, "entries", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.entries = java.util.Objects.requireNonNull(builder.entries, "entries is required");
            }

            @Override
            public final java.lang.Object getEntries() {
                return this.entries;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("entries", om.valueToTree(this.getEntries()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.CfnTransformer.TypeConverterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TypeConverterProperty.Jsii$Proxy that = (TypeConverterProperty.Jsii$Proxy) o;

                return this.entries.equals(that.entries);
            }

            @Override
            public final int hashCode() {
                int result = this.entries.hashCode();
                return result;
            }
        }
    }
    /**
     * This processor converts a string field to uppercase.
     * <p>
     * For more information about this processor including examples, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation-Processors.html#CloudWatch-Logs-Transformation-upperCaseString">upperCaseString</a> in the <em>CloudWatch Logs User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.logs.*;
     * UpperCaseStringProperty upperCaseStringProperty = UpperCaseStringProperty.builder()
     *         .withKeys(List.of("withKeys"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-uppercasestring.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-uppercasestring.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.CfnTransformer.UpperCaseStringProperty")
    @software.amazon.jsii.Jsii.Proxy(UpperCaseStringProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface UpperCaseStringProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The array of containing the keys of the field to convert to uppercase.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-uppercasestring.html#cfn-logs-transformer-uppercasestring-withkeys">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-transformer-uppercasestring.html#cfn-logs-transformer-uppercasestring-withkeys</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getWithKeys();

        /**
         * @return a {@link Builder} of {@link UpperCaseStringProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link UpperCaseStringProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<UpperCaseStringProperty> {
            java.util.List<java.lang.String> withKeys;

            /**
             * Sets the value of {@link UpperCaseStringProperty#getWithKeys}
             * @param withKeys The array of containing the keys of the field to convert to uppercase. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder withKeys(java.util.List<java.lang.String> withKeys) {
                this.withKeys = withKeys;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link UpperCaseStringProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public UpperCaseStringProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link UpperCaseStringProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UpperCaseStringProperty {
            private final java.util.List<java.lang.String> withKeys;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.withKeys = software.amazon.jsii.Kernel.get(this, "withKeys", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.withKeys = java.util.Objects.requireNonNull(builder.withKeys, "withKeys is required");
            }

            @Override
            public final java.util.List<java.lang.String> getWithKeys() {
                return this.withKeys;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("withKeys", om.valueToTree(this.getWithKeys()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.CfnTransformer.UpperCaseStringProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                UpperCaseStringProperty.Jsii$Proxy that = (UpperCaseStringProperty.Jsii$Proxy) o;

                return this.withKeys.equals(that.withKeys);
            }

            @Override
            public final int hashCode() {
                int result = this.withKeys.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.logs.CfnTransformer}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.logs.CfnTransformer> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.logs.CfnTransformerProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.logs.CfnTransformerProps.Builder();
        }

        /**
         * Specify either the name or ARN of the log group to create the transformer for.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-transformer.html#cfn-logs-transformer-loggroupidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-transformer.html#cfn-logs-transformer-loggroupidentifier</a>
         * @param logGroupIdentifier Specify either the name or ARN of the log group to create the transformer for. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logGroupIdentifier(final java.lang.String logGroupIdentifier) {
            this.props.logGroupIdentifier(logGroupIdentifier);
            return this;
        }

        /**
         * This structure is an array that contains the configuration of this log transformer.
         * <p>
         * A log transformer is an array of processors, where each processor applies one type of transformation to the log events that are ingested.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-transformer.html#cfn-logs-transformer-transformerconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-transformer.html#cfn-logs-transformer-transformerconfig</a>
         * @param transformerConfig This structure is an array that contains the configuration of this log transformer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transformerConfig(final software.amazon.awscdk.IResolvable transformerConfig) {
            this.props.transformerConfig(transformerConfig);
            return this;
        }
        /**
         * This structure is an array that contains the configuration of this log transformer.
         * <p>
         * A log transformer is an array of processors, where each processor applies one type of transformation to the log events that are ingested.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-transformer.html#cfn-logs-transformer-transformerconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-transformer.html#cfn-logs-transformer-transformerconfig</a>
         * @param transformerConfig This structure is an array that contains the configuration of this log transformer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transformerConfig(final java.util.List<? extends java.lang.Object> transformerConfig) {
            this.props.transformerConfig(transformerConfig);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.logs.CfnTransformer}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.logs.CfnTransformer build() {
            return new software.amazon.awscdk.services.logs.CfnTransformer(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
