package software.amazon.awscdk.services.logs;

/**
 * Properties for a QueryString.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * QueryDefinition.Builder.create(this, "QueryDefinition")
 *         .queryDefinitionName("MyQuery")
 *         .queryString(QueryString.Builder.create()
 *                 .fields(List.of("&#64;timestamp", "&#64;message"))
 *                 .parseStatements(List.of("&#64;message \"[*] *\" as loggingType, loggingMessage", "&#64;message \"&lt;*&gt;: *\" as differentLoggingType, differentLoggingMessage"))
 *                 .filterStatements(List.of("loggingType = \"ERROR\"", "loggingMessage = \"A very strange error occurred!\""))
 *                 .sort("&#64;timestamp desc")
 *                 .limit(20)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:25:01.032Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.QueryStringProps")
@software.amazon.jsii.Jsii.Proxy(QueryStringProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface QueryStringProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies which fields to display in the query results.
     * <p>
     * Default: - no display in QueryString
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDisplay() {
        return null;
    }

    /**
     * Retrieves the specified fields from log events for display.
     * <p>
     * Default: - no fields in QueryString
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getFields() {
        return null;
    }

    /**
     * (deprecated) A single statement for filtering the results of a query based on a boolean expression.
     * <p>
     * Default: - no filter in QueryString
     * <p>
     * @deprecated Use <code>filterStatements</code> instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.String getFilter() {
        return null;
    }

    /**
     * An array of one or more statements for filtering the results of a query based on a boolean expression.
     * <p>
     * Each provided statement generates a separate filter line in the query string.
     * <p>
     * Note: If provided, this property overrides any value provided for the <code>filter</code> property.
     * <p>
     * Default: - no filter in QueryString
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getFilterStatements() {
        return null;
    }

    /**
     * Specifies the number of log events returned by the query.
     * <p>
     * Default: - no limit in QueryString
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getLimit() {
        return null;
    }

    /**
     * (deprecated) A single statement for parsing data from a log field and creating ephemeral fields that can be processed further in the query.
     * <p>
     * Default: - no parse in QueryString
     * <p>
     * @deprecated Use <code>parseStatements</code> instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.String getParse() {
        return null;
    }

    /**
     * An array of one or more statements for parsing data from a log field and creating ephemeral fields that can be processed further in the query.
     * <p>
     * Each provided statement generates a separate
     * parse line in the query string.
     * <p>
     * Note: If provided, this property overrides any value provided for the <code>parse</code> property.
     * <p>
     * Default: - no parse in QueryString
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getParseStatements() {
        return null;
    }

    /**
     * Sorts the retrieved log events.
     * <p>
     * Default: - no sort in QueryString
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSort() {
        return null;
    }

    /**
     * Uses log field values to calculate aggregate statistics.
     * <p>
     * Default: - no stats in QueryString
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStats() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link QueryStringProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link QueryStringProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<QueryStringProps> {
        java.lang.String display;
        java.util.List<java.lang.String> fields;
        java.lang.String filter;
        java.util.List<java.lang.String> filterStatements;
        java.lang.Number limit;
        java.lang.String parse;
        java.util.List<java.lang.String> parseStatements;
        java.lang.String sort;
        java.lang.String stats;

        /**
         * Sets the value of {@link QueryStringProps#getDisplay}
         * @param display Specifies which fields to display in the query results.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder display(java.lang.String display) {
            this.display = display;
            return this;
        }

        /**
         * Sets the value of {@link QueryStringProps#getFields}
         * @param fields Retrieves the specified fields from log events for display.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fields(java.util.List<java.lang.String> fields) {
            this.fields = fields;
            return this;
        }

        /**
         * Sets the value of {@link QueryStringProps#getFilter}
         * @param filter A single statement for filtering the results of a query based on a boolean expression.
         * @return {@code this}
         * @deprecated Use `filterStatements` instead
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder filter(java.lang.String filter) {
            this.filter = filter;
            return this;
        }

        /**
         * Sets the value of {@link QueryStringProps#getFilterStatements}
         * @param filterStatements An array of one or more statements for filtering the results of a query based on a boolean expression.
         *                         Each provided statement generates a separate filter line in the query string.
         *                         <p>
         *                         Note: If provided, this property overrides any value provided for the <code>filter</code> property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterStatements(java.util.List<java.lang.String> filterStatements) {
            this.filterStatements = filterStatements;
            return this;
        }

        /**
         * Sets the value of {@link QueryStringProps#getLimit}
         * @param limit Specifies the number of log events returned by the query.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder limit(java.lang.Number limit) {
            this.limit = limit;
            return this;
        }

        /**
         * Sets the value of {@link QueryStringProps#getParse}
         * @param parse A single statement for parsing data from a log field and creating ephemeral fields that can be processed further in the query.
         * @return {@code this}
         * @deprecated Use `parseStatements` instead
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder parse(java.lang.String parse) {
            this.parse = parse;
            return this;
        }

        /**
         * Sets the value of {@link QueryStringProps#getParseStatements}
         * @param parseStatements An array of one or more statements for parsing data from a log field and creating ephemeral fields that can be processed further in the query.
         *                        Each provided statement generates a separate
         *                        parse line in the query string.
         *                        <p>
         *                        Note: If provided, this property overrides any value provided for the <code>parse</code> property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parseStatements(java.util.List<java.lang.String> parseStatements) {
            this.parseStatements = parseStatements;
            return this;
        }

        /**
         * Sets the value of {@link QueryStringProps#getSort}
         * @param sort Sorts the retrieved log events.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sort(java.lang.String sort) {
            this.sort = sort;
            return this;
        }

        /**
         * Sets the value of {@link QueryStringProps#getStats}
         * @param stats Uses log field values to calculate aggregate statistics.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stats(java.lang.String stats) {
            this.stats = stats;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link QueryStringProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public QueryStringProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link QueryStringProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements QueryStringProps {
        private final java.lang.String display;
        private final java.util.List<java.lang.String> fields;
        private final java.lang.String filter;
        private final java.util.List<java.lang.String> filterStatements;
        private final java.lang.Number limit;
        private final java.lang.String parse;
        private final java.util.List<java.lang.String> parseStatements;
        private final java.lang.String sort;
        private final java.lang.String stats;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.display = software.amazon.jsii.Kernel.get(this, "display", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.fields = software.amazon.jsii.Kernel.get(this, "fields", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.filter = software.amazon.jsii.Kernel.get(this, "filter", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.filterStatements = software.amazon.jsii.Kernel.get(this, "filterStatements", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.limit = software.amazon.jsii.Kernel.get(this, "limit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.parse = software.amazon.jsii.Kernel.get(this, "parse", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.parseStatements = software.amazon.jsii.Kernel.get(this, "parseStatements", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.sort = software.amazon.jsii.Kernel.get(this, "sort", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.stats = software.amazon.jsii.Kernel.get(this, "stats", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.display = builder.display;
            this.fields = builder.fields;
            this.filter = builder.filter;
            this.filterStatements = builder.filterStatements;
            this.limit = builder.limit;
            this.parse = builder.parse;
            this.parseStatements = builder.parseStatements;
            this.sort = builder.sort;
            this.stats = builder.stats;
        }

        @Override
        public final java.lang.String getDisplay() {
            return this.display;
        }

        @Override
        public final java.util.List<java.lang.String> getFields() {
            return this.fields;
        }

        @Override
        public final java.lang.String getFilter() {
            return this.filter;
        }

        @Override
        public final java.util.List<java.lang.String> getFilterStatements() {
            return this.filterStatements;
        }

        @Override
        public final java.lang.Number getLimit() {
            return this.limit;
        }

        @Override
        public final java.lang.String getParse() {
            return this.parse;
        }

        @Override
        public final java.util.List<java.lang.String> getParseStatements() {
            return this.parseStatements;
        }

        @Override
        public final java.lang.String getSort() {
            return this.sort;
        }

        @Override
        public final java.lang.String getStats() {
            return this.stats;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDisplay() != null) {
                data.set("display", om.valueToTree(this.getDisplay()));
            }
            if (this.getFields() != null) {
                data.set("fields", om.valueToTree(this.getFields()));
            }
            if (this.getFilter() != null) {
                data.set("filter", om.valueToTree(this.getFilter()));
            }
            if (this.getFilterStatements() != null) {
                data.set("filterStatements", om.valueToTree(this.getFilterStatements()));
            }
            if (this.getLimit() != null) {
                data.set("limit", om.valueToTree(this.getLimit()));
            }
            if (this.getParse() != null) {
                data.set("parse", om.valueToTree(this.getParse()));
            }
            if (this.getParseStatements() != null) {
                data.set("parseStatements", om.valueToTree(this.getParseStatements()));
            }
            if (this.getSort() != null) {
                data.set("sort", om.valueToTree(this.getSort()));
            }
            if (this.getStats() != null) {
                data.set("stats", om.valueToTree(this.getStats()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.QueryStringProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            QueryStringProps.Jsii$Proxy that = (QueryStringProps.Jsii$Proxy) o;

            if (this.display != null ? !this.display.equals(that.display) : that.display != null) return false;
            if (this.fields != null ? !this.fields.equals(that.fields) : that.fields != null) return false;
            if (this.filter != null ? !this.filter.equals(that.filter) : that.filter != null) return false;
            if (this.filterStatements != null ? !this.filterStatements.equals(that.filterStatements) : that.filterStatements != null) return false;
            if (this.limit != null ? !this.limit.equals(that.limit) : that.limit != null) return false;
            if (this.parse != null ? !this.parse.equals(that.parse) : that.parse != null) return false;
            if (this.parseStatements != null ? !this.parseStatements.equals(that.parseStatements) : that.parseStatements != null) return false;
            if (this.sort != null ? !this.sort.equals(that.sort) : that.sort != null) return false;
            return this.stats != null ? this.stats.equals(that.stats) : that.stats == null;
        }

        @Override
        public final int hashCode() {
            int result = this.display != null ? this.display.hashCode() : 0;
            result = 31 * result + (this.fields != null ? this.fields.hashCode() : 0);
            result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
            result = 31 * result + (this.filterStatements != null ? this.filterStatements.hashCode() : 0);
            result = 31 * result + (this.limit != null ? this.limit.hashCode() : 0);
            result = 31 * result + (this.parse != null ? this.parse.hashCode() : 0);
            result = 31 * result + (this.parseStatements != null ? this.parseStatements.hashCode() : 0);
            result = 31 * result + (this.sort != null ? this.sort.hashCode() : 0);
            result = 31 * result + (this.stats != null ? this.stats.hashCode() : 0);
            return result;
        }
    }
}
