package software.amazon.awscdk.services.medialive;

/**
 * Resource schema for AWS::MediaLive::Multiplexprogram.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.medialive.*;
 * CfnMultiplexprogram cfnMultiplexprogram = CfnMultiplexprogram.Builder.create(this, "MyCfnMultiplexprogram")
 *         .multiplexId("multiplexId")
 *         .multiplexProgramSettings(MultiplexProgramSettingsProperty.builder()
 *                 .programNumber(123)
 *                 // the properties below are optional
 *                 .preferredChannelPipeline("preferredChannelPipeline")
 *                 .serviceDescriptor(MultiplexProgramServiceDescriptorProperty.builder()
 *                         .providerName("providerName")
 *                         .serviceName("serviceName")
 *                         .build())
 *                 .videoSettings(MultiplexVideoSettingsProperty.builder()
 *                         .constantBitrate(123)
 *                         .statmuxSettings(MultiplexStatmuxVideoSettingsProperty.builder()
 *                                 .maximumBitrate(123)
 *                                 .minimumBitrate(123)
 *                                 .priority(123)
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .packetIdentifiersMap(MultiplexProgramPacketIdentifiersMapProperty.builder()
 *                 .audioPids(List.of(123))
 *                 .dvbSubPids(List.of(123))
 *                 .dvbTeletextPid(123)
 *                 .etvPlatformPid(123)
 *                 .etvSignalPid(123)
 *                 .klvDataPids(List.of(123))
 *                 .pcrPid(123)
 *                 .pmtPid(123)
 *                 .privateMetadataPid(123)
 *                 .scte27Pids(List.of(123))
 *                 .scte35Pid(123)
 *                 .timedMetadataPid(123)
 *                 .videoPid(123)
 *                 .build())
 *         .pipelineDetails(List.of(MultiplexProgramPipelineDetailProperty.builder()
 *                 .activeChannelPipeline("activeChannelPipeline")
 *                 .pipelineId("pipelineId")
 *                 .build()))
 *         .preferredChannelPipeline("preferredChannelPipeline")
 *         .programName("programName")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-multiplexprogram.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-multiplexprogram.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:25:01.351Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnMultiplexprogram")
public class CfnMultiplexprogram extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnMultiplexprogram(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnMultiplexprogram(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.medialive.CfnMultiplexprogram.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnMultiplexprogram(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.medialive.CfnMultiplexprogramProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnMultiplexprogram(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The unique ID of the channel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrChannelId() {
        return software.amazon.jsii.Kernel.get(this, "attrChannelId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The unique id of the multiplex.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getMultiplexId() {
        return software.amazon.jsii.Kernel.get(this, "multiplexId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique id of the multiplex.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMultiplexId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "multiplexId", value);
    }

    /**
     * Multiplex Program settings configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMultiplexProgramSettings() {
        return software.amazon.jsii.Kernel.get(this, "multiplexProgramSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Multiplex Program settings configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMultiplexProgramSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "multiplexProgramSettings", value);
    }

    /**
     * Multiplex Program settings configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMultiplexProgramSettings(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.medialive.CfnMultiplexprogram.MultiplexProgramSettingsProperty value) {
        software.amazon.jsii.Kernel.set(this, "multiplexProgramSettings", value);
    }

    /**
     * Packet identifiers map for a given Multiplex program.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPacketIdentifiersMap() {
        return software.amazon.jsii.Kernel.get(this, "packetIdentifiersMap", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Packet identifiers map for a given Multiplex program.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPacketIdentifiersMap(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "packetIdentifiersMap", value);
    }

    /**
     * Packet identifiers map for a given Multiplex program.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPacketIdentifiersMap(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.medialive.CfnMultiplexprogram.MultiplexProgramPacketIdentifiersMapProperty value) {
        software.amazon.jsii.Kernel.set(this, "packetIdentifiersMap", value);
    }

    /**
     * Contains information about the current sources for the specified program in the specified multiplex.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPipelineDetails() {
        return software.amazon.jsii.Kernel.get(this, "pipelineDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Contains information about the current sources for the specified program in the specified multiplex.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPipelineDetails(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "pipelineDetails", value);
    }

    /**
     * Contains information about the current sources for the specified program in the specified multiplex.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPipelineDetails(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.medialive.CfnMultiplexprogram.MultiplexProgramPipelineDetailProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.medialive.CfnMultiplexprogram.MultiplexProgramPipelineDetailProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "pipelineDetails", value);
    }

    /**
     * Indicates which pipeline is preferred by the multiplex for program ingest.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPreferredChannelPipeline() {
        return software.amazon.jsii.Kernel.get(this, "preferredChannelPipeline", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Indicates which pipeline is preferred by the multiplex for program ingest.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPreferredChannelPipeline(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "preferredChannelPipeline", value);
    }

    /**
     * The name of the multiplex program.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getProgramName() {
        return software.amazon.jsii.Kernel.get(this, "programName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the multiplex program.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProgramName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "programName", value);
    }
    /**
     * Packet identifiers map for a given Multiplex program.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * MultiplexProgramPacketIdentifiersMapProperty multiplexProgramPacketIdentifiersMapProperty = MultiplexProgramPacketIdentifiersMapProperty.builder()
     *         .audioPids(List.of(123))
     *         .dvbSubPids(List.of(123))
     *         .dvbTeletextPid(123)
     *         .etvPlatformPid(123)
     *         .etvSignalPid(123)
     *         .klvDataPids(List.of(123))
     *         .pcrPid(123)
     *         .pmtPid(123)
     *         .privateMetadataPid(123)
     *         .scte27Pids(List.of(123))
     *         .scte35Pid(123)
     *         .timedMetadataPid(123)
     *         .videoPid(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnMultiplexprogram.MultiplexProgramPacketIdentifiersMapProperty")
    @software.amazon.jsii.Jsii.Proxy(MultiplexProgramPacketIdentifiersMapProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MultiplexProgramPacketIdentifiersMapProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap.html#cfn-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap-audiopids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap.html#cfn-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap-audiopids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAudioPids() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap.html#cfn-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap-dvbsubpids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap.html#cfn-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap-dvbsubpids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDvbSubPids() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap.html#cfn-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap-dvbteletextpid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap.html#cfn-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap-dvbteletextpid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDvbTeletextPid() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap.html#cfn-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap-etvplatformpid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap.html#cfn-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap-etvplatformpid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getEtvPlatformPid() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap.html#cfn-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap-etvsignalpid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap.html#cfn-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap-etvsignalpid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getEtvSignalPid() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap.html#cfn-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap-klvdatapids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap.html#cfn-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap-klvdatapids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKlvDataPids() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap.html#cfn-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap-pcrpid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap.html#cfn-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap-pcrpid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPcrPid() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap.html#cfn-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap-pmtpid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap.html#cfn-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap-pmtpid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPmtPid() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap.html#cfn-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap-privatemetadatapid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap.html#cfn-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap-privatemetadatapid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPrivateMetadataPid() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap.html#cfn-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap-scte27pids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap.html#cfn-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap-scte27pids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getScte27Pids() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap.html#cfn-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap-scte35pid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap.html#cfn-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap-scte35pid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getScte35Pid() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap.html#cfn-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap-timedmetadatapid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap.html#cfn-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap-timedmetadatapid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTimedMetadataPid() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap.html#cfn-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap-videopid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap.html#cfn-medialive-multiplexprogram-multiplexprogrampacketidentifiersmap-videopid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getVideoPid() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MultiplexProgramPacketIdentifiersMapProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MultiplexProgramPacketIdentifiersMapProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MultiplexProgramPacketIdentifiersMapProperty> {
            java.lang.Object audioPids;
            java.lang.Object dvbSubPids;
            java.lang.Number dvbTeletextPid;
            java.lang.Number etvPlatformPid;
            java.lang.Number etvSignalPid;
            java.lang.Object klvDataPids;
            java.lang.Number pcrPid;
            java.lang.Number pmtPid;
            java.lang.Number privateMetadataPid;
            java.lang.Object scte27Pids;
            java.lang.Number scte35Pid;
            java.lang.Number timedMetadataPid;
            java.lang.Number videoPid;

            /**
             * Sets the value of {@link MultiplexProgramPacketIdentifiersMapProperty#getAudioPids}
             * @param audioPids the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioPids(java.util.List<? extends java.lang.Number> audioPids) {
                this.audioPids = audioPids;
                return this;
            }

            /**
             * Sets the value of {@link MultiplexProgramPacketIdentifiersMapProperty#getAudioPids}
             * @param audioPids the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audioPids(software.amazon.awscdk.IResolvable audioPids) {
                this.audioPids = audioPids;
                return this;
            }

            /**
             * Sets the value of {@link MultiplexProgramPacketIdentifiersMapProperty#getDvbSubPids}
             * @param dvbSubPids the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dvbSubPids(java.util.List<? extends java.lang.Number> dvbSubPids) {
                this.dvbSubPids = dvbSubPids;
                return this;
            }

            /**
             * Sets the value of {@link MultiplexProgramPacketIdentifiersMapProperty#getDvbSubPids}
             * @param dvbSubPids the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dvbSubPids(software.amazon.awscdk.IResolvable dvbSubPids) {
                this.dvbSubPids = dvbSubPids;
                return this;
            }

            /**
             * Sets the value of {@link MultiplexProgramPacketIdentifiersMapProperty#getDvbTeletextPid}
             * @param dvbTeletextPid the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dvbTeletextPid(java.lang.Number dvbTeletextPid) {
                this.dvbTeletextPid = dvbTeletextPid;
                return this;
            }

            /**
             * Sets the value of {@link MultiplexProgramPacketIdentifiersMapProperty#getEtvPlatformPid}
             * @param etvPlatformPid the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder etvPlatformPid(java.lang.Number etvPlatformPid) {
                this.etvPlatformPid = etvPlatformPid;
                return this;
            }

            /**
             * Sets the value of {@link MultiplexProgramPacketIdentifiersMapProperty#getEtvSignalPid}
             * @param etvSignalPid the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder etvSignalPid(java.lang.Number etvSignalPid) {
                this.etvSignalPid = etvSignalPid;
                return this;
            }

            /**
             * Sets the value of {@link MultiplexProgramPacketIdentifiersMapProperty#getKlvDataPids}
             * @param klvDataPids the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder klvDataPids(java.util.List<? extends java.lang.Number> klvDataPids) {
                this.klvDataPids = klvDataPids;
                return this;
            }

            /**
             * Sets the value of {@link MultiplexProgramPacketIdentifiersMapProperty#getKlvDataPids}
             * @param klvDataPids the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder klvDataPids(software.amazon.awscdk.IResolvable klvDataPids) {
                this.klvDataPids = klvDataPids;
                return this;
            }

            /**
             * Sets the value of {@link MultiplexProgramPacketIdentifiersMapProperty#getPcrPid}
             * @param pcrPid the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pcrPid(java.lang.Number pcrPid) {
                this.pcrPid = pcrPid;
                return this;
            }

            /**
             * Sets the value of {@link MultiplexProgramPacketIdentifiersMapProperty#getPmtPid}
             * @param pmtPid the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pmtPid(java.lang.Number pmtPid) {
                this.pmtPid = pmtPid;
                return this;
            }

            /**
             * Sets the value of {@link MultiplexProgramPacketIdentifiersMapProperty#getPrivateMetadataPid}
             * @param privateMetadataPid the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privateMetadataPid(java.lang.Number privateMetadataPid) {
                this.privateMetadataPid = privateMetadataPid;
                return this;
            }

            /**
             * Sets the value of {@link MultiplexProgramPacketIdentifiersMapProperty#getScte27Pids}
             * @param scte27Pids the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scte27Pids(java.util.List<? extends java.lang.Number> scte27Pids) {
                this.scte27Pids = scte27Pids;
                return this;
            }

            /**
             * Sets the value of {@link MultiplexProgramPacketIdentifiersMapProperty#getScte27Pids}
             * @param scte27Pids the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scte27Pids(software.amazon.awscdk.IResolvable scte27Pids) {
                this.scte27Pids = scte27Pids;
                return this;
            }

            /**
             * Sets the value of {@link MultiplexProgramPacketIdentifiersMapProperty#getScte35Pid}
             * @param scte35Pid the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scte35Pid(java.lang.Number scte35Pid) {
                this.scte35Pid = scte35Pid;
                return this;
            }

            /**
             * Sets the value of {@link MultiplexProgramPacketIdentifiersMapProperty#getTimedMetadataPid}
             * @param timedMetadataPid the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timedMetadataPid(java.lang.Number timedMetadataPid) {
                this.timedMetadataPid = timedMetadataPid;
                return this;
            }

            /**
             * Sets the value of {@link MultiplexProgramPacketIdentifiersMapProperty#getVideoPid}
             * @param videoPid the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder videoPid(java.lang.Number videoPid) {
                this.videoPid = videoPid;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MultiplexProgramPacketIdentifiersMapProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MultiplexProgramPacketIdentifiersMapProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MultiplexProgramPacketIdentifiersMapProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MultiplexProgramPacketIdentifiersMapProperty {
            private final java.lang.Object audioPids;
            private final java.lang.Object dvbSubPids;
            private final java.lang.Number dvbTeletextPid;
            private final java.lang.Number etvPlatformPid;
            private final java.lang.Number etvSignalPid;
            private final java.lang.Object klvDataPids;
            private final java.lang.Number pcrPid;
            private final java.lang.Number pmtPid;
            private final java.lang.Number privateMetadataPid;
            private final java.lang.Object scte27Pids;
            private final java.lang.Number scte35Pid;
            private final java.lang.Number timedMetadataPid;
            private final java.lang.Number videoPid;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.audioPids = software.amazon.jsii.Kernel.get(this, "audioPids", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dvbSubPids = software.amazon.jsii.Kernel.get(this, "dvbSubPids", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dvbTeletextPid = software.amazon.jsii.Kernel.get(this, "dvbTeletextPid", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.etvPlatformPid = software.amazon.jsii.Kernel.get(this, "etvPlatformPid", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.etvSignalPid = software.amazon.jsii.Kernel.get(this, "etvSignalPid", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.klvDataPids = software.amazon.jsii.Kernel.get(this, "klvDataPids", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.pcrPid = software.amazon.jsii.Kernel.get(this, "pcrPid", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.pmtPid = software.amazon.jsii.Kernel.get(this, "pmtPid", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.privateMetadataPid = software.amazon.jsii.Kernel.get(this, "privateMetadataPid", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.scte27Pids = software.amazon.jsii.Kernel.get(this, "scte27Pids", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.scte35Pid = software.amazon.jsii.Kernel.get(this, "scte35Pid", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.timedMetadataPid = software.amazon.jsii.Kernel.get(this, "timedMetadataPid", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.videoPid = software.amazon.jsii.Kernel.get(this, "videoPid", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.audioPids = builder.audioPids;
                this.dvbSubPids = builder.dvbSubPids;
                this.dvbTeletextPid = builder.dvbTeletextPid;
                this.etvPlatformPid = builder.etvPlatformPid;
                this.etvSignalPid = builder.etvSignalPid;
                this.klvDataPids = builder.klvDataPids;
                this.pcrPid = builder.pcrPid;
                this.pmtPid = builder.pmtPid;
                this.privateMetadataPid = builder.privateMetadataPid;
                this.scte27Pids = builder.scte27Pids;
                this.scte35Pid = builder.scte35Pid;
                this.timedMetadataPid = builder.timedMetadataPid;
                this.videoPid = builder.videoPid;
            }

            @Override
            public final java.lang.Object getAudioPids() {
                return this.audioPids;
            }

            @Override
            public final java.lang.Object getDvbSubPids() {
                return this.dvbSubPids;
            }

            @Override
            public final java.lang.Number getDvbTeletextPid() {
                return this.dvbTeletextPid;
            }

            @Override
            public final java.lang.Number getEtvPlatformPid() {
                return this.etvPlatformPid;
            }

            @Override
            public final java.lang.Number getEtvSignalPid() {
                return this.etvSignalPid;
            }

            @Override
            public final java.lang.Object getKlvDataPids() {
                return this.klvDataPids;
            }

            @Override
            public final java.lang.Number getPcrPid() {
                return this.pcrPid;
            }

            @Override
            public final java.lang.Number getPmtPid() {
                return this.pmtPid;
            }

            @Override
            public final java.lang.Number getPrivateMetadataPid() {
                return this.privateMetadataPid;
            }

            @Override
            public final java.lang.Object getScte27Pids() {
                return this.scte27Pids;
            }

            @Override
            public final java.lang.Number getScte35Pid() {
                return this.scte35Pid;
            }

            @Override
            public final java.lang.Number getTimedMetadataPid() {
                return this.timedMetadataPid;
            }

            @Override
            public final java.lang.Number getVideoPid() {
                return this.videoPid;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAudioPids() != null) {
                    data.set("audioPids", om.valueToTree(this.getAudioPids()));
                }
                if (this.getDvbSubPids() != null) {
                    data.set("dvbSubPids", om.valueToTree(this.getDvbSubPids()));
                }
                if (this.getDvbTeletextPid() != null) {
                    data.set("dvbTeletextPid", om.valueToTree(this.getDvbTeletextPid()));
                }
                if (this.getEtvPlatformPid() != null) {
                    data.set("etvPlatformPid", om.valueToTree(this.getEtvPlatformPid()));
                }
                if (this.getEtvSignalPid() != null) {
                    data.set("etvSignalPid", om.valueToTree(this.getEtvSignalPid()));
                }
                if (this.getKlvDataPids() != null) {
                    data.set("klvDataPids", om.valueToTree(this.getKlvDataPids()));
                }
                if (this.getPcrPid() != null) {
                    data.set("pcrPid", om.valueToTree(this.getPcrPid()));
                }
                if (this.getPmtPid() != null) {
                    data.set("pmtPid", om.valueToTree(this.getPmtPid()));
                }
                if (this.getPrivateMetadataPid() != null) {
                    data.set("privateMetadataPid", om.valueToTree(this.getPrivateMetadataPid()));
                }
                if (this.getScte27Pids() != null) {
                    data.set("scte27Pids", om.valueToTree(this.getScte27Pids()));
                }
                if (this.getScte35Pid() != null) {
                    data.set("scte35Pid", om.valueToTree(this.getScte35Pid()));
                }
                if (this.getTimedMetadataPid() != null) {
                    data.set("timedMetadataPid", om.valueToTree(this.getTimedMetadataPid()));
                }
                if (this.getVideoPid() != null) {
                    data.set("videoPid", om.valueToTree(this.getVideoPid()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnMultiplexprogram.MultiplexProgramPacketIdentifiersMapProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MultiplexProgramPacketIdentifiersMapProperty.Jsii$Proxy that = (MultiplexProgramPacketIdentifiersMapProperty.Jsii$Proxy) o;

                if (this.audioPids != null ? !this.audioPids.equals(that.audioPids) : that.audioPids != null) return false;
                if (this.dvbSubPids != null ? !this.dvbSubPids.equals(that.dvbSubPids) : that.dvbSubPids != null) return false;
                if (this.dvbTeletextPid != null ? !this.dvbTeletextPid.equals(that.dvbTeletextPid) : that.dvbTeletextPid != null) return false;
                if (this.etvPlatformPid != null ? !this.etvPlatformPid.equals(that.etvPlatformPid) : that.etvPlatformPid != null) return false;
                if (this.etvSignalPid != null ? !this.etvSignalPid.equals(that.etvSignalPid) : that.etvSignalPid != null) return false;
                if (this.klvDataPids != null ? !this.klvDataPids.equals(that.klvDataPids) : that.klvDataPids != null) return false;
                if (this.pcrPid != null ? !this.pcrPid.equals(that.pcrPid) : that.pcrPid != null) return false;
                if (this.pmtPid != null ? !this.pmtPid.equals(that.pmtPid) : that.pmtPid != null) return false;
                if (this.privateMetadataPid != null ? !this.privateMetadataPid.equals(that.privateMetadataPid) : that.privateMetadataPid != null) return false;
                if (this.scte27Pids != null ? !this.scte27Pids.equals(that.scte27Pids) : that.scte27Pids != null) return false;
                if (this.scte35Pid != null ? !this.scte35Pid.equals(that.scte35Pid) : that.scte35Pid != null) return false;
                if (this.timedMetadataPid != null ? !this.timedMetadataPid.equals(that.timedMetadataPid) : that.timedMetadataPid != null) return false;
                return this.videoPid != null ? this.videoPid.equals(that.videoPid) : that.videoPid == null;
            }

            @Override
            public final int hashCode() {
                int result = this.audioPids != null ? this.audioPids.hashCode() : 0;
                result = 31 * result + (this.dvbSubPids != null ? this.dvbSubPids.hashCode() : 0);
                result = 31 * result + (this.dvbTeletextPid != null ? this.dvbTeletextPid.hashCode() : 0);
                result = 31 * result + (this.etvPlatformPid != null ? this.etvPlatformPid.hashCode() : 0);
                result = 31 * result + (this.etvSignalPid != null ? this.etvSignalPid.hashCode() : 0);
                result = 31 * result + (this.klvDataPids != null ? this.klvDataPids.hashCode() : 0);
                result = 31 * result + (this.pcrPid != null ? this.pcrPid.hashCode() : 0);
                result = 31 * result + (this.pmtPid != null ? this.pmtPid.hashCode() : 0);
                result = 31 * result + (this.privateMetadataPid != null ? this.privateMetadataPid.hashCode() : 0);
                result = 31 * result + (this.scte27Pids != null ? this.scte27Pids.hashCode() : 0);
                result = 31 * result + (this.scte35Pid != null ? this.scte35Pid.hashCode() : 0);
                result = 31 * result + (this.timedMetadataPid != null ? this.timedMetadataPid.hashCode() : 0);
                result = 31 * result + (this.videoPid != null ? this.videoPid.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The current source for one of the pipelines in the multiplex.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * MultiplexProgramPipelineDetailProperty multiplexProgramPipelineDetailProperty = MultiplexProgramPipelineDetailProperty.builder()
     *         .activeChannelPipeline("activeChannelPipeline")
     *         .pipelineId("pipelineId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexprogrampipelinedetail.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexprogrampipelinedetail.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnMultiplexprogram.MultiplexProgramPipelineDetailProperty")
    @software.amazon.jsii.Jsii.Proxy(MultiplexProgramPipelineDetailProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MultiplexProgramPipelineDetailProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Identifies the channel pipeline that is currently active for the pipeline (identified by PipelineId) in the multiplex.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexprogrampipelinedetail.html#cfn-medialive-multiplexprogram-multiplexprogrampipelinedetail-activechannelpipeline">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexprogrampipelinedetail.html#cfn-medialive-multiplexprogram-multiplexprogrampipelinedetail-activechannelpipeline</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getActiveChannelPipeline() {
            return null;
        }

        /**
         * Identifies a specific pipeline in the multiplex.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexprogrampipelinedetail.html#cfn-medialive-multiplexprogram-multiplexprogrampipelinedetail-pipelineid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexprogrampipelinedetail.html#cfn-medialive-multiplexprogram-multiplexprogrampipelinedetail-pipelineid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPipelineId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MultiplexProgramPipelineDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MultiplexProgramPipelineDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MultiplexProgramPipelineDetailProperty> {
            java.lang.String activeChannelPipeline;
            java.lang.String pipelineId;

            /**
             * Sets the value of {@link MultiplexProgramPipelineDetailProperty#getActiveChannelPipeline}
             * @param activeChannelPipeline Identifies the channel pipeline that is currently active for the pipeline (identified by PipelineId) in the multiplex.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder activeChannelPipeline(java.lang.String activeChannelPipeline) {
                this.activeChannelPipeline = activeChannelPipeline;
                return this;
            }

            /**
             * Sets the value of {@link MultiplexProgramPipelineDetailProperty#getPipelineId}
             * @param pipelineId Identifies a specific pipeline in the multiplex.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pipelineId(java.lang.String pipelineId) {
                this.pipelineId = pipelineId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MultiplexProgramPipelineDetailProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MultiplexProgramPipelineDetailProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MultiplexProgramPipelineDetailProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MultiplexProgramPipelineDetailProperty {
            private final java.lang.String activeChannelPipeline;
            private final java.lang.String pipelineId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.activeChannelPipeline = software.amazon.jsii.Kernel.get(this, "activeChannelPipeline", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.pipelineId = software.amazon.jsii.Kernel.get(this, "pipelineId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.activeChannelPipeline = builder.activeChannelPipeline;
                this.pipelineId = builder.pipelineId;
            }

            @Override
            public final java.lang.String getActiveChannelPipeline() {
                return this.activeChannelPipeline;
            }

            @Override
            public final java.lang.String getPipelineId() {
                return this.pipelineId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getActiveChannelPipeline() != null) {
                    data.set("activeChannelPipeline", om.valueToTree(this.getActiveChannelPipeline()));
                }
                if (this.getPipelineId() != null) {
                    data.set("pipelineId", om.valueToTree(this.getPipelineId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnMultiplexprogram.MultiplexProgramPipelineDetailProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MultiplexProgramPipelineDetailProperty.Jsii$Proxy that = (MultiplexProgramPipelineDetailProperty.Jsii$Proxy) o;

                if (this.activeChannelPipeline != null ? !this.activeChannelPipeline.equals(that.activeChannelPipeline) : that.activeChannelPipeline != null) return false;
                return this.pipelineId != null ? this.pipelineId.equals(that.pipelineId) : that.pipelineId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.activeChannelPipeline != null ? this.activeChannelPipeline.hashCode() : 0;
                result = 31 * result + (this.pipelineId != null ? this.pipelineId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Transport stream service descriptor configuration for the Multiplex program.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * MultiplexProgramServiceDescriptorProperty multiplexProgramServiceDescriptorProperty = MultiplexProgramServiceDescriptorProperty.builder()
     *         .providerName("providerName")
     *         .serviceName("serviceName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexprogramservicedescriptor.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexprogramservicedescriptor.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnMultiplexprogram.MultiplexProgramServiceDescriptorProperty")
    @software.amazon.jsii.Jsii.Proxy(MultiplexProgramServiceDescriptorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MultiplexProgramServiceDescriptorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Name of the provider.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexprogramservicedescriptor.html#cfn-medialive-multiplexprogram-multiplexprogramservicedescriptor-providername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexprogramservicedescriptor.html#cfn-medialive-multiplexprogram-multiplexprogramservicedescriptor-providername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getProviderName();

        /**
         * Name of the service.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexprogramservicedescriptor.html#cfn-medialive-multiplexprogram-multiplexprogramservicedescriptor-servicename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexprogramservicedescriptor.html#cfn-medialive-multiplexprogram-multiplexprogramservicedescriptor-servicename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getServiceName();

        /**
         * @return a {@link Builder} of {@link MultiplexProgramServiceDescriptorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MultiplexProgramServiceDescriptorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MultiplexProgramServiceDescriptorProperty> {
            java.lang.String providerName;
            java.lang.String serviceName;

            /**
             * Sets the value of {@link MultiplexProgramServiceDescriptorProperty#getProviderName}
             * @param providerName Name of the provider. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder providerName(java.lang.String providerName) {
                this.providerName = providerName;
                return this;
            }

            /**
             * Sets the value of {@link MultiplexProgramServiceDescriptorProperty#getServiceName}
             * @param serviceName Name of the service. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceName(java.lang.String serviceName) {
                this.serviceName = serviceName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MultiplexProgramServiceDescriptorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MultiplexProgramServiceDescriptorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MultiplexProgramServiceDescriptorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MultiplexProgramServiceDescriptorProperty {
            private final java.lang.String providerName;
            private final java.lang.String serviceName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.providerName = software.amazon.jsii.Kernel.get(this, "providerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.serviceName = software.amazon.jsii.Kernel.get(this, "serviceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.providerName = java.util.Objects.requireNonNull(builder.providerName, "providerName is required");
                this.serviceName = java.util.Objects.requireNonNull(builder.serviceName, "serviceName is required");
            }

            @Override
            public final java.lang.String getProviderName() {
                return this.providerName;
            }

            @Override
            public final java.lang.String getServiceName() {
                return this.serviceName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("providerName", om.valueToTree(this.getProviderName()));
                data.set("serviceName", om.valueToTree(this.getServiceName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnMultiplexprogram.MultiplexProgramServiceDescriptorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MultiplexProgramServiceDescriptorProperty.Jsii$Proxy that = (MultiplexProgramServiceDescriptorProperty.Jsii$Proxy) o;

                if (!providerName.equals(that.providerName)) return false;
                return this.serviceName.equals(that.serviceName);
            }

            @Override
            public final int hashCode() {
                int result = this.providerName.hashCode();
                result = 31 * result + (this.serviceName.hashCode());
                return result;
            }
        }
    }
    /**
     * Multiplex Program settings configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * MultiplexProgramSettingsProperty multiplexProgramSettingsProperty = MultiplexProgramSettingsProperty.builder()
     *         .programNumber(123)
     *         // the properties below are optional
     *         .preferredChannelPipeline("preferredChannelPipeline")
     *         .serviceDescriptor(MultiplexProgramServiceDescriptorProperty.builder()
     *                 .providerName("providerName")
     *                 .serviceName("serviceName")
     *                 .build())
     *         .videoSettings(MultiplexVideoSettingsProperty.builder()
     *                 .constantBitrate(123)
     *                 .statmuxSettings(MultiplexStatmuxVideoSettingsProperty.builder()
     *                         .maximumBitrate(123)
     *                         .minimumBitrate(123)
     *                         .priority(123)
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexprogramsettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexprogramsettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnMultiplexprogram.MultiplexProgramSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(MultiplexProgramSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MultiplexProgramSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Unique program number.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexprogramsettings.html#cfn-medialive-multiplexprogram-multiplexprogramsettings-programnumber">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexprogramsettings.html#cfn-medialive-multiplexprogram-multiplexprogramsettings-programnumber</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getProgramNumber();

        /**
         * Indicates which pipeline is preferred by the multiplex for program ingest.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexprogramsettings.html#cfn-medialive-multiplexprogram-multiplexprogramsettings-preferredchannelpipeline">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexprogramsettings.html#cfn-medialive-multiplexprogram-multiplexprogramsettings-preferredchannelpipeline</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPreferredChannelPipeline() {
            return null;
        }

        /**
         * Transport stream service descriptor configuration for the Multiplex program.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexprogramsettings.html#cfn-medialive-multiplexprogram-multiplexprogramsettings-servicedescriptor">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexprogramsettings.html#cfn-medialive-multiplexprogram-multiplexprogramsettings-servicedescriptor</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getServiceDescriptor() {
            return null;
        }

        /**
         * Program video settings configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexprogramsettings.html#cfn-medialive-multiplexprogram-multiplexprogramsettings-videosettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexprogramsettings.html#cfn-medialive-multiplexprogram-multiplexprogramsettings-videosettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVideoSettings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MultiplexProgramSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MultiplexProgramSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MultiplexProgramSettingsProperty> {
            java.lang.Number programNumber;
            java.lang.String preferredChannelPipeline;
            java.lang.Object serviceDescriptor;
            java.lang.Object videoSettings;

            /**
             * Sets the value of {@link MultiplexProgramSettingsProperty#getProgramNumber}
             * @param programNumber Unique program number. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder programNumber(java.lang.Number programNumber) {
                this.programNumber = programNumber;
                return this;
            }

            /**
             * Sets the value of {@link MultiplexProgramSettingsProperty#getPreferredChannelPipeline}
             * @param preferredChannelPipeline Indicates which pipeline is preferred by the multiplex for program ingest.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder preferredChannelPipeline(java.lang.String preferredChannelPipeline) {
                this.preferredChannelPipeline = preferredChannelPipeline;
                return this;
            }

            /**
             * Sets the value of {@link MultiplexProgramSettingsProperty#getServiceDescriptor}
             * @param serviceDescriptor Transport stream service descriptor configuration for the Multiplex program.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceDescriptor(software.amazon.awscdk.IResolvable serviceDescriptor) {
                this.serviceDescriptor = serviceDescriptor;
                return this;
            }

            /**
             * Sets the value of {@link MultiplexProgramSettingsProperty#getServiceDescriptor}
             * @param serviceDescriptor Transport stream service descriptor configuration for the Multiplex program.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceDescriptor(software.amazon.awscdk.services.medialive.CfnMultiplexprogram.MultiplexProgramServiceDescriptorProperty serviceDescriptor) {
                this.serviceDescriptor = serviceDescriptor;
                return this;
            }

            /**
             * Sets the value of {@link MultiplexProgramSettingsProperty#getVideoSettings}
             * @param videoSettings Program video settings configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder videoSettings(software.amazon.awscdk.IResolvable videoSettings) {
                this.videoSettings = videoSettings;
                return this;
            }

            /**
             * Sets the value of {@link MultiplexProgramSettingsProperty#getVideoSettings}
             * @param videoSettings Program video settings configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder videoSettings(software.amazon.awscdk.services.medialive.CfnMultiplexprogram.MultiplexVideoSettingsProperty videoSettings) {
                this.videoSettings = videoSettings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MultiplexProgramSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MultiplexProgramSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MultiplexProgramSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MultiplexProgramSettingsProperty {
            private final java.lang.Number programNumber;
            private final java.lang.String preferredChannelPipeline;
            private final java.lang.Object serviceDescriptor;
            private final java.lang.Object videoSettings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.programNumber = software.amazon.jsii.Kernel.get(this, "programNumber", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.preferredChannelPipeline = software.amazon.jsii.Kernel.get(this, "preferredChannelPipeline", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.serviceDescriptor = software.amazon.jsii.Kernel.get(this, "serviceDescriptor", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.videoSettings = software.amazon.jsii.Kernel.get(this, "videoSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.programNumber = java.util.Objects.requireNonNull(builder.programNumber, "programNumber is required");
                this.preferredChannelPipeline = builder.preferredChannelPipeline;
                this.serviceDescriptor = builder.serviceDescriptor;
                this.videoSettings = builder.videoSettings;
            }

            @Override
            public final java.lang.Number getProgramNumber() {
                return this.programNumber;
            }

            @Override
            public final java.lang.String getPreferredChannelPipeline() {
                return this.preferredChannelPipeline;
            }

            @Override
            public final java.lang.Object getServiceDescriptor() {
                return this.serviceDescriptor;
            }

            @Override
            public final java.lang.Object getVideoSettings() {
                return this.videoSettings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("programNumber", om.valueToTree(this.getProgramNumber()));
                if (this.getPreferredChannelPipeline() != null) {
                    data.set("preferredChannelPipeline", om.valueToTree(this.getPreferredChannelPipeline()));
                }
                if (this.getServiceDescriptor() != null) {
                    data.set("serviceDescriptor", om.valueToTree(this.getServiceDescriptor()));
                }
                if (this.getVideoSettings() != null) {
                    data.set("videoSettings", om.valueToTree(this.getVideoSettings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnMultiplexprogram.MultiplexProgramSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MultiplexProgramSettingsProperty.Jsii$Proxy that = (MultiplexProgramSettingsProperty.Jsii$Proxy) o;

                if (!programNumber.equals(that.programNumber)) return false;
                if (this.preferredChannelPipeline != null ? !this.preferredChannelPipeline.equals(that.preferredChannelPipeline) : that.preferredChannelPipeline != null) return false;
                if (this.serviceDescriptor != null ? !this.serviceDescriptor.equals(that.serviceDescriptor) : that.serviceDescriptor != null) return false;
                return this.videoSettings != null ? this.videoSettings.equals(that.videoSettings) : that.videoSettings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.programNumber.hashCode();
                result = 31 * result + (this.preferredChannelPipeline != null ? this.preferredChannelPipeline.hashCode() : 0);
                result = 31 * result + (this.serviceDescriptor != null ? this.serviceDescriptor.hashCode() : 0);
                result = 31 * result + (this.videoSettings != null ? this.videoSettings.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Statmux rate control settings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * MultiplexStatmuxVideoSettingsProperty multiplexStatmuxVideoSettingsProperty = MultiplexStatmuxVideoSettingsProperty.builder()
     *         .maximumBitrate(123)
     *         .minimumBitrate(123)
     *         .priority(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexstatmuxvideosettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexstatmuxvideosettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnMultiplexprogram.MultiplexStatmuxVideoSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(MultiplexStatmuxVideoSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MultiplexStatmuxVideoSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Maximum statmux bitrate.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexstatmuxvideosettings.html#cfn-medialive-multiplexprogram-multiplexstatmuxvideosettings-maximumbitrate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexstatmuxvideosettings.html#cfn-medialive-multiplexprogram-multiplexstatmuxvideosettings-maximumbitrate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumBitrate() {
            return null;
        }

        /**
         * Minimum statmux bitrate.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexstatmuxvideosettings.html#cfn-medialive-multiplexprogram-multiplexstatmuxvideosettings-minimumbitrate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexstatmuxvideosettings.html#cfn-medialive-multiplexprogram-multiplexstatmuxvideosettings-minimumbitrate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinimumBitrate() {
            return null;
        }

        /**
         * The purpose of the priority is to use a combination of the\nmultiplex rate control algorithm and the QVBR capability of the\nencoder to prioritize the video quality of some channels in a\nmultiplex over others.
         * <p>
         * Channels that have a higher priority will\nget higher video quality at the expense of the video quality of\nother channels in the multiplex with lower priority.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexstatmuxvideosettings.html#cfn-medialive-multiplexprogram-multiplexstatmuxvideosettings-priority">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexstatmuxvideosettings.html#cfn-medialive-multiplexprogram-multiplexstatmuxvideosettings-priority</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPriority() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MultiplexStatmuxVideoSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MultiplexStatmuxVideoSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MultiplexStatmuxVideoSettingsProperty> {
            java.lang.Number maximumBitrate;
            java.lang.Number minimumBitrate;
            java.lang.Number priority;

            /**
             * Sets the value of {@link MultiplexStatmuxVideoSettingsProperty#getMaximumBitrate}
             * @param maximumBitrate Maximum statmux bitrate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumBitrate(java.lang.Number maximumBitrate) {
                this.maximumBitrate = maximumBitrate;
                return this;
            }

            /**
             * Sets the value of {@link MultiplexStatmuxVideoSettingsProperty#getMinimumBitrate}
             * @param minimumBitrate Minimum statmux bitrate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minimumBitrate(java.lang.Number minimumBitrate) {
                this.minimumBitrate = minimumBitrate;
                return this;
            }

            /**
             * Sets the value of {@link MultiplexStatmuxVideoSettingsProperty#getPriority}
             * @param priority The purpose of the priority is to use a combination of the\nmultiplex rate control algorithm and the QVBR capability of the\nencoder to prioritize the video quality of some channels in a\nmultiplex over others.
             *                 Channels that have a higher priority will\nget higher video quality at the expense of the video quality of\nother channels in the multiplex with lower priority.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder priority(java.lang.Number priority) {
                this.priority = priority;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MultiplexStatmuxVideoSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MultiplexStatmuxVideoSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MultiplexStatmuxVideoSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MultiplexStatmuxVideoSettingsProperty {
            private final java.lang.Number maximumBitrate;
            private final java.lang.Number minimumBitrate;
            private final java.lang.Number priority;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maximumBitrate = software.amazon.jsii.Kernel.get(this, "maximumBitrate", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minimumBitrate = software.amazon.jsii.Kernel.get(this, "minimumBitrate", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.priority = software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maximumBitrate = builder.maximumBitrate;
                this.minimumBitrate = builder.minimumBitrate;
                this.priority = builder.priority;
            }

            @Override
            public final java.lang.Number getMaximumBitrate() {
                return this.maximumBitrate;
            }

            @Override
            public final java.lang.Number getMinimumBitrate() {
                return this.minimumBitrate;
            }

            @Override
            public final java.lang.Number getPriority() {
                return this.priority;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMaximumBitrate() != null) {
                    data.set("maximumBitrate", om.valueToTree(this.getMaximumBitrate()));
                }
                if (this.getMinimumBitrate() != null) {
                    data.set("minimumBitrate", om.valueToTree(this.getMinimumBitrate()));
                }
                if (this.getPriority() != null) {
                    data.set("priority", om.valueToTree(this.getPriority()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnMultiplexprogram.MultiplexStatmuxVideoSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MultiplexStatmuxVideoSettingsProperty.Jsii$Proxy that = (MultiplexStatmuxVideoSettingsProperty.Jsii$Proxy) o;

                if (this.maximumBitrate != null ? !this.maximumBitrate.equals(that.maximumBitrate) : that.maximumBitrate != null) return false;
                if (this.minimumBitrate != null ? !this.minimumBitrate.equals(that.minimumBitrate) : that.minimumBitrate != null) return false;
                return this.priority != null ? this.priority.equals(that.priority) : that.priority == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maximumBitrate != null ? this.maximumBitrate.hashCode() : 0;
                result = 31 * result + (this.minimumBitrate != null ? this.minimumBitrate.hashCode() : 0);
                result = 31 * result + (this.priority != null ? this.priority.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The video configuration for each program in a multiplex.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.medialive.*;
     * MultiplexVideoSettingsProperty multiplexVideoSettingsProperty = MultiplexVideoSettingsProperty.builder()
     *         .constantBitrate(123)
     *         .statmuxSettings(MultiplexStatmuxVideoSettingsProperty.builder()
     *                 .maximumBitrate(123)
     *                 .minimumBitrate(123)
     *                 .priority(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexvideosettings.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexvideosettings.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_medialive.CfnMultiplexprogram.MultiplexVideoSettingsProperty")
    @software.amazon.jsii.Jsii.Proxy(MultiplexVideoSettingsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MultiplexVideoSettingsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The constant bitrate configuration for the video encode.
         * <p>
         * When this field is defined, StatmuxSettings must be undefined.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexvideosettings.html#cfn-medialive-multiplexprogram-multiplexvideosettings-constantbitrate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexvideosettings.html#cfn-medialive-multiplexprogram-multiplexvideosettings-constantbitrate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getConstantBitrate() {
            return null;
        }

        /**
         * Statmux rate control settings.
         * <p>
         * When this field is defined, ConstantBitrate must be undefined.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexvideosettings.html#cfn-medialive-multiplexprogram-multiplexvideosettings-statmuxsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-multiplexprogram-multiplexvideosettings.html#cfn-medialive-multiplexprogram-multiplexvideosettings-statmuxsettings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStatmuxSettings() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MultiplexVideoSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MultiplexVideoSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MultiplexVideoSettingsProperty> {
            java.lang.Number constantBitrate;
            java.lang.Object statmuxSettings;

            /**
             * Sets the value of {@link MultiplexVideoSettingsProperty#getConstantBitrate}
             * @param constantBitrate The constant bitrate configuration for the video encode.
             *                        When this field is defined, StatmuxSettings must be undefined.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder constantBitrate(java.lang.Number constantBitrate) {
                this.constantBitrate = constantBitrate;
                return this;
            }

            /**
             * Sets the value of {@link MultiplexVideoSettingsProperty#getStatmuxSettings}
             * @param statmuxSettings Statmux rate control settings.
             *                        When this field is defined, ConstantBitrate must be undefined.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statmuxSettings(software.amazon.awscdk.IResolvable statmuxSettings) {
                this.statmuxSettings = statmuxSettings;
                return this;
            }

            /**
             * Sets the value of {@link MultiplexVideoSettingsProperty#getStatmuxSettings}
             * @param statmuxSettings Statmux rate control settings.
             *                        When this field is defined, ConstantBitrate must be undefined.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statmuxSettings(software.amazon.awscdk.services.medialive.CfnMultiplexprogram.MultiplexStatmuxVideoSettingsProperty statmuxSettings) {
                this.statmuxSettings = statmuxSettings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MultiplexVideoSettingsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MultiplexVideoSettingsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MultiplexVideoSettingsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MultiplexVideoSettingsProperty {
            private final java.lang.Number constantBitrate;
            private final java.lang.Object statmuxSettings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.constantBitrate = software.amazon.jsii.Kernel.get(this, "constantBitrate", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.statmuxSettings = software.amazon.jsii.Kernel.get(this, "statmuxSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.constantBitrate = builder.constantBitrate;
                this.statmuxSettings = builder.statmuxSettings;
            }

            @Override
            public final java.lang.Number getConstantBitrate() {
                return this.constantBitrate;
            }

            @Override
            public final java.lang.Object getStatmuxSettings() {
                return this.statmuxSettings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConstantBitrate() != null) {
                    data.set("constantBitrate", om.valueToTree(this.getConstantBitrate()));
                }
                if (this.getStatmuxSettings() != null) {
                    data.set("statmuxSettings", om.valueToTree(this.getStatmuxSettings()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_medialive.CfnMultiplexprogram.MultiplexVideoSettingsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MultiplexVideoSettingsProperty.Jsii$Proxy that = (MultiplexVideoSettingsProperty.Jsii$Proxy) o;

                if (this.constantBitrate != null ? !this.constantBitrate.equals(that.constantBitrate) : that.constantBitrate != null) return false;
                return this.statmuxSettings != null ? this.statmuxSettings.equals(that.statmuxSettings) : that.statmuxSettings == null;
            }

            @Override
            public final int hashCode() {
                int result = this.constantBitrate != null ? this.constantBitrate.hashCode() : 0;
                result = 31 * result + (this.statmuxSettings != null ? this.statmuxSettings.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.medialive.CfnMultiplexprogram}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.medialive.CfnMultiplexprogram> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.medialive.CfnMultiplexprogramProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The unique id of the multiplex.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-multiplexprogram.html#cfn-medialive-multiplexprogram-multiplexid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-multiplexprogram.html#cfn-medialive-multiplexprogram-multiplexid</a>
         * @param multiplexId The unique id of the multiplex. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiplexId(final java.lang.String multiplexId) {
            this.props().multiplexId(multiplexId);
            return this;
        }

        /**
         * Multiplex Program settings configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-multiplexprogram.html#cfn-medialive-multiplexprogram-multiplexprogramsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-multiplexprogram.html#cfn-medialive-multiplexprogram-multiplexprogramsettings</a>
         * @param multiplexProgramSettings Multiplex Program settings configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiplexProgramSettings(final software.amazon.awscdk.IResolvable multiplexProgramSettings) {
            this.props().multiplexProgramSettings(multiplexProgramSettings);
            return this;
        }
        /**
         * Multiplex Program settings configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-multiplexprogram.html#cfn-medialive-multiplexprogram-multiplexprogramsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-multiplexprogram.html#cfn-medialive-multiplexprogram-multiplexprogramsettings</a>
         * @param multiplexProgramSettings Multiplex Program settings configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder multiplexProgramSettings(final software.amazon.awscdk.services.medialive.CfnMultiplexprogram.MultiplexProgramSettingsProperty multiplexProgramSettings) {
            this.props().multiplexProgramSettings(multiplexProgramSettings);
            return this;
        }

        /**
         * Packet identifiers map for a given Multiplex program.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-multiplexprogram.html#cfn-medialive-multiplexprogram-packetidentifiersmap">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-multiplexprogram.html#cfn-medialive-multiplexprogram-packetidentifiersmap</a>
         * @param packetIdentifiersMap Packet identifiers map for a given Multiplex program. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder packetIdentifiersMap(final software.amazon.awscdk.IResolvable packetIdentifiersMap) {
            this.props().packetIdentifiersMap(packetIdentifiersMap);
            return this;
        }
        /**
         * Packet identifiers map for a given Multiplex program.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-multiplexprogram.html#cfn-medialive-multiplexprogram-packetidentifiersmap">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-multiplexprogram.html#cfn-medialive-multiplexprogram-packetidentifiersmap</a>
         * @param packetIdentifiersMap Packet identifiers map for a given Multiplex program. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder packetIdentifiersMap(final software.amazon.awscdk.services.medialive.CfnMultiplexprogram.MultiplexProgramPacketIdentifiersMapProperty packetIdentifiersMap) {
            this.props().packetIdentifiersMap(packetIdentifiersMap);
            return this;
        }

        /**
         * Contains information about the current sources for the specified program in the specified multiplex.
         * <p>
         * Keep in mind that each multiplex pipeline connects to both pipelines in a given source channel (the channel identified by the program). But only one of those channel pipelines is ever active at one time.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-multiplexprogram.html#cfn-medialive-multiplexprogram-pipelinedetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-multiplexprogram.html#cfn-medialive-multiplexprogram-pipelinedetails</a>
         * @param pipelineDetails Contains information about the current sources for the specified program in the specified multiplex. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pipelineDetails(final software.amazon.awscdk.IResolvable pipelineDetails) {
            this.props().pipelineDetails(pipelineDetails);
            return this;
        }
        /**
         * Contains information about the current sources for the specified program in the specified multiplex.
         * <p>
         * Keep in mind that each multiplex pipeline connects to both pipelines in a given source channel (the channel identified by the program). But only one of those channel pipelines is ever active at one time.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-multiplexprogram.html#cfn-medialive-multiplexprogram-pipelinedetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-multiplexprogram.html#cfn-medialive-multiplexprogram-pipelinedetails</a>
         * @param pipelineDetails Contains information about the current sources for the specified program in the specified multiplex. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pipelineDetails(final java.util.List<? extends java.lang.Object> pipelineDetails) {
            this.props().pipelineDetails(pipelineDetails);
            return this;
        }

        /**
         * Indicates which pipeline is preferred by the multiplex for program ingest.
         * <p>
         * If set to "PIPELINE_0" or "PIPELINE_1" and an unhealthy ingest causes the multiplex to switch to the non-preferred pipeline,
         * it will switch back once that ingest is healthy again. If set to "CURRENTLY_ACTIVE",
         * it will not switch back to the other pipeline based on it recovering to a healthy state,
         * it will only switch if the active pipeline becomes unhealthy.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-multiplexprogram.html#cfn-medialive-multiplexprogram-preferredchannelpipeline">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-multiplexprogram.html#cfn-medialive-multiplexprogram-preferredchannelpipeline</a>
         * @param preferredChannelPipeline Indicates which pipeline is preferred by the multiplex for program ingest. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredChannelPipeline(final java.lang.String preferredChannelPipeline) {
            this.props().preferredChannelPipeline(preferredChannelPipeline);
            return this;
        }

        /**
         * The name of the multiplex program.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-multiplexprogram.html#cfn-medialive-multiplexprogram-programname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-medialive-multiplexprogram.html#cfn-medialive-multiplexprogram-programname</a>
         * @param programName The name of the multiplex program. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder programName(final java.lang.String programName) {
            this.props().programName(programName);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.medialive.CfnMultiplexprogram}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.medialive.CfnMultiplexprogram build() {
            return new software.amazon.awscdk.services.medialive.CfnMultiplexprogram(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.medialive.CfnMultiplexprogramProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.medialive.CfnMultiplexprogramProps.Builder();
            }
            return this.props;
        }
    }
}
