package software.amazon.awscdk.services.networkmanager;

/**
 * Properties for defining a <code>CfnDirectConnectGatewayAttachment</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.networkmanager.*;
 * CfnDirectConnectGatewayAttachmentProps cfnDirectConnectGatewayAttachmentProps = CfnDirectConnectGatewayAttachmentProps.builder()
 *         .coreNetworkId("coreNetworkId")
 *         .directConnectGatewayArn("directConnectGatewayArn")
 *         .edgeLocations(List.of("edgeLocations"))
 *         // the properties below are optional
 *         .proposedNetworkFunctionGroupChange(ProposedNetworkFunctionGroupChangeProperty.builder()
 *                 .attachmentPolicyRuleNumber(123)
 *                 .networkFunctionGroupName("networkFunctionGroupName")
 *                 .tags(List.of(CfnTag.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .build())
 *         .proposedSegmentChange(ProposedSegmentChangeProperty.builder()
 *                 .attachmentPolicyRuleNumber(123)
 *                 .segmentName("segmentName")
 *                 .tags(List.of(CfnTag.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-directconnectgatewayattachment.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-directconnectgatewayattachment.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:25:01.647Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_networkmanager.CfnDirectConnectGatewayAttachmentProps")
@software.amazon.jsii.Jsii.Proxy(CfnDirectConnectGatewayAttachmentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDirectConnectGatewayAttachmentProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of a core network for the Direct Connect Gateway attachment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-directconnectgatewayattachment.html#cfn-networkmanager-directconnectgatewayattachment-corenetworkid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-directconnectgatewayattachment.html#cfn-networkmanager-directconnectgatewayattachment-corenetworkid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCoreNetworkId();

    /**
     * The Direct Connect gateway attachment ARN.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-directconnectgatewayattachment.html#cfn-networkmanager-directconnectgatewayattachment-directconnectgatewayarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-directconnectgatewayattachment.html#cfn-networkmanager-directconnectgatewayattachment-directconnectgatewayarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDirectConnectGatewayArn();

    /**
     * The Regions where the edges are located.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-directconnectgatewayattachment.html#cfn-networkmanager-directconnectgatewayattachment-edgelocations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-directconnectgatewayattachment.html#cfn-networkmanager-directconnectgatewayattachment-edgelocations</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getEdgeLocations();

    /**
     * Describes proposed changes to a network function group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-directconnectgatewayattachment.html#cfn-networkmanager-directconnectgatewayattachment-proposednetworkfunctiongroupchange">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-directconnectgatewayattachment.html#cfn-networkmanager-directconnectgatewayattachment-proposednetworkfunctiongroupchange</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getProposedNetworkFunctionGroupChange() {
        return null;
    }

    /**
     * Describes a proposed segment change.
     * <p>
     * In some cases, the segment change must first be evaluated and accepted.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-directconnectgatewayattachment.html#cfn-networkmanager-directconnectgatewayattachment-proposedsegmentchange">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-directconnectgatewayattachment.html#cfn-networkmanager-directconnectgatewayattachment-proposedsegmentchange</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getProposedSegmentChange() {
        return null;
    }

    /**
     * Tags for the attachment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-directconnectgatewayattachment.html#cfn-networkmanager-directconnectgatewayattachment-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-networkmanager-directconnectgatewayattachment.html#cfn-networkmanager-directconnectgatewayattachment-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDirectConnectGatewayAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDirectConnectGatewayAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDirectConnectGatewayAttachmentProps> {
        java.lang.String coreNetworkId;
        java.lang.String directConnectGatewayArn;
        java.util.List<java.lang.String> edgeLocations;
        java.lang.Object proposedNetworkFunctionGroupChange;
        java.lang.Object proposedSegmentChange;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnDirectConnectGatewayAttachmentProps#getCoreNetworkId}
         * @param coreNetworkId The ID of a core network for the Direct Connect Gateway attachment. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder coreNetworkId(java.lang.String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
            return this;
        }

        /**
         * Sets the value of {@link CfnDirectConnectGatewayAttachmentProps#getDirectConnectGatewayArn}
         * @param directConnectGatewayArn The Direct Connect gateway attachment ARN. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder directConnectGatewayArn(java.lang.String directConnectGatewayArn) {
            this.directConnectGatewayArn = directConnectGatewayArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnDirectConnectGatewayAttachmentProps#getEdgeLocations}
         * @param edgeLocations The Regions where the edges are located. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder edgeLocations(java.util.List<java.lang.String> edgeLocations) {
            this.edgeLocations = edgeLocations;
            return this;
        }

        /**
         * Sets the value of {@link CfnDirectConnectGatewayAttachmentProps#getProposedNetworkFunctionGroupChange}
         * @param proposedNetworkFunctionGroupChange Describes proposed changes to a network function group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proposedNetworkFunctionGroupChange(software.amazon.awscdk.IResolvable proposedNetworkFunctionGroupChange) {
            this.proposedNetworkFunctionGroupChange = proposedNetworkFunctionGroupChange;
            return this;
        }

        /**
         * Sets the value of {@link CfnDirectConnectGatewayAttachmentProps#getProposedNetworkFunctionGroupChange}
         * @param proposedNetworkFunctionGroupChange Describes proposed changes to a network function group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proposedNetworkFunctionGroupChange(software.amazon.awscdk.services.networkmanager.CfnDirectConnectGatewayAttachment.ProposedNetworkFunctionGroupChangeProperty proposedNetworkFunctionGroupChange) {
            this.proposedNetworkFunctionGroupChange = proposedNetworkFunctionGroupChange;
            return this;
        }

        /**
         * Sets the value of {@link CfnDirectConnectGatewayAttachmentProps#getProposedSegmentChange}
         * @param proposedSegmentChange Describes a proposed segment change.
         *                              In some cases, the segment change must first be evaluated and accepted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proposedSegmentChange(software.amazon.awscdk.IResolvable proposedSegmentChange) {
            this.proposedSegmentChange = proposedSegmentChange;
            return this;
        }

        /**
         * Sets the value of {@link CfnDirectConnectGatewayAttachmentProps#getProposedSegmentChange}
         * @param proposedSegmentChange Describes a proposed segment change.
         *                              In some cases, the segment change must first be evaluated and accepted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proposedSegmentChange(software.amazon.awscdk.services.networkmanager.CfnDirectConnectGatewayAttachment.ProposedSegmentChangeProperty proposedSegmentChange) {
            this.proposedSegmentChange = proposedSegmentChange;
            return this;
        }

        /**
         * Sets the value of {@link CfnDirectConnectGatewayAttachmentProps#getTags}
         * @param tags Tags for the attachment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDirectConnectGatewayAttachmentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDirectConnectGatewayAttachmentProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDirectConnectGatewayAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDirectConnectGatewayAttachmentProps {
        private final java.lang.String coreNetworkId;
        private final java.lang.String directConnectGatewayArn;
        private final java.util.List<java.lang.String> edgeLocations;
        private final java.lang.Object proposedNetworkFunctionGroupChange;
        private final java.lang.Object proposedSegmentChange;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.coreNetworkId = software.amazon.jsii.Kernel.get(this, "coreNetworkId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.directConnectGatewayArn = software.amazon.jsii.Kernel.get(this, "directConnectGatewayArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.edgeLocations = software.amazon.jsii.Kernel.get(this, "edgeLocations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.proposedNetworkFunctionGroupChange = software.amazon.jsii.Kernel.get(this, "proposedNetworkFunctionGroupChange", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.proposedSegmentChange = software.amazon.jsii.Kernel.get(this, "proposedSegmentChange", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.coreNetworkId = java.util.Objects.requireNonNull(builder.coreNetworkId, "coreNetworkId is required");
            this.directConnectGatewayArn = java.util.Objects.requireNonNull(builder.directConnectGatewayArn, "directConnectGatewayArn is required");
            this.edgeLocations = java.util.Objects.requireNonNull(builder.edgeLocations, "edgeLocations is required");
            this.proposedNetworkFunctionGroupChange = builder.proposedNetworkFunctionGroupChange;
            this.proposedSegmentChange = builder.proposedSegmentChange;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getCoreNetworkId() {
            return this.coreNetworkId;
        }

        @Override
        public final java.lang.String getDirectConnectGatewayArn() {
            return this.directConnectGatewayArn;
        }

        @Override
        public final java.util.List<java.lang.String> getEdgeLocations() {
            return this.edgeLocations;
        }

        @Override
        public final java.lang.Object getProposedNetworkFunctionGroupChange() {
            return this.proposedNetworkFunctionGroupChange;
        }

        @Override
        public final java.lang.Object getProposedSegmentChange() {
            return this.proposedSegmentChange;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("coreNetworkId", om.valueToTree(this.getCoreNetworkId()));
            data.set("directConnectGatewayArn", om.valueToTree(this.getDirectConnectGatewayArn()));
            data.set("edgeLocations", om.valueToTree(this.getEdgeLocations()));
            if (this.getProposedNetworkFunctionGroupChange() != null) {
                data.set("proposedNetworkFunctionGroupChange", om.valueToTree(this.getProposedNetworkFunctionGroupChange()));
            }
            if (this.getProposedSegmentChange() != null) {
                data.set("proposedSegmentChange", om.valueToTree(this.getProposedSegmentChange()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_networkmanager.CfnDirectConnectGatewayAttachmentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDirectConnectGatewayAttachmentProps.Jsii$Proxy that = (CfnDirectConnectGatewayAttachmentProps.Jsii$Proxy) o;

            if (!coreNetworkId.equals(that.coreNetworkId)) return false;
            if (!directConnectGatewayArn.equals(that.directConnectGatewayArn)) return false;
            if (!edgeLocations.equals(that.edgeLocations)) return false;
            if (this.proposedNetworkFunctionGroupChange != null ? !this.proposedNetworkFunctionGroupChange.equals(that.proposedNetworkFunctionGroupChange) : that.proposedNetworkFunctionGroupChange != null) return false;
            if (this.proposedSegmentChange != null ? !this.proposedSegmentChange.equals(that.proposedSegmentChange) : that.proposedSegmentChange != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.coreNetworkId.hashCode();
            result = 31 * result + (this.directConnectGatewayArn.hashCode());
            result = 31 * result + (this.edgeLocations.hashCode());
            result = 31 * result + (this.proposedNetworkFunctionGroupChange != null ? this.proposedNetworkFunctionGroupChange.hashCode() : 0);
            result = 31 * result + (this.proposedSegmentChange != null ? this.proposedSegmentChange.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
