package software.amazon.awscdk.services.paymentcryptography;

/**
 * Creates an AWS Payment Cryptography key, a logical representation of a cryptographic key, that is unique in your account and AWS Region .
 * <p>
 * You use keys for cryptographic functions such as encryption and decryption.
 * <p>
 * In addition to the key material used in cryptographic operations, an AWS Payment Cryptography key includes metadata such as the key ARN, key usage, key origin, creation date, description, and key state.
 * <p>
 * When you create a key, you specify both immutable and mutable data about the key. The immutable data contains key attributes that define the scope and cryptographic operations that you can perform using the key, for example key class (example: <code>SYMMETRIC_KEY</code> ), key algorithm (example: <code>TDES_2KEY</code> ), key usage (example: <code>TR31_P0_PIN_ENCRYPTION_KEY</code> ) and key modes of use (example: <code>Encrypt</code> ). For information about valid combinations of key attributes, see <a href="https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-validattributes.html">Understanding key attributes</a> in the <em>AWS Payment Cryptography User Guide</em> . The mutable data contained within a key includes usage timestamp and key deletion timestamp and can be modified after creation.
 * <p>
 * AWS Payment Cryptography binds key attributes to keys using key blocks when you store or export them. AWS Payment Cryptography stores the key contents wrapped and never stores or transmits them in the clear.
 * <p>
 * <em>Cross-account use</em> : This operation can't be used across different AWS accounts.
 * <p>
 * <em>Related operations:</em>
 * <p>
 * <ul>
 * <li><a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_DeleteKey.html">DeleteKey</a></li>
 * <li><a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetKey.html">GetKey</a></li>
 * <li><a href="https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ListKeys.html">ListKeys</a></li>
 * </ul>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.paymentcryptography.*;
 * CfnKey cfnKey = CfnKey.Builder.create(this, "MyCfnKey")
 *         .exportable(false)
 *         .keyAttributes(KeyAttributesProperty.builder()
 *                 .keyAlgorithm("keyAlgorithm")
 *                 .keyClass("keyClass")
 *                 .keyModesOfUse(KeyModesOfUseProperty.builder()
 *                         .decrypt(false)
 *                         .deriveKey(false)
 *                         .encrypt(false)
 *                         .generate(false)
 *                         .noRestrictions(false)
 *                         .sign(false)
 *                         .unwrap(false)
 *                         .verify(false)
 *                         .wrap(false)
 *                         .build())
 *                 .keyUsage("keyUsage")
 *                 .build())
 *         // the properties below are optional
 *         .enabled(false)
 *         .keyCheckValueAlgorithm("keyCheckValueAlgorithm")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-paymentcryptography-key.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-paymentcryptography-key.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:25:01.910Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_paymentcryptography.CfnKey")
public class CfnKey extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnKey(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnKey(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.paymentcryptography.CfnKey.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnKey(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.paymentcryptography.CfnKeyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrKeyIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "attrKeyIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The source of the key material.
     * <p>
     * For keys created within AWS Payment Cryptography, the value is <code>AWS_PAYMENT_CRYPTOGRAPHY</code> . For keys imported into AWS Payment Cryptography, the value is <code>EXTERNAL</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrKeyOrigin() {
        return software.amazon.jsii.Kernel.get(this, "attrKeyOrigin", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The state of key that is being created or deleted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrKeyState() {
        return software.amazon.jsii.Kernel.get(this, "attrKeyState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Specifies whether the key is exportable.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getExportable() {
        return software.amazon.jsii.Kernel.get(this, "exportable", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether the key is exportable.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExportable(final @org.jetbrains.annotations.NotNull java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "exportable", java.util.Objects.requireNonNull(value, "exportable is required"));
    }

    /**
     * Specifies whether the key is exportable.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExportable(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "exportable", java.util.Objects.requireNonNull(value, "exportable is required"));
    }

    /**
     * The role of the key, the algorithm it supports, and the cryptographic operations allowed with the key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getKeyAttributes() {
        return software.amazon.jsii.Kernel.get(this, "keyAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The role of the key, the algorithm it supports, and the cryptographic operations allowed with the key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKeyAttributes(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "keyAttributes", java.util.Objects.requireNonNull(value, "keyAttributes is required"));
    }

    /**
     * The role of the key, the algorithm it supports, and the cryptographic operations allowed with the key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKeyAttributes(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.paymentcryptography.CfnKey.KeyAttributesProperty value) {
        software.amazon.jsii.Kernel.set(this, "keyAttributes", java.util.Objects.requireNonNull(value, "keyAttributes is required"));
    }

    /**
     * Specifies whether the key is enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
        return software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether the key is enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "enabled", value);
    }

    /**
     * Specifies whether the key is enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "enabled", value);
    }

    /**
     * The algorithm that AWS Payment Cryptography uses to calculate the key check value (KCV).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKeyCheckValueAlgorithm() {
        return software.amazon.jsii.Kernel.get(this, "keyCheckValueAlgorithm", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The algorithm that AWS Payment Cryptography uses to calculate the key check value (KCV).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKeyCheckValueAlgorithm(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "keyCheckValueAlgorithm", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * The role of the key, the algorithm it supports, and the cryptographic operations allowed with the key.
     * <p>
     * This data is immutable after the key is created.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.paymentcryptography.*;
     * KeyAttributesProperty keyAttributesProperty = KeyAttributesProperty.builder()
     *         .keyAlgorithm("keyAlgorithm")
     *         .keyClass("keyClass")
     *         .keyModesOfUse(KeyModesOfUseProperty.builder()
     *                 .decrypt(false)
     *                 .deriveKey(false)
     *                 .encrypt(false)
     *                 .generate(false)
     *                 .noRestrictions(false)
     *                 .sign(false)
     *                 .unwrap(false)
     *                 .verify(false)
     *                 .wrap(false)
     *                 .build())
     *         .keyUsage("keyUsage")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-paymentcryptography-key-keyattributes.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-paymentcryptography-key-keyattributes.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_paymentcryptography.CfnKey.KeyAttributesProperty")
    @software.amazon.jsii.Jsii.Proxy(KeyAttributesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KeyAttributesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The key algorithm to be use during creation of an AWS Payment Cryptography key.
         * <p>
         * For symmetric keys, AWS Payment Cryptography supports <code>AES</code> and <code>TDES</code> algorithms. For asymmetric keys, AWS Payment Cryptography supports <code>RSA</code> and <code>ECC_NIST</code> algorithms.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-paymentcryptography-key-keyattributes.html#cfn-paymentcryptography-key-keyattributes-keyalgorithm">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-paymentcryptography-key-keyattributes.html#cfn-paymentcryptography-key-keyattributes-keyalgorithm</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKeyAlgorithm();

        /**
         * The type of AWS Payment Cryptography key to create, which determines the classiﬁcation of the cryptographic method and whether AWS Payment Cryptography key contains a symmetric key or an asymmetric key pair.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-paymentcryptography-key-keyattributes.html#cfn-paymentcryptography-key-keyattributes-keyclass">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-paymentcryptography-key-keyattributes.html#cfn-paymentcryptography-key-keyattributes-keyclass</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKeyClass();

        /**
         * The list of cryptographic operations that you can perform using the key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-paymentcryptography-key-keyattributes.html#cfn-paymentcryptography-key-keyattributes-keymodesofuse">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-paymentcryptography-key-keyattributes.html#cfn-paymentcryptography-key-keyattributes-keymodesofuse</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getKeyModesOfUse();

        /**
         * The cryptographic usage of an AWS Payment Cryptography key as deﬁned in section A.5.2 of the TR-31 spec.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-paymentcryptography-key-keyattributes.html#cfn-paymentcryptography-key-keyattributes-keyusage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-paymentcryptography-key-keyattributes.html#cfn-paymentcryptography-key-keyattributes-keyusage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKeyUsage();

        /**
         * @return a {@link Builder} of {@link KeyAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KeyAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KeyAttributesProperty> {
            java.lang.String keyAlgorithm;
            java.lang.String keyClass;
            java.lang.Object keyModesOfUse;
            java.lang.String keyUsage;

            /**
             * Sets the value of {@link KeyAttributesProperty#getKeyAlgorithm}
             * @param keyAlgorithm The key algorithm to be use during creation of an AWS Payment Cryptography key. This parameter is required.
             *                     For symmetric keys, AWS Payment Cryptography supports <code>AES</code> and <code>TDES</code> algorithms. For asymmetric keys, AWS Payment Cryptography supports <code>RSA</code> and <code>ECC_NIST</code> algorithms.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyAlgorithm(java.lang.String keyAlgorithm) {
                this.keyAlgorithm = keyAlgorithm;
                return this;
            }

            /**
             * Sets the value of {@link KeyAttributesProperty#getKeyClass}
             * @param keyClass The type of AWS Payment Cryptography key to create, which determines the classiﬁcation of the cryptographic method and whether AWS Payment Cryptography key contains a symmetric key or an asymmetric key pair. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyClass(java.lang.String keyClass) {
                this.keyClass = keyClass;
                return this;
            }

            /**
             * Sets the value of {@link KeyAttributesProperty#getKeyModesOfUse}
             * @param keyModesOfUse The list of cryptographic operations that you can perform using the key. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyModesOfUse(software.amazon.awscdk.IResolvable keyModesOfUse) {
                this.keyModesOfUse = keyModesOfUse;
                return this;
            }

            /**
             * Sets the value of {@link KeyAttributesProperty#getKeyModesOfUse}
             * @param keyModesOfUse The list of cryptographic operations that you can perform using the key. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyModesOfUse(software.amazon.awscdk.services.paymentcryptography.CfnKey.KeyModesOfUseProperty keyModesOfUse) {
                this.keyModesOfUse = keyModesOfUse;
                return this;
            }

            /**
             * Sets the value of {@link KeyAttributesProperty#getKeyUsage}
             * @param keyUsage The cryptographic usage of an AWS Payment Cryptography key as deﬁned in section A.5.2 of the TR-31 spec. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder keyUsage(java.lang.String keyUsage) {
                this.keyUsage = keyUsage;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KeyAttributesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KeyAttributesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KeyAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KeyAttributesProperty {
            private final java.lang.String keyAlgorithm;
            private final java.lang.String keyClass;
            private final java.lang.Object keyModesOfUse;
            private final java.lang.String keyUsage;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.keyAlgorithm = software.amazon.jsii.Kernel.get(this, "keyAlgorithm", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.keyClass = software.amazon.jsii.Kernel.get(this, "keyClass", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.keyModesOfUse = software.amazon.jsii.Kernel.get(this, "keyModesOfUse", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.keyUsage = software.amazon.jsii.Kernel.get(this, "keyUsage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.keyAlgorithm = java.util.Objects.requireNonNull(builder.keyAlgorithm, "keyAlgorithm is required");
                this.keyClass = java.util.Objects.requireNonNull(builder.keyClass, "keyClass is required");
                this.keyModesOfUse = java.util.Objects.requireNonNull(builder.keyModesOfUse, "keyModesOfUse is required");
                this.keyUsage = java.util.Objects.requireNonNull(builder.keyUsage, "keyUsage is required");
            }

            @Override
            public final java.lang.String getKeyAlgorithm() {
                return this.keyAlgorithm;
            }

            @Override
            public final java.lang.String getKeyClass() {
                return this.keyClass;
            }

            @Override
            public final java.lang.Object getKeyModesOfUse() {
                return this.keyModesOfUse;
            }

            @Override
            public final java.lang.String getKeyUsage() {
                return this.keyUsage;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("keyAlgorithm", om.valueToTree(this.getKeyAlgorithm()));
                data.set("keyClass", om.valueToTree(this.getKeyClass()));
                data.set("keyModesOfUse", om.valueToTree(this.getKeyModesOfUse()));
                data.set("keyUsage", om.valueToTree(this.getKeyUsage()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_paymentcryptography.CfnKey.KeyAttributesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KeyAttributesProperty.Jsii$Proxy that = (KeyAttributesProperty.Jsii$Proxy) o;

                if (!keyAlgorithm.equals(that.keyAlgorithm)) return false;
                if (!keyClass.equals(that.keyClass)) return false;
                if (!keyModesOfUse.equals(that.keyModesOfUse)) return false;
                return this.keyUsage.equals(that.keyUsage);
            }

            @Override
            public final int hashCode() {
                int result = this.keyAlgorithm.hashCode();
                result = 31 * result + (this.keyClass.hashCode());
                result = 31 * result + (this.keyModesOfUse.hashCode());
                result = 31 * result + (this.keyUsage.hashCode());
                return result;
            }
        }
    }
    /**
     * The list of cryptographic operations that you can perform using the key.
     * <p>
     * The modes of use are deﬁned in section A.5.3 of the TR-31 spec.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.paymentcryptography.*;
     * KeyModesOfUseProperty keyModesOfUseProperty = KeyModesOfUseProperty.builder()
     *         .decrypt(false)
     *         .deriveKey(false)
     *         .encrypt(false)
     *         .generate(false)
     *         .noRestrictions(false)
     *         .sign(false)
     *         .unwrap(false)
     *         .verify(false)
     *         .wrap(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-paymentcryptography-key-keymodesofuse.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-paymentcryptography-key-keymodesofuse.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_paymentcryptography.CfnKey.KeyModesOfUseProperty")
    @software.amazon.jsii.Jsii.Proxy(KeyModesOfUseProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KeyModesOfUseProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Speciﬁes whether an AWS Payment Cryptography key can be used to decrypt data.
         * <p>
         * Default: - false
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-paymentcryptography-key-keymodesofuse.html#cfn-paymentcryptography-key-keymodesofuse-decrypt">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-paymentcryptography-key-keymodesofuse.html#cfn-paymentcryptography-key-keymodesofuse-decrypt</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDecrypt() {
            return null;
        }

        /**
         * Speciﬁes whether an AWS Payment Cryptography key can be used to derive new keys.
         * <p>
         * Default: - false
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-paymentcryptography-key-keymodesofuse.html#cfn-paymentcryptography-key-keymodesofuse-derivekey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-paymentcryptography-key-keymodesofuse.html#cfn-paymentcryptography-key-keymodesofuse-derivekey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDeriveKey() {
            return null;
        }

        /**
         * Speciﬁes whether an AWS Payment Cryptography key can be used to encrypt data.
         * <p>
         * Default: - false
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-paymentcryptography-key-keymodesofuse.html#cfn-paymentcryptography-key-keymodesofuse-encrypt">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-paymentcryptography-key-keymodesofuse.html#cfn-paymentcryptography-key-keymodesofuse-encrypt</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEncrypt() {
            return null;
        }

        /**
         * Speciﬁes whether an AWS Payment Cryptography key can be used to generate and verify other card and PIN verification keys.
         * <p>
         * Default: - false
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-paymentcryptography-key-keymodesofuse.html#cfn-paymentcryptography-key-keymodesofuse-generate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-paymentcryptography-key-keymodesofuse.html#cfn-paymentcryptography-key-keymodesofuse-generate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGenerate() {
            return null;
        }

        /**
         * Speciﬁes whether an AWS Payment Cryptography key has no special restrictions other than the restrictions implied by <code>KeyUsage</code> .
         * <p>
         * Default: - false
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-paymentcryptography-key-keymodesofuse.html#cfn-paymentcryptography-key-keymodesofuse-norestrictions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-paymentcryptography-key-keymodesofuse.html#cfn-paymentcryptography-key-keymodesofuse-norestrictions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNoRestrictions() {
            return null;
        }

        /**
         * Speciﬁes whether an AWS Payment Cryptography key can be used for signing.
         * <p>
         * Default: - false
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-paymentcryptography-key-keymodesofuse.html#cfn-paymentcryptography-key-keymodesofuse-sign">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-paymentcryptography-key-keymodesofuse.html#cfn-paymentcryptography-key-keymodesofuse-sign</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSign() {
            return null;
        }

        /**
         * Default: - false
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-paymentcryptography-key-keymodesofuse.html#cfn-paymentcryptography-key-keymodesofuse-unwrap">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-paymentcryptography-key-keymodesofuse.html#cfn-paymentcryptography-key-keymodesofuse-unwrap</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUnwrap() {
            return null;
        }

        /**
         * Speciﬁes whether an AWS Payment Cryptography key can be used to verify signatures.
         * <p>
         * Default: - false
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-paymentcryptography-key-keymodesofuse.html#cfn-paymentcryptography-key-keymodesofuse-verify">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-paymentcryptography-key-keymodesofuse.html#cfn-paymentcryptography-key-keymodesofuse-verify</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVerify() {
            return null;
        }

        /**
         * Speciﬁes whether an AWS Payment Cryptography key can be used to wrap other keys.
         * <p>
         * Default: - false
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-paymentcryptography-key-keymodesofuse.html#cfn-paymentcryptography-key-keymodesofuse-wrap">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-paymentcryptography-key-keymodesofuse.html#cfn-paymentcryptography-key-keymodesofuse-wrap</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getWrap() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link KeyModesOfUseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KeyModesOfUseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KeyModesOfUseProperty> {
            java.lang.Object decrypt;
            java.lang.Object deriveKey;
            java.lang.Object encrypt;
            java.lang.Object generate;
            java.lang.Object noRestrictions;
            java.lang.Object sign;
            java.lang.Object unwrap;
            java.lang.Object verify;
            java.lang.Object wrap;

            /**
             * Sets the value of {@link KeyModesOfUseProperty#getDecrypt}
             * @param decrypt Speciﬁes whether an AWS Payment Cryptography key can be used to decrypt data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder decrypt(java.lang.Boolean decrypt) {
                this.decrypt = decrypt;
                return this;
            }

            /**
             * Sets the value of {@link KeyModesOfUseProperty#getDecrypt}
             * @param decrypt Speciﬁes whether an AWS Payment Cryptography key can be used to decrypt data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder decrypt(software.amazon.awscdk.IResolvable decrypt) {
                this.decrypt = decrypt;
                return this;
            }

            /**
             * Sets the value of {@link KeyModesOfUseProperty#getDeriveKey}
             * @param deriveKey Speciﬁes whether an AWS Payment Cryptography key can be used to derive new keys.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deriveKey(java.lang.Boolean deriveKey) {
                this.deriveKey = deriveKey;
                return this;
            }

            /**
             * Sets the value of {@link KeyModesOfUseProperty#getDeriveKey}
             * @param deriveKey Speciﬁes whether an AWS Payment Cryptography key can be used to derive new keys.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deriveKey(software.amazon.awscdk.IResolvable deriveKey) {
                this.deriveKey = deriveKey;
                return this;
            }

            /**
             * Sets the value of {@link KeyModesOfUseProperty#getEncrypt}
             * @param encrypt Speciﬁes whether an AWS Payment Cryptography key can be used to encrypt data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encrypt(java.lang.Boolean encrypt) {
                this.encrypt = encrypt;
                return this;
            }

            /**
             * Sets the value of {@link KeyModesOfUseProperty#getEncrypt}
             * @param encrypt Speciﬁes whether an AWS Payment Cryptography key can be used to encrypt data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encrypt(software.amazon.awscdk.IResolvable encrypt) {
                this.encrypt = encrypt;
                return this;
            }

            /**
             * Sets the value of {@link KeyModesOfUseProperty#getGenerate}
             * @param generate Speciﬁes whether an AWS Payment Cryptography key can be used to generate and verify other card and PIN verification keys.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder generate(java.lang.Boolean generate) {
                this.generate = generate;
                return this;
            }

            /**
             * Sets the value of {@link KeyModesOfUseProperty#getGenerate}
             * @param generate Speciﬁes whether an AWS Payment Cryptography key can be used to generate and verify other card and PIN verification keys.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder generate(software.amazon.awscdk.IResolvable generate) {
                this.generate = generate;
                return this;
            }

            /**
             * Sets the value of {@link KeyModesOfUseProperty#getNoRestrictions}
             * @param noRestrictions Speciﬁes whether an AWS Payment Cryptography key has no special restrictions other than the restrictions implied by <code>KeyUsage</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noRestrictions(java.lang.Boolean noRestrictions) {
                this.noRestrictions = noRestrictions;
                return this;
            }

            /**
             * Sets the value of {@link KeyModesOfUseProperty#getNoRestrictions}
             * @param noRestrictions Speciﬁes whether an AWS Payment Cryptography key has no special restrictions other than the restrictions implied by <code>KeyUsage</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noRestrictions(software.amazon.awscdk.IResolvable noRestrictions) {
                this.noRestrictions = noRestrictions;
                return this;
            }

            /**
             * Sets the value of {@link KeyModesOfUseProperty#getSign}
             * @param sign Speciﬁes whether an AWS Payment Cryptography key can be used for signing.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sign(java.lang.Boolean sign) {
                this.sign = sign;
                return this;
            }

            /**
             * Sets the value of {@link KeyModesOfUseProperty#getSign}
             * @param sign Speciﬁes whether an AWS Payment Cryptography key can be used for signing.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sign(software.amazon.awscdk.IResolvable sign) {
                this.sign = sign;
                return this;
            }

            /**
             * Sets the value of {@link KeyModesOfUseProperty#getUnwrap}
             * @param unwrap the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unwrap(java.lang.Boolean unwrap) {
                this.unwrap = unwrap;
                return this;
            }

            /**
             * Sets the value of {@link KeyModesOfUseProperty#getUnwrap}
             * @param unwrap the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unwrap(software.amazon.awscdk.IResolvable unwrap) {
                this.unwrap = unwrap;
                return this;
            }

            /**
             * Sets the value of {@link KeyModesOfUseProperty#getVerify}
             * @param verify Speciﬁes whether an AWS Payment Cryptography key can be used to verify signatures.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder verify(java.lang.Boolean verify) {
                this.verify = verify;
                return this;
            }

            /**
             * Sets the value of {@link KeyModesOfUseProperty#getVerify}
             * @param verify Speciﬁes whether an AWS Payment Cryptography key can be used to verify signatures.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder verify(software.amazon.awscdk.IResolvable verify) {
                this.verify = verify;
                return this;
            }

            /**
             * Sets the value of {@link KeyModesOfUseProperty#getWrap}
             * @param wrap Speciﬁes whether an AWS Payment Cryptography key can be used to wrap other keys.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder wrap(java.lang.Boolean wrap) {
                this.wrap = wrap;
                return this;
            }

            /**
             * Sets the value of {@link KeyModesOfUseProperty#getWrap}
             * @param wrap Speciﬁes whether an AWS Payment Cryptography key can be used to wrap other keys.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder wrap(software.amazon.awscdk.IResolvable wrap) {
                this.wrap = wrap;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KeyModesOfUseProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KeyModesOfUseProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KeyModesOfUseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KeyModesOfUseProperty {
            private final java.lang.Object decrypt;
            private final java.lang.Object deriveKey;
            private final java.lang.Object encrypt;
            private final java.lang.Object generate;
            private final java.lang.Object noRestrictions;
            private final java.lang.Object sign;
            private final java.lang.Object unwrap;
            private final java.lang.Object verify;
            private final java.lang.Object wrap;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.decrypt = software.amazon.jsii.Kernel.get(this, "decrypt", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.deriveKey = software.amazon.jsii.Kernel.get(this, "deriveKey", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.encrypt = software.amazon.jsii.Kernel.get(this, "encrypt", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.generate = software.amazon.jsii.Kernel.get(this, "generate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.noRestrictions = software.amazon.jsii.Kernel.get(this, "noRestrictions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sign = software.amazon.jsii.Kernel.get(this, "sign", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.unwrap = software.amazon.jsii.Kernel.get(this, "unwrap", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.verify = software.amazon.jsii.Kernel.get(this, "verify", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.wrap = software.amazon.jsii.Kernel.get(this, "wrap", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.decrypt = builder.decrypt;
                this.deriveKey = builder.deriveKey;
                this.encrypt = builder.encrypt;
                this.generate = builder.generate;
                this.noRestrictions = builder.noRestrictions;
                this.sign = builder.sign;
                this.unwrap = builder.unwrap;
                this.verify = builder.verify;
                this.wrap = builder.wrap;
            }

            @Override
            public final java.lang.Object getDecrypt() {
                return this.decrypt;
            }

            @Override
            public final java.lang.Object getDeriveKey() {
                return this.deriveKey;
            }

            @Override
            public final java.lang.Object getEncrypt() {
                return this.encrypt;
            }

            @Override
            public final java.lang.Object getGenerate() {
                return this.generate;
            }

            @Override
            public final java.lang.Object getNoRestrictions() {
                return this.noRestrictions;
            }

            @Override
            public final java.lang.Object getSign() {
                return this.sign;
            }

            @Override
            public final java.lang.Object getUnwrap() {
                return this.unwrap;
            }

            @Override
            public final java.lang.Object getVerify() {
                return this.verify;
            }

            @Override
            public final java.lang.Object getWrap() {
                return this.wrap;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDecrypt() != null) {
                    data.set("decrypt", om.valueToTree(this.getDecrypt()));
                }
                if (this.getDeriveKey() != null) {
                    data.set("deriveKey", om.valueToTree(this.getDeriveKey()));
                }
                if (this.getEncrypt() != null) {
                    data.set("encrypt", om.valueToTree(this.getEncrypt()));
                }
                if (this.getGenerate() != null) {
                    data.set("generate", om.valueToTree(this.getGenerate()));
                }
                if (this.getNoRestrictions() != null) {
                    data.set("noRestrictions", om.valueToTree(this.getNoRestrictions()));
                }
                if (this.getSign() != null) {
                    data.set("sign", om.valueToTree(this.getSign()));
                }
                if (this.getUnwrap() != null) {
                    data.set("unwrap", om.valueToTree(this.getUnwrap()));
                }
                if (this.getVerify() != null) {
                    data.set("verify", om.valueToTree(this.getVerify()));
                }
                if (this.getWrap() != null) {
                    data.set("wrap", om.valueToTree(this.getWrap()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_paymentcryptography.CfnKey.KeyModesOfUseProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KeyModesOfUseProperty.Jsii$Proxy that = (KeyModesOfUseProperty.Jsii$Proxy) o;

                if (this.decrypt != null ? !this.decrypt.equals(that.decrypt) : that.decrypt != null) return false;
                if (this.deriveKey != null ? !this.deriveKey.equals(that.deriveKey) : that.deriveKey != null) return false;
                if (this.encrypt != null ? !this.encrypt.equals(that.encrypt) : that.encrypt != null) return false;
                if (this.generate != null ? !this.generate.equals(that.generate) : that.generate != null) return false;
                if (this.noRestrictions != null ? !this.noRestrictions.equals(that.noRestrictions) : that.noRestrictions != null) return false;
                if (this.sign != null ? !this.sign.equals(that.sign) : that.sign != null) return false;
                if (this.unwrap != null ? !this.unwrap.equals(that.unwrap) : that.unwrap != null) return false;
                if (this.verify != null ? !this.verify.equals(that.verify) : that.verify != null) return false;
                return this.wrap != null ? this.wrap.equals(that.wrap) : that.wrap == null;
            }

            @Override
            public final int hashCode() {
                int result = this.decrypt != null ? this.decrypt.hashCode() : 0;
                result = 31 * result + (this.deriveKey != null ? this.deriveKey.hashCode() : 0);
                result = 31 * result + (this.encrypt != null ? this.encrypt.hashCode() : 0);
                result = 31 * result + (this.generate != null ? this.generate.hashCode() : 0);
                result = 31 * result + (this.noRestrictions != null ? this.noRestrictions.hashCode() : 0);
                result = 31 * result + (this.sign != null ? this.sign.hashCode() : 0);
                result = 31 * result + (this.unwrap != null ? this.unwrap.hashCode() : 0);
                result = 31 * result + (this.verify != null ? this.verify.hashCode() : 0);
                result = 31 * result + (this.wrap != null ? this.wrap.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.paymentcryptography.CfnKey}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.paymentcryptography.CfnKey> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.paymentcryptography.CfnKeyProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.paymentcryptography.CfnKeyProps.Builder();
        }

        /**
         * Specifies whether the key is exportable.
         * <p>
         * This data is immutable after the key is created.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-paymentcryptography-key.html#cfn-paymentcryptography-key-exportable">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-paymentcryptography-key.html#cfn-paymentcryptography-key-exportable</a>
         * @param exportable Specifies whether the key is exportable. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exportable(final java.lang.Boolean exportable) {
            this.props.exportable(exportable);
            return this;
        }
        /**
         * Specifies whether the key is exportable.
         * <p>
         * This data is immutable after the key is created.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-paymentcryptography-key.html#cfn-paymentcryptography-key-exportable">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-paymentcryptography-key.html#cfn-paymentcryptography-key-exportable</a>
         * @param exportable Specifies whether the key is exportable. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exportable(final software.amazon.awscdk.IResolvable exportable) {
            this.props.exportable(exportable);
            return this;
        }

        /**
         * The role of the key, the algorithm it supports, and the cryptographic operations allowed with the key.
         * <p>
         * This data is immutable after the key is created.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-paymentcryptography-key.html#cfn-paymentcryptography-key-keyattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-paymentcryptography-key.html#cfn-paymentcryptography-key-keyattributes</a>
         * @param keyAttributes The role of the key, the algorithm it supports, and the cryptographic operations allowed with the key. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyAttributes(final software.amazon.awscdk.IResolvable keyAttributes) {
            this.props.keyAttributes(keyAttributes);
            return this;
        }
        /**
         * The role of the key, the algorithm it supports, and the cryptographic operations allowed with the key.
         * <p>
         * This data is immutable after the key is created.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-paymentcryptography-key.html#cfn-paymentcryptography-key-keyattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-paymentcryptography-key.html#cfn-paymentcryptography-key-keyattributes</a>
         * @param keyAttributes The role of the key, the algorithm it supports, and the cryptographic operations allowed with the key. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyAttributes(final software.amazon.awscdk.services.paymentcryptography.CfnKey.KeyAttributesProperty keyAttributes) {
            this.props.keyAttributes(keyAttributes);
            return this;
        }

        /**
         * Specifies whether the key is enabled.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-paymentcryptography-key.html#cfn-paymentcryptography-key-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-paymentcryptography-key.html#cfn-paymentcryptography-key-enabled</a>
         * @param enabled Specifies whether the key is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(final java.lang.Boolean enabled) {
            this.props.enabled(enabled);
            return this;
        }
        /**
         * Specifies whether the key is enabled.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-paymentcryptography-key.html#cfn-paymentcryptography-key-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-paymentcryptography-key.html#cfn-paymentcryptography-key-enabled</a>
         * @param enabled Specifies whether the key is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(final software.amazon.awscdk.IResolvable enabled) {
            this.props.enabled(enabled);
            return this;
        }

        /**
         * The algorithm that AWS Payment Cryptography uses to calculate the key check value (KCV).
         * <p>
         * It is used to validate the key integrity.
         * <p>
         * For TDES keys, the KCV is computed by encrypting 8 bytes, each with value of zero, with the key to be checked and retaining the 3 highest order bytes of the encrypted result. For AES keys, the KCV is computed using a CMAC algorithm where the input data is 16 bytes of zero and retaining the 3 highest order bytes of the encrypted result.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-paymentcryptography-key.html#cfn-paymentcryptography-key-keycheckvaluealgorithm">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-paymentcryptography-key.html#cfn-paymentcryptography-key-keycheckvaluealgorithm</a>
         * @param keyCheckValueAlgorithm The algorithm that AWS Payment Cryptography uses to calculate the key check value (KCV). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyCheckValueAlgorithm(final java.lang.String keyCheckValueAlgorithm) {
            this.props.keyCheckValueAlgorithm(keyCheckValueAlgorithm);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-paymentcryptography-key.html#cfn-paymentcryptography-key-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-paymentcryptography-key.html#cfn-paymentcryptography-key-tags</a>
         * @param tags This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.paymentcryptography.CfnKey}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.paymentcryptography.CfnKey build() {
            return new software.amazon.awscdk.services.paymentcryptography.CfnKey(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
