package software.amazon.awscdk.services.paymentcryptography;

/**
 * Properties for defining a <code>CfnKey</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.paymentcryptography.*;
 * CfnKeyProps cfnKeyProps = CfnKeyProps.builder()
 *         .exportable(false)
 *         .keyAttributes(KeyAttributesProperty.builder()
 *                 .keyAlgorithm("keyAlgorithm")
 *                 .keyClass("keyClass")
 *                 .keyModesOfUse(KeyModesOfUseProperty.builder()
 *                         .decrypt(false)
 *                         .deriveKey(false)
 *                         .encrypt(false)
 *                         .generate(false)
 *                         .noRestrictions(false)
 *                         .sign(false)
 *                         .unwrap(false)
 *                         .verify(false)
 *                         .wrap(false)
 *                         .build())
 *                 .keyUsage("keyUsage")
 *                 .build())
 *         // the properties below are optional
 *         .enabled(false)
 *         .keyCheckValueAlgorithm("keyCheckValueAlgorithm")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-paymentcryptography-key.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-paymentcryptography-key.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:25:01.922Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_paymentcryptography.CfnKeyProps")
@software.amazon.jsii.Jsii.Proxy(CfnKeyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnKeyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies whether the key is exportable.
     * <p>
     * This data is immutable after the key is created.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-paymentcryptography-key.html#cfn-paymentcryptography-key-exportable">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-paymentcryptography-key.html#cfn-paymentcryptography-key-exportable</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getExportable();

    /**
     * The role of the key, the algorithm it supports, and the cryptographic operations allowed with the key.
     * <p>
     * This data is immutable after the key is created.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-paymentcryptography-key.html#cfn-paymentcryptography-key-keyattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-paymentcryptography-key.html#cfn-paymentcryptography-key-keyattributes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getKeyAttributes();

    /**
     * Specifies whether the key is enabled.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-paymentcryptography-key.html#cfn-paymentcryptography-key-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-paymentcryptography-key.html#cfn-paymentcryptography-key-enabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
        return null;
    }

    /**
     * The algorithm that AWS Payment Cryptography uses to calculate the key check value (KCV).
     * <p>
     * It is used to validate the key integrity.
     * <p>
     * For TDES keys, the KCV is computed by encrypting 8 bytes, each with value of zero, with the key to be checked and retaining the 3 highest order bytes of the encrypted result. For AES keys, the KCV is computed using a CMAC algorithm where the input data is 16 bytes of zero and retaining the 3 highest order bytes of the encrypted result.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-paymentcryptography-key.html#cfn-paymentcryptography-key-keycheckvaluealgorithm">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-paymentcryptography-key.html#cfn-paymentcryptography-key-keycheckvaluealgorithm</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKeyCheckValueAlgorithm() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-paymentcryptography-key.html#cfn-paymentcryptography-key-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-paymentcryptography-key.html#cfn-paymentcryptography-key-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnKeyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnKeyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnKeyProps> {
        java.lang.Object exportable;
        java.lang.Object keyAttributes;
        java.lang.Object enabled;
        java.lang.String keyCheckValueAlgorithm;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnKeyProps#getExportable}
         * @param exportable Specifies whether the key is exportable. This parameter is required.
         *                   This data is immutable after the key is created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exportable(java.lang.Boolean exportable) {
            this.exportable = exportable;
            return this;
        }

        /**
         * Sets the value of {@link CfnKeyProps#getExportable}
         * @param exportable Specifies whether the key is exportable. This parameter is required.
         *                   This data is immutable after the key is created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exportable(software.amazon.awscdk.IResolvable exportable) {
            this.exportable = exportable;
            return this;
        }

        /**
         * Sets the value of {@link CfnKeyProps#getKeyAttributes}
         * @param keyAttributes The role of the key, the algorithm it supports, and the cryptographic operations allowed with the key. This parameter is required.
         *                      This data is immutable after the key is created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyAttributes(software.amazon.awscdk.IResolvable keyAttributes) {
            this.keyAttributes = keyAttributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnKeyProps#getKeyAttributes}
         * @param keyAttributes The role of the key, the algorithm it supports, and the cryptographic operations allowed with the key. This parameter is required.
         *                      This data is immutable after the key is created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyAttributes(software.amazon.awscdk.services.paymentcryptography.CfnKey.KeyAttributesProperty keyAttributes) {
            this.keyAttributes = keyAttributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnKeyProps#getEnabled}
         * @param enabled Specifies whether the key is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnKeyProps#getEnabled}
         * @param enabled Specifies whether the key is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnKeyProps#getKeyCheckValueAlgorithm}
         * @param keyCheckValueAlgorithm The algorithm that AWS Payment Cryptography uses to calculate the key check value (KCV).
         *                               It is used to validate the key integrity.
         *                               <p>
         *                               For TDES keys, the KCV is computed by encrypting 8 bytes, each with value of zero, with the key to be checked and retaining the 3 highest order bytes of the encrypted result. For AES keys, the KCV is computed using a CMAC algorithm where the input data is 16 bytes of zero and retaining the 3 highest order bytes of the encrypted result.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyCheckValueAlgorithm(java.lang.String keyCheckValueAlgorithm) {
            this.keyCheckValueAlgorithm = keyCheckValueAlgorithm;
            return this;
        }

        /**
         * Sets the value of {@link CfnKeyProps#getTags}
         * @param tags the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnKeyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnKeyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnKeyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnKeyProps {
        private final java.lang.Object exportable;
        private final java.lang.Object keyAttributes;
        private final java.lang.Object enabled;
        private final java.lang.String keyCheckValueAlgorithm;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.exportable = software.amazon.jsii.Kernel.get(this, "exportable", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.keyAttributes = software.amazon.jsii.Kernel.get(this, "keyAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.keyCheckValueAlgorithm = software.amazon.jsii.Kernel.get(this, "keyCheckValueAlgorithm", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.exportable = java.util.Objects.requireNonNull(builder.exportable, "exportable is required");
            this.keyAttributes = java.util.Objects.requireNonNull(builder.keyAttributes, "keyAttributes is required");
            this.enabled = builder.enabled;
            this.keyCheckValueAlgorithm = builder.keyCheckValueAlgorithm;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getExportable() {
            return this.exportable;
        }

        @Override
        public final java.lang.Object getKeyAttributes() {
            return this.keyAttributes;
        }

        @Override
        public final java.lang.Object getEnabled() {
            return this.enabled;
        }

        @Override
        public final java.lang.String getKeyCheckValueAlgorithm() {
            return this.keyCheckValueAlgorithm;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("exportable", om.valueToTree(this.getExportable()));
            data.set("keyAttributes", om.valueToTree(this.getKeyAttributes()));
            if (this.getEnabled() != null) {
                data.set("enabled", om.valueToTree(this.getEnabled()));
            }
            if (this.getKeyCheckValueAlgorithm() != null) {
                data.set("keyCheckValueAlgorithm", om.valueToTree(this.getKeyCheckValueAlgorithm()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_paymentcryptography.CfnKeyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnKeyProps.Jsii$Proxy that = (CfnKeyProps.Jsii$Proxy) o;

            if (!exportable.equals(that.exportable)) return false;
            if (!keyAttributes.equals(that.keyAttributes)) return false;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
            if (this.keyCheckValueAlgorithm != null ? !this.keyCheckValueAlgorithm.equals(that.keyCheckValueAlgorithm) : that.keyCheckValueAlgorithm != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.exportable.hashCode();
            result = 31 * result + (this.keyAttributes.hashCode());
            result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
            result = 31 * result + (this.keyCheckValueAlgorithm != null ? this.keyCheckValueAlgorithm.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
