package software.amazon.awscdk.services.route53;

/**
 * Properties of a new hosted zone.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * HostedZone hostedZone = HostedZone.Builder.create(this, "MyHostedZone").zoneName("example.org").build();
 * Metric metric = Metric.Builder.create()
 *         .namespace("AWS/Route53")
 *         .metricName("DNSQueries")
 *         .dimensionsMap(Map.of(
 *                 "HostedZoneId", hostedZone.getHostedZoneId()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:25:04.515Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53.HostedZoneProps")
@software.amazon.jsii.Jsii.Proxy(HostedZoneProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface HostedZoneProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.route53.CommonHostedZoneProps {

    /**
     * A VPC that you want to associate with this hosted zone.
     * <p>
     * When you specify
     * this property, a private hosted zone will be created.
     * <p>
     * You can associate additional VPCs to this private zone using <code>addVpc(vpc)</code>.
     * <p>
     * Default: public (no VPCs associated)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.IVpc> getVpcs() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link HostedZoneProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link HostedZoneProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<HostedZoneProps> {
        java.util.List<software.amazon.awscdk.services.ec2.IVpc> vpcs;
        java.lang.String zoneName;
        java.lang.Boolean addTrailingDot;
        java.lang.String comment;
        java.lang.String queryLogsLogGroupArn;

        /**
         * Sets the value of {@link HostedZoneProps#getVpcs}
         * @param vpcs A VPC that you want to associate with this hosted zone.
         *             When you specify
         *             this property, a private hosted zone will be created.
         *             <p>
         *             You can associate additional VPCs to this private zone using <code>addVpc(vpc)</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder vpcs(java.util.List<? extends software.amazon.awscdk.services.ec2.IVpc> vpcs) {
            this.vpcs = (java.util.List<software.amazon.awscdk.services.ec2.IVpc>)vpcs;
            return this;
        }

        /**
         * Sets the value of {@link HostedZoneProps#getZoneName}
         * @param zoneName The name of the domain. This parameter is required.
         *                 For resource record types that include a domain
         *                 name, specify a fully qualified domain name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder zoneName(java.lang.String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        /**
         * Sets the value of {@link HostedZoneProps#getAddTrailingDot}
         * @param addTrailingDot Whether to add a trailing dot to the zone name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder addTrailingDot(java.lang.Boolean addTrailingDot) {
            this.addTrailingDot = addTrailingDot;
            return this;
        }

        /**
         * Sets the value of {@link HostedZoneProps#getComment}
         * @param comment Any comments that you want to include about the hosted zone.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(java.lang.String comment) {
            this.comment = comment;
            return this;
        }

        /**
         * Sets the value of {@link HostedZoneProps#getQueryLogsLogGroupArn}
         * @param queryLogsLogGroupArn The Amazon Resource Name (ARN) for the log group that you want Amazon Route 53 to send query logs to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryLogsLogGroupArn(java.lang.String queryLogsLogGroupArn) {
            this.queryLogsLogGroupArn = queryLogsLogGroupArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link HostedZoneProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public HostedZoneProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link HostedZoneProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HostedZoneProps {
        private final java.util.List<software.amazon.awscdk.services.ec2.IVpc> vpcs;
        private final java.lang.String zoneName;
        private final java.lang.Boolean addTrailingDot;
        private final java.lang.String comment;
        private final java.lang.String queryLogsLogGroupArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.vpcs = software.amazon.jsii.Kernel.get(this, "vpcs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class)));
            this.zoneName = software.amazon.jsii.Kernel.get(this, "zoneName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.addTrailingDot = software.amazon.jsii.Kernel.get(this, "addTrailingDot", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.queryLogsLogGroupArn = software.amazon.jsii.Kernel.get(this, "queryLogsLogGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.vpcs = (java.util.List<software.amazon.awscdk.services.ec2.IVpc>)builder.vpcs;
            this.zoneName = java.util.Objects.requireNonNull(builder.zoneName, "zoneName is required");
            this.addTrailingDot = builder.addTrailingDot;
            this.comment = builder.comment;
            this.queryLogsLogGroupArn = builder.queryLogsLogGroupArn;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.IVpc> getVpcs() {
            return this.vpcs;
        }

        @Override
        public final java.lang.String getZoneName() {
            return this.zoneName;
        }

        @Override
        public final java.lang.Boolean getAddTrailingDot() {
            return this.addTrailingDot;
        }

        @Override
        public final java.lang.String getComment() {
            return this.comment;
        }

        @Override
        public final java.lang.String getQueryLogsLogGroupArn() {
            return this.queryLogsLogGroupArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getVpcs() != null) {
                data.set("vpcs", om.valueToTree(this.getVpcs()));
            }
            data.set("zoneName", om.valueToTree(this.getZoneName()));
            if (this.getAddTrailingDot() != null) {
                data.set("addTrailingDot", om.valueToTree(this.getAddTrailingDot()));
            }
            if (this.getComment() != null) {
                data.set("comment", om.valueToTree(this.getComment()));
            }
            if (this.getQueryLogsLogGroupArn() != null) {
                data.set("queryLogsLogGroupArn", om.valueToTree(this.getQueryLogsLogGroupArn()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_route53.HostedZoneProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            HostedZoneProps.Jsii$Proxy that = (HostedZoneProps.Jsii$Proxy) o;

            if (this.vpcs != null ? !this.vpcs.equals(that.vpcs) : that.vpcs != null) return false;
            if (!zoneName.equals(that.zoneName)) return false;
            if (this.addTrailingDot != null ? !this.addTrailingDot.equals(that.addTrailingDot) : that.addTrailingDot != null) return false;
            if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
            return this.queryLogsLogGroupArn != null ? this.queryLogsLogGroupArn.equals(that.queryLogsLogGroupArn) : that.queryLogsLogGroupArn == null;
        }

        @Override
        public final int hashCode() {
            int result = this.vpcs != null ? this.vpcs.hashCode() : 0;
            result = 31 * result + (this.zoneName.hashCode());
            result = 31 * result + (this.addTrailingDot != null ? this.addTrailingDot.hashCode() : 0);
            result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
            result = 31 * result + (this.queryLogsLogGroupArn != null ? this.queryLogsLogGroupArn.hashCode() : 0);
            return result;
        }
    }
}
