package software.amazon.awscdk.services.route53;

/**
 * Properties for constructing a Key Signing Key.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * HostedZone hostedZone;
 * Key kmsKey;
 * KeySigningKey.Builder.create(this, "KeySigningKey")
 *         .hostedZone(hostedZone)
 *         .kmsKey(kmsKey)
 *         .keySigningKeyName("ksk")
 *         .status(KeySigningKeyStatus.ACTIVE)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:25:04.521Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53.KeySigningKeyProps")
@software.amazon.jsii.Jsii.Proxy(KeySigningKeyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface KeySigningKeyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The hosted zone that this key will be used to sign.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.IHostedZone getHostedZone();

    /**
     * The customer-managed KMS key that that will be used to sign the records.
     * <p>
     * The KMS Key must be unique for each KSK within a hosted zone. Additionally, the
     * KMS key must be an asymetric customer-managed key using the ECC_NIST_P256 algorithm.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-configuring-dnssec-cmk-requirements.html">https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-configuring-dnssec-cmk-requirements.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kms.IKey getKmsKey();

    /**
     * The name for the key signing key.
     * <p>
     * This name must be unique within a hosted zone.
     * <p>
     * Default: an autogenerated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKeySigningKeyName() {
        return null;
    }

    /**
     * The status of the key signing key.
     * <p>
     * Default: ACTIVE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.route53.KeySigningKeyStatus getStatus() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link KeySigningKeyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link KeySigningKeyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<KeySigningKeyProps> {
        software.amazon.awscdk.services.route53.IHostedZone hostedZone;
        software.amazon.awscdk.services.kms.IKey kmsKey;
        java.lang.String keySigningKeyName;
        software.amazon.awscdk.services.route53.KeySigningKeyStatus status;

        /**
         * Sets the value of {@link KeySigningKeyProps#getHostedZone}
         * @param hostedZone The hosted zone that this key will be used to sign. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostedZone(software.amazon.awscdk.services.route53.IHostedZone hostedZone) {
            this.hostedZone = hostedZone;
            return this;
        }

        /**
         * Sets the value of {@link KeySigningKeyProps#getKmsKey}
         * @param kmsKey The customer-managed KMS key that that will be used to sign the records. This parameter is required.
         *               The KMS Key must be unique for each KSK within a hosted zone. Additionally, the
         *               KMS key must be an asymetric customer-managed key using the ECC_NIST_P256 algorithm.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKey(software.amazon.awscdk.services.kms.IKey kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        /**
         * Sets the value of {@link KeySigningKeyProps#getKeySigningKeyName}
         * @param keySigningKeyName The name for the key signing key.
         *                          This name must be unique within a hosted zone.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keySigningKeyName(java.lang.String keySigningKeyName) {
            this.keySigningKeyName = keySigningKeyName;
            return this;
        }

        /**
         * Sets the value of {@link KeySigningKeyProps#getStatus}
         * @param status The status of the key signing key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder status(software.amazon.awscdk.services.route53.KeySigningKeyStatus status) {
            this.status = status;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link KeySigningKeyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public KeySigningKeyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link KeySigningKeyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KeySigningKeyProps {
        private final software.amazon.awscdk.services.route53.IHostedZone hostedZone;
        private final software.amazon.awscdk.services.kms.IKey kmsKey;
        private final java.lang.String keySigningKeyName;
        private final software.amazon.awscdk.services.route53.KeySigningKeyStatus status;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.hostedZone = software.amazon.jsii.Kernel.get(this, "hostedZone", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.IHostedZone.class));
            this.kmsKey = software.amazon.jsii.Kernel.get(this, "kmsKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.keySigningKeyName = software.amazon.jsii.Kernel.get(this, "keySigningKeyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.KeySigningKeyStatus.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.hostedZone = java.util.Objects.requireNonNull(builder.hostedZone, "hostedZone is required");
            this.kmsKey = java.util.Objects.requireNonNull(builder.kmsKey, "kmsKey is required");
            this.keySigningKeyName = builder.keySigningKeyName;
            this.status = builder.status;
        }

        @Override
        public final software.amazon.awscdk.services.route53.IHostedZone getHostedZone() {
            return this.hostedZone;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getKmsKey() {
            return this.kmsKey;
        }

        @Override
        public final java.lang.String getKeySigningKeyName() {
            return this.keySigningKeyName;
        }

        @Override
        public final software.amazon.awscdk.services.route53.KeySigningKeyStatus getStatus() {
            return this.status;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("hostedZone", om.valueToTree(this.getHostedZone()));
            data.set("kmsKey", om.valueToTree(this.getKmsKey()));
            if (this.getKeySigningKeyName() != null) {
                data.set("keySigningKeyName", om.valueToTree(this.getKeySigningKeyName()));
            }
            if (this.getStatus() != null) {
                data.set("status", om.valueToTree(this.getStatus()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_route53.KeySigningKeyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            KeySigningKeyProps.Jsii$Proxy that = (KeySigningKeyProps.Jsii$Proxy) o;

            if (!hostedZone.equals(that.hostedZone)) return false;
            if (!kmsKey.equals(that.kmsKey)) return false;
            if (this.keySigningKeyName != null ? !this.keySigningKeyName.equals(that.keySigningKeyName) : that.keySigningKeyName != null) return false;
            return this.status != null ? this.status.equals(that.status) : that.status == null;
        }

        @Override
        public final int hashCode() {
            int result = this.hostedZone.hashCode();
            result = 31 * result + (this.kmsKey.hashCode());
            result = 31 * result + (this.keySigningKeyName != null ? this.keySigningKeyName.hashCode() : 0);
            result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
            return result;
        }
    }
}
