package software.amazon.awscdk.services.s3;

/**
 * A filter that identifies the subset of objects to which the replication rule applies.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IBucket destinationBucket1;
 * IBucket destinationBucket2;
 * IKey kmsKey;
 * Bucket sourceBucket = Bucket.Builder.create(this, "SourceBucket")
 *         // Versioning must be enabled on both the source and destination bucket
 *         .versioned(true)
 *         .replicationRules(List.of(ReplicationRule.builder()
 *                 // The destination bucket for the replication rule.
 *                 .destination(destinationBucket1)
 *                 // The priority of the rule.
 *                 // Amazon S3 will attempt to replicate objects according to all replication rules.
 *                 // However, if there are two or more rules with the same destination bucket, then objects will be replicated according to the rule with the highest priority.
 *                 // The higher the number, the higher the priority.
 *                 // It is essential to specify priority explicitly when the replication configuration has multiple rules.
 *                 .priority(1)
 *                 .build(), ReplicationRule.builder()
 *                 .destination(destinationBucket2)
 *                 .priority(2)
 *                 // Whether to specify S3 Replication Time Control (S3 RTC).
 *                 // S3 RTC replicates most objects that you upload to Amazon S3 in seconds,
 *                 // and 99.99 percent of those objects within specified time.
 *                 .replicationTimeControl(ReplicationTimeValue.FIFTEEN_MINUTES)
 *                 // Whether to enable replication metrics about S3 RTC.
 *                 // If set, metrics will be output to indicate whether replication by S3 RTC took longer than the configured time.
 *                 .metrics(ReplicationTimeValue.FIFTEEN_MINUTES)
 *                 // The kms key to use for the destination bucket.
 *                 .kmsKey(kmsKey)
 *                 // The storage class to use for the destination bucket.
 *                 .storageClass(StorageClass.INFREQUENT_ACCESS)
 *                 // Whether to replicate objects with SSE-KMS encryption.
 *                 .sseKmsEncryptedObjects(false)
 *                 // Whether to replicate modifications on replicas.
 *                 .replicaModifications(true)
 *                 // Whether to replicate delete markers.
 *                 // This property cannot be enabled if the replication rule has a tag filter.
 *                 .deleteMarkerReplication(false)
 *                 // The ID of the rule.
 *                 .id("full-settings-rule")
 *                 // The object filter for the rule.
 *                 .filter(Filter.builder()
 *                         // The prefix filter for the rule.
 *                         .prefix("prefix")
 *                         // The tag filter for the rule.
 *                         .tags(List.of(Tag.builder()
 *                                 .key("tagKey")
 *                                 .value("tagValue")
 *                                 .build()))
 *                         .build())
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:25:04.765Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3.Filter")
@software.amazon.jsii.Jsii.Proxy(Filter.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface Filter extends software.amazon.jsii.JsiiSerializable {

    /**
     * An object key name prefix that identifies the object or objects to which the rule applies.
     * <p>
     * Default: - applies to all objects
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPrefix() {
        return null;
    }

    /**
     * The tag array used for tag filters.
     * <p>
     * The rule applies only to objects that have the tag in this set.
     * <p>
     * Default: - applies to all objects
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.s3.Tag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link Filter}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link Filter}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<Filter> {
        java.lang.String prefix;
        java.util.List<software.amazon.awscdk.services.s3.Tag> tags;

        /**
         * Sets the value of {@link Filter#getPrefix}
         * @param prefix An object key name prefix that identifies the object or objects to which the rule applies.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder prefix(java.lang.String prefix) {
            this.prefix = prefix;
            return this;
        }

        /**
         * Sets the value of {@link Filter#getTags}
         * @param tags The tag array used for tag filters.
         *             The rule applies only to objects that have the tag in this set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.services.s3.Tag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.services.s3.Tag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link Filter}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public Filter build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link Filter}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Filter {
        private final java.lang.String prefix;
        private final java.util.List<software.amazon.awscdk.services.s3.Tag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.prefix = software.amazon.jsii.Kernel.get(this, "prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.Tag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.prefix = builder.prefix;
            this.tags = (java.util.List<software.amazon.awscdk.services.s3.Tag>)builder.tags;
        }

        @Override
        public final java.lang.String getPrefix() {
            return this.prefix;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.s3.Tag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getPrefix() != null) {
                data.set("prefix", om.valueToTree(this.getPrefix()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_s3.Filter"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            Filter.Jsii$Proxy that = (Filter.Jsii$Proxy) o;

            if (this.prefix != null ? !this.prefix.equals(that.prefix) : that.prefix != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.prefix != null ? this.prefix.hashCode() : 0;
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
