package software.amazon.awscdk.services.s3.deployment;

/**
 * Specifies bucket deployment source.
 * <p>
 * Usage:
 * <p>
 * <blockquote><pre>
 * Source.bucket(bucket, key)
 * Source.asset('/local/path/to/directory')
 * Source.asset('/local/path/to/a/file.zip')
 * Source.data('hello/world/file.txt', 'Hello, world!')
 * Source.jsonData('config.json', { baz: topic.topicArn })
 * Source.yamlData('config.yaml', { baz: topic.topicArn })
 * </pre></blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket destinationBucket;
 * BucketDeployment deployment = BucketDeployment.Builder.create(this, "DeployFiles")
 *         .sources(List.of(Source.asset(join(__dirname, "source-files"))))
 *         .destinationBucket(destinationBucket)
 *         .build();
 * deployment.handlerRole.addToPolicy(
 * PolicyStatement.Builder.create()
 *         .actions(List.of("kms:Decrypt", "kms:DescribeKey"))
 *         .effect(Effect.ALLOW)
 *         .resources(List.of("&lt;encryption key ARN&gt;"))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:25:04.814Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3_deployment.Source")
public class Source extends software.amazon.jsii.JsiiObject {

    protected Source(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Source(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Uses a local asset as the deployment source.
     * <p>
     * If the local asset is a .zip archive, make sure you trust the
     * producer of the archive.
     * <p>
     * @param path The path to a local .zip file or a directory. This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.deployment.ISource asset(final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.assets.AssetOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.deployment.Source.class, "asset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.deployment.ISource.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required"), options });
    }

    /**
     * Uses a local asset as the deployment source.
     * <p>
     * If the local asset is a .zip archive, make sure you trust the
     * producer of the archive.
     * <p>
     * @param path The path to a local .zip file or a directory. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.deployment.ISource asset(final @org.jetbrains.annotations.NotNull java.lang.String path) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.deployment.Source.class, "asset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.deployment.ISource.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required") });
    }

    /**
     * Uses a .zip file stored in an S3 bucket as the source for the destination bucket contents.
     * <p>
     * Make sure you trust the producer of the archive.
     * <p>
     * If the <code>bucket</code> parameter is an "out-of-app" reference "imported" via static methods such
     * as <code>s3.Bucket.fromBucketName</code>, be cautious about the bucket's encryption key. In general,
     * CDK does not query for additional properties of imported constructs at synthesis time.
     * For example, for a bucket created from <code>s3.Bucket.fromBucketName</code>, CDK does not know
     * its <code>IBucket.encryptionKey</code> property, and therefore will NOT give KMS permissions to the
     * Lambda execution role of the <code>BucketDeployment</code> construct. If you want the
     * <code>kms:Decrypt</code> and <code>kms:DescribeKey</code> permissions on the bucket's encryption key
     * to be added automatically, reference the imported bucket via <code>s3.Bucket.fromBucketAttributes</code>
     * and pass in the <code>encryptionKey</code> attribute explicitly.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * Bucket destinationBucket;
     * IBucket sourceBucket = Bucket.fromBucketAttributes(this, "SourceBucket", BucketAttributes.builder()
     *         .bucketArn("arn:aws:s3:::my-source-bucket-name")
     *         .encryptionKey(Key.fromKeyArn(this, "SourceBucketEncryptionKey", "arn:aws:kms:us-east-1:123456789012:key/&lt;key-id&gt;"))
     *         .build());
     * BucketDeployment deployment = BucketDeployment.Builder.create(this, "DeployFiles")
     *         .sources(List.of(Source.bucket(sourceBucket, "source.zip")))
     *         .destinationBucket(destinationBucket)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @param bucket The S3 Bucket. This parameter is required.
     * @param zipObjectKey The S3 object key of the zip file with contents. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.deployment.ISource bucket(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket, final @org.jetbrains.annotations.NotNull java.lang.String zipObjectKey) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.deployment.Source.class, "bucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.deployment.ISource.class), new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required"), java.util.Objects.requireNonNull(zipObjectKey, "zipObjectKey is required") });
    }

    /**
     * Deploys an object with the specified string contents into the bucket.
     * <p>
     * The
     * content can include deploy-time values (such as <code>snsTopic.topicArn</code>) that
     * will get resolved only during deployment.
     * <p>
     * To store a JSON object use <code>Source.jsonData()</code>.
     * To store YAML content use <code>Source.yamlData()</code>.
     * <p>
     * @param objectKey The destination S3 object key (relative to the root of the S3 deployment). This parameter is required.
     * @param data The data to be stored in the object. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.deployment.ISource data(final @org.jetbrains.annotations.NotNull java.lang.String objectKey, final @org.jetbrains.annotations.NotNull java.lang.String data) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.deployment.Source.class, "data", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.deployment.ISource.class), new Object[] { java.util.Objects.requireNonNull(objectKey, "objectKey is required"), java.util.Objects.requireNonNull(data, "data is required") });
    }

    /**
     * Deploys an object with the specified JSON object into the bucket.
     * <p>
     * The
     * object can include deploy-time values (such as <code>snsTopic.topicArn</code>) that
     * will get resolved only during deployment.
     * <p>
     * @param objectKey The destination S3 object key (relative to the root of the S3 deployment). This parameter is required.
     * @param obj A JSON object. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.deployment.ISource jsonData(final @org.jetbrains.annotations.NotNull java.lang.String objectKey, final @org.jetbrains.annotations.NotNull java.lang.Object obj) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.deployment.Source.class, "jsonData", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.deployment.ISource.class), new Object[] { java.util.Objects.requireNonNull(objectKey, "objectKey is required"), obj });
    }

    /**
     * Deploys an object with the specified JSON object formatted as YAML into the bucket.
     * <p>
     * The object can include deploy-time values (such as <code>snsTopic.topicArn</code>) that
     * will get resolved only during deployment.
     * <p>
     * @param objectKey The destination S3 object key (relative to the root of the S3 deployment). This parameter is required.
     * @param obj A JSON object. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.deployment.ISource yamlData(final @org.jetbrains.annotations.NotNull java.lang.String objectKey, final @org.jetbrains.annotations.NotNull java.lang.Object obj) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.deployment.Source.class, "yamlData", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.deployment.ISource.class), new Object[] { java.util.Objects.requireNonNull(objectKey, "objectKey is required"), obj });
    }
}
