package software.amazon.awscdk.services.securityhub;

/**
 * The <code>AWS::SecurityHub::AutomationRule</code> resource specifies an automation rule based on input parameters.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/automation-rules.html">Automation rules</a> in the <em>AWS Security Hub User Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.securityhub.*;
 * Object id;
 * Object updatedBy;
 * CfnAutomationRule cfnAutomationRule = CfnAutomationRule.Builder.create(this, "MyCfnAutomationRule")
 *         .actions(List.of(AutomationRulesActionProperty.builder()
 *                 .findingFieldsUpdate(AutomationRulesFindingFieldsUpdateProperty.builder()
 *                         .confidence(123)
 *                         .criticality(123)
 *                         .note(NoteUpdateProperty.builder()
 *                                 .text("text")
 *                                 .updatedBy(updatedBy)
 *                                 .build())
 *                         .relatedFindings(List.of(RelatedFindingProperty.builder()
 *                                 .id(id)
 *                                 .productArn("productArn")
 *                                 .build()))
 *                         .severity(SeverityUpdateProperty.builder()
 *                                 .label("label")
 *                                 .normalized(123)
 *                                 .product(123)
 *                                 .build())
 *                         .types(List.of("types"))
 *                         .userDefinedFields(Map.of(
 *                                 "userDefinedFieldsKey", "userDefinedFields"))
 *                         .verificationState("verificationState")
 *                         .workflow(WorkflowUpdateProperty.builder()
 *                                 .status("status")
 *                                 .build())
 *                         .build())
 *                 .type("type")
 *                 .build()))
 *         .criteria(AutomationRulesFindingFiltersProperty.builder()
 *                 .awsAccountId(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .companyName(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .complianceAssociatedStandardsId(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .complianceSecurityControlId(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .complianceStatus(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .confidence(List.of(NumberFilterProperty.builder()
 *                         .eq(123)
 *                         .gte(123)
 *                         .lte(123)
 *                         .build()))
 *                 .createdAt(List.of(DateFilterProperty.builder()
 *                         .dateRange(DateRangeProperty.builder()
 *                                 .unit("unit")
 *                                 .value(123)
 *                                 .build())
 *                         .end("end")
 *                         .start("start")
 *                         .build()))
 *                 .criticality(List.of(NumberFilterProperty.builder()
 *                         .eq(123)
 *                         .gte(123)
 *                         .lte(123)
 *                         .build()))
 *                 .description(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .firstObservedAt(List.of(DateFilterProperty.builder()
 *                         .dateRange(DateRangeProperty.builder()
 *                                 .unit("unit")
 *                                 .value(123)
 *                                 .build())
 *                         .end("end")
 *                         .start("start")
 *                         .build()))
 *                 .generatorId(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .id(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .lastObservedAt(List.of(DateFilterProperty.builder()
 *                         .dateRange(DateRangeProperty.builder()
 *                                 .unit("unit")
 *                                 .value(123)
 *                                 .build())
 *                         .end("end")
 *                         .start("start")
 *                         .build()))
 *                 .noteText(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .noteUpdatedAt(List.of(DateFilterProperty.builder()
 *                         .dateRange(DateRangeProperty.builder()
 *                                 .unit("unit")
 *                                 .value(123)
 *                                 .build())
 *                         .end("end")
 *                         .start("start")
 *                         .build()))
 *                 .noteUpdatedBy(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .productArn(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .productName(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .recordState(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .relatedFindingsId(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .relatedFindingsProductArn(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .resourceDetailsOther(List.of(MapFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .resourceId(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .resourcePartition(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .resourceRegion(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .resourceTags(List.of(MapFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .resourceType(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .severityLabel(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .sourceUrl(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .title(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .type(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .updatedAt(List.of(DateFilterProperty.builder()
 *                         .dateRange(DateRangeProperty.builder()
 *                                 .unit("unit")
 *                                 .value(123)
 *                                 .build())
 *                         .end("end")
 *                         .start("start")
 *                         .build()))
 *                 .userDefinedFields(List.of(MapFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .verificationState(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .workflowStatus(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .build())
 *         .description("description")
 *         .ruleName("ruleName")
 *         .ruleOrder(123)
 *         // the properties below are optional
 *         .isTerminal(false)
 *         .ruleStatus("ruleStatus")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:25:05.362Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnAutomationRule")
public class CfnAutomationRule extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnAutomationRule(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnAutomationRule(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.securityhub.CfnAutomationRule.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnAutomationRule(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.securityhub.CfnAutomationRuleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * A timestamp that indicates when the rule was created.
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a> . The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The principal that created the rule.
     * <p>
     * For example, <code>arn:aws:sts::123456789012:assumed-role/Developer-Role/JaneDoe</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedBy() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedBy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the automation rule that you create.
     * <p>
     * For example, <code>arn:aws:securityhub:us-east-1:123456789012:automation-rule/a1b2c3d4-5678-90ab-cdef-EXAMPLE11111</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrRuleArn() {
        return software.amazon.jsii.Kernel.get(this, "attrRuleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A timestamp that indicates when the rule was most recently updated.
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a> . The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUpdatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrUpdatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * One or more actions to update finding fields if a finding matches the conditions specified in <code>Criteria</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getActions() {
        return software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * One or more actions to update finding fields if a finding matches the conditions specified in <code>Criteria</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setActions(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "actions", java.util.Objects.requireNonNull(value, "actions is required"));
    }

    /**
     * One or more actions to update finding fields if a finding matches the conditions specified in <code>Criteria</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setActions(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.securityhub.CfnAutomationRule.AutomationRulesActionProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.securityhub.CfnAutomationRule.AutomationRulesActionProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "actions", java.util.Objects.requireNonNull(value, "actions is required"));
    }

    /**
     * A set of <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format.html">AWS Security Finding Format (ASFF)</a> finding field attributes and corresponding expected values that Security Hub uses to filter findings. If a rule is enabled and a finding matches the criteria specified in this parameter, Security Hub applies the rule action to the finding.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getCriteria() {
        return software.amazon.jsii.Kernel.get(this, "criteria", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A set of <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format.html">AWS Security Finding Format (ASFF)</a> finding field attributes and corresponding expected values that Security Hub uses to filter findings. If a rule is enabled and a finding matches the criteria specified in this parameter, Security Hub applies the rule action to the finding.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCriteria(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "criteria", java.util.Objects.requireNonNull(value, "criteria is required"));
    }

    /**
     * A set of <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format.html">AWS Security Finding Format (ASFF)</a> finding field attributes and corresponding expected values that Security Hub uses to filter findings. If a rule is enabled and a finding matches the criteria specified in this parameter, Security Hub applies the rule action to the finding.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCriteria(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.securityhub.CfnAutomationRule.AutomationRulesFindingFiltersProperty value) {
        software.amazon.jsii.Kernel.set(this, "criteria", java.util.Objects.requireNonNull(value, "criteria is required"));
    }

    /**
     * A description of the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description of the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", java.util.Objects.requireNonNull(value, "description is required"));
    }

    /**
     * The name of the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRuleName() {
        return software.amazon.jsii.Kernel.get(this, "ruleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRuleName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "ruleName", java.util.Objects.requireNonNull(value, "ruleName is required"));
    }

    /**
     * An integer ranging from 1 to 1000 that represents the order in which the rule action is applied to findings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getRuleOrder() {
        return software.amazon.jsii.Kernel.get(this, "ruleOrder", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * An integer ranging from 1 to 1000 that represents the order in which the rule action is applied to findings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRuleOrder(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "ruleOrder", java.util.Objects.requireNonNull(value, "ruleOrder is required"));
    }

    /**
     * Specifies whether a rule is the last to be applied with respect to a finding that matches the rule criteria.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getIsTerminal() {
        return software.amazon.jsii.Kernel.get(this, "isTerminal", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether a rule is the last to be applied with respect to a finding that matches the rule criteria.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIsTerminal(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "isTerminal", value);
    }

    /**
     * Specifies whether a rule is the last to be applied with respect to a finding that matches the rule criteria.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIsTerminal(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "isTerminal", value);
    }

    /**
     * Whether the rule is active after it is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRuleStatus() {
        return software.amazon.jsii.Kernel.get(this, "ruleStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Whether the rule is active after it is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRuleStatus(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "ruleStatus", value);
    }

    /**
     * User-defined tags associated with an automation rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.String>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     * User-defined tags associated with an automation rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * One or more actions that AWS Security Hub takes when a finding matches the defined criteria of a rule.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.securityhub.*;
     * Object id;
     * Object updatedBy;
     * AutomationRulesActionProperty automationRulesActionProperty = AutomationRulesActionProperty.builder()
     *         .findingFieldsUpdate(AutomationRulesFindingFieldsUpdateProperty.builder()
     *                 .confidence(123)
     *                 .criticality(123)
     *                 .note(NoteUpdateProperty.builder()
     *                         .text("text")
     *                         .updatedBy(updatedBy)
     *                         .build())
     *                 .relatedFindings(List.of(RelatedFindingProperty.builder()
     *                         .id(id)
     *                         .productArn("productArn")
     *                         .build()))
     *                 .severity(SeverityUpdateProperty.builder()
     *                         .label("label")
     *                         .normalized(123)
     *                         .product(123)
     *                         .build())
     *                 .types(List.of("types"))
     *                 .userDefinedFields(Map.of(
     *                         "userDefinedFieldsKey", "userDefinedFields"))
     *                 .verificationState("verificationState")
     *                 .workflow(WorkflowUpdateProperty.builder()
     *                         .status("status")
     *                         .build())
     *                 .build())
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnAutomationRule.AutomationRulesActionProperty")
    @software.amazon.jsii.Jsii.Proxy(AutomationRulesActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AutomationRulesActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies that the automation rule action is an update to a finding field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesaction.html#cfn-securityhub-automationrule-automationrulesaction-findingfieldsupdate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesaction.html#cfn-securityhub-automationrule-automationrulesaction-findingfieldsupdate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getFindingFieldsUpdate();

        /**
         * Specifies the type of action that Security Hub takes when a finding matches the defined criteria of a rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesaction.html#cfn-securityhub-automationrule-automationrulesaction-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesaction.html#cfn-securityhub-automationrule-automationrulesaction-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link AutomationRulesActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AutomationRulesActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AutomationRulesActionProperty> {
            java.lang.Object findingFieldsUpdate;
            java.lang.String type;

            /**
             * Sets the value of {@link AutomationRulesActionProperty#getFindingFieldsUpdate}
             * @param findingFieldsUpdate Specifies that the automation rule action is an update to a finding field. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder findingFieldsUpdate(software.amazon.awscdk.IResolvable findingFieldsUpdate) {
                this.findingFieldsUpdate = findingFieldsUpdate;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesActionProperty#getFindingFieldsUpdate}
             * @param findingFieldsUpdate Specifies that the automation rule action is an update to a finding field. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder findingFieldsUpdate(software.amazon.awscdk.services.securityhub.CfnAutomationRule.AutomationRulesFindingFieldsUpdateProperty findingFieldsUpdate) {
                this.findingFieldsUpdate = findingFieldsUpdate;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesActionProperty#getType}
             * @param type Specifies the type of action that Security Hub takes when a finding matches the defined criteria of a rule. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AutomationRulesActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AutomationRulesActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AutomationRulesActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AutomationRulesActionProperty {
            private final java.lang.Object findingFieldsUpdate;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.findingFieldsUpdate = software.amazon.jsii.Kernel.get(this, "findingFieldsUpdate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.findingFieldsUpdate = java.util.Objects.requireNonNull(builder.findingFieldsUpdate, "findingFieldsUpdate is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.Object getFindingFieldsUpdate() {
                return this.findingFieldsUpdate;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("findingFieldsUpdate", om.valueToTree(this.getFindingFieldsUpdate()));
                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnAutomationRule.AutomationRulesActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AutomationRulesActionProperty.Jsii$Proxy that = (AutomationRulesActionProperty.Jsii$Proxy) o;

                if (!findingFieldsUpdate.equals(that.findingFieldsUpdate)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.findingFieldsUpdate.hashCode();
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }
    /**
     * Identifies the finding fields that the automation rule action updates when a finding matches the defined criteria.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.securityhub.*;
     * Object id;
     * Object updatedBy;
     * AutomationRulesFindingFieldsUpdateProperty automationRulesFindingFieldsUpdateProperty = AutomationRulesFindingFieldsUpdateProperty.builder()
     *         .confidence(123)
     *         .criticality(123)
     *         .note(NoteUpdateProperty.builder()
     *                 .text("text")
     *                 .updatedBy(updatedBy)
     *                 .build())
     *         .relatedFindings(List.of(RelatedFindingProperty.builder()
     *                 .id(id)
     *                 .productArn("productArn")
     *                 .build()))
     *         .severity(SeverityUpdateProperty.builder()
     *                 .label("label")
     *                 .normalized(123)
     *                 .product(123)
     *                 .build())
     *         .types(List.of("types"))
     *         .userDefinedFields(Map.of(
     *                 "userDefinedFieldsKey", "userDefinedFields"))
     *         .verificationState("verificationState")
     *         .workflow(WorkflowUpdateProperty.builder()
     *                 .status("status")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfieldsupdate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfieldsupdate.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnAutomationRule.AutomationRulesFindingFieldsUpdateProperty")
    @software.amazon.jsii.Jsii.Proxy(AutomationRulesFindingFieldsUpdateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AutomationRulesFindingFieldsUpdateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The rule action updates the <code>Confidence</code> field of a finding.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfieldsupdate.html#cfn-securityhub-automationrule-automationrulesfindingfieldsupdate-confidence">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfieldsupdate.html#cfn-securityhub-automationrule-automationrulesfindingfieldsupdate-confidence</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getConfidence() {
            return null;
        }

        /**
         * The rule action updates the <code>Criticality</code> field of a finding.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfieldsupdate.html#cfn-securityhub-automationrule-automationrulesfindingfieldsupdate-criticality">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfieldsupdate.html#cfn-securityhub-automationrule-automationrulesfindingfieldsupdate-criticality</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCriticality() {
            return null;
        }

        /**
         * The rule action will update the <code>Note</code> field of a finding.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfieldsupdate.html#cfn-securityhub-automationrule-automationrulesfindingfieldsupdate-note">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfieldsupdate.html#cfn-securityhub-automationrule-automationrulesfindingfieldsupdate-note</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNote() {
            return null;
        }

        /**
         * The rule action will update the <code>RelatedFindings</code> field of a finding.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfieldsupdate.html#cfn-securityhub-automationrule-automationrulesfindingfieldsupdate-relatedfindings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfieldsupdate.html#cfn-securityhub-automationrule-automationrulesfindingfieldsupdate-relatedfindings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRelatedFindings() {
            return null;
        }

        /**
         * The rule action will update the <code>Severity</code> field of a finding.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfieldsupdate.html#cfn-securityhub-automationrule-automationrulesfindingfieldsupdate-severity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfieldsupdate.html#cfn-securityhub-automationrule-automationrulesfindingfieldsupdate-severity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSeverity() {
            return null;
        }

        /**
         * The rule action updates the <code>Types</code> field of a finding.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfieldsupdate.html#cfn-securityhub-automationrule-automationrulesfindingfieldsupdate-types">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfieldsupdate.html#cfn-securityhub-automationrule-automationrulesfindingfieldsupdate-types</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTypes() {
            return null;
        }

        /**
         * The rule action updates the <code>UserDefinedFields</code> field of a finding.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfieldsupdate.html#cfn-securityhub-automationrule-automationrulesfindingfieldsupdate-userdefinedfields">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfieldsupdate.html#cfn-securityhub-automationrule-automationrulesfindingfieldsupdate-userdefinedfields</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUserDefinedFields() {
            return null;
        }

        /**
         * The rule action updates the <code>VerificationState</code> field of a finding.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfieldsupdate.html#cfn-securityhub-automationrule-automationrulesfindingfieldsupdate-verificationstate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfieldsupdate.html#cfn-securityhub-automationrule-automationrulesfindingfieldsupdate-verificationstate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVerificationState() {
            return null;
        }

        /**
         * The rule action will update the <code>Workflow</code> field of a finding.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfieldsupdate.html#cfn-securityhub-automationrule-automationrulesfindingfieldsupdate-workflow">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfieldsupdate.html#cfn-securityhub-automationrule-automationrulesfindingfieldsupdate-workflow</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getWorkflow() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AutomationRulesFindingFieldsUpdateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AutomationRulesFindingFieldsUpdateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AutomationRulesFindingFieldsUpdateProperty> {
            java.lang.Number confidence;
            java.lang.Number criticality;
            java.lang.Object note;
            java.lang.Object relatedFindings;
            java.lang.Object severity;
            java.util.List<java.lang.String> types;
            java.lang.Object userDefinedFields;
            java.lang.String verificationState;
            java.lang.Object workflow;

            /**
             * Sets the value of {@link AutomationRulesFindingFieldsUpdateProperty#getConfidence}
             * @param confidence The rule action updates the <code>Confidence</code> field of a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder confidence(java.lang.Number confidence) {
                this.confidence = confidence;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFieldsUpdateProperty#getCriticality}
             * @param criticality The rule action updates the <code>Criticality</code> field of a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder criticality(java.lang.Number criticality) {
                this.criticality = criticality;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFieldsUpdateProperty#getNote}
             * @param note The rule action will update the <code>Note</code> field of a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder note(software.amazon.awscdk.IResolvable note) {
                this.note = note;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFieldsUpdateProperty#getNote}
             * @param note The rule action will update the <code>Note</code> field of a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder note(software.amazon.awscdk.services.securityhub.CfnAutomationRule.NoteUpdateProperty note) {
                this.note = note;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFieldsUpdateProperty#getRelatedFindings}
             * @param relatedFindings The rule action will update the <code>RelatedFindings</code> field of a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder relatedFindings(software.amazon.awscdk.IResolvable relatedFindings) {
                this.relatedFindings = relatedFindings;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFieldsUpdateProperty#getRelatedFindings}
             * @param relatedFindings The rule action will update the <code>RelatedFindings</code> field of a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder relatedFindings(java.util.List<? extends java.lang.Object> relatedFindings) {
                this.relatedFindings = relatedFindings;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFieldsUpdateProperty#getSeverity}
             * @param severity The rule action will update the <code>Severity</code> field of a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder severity(software.amazon.awscdk.IResolvable severity) {
                this.severity = severity;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFieldsUpdateProperty#getSeverity}
             * @param severity The rule action will update the <code>Severity</code> field of a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder severity(software.amazon.awscdk.services.securityhub.CfnAutomationRule.SeverityUpdateProperty severity) {
                this.severity = severity;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFieldsUpdateProperty#getTypes}
             * @param types The rule action updates the <code>Types</code> field of a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder types(java.util.List<java.lang.String> types) {
                this.types = types;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFieldsUpdateProperty#getUserDefinedFields}
             * @param userDefinedFields The rule action updates the <code>UserDefinedFields</code> field of a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userDefinedFields(java.util.Map<java.lang.String, java.lang.String> userDefinedFields) {
                this.userDefinedFields = userDefinedFields;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFieldsUpdateProperty#getUserDefinedFields}
             * @param userDefinedFields The rule action updates the <code>UserDefinedFields</code> field of a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userDefinedFields(software.amazon.awscdk.IResolvable userDefinedFields) {
                this.userDefinedFields = userDefinedFields;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFieldsUpdateProperty#getVerificationState}
             * @param verificationState The rule action updates the <code>VerificationState</code> field of a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder verificationState(java.lang.String verificationState) {
                this.verificationState = verificationState;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFieldsUpdateProperty#getWorkflow}
             * @param workflow The rule action will update the <code>Workflow</code> field of a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder workflow(software.amazon.awscdk.IResolvable workflow) {
                this.workflow = workflow;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFieldsUpdateProperty#getWorkflow}
             * @param workflow The rule action will update the <code>Workflow</code> field of a finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder workflow(software.amazon.awscdk.services.securityhub.CfnAutomationRule.WorkflowUpdateProperty workflow) {
                this.workflow = workflow;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AutomationRulesFindingFieldsUpdateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AutomationRulesFindingFieldsUpdateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AutomationRulesFindingFieldsUpdateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AutomationRulesFindingFieldsUpdateProperty {
            private final java.lang.Number confidence;
            private final java.lang.Number criticality;
            private final java.lang.Object note;
            private final java.lang.Object relatedFindings;
            private final java.lang.Object severity;
            private final java.util.List<java.lang.String> types;
            private final java.lang.Object userDefinedFields;
            private final java.lang.String verificationState;
            private final java.lang.Object workflow;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.confidence = software.amazon.jsii.Kernel.get(this, "confidence", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.criticality = software.amazon.jsii.Kernel.get(this, "criticality", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.note = software.amazon.jsii.Kernel.get(this, "note", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.relatedFindings = software.amazon.jsii.Kernel.get(this, "relatedFindings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.severity = software.amazon.jsii.Kernel.get(this, "severity", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.types = software.amazon.jsii.Kernel.get(this, "types", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.userDefinedFields = software.amazon.jsii.Kernel.get(this, "userDefinedFields", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.verificationState = software.amazon.jsii.Kernel.get(this, "verificationState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.workflow = software.amazon.jsii.Kernel.get(this, "workflow", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.confidence = builder.confidence;
                this.criticality = builder.criticality;
                this.note = builder.note;
                this.relatedFindings = builder.relatedFindings;
                this.severity = builder.severity;
                this.types = builder.types;
                this.userDefinedFields = builder.userDefinedFields;
                this.verificationState = builder.verificationState;
                this.workflow = builder.workflow;
            }

            @Override
            public final java.lang.Number getConfidence() {
                return this.confidence;
            }

            @Override
            public final java.lang.Number getCriticality() {
                return this.criticality;
            }

            @Override
            public final java.lang.Object getNote() {
                return this.note;
            }

            @Override
            public final java.lang.Object getRelatedFindings() {
                return this.relatedFindings;
            }

            @Override
            public final java.lang.Object getSeverity() {
                return this.severity;
            }

            @Override
            public final java.util.List<java.lang.String> getTypes() {
                return this.types;
            }

            @Override
            public final java.lang.Object getUserDefinedFields() {
                return this.userDefinedFields;
            }

            @Override
            public final java.lang.String getVerificationState() {
                return this.verificationState;
            }

            @Override
            public final java.lang.Object getWorkflow() {
                return this.workflow;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConfidence() != null) {
                    data.set("confidence", om.valueToTree(this.getConfidence()));
                }
                if (this.getCriticality() != null) {
                    data.set("criticality", om.valueToTree(this.getCriticality()));
                }
                if (this.getNote() != null) {
                    data.set("note", om.valueToTree(this.getNote()));
                }
                if (this.getRelatedFindings() != null) {
                    data.set("relatedFindings", om.valueToTree(this.getRelatedFindings()));
                }
                if (this.getSeverity() != null) {
                    data.set("severity", om.valueToTree(this.getSeverity()));
                }
                if (this.getTypes() != null) {
                    data.set("types", om.valueToTree(this.getTypes()));
                }
                if (this.getUserDefinedFields() != null) {
                    data.set("userDefinedFields", om.valueToTree(this.getUserDefinedFields()));
                }
                if (this.getVerificationState() != null) {
                    data.set("verificationState", om.valueToTree(this.getVerificationState()));
                }
                if (this.getWorkflow() != null) {
                    data.set("workflow", om.valueToTree(this.getWorkflow()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnAutomationRule.AutomationRulesFindingFieldsUpdateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AutomationRulesFindingFieldsUpdateProperty.Jsii$Proxy that = (AutomationRulesFindingFieldsUpdateProperty.Jsii$Proxy) o;

                if (this.confidence != null ? !this.confidence.equals(that.confidence) : that.confidence != null) return false;
                if (this.criticality != null ? !this.criticality.equals(that.criticality) : that.criticality != null) return false;
                if (this.note != null ? !this.note.equals(that.note) : that.note != null) return false;
                if (this.relatedFindings != null ? !this.relatedFindings.equals(that.relatedFindings) : that.relatedFindings != null) return false;
                if (this.severity != null ? !this.severity.equals(that.severity) : that.severity != null) return false;
                if (this.types != null ? !this.types.equals(that.types) : that.types != null) return false;
                if (this.userDefinedFields != null ? !this.userDefinedFields.equals(that.userDefinedFields) : that.userDefinedFields != null) return false;
                if (this.verificationState != null ? !this.verificationState.equals(that.verificationState) : that.verificationState != null) return false;
                return this.workflow != null ? this.workflow.equals(that.workflow) : that.workflow == null;
            }

            @Override
            public final int hashCode() {
                int result = this.confidence != null ? this.confidence.hashCode() : 0;
                result = 31 * result + (this.criticality != null ? this.criticality.hashCode() : 0);
                result = 31 * result + (this.note != null ? this.note.hashCode() : 0);
                result = 31 * result + (this.relatedFindings != null ? this.relatedFindings.hashCode() : 0);
                result = 31 * result + (this.severity != null ? this.severity.hashCode() : 0);
                result = 31 * result + (this.types != null ? this.types.hashCode() : 0);
                result = 31 * result + (this.userDefinedFields != null ? this.userDefinedFields.hashCode() : 0);
                result = 31 * result + (this.verificationState != null ? this.verificationState.hashCode() : 0);
                result = 31 * result + (this.workflow != null ? this.workflow.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The criteria that determine which findings a rule applies to.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.securityhub.*;
     * AutomationRulesFindingFiltersProperty automationRulesFindingFiltersProperty = AutomationRulesFindingFiltersProperty.builder()
     *         .awsAccountId(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .companyName(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .complianceAssociatedStandardsId(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .complianceSecurityControlId(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .complianceStatus(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .confidence(List.of(NumberFilterProperty.builder()
     *                 .eq(123)
     *                 .gte(123)
     *                 .lte(123)
     *                 .build()))
     *         .createdAt(List.of(DateFilterProperty.builder()
     *                 .dateRange(DateRangeProperty.builder()
     *                         .unit("unit")
     *                         .value(123)
     *                         .build())
     *                 .end("end")
     *                 .start("start")
     *                 .build()))
     *         .criticality(List.of(NumberFilterProperty.builder()
     *                 .eq(123)
     *                 .gte(123)
     *                 .lte(123)
     *                 .build()))
     *         .description(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .firstObservedAt(List.of(DateFilterProperty.builder()
     *                 .dateRange(DateRangeProperty.builder()
     *                         .unit("unit")
     *                         .value(123)
     *                         .build())
     *                 .end("end")
     *                 .start("start")
     *                 .build()))
     *         .generatorId(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .id(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .lastObservedAt(List.of(DateFilterProperty.builder()
     *                 .dateRange(DateRangeProperty.builder()
     *                         .unit("unit")
     *                         .value(123)
     *                         .build())
     *                 .end("end")
     *                 .start("start")
     *                 .build()))
     *         .noteText(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .noteUpdatedAt(List.of(DateFilterProperty.builder()
     *                 .dateRange(DateRangeProperty.builder()
     *                         .unit("unit")
     *                         .value(123)
     *                         .build())
     *                 .end("end")
     *                 .start("start")
     *                 .build()))
     *         .noteUpdatedBy(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .productArn(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .productName(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .recordState(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .relatedFindingsId(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .relatedFindingsProductArn(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .resourceDetailsOther(List.of(MapFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .resourceId(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .resourcePartition(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .resourceRegion(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .resourceTags(List.of(MapFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .resourceType(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .severityLabel(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .sourceUrl(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .title(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .type(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .updatedAt(List.of(DateFilterProperty.builder()
     *                 .dateRange(DateRangeProperty.builder()
     *                         .unit("unit")
     *                         .value(123)
     *                         .build())
     *                 .end("end")
     *                 .start("start")
     *                 .build()))
     *         .userDefinedFields(List.of(MapFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .verificationState(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .workflowStatus(List.of(StringFilterProperty.builder()
     *                 .comparison("comparison")
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnAutomationRule.AutomationRulesFindingFiltersProperty")
    @software.amazon.jsii.Jsii.Proxy(AutomationRulesFindingFiltersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AutomationRulesFindingFiltersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The AWS account ID in which a finding was generated.
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 100 items.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-awsaccountid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-awsaccountid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAwsAccountId() {
            return null;
        }

        /**
         * The name of the company for the product that generated the finding.
         * <p>
         * For control-based findings, the company is AWS .
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-companyname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-companyname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCompanyName() {
            return null;
        }

        /**
         * The unique identifier of a standard in which a control is enabled.
         * <p>
         * This field consists of the resource portion of the Amazon Resource Name (ARN) returned for a standard in the <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DescribeStandards.html">DescribeStandards</a> API response.
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-complianceassociatedstandardsid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-complianceassociatedstandardsid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getComplianceAssociatedStandardsId() {
            return null;
        }

        /**
         * The security control ID for which a finding was generated. Security control IDs are the same across standards.
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-compliancesecuritycontrolid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-compliancesecuritycontrolid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getComplianceSecurityControlId() {
            return null;
        }

        /**
         * The result of a security check. This field is only used for findings generated from controls.
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-compliancestatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-compliancestatus</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getComplianceStatus() {
            return null;
        }

        /**
         * The likelihood that a finding accurately identifies the behavior or issue that it was intended to identify.
         * <p>
         * <code>Confidence</code> is scored on a 0–100 basis using a ratio scale. A value of <code>0</code> means 0 percent confidence, and a value of <code>100</code> means 100 percent confidence. For example, a data exfiltration detection based on a statistical deviation of network traffic has low confidence because an actual exfiltration hasn't been verified. For more information, see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/asff-top-level-attributes.html#asff-confidence">Confidence</a> in the <em>AWS Security Hub User Guide</em> .
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-confidence">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-confidence</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConfidence() {
            return null;
        }

        /**
         * A timestamp that indicates when this finding record was created.
         * <p>
         * For more information about the validation and formatting of timestamp fields in AWS Security Hub , see <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a> .
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-createdat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-createdat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCreatedAt() {
            return null;
        }

        /**
         * The level of importance that is assigned to the resources that are associated with a finding.
         * <p>
         * <code>Criticality</code> is scored on a 0–100 basis, using a ratio scale that supports only full integers. A score of <code>0</code> means that the underlying resources have no criticality, and a score of <code>100</code> is reserved for the most critical resources. For more information, see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/asff-top-level-attributes.html#asff-criticality">Criticality</a> in the <em>AWS Security Hub User Guide</em> .
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-criticality">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-criticality</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCriticality() {
            return null;
        }

        /**
         * A finding's description.
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDescription() {
            return null;
        }

        /**
         * A timestamp that indicates when the potential security issue captured by a finding was first observed by the security findings product.
         * <p>
         * For more information about the validation and formatting of timestamp fields in AWS Security Hub , see <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a> .
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-firstobservedat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-firstobservedat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFirstObservedAt() {
            return null;
        }

        /**
         * The identifier for the solution-specific component that generated a finding.
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 100 items.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-generatorid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-generatorid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGeneratorId() {
            return null;
        }

        /**
         * The product-specific identifier for a finding.
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-id">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-id</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getId() {
            return null;
        }

        /**
         * A timestamp that indicates when the security findings provider most recently observed a change in the resource that is involved in the finding.
         * <p>
         * For more information about the validation and formatting of timestamp fields in AWS Security Hub , see <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a> .
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-lastobservedat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-lastobservedat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLastObservedAt() {
            return null;
        }

        /**
         * The text of a user-defined note that's added to a finding.
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-notetext">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-notetext</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNoteText() {
            return null;
        }

        /**
         * The timestamp of when the note was updated.
         * <p>
         * For more information about the validation and formatting of timestamp fields in AWS Security Hub , see <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a> .
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-noteupdatedat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-noteupdatedat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNoteUpdatedAt() {
            return null;
        }

        /**
         * The principal that created a note.
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-noteupdatedby">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-noteupdatedby</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNoteUpdatedBy() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) for a third-party product that generated a finding in Security Hub.
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-productarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-productarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProductArn() {
            return null;
        }

        /**
         * Provides the name of the product that generated the finding. For control-based findings, the product name is Security Hub.
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-productname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-productname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProductName() {
            return null;
        }

        /**
         * Provides the current state of a finding.
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-recordstate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-recordstate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRecordState() {
            return null;
        }

        /**
         * The product-generated identifier for a related finding.
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-relatedfindingsid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-relatedfindingsid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRelatedFindingsId() {
            return null;
        }

        /**
         * The ARN for the product that generated a related finding.
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-relatedfindingsproductarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-relatedfindingsproductarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRelatedFindingsProductArn() {
            return null;
        }

        /**
         * Custom fields and values about the resource that a finding pertains to.
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-resourcedetailsother">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-resourcedetailsother</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourceDetailsOther() {
            return null;
        }

        /**
         * The identifier for the given resource type.
         * <p>
         * For AWS resources that are identified by Amazon Resource Names (ARNs), this is the ARN. For AWS resources that lack ARNs, this is the identifier as defined by the AWS service that created the resource. For non- AWS resources, this is a unique identifier that is associated with the resource.
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 100 items.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-resourceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-resourceid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourceId() {
            return null;
        }

        /**
         * The partition in which the resource that the finding pertains to is located.
         * <p>
         * A partition is a group of AWS Regions . Each AWS account is scoped to one partition.
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-resourcepartition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-resourcepartition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourcePartition() {
            return null;
        }

        /**
         * The AWS Region where the resource that a finding pertains to is located.
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-resourceregion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-resourceregion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourceRegion() {
            return null;
        }

        /**
         * A list of AWS tags associated with a resource at the time the finding was processed.
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-resourcetags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-resourcetags</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourceTags() {
            return null;
        }

        /**
         * A finding's title.
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 100 items.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-resourcetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-resourcetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourceType() {
            return null;
        }

        /**
         * The severity value of the finding.
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-severitylabel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-severitylabel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSeverityLabel() {
            return null;
        }

        /**
         * Provides a URL that links to a page about the current finding in the finding product.
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-sourceurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-sourceurl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSourceUrl() {
            return null;
        }

        /**
         * A finding's title.
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 100 items.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-title">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-title</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTitle() {
            return null;
        }

        /**
         * One or more finding types in the format of namespace/category/classifier that classify a finding.
         * <p>
         * For a list of namespaces, classifiers, and categories, see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format-type-taxonomy.html">Types taxonomy for ASFF</a> in the <em>AWS Security Hub User Guide</em> .
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getType() {
            return null;
        }

        /**
         * A timestamp that indicates when the finding record was most recently updated.
         * <p>
         * For more information about the validation and formatting of timestamp fields in AWS Security Hub , see <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a> .
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-updatedat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-updatedat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUpdatedAt() {
            return null;
        }

        /**
         * A list of user-defined name and value string pairs added to a finding.
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-userdefinedfields">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-userdefinedfields</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUserDefinedFields() {
            return null;
        }

        /**
         * Provides the veracity of a finding.
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-verificationstate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-verificationstate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVerificationState() {
            return null;
        }

        /**
         * Provides information about the status of the investigation into a finding.
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-workflowstatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-workflowstatus</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getWorkflowStatus() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AutomationRulesFindingFiltersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AutomationRulesFindingFiltersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AutomationRulesFindingFiltersProperty> {
            java.lang.Object awsAccountId;
            java.lang.Object companyName;
            java.lang.Object complianceAssociatedStandardsId;
            java.lang.Object complianceSecurityControlId;
            java.lang.Object complianceStatus;
            java.lang.Object confidence;
            java.lang.Object createdAt;
            java.lang.Object criticality;
            java.lang.Object description;
            java.lang.Object firstObservedAt;
            java.lang.Object generatorId;
            java.lang.Object id;
            java.lang.Object lastObservedAt;
            java.lang.Object noteText;
            java.lang.Object noteUpdatedAt;
            java.lang.Object noteUpdatedBy;
            java.lang.Object productArn;
            java.lang.Object productName;
            java.lang.Object recordState;
            java.lang.Object relatedFindingsId;
            java.lang.Object relatedFindingsProductArn;
            java.lang.Object resourceDetailsOther;
            java.lang.Object resourceId;
            java.lang.Object resourcePartition;
            java.lang.Object resourceRegion;
            java.lang.Object resourceTags;
            java.lang.Object resourceType;
            java.lang.Object severityLabel;
            java.lang.Object sourceUrl;
            java.lang.Object title;
            java.lang.Object type;
            java.lang.Object updatedAt;
            java.lang.Object userDefinedFields;
            java.lang.Object verificationState;
            java.lang.Object workflowStatus;

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getAwsAccountId}
             * @param awsAccountId The AWS account ID in which a finding was generated.
             *                     Array Members: Minimum number of 1 item. Maximum number of 100 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsAccountId(software.amazon.awscdk.IResolvable awsAccountId) {
                this.awsAccountId = awsAccountId;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getAwsAccountId}
             * @param awsAccountId The AWS account ID in which a finding was generated.
             *                     Array Members: Minimum number of 1 item. Maximum number of 100 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsAccountId(java.util.List<? extends java.lang.Object> awsAccountId) {
                this.awsAccountId = awsAccountId;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getCompanyName}
             * @param companyName The name of the company for the product that generated the finding.
             *                    For control-based findings, the company is AWS .
             *                    <p>
             *                    Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder companyName(software.amazon.awscdk.IResolvable companyName) {
                this.companyName = companyName;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getCompanyName}
             * @param companyName The name of the company for the product that generated the finding.
             *                    For control-based findings, the company is AWS .
             *                    <p>
             *                    Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder companyName(java.util.List<? extends java.lang.Object> companyName) {
                this.companyName = companyName;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getComplianceAssociatedStandardsId}
             * @param complianceAssociatedStandardsId The unique identifier of a standard in which a control is enabled.
             *                                        This field consists of the resource portion of the Amazon Resource Name (ARN) returned for a standard in the <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DescribeStandards.html">DescribeStandards</a> API response.
             *                                        <p>
             *                                        Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder complianceAssociatedStandardsId(software.amazon.awscdk.IResolvable complianceAssociatedStandardsId) {
                this.complianceAssociatedStandardsId = complianceAssociatedStandardsId;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getComplianceAssociatedStandardsId}
             * @param complianceAssociatedStandardsId The unique identifier of a standard in which a control is enabled.
             *                                        This field consists of the resource portion of the Amazon Resource Name (ARN) returned for a standard in the <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DescribeStandards.html">DescribeStandards</a> API response.
             *                                        <p>
             *                                        Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder complianceAssociatedStandardsId(java.util.List<? extends java.lang.Object> complianceAssociatedStandardsId) {
                this.complianceAssociatedStandardsId = complianceAssociatedStandardsId;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getComplianceSecurityControlId}
             * @param complianceSecurityControlId The security control ID for which a finding was generated. Security control IDs are the same across standards.
             *                                    Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder complianceSecurityControlId(software.amazon.awscdk.IResolvable complianceSecurityControlId) {
                this.complianceSecurityControlId = complianceSecurityControlId;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getComplianceSecurityControlId}
             * @param complianceSecurityControlId The security control ID for which a finding was generated. Security control IDs are the same across standards.
             *                                    Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder complianceSecurityControlId(java.util.List<? extends java.lang.Object> complianceSecurityControlId) {
                this.complianceSecurityControlId = complianceSecurityControlId;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getComplianceStatus}
             * @param complianceStatus The result of a security check. This field is only used for findings generated from controls.
             *                         Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder complianceStatus(software.amazon.awscdk.IResolvable complianceStatus) {
                this.complianceStatus = complianceStatus;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getComplianceStatus}
             * @param complianceStatus The result of a security check. This field is only used for findings generated from controls.
             *                         Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder complianceStatus(java.util.List<? extends java.lang.Object> complianceStatus) {
                this.complianceStatus = complianceStatus;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getConfidence}
             * @param confidence The likelihood that a finding accurately identifies the behavior or issue that it was intended to identify.
             *                   <code>Confidence</code> is scored on a 0–100 basis using a ratio scale. A value of <code>0</code> means 0 percent confidence, and a value of <code>100</code> means 100 percent confidence. For example, a data exfiltration detection based on a statistical deviation of network traffic has low confidence because an actual exfiltration hasn't been verified. For more information, see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/asff-top-level-attributes.html#asff-confidence">Confidence</a> in the <em>AWS Security Hub User Guide</em> .
             *                   <p>
             *                   Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder confidence(software.amazon.awscdk.IResolvable confidence) {
                this.confidence = confidence;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getConfidence}
             * @param confidence The likelihood that a finding accurately identifies the behavior or issue that it was intended to identify.
             *                   <code>Confidence</code> is scored on a 0–100 basis using a ratio scale. A value of <code>0</code> means 0 percent confidence, and a value of <code>100</code> means 100 percent confidence. For example, a data exfiltration detection based on a statistical deviation of network traffic has low confidence because an actual exfiltration hasn't been verified. For more information, see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/asff-top-level-attributes.html#asff-confidence">Confidence</a> in the <em>AWS Security Hub User Guide</em> .
             *                   <p>
             *                   Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder confidence(java.util.List<? extends java.lang.Object> confidence) {
                this.confidence = confidence;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getCreatedAt}
             * @param createdAt A timestamp that indicates when this finding record was created.
             *                  For more information about the validation and formatting of timestamp fields in AWS Security Hub , see <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a> .
             *                  <p>
             *                  Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createdAt(software.amazon.awscdk.IResolvable createdAt) {
                this.createdAt = createdAt;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getCreatedAt}
             * @param createdAt A timestamp that indicates when this finding record was created.
             *                  For more information about the validation and formatting of timestamp fields in AWS Security Hub , see <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a> .
             *                  <p>
             *                  Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder createdAt(java.util.List<? extends java.lang.Object> createdAt) {
                this.createdAt = createdAt;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getCriticality}
             * @param criticality The level of importance that is assigned to the resources that are associated with a finding.
             *                    <code>Criticality</code> is scored on a 0–100 basis, using a ratio scale that supports only full integers. A score of <code>0</code> means that the underlying resources have no criticality, and a score of <code>100</code> is reserved for the most critical resources. For more information, see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/asff-top-level-attributes.html#asff-criticality">Criticality</a> in the <em>AWS Security Hub User Guide</em> .
             *                    <p>
             *                    Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder criticality(software.amazon.awscdk.IResolvable criticality) {
                this.criticality = criticality;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getCriticality}
             * @param criticality The level of importance that is assigned to the resources that are associated with a finding.
             *                    <code>Criticality</code> is scored on a 0–100 basis, using a ratio scale that supports only full integers. A score of <code>0</code> means that the underlying resources have no criticality, and a score of <code>100</code> is reserved for the most critical resources. For more information, see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/asff-top-level-attributes.html#asff-criticality">Criticality</a> in the <em>AWS Security Hub User Guide</em> .
             *                    <p>
             *                    Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder criticality(java.util.List<? extends java.lang.Object> criticality) {
                this.criticality = criticality;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getDescription}
             * @param description A finding's description.
             *                    Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(software.amazon.awscdk.IResolvable description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getDescription}
             * @param description A finding's description.
             *                    Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.util.List<? extends java.lang.Object> description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getFirstObservedAt}
             * @param firstObservedAt A timestamp that indicates when the potential security issue captured by a finding was first observed by the security findings product.
             *                        For more information about the validation and formatting of timestamp fields in AWS Security Hub , see <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a> .
             *                        <p>
             *                        Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder firstObservedAt(software.amazon.awscdk.IResolvable firstObservedAt) {
                this.firstObservedAt = firstObservedAt;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getFirstObservedAt}
             * @param firstObservedAt A timestamp that indicates when the potential security issue captured by a finding was first observed by the security findings product.
             *                        For more information about the validation and formatting of timestamp fields in AWS Security Hub , see <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a> .
             *                        <p>
             *                        Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder firstObservedAt(java.util.List<? extends java.lang.Object> firstObservedAt) {
                this.firstObservedAt = firstObservedAt;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getGeneratorId}
             * @param generatorId The identifier for the solution-specific component that generated a finding.
             *                    Array Members: Minimum number of 1 item. Maximum number of 100 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder generatorId(software.amazon.awscdk.IResolvable generatorId) {
                this.generatorId = generatorId;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getGeneratorId}
             * @param generatorId The identifier for the solution-specific component that generated a finding.
             *                    Array Members: Minimum number of 1 item. Maximum number of 100 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder generatorId(java.util.List<? extends java.lang.Object> generatorId) {
                this.generatorId = generatorId;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getId}
             * @param id The product-specific identifier for a finding.
             *           Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(software.amazon.awscdk.IResolvable id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getId}
             * @param id The product-specific identifier for a finding.
             *           Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.util.List<? extends java.lang.Object> id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getLastObservedAt}
             * @param lastObservedAt A timestamp that indicates when the security findings provider most recently observed a change in the resource that is involved in the finding.
             *                       For more information about the validation and formatting of timestamp fields in AWS Security Hub , see <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a> .
             *                       <p>
             *                       Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lastObservedAt(software.amazon.awscdk.IResolvable lastObservedAt) {
                this.lastObservedAt = lastObservedAt;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getLastObservedAt}
             * @param lastObservedAt A timestamp that indicates when the security findings provider most recently observed a change in the resource that is involved in the finding.
             *                       For more information about the validation and formatting of timestamp fields in AWS Security Hub , see <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a> .
             *                       <p>
             *                       Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lastObservedAt(java.util.List<? extends java.lang.Object> lastObservedAt) {
                this.lastObservedAt = lastObservedAt;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getNoteText}
             * @param noteText The text of a user-defined note that's added to a finding.
             *                 Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noteText(software.amazon.awscdk.IResolvable noteText) {
                this.noteText = noteText;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getNoteText}
             * @param noteText The text of a user-defined note that's added to a finding.
             *                 Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noteText(java.util.List<? extends java.lang.Object> noteText) {
                this.noteText = noteText;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getNoteUpdatedAt}
             * @param noteUpdatedAt The timestamp of when the note was updated.
             *                      For more information about the validation and formatting of timestamp fields in AWS Security Hub , see <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a> .
             *                      <p>
             *                      Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noteUpdatedAt(software.amazon.awscdk.IResolvable noteUpdatedAt) {
                this.noteUpdatedAt = noteUpdatedAt;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getNoteUpdatedAt}
             * @param noteUpdatedAt The timestamp of when the note was updated.
             *                      For more information about the validation and formatting of timestamp fields in AWS Security Hub , see <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a> .
             *                      <p>
             *                      Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noteUpdatedAt(java.util.List<? extends java.lang.Object> noteUpdatedAt) {
                this.noteUpdatedAt = noteUpdatedAt;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getNoteUpdatedBy}
             * @param noteUpdatedBy The principal that created a note.
             *                      Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noteUpdatedBy(software.amazon.awscdk.IResolvable noteUpdatedBy) {
                this.noteUpdatedBy = noteUpdatedBy;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getNoteUpdatedBy}
             * @param noteUpdatedBy The principal that created a note.
             *                      Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noteUpdatedBy(java.util.List<? extends java.lang.Object> noteUpdatedBy) {
                this.noteUpdatedBy = noteUpdatedBy;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getProductArn}
             * @param productArn The Amazon Resource Name (ARN) for a third-party product that generated a finding in Security Hub.
             *                   Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder productArn(software.amazon.awscdk.IResolvable productArn) {
                this.productArn = productArn;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getProductArn}
             * @param productArn The Amazon Resource Name (ARN) for a third-party product that generated a finding in Security Hub.
             *                   Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder productArn(java.util.List<? extends java.lang.Object> productArn) {
                this.productArn = productArn;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getProductName}
             * @param productName Provides the name of the product that generated the finding. For control-based findings, the product name is Security Hub.
             *                    Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder productName(software.amazon.awscdk.IResolvable productName) {
                this.productName = productName;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getProductName}
             * @param productName Provides the name of the product that generated the finding. For control-based findings, the product name is Security Hub.
             *                    Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder productName(java.util.List<? extends java.lang.Object> productName) {
                this.productName = productName;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getRecordState}
             * @param recordState Provides the current state of a finding.
             *                    Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordState(software.amazon.awscdk.IResolvable recordState) {
                this.recordState = recordState;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getRecordState}
             * @param recordState Provides the current state of a finding.
             *                    Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder recordState(java.util.List<? extends java.lang.Object> recordState) {
                this.recordState = recordState;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getRelatedFindingsId}
             * @param relatedFindingsId The product-generated identifier for a related finding.
             *                          Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder relatedFindingsId(software.amazon.awscdk.IResolvable relatedFindingsId) {
                this.relatedFindingsId = relatedFindingsId;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getRelatedFindingsId}
             * @param relatedFindingsId The product-generated identifier for a related finding.
             *                          Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder relatedFindingsId(java.util.List<? extends java.lang.Object> relatedFindingsId) {
                this.relatedFindingsId = relatedFindingsId;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getRelatedFindingsProductArn}
             * @param relatedFindingsProductArn The ARN for the product that generated a related finding.
             *                                  Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder relatedFindingsProductArn(software.amazon.awscdk.IResolvable relatedFindingsProductArn) {
                this.relatedFindingsProductArn = relatedFindingsProductArn;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getRelatedFindingsProductArn}
             * @param relatedFindingsProductArn The ARN for the product that generated a related finding.
             *                                  Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder relatedFindingsProductArn(java.util.List<? extends java.lang.Object> relatedFindingsProductArn) {
                this.relatedFindingsProductArn = relatedFindingsProductArn;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getResourceDetailsOther}
             * @param resourceDetailsOther Custom fields and values about the resource that a finding pertains to.
             *                             Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceDetailsOther(software.amazon.awscdk.IResolvable resourceDetailsOther) {
                this.resourceDetailsOther = resourceDetailsOther;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getResourceDetailsOther}
             * @param resourceDetailsOther Custom fields and values about the resource that a finding pertains to.
             *                             Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceDetailsOther(java.util.List<? extends java.lang.Object> resourceDetailsOther) {
                this.resourceDetailsOther = resourceDetailsOther;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getResourceId}
             * @param resourceId The identifier for the given resource type.
             *                   For AWS resources that are identified by Amazon Resource Names (ARNs), this is the ARN. For AWS resources that lack ARNs, this is the identifier as defined by the AWS service that created the resource. For non- AWS resources, this is a unique identifier that is associated with the resource.
             *                   <p>
             *                   Array Members: Minimum number of 1 item. Maximum number of 100 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceId(software.amazon.awscdk.IResolvable resourceId) {
                this.resourceId = resourceId;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getResourceId}
             * @param resourceId The identifier for the given resource type.
             *                   For AWS resources that are identified by Amazon Resource Names (ARNs), this is the ARN. For AWS resources that lack ARNs, this is the identifier as defined by the AWS service that created the resource. For non- AWS resources, this is a unique identifier that is associated with the resource.
             *                   <p>
             *                   Array Members: Minimum number of 1 item. Maximum number of 100 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceId(java.util.List<? extends java.lang.Object> resourceId) {
                this.resourceId = resourceId;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getResourcePartition}
             * @param resourcePartition The partition in which the resource that the finding pertains to is located.
             *                          A partition is a group of AWS Regions . Each AWS account is scoped to one partition.
             *                          <p>
             *                          Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourcePartition(software.amazon.awscdk.IResolvable resourcePartition) {
                this.resourcePartition = resourcePartition;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getResourcePartition}
             * @param resourcePartition The partition in which the resource that the finding pertains to is located.
             *                          A partition is a group of AWS Regions . Each AWS account is scoped to one partition.
             *                          <p>
             *                          Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourcePartition(java.util.List<? extends java.lang.Object> resourcePartition) {
                this.resourcePartition = resourcePartition;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getResourceRegion}
             * @param resourceRegion The AWS Region where the resource that a finding pertains to is located.
             *                       Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceRegion(software.amazon.awscdk.IResolvable resourceRegion) {
                this.resourceRegion = resourceRegion;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getResourceRegion}
             * @param resourceRegion The AWS Region where the resource that a finding pertains to is located.
             *                       Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceRegion(java.util.List<? extends java.lang.Object> resourceRegion) {
                this.resourceRegion = resourceRegion;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getResourceTags}
             * @param resourceTags A list of AWS tags associated with a resource at the time the finding was processed.
             *                     Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceTags(software.amazon.awscdk.IResolvable resourceTags) {
                this.resourceTags = resourceTags;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getResourceTags}
             * @param resourceTags A list of AWS tags associated with a resource at the time the finding was processed.
             *                     Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceTags(java.util.List<? extends java.lang.Object> resourceTags) {
                this.resourceTags = resourceTags;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getResourceType}
             * @param resourceType A finding's title.
             *                     Array Members: Minimum number of 1 item. Maximum number of 100 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceType(software.amazon.awscdk.IResolvable resourceType) {
                this.resourceType = resourceType;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getResourceType}
             * @param resourceType A finding's title.
             *                     Array Members: Minimum number of 1 item. Maximum number of 100 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceType(java.util.List<? extends java.lang.Object> resourceType) {
                this.resourceType = resourceType;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getSeverityLabel}
             * @param severityLabel The severity value of the finding.
             *                      Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder severityLabel(software.amazon.awscdk.IResolvable severityLabel) {
                this.severityLabel = severityLabel;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getSeverityLabel}
             * @param severityLabel The severity value of the finding.
             *                      Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder severityLabel(java.util.List<? extends java.lang.Object> severityLabel) {
                this.severityLabel = severityLabel;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getSourceUrl}
             * @param sourceUrl Provides a URL that links to a page about the current finding in the finding product.
             *                  Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceUrl(software.amazon.awscdk.IResolvable sourceUrl) {
                this.sourceUrl = sourceUrl;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getSourceUrl}
             * @param sourceUrl Provides a URL that links to a page about the current finding in the finding product.
             *                  Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceUrl(java.util.List<? extends java.lang.Object> sourceUrl) {
                this.sourceUrl = sourceUrl;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getTitle}
             * @param title A finding's title.
             *              Array Members: Minimum number of 1 item. Maximum number of 100 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder title(software.amazon.awscdk.IResolvable title) {
                this.title = title;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getTitle}
             * @param title A finding's title.
             *              Array Members: Minimum number of 1 item. Maximum number of 100 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder title(java.util.List<? extends java.lang.Object> title) {
                this.title = title;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getType}
             * @param type One or more finding types in the format of namespace/category/classifier that classify a finding.
             *             For a list of namespaces, classifiers, and categories, see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format-type-taxonomy.html">Types taxonomy for ASFF</a> in the <em>AWS Security Hub User Guide</em> .
             *             <p>
             *             Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(software.amazon.awscdk.IResolvable type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getType}
             * @param type One or more finding types in the format of namespace/category/classifier that classify a finding.
             *             For a list of namespaces, classifiers, and categories, see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format-type-taxonomy.html">Types taxonomy for ASFF</a> in the <em>AWS Security Hub User Guide</em> .
             *             <p>
             *             Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.util.List<? extends java.lang.Object> type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getUpdatedAt}
             * @param updatedAt A timestamp that indicates when the finding record was most recently updated.
             *                  For more information about the validation and formatting of timestamp fields in AWS Security Hub , see <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a> .
             *                  <p>
             *                  Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder updatedAt(software.amazon.awscdk.IResolvable updatedAt) {
                this.updatedAt = updatedAt;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getUpdatedAt}
             * @param updatedAt A timestamp that indicates when the finding record was most recently updated.
             *                  For more information about the validation and formatting of timestamp fields in AWS Security Hub , see <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a> .
             *                  <p>
             *                  Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder updatedAt(java.util.List<? extends java.lang.Object> updatedAt) {
                this.updatedAt = updatedAt;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getUserDefinedFields}
             * @param userDefinedFields A list of user-defined name and value string pairs added to a finding.
             *                          Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userDefinedFields(software.amazon.awscdk.IResolvable userDefinedFields) {
                this.userDefinedFields = userDefinedFields;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getUserDefinedFields}
             * @param userDefinedFields A list of user-defined name and value string pairs added to a finding.
             *                          Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userDefinedFields(java.util.List<? extends java.lang.Object> userDefinedFields) {
                this.userDefinedFields = userDefinedFields;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getVerificationState}
             * @param verificationState Provides the veracity of a finding.
             *                          Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder verificationState(software.amazon.awscdk.IResolvable verificationState) {
                this.verificationState = verificationState;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getVerificationState}
             * @param verificationState Provides the veracity of a finding.
             *                          Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder verificationState(java.util.List<? extends java.lang.Object> verificationState) {
                this.verificationState = verificationState;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getWorkflowStatus}
             * @param workflowStatus Provides information about the status of the investigation into a finding.
             *                       Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder workflowStatus(software.amazon.awscdk.IResolvable workflowStatus) {
                this.workflowStatus = workflowStatus;
                return this;
            }

            /**
             * Sets the value of {@link AutomationRulesFindingFiltersProperty#getWorkflowStatus}
             * @param workflowStatus Provides information about the status of the investigation into a finding.
             *                       Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder workflowStatus(java.util.List<? extends java.lang.Object> workflowStatus) {
                this.workflowStatus = workflowStatus;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AutomationRulesFindingFiltersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AutomationRulesFindingFiltersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AutomationRulesFindingFiltersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AutomationRulesFindingFiltersProperty {
            private final java.lang.Object awsAccountId;
            private final java.lang.Object companyName;
            private final java.lang.Object complianceAssociatedStandardsId;
            private final java.lang.Object complianceSecurityControlId;
            private final java.lang.Object complianceStatus;
            private final java.lang.Object confidence;
            private final java.lang.Object createdAt;
            private final java.lang.Object criticality;
            private final java.lang.Object description;
            private final java.lang.Object firstObservedAt;
            private final java.lang.Object generatorId;
            private final java.lang.Object id;
            private final java.lang.Object lastObservedAt;
            private final java.lang.Object noteText;
            private final java.lang.Object noteUpdatedAt;
            private final java.lang.Object noteUpdatedBy;
            private final java.lang.Object productArn;
            private final java.lang.Object productName;
            private final java.lang.Object recordState;
            private final java.lang.Object relatedFindingsId;
            private final java.lang.Object relatedFindingsProductArn;
            private final java.lang.Object resourceDetailsOther;
            private final java.lang.Object resourceId;
            private final java.lang.Object resourcePartition;
            private final java.lang.Object resourceRegion;
            private final java.lang.Object resourceTags;
            private final java.lang.Object resourceType;
            private final java.lang.Object severityLabel;
            private final java.lang.Object sourceUrl;
            private final java.lang.Object title;
            private final java.lang.Object type;
            private final java.lang.Object updatedAt;
            private final java.lang.Object userDefinedFields;
            private final java.lang.Object verificationState;
            private final java.lang.Object workflowStatus;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.awsAccountId = software.amazon.jsii.Kernel.get(this, "awsAccountId", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.companyName = software.amazon.jsii.Kernel.get(this, "companyName", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.complianceAssociatedStandardsId = software.amazon.jsii.Kernel.get(this, "complianceAssociatedStandardsId", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.complianceSecurityControlId = software.amazon.jsii.Kernel.get(this, "complianceSecurityControlId", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.complianceStatus = software.amazon.jsii.Kernel.get(this, "complianceStatus", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.confidence = software.amazon.jsii.Kernel.get(this, "confidence", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.createdAt = software.amazon.jsii.Kernel.get(this, "createdAt", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.criticality = software.amazon.jsii.Kernel.get(this, "criticality", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.firstObservedAt = software.amazon.jsii.Kernel.get(this, "firstObservedAt", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.generatorId = software.amazon.jsii.Kernel.get(this, "generatorId", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.lastObservedAt = software.amazon.jsii.Kernel.get(this, "lastObservedAt", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.noteText = software.amazon.jsii.Kernel.get(this, "noteText", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.noteUpdatedAt = software.amazon.jsii.Kernel.get(this, "noteUpdatedAt", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.noteUpdatedBy = software.amazon.jsii.Kernel.get(this, "noteUpdatedBy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.productArn = software.amazon.jsii.Kernel.get(this, "productArn", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.productName = software.amazon.jsii.Kernel.get(this, "productName", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.recordState = software.amazon.jsii.Kernel.get(this, "recordState", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.relatedFindingsId = software.amazon.jsii.Kernel.get(this, "relatedFindingsId", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.relatedFindingsProductArn = software.amazon.jsii.Kernel.get(this, "relatedFindingsProductArn", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourceDetailsOther = software.amazon.jsii.Kernel.get(this, "resourceDetailsOther", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourceId = software.amazon.jsii.Kernel.get(this, "resourceId", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourcePartition = software.amazon.jsii.Kernel.get(this, "resourcePartition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourceRegion = software.amazon.jsii.Kernel.get(this, "resourceRegion", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourceTags = software.amazon.jsii.Kernel.get(this, "resourceTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourceType = software.amazon.jsii.Kernel.get(this, "resourceType", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.severityLabel = software.amazon.jsii.Kernel.get(this, "severityLabel", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sourceUrl = software.amazon.jsii.Kernel.get(this, "sourceUrl", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.title = software.amazon.jsii.Kernel.get(this, "title", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.updatedAt = software.amazon.jsii.Kernel.get(this, "updatedAt", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.userDefinedFields = software.amazon.jsii.Kernel.get(this, "userDefinedFields", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.verificationState = software.amazon.jsii.Kernel.get(this, "verificationState", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.workflowStatus = software.amazon.jsii.Kernel.get(this, "workflowStatus", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.awsAccountId = builder.awsAccountId;
                this.companyName = builder.companyName;
                this.complianceAssociatedStandardsId = builder.complianceAssociatedStandardsId;
                this.complianceSecurityControlId = builder.complianceSecurityControlId;
                this.complianceStatus = builder.complianceStatus;
                this.confidence = builder.confidence;
                this.createdAt = builder.createdAt;
                this.criticality = builder.criticality;
                this.description = builder.description;
                this.firstObservedAt = builder.firstObservedAt;
                this.generatorId = builder.generatorId;
                this.id = builder.id;
                this.lastObservedAt = builder.lastObservedAt;
                this.noteText = builder.noteText;
                this.noteUpdatedAt = builder.noteUpdatedAt;
                this.noteUpdatedBy = builder.noteUpdatedBy;
                this.productArn = builder.productArn;
                this.productName = builder.productName;
                this.recordState = builder.recordState;
                this.relatedFindingsId = builder.relatedFindingsId;
                this.relatedFindingsProductArn = builder.relatedFindingsProductArn;
                this.resourceDetailsOther = builder.resourceDetailsOther;
                this.resourceId = builder.resourceId;
                this.resourcePartition = builder.resourcePartition;
                this.resourceRegion = builder.resourceRegion;
                this.resourceTags = builder.resourceTags;
                this.resourceType = builder.resourceType;
                this.severityLabel = builder.severityLabel;
                this.sourceUrl = builder.sourceUrl;
                this.title = builder.title;
                this.type = builder.type;
                this.updatedAt = builder.updatedAt;
                this.userDefinedFields = builder.userDefinedFields;
                this.verificationState = builder.verificationState;
                this.workflowStatus = builder.workflowStatus;
            }

            @Override
            public final java.lang.Object getAwsAccountId() {
                return this.awsAccountId;
            }

            @Override
            public final java.lang.Object getCompanyName() {
                return this.companyName;
            }

            @Override
            public final java.lang.Object getComplianceAssociatedStandardsId() {
                return this.complianceAssociatedStandardsId;
            }

            @Override
            public final java.lang.Object getComplianceSecurityControlId() {
                return this.complianceSecurityControlId;
            }

            @Override
            public final java.lang.Object getComplianceStatus() {
                return this.complianceStatus;
            }

            @Override
            public final java.lang.Object getConfidence() {
                return this.confidence;
            }

            @Override
            public final java.lang.Object getCreatedAt() {
                return this.createdAt;
            }

            @Override
            public final java.lang.Object getCriticality() {
                return this.criticality;
            }

            @Override
            public final java.lang.Object getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.Object getFirstObservedAt() {
                return this.firstObservedAt;
            }

            @Override
            public final java.lang.Object getGeneratorId() {
                return this.generatorId;
            }

            @Override
            public final java.lang.Object getId() {
                return this.id;
            }

            @Override
            public final java.lang.Object getLastObservedAt() {
                return this.lastObservedAt;
            }

            @Override
            public final java.lang.Object getNoteText() {
                return this.noteText;
            }

            @Override
            public final java.lang.Object getNoteUpdatedAt() {
                return this.noteUpdatedAt;
            }

            @Override
            public final java.lang.Object getNoteUpdatedBy() {
                return this.noteUpdatedBy;
            }

            @Override
            public final java.lang.Object getProductArn() {
                return this.productArn;
            }

            @Override
            public final java.lang.Object getProductName() {
                return this.productName;
            }

            @Override
            public final java.lang.Object getRecordState() {
                return this.recordState;
            }

            @Override
            public final java.lang.Object getRelatedFindingsId() {
                return this.relatedFindingsId;
            }

            @Override
            public final java.lang.Object getRelatedFindingsProductArn() {
                return this.relatedFindingsProductArn;
            }

            @Override
            public final java.lang.Object getResourceDetailsOther() {
                return this.resourceDetailsOther;
            }

            @Override
            public final java.lang.Object getResourceId() {
                return this.resourceId;
            }

            @Override
            public final java.lang.Object getResourcePartition() {
                return this.resourcePartition;
            }

            @Override
            public final java.lang.Object getResourceRegion() {
                return this.resourceRegion;
            }

            @Override
            public final java.lang.Object getResourceTags() {
                return this.resourceTags;
            }

            @Override
            public final java.lang.Object getResourceType() {
                return this.resourceType;
            }

            @Override
            public final java.lang.Object getSeverityLabel() {
                return this.severityLabel;
            }

            @Override
            public final java.lang.Object getSourceUrl() {
                return this.sourceUrl;
            }

            @Override
            public final java.lang.Object getTitle() {
                return this.title;
            }

            @Override
            public final java.lang.Object getType() {
                return this.type;
            }

            @Override
            public final java.lang.Object getUpdatedAt() {
                return this.updatedAt;
            }

            @Override
            public final java.lang.Object getUserDefinedFields() {
                return this.userDefinedFields;
            }

            @Override
            public final java.lang.Object getVerificationState() {
                return this.verificationState;
            }

            @Override
            public final java.lang.Object getWorkflowStatus() {
                return this.workflowStatus;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAwsAccountId() != null) {
                    data.set("awsAccountId", om.valueToTree(this.getAwsAccountId()));
                }
                if (this.getCompanyName() != null) {
                    data.set("companyName", om.valueToTree(this.getCompanyName()));
                }
                if (this.getComplianceAssociatedStandardsId() != null) {
                    data.set("complianceAssociatedStandardsId", om.valueToTree(this.getComplianceAssociatedStandardsId()));
                }
                if (this.getComplianceSecurityControlId() != null) {
                    data.set("complianceSecurityControlId", om.valueToTree(this.getComplianceSecurityControlId()));
                }
                if (this.getComplianceStatus() != null) {
                    data.set("complianceStatus", om.valueToTree(this.getComplianceStatus()));
                }
                if (this.getConfidence() != null) {
                    data.set("confidence", om.valueToTree(this.getConfidence()));
                }
                if (this.getCreatedAt() != null) {
                    data.set("createdAt", om.valueToTree(this.getCreatedAt()));
                }
                if (this.getCriticality() != null) {
                    data.set("criticality", om.valueToTree(this.getCriticality()));
                }
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getFirstObservedAt() != null) {
                    data.set("firstObservedAt", om.valueToTree(this.getFirstObservedAt()));
                }
                if (this.getGeneratorId() != null) {
                    data.set("generatorId", om.valueToTree(this.getGeneratorId()));
                }
                if (this.getId() != null) {
                    data.set("id", om.valueToTree(this.getId()));
                }
                if (this.getLastObservedAt() != null) {
                    data.set("lastObservedAt", om.valueToTree(this.getLastObservedAt()));
                }
                if (this.getNoteText() != null) {
                    data.set("noteText", om.valueToTree(this.getNoteText()));
                }
                if (this.getNoteUpdatedAt() != null) {
                    data.set("noteUpdatedAt", om.valueToTree(this.getNoteUpdatedAt()));
                }
                if (this.getNoteUpdatedBy() != null) {
                    data.set("noteUpdatedBy", om.valueToTree(this.getNoteUpdatedBy()));
                }
                if (this.getProductArn() != null) {
                    data.set("productArn", om.valueToTree(this.getProductArn()));
                }
                if (this.getProductName() != null) {
                    data.set("productName", om.valueToTree(this.getProductName()));
                }
                if (this.getRecordState() != null) {
                    data.set("recordState", om.valueToTree(this.getRecordState()));
                }
                if (this.getRelatedFindingsId() != null) {
                    data.set("relatedFindingsId", om.valueToTree(this.getRelatedFindingsId()));
                }
                if (this.getRelatedFindingsProductArn() != null) {
                    data.set("relatedFindingsProductArn", om.valueToTree(this.getRelatedFindingsProductArn()));
                }
                if (this.getResourceDetailsOther() != null) {
                    data.set("resourceDetailsOther", om.valueToTree(this.getResourceDetailsOther()));
                }
                if (this.getResourceId() != null) {
                    data.set("resourceId", om.valueToTree(this.getResourceId()));
                }
                if (this.getResourcePartition() != null) {
                    data.set("resourcePartition", om.valueToTree(this.getResourcePartition()));
                }
                if (this.getResourceRegion() != null) {
                    data.set("resourceRegion", om.valueToTree(this.getResourceRegion()));
                }
                if (this.getResourceTags() != null) {
                    data.set("resourceTags", om.valueToTree(this.getResourceTags()));
                }
                if (this.getResourceType() != null) {
                    data.set("resourceType", om.valueToTree(this.getResourceType()));
                }
                if (this.getSeverityLabel() != null) {
                    data.set("severityLabel", om.valueToTree(this.getSeverityLabel()));
                }
                if (this.getSourceUrl() != null) {
                    data.set("sourceUrl", om.valueToTree(this.getSourceUrl()));
                }
                if (this.getTitle() != null) {
                    data.set("title", om.valueToTree(this.getTitle()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }
                if (this.getUpdatedAt() != null) {
                    data.set("updatedAt", om.valueToTree(this.getUpdatedAt()));
                }
                if (this.getUserDefinedFields() != null) {
                    data.set("userDefinedFields", om.valueToTree(this.getUserDefinedFields()));
                }
                if (this.getVerificationState() != null) {
                    data.set("verificationState", om.valueToTree(this.getVerificationState()));
                }
                if (this.getWorkflowStatus() != null) {
                    data.set("workflowStatus", om.valueToTree(this.getWorkflowStatus()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnAutomationRule.AutomationRulesFindingFiltersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AutomationRulesFindingFiltersProperty.Jsii$Proxy that = (AutomationRulesFindingFiltersProperty.Jsii$Proxy) o;

                if (this.awsAccountId != null ? !this.awsAccountId.equals(that.awsAccountId) : that.awsAccountId != null) return false;
                if (this.companyName != null ? !this.companyName.equals(that.companyName) : that.companyName != null) return false;
                if (this.complianceAssociatedStandardsId != null ? !this.complianceAssociatedStandardsId.equals(that.complianceAssociatedStandardsId) : that.complianceAssociatedStandardsId != null) return false;
                if (this.complianceSecurityControlId != null ? !this.complianceSecurityControlId.equals(that.complianceSecurityControlId) : that.complianceSecurityControlId != null) return false;
                if (this.complianceStatus != null ? !this.complianceStatus.equals(that.complianceStatus) : that.complianceStatus != null) return false;
                if (this.confidence != null ? !this.confidence.equals(that.confidence) : that.confidence != null) return false;
                if (this.createdAt != null ? !this.createdAt.equals(that.createdAt) : that.createdAt != null) return false;
                if (this.criticality != null ? !this.criticality.equals(that.criticality) : that.criticality != null) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.firstObservedAt != null ? !this.firstObservedAt.equals(that.firstObservedAt) : that.firstObservedAt != null) return false;
                if (this.generatorId != null ? !this.generatorId.equals(that.generatorId) : that.generatorId != null) return false;
                if (this.id != null ? !this.id.equals(that.id) : that.id != null) return false;
                if (this.lastObservedAt != null ? !this.lastObservedAt.equals(that.lastObservedAt) : that.lastObservedAt != null) return false;
                if (this.noteText != null ? !this.noteText.equals(that.noteText) : that.noteText != null) return false;
                if (this.noteUpdatedAt != null ? !this.noteUpdatedAt.equals(that.noteUpdatedAt) : that.noteUpdatedAt != null) return false;
                if (this.noteUpdatedBy != null ? !this.noteUpdatedBy.equals(that.noteUpdatedBy) : that.noteUpdatedBy != null) return false;
                if (this.productArn != null ? !this.productArn.equals(that.productArn) : that.productArn != null) return false;
                if (this.productName != null ? !this.productName.equals(that.productName) : that.productName != null) return false;
                if (this.recordState != null ? !this.recordState.equals(that.recordState) : that.recordState != null) return false;
                if (this.relatedFindingsId != null ? !this.relatedFindingsId.equals(that.relatedFindingsId) : that.relatedFindingsId != null) return false;
                if (this.relatedFindingsProductArn != null ? !this.relatedFindingsProductArn.equals(that.relatedFindingsProductArn) : that.relatedFindingsProductArn != null) return false;
                if (this.resourceDetailsOther != null ? !this.resourceDetailsOther.equals(that.resourceDetailsOther) : that.resourceDetailsOther != null) return false;
                if (this.resourceId != null ? !this.resourceId.equals(that.resourceId) : that.resourceId != null) return false;
                if (this.resourcePartition != null ? !this.resourcePartition.equals(that.resourcePartition) : that.resourcePartition != null) return false;
                if (this.resourceRegion != null ? !this.resourceRegion.equals(that.resourceRegion) : that.resourceRegion != null) return false;
                if (this.resourceTags != null ? !this.resourceTags.equals(that.resourceTags) : that.resourceTags != null) return false;
                if (this.resourceType != null ? !this.resourceType.equals(that.resourceType) : that.resourceType != null) return false;
                if (this.severityLabel != null ? !this.severityLabel.equals(that.severityLabel) : that.severityLabel != null) return false;
                if (this.sourceUrl != null ? !this.sourceUrl.equals(that.sourceUrl) : that.sourceUrl != null) return false;
                if (this.title != null ? !this.title.equals(that.title) : that.title != null) return false;
                if (this.type != null ? !this.type.equals(that.type) : that.type != null) return false;
                if (this.updatedAt != null ? !this.updatedAt.equals(that.updatedAt) : that.updatedAt != null) return false;
                if (this.userDefinedFields != null ? !this.userDefinedFields.equals(that.userDefinedFields) : that.userDefinedFields != null) return false;
                if (this.verificationState != null ? !this.verificationState.equals(that.verificationState) : that.verificationState != null) return false;
                return this.workflowStatus != null ? this.workflowStatus.equals(that.workflowStatus) : that.workflowStatus == null;
            }

            @Override
            public final int hashCode() {
                int result = this.awsAccountId != null ? this.awsAccountId.hashCode() : 0;
                result = 31 * result + (this.companyName != null ? this.companyName.hashCode() : 0);
                result = 31 * result + (this.complianceAssociatedStandardsId != null ? this.complianceAssociatedStandardsId.hashCode() : 0);
                result = 31 * result + (this.complianceSecurityControlId != null ? this.complianceSecurityControlId.hashCode() : 0);
                result = 31 * result + (this.complianceStatus != null ? this.complianceStatus.hashCode() : 0);
                result = 31 * result + (this.confidence != null ? this.confidence.hashCode() : 0);
                result = 31 * result + (this.createdAt != null ? this.createdAt.hashCode() : 0);
                result = 31 * result + (this.criticality != null ? this.criticality.hashCode() : 0);
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.firstObservedAt != null ? this.firstObservedAt.hashCode() : 0);
                result = 31 * result + (this.generatorId != null ? this.generatorId.hashCode() : 0);
                result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
                result = 31 * result + (this.lastObservedAt != null ? this.lastObservedAt.hashCode() : 0);
                result = 31 * result + (this.noteText != null ? this.noteText.hashCode() : 0);
                result = 31 * result + (this.noteUpdatedAt != null ? this.noteUpdatedAt.hashCode() : 0);
                result = 31 * result + (this.noteUpdatedBy != null ? this.noteUpdatedBy.hashCode() : 0);
                result = 31 * result + (this.productArn != null ? this.productArn.hashCode() : 0);
                result = 31 * result + (this.productName != null ? this.productName.hashCode() : 0);
                result = 31 * result + (this.recordState != null ? this.recordState.hashCode() : 0);
                result = 31 * result + (this.relatedFindingsId != null ? this.relatedFindingsId.hashCode() : 0);
                result = 31 * result + (this.relatedFindingsProductArn != null ? this.relatedFindingsProductArn.hashCode() : 0);
                result = 31 * result + (this.resourceDetailsOther != null ? this.resourceDetailsOther.hashCode() : 0);
                result = 31 * result + (this.resourceId != null ? this.resourceId.hashCode() : 0);
                result = 31 * result + (this.resourcePartition != null ? this.resourcePartition.hashCode() : 0);
                result = 31 * result + (this.resourceRegion != null ? this.resourceRegion.hashCode() : 0);
                result = 31 * result + (this.resourceTags != null ? this.resourceTags.hashCode() : 0);
                result = 31 * result + (this.resourceType != null ? this.resourceType.hashCode() : 0);
                result = 31 * result + (this.severityLabel != null ? this.severityLabel.hashCode() : 0);
                result = 31 * result + (this.sourceUrl != null ? this.sourceUrl.hashCode() : 0);
                result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                result = 31 * result + (this.updatedAt != null ? this.updatedAt.hashCode() : 0);
                result = 31 * result + (this.userDefinedFields != null ? this.userDefinedFields.hashCode() : 0);
                result = 31 * result + (this.verificationState != null ? this.verificationState.hashCode() : 0);
                result = 31 * result + (this.workflowStatus != null ? this.workflowStatus.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A date filter for querying findings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.securityhub.*;
     * DateFilterProperty dateFilterProperty = DateFilterProperty.builder()
     *         .dateRange(DateRangeProperty.builder()
     *                 .unit("unit")
     *                 .value(123)
     *                 .build())
     *         .end("end")
     *         .start("start")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-datefilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-datefilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnAutomationRule.DateFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(DateFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DateFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A date range for the date filter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-datefilter.html#cfn-securityhub-automationrule-datefilter-daterange">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-datefilter.html#cfn-securityhub-automationrule-datefilter-daterange</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDateRange() {
            return null;
        }

        /**
         * A timestamp that provides the end date for the date filter.
         * <p>
         * For more information about the validation and formatting of timestamp fields in AWS Security Hub , see <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-datefilter.html#cfn-securityhub-automationrule-datefilter-end">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-datefilter.html#cfn-securityhub-automationrule-datefilter-end</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEnd() {
            return null;
        }

        /**
         * A timestamp that provides the start date for the date filter.
         * <p>
         * For more information about the validation and formatting of timestamp fields in AWS Security Hub , see <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-datefilter.html#cfn-securityhub-automationrule-datefilter-start">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-datefilter.html#cfn-securityhub-automationrule-datefilter-start</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStart() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DateFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DateFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DateFilterProperty> {
            java.lang.Object dateRange;
            java.lang.String end;
            java.lang.String start;

            /**
             * Sets the value of {@link DateFilterProperty#getDateRange}
             * @param dateRange A date range for the date filter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dateRange(software.amazon.awscdk.IResolvable dateRange) {
                this.dateRange = dateRange;
                return this;
            }

            /**
             * Sets the value of {@link DateFilterProperty#getDateRange}
             * @param dateRange A date range for the date filter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dateRange(software.amazon.awscdk.services.securityhub.CfnAutomationRule.DateRangeProperty dateRange) {
                this.dateRange = dateRange;
                return this;
            }

            /**
             * Sets the value of {@link DateFilterProperty#getEnd}
             * @param end A timestamp that provides the end date for the date filter.
             *            For more information about the validation and formatting of timestamp fields in AWS Security Hub , see <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder end(java.lang.String end) {
                this.end = end;
                return this;
            }

            /**
             * Sets the value of {@link DateFilterProperty#getStart}
             * @param start A timestamp that provides the start date for the date filter.
             *              For more information about the validation and formatting of timestamp fields in AWS Security Hub , see <a href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder start(java.lang.String start) {
                this.start = start;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DateFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DateFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DateFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DateFilterProperty {
            private final java.lang.Object dateRange;
            private final java.lang.String end;
            private final java.lang.String start;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dateRange = software.amazon.jsii.Kernel.get(this, "dateRange", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.end = software.amazon.jsii.Kernel.get(this, "end", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.start = software.amazon.jsii.Kernel.get(this, "start", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dateRange = builder.dateRange;
                this.end = builder.end;
                this.start = builder.start;
            }

            @Override
            public final java.lang.Object getDateRange() {
                return this.dateRange;
            }

            @Override
            public final java.lang.String getEnd() {
                return this.end;
            }

            @Override
            public final java.lang.String getStart() {
                return this.start;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDateRange() != null) {
                    data.set("dateRange", om.valueToTree(this.getDateRange()));
                }
                if (this.getEnd() != null) {
                    data.set("end", om.valueToTree(this.getEnd()));
                }
                if (this.getStart() != null) {
                    data.set("start", om.valueToTree(this.getStart()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnAutomationRule.DateFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DateFilterProperty.Jsii$Proxy that = (DateFilterProperty.Jsii$Proxy) o;

                if (this.dateRange != null ? !this.dateRange.equals(that.dateRange) : that.dateRange != null) return false;
                if (this.end != null ? !this.end.equals(that.end) : that.end != null) return false;
                return this.start != null ? this.start.equals(that.start) : that.start == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dateRange != null ? this.dateRange.hashCode() : 0;
                result = 31 * result + (this.end != null ? this.end.hashCode() : 0);
                result = 31 * result + (this.start != null ? this.start.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A date range for the date filter.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.securityhub.*;
     * DateRangeProperty dateRangeProperty = DateRangeProperty.builder()
     *         .unit("unit")
     *         .value(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-daterange.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-daterange.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnAutomationRule.DateRangeProperty")
    @software.amazon.jsii.Jsii.Proxy(DateRangeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DateRangeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A date range unit for the date filter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-daterange.html#cfn-securityhub-automationrule-daterange-unit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-daterange.html#cfn-securityhub-automationrule-daterange-unit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUnit();

        /**
         * A date range value for the date filter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-daterange.html#cfn-securityhub-automationrule-daterange-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-daterange.html#cfn-securityhub-automationrule-daterange-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getValue();

        /**
         * @return a {@link Builder} of {@link DateRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DateRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DateRangeProperty> {
            java.lang.String unit;
            java.lang.Number value;

            /**
             * Sets the value of {@link DateRangeProperty#getUnit}
             * @param unit A date range unit for the date filter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unit(java.lang.String unit) {
                this.unit = unit;
                return this;
            }

            /**
             * Sets the value of {@link DateRangeProperty#getValue}
             * @param value A date range value for the date filter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.Number value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DateRangeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DateRangeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DateRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DateRangeProperty {
            private final java.lang.String unit;
            private final java.lang.Number value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.unit = software.amazon.jsii.Kernel.get(this, "unit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.unit = java.util.Objects.requireNonNull(builder.unit, "unit is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getUnit() {
                return this.unit;
            }

            @Override
            public final java.lang.Number getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("unit", om.valueToTree(this.getUnit()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnAutomationRule.DateRangeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DateRangeProperty.Jsii$Proxy that = (DateRangeProperty.Jsii$Proxy) o;

                if (!unit.equals(that.unit)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.unit.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * A map filter for filtering AWS Security Hub findings.
     * <p>
     * Each map filter provides the field to check for, the value to check for, and the comparison operator.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.securityhub.*;
     * MapFilterProperty mapFilterProperty = MapFilterProperty.builder()
     *         .comparison("comparison")
     *         .key("key")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-mapfilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-mapfilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnAutomationRule.MapFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(MapFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MapFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The condition to apply to the key value when filtering Security Hub findings with a map filter.
         * <p>
         * To search for values that have the filter value, use one of the following comparison operators:
         * <p>
         * <ul>
         * <li>To search for values that include the filter value, use <code>CONTAINS</code> . For example, for the <code>ResourceTags</code> field, the filter <code>Department CONTAINS Security</code> matches findings that include the value <code>Security</code> for the <code>Department</code> tag. In the same example, a finding with a value of <code>Security team</code> for the <code>Department</code> tag is a match.</li>
         * <li>To search for values that exactly match the filter value, use <code>EQUALS</code> . For example, for the <code>ResourceTags</code> field, the filter <code>Department EQUALS Security</code> matches findings that have the value <code>Security</code> for the <code>Department</code> tag.</li>
         * </ul>
         * <p>
         * <code>CONTAINS</code> and <code>EQUALS</code> filters on the same field are joined by <code>OR</code> . A finding matches if it matches any one of those filters. For example, the filters <code>Department CONTAINS Security OR Department CONTAINS Finance</code> match a finding that includes either <code>Security</code> , <code>Finance</code> , or both values.
         * <p>
         * To search for values that don't have the filter value, use one of the following comparison operators:
         * <p>
         * <ul>
         * <li>To search for values that exclude the filter value, use <code>NOT_CONTAINS</code> . For example, for the <code>ResourceTags</code> field, the filter <code>Department NOT_CONTAINS Finance</code> matches findings that exclude the value <code>Finance</code> for the <code>Department</code> tag.</li>
         * <li>To search for values other than the filter value, use <code>NOT_EQUALS</code> . For example, for the <code>ResourceTags</code> field, the filter <code>Department NOT_EQUALS Finance</code> matches findings that don’t have the value <code>Finance</code> for the <code>Department</code> tag.</li>
         * </ul>
         * <p>
         * <code>NOT_CONTAINS</code> and <code>NOT_EQUALS</code> filters on the same field are joined by <code>AND</code> . A finding matches only if it matches all of those filters. For example, the filters <code>Department NOT_CONTAINS Security AND Department NOT_CONTAINS Finance</code> match a finding that excludes both the <code>Security</code> and <code>Finance</code> values.
         * <p>
         * <code>CONTAINS</code> filters can only be used with other <code>CONTAINS</code> filters. <code>NOT_CONTAINS</code> filters can only be used with other <code>NOT_CONTAINS</code> filters.
         * <p>
         * You can’t have both a <code>CONTAINS</code> filter and a <code>NOT_CONTAINS</code> filter on the same field. Similarly, you can’t have both an <code>EQUALS</code> filter and a <code>NOT_EQUALS</code> filter on the same field. Combining filters in this way returns an error.
         * <p>
         * <code>CONTAINS</code> and <code>NOT_CONTAINS</code> operators can be used only with automation rules. For more information, see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/automation-rules.html">Automation rules</a> in the <em>AWS Security Hub User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-mapfilter.html#cfn-securityhub-automationrule-mapfilter-comparison">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-mapfilter.html#cfn-securityhub-automationrule-mapfilter-comparison</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getComparison();

        /**
         * The key of the map filter.
         * <p>
         * For example, for <code>ResourceTags</code> , <code>Key</code> identifies the name of the tag. For <code>UserDefinedFields</code> , <code>Key</code> is the name of the field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-mapfilter.html#cfn-securityhub-automationrule-mapfilter-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-mapfilter.html#cfn-securityhub-automationrule-mapfilter-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * The value for the key in the map filter.
         * <p>
         * Filter values are case sensitive. For example, one of the values for a tag called <code>Department</code> might be <code>Security</code> . If you provide <code>security</code> as the filter value, then there's no match.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-mapfilter.html#cfn-securityhub-automationrule-mapfilter-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-mapfilter.html#cfn-securityhub-automationrule-mapfilter-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link MapFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MapFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MapFilterProperty> {
            java.lang.String comparison;
            java.lang.String key;
            java.lang.String value;

            /**
             * Sets the value of {@link MapFilterProperty#getComparison}
             * @param comparison The condition to apply to the key value when filtering Security Hub findings with a map filter. This parameter is required.
             *                   To search for values that have the filter value, use one of the following comparison operators:
             *                   <p>
             *                   <ul>
             *                   <li>To search for values that include the filter value, use <code>CONTAINS</code> . For example, for the <code>ResourceTags</code> field, the filter <code>Department CONTAINS Security</code> matches findings that include the value <code>Security</code> for the <code>Department</code> tag. In the same example, a finding with a value of <code>Security team</code> for the <code>Department</code> tag is a match.</li>
             *                   <li>To search for values that exactly match the filter value, use <code>EQUALS</code> . For example, for the <code>ResourceTags</code> field, the filter <code>Department EQUALS Security</code> matches findings that have the value <code>Security</code> for the <code>Department</code> tag.</li>
             *                   </ul>
             *                   <p>
             *                   <code>CONTAINS</code> and <code>EQUALS</code> filters on the same field are joined by <code>OR</code> . A finding matches if it matches any one of those filters. For example, the filters <code>Department CONTAINS Security OR Department CONTAINS Finance</code> match a finding that includes either <code>Security</code> , <code>Finance</code> , or both values.
             *                   <p>
             *                   To search for values that don't have the filter value, use one of the following comparison operators:
             *                   <p>
             *                   <ul>
             *                   <li>To search for values that exclude the filter value, use <code>NOT_CONTAINS</code> . For example, for the <code>ResourceTags</code> field, the filter <code>Department NOT_CONTAINS Finance</code> matches findings that exclude the value <code>Finance</code> for the <code>Department</code> tag.</li>
             *                   <li>To search for values other than the filter value, use <code>NOT_EQUALS</code> . For example, for the <code>ResourceTags</code> field, the filter <code>Department NOT_EQUALS Finance</code> matches findings that don’t have the value <code>Finance</code> for the <code>Department</code> tag.</li>
             *                   </ul>
             *                   <p>
             *                   <code>NOT_CONTAINS</code> and <code>NOT_EQUALS</code> filters on the same field are joined by <code>AND</code> . A finding matches only if it matches all of those filters. For example, the filters <code>Department NOT_CONTAINS Security AND Department NOT_CONTAINS Finance</code> match a finding that excludes both the <code>Security</code> and <code>Finance</code> values.
             *                   <p>
             *                   <code>CONTAINS</code> filters can only be used with other <code>CONTAINS</code> filters. <code>NOT_CONTAINS</code> filters can only be used with other <code>NOT_CONTAINS</code> filters.
             *                   <p>
             *                   You can’t have both a <code>CONTAINS</code> filter and a <code>NOT_CONTAINS</code> filter on the same field. Similarly, you can’t have both an <code>EQUALS</code> filter and a <code>NOT_EQUALS</code> filter on the same field. Combining filters in this way returns an error.
             *                   <p>
             *                   <code>CONTAINS</code> and <code>NOT_CONTAINS</code> operators can be used only with automation rules. For more information, see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/automation-rules.html">Automation rules</a> in the <em>AWS Security Hub User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder comparison(java.lang.String comparison) {
                this.comparison = comparison;
                return this;
            }

            /**
             * Sets the value of {@link MapFilterProperty#getKey}
             * @param key The key of the map filter. This parameter is required.
             *            For example, for <code>ResourceTags</code> , <code>Key</code> identifies the name of the tag. For <code>UserDefinedFields</code> , <code>Key</code> is the name of the field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link MapFilterProperty#getValue}
             * @param value The value for the key in the map filter. This parameter is required.
             *              Filter values are case sensitive. For example, one of the values for a tag called <code>Department</code> might be <code>Security</code> . If you provide <code>security</code> as the filter value, then there's no match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MapFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MapFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MapFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MapFilterProperty {
            private final java.lang.String comparison;
            private final java.lang.String key;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.comparison = software.amazon.jsii.Kernel.get(this, "comparison", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.comparison = java.util.Objects.requireNonNull(builder.comparison, "comparison is required");
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getComparison() {
                return this.comparison;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("comparison", om.valueToTree(this.getComparison()));
                data.set("key", om.valueToTree(this.getKey()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnAutomationRule.MapFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MapFilterProperty.Jsii$Proxy that = (MapFilterProperty.Jsii$Proxy) o;

                if (!comparison.equals(that.comparison)) return false;
                if (!key.equals(that.key)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.comparison.hashCode();
                result = 31 * result + (this.key.hashCode());
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * The updated note.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.securityhub.*;
     * Object updatedBy;
     * NoteUpdateProperty noteUpdateProperty = NoteUpdateProperty.builder()
     *         .text("text")
     *         .updatedBy(updatedBy)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-noteupdate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-noteupdate.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnAutomationRule.NoteUpdateProperty")
    @software.amazon.jsii.Jsii.Proxy(NoteUpdateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NoteUpdateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The updated note text.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-noteupdate.html#cfn-securityhub-automationrule-noteupdate-text">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-noteupdate.html#cfn-securityhub-automationrule-noteupdate-text</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getText();

        /**
         * The principal that updated the note.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-noteupdate.html#cfn-securityhub-automationrule-noteupdate-updatedby">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-noteupdate.html#cfn-securityhub-automationrule-noteupdate-updatedby</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getUpdatedBy();

        /**
         * @return a {@link Builder} of {@link NoteUpdateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NoteUpdateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NoteUpdateProperty> {
            java.lang.String text;
            java.lang.Object updatedBy;

            /**
             * Sets the value of {@link NoteUpdateProperty#getText}
             * @param text The updated note text. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder text(java.lang.String text) {
                this.text = text;
                return this;
            }

            /**
             * Sets the value of {@link NoteUpdateProperty#getUpdatedBy}
             * @param updatedBy The principal that updated the note. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder updatedBy(java.lang.Object updatedBy) {
                this.updatedBy = updatedBy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NoteUpdateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NoteUpdateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NoteUpdateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NoteUpdateProperty {
            private final java.lang.String text;
            private final java.lang.Object updatedBy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.text = software.amazon.jsii.Kernel.get(this, "text", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.updatedBy = software.amazon.jsii.Kernel.get(this, "updatedBy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.text = java.util.Objects.requireNonNull(builder.text, "text is required");
                this.updatedBy = java.util.Objects.requireNonNull(builder.updatedBy, "updatedBy is required");
            }

            @Override
            public final java.lang.String getText() {
                return this.text;
            }

            @Override
            public final java.lang.Object getUpdatedBy() {
                return this.updatedBy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("text", om.valueToTree(this.getText()));
                data.set("updatedBy", om.valueToTree(this.getUpdatedBy()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnAutomationRule.NoteUpdateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NoteUpdateProperty.Jsii$Proxy that = (NoteUpdateProperty.Jsii$Proxy) o;

                if (!text.equals(that.text)) return false;
                return this.updatedBy.equals(that.updatedBy);
            }

            @Override
            public final int hashCode() {
                int result = this.text.hashCode();
                result = 31 * result + (this.updatedBy.hashCode());
                return result;
            }
        }
    }
    /**
     * A number filter for querying findings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.securityhub.*;
     * NumberFilterProperty numberFilterProperty = NumberFilterProperty.builder()
     *         .eq(123)
     *         .gte(123)
     *         .lte(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-numberfilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-numberfilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnAutomationRule.NumberFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(NumberFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NumberFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The equal-to condition to be applied to a single field when querying for findings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-numberfilter.html#cfn-securityhub-automationrule-numberfilter-eq">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-numberfilter.html#cfn-securityhub-automationrule-numberfilter-eq</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getEq() {
            return null;
        }

        /**
         * The greater-than-equal condition to be applied to a single field when querying for findings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-numberfilter.html#cfn-securityhub-automationrule-numberfilter-gte">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-numberfilter.html#cfn-securityhub-automationrule-numberfilter-gte</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getGte() {
            return null;
        }

        /**
         * The less-than-equal condition to be applied to a single field when querying for findings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-numberfilter.html#cfn-securityhub-automationrule-numberfilter-lte">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-numberfilter.html#cfn-securityhub-automationrule-numberfilter-lte</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getLte() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NumberFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NumberFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NumberFilterProperty> {
            java.lang.Number eq;
            java.lang.Number gte;
            java.lang.Number lte;

            /**
             * Sets the value of {@link NumberFilterProperty#getEq}
             * @param eq The equal-to condition to be applied to a single field when querying for findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eq(java.lang.Number eq) {
                this.eq = eq;
                return this;
            }

            /**
             * Sets the value of {@link NumberFilterProperty#getGte}
             * @param gte The greater-than-equal condition to be applied to a single field when querying for findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder gte(java.lang.Number gte) {
                this.gte = gte;
                return this;
            }

            /**
             * Sets the value of {@link NumberFilterProperty#getLte}
             * @param lte The less-than-equal condition to be applied to a single field when querying for findings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lte(java.lang.Number lte) {
                this.lte = lte;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NumberFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NumberFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NumberFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NumberFilterProperty {
            private final java.lang.Number eq;
            private final java.lang.Number gte;
            private final java.lang.Number lte;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.eq = software.amazon.jsii.Kernel.get(this, "eq", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.gte = software.amazon.jsii.Kernel.get(this, "gte", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.lte = software.amazon.jsii.Kernel.get(this, "lte", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.eq = builder.eq;
                this.gte = builder.gte;
                this.lte = builder.lte;
            }

            @Override
            public final java.lang.Number getEq() {
                return this.eq;
            }

            @Override
            public final java.lang.Number getGte() {
                return this.gte;
            }

            @Override
            public final java.lang.Number getLte() {
                return this.lte;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEq() != null) {
                    data.set("eq", om.valueToTree(this.getEq()));
                }
                if (this.getGte() != null) {
                    data.set("gte", om.valueToTree(this.getGte()));
                }
                if (this.getLte() != null) {
                    data.set("lte", om.valueToTree(this.getLte()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnAutomationRule.NumberFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NumberFilterProperty.Jsii$Proxy that = (NumberFilterProperty.Jsii$Proxy) o;

                if (this.eq != null ? !this.eq.equals(that.eq) : that.eq != null) return false;
                if (this.gte != null ? !this.gte.equals(that.gte) : that.gte != null) return false;
                return this.lte != null ? this.lte.equals(that.lte) : that.lte == null;
            }

            @Override
            public final int hashCode() {
                int result = this.eq != null ? this.eq.hashCode() : 0;
                result = 31 * result + (this.gte != null ? this.gte.hashCode() : 0);
                result = 31 * result + (this.lte != null ? this.lte.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Provides details about a list of findings that the current finding relates to.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.securityhub.*;
     * Object id;
     * RelatedFindingProperty relatedFindingProperty = RelatedFindingProperty.builder()
     *         .id(id)
     *         .productArn("productArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-relatedfinding.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-relatedfinding.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnAutomationRule.RelatedFindingProperty")
    @software.amazon.jsii.Jsii.Proxy(RelatedFindingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RelatedFindingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The product-generated identifier for a related finding.
         * <p>
         * Array Members: Minimum number of 1 item. Maximum number of 20 items.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-relatedfinding.html#cfn-securityhub-automationrule-relatedfinding-id">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-relatedfinding.html#cfn-securityhub-automationrule-relatedfinding-id</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getId();

        /**
         * The Amazon Resource Name (ARN) for the product that generated a related finding.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-relatedfinding.html#cfn-securityhub-automationrule-relatedfinding-productarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-relatedfinding.html#cfn-securityhub-automationrule-relatedfinding-productarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getProductArn();

        /**
         * @return a {@link Builder} of {@link RelatedFindingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RelatedFindingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RelatedFindingProperty> {
            java.lang.Object id;
            java.lang.String productArn;

            /**
             * Sets the value of {@link RelatedFindingProperty#getId}
             * @param id The product-generated identifier for a related finding. This parameter is required.
             *           Array Members: Minimum number of 1 item. Maximum number of 20 items.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.Object id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link RelatedFindingProperty#getProductArn}
             * @param productArn The Amazon Resource Name (ARN) for the product that generated a related finding. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder productArn(java.lang.String productArn) {
                this.productArn = productArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RelatedFindingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RelatedFindingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RelatedFindingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RelatedFindingProperty {
            private final java.lang.Object id;
            private final java.lang.String productArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.productArn = software.amazon.jsii.Kernel.get(this, "productArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.id = java.util.Objects.requireNonNull(builder.id, "id is required");
                this.productArn = java.util.Objects.requireNonNull(builder.productArn, "productArn is required");
            }

            @Override
            public final java.lang.Object getId() {
                return this.id;
            }

            @Override
            public final java.lang.String getProductArn() {
                return this.productArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("id", om.valueToTree(this.getId()));
                data.set("productArn", om.valueToTree(this.getProductArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnAutomationRule.RelatedFindingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RelatedFindingProperty.Jsii$Proxy that = (RelatedFindingProperty.Jsii$Proxy) o;

                if (!id.equals(that.id)) return false;
                return this.productArn.equals(that.productArn);
            }

            @Override
            public final int hashCode() {
                int result = this.id.hashCode();
                result = 31 * result + (this.productArn.hashCode());
                return result;
            }
        }
    }
    /**
     * Updates to the severity information for a finding.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.securityhub.*;
     * SeverityUpdateProperty severityUpdateProperty = SeverityUpdateProperty.builder()
     *         .label("label")
     *         .normalized(123)
     *         .product(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-severityupdate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-severityupdate.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnAutomationRule.SeverityUpdateProperty")
    @software.amazon.jsii.Jsii.Proxy(SeverityUpdateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SeverityUpdateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The severity value of the finding. The allowed values are the following.
         * <p>
         * <ul>
         * <li><code>INFORMATIONAL</code> - No issue was found.</li>
         * <li><code>LOW</code> - The issue does not require action on its own.</li>
         * <li><code>MEDIUM</code> - The issue must be addressed but not urgently.</li>
         * <li><code>HIGH</code> - The issue must be addressed as a priority.</li>
         * <li><code>CRITICAL</code> - The issue must be remediated immediately to avoid it escalating.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-severityupdate.html#cfn-securityhub-automationrule-severityupdate-label">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-severityupdate.html#cfn-securityhub-automationrule-severityupdate-label</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLabel() {
            return null;
        }

        /**
         * The normalized severity for the finding. This attribute is to be deprecated in favor of <code>Label</code> .
         * <p>
         * If you provide <code>Normalized</code> and don't provide <code>Label</code> , <code>Label</code> is set automatically as follows.
         * <p>
         * <ul>
         * <li>0 - <code>INFORMATIONAL</code></li>
         * <li>1–39 - <code>LOW</code></li>
         * <li>40–69 - <code>MEDIUM</code></li>
         * <li>70–89 - <code>HIGH</code></li>
         * <li>90–100 - <code>CRITICAL</code></li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-severityupdate.html#cfn-securityhub-automationrule-severityupdate-normalized">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-severityupdate.html#cfn-securityhub-automationrule-severityupdate-normalized</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getNormalized() {
            return null;
        }

        /**
         * The native severity as defined by the AWS service or integrated partner product that generated the finding.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-severityupdate.html#cfn-securityhub-automationrule-severityupdate-product">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-severityupdate.html#cfn-securityhub-automationrule-severityupdate-product</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getProduct() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SeverityUpdateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SeverityUpdateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SeverityUpdateProperty> {
            java.lang.String label;
            java.lang.Number normalized;
            java.lang.Number product;

            /**
             * Sets the value of {@link SeverityUpdateProperty#getLabel}
             * @param label The severity value of the finding. The allowed values are the following.
             *              <ul>
             *              <li><code>INFORMATIONAL</code> - No issue was found.</li>
             *              <li><code>LOW</code> - The issue does not require action on its own.</li>
             *              <li><code>MEDIUM</code> - The issue must be addressed but not urgently.</li>
             *              <li><code>HIGH</code> - The issue must be addressed as a priority.</li>
             *              <li><code>CRITICAL</code> - The issue must be remediated immediately to avoid it escalating.</li>
             *              </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder label(java.lang.String label) {
                this.label = label;
                return this;
            }

            /**
             * Sets the value of {@link SeverityUpdateProperty#getNormalized}
             * @param normalized The normalized severity for the finding. This attribute is to be deprecated in favor of <code>Label</code> .
             *                   If you provide <code>Normalized</code> and don't provide <code>Label</code> , <code>Label</code> is set automatically as follows.
             *                   <p>
             *                   <ul>
             *                   <li>0 - <code>INFORMATIONAL</code></li>
             *                   <li>1–39 - <code>LOW</code></li>
             *                   <li>40–69 - <code>MEDIUM</code></li>
             *                   <li>70–89 - <code>HIGH</code></li>
             *                   <li>90–100 - <code>CRITICAL</code></li>
             *                   </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder normalized(java.lang.Number normalized) {
                this.normalized = normalized;
                return this;
            }

            /**
             * Sets the value of {@link SeverityUpdateProperty#getProduct}
             * @param product The native severity as defined by the AWS service or integrated partner product that generated the finding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder product(java.lang.Number product) {
                this.product = product;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SeverityUpdateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SeverityUpdateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SeverityUpdateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SeverityUpdateProperty {
            private final java.lang.String label;
            private final java.lang.Number normalized;
            private final java.lang.Number product;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.label = software.amazon.jsii.Kernel.get(this, "label", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.normalized = software.amazon.jsii.Kernel.get(this, "normalized", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.product = software.amazon.jsii.Kernel.get(this, "product", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.label = builder.label;
                this.normalized = builder.normalized;
                this.product = builder.product;
            }

            @Override
            public final java.lang.String getLabel() {
                return this.label;
            }

            @Override
            public final java.lang.Number getNormalized() {
                return this.normalized;
            }

            @Override
            public final java.lang.Number getProduct() {
                return this.product;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLabel() != null) {
                    data.set("label", om.valueToTree(this.getLabel()));
                }
                if (this.getNormalized() != null) {
                    data.set("normalized", om.valueToTree(this.getNormalized()));
                }
                if (this.getProduct() != null) {
                    data.set("product", om.valueToTree(this.getProduct()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnAutomationRule.SeverityUpdateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SeverityUpdateProperty.Jsii$Proxy that = (SeverityUpdateProperty.Jsii$Proxy) o;

                if (this.label != null ? !this.label.equals(that.label) : that.label != null) return false;
                if (this.normalized != null ? !this.normalized.equals(that.normalized) : that.normalized != null) return false;
                return this.product != null ? this.product.equals(that.product) : that.product == null;
            }

            @Override
            public final int hashCode() {
                int result = this.label != null ? this.label.hashCode() : 0;
                result = 31 * result + (this.normalized != null ? this.normalized.hashCode() : 0);
                result = 31 * result + (this.product != null ? this.product.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A string filter for filtering AWS Security Hub findings.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.securityhub.*;
     * StringFilterProperty stringFilterProperty = StringFilterProperty.builder()
     *         .comparison("comparison")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-stringfilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-stringfilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnAutomationRule.StringFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(StringFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StringFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The condition to apply to a string value when filtering Security Hub findings.
         * <p>
         * To search for values that have the filter value, use one of the following comparison operators:
         * <p>
         * <ul>
         * <li>To search for values that include the filter value, use <code>CONTAINS</code> . For example, the filter <code>Title CONTAINS CloudFront</code> matches findings that have a <code>Title</code> that includes the string CloudFront.</li>
         * <li>To search for values that exactly match the filter value, use <code>EQUALS</code> . For example, the filter <code>AwsAccountId EQUALS 123456789012</code> only matches findings that have an account ID of <code>123456789012</code> .</li>
         * <li>To search for values that start with the filter value, use <code>PREFIX</code> . For example, the filter <code>ResourceRegion PREFIX us</code> matches findings that have a <code>ResourceRegion</code> that starts with <code>us</code> . A <code>ResourceRegion</code> that starts with a different value, such as <code>af</code> , <code>ap</code> , or <code>ca</code> , doesn't match.</li>
         * </ul>
         * <p>
         * <code>CONTAINS</code> , <code>EQUALS</code> , and <code>PREFIX</code> filters on the same field are joined by <code>OR</code> . A finding matches if it matches any one of those filters. For example, the filters <code>Title CONTAINS CloudFront OR Title CONTAINS CloudWatch</code> match a finding that includes either <code>CloudFront</code> , <code>CloudWatch</code> , or both strings in the title.
         * <p>
         * To search for values that don’t have the filter value, use one of the following comparison operators:
         * <p>
         * <ul>
         * <li>To search for values that exclude the filter value, use <code>NOT_CONTAINS</code> . For example, the filter <code>Title NOT_CONTAINS CloudFront</code> matches findings that have a <code>Title</code> that excludes the string CloudFront.</li>
         * <li>To search for values other than the filter value, use <code>NOT_EQUALS</code> . For example, the filter <code>AwsAccountId NOT_EQUALS 123456789012</code> only matches findings that have an account ID other than <code>123456789012</code> .</li>
         * <li>To search for values that don't start with the filter value, use <code>PREFIX_NOT_EQUALS</code> . For example, the filter <code>ResourceRegion PREFIX_NOT_EQUALS us</code> matches findings with a <code>ResourceRegion</code> that starts with a value other than <code>us</code> .</li>
         * </ul>
         * <p>
         * <code>NOT_CONTAINS</code> , <code>NOT_EQUALS</code> , and <code>PREFIX_NOT_EQUALS</code> filters on the same field are joined by <code>AND</code> . A finding matches only if it matches all of those filters. For example, the filters <code>Title NOT_CONTAINS CloudFront AND Title NOT_CONTAINS CloudWatch</code> match a finding that excludes both <code>CloudFront</code> and <code>CloudWatch</code> in the title.
         * <p>
         * You can’t have both a <code>CONTAINS</code> filter and a <code>NOT_CONTAINS</code> filter on the same field. Similarly, you can't provide both an <code>EQUALS</code> filter and a <code>NOT_EQUALS</code> or <code>PREFIX_NOT_EQUALS</code> filter on the same field. Combining filters in this way returns an error. <code>CONTAINS</code> filters can only be used with other <code>CONTAINS</code> filters. <code>NOT_CONTAINS</code> filters can only be used with other <code>NOT_CONTAINS</code> filters.
         * <p>
         * You can combine <code>PREFIX</code> filters with <code>NOT_EQUALS</code> or <code>PREFIX_NOT_EQUALS</code> filters for the same field. Security Hub first processes the <code>PREFIX</code> filters, and then the <code>NOT_EQUALS</code> or <code>PREFIX_NOT_EQUALS</code> filters.
         * <p>
         * For example, for the following filters, Security Hub first identifies findings that have resource types that start with either <code>AwsIam</code> or <code>AwsEc2</code> . It then excludes findings that have a resource type of <code>AwsIamPolicy</code> and findings that have a resource type of <code>AwsEc2NetworkInterface</code> .
         * <p>
         * <ul>
         * <li><code>ResourceType PREFIX AwsIam</code></li>
         * <li><code>ResourceType PREFIX AwsEc2</code></li>
         * <li><code>ResourceType NOT_EQUALS AwsIamPolicy</code></li>
         * <li><code>ResourceType NOT_EQUALS AwsEc2NetworkInterface</code></li>
         * </ul>
         * <p>
         * <code>CONTAINS</code> and <code>NOT_CONTAINS</code> operators can be used only with automation rules. For more information, see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/automation-rules.html">Automation rules</a> in the <em>AWS Security Hub User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-stringfilter.html#cfn-securityhub-automationrule-stringfilter-comparison">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-stringfilter.html#cfn-securityhub-automationrule-stringfilter-comparison</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getComparison();

        /**
         * The string filter value.
         * <p>
         * Filter values are case sensitive. For example, the product name for control-based findings is <code>Security Hub</code> . If you provide <code>security hub</code> as the filter value, there's no match.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-stringfilter.html#cfn-securityhub-automationrule-stringfilter-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-stringfilter.html#cfn-securityhub-automationrule-stringfilter-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link StringFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StringFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StringFilterProperty> {
            java.lang.String comparison;
            java.lang.String value;

            /**
             * Sets the value of {@link StringFilterProperty#getComparison}
             * @param comparison The condition to apply to a string value when filtering Security Hub findings. This parameter is required.
             *                   To search for values that have the filter value, use one of the following comparison operators:
             *                   <p>
             *                   <ul>
             *                   <li>To search for values that include the filter value, use <code>CONTAINS</code> . For example, the filter <code>Title CONTAINS CloudFront</code> matches findings that have a <code>Title</code> that includes the string CloudFront.</li>
             *                   <li>To search for values that exactly match the filter value, use <code>EQUALS</code> . For example, the filter <code>AwsAccountId EQUALS 123456789012</code> only matches findings that have an account ID of <code>123456789012</code> .</li>
             *                   <li>To search for values that start with the filter value, use <code>PREFIX</code> . For example, the filter <code>ResourceRegion PREFIX us</code> matches findings that have a <code>ResourceRegion</code> that starts with <code>us</code> . A <code>ResourceRegion</code> that starts with a different value, such as <code>af</code> , <code>ap</code> , or <code>ca</code> , doesn't match.</li>
             *                   </ul>
             *                   <p>
             *                   <code>CONTAINS</code> , <code>EQUALS</code> , and <code>PREFIX</code> filters on the same field are joined by <code>OR</code> . A finding matches if it matches any one of those filters. For example, the filters <code>Title CONTAINS CloudFront OR Title CONTAINS CloudWatch</code> match a finding that includes either <code>CloudFront</code> , <code>CloudWatch</code> , or both strings in the title.
             *                   <p>
             *                   To search for values that don’t have the filter value, use one of the following comparison operators:
             *                   <p>
             *                   <ul>
             *                   <li>To search for values that exclude the filter value, use <code>NOT_CONTAINS</code> . For example, the filter <code>Title NOT_CONTAINS CloudFront</code> matches findings that have a <code>Title</code> that excludes the string CloudFront.</li>
             *                   <li>To search for values other than the filter value, use <code>NOT_EQUALS</code> . For example, the filter <code>AwsAccountId NOT_EQUALS 123456789012</code> only matches findings that have an account ID other than <code>123456789012</code> .</li>
             *                   <li>To search for values that don't start with the filter value, use <code>PREFIX_NOT_EQUALS</code> . For example, the filter <code>ResourceRegion PREFIX_NOT_EQUALS us</code> matches findings with a <code>ResourceRegion</code> that starts with a value other than <code>us</code> .</li>
             *                   </ul>
             *                   <p>
             *                   <code>NOT_CONTAINS</code> , <code>NOT_EQUALS</code> , and <code>PREFIX_NOT_EQUALS</code> filters on the same field are joined by <code>AND</code> . A finding matches only if it matches all of those filters. For example, the filters <code>Title NOT_CONTAINS CloudFront AND Title NOT_CONTAINS CloudWatch</code> match a finding that excludes both <code>CloudFront</code> and <code>CloudWatch</code> in the title.
             *                   <p>
             *                   You can’t have both a <code>CONTAINS</code> filter and a <code>NOT_CONTAINS</code> filter on the same field. Similarly, you can't provide both an <code>EQUALS</code> filter and a <code>NOT_EQUALS</code> or <code>PREFIX_NOT_EQUALS</code> filter on the same field. Combining filters in this way returns an error. <code>CONTAINS</code> filters can only be used with other <code>CONTAINS</code> filters. <code>NOT_CONTAINS</code> filters can only be used with other <code>NOT_CONTAINS</code> filters.
             *                   <p>
             *                   You can combine <code>PREFIX</code> filters with <code>NOT_EQUALS</code> or <code>PREFIX_NOT_EQUALS</code> filters for the same field. Security Hub first processes the <code>PREFIX</code> filters, and then the <code>NOT_EQUALS</code> or <code>PREFIX_NOT_EQUALS</code> filters.
             *                   <p>
             *                   For example, for the following filters, Security Hub first identifies findings that have resource types that start with either <code>AwsIam</code> or <code>AwsEc2</code> . It then excludes findings that have a resource type of <code>AwsIamPolicy</code> and findings that have a resource type of <code>AwsEc2NetworkInterface</code> .
             *                   <p>
             *                   <ul>
             *                   <li><code>ResourceType PREFIX AwsIam</code></li>
             *                   <li><code>ResourceType PREFIX AwsEc2</code></li>
             *                   <li><code>ResourceType NOT_EQUALS AwsIamPolicy</code></li>
             *                   <li><code>ResourceType NOT_EQUALS AwsEc2NetworkInterface</code></li>
             *                   </ul>
             *                   <p>
             *                   <code>CONTAINS</code> and <code>NOT_CONTAINS</code> operators can be used only with automation rules. For more information, see <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/automation-rules.html">Automation rules</a> in the <em>AWS Security Hub User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder comparison(java.lang.String comparison) {
                this.comparison = comparison;
                return this;
            }

            /**
             * Sets the value of {@link StringFilterProperty#getValue}
             * @param value The string filter value. This parameter is required.
             *              Filter values are case sensitive. For example, the product name for control-based findings is <code>Security Hub</code> . If you provide <code>security hub</code> as the filter value, there's no match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StringFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StringFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StringFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StringFilterProperty {
            private final java.lang.String comparison;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.comparison = software.amazon.jsii.Kernel.get(this, "comparison", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.comparison = java.util.Objects.requireNonNull(builder.comparison, "comparison is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getComparison() {
                return this.comparison;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("comparison", om.valueToTree(this.getComparison()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnAutomationRule.StringFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StringFilterProperty.Jsii$Proxy that = (StringFilterProperty.Jsii$Proxy) o;

                if (!comparison.equals(that.comparison)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.comparison.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * Used to update information about the investigation into the finding.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.securityhub.*;
     * WorkflowUpdateProperty workflowUpdateProperty = WorkflowUpdateProperty.builder()
     *         .status("status")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-workflowupdate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-workflowupdate.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnAutomationRule.WorkflowUpdateProperty")
    @software.amazon.jsii.Jsii.Proxy(WorkflowUpdateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WorkflowUpdateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The status of the investigation into the finding.
         * <p>
         * The workflow status is specific to an individual finding. It does not affect the generation of new findings. For example, setting the workflow status to <code>SUPPRESSED</code> or <code>RESOLVED</code> does not prevent a new finding for the same issue.
         * <p>
         * The allowed values are the following.
         * <p>
         * <ul>
         * <li><code>NEW</code> - The initial state of a finding, before it is reviewed.</li>
         * </ul>
         * <p>
         * Security Hub also resets <code>WorkFlowStatus</code> from <code>NOTIFIED</code> or <code>RESOLVED</code> to <code>NEW</code> in the following cases:
         * <p>
         * <ul>
         * <li>The record state changes from <code>ARCHIVED</code> to <code>ACTIVE</code> .</li>
         * <li>The compliance status changes from <code>PASSED</code> to either <code>WARNING</code> , <code>FAILED</code> , or <code>NOT_AVAILABLE</code> .</li>
         * <li><code>NOTIFIED</code> - Indicates that you notified the resource owner about the security issue. Used when the initial reviewer is not the resource owner, and needs intervention from the resource owner.</li>
         * <li><code>RESOLVED</code> - The finding was reviewed and remediated and is now considered resolved.</li>
         * <li><code>SUPPRESSED</code> - Indicates that you reviewed the finding and don't believe that any action is needed. The finding is no longer updated.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-workflowupdate.html#cfn-securityhub-automationrule-workflowupdate-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-workflowupdate.html#cfn-securityhub-automationrule-workflowupdate-status</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStatus();

        /**
         * @return a {@link Builder} of {@link WorkflowUpdateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WorkflowUpdateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WorkflowUpdateProperty> {
            java.lang.String status;

            /**
             * Sets the value of {@link WorkflowUpdateProperty#getStatus}
             * @param status The status of the investigation into the finding. This parameter is required.
             *               The workflow status is specific to an individual finding. It does not affect the generation of new findings. For example, setting the workflow status to <code>SUPPRESSED</code> or <code>RESOLVED</code> does not prevent a new finding for the same issue.
             *               <p>
             *               The allowed values are the following.
             *               <p>
             *               <ul>
             *               <li><code>NEW</code> - The initial state of a finding, before it is reviewed.</li>
             *               </ul>
             *               <p>
             *               Security Hub also resets <code>WorkFlowStatus</code> from <code>NOTIFIED</code> or <code>RESOLVED</code> to <code>NEW</code> in the following cases:
             *               <p>
             *               <ul>
             *               <li>The record state changes from <code>ARCHIVED</code> to <code>ACTIVE</code> .</li>
             *               <li>The compliance status changes from <code>PASSED</code> to either <code>WARNING</code> , <code>FAILED</code> , or <code>NOT_AVAILABLE</code> .</li>
             *               <li><code>NOTIFIED</code> - Indicates that you notified the resource owner about the security issue. Used when the initial reviewer is not the resource owner, and needs intervention from the resource owner.</li>
             *               <li><code>RESOLVED</code> - The finding was reviewed and remediated and is now considered resolved.</li>
             *               <li><code>SUPPRESSED</code> - Indicates that you reviewed the finding and don't believe that any action is needed. The finding is no longer updated.</li>
             *               </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WorkflowUpdateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WorkflowUpdateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WorkflowUpdateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WorkflowUpdateProperty {
            private final java.lang.String status;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.status = java.util.Objects.requireNonNull(builder.status, "status is required");
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("status", om.valueToTree(this.getStatus()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnAutomationRule.WorkflowUpdateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WorkflowUpdateProperty.Jsii$Proxy that = (WorkflowUpdateProperty.Jsii$Proxy) o;

                return this.status.equals(that.status);
            }

            @Override
            public final int hashCode() {
                int result = this.status.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.securityhub.CfnAutomationRule}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.securityhub.CfnAutomationRule> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.securityhub.CfnAutomationRuleProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.securityhub.CfnAutomationRuleProps.Builder();
        }

        /**
         * One or more actions to update finding fields if a finding matches the conditions specified in <code>Criteria</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-actions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-actions</a>
         * @param actions One or more actions to update finding fields if a finding matches the conditions specified in <code>Criteria</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actions(final software.amazon.awscdk.IResolvable actions) {
            this.props.actions(actions);
            return this;
        }
        /**
         * One or more actions to update finding fields if a finding matches the conditions specified in <code>Criteria</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-actions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-actions</a>
         * @param actions One or more actions to update finding fields if a finding matches the conditions specified in <code>Criteria</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actions(final java.util.List<? extends java.lang.Object> actions) {
            this.props.actions(actions);
            return this;
        }

        /**
         * A set of <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format.html">AWS Security Finding Format (ASFF)</a> finding field attributes and corresponding expected values that Security Hub uses to filter findings. If a rule is enabled and a finding matches the criteria specified in this parameter, Security Hub applies the rule action to the finding.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-criteria">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-criteria</a>
         * @param criteria A set of <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format.html">AWS Security Finding Format (ASFF)</a> finding field attributes and corresponding expected values that Security Hub uses to filter findings. If a rule is enabled and a finding matches the criteria specified in this parameter, Security Hub applies the rule action to the finding. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder criteria(final software.amazon.awscdk.IResolvable criteria) {
            this.props.criteria(criteria);
            return this;
        }
        /**
         * A set of <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format.html">AWS Security Finding Format (ASFF)</a> finding field attributes and corresponding expected values that Security Hub uses to filter findings. If a rule is enabled and a finding matches the criteria specified in this parameter, Security Hub applies the rule action to the finding.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-criteria">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-criteria</a>
         * @param criteria A set of <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format.html">AWS Security Finding Format (ASFF)</a> finding field attributes and corresponding expected values that Security Hub uses to filter findings. If a rule is enabled and a finding matches the criteria specified in this parameter, Security Hub applies the rule action to the finding. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder criteria(final software.amazon.awscdk.services.securityhub.CfnAutomationRule.AutomationRulesFindingFiltersProperty criteria) {
            this.props.criteria(criteria);
            return this;
        }

        /**
         * A description of the rule.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-description</a>
         * @param description A description of the rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The name of the rule.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-rulename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-rulename</a>
         * @param ruleName The name of the rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleName(final java.lang.String ruleName) {
            this.props.ruleName(ruleName);
            return this;
        }

        /**
         * An integer ranging from 1 to 1000 that represents the order in which the rule action is applied to findings.
         * <p>
         * Security Hub applies rules with lower values for this parameter first.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-ruleorder">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-ruleorder</a>
         * @param ruleOrder An integer ranging from 1 to 1000 that represents the order in which the rule action is applied to findings. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleOrder(final java.lang.Number ruleOrder) {
            this.props.ruleOrder(ruleOrder);
            return this;
        }

        /**
         * Specifies whether a rule is the last to be applied with respect to a finding that matches the rule criteria.
         * <p>
         * This is useful when a finding matches the criteria for multiple rules, and each rule has different actions. If a rule is terminal, Security Hub applies the rule action to a finding that matches the rule criteria and doesn't evaluate other rules for the finding. By default, a rule isn't terminal.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-isterminal">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-isterminal</a>
         * @param isTerminal Specifies whether a rule is the last to be applied with respect to a finding that matches the rule criteria. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isTerminal(final java.lang.Boolean isTerminal) {
            this.props.isTerminal(isTerminal);
            return this;
        }
        /**
         * Specifies whether a rule is the last to be applied with respect to a finding that matches the rule criteria.
         * <p>
         * This is useful when a finding matches the criteria for multiple rules, and each rule has different actions. If a rule is terminal, Security Hub applies the rule action to a finding that matches the rule criteria and doesn't evaluate other rules for the finding. By default, a rule isn't terminal.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-isterminal">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-isterminal</a>
         * @param isTerminal Specifies whether a rule is the last to be applied with respect to a finding that matches the rule criteria. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isTerminal(final software.amazon.awscdk.IResolvable isTerminal) {
            this.props.isTerminal(isTerminal);
            return this;
        }

        /**
         * Whether the rule is active after it is created.
         * <p>
         * If this parameter is equal to <code>ENABLED</code> , Security Hub applies the rule to findings and finding updates after the rule is created.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-rulestatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-rulestatus</a>
         * @param ruleStatus Whether the rule is active after it is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleStatus(final java.lang.String ruleStatus) {
            this.props.ruleStatus(ruleStatus);
            return this;
        }

        /**
         * User-defined tags associated with an automation rule.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-tags</a>
         * @param tags User-defined tags associated with an automation rule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.securityhub.CfnAutomationRule}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.securityhub.CfnAutomationRule build() {
            return new software.amazon.awscdk.services.securityhub.CfnAutomationRule(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
