package software.amazon.awscdk.services.securityhub;

/**
 * Properties for defining a <code>CfnAutomationRule</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.securityhub.*;
 * Object id;
 * Object updatedBy;
 * CfnAutomationRuleProps cfnAutomationRuleProps = CfnAutomationRuleProps.builder()
 *         .actions(List.of(AutomationRulesActionProperty.builder()
 *                 .findingFieldsUpdate(AutomationRulesFindingFieldsUpdateProperty.builder()
 *                         .confidence(123)
 *                         .criticality(123)
 *                         .note(NoteUpdateProperty.builder()
 *                                 .text("text")
 *                                 .updatedBy(updatedBy)
 *                                 .build())
 *                         .relatedFindings(List.of(RelatedFindingProperty.builder()
 *                                 .id(id)
 *                                 .productArn("productArn")
 *                                 .build()))
 *                         .severity(SeverityUpdateProperty.builder()
 *                                 .label("label")
 *                                 .normalized(123)
 *                                 .product(123)
 *                                 .build())
 *                         .types(List.of("types"))
 *                         .userDefinedFields(Map.of(
 *                                 "userDefinedFieldsKey", "userDefinedFields"))
 *                         .verificationState("verificationState")
 *                         .workflow(WorkflowUpdateProperty.builder()
 *                                 .status("status")
 *                                 .build())
 *                         .build())
 *                 .type("type")
 *                 .build()))
 *         .criteria(AutomationRulesFindingFiltersProperty.builder()
 *                 .awsAccountId(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .companyName(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .complianceAssociatedStandardsId(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .complianceSecurityControlId(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .complianceStatus(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .confidence(List.of(NumberFilterProperty.builder()
 *                         .eq(123)
 *                         .gte(123)
 *                         .lte(123)
 *                         .build()))
 *                 .createdAt(List.of(DateFilterProperty.builder()
 *                         .dateRange(DateRangeProperty.builder()
 *                                 .unit("unit")
 *                                 .value(123)
 *                                 .build())
 *                         .end("end")
 *                         .start("start")
 *                         .build()))
 *                 .criticality(List.of(NumberFilterProperty.builder()
 *                         .eq(123)
 *                         .gte(123)
 *                         .lte(123)
 *                         .build()))
 *                 .description(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .firstObservedAt(List.of(DateFilterProperty.builder()
 *                         .dateRange(DateRangeProperty.builder()
 *                                 .unit("unit")
 *                                 .value(123)
 *                                 .build())
 *                         .end("end")
 *                         .start("start")
 *                         .build()))
 *                 .generatorId(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .id(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .lastObservedAt(List.of(DateFilterProperty.builder()
 *                         .dateRange(DateRangeProperty.builder()
 *                                 .unit("unit")
 *                                 .value(123)
 *                                 .build())
 *                         .end("end")
 *                         .start("start")
 *                         .build()))
 *                 .noteText(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .noteUpdatedAt(List.of(DateFilterProperty.builder()
 *                         .dateRange(DateRangeProperty.builder()
 *                                 .unit("unit")
 *                                 .value(123)
 *                                 .build())
 *                         .end("end")
 *                         .start("start")
 *                         .build()))
 *                 .noteUpdatedBy(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .productArn(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .productName(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .recordState(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .relatedFindingsId(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .relatedFindingsProductArn(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .resourceDetailsOther(List.of(MapFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .resourceId(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .resourcePartition(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .resourceRegion(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .resourceTags(List.of(MapFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .resourceType(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .severityLabel(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .sourceUrl(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .title(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .type(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .updatedAt(List.of(DateFilterProperty.builder()
 *                         .dateRange(DateRangeProperty.builder()
 *                                 .unit("unit")
 *                                 .value(123)
 *                                 .build())
 *                         .end("end")
 *                         .start("start")
 *                         .build()))
 *                 .userDefinedFields(List.of(MapFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .verificationState(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .workflowStatus(List.of(StringFilterProperty.builder()
 *                         .comparison("comparison")
 *                         .value("value")
 *                         .build()))
 *                 .build())
 *         .description("description")
 *         .ruleName("ruleName")
 *         .ruleOrder(123)
 *         // the properties below are optional
 *         .isTerminal(false)
 *         .ruleStatus("ruleStatus")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:25:05.386Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnAutomationRuleProps")
@software.amazon.jsii.Jsii.Proxy(CfnAutomationRuleProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAutomationRuleProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * One or more actions to update finding fields if a finding matches the conditions specified in <code>Criteria</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-actions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-actions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getActions();

    /**
     * A set of <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format.html">AWS Security Finding Format (ASFF)</a> finding field attributes and corresponding expected values that Security Hub uses to filter findings. If a rule is enabled and a finding matches the criteria specified in this parameter, Security Hub applies the rule action to the finding.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-criteria">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-criteria</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getCriteria();

    /**
     * A description of the rule.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDescription();

    /**
     * The name of the rule.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-rulename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-rulename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRuleName();

    /**
     * An integer ranging from 1 to 1000 that represents the order in which the rule action is applied to findings.
     * <p>
     * Security Hub applies rules with lower values for this parameter first.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-ruleorder">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-ruleorder</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getRuleOrder();

    /**
     * Specifies whether a rule is the last to be applied with respect to a finding that matches the rule criteria.
     * <p>
     * This is useful when a finding matches the criteria for multiple rules, and each rule has different actions. If a rule is terminal, Security Hub applies the rule action to a finding that matches the rule criteria and doesn't evaluate other rules for the finding. By default, a rule isn't terminal.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-isterminal">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-isterminal</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getIsTerminal() {
        return null;
    }

    /**
     * Whether the rule is active after it is created.
     * <p>
     * If this parameter is equal to <code>ENABLED</code> , Security Hub applies the rule to findings and finding updates after the rule is created.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-rulestatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-rulestatus</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRuleStatus() {
        return null;
    }

    /**
     * User-defined tags associated with an automation rule.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAutomationRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAutomationRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAutomationRuleProps> {
        java.lang.Object actions;
        java.lang.Object criteria;
        java.lang.String description;
        java.lang.String ruleName;
        java.lang.Number ruleOrder;
        java.lang.Object isTerminal;
        java.lang.String ruleStatus;
        java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Sets the value of {@link CfnAutomationRuleProps#getActions}
         * @param actions One or more actions to update finding fields if a finding matches the conditions specified in <code>Criteria</code> . This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actions(software.amazon.awscdk.IResolvable actions) {
            this.actions = actions;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutomationRuleProps#getActions}
         * @param actions One or more actions to update finding fields if a finding matches the conditions specified in <code>Criteria</code> . This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actions(java.util.List<? extends java.lang.Object> actions) {
            this.actions = actions;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutomationRuleProps#getCriteria}
         * @param criteria A set of <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format.html">AWS Security Finding Format (ASFF)</a> finding field attributes and corresponding expected values that Security Hub uses to filter findings. If a rule is enabled and a finding matches the criteria specified in this parameter, Security Hub applies the rule action to the finding. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder criteria(software.amazon.awscdk.IResolvable criteria) {
            this.criteria = criteria;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutomationRuleProps#getCriteria}
         * @param criteria A set of <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format.html">AWS Security Finding Format (ASFF)</a> finding field attributes and corresponding expected values that Security Hub uses to filter findings. If a rule is enabled and a finding matches the criteria specified in this parameter, Security Hub applies the rule action to the finding. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder criteria(software.amazon.awscdk.services.securityhub.CfnAutomationRule.AutomationRulesFindingFiltersProperty criteria) {
            this.criteria = criteria;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutomationRuleProps#getDescription}
         * @param description A description of the rule. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutomationRuleProps#getRuleName}
         * @param ruleName The name of the rule. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleName(java.lang.String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutomationRuleProps#getRuleOrder}
         * @param ruleOrder An integer ranging from 1 to 1000 that represents the order in which the rule action is applied to findings. This parameter is required.
         *                  Security Hub applies rules with lower values for this parameter first.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleOrder(java.lang.Number ruleOrder) {
            this.ruleOrder = ruleOrder;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutomationRuleProps#getIsTerminal}
         * @param isTerminal Specifies whether a rule is the last to be applied with respect to a finding that matches the rule criteria.
         *                   This is useful when a finding matches the criteria for multiple rules, and each rule has different actions. If a rule is terminal, Security Hub applies the rule action to a finding that matches the rule criteria and doesn't evaluate other rules for the finding. By default, a rule isn't terminal.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isTerminal(java.lang.Boolean isTerminal) {
            this.isTerminal = isTerminal;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutomationRuleProps#getIsTerminal}
         * @param isTerminal Specifies whether a rule is the last to be applied with respect to a finding that matches the rule criteria.
         *                   This is useful when a finding matches the criteria for multiple rules, and each rule has different actions. If a rule is terminal, Security Hub applies the rule action to a finding that matches the rule criteria and doesn't evaluate other rules for the finding. By default, a rule isn't terminal.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isTerminal(software.amazon.awscdk.IResolvable isTerminal) {
            this.isTerminal = isTerminal;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutomationRuleProps#getRuleStatus}
         * @param ruleStatus Whether the rule is active after it is created.
         *                   If this parameter is equal to <code>ENABLED</code> , Security Hub applies the rule to findings and finding updates after the rule is created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleStatus(java.lang.String ruleStatus) {
            this.ruleStatus = ruleStatus;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutomationRuleProps#getTags}
         * @param tags User-defined tags associated with an automation rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAutomationRuleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAutomationRuleProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAutomationRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAutomationRuleProps {
        private final java.lang.Object actions;
        private final java.lang.Object criteria;
        private final java.lang.String description;
        private final java.lang.String ruleName;
        private final java.lang.Number ruleOrder;
        private final java.lang.Object isTerminal;
        private final java.lang.String ruleStatus;
        private final java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.actions = software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.criteria = software.amazon.jsii.Kernel.get(this, "criteria", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ruleName = software.amazon.jsii.Kernel.get(this, "ruleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ruleOrder = software.amazon.jsii.Kernel.get(this, "ruleOrder", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.isTerminal = software.amazon.jsii.Kernel.get(this, "isTerminal", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.ruleStatus = software.amazon.jsii.Kernel.get(this, "ruleStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.actions = java.util.Objects.requireNonNull(builder.actions, "actions is required");
            this.criteria = java.util.Objects.requireNonNull(builder.criteria, "criteria is required");
            this.description = java.util.Objects.requireNonNull(builder.description, "description is required");
            this.ruleName = java.util.Objects.requireNonNull(builder.ruleName, "ruleName is required");
            this.ruleOrder = java.util.Objects.requireNonNull(builder.ruleOrder, "ruleOrder is required");
            this.isTerminal = builder.isTerminal;
            this.ruleStatus = builder.ruleStatus;
            this.tags = builder.tags;
        }

        @Override
        public final java.lang.Object getActions() {
            return this.actions;
        }

        @Override
        public final java.lang.Object getCriteria() {
            return this.criteria;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getRuleName() {
            return this.ruleName;
        }

        @Override
        public final java.lang.Number getRuleOrder() {
            return this.ruleOrder;
        }

        @Override
        public final java.lang.Object getIsTerminal() {
            return this.isTerminal;
        }

        @Override
        public final java.lang.String getRuleStatus() {
            return this.ruleStatus;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("actions", om.valueToTree(this.getActions()));
            data.set("criteria", om.valueToTree(this.getCriteria()));
            data.set("description", om.valueToTree(this.getDescription()));
            data.set("ruleName", om.valueToTree(this.getRuleName()));
            data.set("ruleOrder", om.valueToTree(this.getRuleOrder()));
            if (this.getIsTerminal() != null) {
                data.set("isTerminal", om.valueToTree(this.getIsTerminal()));
            }
            if (this.getRuleStatus() != null) {
                data.set("ruleStatus", om.valueToTree(this.getRuleStatus()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnAutomationRuleProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAutomationRuleProps.Jsii$Proxy that = (CfnAutomationRuleProps.Jsii$Proxy) o;

            if (!actions.equals(that.actions)) return false;
            if (!criteria.equals(that.criteria)) return false;
            if (!description.equals(that.description)) return false;
            if (!ruleName.equals(that.ruleName)) return false;
            if (!ruleOrder.equals(that.ruleOrder)) return false;
            if (this.isTerminal != null ? !this.isTerminal.equals(that.isTerminal) : that.isTerminal != null) return false;
            if (this.ruleStatus != null ? !this.ruleStatus.equals(that.ruleStatus) : that.ruleStatus != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.actions.hashCode();
            result = 31 * result + (this.criteria.hashCode());
            result = 31 * result + (this.description.hashCode());
            result = 31 * result + (this.ruleName.hashCode());
            result = 31 * result + (this.ruleOrder.hashCode());
            result = 31 * result + (this.isTerminal != null ? this.isTerminal.hashCode() : 0);
            result = 31 * result + (this.ruleStatus != null ? this.ruleStatus.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
