package software.amazon.awscdk.services.ses;

/**
 * The identity to use for DKIM.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IPublicHostedZone myHostedZone;
 * EmailIdentity.Builder.create(this, "Identity")
 *         .identity(Identity.publicHostedZone(myHostedZone))
 *         .dkimIdentity(DkimIdentity.byoDkim(ByoDkimOptions.builder()
 *                 .privateKey(SecretValue.secretsManager("dkim-private-key"))
 *                 .publicKey("...base64-encoded-public-key...")
 *                 .selector("selector")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:25:05.693Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.DkimIdentity")
public abstract class DkimIdentity extends software.amazon.jsii.JsiiObject {

    protected DkimIdentity(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DkimIdentity(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected DkimIdentity() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Bring Your Own DKIM.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/ses/latest/dg/send-email-authentication-dkim-bring-your-own.html">https://docs.aws.amazon.com/ses/latest/dg/send-email-authentication-dkim-bring-your-own.html</a>
     * @param options Options for BYO DKIM. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.DkimIdentity byoDkim(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.ByoDkimOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ses.DkimIdentity.class, "byoDkim", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.DkimIdentity.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Easy DKIM.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/ses/latest/dg/send-email-authentication-dkim-easy.html">https://docs.aws.amazon.com/ses/latest/dg/send-email-authentication-dkim-easy.html</a>
     * @param signingKeyLength The length of the signing key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.DkimIdentity easyDkim(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ses.EasyDkimSigningKeyLength signingKeyLength) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ses.DkimIdentity.class, "easyDkim", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.DkimIdentity.class), new Object[] { signingKeyLength });
    }

    /**
     * Easy DKIM.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/ses/latest/dg/send-email-authentication-dkim-easy.html">https://docs.aws.amazon.com/ses/latest/dg/send-email-authentication-dkim-easy.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.DkimIdentity easyDkim() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ses.DkimIdentity.class, "easyDkim", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.DkimIdentity.class));
    }

    /**
     * Binds this DKIM identity to the email identity.
     * <p>
     * @param emailIdentity This parameter is required.
     * @param hostedZone
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ses.DkimIdentityConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.EmailIdentity emailIdentity, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.route53.IPublicHostedZone hostedZone);

    /**
     * Binds this DKIM identity to the email identity.
     * <p>
     * @param emailIdentity This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ses.DkimIdentityConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.EmailIdentity emailIdentity);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.ses.DkimIdentity {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Binds this DKIM identity to the email identity.
         * <p>
         * @param emailIdentity This parameter is required.
         * @param hostedZone
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ses.DkimIdentityConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.EmailIdentity emailIdentity, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.route53.IPublicHostedZone hostedZone) {
            return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.DkimIdentityConfig.class), new Object[] { java.util.Objects.requireNonNull(emailIdentity, "emailIdentity is required"), hostedZone });
        }

        /**
         * Binds this DKIM identity to the email identity.
         * <p>
         * @param emailIdentity This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ses.DkimIdentityConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ses.EmailIdentity emailIdentity) {
            return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ses.DkimIdentityConfig.class), new Object[] { java.util.Objects.requireNonNull(emailIdentity, "emailIdentity is required") });
        }
    }
}
