package software.amazon.awscdk.services.sns;

/**
 * The throughput quota and deduplication behavior to apply for the FIFO topic.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Topic topic = Topic.Builder.create(this, "MyTopic")
 *         .fifo(true)
 *         .fifoThroughputScope(FifoThroughputScope.TOPIC)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:25:05.772Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sns.FifoThroughputScope")
public enum FifoThroughputScope {
    /**
     * Topic scope - Throughput: 3000 messages per second and a bandwidth of 20MB per second.
     * <p>
     * <ul>
     * <li>Deduplication: Message deduplication is verified on the entire FIFO topic.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TOPIC,
    /**
     * Message group scope - Throughput: Maximum regional limits.
     * <p>
     * <ul>
     * <li>Deduplication: Message deduplication is only verified within a message group.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MESSAGE_GROUP,
}
