package software.amazon.awscdk.services.sso;

/**
 * Properties for defining a <code>CfnPermissionSet</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sso.*;
 * Object inlinePolicy;
 * CfnPermissionSetProps cfnPermissionSetProps = CfnPermissionSetProps.builder()
 *         .instanceArn("instanceArn")
 *         .name("name")
 *         // the properties below are optional
 *         .customerManagedPolicyReferences(List.of(CustomerManagedPolicyReferenceProperty.builder()
 *                 .name("name")
 *                 // the properties below are optional
 *                 .path("path")
 *                 .build()))
 *         .description("description")
 *         .inlinePolicy(inlinePolicy)
 *         .managedPolicies(List.of("managedPolicies"))
 *         .permissionsBoundary(PermissionsBoundaryProperty.builder()
 *                 .customerManagedPolicyReference(CustomerManagedPolicyReferenceProperty.builder()
 *                         .name("name")
 *                         // the properties below are optional
 *                         .path("path")
 *                         .build())
 *                 .managedPolicyArn("managedPolicyArn")
 *                 .build())
 *         .relayStateType("relayStateType")
 *         .sessionDuration("sessionDuration")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sso-permissionset.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sso-permissionset.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:25:05.971Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sso.CfnPermissionSetProps")
@software.amazon.jsii.Jsii.Proxy(CfnPermissionSetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnPermissionSetProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ARN of the IAM Identity Center instance under which the operation will be executed.
     * <p>
     * For more information about ARNs, see <a href="https://docs.aws.amazon.com//general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a> in the <em>AWS General Reference</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sso-permissionset.html#cfn-sso-permissionset-instancearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sso-permissionset.html#cfn-sso-permissionset-instancearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInstanceArn();

    /**
     * The name of the permission set.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sso-permissionset.html#cfn-sso-permissionset-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sso-permissionset.html#cfn-sso-permissionset-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * Specifies the names and paths of the customer managed policies that you have attached to your permission set.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sso-permissionset.html#cfn-sso-permissionset-customermanagedpolicyreferences">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sso-permissionset.html#cfn-sso-permissionset-customermanagedpolicyreferences</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCustomerManagedPolicyReferences() {
        return null;
    }

    /**
     * The description of the <code>PermissionSet</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sso-permissionset.html#cfn-sso-permissionset-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sso-permissionset.html#cfn-sso-permissionset-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The inline policy that is attached to the permission set.
     * <p>
     * <blockquote>
     * <p>
     * For <code>Length Constraints</code> , if a valid ARN is provided for a permission set, it is possible for an empty inline policy to be returned.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sso-permissionset.html#cfn-sso-permissionset-inlinepolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sso-permissionset.html#cfn-sso-permissionset-inlinepolicy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getInlinePolicy() {
        return null;
    }

    /**
     * A structure that stores a list of managed policy ARNs that describe the associated AWS managed policy.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sso-permissionset.html#cfn-sso-permissionset-managedpolicies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sso-permissionset.html#cfn-sso-permissionset-managedpolicies</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getManagedPolicies() {
        return null;
    }

    /**
     * Specifies the configuration of the AWS managed or customer managed policy that you want to set as a permissions boundary.
     * <p>
     * Specify either <code>CustomerManagedPolicyReference</code> to use the name and path of a customer managed policy, or <code>ManagedPolicyArn</code> to use the ARN of an AWS managed policy. A permissions boundary represents the maximum permissions that any policy can grant your role. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM entities</a> in the <em>IAM User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * Policies used as permissions boundaries don't provide permissions. You must also attach an IAM policy to the role. To learn how the effective permissions for a role are evaluated, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html">IAM JSON policy evaluation logic</a> in the <em>IAM User Guide</em> .
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sso-permissionset.html#cfn-sso-permissionset-permissionsboundary">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sso-permissionset.html#cfn-sso-permissionset-permissionsboundary</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPermissionsBoundary() {
        return null;
    }

    /**
     * Used to redirect users within the application during the federation authentication process.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sso-permissionset.html#cfn-sso-permissionset-relaystatetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sso-permissionset.html#cfn-sso-permissionset-relaystatetype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRelayStateType() {
        return null;
    }

    /**
     * The length of time that the application user sessions are valid for in the ISO-8601 standard.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sso-permissionset.html#cfn-sso-permissionset-sessionduration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sso-permissionset.html#cfn-sso-permissionset-sessionduration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSessionDuration() {
        return null;
    }

    /**
     * The tags to attach to the new <code>PermissionSet</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sso-permissionset.html#cfn-sso-permissionset-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sso-permissionset.html#cfn-sso-permissionset-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnPermissionSetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnPermissionSetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnPermissionSetProps> {
        java.lang.String instanceArn;
        java.lang.String name;
        java.lang.Object customerManagedPolicyReferences;
        java.lang.String description;
        java.lang.Object inlinePolicy;
        java.util.List<java.lang.String> managedPolicies;
        java.lang.Object permissionsBoundary;
        java.lang.String relayStateType;
        java.lang.String sessionDuration;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnPermissionSetProps#getInstanceArn}
         * @param instanceArn The ARN of the IAM Identity Center instance under which the operation will be executed. This parameter is required.
         *                    For more information about ARNs, see <a href="https://docs.aws.amazon.com//general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and AWS Service Namespaces</a> in the <em>AWS General Reference</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceArn(java.lang.String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnPermissionSetProps#getName}
         * @param name The name of the permission set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnPermissionSetProps#getCustomerManagedPolicyReferences}
         * @param customerManagedPolicyReferences Specifies the names and paths of the customer managed policies that you have attached to your permission set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customerManagedPolicyReferences(software.amazon.awscdk.IResolvable customerManagedPolicyReferences) {
            this.customerManagedPolicyReferences = customerManagedPolicyReferences;
            return this;
        }

        /**
         * Sets the value of {@link CfnPermissionSetProps#getCustomerManagedPolicyReferences}
         * @param customerManagedPolicyReferences Specifies the names and paths of the customer managed policies that you have attached to your permission set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customerManagedPolicyReferences(java.util.List<? extends java.lang.Object> customerManagedPolicyReferences) {
            this.customerManagedPolicyReferences = customerManagedPolicyReferences;
            return this;
        }

        /**
         * Sets the value of {@link CfnPermissionSetProps#getDescription}
         * @param description The description of the <code>PermissionSet</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnPermissionSetProps#getInlinePolicy}
         * @param inlinePolicy The inline policy that is attached to the permission set.
         *                     <blockquote>
         *                     <p>
         *                     For <code>Length Constraints</code> , if a valid ARN is provided for a permission set, it is possible for an empty inline policy to be returned.
         *                     <p>
         *                     </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inlinePolicy(java.lang.Object inlinePolicy) {
            this.inlinePolicy = inlinePolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnPermissionSetProps#getManagedPolicies}
         * @param managedPolicies A structure that stores a list of managed policy ARNs that describe the associated AWS managed policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder managedPolicies(java.util.List<java.lang.String> managedPolicies) {
            this.managedPolicies = managedPolicies;
            return this;
        }

        /**
         * Sets the value of {@link CfnPermissionSetProps#getPermissionsBoundary}
         * @param permissionsBoundary Specifies the configuration of the AWS managed or customer managed policy that you want to set as a permissions boundary.
         *                            Specify either <code>CustomerManagedPolicyReference</code> to use the name and path of a customer managed policy, or <code>ManagedPolicyArn</code> to use the ARN of an AWS managed policy. A permissions boundary represents the maximum permissions that any policy can grant your role. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM entities</a> in the <em>IAM User Guide</em> .
         *                            <p>
         *                            <blockquote>
         *                            <p>
         *                            Policies used as permissions boundaries don't provide permissions. You must also attach an IAM policy to the role. To learn how the effective permissions for a role are evaluated, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html">IAM JSON policy evaluation logic</a> in the <em>IAM User Guide</em> .
         *                            <p>
         *                            </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissionsBoundary(software.amazon.awscdk.IResolvable permissionsBoundary) {
            this.permissionsBoundary = permissionsBoundary;
            return this;
        }

        /**
         * Sets the value of {@link CfnPermissionSetProps#getPermissionsBoundary}
         * @param permissionsBoundary Specifies the configuration of the AWS managed or customer managed policy that you want to set as a permissions boundary.
         *                            Specify either <code>CustomerManagedPolicyReference</code> to use the name and path of a customer managed policy, or <code>ManagedPolicyArn</code> to use the ARN of an AWS managed policy. A permissions boundary represents the maximum permissions that any policy can grant your role. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions boundaries for IAM entities</a> in the <em>IAM User Guide</em> .
         *                            <p>
         *                            <blockquote>
         *                            <p>
         *                            Policies used as permissions boundaries don't provide permissions. You must also attach an IAM policy to the role. To learn how the effective permissions for a role are evaluated, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html">IAM JSON policy evaluation logic</a> in the <em>IAM User Guide</em> .
         *                            <p>
         *                            </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissionsBoundary(software.amazon.awscdk.services.sso.CfnPermissionSet.PermissionsBoundaryProperty permissionsBoundary) {
            this.permissionsBoundary = permissionsBoundary;
            return this;
        }

        /**
         * Sets the value of {@link CfnPermissionSetProps#getRelayStateType}
         * @param relayStateType Used to redirect users within the application during the federation authentication process.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder relayStateType(java.lang.String relayStateType) {
            this.relayStateType = relayStateType;
            return this;
        }

        /**
         * Sets the value of {@link CfnPermissionSetProps#getSessionDuration}
         * @param sessionDuration The length of time that the application user sessions are valid for in the ISO-8601 standard.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sessionDuration(java.lang.String sessionDuration) {
            this.sessionDuration = sessionDuration;
            return this;
        }

        /**
         * Sets the value of {@link CfnPermissionSetProps#getTags}
         * @param tags The tags to attach to the new <code>PermissionSet</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnPermissionSetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnPermissionSetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnPermissionSetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnPermissionSetProps {
        private final java.lang.String instanceArn;
        private final java.lang.String name;
        private final java.lang.Object customerManagedPolicyReferences;
        private final java.lang.String description;
        private final java.lang.Object inlinePolicy;
        private final java.util.List<java.lang.String> managedPolicies;
        private final java.lang.Object permissionsBoundary;
        private final java.lang.String relayStateType;
        private final java.lang.String sessionDuration;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.instanceArn = software.amazon.jsii.Kernel.get(this, "instanceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.customerManagedPolicyReferences = software.amazon.jsii.Kernel.get(this, "customerManagedPolicyReferences", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.inlinePolicy = software.amazon.jsii.Kernel.get(this, "inlinePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.managedPolicies = software.amazon.jsii.Kernel.get(this, "managedPolicies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.permissionsBoundary = software.amazon.jsii.Kernel.get(this, "permissionsBoundary", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.relayStateType = software.amazon.jsii.Kernel.get(this, "relayStateType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sessionDuration = software.amazon.jsii.Kernel.get(this, "sessionDuration", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.instanceArn = java.util.Objects.requireNonNull(builder.instanceArn, "instanceArn is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.customerManagedPolicyReferences = builder.customerManagedPolicyReferences;
            this.description = builder.description;
            this.inlinePolicy = builder.inlinePolicy;
            this.managedPolicies = builder.managedPolicies;
            this.permissionsBoundary = builder.permissionsBoundary;
            this.relayStateType = builder.relayStateType;
            this.sessionDuration = builder.sessionDuration;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getInstanceArn() {
            return this.instanceArn;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getCustomerManagedPolicyReferences() {
            return this.customerManagedPolicyReferences;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getInlinePolicy() {
            return this.inlinePolicy;
        }

        @Override
        public final java.util.List<java.lang.String> getManagedPolicies() {
            return this.managedPolicies;
        }

        @Override
        public final java.lang.Object getPermissionsBoundary() {
            return this.permissionsBoundary;
        }

        @Override
        public final java.lang.String getRelayStateType() {
            return this.relayStateType;
        }

        @Override
        public final java.lang.String getSessionDuration() {
            return this.sessionDuration;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("instanceArn", om.valueToTree(this.getInstanceArn()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getCustomerManagedPolicyReferences() != null) {
                data.set("customerManagedPolicyReferences", om.valueToTree(this.getCustomerManagedPolicyReferences()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getInlinePolicy() != null) {
                data.set("inlinePolicy", om.valueToTree(this.getInlinePolicy()));
            }
            if (this.getManagedPolicies() != null) {
                data.set("managedPolicies", om.valueToTree(this.getManagedPolicies()));
            }
            if (this.getPermissionsBoundary() != null) {
                data.set("permissionsBoundary", om.valueToTree(this.getPermissionsBoundary()));
            }
            if (this.getRelayStateType() != null) {
                data.set("relayStateType", om.valueToTree(this.getRelayStateType()));
            }
            if (this.getSessionDuration() != null) {
                data.set("sessionDuration", om.valueToTree(this.getSessionDuration()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sso.CfnPermissionSetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnPermissionSetProps.Jsii$Proxy that = (CfnPermissionSetProps.Jsii$Proxy) o;

            if (!instanceArn.equals(that.instanceArn)) return false;
            if (!name.equals(that.name)) return false;
            if (this.customerManagedPolicyReferences != null ? !this.customerManagedPolicyReferences.equals(that.customerManagedPolicyReferences) : that.customerManagedPolicyReferences != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.inlinePolicy != null ? !this.inlinePolicy.equals(that.inlinePolicy) : that.inlinePolicy != null) return false;
            if (this.managedPolicies != null ? !this.managedPolicies.equals(that.managedPolicies) : that.managedPolicies != null) return false;
            if (this.permissionsBoundary != null ? !this.permissionsBoundary.equals(that.permissionsBoundary) : that.permissionsBoundary != null) return false;
            if (this.relayStateType != null ? !this.relayStateType.equals(that.relayStateType) : that.relayStateType != null) return false;
            if (this.sessionDuration != null ? !this.sessionDuration.equals(that.sessionDuration) : that.sessionDuration != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.instanceArn.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.customerManagedPolicyReferences != null ? this.customerManagedPolicyReferences.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.inlinePolicy != null ? this.inlinePolicy.hashCode() : 0);
            result = 31 * result + (this.managedPolicies != null ? this.managedPolicies.hashCode() : 0);
            result = 31 * result + (this.permissionsBoundary != null ? this.permissionsBoundary.hashCode() : 0);
            result = 31 * result + (this.relayStateType != null ? this.relayStateType.hashCode() : 0);
            result = 31 * result + (this.sessionDuration != null ? this.sessionDuration.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
