package software.amazon.awscdk.services.stepfunctions;

/**
 * Options for Choice Transition.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.events.*;
 * Connection connection;
 * HttpInvoke getIssue = HttpInvoke.jsonata(this, "Get Issue", HttpInvokeJsonataProps.builder()
 *         .connection(connection)
 *         .apiRoot("{% 'https://' &amp; $states.input.hostname %}")
 *         .apiEndpoint(TaskInput.fromText("{% 'issues/' &amp; $states.input.issue.id %}"))
 *         .method(TaskInput.fromText("GET"))
 *         // Parse the API call result to object and set to the variables
 *         .assign(Map.of(
 *                 "hostname", "{% $states.input.hostname %}",
 *                 "issue", "{% $parse($states.result.ResponseBody) %}"))
 *         .build());
 * HttpInvoke updateLabels = HttpInvoke.jsonata(this, "Update Issue Labels", HttpInvokeJsonataProps.builder()
 *         .connection(connection)
 *         .apiRoot("{% 'https://' &amp; $states.input.hostname %}")
 *         .apiEndpoint(TaskInput.fromText("{% 'issues/' &amp; $states.input.issue.id &amp; 'labels' %}"))
 *         .method(TaskInput.fromText("POST"))
 *         .body(TaskInput.fromObject(Map.of(
 *                 "labels", "{% [$type, $component] %}")))
 *         .build());
 * Pass notMatchTitleTemplate = Pass.jsonata(this, "Not Match Title Template");
 * Chain definition = getIssue.next(Choice.jsonata(this, "Match Title Template?").when(Condition.jsonata("{% $contains($issue.title, /(feat)|(fix)|(chore)(w*):.*&#47;) %}"), updateLabels, ChoiceTransitionOptions.builder()
 *         .assign(Map.of(
 *                 "type", "{% $match($states.input.title, /(w*)((.*))/).groups[0] %}",
 *                 "component", "{% $match($states.input.title, /(w*)((.*))/).groups[1] %}"))
 *         .build()).otherwise(notMatchTitleTemplate));
 * StateMachine.Builder.create(this, "StateMachine")
 *         .definitionBody(DefinitionBody.fromChainable(definition))
 *         .timeout(Duration.minutes(5))
 *         .comment("automate issue labeling state machine")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:25:06.021Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.ChoiceTransitionOptions")
@software.amazon.jsii.Jsii.Proxy(ChoiceTransitionOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ChoiceTransitionOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.stepfunctions.AssignableStateOptions {

    /**
     * An optional description for the choice transition.
     * <p>
     * Default: No comment
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getComment() {
        return null;
    }

    /**
     * This option for JSONata only.
     * <p>
     * When you use JSONPath, then the state ignores this property.
     * Used to specify and transform output from the state.
     * When specified, the value overrides the state output default.
     * The output field accepts any JSON value (object, array, string, number, boolean, null).
     * Any string value, including those inside objects or arrays,
     * will be evaluated as JSONata if surrounded by {% %} characters.
     * Output also accepts a JSONata expression directly.
     * <p>
     * Default: - $states.result or $states.errorOutput
     * <p>
     * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-input-output-filtering.html">https://docs.aws.amazon.com/step-functions/latest/dg/concepts-input-output-filtering.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOutputs() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ChoiceTransitionOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ChoiceTransitionOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ChoiceTransitionOptions> {
        java.lang.String comment;
        java.lang.Object outputs;
        java.util.Map<java.lang.String, java.lang.Object> assign;

        /**
         * Sets the value of {@link ChoiceTransitionOptions#getComment}
         * @param comment An optional description for the choice transition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(java.lang.String comment) {
            this.comment = comment;
            return this;
        }

        /**
         * Sets the value of {@link ChoiceTransitionOptions#getOutputs}
         * @param outputs This option for JSONata only.
         *                When you use JSONPath, then the state ignores this property.
         *                Used to specify and transform output from the state.
         *                When specified, the value overrides the state output default.
         *                The output field accepts any JSON value (object, array, string, number, boolean, null).
         *                Any string value, including those inside objects or arrays,
         *                will be evaluated as JSONata if surrounded by {% %} characters.
         *                Output also accepts a JSONata expression directly.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputs(java.lang.Object outputs) {
            this.outputs = outputs;
            return this;
        }

        /**
         * Sets the value of {@link ChoiceTransitionOptions#getAssign}
         * @param assign Workflow variables to store in this step.
         *               Using workflow variables, you can store data in a step and retrieve that data in future steps.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder assign(java.util.Map<java.lang.String, ? extends java.lang.Object> assign) {
            this.assign = (java.util.Map<java.lang.String, java.lang.Object>)assign;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ChoiceTransitionOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ChoiceTransitionOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ChoiceTransitionOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ChoiceTransitionOptions {
        private final java.lang.String comment;
        private final java.lang.Object outputs;
        private final java.util.Map<java.lang.String, java.lang.Object> assign;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.outputs = software.amazon.jsii.Kernel.get(this, "outputs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.assign = software.amazon.jsii.Kernel.get(this, "assign", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.comment = builder.comment;
            this.outputs = builder.outputs;
            this.assign = (java.util.Map<java.lang.String, java.lang.Object>)builder.assign;
        }

        @Override
        public final java.lang.String getComment() {
            return this.comment;
        }

        @Override
        public final java.lang.Object getOutputs() {
            return this.outputs;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getAssign() {
            return this.assign;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getComment() != null) {
                data.set("comment", om.valueToTree(this.getComment()));
            }
            if (this.getOutputs() != null) {
                data.set("outputs", om.valueToTree(this.getOutputs()));
            }
            if (this.getAssign() != null) {
                data.set("assign", om.valueToTree(this.getAssign()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions.ChoiceTransitionOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ChoiceTransitionOptions.Jsii$Proxy that = (ChoiceTransitionOptions.Jsii$Proxy) o;

            if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
            if (this.outputs != null ? !this.outputs.equals(that.outputs) : that.outputs != null) return false;
            return this.assign != null ? this.assign.equals(that.assign) : that.assign == null;
        }

        @Override
        public final int hashCode() {
            int result = this.comment != null ? this.comment.hashCode() : 0;
            result = 31 * result + (this.outputs != null ? this.outputs.hashCode() : 0);
            result = 31 * result + (this.assign != null ? this.assign.hashCode() : 0);
            return result;
        }
    }
}
