package software.amazon.awscdk.services.stepfunctions;

/**
 * Partial object from the StateMachine L1 construct properties containing definition information.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.stepfunctions.*;
 * Object definition;
 * DefinitionConfig definitionConfig = DefinitionConfig.builder()
 *         .definition(definition)
 *         .definitionS3Location(S3LocationProperty.builder()
 *                 .bucket("bucket")
 *                 .key("key")
 *                 // the properties below are optional
 *                 .version("version")
 *                 .build())
 *         .definitionString("definitionString")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:25:06.026Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.DefinitionConfig")
@software.amazon.jsii.Jsii.Proxy(DefinitionConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DefinitionConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDefinition() {
        return null;
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.CfnStateMachine.S3LocationProperty getDefinitionS3Location() {
        return null;
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDefinitionString() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DefinitionConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DefinitionConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DefinitionConfig> {
        java.lang.Object definition;
        software.amazon.awscdk.services.stepfunctions.CfnStateMachine.S3LocationProperty definitionS3Location;
        java.lang.String definitionString;

        /**
         * Sets the value of {@link DefinitionConfig#getDefinition}
         * @param definition the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definition(java.lang.Object definition) {
            this.definition = definition;
            return this;
        }

        /**
         * Sets the value of {@link DefinitionConfig#getDefinitionS3Location}
         * @param definitionS3Location the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionS3Location(software.amazon.awscdk.services.stepfunctions.CfnStateMachine.S3LocationProperty definitionS3Location) {
            this.definitionS3Location = definitionS3Location;
            return this;
        }

        /**
         * Sets the value of {@link DefinitionConfig#getDefinitionString}
         * @param definitionString the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionString(java.lang.String definitionString) {
            this.definitionString = definitionString;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DefinitionConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DefinitionConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DefinitionConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DefinitionConfig {
        private final java.lang.Object definition;
        private final software.amazon.awscdk.services.stepfunctions.CfnStateMachine.S3LocationProperty definitionS3Location;
        private final java.lang.String definitionString;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.definition = software.amazon.jsii.Kernel.get(this, "definition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.definitionS3Location = software.amazon.jsii.Kernel.get(this, "definitionS3Location", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.CfnStateMachine.S3LocationProperty.class));
            this.definitionString = software.amazon.jsii.Kernel.get(this, "definitionString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.definition = builder.definition;
            this.definitionS3Location = builder.definitionS3Location;
            this.definitionString = builder.definitionString;
        }

        @Override
        public final java.lang.Object getDefinition() {
            return this.definition;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.CfnStateMachine.S3LocationProperty getDefinitionS3Location() {
            return this.definitionS3Location;
        }

        @Override
        public final java.lang.String getDefinitionString() {
            return this.definitionString;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDefinition() != null) {
                data.set("definition", om.valueToTree(this.getDefinition()));
            }
            if (this.getDefinitionS3Location() != null) {
                data.set("definitionS3Location", om.valueToTree(this.getDefinitionS3Location()));
            }
            if (this.getDefinitionString() != null) {
                data.set("definitionString", om.valueToTree(this.getDefinitionString()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions.DefinitionConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DefinitionConfig.Jsii$Proxy that = (DefinitionConfig.Jsii$Proxy) o;

            if (this.definition != null ? !this.definition.equals(that.definition) : that.definition != null) return false;
            if (this.definitionS3Location != null ? !this.definitionS3Location.equals(that.definitionS3Location) : that.definitionS3Location != null) return false;
            return this.definitionString != null ? this.definitionString.equals(that.definitionString) : that.definitionString == null;
        }

        @Override
        public final int hashCode() {
            int result = this.definition != null ? this.definition.hashCode() : 0;
            result = 31 * result + (this.definitionS3Location != null ? this.definitionS3Location.hashCode() : 0);
            result = 31 * result + (this.definitionString != null ? this.definitionString.hashCode() : 0);
            return result;
        }
    }
}
