package software.amazon.awscdk.services.stepfunctions;

/**
 * Mode of the Map workflow.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Map map = Map.Builder.create(this, "Map State")
 *         .maxConcurrency(1)
 *         .itemsPath(JsonPath.stringAt("$.inputForMap"))
 *         .itemSelector(Map.of(
 *                 "item", JsonPath.stringAt("$.Map.Item.Value")))
 *         .resultPath("$.mapOutput")
 *         .build();
 * map.itemProcessor(new Pass(this, "Pass State"), ProcessorConfig.builder()
 *         .mode(ProcessorMode.DISTRIBUTED)
 *         .executionType(ProcessorType.STANDARD)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:25:06.084Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.ProcessorMode")
public enum ProcessorMode {
    /**
     * Inline Map mode.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    INLINE,
    /**
     * Distributed Map mode.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DISTRIBUTED,
}
