package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Properties to define a ContainerDefinition.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * SageMakerCreateModel.Builder.create(this, "Sagemaker")
 *         .modelName("MyModel")
 *         .primaryContainer(ContainerDefinition.Builder.create()
 *                 .image(DockerImage.fromJsonExpression(JsonPath.stringAt("$.Model.imageName")))
 *                 .mode(Mode.SINGLE_MODEL)
 *                 .modelS3Location(S3Location.fromJsonExpression("$.TrainingJob.ModelArtifacts.S3ModelArtifacts"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ContainerDefinition.html">https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ContainerDefinition.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:25:06.248Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.ContainerDefinitionOptions")
@software.amazon.jsii.Jsii.Proxy(ContainerDefinitionOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ContainerDefinitionOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * This parameter is ignored for models that contain only a PrimaryContainer.
     * <p>
     * When a ContainerDefinition is part of an inference pipeline,
     * the value of the parameter uniquely identifies the container for the purposes of logging and metrics.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getContainerHostName() {
        return null;
    }

    /**
     * The environment variables to set in the Docker container.
     * <p>
     * Default: - No variables
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.TaskInput getEnvironmentVariables() {
        return null;
    }

    /**
     * The Amazon EC2 Container Registry (Amazon ECR) path where inference code is stored.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.DockerImage getImage() {
        return null;
    }

    /**
     * Defines how many models the container hosts.
     * <p>
     * Default: - Mode.SINGLE_MODEL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.Mode getMode() {
        return null;
    }

    /**
     * The name or Amazon Resource Name (ARN) of the model package to use to create the model.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getModelPackageName() {
        return null;
    }

    /**
     * The S3 path where the model artifacts, which result from model training, are stored.
     * <p>
     * This path must point to a single gzip compressed tar archive (.tar.gz suffix).
     * The S3 path is required for Amazon SageMaker built-in algorithms, but not if you use your own algorithms.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.S3Location getModelS3Location() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ContainerDefinitionOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ContainerDefinitionOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ContainerDefinitionOptions> {
        java.lang.String containerHostName;
        software.amazon.awscdk.services.stepfunctions.TaskInput environmentVariables;
        software.amazon.awscdk.services.stepfunctions.tasks.DockerImage image;
        software.amazon.awscdk.services.stepfunctions.tasks.Mode mode;
        java.lang.String modelPackageName;
        software.amazon.awscdk.services.stepfunctions.tasks.S3Location modelS3Location;

        /**
         * Sets the value of {@link ContainerDefinitionOptions#getContainerHostName}
         * @param containerHostName This parameter is ignored for models that contain only a PrimaryContainer.
         *                          When a ContainerDefinition is part of an inference pipeline,
         *                          the value of the parameter uniquely identifies the container for the purposes of logging and metrics.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerHostName(java.lang.String containerHostName) {
            this.containerHostName = containerHostName;
            return this;
        }

        /**
         * Sets the value of {@link ContainerDefinitionOptions#getEnvironmentVariables}
         * @param environmentVariables The environment variables to set in the Docker container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentVariables(software.amazon.awscdk.services.stepfunctions.TaskInput environmentVariables) {
            this.environmentVariables = environmentVariables;
            return this;
        }

        /**
         * Sets the value of {@link ContainerDefinitionOptions#getImage}
         * @param image The Amazon EC2 Container Registry (Amazon ECR) path where inference code is stored.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder image(software.amazon.awscdk.services.stepfunctions.tasks.DockerImage image) {
            this.image = image;
            return this;
        }

        /**
         * Sets the value of {@link ContainerDefinitionOptions#getMode}
         * @param mode Defines how many models the container hosts.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mode(software.amazon.awscdk.services.stepfunctions.tasks.Mode mode) {
            this.mode = mode;
            return this;
        }

        /**
         * Sets the value of {@link ContainerDefinitionOptions#getModelPackageName}
         * @param modelPackageName The name or Amazon Resource Name (ARN) of the model package to use to create the model.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelPackageName(java.lang.String modelPackageName) {
            this.modelPackageName = modelPackageName;
            return this;
        }

        /**
         * Sets the value of {@link ContainerDefinitionOptions#getModelS3Location}
         * @param modelS3Location The S3 path where the model artifacts, which result from model training, are stored.
         *                        This path must point to a single gzip compressed tar archive (.tar.gz suffix).
         *                        The S3 path is required for Amazon SageMaker built-in algorithms, but not if you use your own algorithms.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelS3Location(software.amazon.awscdk.services.stepfunctions.tasks.S3Location modelS3Location) {
            this.modelS3Location = modelS3Location;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ContainerDefinitionOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ContainerDefinitionOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ContainerDefinitionOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ContainerDefinitionOptions {
        private final java.lang.String containerHostName;
        private final software.amazon.awscdk.services.stepfunctions.TaskInput environmentVariables;
        private final software.amazon.awscdk.services.stepfunctions.tasks.DockerImage image;
        private final software.amazon.awscdk.services.stepfunctions.tasks.Mode mode;
        private final java.lang.String modelPackageName;
        private final software.amazon.awscdk.services.stepfunctions.tasks.S3Location modelS3Location;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.containerHostName = software.amazon.jsii.Kernel.get(this, "containerHostName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.environmentVariables = software.amazon.jsii.Kernel.get(this, "environmentVariables", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.TaskInput.class));
            this.image = software.amazon.jsii.Kernel.get(this, "image", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.DockerImage.class));
            this.mode = software.amazon.jsii.Kernel.get(this, "mode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.Mode.class));
            this.modelPackageName = software.amazon.jsii.Kernel.get(this, "modelPackageName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.modelS3Location = software.amazon.jsii.Kernel.get(this, "modelS3Location", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.S3Location.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.containerHostName = builder.containerHostName;
            this.environmentVariables = builder.environmentVariables;
            this.image = builder.image;
            this.mode = builder.mode;
            this.modelPackageName = builder.modelPackageName;
            this.modelS3Location = builder.modelS3Location;
        }

        @Override
        public final java.lang.String getContainerHostName() {
            return this.containerHostName;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.TaskInput getEnvironmentVariables() {
            return this.environmentVariables;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.DockerImage getImage() {
            return this.image;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.Mode getMode() {
            return this.mode;
        }

        @Override
        public final java.lang.String getModelPackageName() {
            return this.modelPackageName;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.S3Location getModelS3Location() {
            return this.modelS3Location;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getContainerHostName() != null) {
                data.set("containerHostName", om.valueToTree(this.getContainerHostName()));
            }
            if (this.getEnvironmentVariables() != null) {
                data.set("environmentVariables", om.valueToTree(this.getEnvironmentVariables()));
            }
            if (this.getImage() != null) {
                data.set("image", om.valueToTree(this.getImage()));
            }
            if (this.getMode() != null) {
                data.set("mode", om.valueToTree(this.getMode()));
            }
            if (this.getModelPackageName() != null) {
                data.set("modelPackageName", om.valueToTree(this.getModelPackageName()));
            }
            if (this.getModelS3Location() != null) {
                data.set("modelS3Location", om.valueToTree(this.getModelS3Location()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions_tasks.ContainerDefinitionOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ContainerDefinitionOptions.Jsii$Proxy that = (ContainerDefinitionOptions.Jsii$Proxy) o;

            if (this.containerHostName != null ? !this.containerHostName.equals(that.containerHostName) : that.containerHostName != null) return false;
            if (this.environmentVariables != null ? !this.environmentVariables.equals(that.environmentVariables) : that.environmentVariables != null) return false;
            if (this.image != null ? !this.image.equals(that.image) : that.image != null) return false;
            if (this.mode != null ? !this.mode.equals(that.mode) : that.mode != null) return false;
            if (this.modelPackageName != null ? !this.modelPackageName.equals(that.modelPackageName) : that.modelPackageName != null) return false;
            return this.modelS3Location != null ? this.modelS3Location.equals(that.modelS3Location) : that.modelS3Location == null;
        }

        @Override
        public final int hashCode() {
            int result = this.containerHostName != null ? this.containerHostName.hashCode() : 0;
            result = 31 * result + (this.environmentVariables != null ? this.environmentVariables.hashCode() : 0);
            result = 31 * result + (this.image != null ? this.image.hashCode() : 0);
            result = 31 * result + (this.mode != null ? this.mode.hashCode() : 0);
            result = 31 * result + (this.modelPackageName != null ? this.modelPackageName.hashCode() : 0);
            result = 31 * result + (this.modelS3Location != null ? this.modelS3Location.hashCode() : 0);
            return result;
        }
    }
}
