package software.amazon.awscdk.services.wafv2;

/**
 * Properties for defining a <code>CfnRuleGroup</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.wafv2.*;
 * Object all;
 * Object allow;
 * Object allQueryArguments;
 * Object block;
 * Object captcha;
 * Object challenge;
 * Object count;
 * Object forwardedIp;
 * Object httpMethod;
 * Object ip;
 * Object method;
 * Object queryString;
 * Object singleHeader;
 * Object singleQueryArgument;
 * StatementProperty statementProperty_;
 * Object uriPath;
 * CfnRuleGroupProps cfnRuleGroupProps = CfnRuleGroupProps.builder()
 *         .capacity(123)
 *         .scope("scope")
 *         .visibilityConfig(VisibilityConfigProperty.builder()
 *                 .cloudWatchMetricsEnabled(false)
 *                 .metricName("metricName")
 *                 .sampledRequestsEnabled(false)
 *                 .build())
 *         // the properties below are optional
 *         .availableLabels(List.of(LabelSummaryProperty.builder()
 *                 .name("name")
 *                 .build()))
 *         .consumedLabels(List.of(LabelSummaryProperty.builder()
 *                 .name("name")
 *                 .build()))
 *         .customResponseBodies(Map.of(
 *                 "customResponseBodiesKey", CustomResponseBodyProperty.builder()
 *                         .content("content")
 *                         .contentType("contentType")
 *                         .build()))
 *         .description("description")
 *         .name("name")
 *         .rules(List.of(RuleProperty.builder()
 *                 .name("name")
 *                 .priority(123)
 *                 .statement(StatementProperty.builder()
 *                         .andStatement(AndStatementProperty.builder()
 *                                 .statements(List.of(statementProperty_))
 *                                 .build())
 *                         .byteMatchStatement(ByteMatchStatementProperty.builder()
 *                                 .fieldToMatch(FieldToMatchProperty.builder()
 *                                         .allQueryArguments(allQueryArguments)
 *                                         .body(BodyProperty.builder()
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .cookies(CookiesProperty.builder()
 *                                                 .matchPattern(CookieMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .excludedCookies(List.of("excludedCookies"))
 *                                                         .includedCookies(List.of("includedCookies"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .headers(HeadersProperty.builder()
 *                                                 .matchPattern(HeaderMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .excludedHeaders(List.of("excludedHeaders"))
 *                                                         .includedHeaders(List.of("includedHeaders"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .ja3Fingerprint(JA3FingerprintProperty.builder()
 *                                                 .fallbackBehavior("fallbackBehavior")
 *                                                 .build())
 *                                         .ja4Fingerprint(JA4FingerprintProperty.builder()
 *                                                 .fallbackBehavior("fallbackBehavior")
 *                                                 .build())
 *                                         .jsonBody(JsonBodyProperty.builder()
 *                                                 .matchPattern(JsonMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .includedPaths(List.of("includedPaths"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 // the properties below are optional
 *                                                 .invalidFallbackBehavior("invalidFallbackBehavior")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .method(method)
 *                                         .queryString(queryString)
 *                                         .singleHeader(singleHeader)
 *                                         .singleQueryArgument(singleQueryArgument)
 *                                         .uriPath(uriPath)
 *                                         .build())
 *                                 .positionalConstraint("positionalConstraint")
 *                                 .textTransformations(List.of(TextTransformationProperty.builder()
 *                                         .priority(123)
 *                                         .type("type")
 *                                         .build()))
 *                                 // the properties below are optional
 *                                 .searchString("searchString")
 *                                 .searchStringBase64("searchStringBase64")
 *                                 .build())
 *                         .geoMatchStatement(GeoMatchStatementProperty.builder()
 *                                 .countryCodes(List.of("countryCodes"))
 *                                 .forwardedIpConfig(ForwardedIPConfigurationProperty.builder()
 *                                         .fallbackBehavior("fallbackBehavior")
 *                                         .headerName("headerName")
 *                                         .build())
 *                                 .build())
 *                         .ipSetReferenceStatement(Map.of(
 *                                 "arn", "arn",
 *                                 // the properties below are optional
 *                                 "ipSetForwardedIpConfig", Map.of(
 *                                         "fallbackBehavior", "fallbackBehavior",
 *                                         "headerName", "headerName",
 *                                         "position", "position")))
 *                         .labelMatchStatement(LabelMatchStatementProperty.builder()
 *                                 .key("key")
 *                                 .scope("scope")
 *                                 .build())
 *                         .notStatement(NotStatementProperty.builder()
 *                                 .statement(statementProperty_)
 *                                 .build())
 *                         .orStatement(OrStatementProperty.builder()
 *                                 .statements(List.of(statementProperty_))
 *                                 .build())
 *                         .rateBasedStatement(RateBasedStatementProperty.builder()
 *                                 .aggregateKeyType("aggregateKeyType")
 *                                 .limit(123)
 *                                 // the properties below are optional
 *                                 .customKeys(List.of(RateBasedStatementCustomKeyProperty.builder()
 *                                         .cookie(RateLimitCookieProperty.builder()
 *                                                 .name("name")
 *                                                 .textTransformations(List.of(TextTransformationProperty.builder()
 *                                                         .priority(123)
 *                                                         .type("type")
 *                                                         .build()))
 *                                                 .build())
 *                                         .forwardedIp(forwardedIp)
 *                                         .header(RateLimitHeaderProperty.builder()
 *                                                 .name("name")
 *                                                 .textTransformations(List.of(TextTransformationProperty.builder()
 *                                                         .priority(123)
 *                                                         .type("type")
 *                                                         .build()))
 *                                                 .build())
 *                                         .httpMethod(httpMethod)
 *                                         .ip(ip)
 *                                         .ja3Fingerprint(RateLimitJA3FingerprintProperty.builder()
 *                                                 .fallbackBehavior("fallbackBehavior")
 *                                                 .build())
 *                                         .ja4Fingerprint(RateLimitJA4FingerprintProperty.builder()
 *                                                 .fallbackBehavior("fallbackBehavior")
 *                                                 .build())
 *                                         .labelNamespace(RateLimitLabelNamespaceProperty.builder()
 *                                                 .namespace("namespace")
 *                                                 .build())
 *                                         .queryArgument(RateLimitQueryArgumentProperty.builder()
 *                                                 .name("name")
 *                                                 .textTransformations(List.of(TextTransformationProperty.builder()
 *                                                         .priority(123)
 *                                                         .type("type")
 *                                                         .build()))
 *                                                 .build())
 *                                         .queryString(RateLimitQueryStringProperty.builder()
 *                                                 .textTransformations(List.of(TextTransformationProperty.builder()
 *                                                         .priority(123)
 *                                                         .type("type")
 *                                                         .build()))
 *                                                 .build())
 *                                         .uriPath(RateLimitUriPathProperty.builder()
 *                                                 .textTransformations(List.of(TextTransformationProperty.builder()
 *                                                         .priority(123)
 *                                                         .type("type")
 *                                                         .build()))
 *                                                 .build())
 *                                         .build()))
 *                                 .evaluationWindowSec(123)
 *                                 .forwardedIpConfig(ForwardedIPConfigurationProperty.builder()
 *                                         .fallbackBehavior("fallbackBehavior")
 *                                         .headerName("headerName")
 *                                         .build())
 *                                 .scopeDownStatement(statementProperty_)
 *                                 .build())
 *                         .regexMatchStatement(RegexMatchStatementProperty.builder()
 *                                 .fieldToMatch(FieldToMatchProperty.builder()
 *                                         .allQueryArguments(allQueryArguments)
 *                                         .body(BodyProperty.builder()
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .cookies(CookiesProperty.builder()
 *                                                 .matchPattern(CookieMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .excludedCookies(List.of("excludedCookies"))
 *                                                         .includedCookies(List.of("includedCookies"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .headers(HeadersProperty.builder()
 *                                                 .matchPattern(HeaderMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .excludedHeaders(List.of("excludedHeaders"))
 *                                                         .includedHeaders(List.of("includedHeaders"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .ja3Fingerprint(JA3FingerprintProperty.builder()
 *                                                 .fallbackBehavior("fallbackBehavior")
 *                                                 .build())
 *                                         .ja4Fingerprint(JA4FingerprintProperty.builder()
 *                                                 .fallbackBehavior("fallbackBehavior")
 *                                                 .build())
 *                                         .jsonBody(JsonBodyProperty.builder()
 *                                                 .matchPattern(JsonMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .includedPaths(List.of("includedPaths"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 // the properties below are optional
 *                                                 .invalidFallbackBehavior("invalidFallbackBehavior")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .method(method)
 *                                         .queryString(queryString)
 *                                         .singleHeader(singleHeader)
 *                                         .singleQueryArgument(singleQueryArgument)
 *                                         .uriPath(uriPath)
 *                                         .build())
 *                                 .regexString("regexString")
 *                                 .textTransformations(List.of(TextTransformationProperty.builder()
 *                                         .priority(123)
 *                                         .type("type")
 *                                         .build()))
 *                                 .build())
 *                         .regexPatternSetReferenceStatement(RegexPatternSetReferenceStatementProperty.builder()
 *                                 .arn("arn")
 *                                 .fieldToMatch(FieldToMatchProperty.builder()
 *                                         .allQueryArguments(allQueryArguments)
 *                                         .body(BodyProperty.builder()
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .cookies(CookiesProperty.builder()
 *                                                 .matchPattern(CookieMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .excludedCookies(List.of("excludedCookies"))
 *                                                         .includedCookies(List.of("includedCookies"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .headers(HeadersProperty.builder()
 *                                                 .matchPattern(HeaderMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .excludedHeaders(List.of("excludedHeaders"))
 *                                                         .includedHeaders(List.of("includedHeaders"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .ja3Fingerprint(JA3FingerprintProperty.builder()
 *                                                 .fallbackBehavior("fallbackBehavior")
 *                                                 .build())
 *                                         .ja4Fingerprint(JA4FingerprintProperty.builder()
 *                                                 .fallbackBehavior("fallbackBehavior")
 *                                                 .build())
 *                                         .jsonBody(JsonBodyProperty.builder()
 *                                                 .matchPattern(JsonMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .includedPaths(List.of("includedPaths"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 // the properties below are optional
 *                                                 .invalidFallbackBehavior("invalidFallbackBehavior")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .method(method)
 *                                         .queryString(queryString)
 *                                         .singleHeader(singleHeader)
 *                                         .singleQueryArgument(singleQueryArgument)
 *                                         .uriPath(uriPath)
 *                                         .build())
 *                                 .textTransformations(List.of(TextTransformationProperty.builder()
 *                                         .priority(123)
 *                                         .type("type")
 *                                         .build()))
 *                                 .build())
 *                         .sizeConstraintStatement(SizeConstraintStatementProperty.builder()
 *                                 .comparisonOperator("comparisonOperator")
 *                                 .fieldToMatch(FieldToMatchProperty.builder()
 *                                         .allQueryArguments(allQueryArguments)
 *                                         .body(BodyProperty.builder()
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .cookies(CookiesProperty.builder()
 *                                                 .matchPattern(CookieMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .excludedCookies(List.of("excludedCookies"))
 *                                                         .includedCookies(List.of("includedCookies"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .headers(HeadersProperty.builder()
 *                                                 .matchPattern(HeaderMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .excludedHeaders(List.of("excludedHeaders"))
 *                                                         .includedHeaders(List.of("includedHeaders"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .ja3Fingerprint(JA3FingerprintProperty.builder()
 *                                                 .fallbackBehavior("fallbackBehavior")
 *                                                 .build())
 *                                         .ja4Fingerprint(JA4FingerprintProperty.builder()
 *                                                 .fallbackBehavior("fallbackBehavior")
 *                                                 .build())
 *                                         .jsonBody(JsonBodyProperty.builder()
 *                                                 .matchPattern(JsonMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .includedPaths(List.of("includedPaths"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 // the properties below are optional
 *                                                 .invalidFallbackBehavior("invalidFallbackBehavior")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .method(method)
 *                                         .queryString(queryString)
 *                                         .singleHeader(singleHeader)
 *                                         .singleQueryArgument(singleQueryArgument)
 *                                         .uriPath(uriPath)
 *                                         .build())
 *                                 .size(123)
 *                                 .textTransformations(List.of(TextTransformationProperty.builder()
 *                                         .priority(123)
 *                                         .type("type")
 *                                         .build()))
 *                                 .build())
 *                         .sqliMatchStatement(SqliMatchStatementProperty.builder()
 *                                 .fieldToMatch(FieldToMatchProperty.builder()
 *                                         .allQueryArguments(allQueryArguments)
 *                                         .body(BodyProperty.builder()
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .cookies(CookiesProperty.builder()
 *                                                 .matchPattern(CookieMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .excludedCookies(List.of("excludedCookies"))
 *                                                         .includedCookies(List.of("includedCookies"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .headers(HeadersProperty.builder()
 *                                                 .matchPattern(HeaderMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .excludedHeaders(List.of("excludedHeaders"))
 *                                                         .includedHeaders(List.of("includedHeaders"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .ja3Fingerprint(JA3FingerprintProperty.builder()
 *                                                 .fallbackBehavior("fallbackBehavior")
 *                                                 .build())
 *                                         .ja4Fingerprint(JA4FingerprintProperty.builder()
 *                                                 .fallbackBehavior("fallbackBehavior")
 *                                                 .build())
 *                                         .jsonBody(JsonBodyProperty.builder()
 *                                                 .matchPattern(JsonMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .includedPaths(List.of("includedPaths"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 // the properties below are optional
 *                                                 .invalidFallbackBehavior("invalidFallbackBehavior")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .method(method)
 *                                         .queryString(queryString)
 *                                         .singleHeader(singleHeader)
 *                                         .singleQueryArgument(singleQueryArgument)
 *                                         .uriPath(uriPath)
 *                                         .build())
 *                                 .textTransformations(List.of(TextTransformationProperty.builder()
 *                                         .priority(123)
 *                                         .type("type")
 *                                         .build()))
 *                                 // the properties below are optional
 *                                 .sensitivityLevel("sensitivityLevel")
 *                                 .build())
 *                         .xssMatchStatement(XssMatchStatementProperty.builder()
 *                                 .fieldToMatch(FieldToMatchProperty.builder()
 *                                         .allQueryArguments(allQueryArguments)
 *                                         .body(BodyProperty.builder()
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .cookies(CookiesProperty.builder()
 *                                                 .matchPattern(CookieMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .excludedCookies(List.of("excludedCookies"))
 *                                                         .includedCookies(List.of("includedCookies"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .headers(HeadersProperty.builder()
 *                                                 .matchPattern(HeaderMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .excludedHeaders(List.of("excludedHeaders"))
 *                                                         .includedHeaders(List.of("includedHeaders"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .ja3Fingerprint(JA3FingerprintProperty.builder()
 *                                                 .fallbackBehavior("fallbackBehavior")
 *                                                 .build())
 *                                         .ja4Fingerprint(JA4FingerprintProperty.builder()
 *                                                 .fallbackBehavior("fallbackBehavior")
 *                                                 .build())
 *                                         .jsonBody(JsonBodyProperty.builder()
 *                                                 .matchPattern(JsonMatchPatternProperty.builder()
 *                                                         .all(all)
 *                                                         .includedPaths(List.of("includedPaths"))
 *                                                         .build())
 *                                                 .matchScope("matchScope")
 *                                                 // the properties below are optional
 *                                                 .invalidFallbackBehavior("invalidFallbackBehavior")
 *                                                 .oversizeHandling("oversizeHandling")
 *                                                 .build())
 *                                         .method(method)
 *                                         .queryString(queryString)
 *                                         .singleHeader(singleHeader)
 *                                         .singleQueryArgument(singleQueryArgument)
 *                                         .uriPath(uriPath)
 *                                         .build())
 *                                 .textTransformations(List.of(TextTransformationProperty.builder()
 *                                         .priority(123)
 *                                         .type("type")
 *                                         .build()))
 *                                 .build())
 *                         .build())
 *                 .visibilityConfig(VisibilityConfigProperty.builder()
 *                         .cloudWatchMetricsEnabled(false)
 *                         .metricName("metricName")
 *                         .sampledRequestsEnabled(false)
 *                         .build())
 *                 // the properties below are optional
 *                 .action(RuleActionProperty.builder()
 *                         .allow(allow)
 *                         .block(block)
 *                         .captcha(captcha)
 *                         .challenge(challenge)
 *                         .count(count)
 *                         .build())
 *                 .captchaConfig(CaptchaConfigProperty.builder()
 *                         .immunityTimeProperty(ImmunityTimePropertyProperty.builder()
 *                                 .immunityTime(123)
 *                                 .build())
 *                         .build())
 *                 .challengeConfig(ChallengeConfigProperty.builder()
 *                         .immunityTimeProperty(ImmunityTimePropertyProperty.builder()
 *                                 .immunityTime(123)
 *                                 .build())
 *                         .build())
 *                 .ruleLabels(List.of(LabelProperty.builder()
 *                         .name("name")
 *                         .build()))
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:25:06.945Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnRuleGroupProps")
@software.amazon.jsii.Jsii.Proxy(CfnRuleGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnRuleGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The web ACL capacity units (WCUs) required for this rule group.
     * <p>
     * When you create your own rule group, you define this, and you cannot change it after creation. When you add or modify the rules in a rule group, AWS WAF enforces this limit.
     * <p>
     * AWS WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and web ACLs. AWS WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group. The WCU limit for web ACLs is 1,500.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-capacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-capacity</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getCapacity();

    /**
     * Specifies whether this is for an Amazon CloudFront distribution or for a regional application.
     * <p>
     * A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AWS AppSync GraphQL API, an Amazon Cognito user pool, an AWS App Runner service, or an AWS Verified Access instance. Valid Values are <code>CLOUDFRONT</code> and <code>REGIONAL</code> .
     * <p>
     * <blockquote>
     * <p>
     * For <code>CLOUDFRONT</code> , you must create your WAFv2 resources in the US East (N. Virginia) Region, <code>us-east-1</code> .
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-scope">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-scope</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getScope();

    /**
     * Defines and enables Amazon CloudWatch metrics and web request sample collection.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-visibilityconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-visibilityconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getVisibilityConfig();

    /**
     * The labels that one or more rules in this rule group add to matching web requests.
     * <p>
     * These labels are defined in the <code>RuleLabels</code> for a <code>Rule</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-availablelabels">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-availablelabels</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAvailableLabels() {
        return null;
    }

    /**
     * The labels that one or more rules in this rule group match against in label match statements.
     * <p>
     * These labels are defined in a <code>LabelMatchStatement</code> specification, in the <code>Statement</code> definition of a rule.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-consumedlabels">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-consumedlabels</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getConsumedLabels() {
        return null;
    }

    /**
     * A map of custom response keys and content bodies.
     * <p>
     * When you create a rule with a block action, you can send a custom response to the web request. You define these for the rule group, and then use them in the rules that you define in the rule group.
     * <p>
     * For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in AWS WAF</a> in the <em>AWS WAF Developer Guide</em> .
     * <p>
     * For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">AWS WAF quotas</a> in the <em>AWS WAF Developer Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-customresponsebodies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-customresponsebodies</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCustomResponseBodies() {
        return null;
    }

    /**
     * A description of the rule group that helps with identification.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The name of the rule group.
     * <p>
     * You cannot change the name of a rule group after you create it.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * The rule statements used to identify the web requests that you want to allow, block, or count.
     * <p>
     * Each rule includes one top-level statement that AWS WAF uses to identify matching web requests, and parameters that govern how AWS WAF handles them.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-rules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-rules</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRules() {
        return null;
    }

    /**
     * Key:value pairs associated with an AWS resource.
     * <p>
     * The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource.
     * <p>
     * <blockquote>
     * <p>
     * To modify tags on existing resources, use the AWS WAF APIs or command line interface. With AWS CloudFormation , you can only add tags to AWS WAF resources during resource creation.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-rulegroup.html#cfn-wafv2-rulegroup-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnRuleGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnRuleGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnRuleGroupProps> {
        java.lang.Number capacity;
        java.lang.String scope;
        java.lang.Object visibilityConfig;
        java.lang.Object availableLabels;
        java.lang.Object consumedLabels;
        java.lang.Object customResponseBodies;
        java.lang.String description;
        java.lang.String name;
        java.lang.Object rules;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnRuleGroupProps#getCapacity}
         * @param capacity The web ACL capacity units (WCUs) required for this rule group. This parameter is required.
         *                 When you create your own rule group, you define this, and you cannot change it after creation. When you add or modify the rules in a rule group, AWS WAF enforces this limit.
         *                 <p>
         *                 AWS WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and web ACLs. AWS WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group. The WCU limit for web ACLs is 1,500.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacity(java.lang.Number capacity) {
            this.capacity = capacity;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuleGroupProps#getScope}
         * @param scope Specifies whether this is for an Amazon CloudFront distribution or for a regional application. This parameter is required.
         *              A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AWS AppSync GraphQL API, an Amazon Cognito user pool, an AWS App Runner service, or an AWS Verified Access instance. Valid Values are <code>CLOUDFRONT</code> and <code>REGIONAL</code> .
         *              <p>
         *              <blockquote>
         *              <p>
         *              For <code>CLOUDFRONT</code> , you must create your WAFv2 resources in the US East (N. Virginia) Region, <code>us-east-1</code> .
         *              <p>
         *              </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scope(java.lang.String scope) {
            this.scope = scope;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuleGroupProps#getVisibilityConfig}
         * @param visibilityConfig Defines and enables Amazon CloudWatch metrics and web request sample collection. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder visibilityConfig(software.amazon.awscdk.IResolvable visibilityConfig) {
            this.visibilityConfig = visibilityConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuleGroupProps#getVisibilityConfig}
         * @param visibilityConfig Defines and enables Amazon CloudWatch metrics and web request sample collection. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder visibilityConfig(software.amazon.awscdk.services.wafv2.CfnRuleGroup.VisibilityConfigProperty visibilityConfig) {
            this.visibilityConfig = visibilityConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuleGroupProps#getAvailableLabels}
         * @param availableLabels The labels that one or more rules in this rule group add to matching web requests.
         *                        These labels are defined in the <code>RuleLabels</code> for a <code>Rule</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availableLabels(software.amazon.awscdk.IResolvable availableLabels) {
            this.availableLabels = availableLabels;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuleGroupProps#getAvailableLabels}
         * @param availableLabels The labels that one or more rules in this rule group add to matching web requests.
         *                        These labels are defined in the <code>RuleLabels</code> for a <code>Rule</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availableLabels(java.util.List<? extends java.lang.Object> availableLabels) {
            this.availableLabels = availableLabels;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuleGroupProps#getConsumedLabels}
         * @param consumedLabels The labels that one or more rules in this rule group match against in label match statements.
         *                       These labels are defined in a <code>LabelMatchStatement</code> specification, in the <code>Statement</code> definition of a rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder consumedLabels(software.amazon.awscdk.IResolvable consumedLabels) {
            this.consumedLabels = consumedLabels;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuleGroupProps#getConsumedLabels}
         * @param consumedLabels The labels that one or more rules in this rule group match against in label match statements.
         *                       These labels are defined in a <code>LabelMatchStatement</code> specification, in the <code>Statement</code> definition of a rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder consumedLabels(java.util.List<? extends java.lang.Object> consumedLabels) {
            this.consumedLabels = consumedLabels;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuleGroupProps#getCustomResponseBodies}
         * @param customResponseBodies A map of custom response keys and content bodies.
         *                             When you create a rule with a block action, you can send a custom response to the web request. You define these for the rule group, and then use them in the rules that you define in the rule group.
         *                             <p>
         *                             For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in AWS WAF</a> in the <em>AWS WAF Developer Guide</em> .
         *                             <p>
         *                             For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">AWS WAF quotas</a> in the <em>AWS WAF Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customResponseBodies(software.amazon.awscdk.IResolvable customResponseBodies) {
            this.customResponseBodies = customResponseBodies;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuleGroupProps#getCustomResponseBodies}
         * @param customResponseBodies A map of custom response keys and content bodies.
         *                             When you create a rule with a block action, you can send a custom response to the web request. You define these for the rule group, and then use them in the rules that you define in the rule group.
         *                             <p>
         *                             For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in AWS WAF</a> in the <em>AWS WAF Developer Guide</em> .
         *                             <p>
         *                             For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">AWS WAF quotas</a> in the <em>AWS WAF Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customResponseBodies(java.util.Map<java.lang.String, ? extends java.lang.Object> customResponseBodies) {
            this.customResponseBodies = customResponseBodies;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuleGroupProps#getDescription}
         * @param description A description of the rule group that helps with identification.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuleGroupProps#getName}
         * @param name The name of the rule group.
         *             You cannot change the name of a rule group after you create it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuleGroupProps#getRules}
         * @param rules The rule statements used to identify the web requests that you want to allow, block, or count.
         *              Each rule includes one top-level statement that AWS WAF uses to identify matching web requests, and parameters that govern how AWS WAF handles them.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rules(software.amazon.awscdk.IResolvable rules) {
            this.rules = rules;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuleGroupProps#getRules}
         * @param rules The rule statements used to identify the web requests that you want to allow, block, or count.
         *              Each rule includes one top-level statement that AWS WAF uses to identify matching web requests, and parameters that govern how AWS WAF handles them.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rules(java.util.List<? extends java.lang.Object> rules) {
            this.rules = rules;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuleGroupProps#getTags}
         * @param tags Key:value pairs associated with an AWS resource.
         *             The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource.
         *             <p>
         *             <blockquote>
         *             <p>
         *             To modify tags on existing resources, use the AWS WAF APIs or command line interface. With AWS CloudFormation , you can only add tags to AWS WAF resources during resource creation.
         *             <p>
         *             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnRuleGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnRuleGroupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnRuleGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnRuleGroupProps {
        private final java.lang.Number capacity;
        private final java.lang.String scope;
        private final java.lang.Object visibilityConfig;
        private final java.lang.Object availableLabels;
        private final java.lang.Object consumedLabels;
        private final java.lang.Object customResponseBodies;
        private final java.lang.String description;
        private final java.lang.String name;
        private final java.lang.Object rules;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.capacity = software.amazon.jsii.Kernel.get(this, "capacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.scope = software.amazon.jsii.Kernel.get(this, "scope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.visibilityConfig = software.amazon.jsii.Kernel.get(this, "visibilityConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.availableLabels = software.amazon.jsii.Kernel.get(this, "availableLabels", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.consumedLabels = software.amazon.jsii.Kernel.get(this, "consumedLabels", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.customResponseBodies = software.amazon.jsii.Kernel.get(this, "customResponseBodies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.rules = software.amazon.jsii.Kernel.get(this, "rules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.capacity = java.util.Objects.requireNonNull(builder.capacity, "capacity is required");
            this.scope = java.util.Objects.requireNonNull(builder.scope, "scope is required");
            this.visibilityConfig = java.util.Objects.requireNonNull(builder.visibilityConfig, "visibilityConfig is required");
            this.availableLabels = builder.availableLabels;
            this.consumedLabels = builder.consumedLabels;
            this.customResponseBodies = builder.customResponseBodies;
            this.description = builder.description;
            this.name = builder.name;
            this.rules = builder.rules;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Number getCapacity() {
            return this.capacity;
        }

        @Override
        public final java.lang.String getScope() {
            return this.scope;
        }

        @Override
        public final java.lang.Object getVisibilityConfig() {
            return this.visibilityConfig;
        }

        @Override
        public final java.lang.Object getAvailableLabels() {
            return this.availableLabels;
        }

        @Override
        public final java.lang.Object getConsumedLabels() {
            return this.consumedLabels;
        }

        @Override
        public final java.lang.Object getCustomResponseBodies() {
            return this.customResponseBodies;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getRules() {
            return this.rules;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("capacity", om.valueToTree(this.getCapacity()));
            data.set("scope", om.valueToTree(this.getScope()));
            data.set("visibilityConfig", om.valueToTree(this.getVisibilityConfig()));
            if (this.getAvailableLabels() != null) {
                data.set("availableLabels", om.valueToTree(this.getAvailableLabels()));
            }
            if (this.getConsumedLabels() != null) {
                data.set("consumedLabels", om.valueToTree(this.getConsumedLabels()));
            }
            if (this.getCustomResponseBodies() != null) {
                data.set("customResponseBodies", om.valueToTree(this.getCustomResponseBodies()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getRules() != null) {
                data.set("rules", om.valueToTree(this.getRules()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnRuleGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnRuleGroupProps.Jsii$Proxy that = (CfnRuleGroupProps.Jsii$Proxy) o;

            if (!capacity.equals(that.capacity)) return false;
            if (!scope.equals(that.scope)) return false;
            if (!visibilityConfig.equals(that.visibilityConfig)) return false;
            if (this.availableLabels != null ? !this.availableLabels.equals(that.availableLabels) : that.availableLabels != null) return false;
            if (this.consumedLabels != null ? !this.consumedLabels.equals(that.consumedLabels) : that.consumedLabels != null) return false;
            if (this.customResponseBodies != null ? !this.customResponseBodies.equals(that.customResponseBodies) : that.customResponseBodies != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.rules != null ? !this.rules.equals(that.rules) : that.rules != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.capacity.hashCode();
            result = 31 * result + (this.scope.hashCode());
            result = 31 * result + (this.visibilityConfig.hashCode());
            result = 31 * result + (this.availableLabels != null ? this.availableLabels.hashCode() : 0);
            result = 31 * result + (this.consumedLabels != null ? this.consumedLabels.hashCode() : 0);
            result = 31 * result + (this.customResponseBodies != null ? this.customResponseBodies.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.rules != null ? this.rules.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
