package software.amazon.awscdk.services.xray;

/**
 * Properties for defining a <code>CfnTransactionSearchConfig</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.xray.*;
 * CfnTransactionSearchConfigProps cfnTransactionSearchConfigProps = CfnTransactionSearchConfigProps.builder()
 *         .indexingPercentage(123)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-xray-transactionsearchconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-xray-transactionsearchconfig.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.109.0 (build c221850)", date = "2025-03-14T03:25:07.161Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_xray.CfnTransactionSearchConfigProps")
@software.amazon.jsii.Jsii.Proxy(CfnTransactionSearchConfigProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnTransactionSearchConfigProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Determines the percentage of traces indexed from CloudWatch Logs to X-Ray.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-xray-transactionsearchconfig.html#cfn-xray-transactionsearchconfig-indexingpercentage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-xray-transactionsearchconfig.html#cfn-xray-transactionsearchconfig-indexingpercentage</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getIndexingPercentage() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnTransactionSearchConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnTransactionSearchConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnTransactionSearchConfigProps> {
        java.lang.Number indexingPercentage;

        /**
         * Sets the value of {@link CfnTransactionSearchConfigProps#getIndexingPercentage}
         * @param indexingPercentage Determines the percentage of traces indexed from CloudWatch Logs to X-Ray.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder indexingPercentage(java.lang.Number indexingPercentage) {
            this.indexingPercentage = indexingPercentage;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTransactionSearchConfigProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnTransactionSearchConfigProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnTransactionSearchConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTransactionSearchConfigProps {
        private final java.lang.Number indexingPercentage;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.indexingPercentage = software.amazon.jsii.Kernel.get(this, "indexingPercentage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.indexingPercentage = builder.indexingPercentage;
        }

        @Override
        public final java.lang.Number getIndexingPercentage() {
            return this.indexingPercentage;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getIndexingPercentage() != null) {
                data.set("indexingPercentage", om.valueToTree(this.getIndexingPercentage()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_xray.CfnTransactionSearchConfigProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTransactionSearchConfigProps.Jsii$Proxy that = (CfnTransactionSearchConfigProps.Jsii$Proxy) o;

            return this.indexingPercentage != null ? this.indexingPercentage.equals(that.indexingPercentage) : that.indexingPercentage == null;
        }

        @Override
        public final int hashCode() {
            int result = this.indexingPercentage != null ? this.indexingPercentage.hashCode() : 0;
            return result;
        }
    }
}
