/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ec2;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.services.ec2.ApplyCloudFormationInitOptions;
import software.amazon.awscdk.services.ec2.BlockDevice;
import software.amazon.awscdk.services.ec2.CloudFormationInit;
import software.amazon.awscdk.services.ec2.CpuCredits;
import software.amazon.awscdk.services.ec2.IKeyPair;
import software.amazon.awscdk.services.ec2.IMachineImage;
import software.amazon.awscdk.services.ec2.IPlacementGroup;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.InstanceInitiatedShutdownBehavior;
import software.amazon.awscdk.services.ec2.InstanceProps;
import software.amazon.awscdk.services.ec2.InstanceType;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.ec2.UserData;
import software.amazon.awscdk.services.iam.IInstanceProfile;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_ec2.InstanceProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface InstanceProps
extends JsiiSerializable {
    @NotNull
    public InstanceType getInstanceType();

    @NotNull
    public IMachineImage getMachineImage();

    @NotNull
    public IVpc getVpc();

    @Nullable
    default public Boolean getAllowAllIpv6Outbound() {
        return null;
    }

    @Nullable
    default public Boolean getAllowAllOutbound() {
        return null;
    }

    @Nullable
    default public Boolean getAssociatePublicIpAddress() {
        return null;
    }

    @Nullable
    default public String getAvailabilityZone() {
        return null;
    }

    @Nullable
    default public List<BlockDevice> getBlockDevices() {
        return null;
    }

    @Nullable
    default public CpuCredits getCreditSpecification() {
        return null;
    }

    @Nullable
    default public Boolean getDetailedMonitoring() {
        return null;
    }

    @Nullable
    default public Boolean getDisableApiTermination() {
        return null;
    }

    @Nullable
    default public Boolean getEbsOptimized() {
        return null;
    }

    @Nullable
    default public Boolean getEnclaveEnabled() {
        return null;
    }

    @Nullable
    default public Boolean getHibernationEnabled() {
        return null;
    }

    @Nullable
    default public CloudFormationInit getInit() {
        return null;
    }

    @Nullable
    default public ApplyCloudFormationInitOptions getInitOptions() {
        return null;
    }

    @Nullable
    default public InstanceInitiatedShutdownBehavior getInstanceInitiatedShutdownBehavior() {
        return null;
    }

    @Nullable
    default public String getInstanceName() {
        return null;
    }

    @Nullable
    default public IInstanceProfile getInstanceProfile() {
        return null;
    }

    @Nullable
    default public Number getIpv6AddressCount() {
        return null;
    }

    @Deprecated
    @Nullable
    default public String getKeyName() {
        return null;
    }

    @Nullable
    default public IKeyPair getKeyPair() {
        return null;
    }

    @Nullable
    default public IPlacementGroup getPlacementGroup() {
        return null;
    }

    @Nullable
    default public String getPrivateIpAddress() {
        return null;
    }

    @Nullable
    default public Boolean getPropagateTagsToVolumeOnCreation() {
        return null;
    }

    @Nullable
    default public Boolean getRequireImdsv2() {
        return null;
    }

    @Nullable
    default public Duration getResourceSignalTimeout() {
        return null;
    }

    @Nullable
    default public IRole getRole() {
        return null;
    }

    @Nullable
    default public ISecurityGroup getSecurityGroup() {
        return null;
    }

    @Nullable
    default public Boolean getSourceDestCheck() {
        return null;
    }

    @Nullable
    default public Boolean getSsmSessionPermissions() {
        return null;
    }

    @Nullable
    default public UserData getUserData() {
        return null;
    }

    @Nullable
    default public Boolean getUserDataCausesReplacement() {
        return null;
    }

    @Nullable
    default public SubnetSelection getVpcSubnets() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<InstanceProps> {
        InstanceType instanceType;
        IMachineImage machineImage;
        IVpc vpc;
        Boolean allowAllIpv6Outbound;
        Boolean allowAllOutbound;
        Boolean associatePublicIpAddress;
        String availabilityZone;
        List<BlockDevice> blockDevices;
        CpuCredits creditSpecification;
        Boolean detailedMonitoring;
        Boolean disableApiTermination;
        Boolean ebsOptimized;
        Boolean enclaveEnabled;
        Boolean hibernationEnabled;
        CloudFormationInit init;
        ApplyCloudFormationInitOptions initOptions;
        InstanceInitiatedShutdownBehavior instanceInitiatedShutdownBehavior;
        String instanceName;
        IInstanceProfile instanceProfile;
        Number ipv6AddressCount;
        String keyName;
        IKeyPair keyPair;
        IPlacementGroup placementGroup;
        String privateIpAddress;
        Boolean propagateTagsToVolumeOnCreation;
        Boolean requireImdsv2;
        Duration resourceSignalTimeout;
        IRole role;
        ISecurityGroup securityGroup;
        Boolean sourceDestCheck;
        Boolean ssmSessionPermissions;
        UserData userData;
        Boolean userDataCausesReplacement;
        SubnetSelection vpcSubnets;

        public Builder instanceType(InstanceType instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public Builder machineImage(IMachineImage machineImage) {
            this.machineImage = machineImage;
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        public Builder allowAllIpv6Outbound(Boolean allowAllIpv6Outbound) {
            this.allowAllIpv6Outbound = allowAllIpv6Outbound;
            return this;
        }

        public Builder allowAllOutbound(Boolean allowAllOutbound) {
            this.allowAllOutbound = allowAllOutbound;
            return this;
        }

        public Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        public Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public Builder blockDevices(List<? extends BlockDevice> blockDevices) {
            this.blockDevices = blockDevices;
            return this;
        }

        public Builder creditSpecification(CpuCredits creditSpecification) {
            this.creditSpecification = creditSpecification;
            return this;
        }

        public Builder detailedMonitoring(Boolean detailedMonitoring) {
            this.detailedMonitoring = detailedMonitoring;
            return this;
        }

        public Builder disableApiTermination(Boolean disableApiTermination) {
            this.disableApiTermination = disableApiTermination;
            return this;
        }

        public Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public Builder enclaveEnabled(Boolean enclaveEnabled) {
            this.enclaveEnabled = enclaveEnabled;
            return this;
        }

        public Builder hibernationEnabled(Boolean hibernationEnabled) {
            this.hibernationEnabled = hibernationEnabled;
            return this;
        }

        public Builder init(CloudFormationInit init) {
            this.init = init;
            return this;
        }

        public Builder initOptions(ApplyCloudFormationInitOptions initOptions) {
            this.initOptions = initOptions;
            return this;
        }

        public Builder instanceInitiatedShutdownBehavior(InstanceInitiatedShutdownBehavior instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
            return this;
        }

        public Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public Builder instanceProfile(IInstanceProfile instanceProfile) {
            this.instanceProfile = instanceProfile;
            return this;
        }

        public Builder ipv6AddressCount(Number ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
            return this;
        }

        @Deprecated
        public Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public Builder keyPair(IKeyPair keyPair) {
            this.keyPair = keyPair;
            return this;
        }

        public Builder placementGroup(IPlacementGroup placementGroup) {
            this.placementGroup = placementGroup;
            return this;
        }

        public Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public Builder propagateTagsToVolumeOnCreation(Boolean propagateTagsToVolumeOnCreation) {
            this.propagateTagsToVolumeOnCreation = propagateTagsToVolumeOnCreation;
            return this;
        }

        public Builder requireImdsv2(Boolean requireImdsv2) {
            this.requireImdsv2 = requireImdsv2;
            return this;
        }

        public Builder resourceSignalTimeout(Duration resourceSignalTimeout) {
            this.resourceSignalTimeout = resourceSignalTimeout;
            return this;
        }

        public Builder role(IRole role) {
            this.role = role;
            return this;
        }

        public Builder securityGroup(ISecurityGroup securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        public Builder sourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        public Builder ssmSessionPermissions(Boolean ssmSessionPermissions) {
            this.ssmSessionPermissions = ssmSessionPermissions;
            return this;
        }

        public Builder userData(UserData userData) {
            this.userData = userData;
            return this;
        }

        public Builder userDataCausesReplacement(Boolean userDataCausesReplacement) {
            this.userDataCausesReplacement = userDataCausesReplacement;
            return this;
        }

        public Builder vpcSubnets(SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        public InstanceProps build() {
            return new Jsii.Proxy(this);
        }
    }
}

