/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.kinesisfirehose;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.cloudwatch.Metric;
import software.amazon.awscdk.services.cloudwatch.MetricOptions;
import software.amazon.awscdk.services.ec2.Connections;
import software.amazon.awscdk.services.iam.Grant;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.awscdk.services.iam.IPrincipal;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.kinesisfirehose.DeliveryStreamAttributes;
import software.amazon.awscdk.services.kinesisfirehose.DeliveryStreamProps;
import software.amazon.awscdk.services.kinesisfirehose.IDeliveryStream;
import software.amazon.awscdk.services.kinesisfirehose.IDestination;
import software.amazon.awscdk.services.kinesisfirehose.ISource;
import software.amazon.awscdk.services.kinesisfirehose.StreamEncryption;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kinesisfirehose.DeliveryStream")
public class DeliveryStream
extends Resource
implements IDeliveryStream {
    protected DeliveryStream(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DeliveryStream(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public DeliveryStream(@NotNull Construct scope, @NotNull String id, @NotNull DeliveryStreamProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IDeliveryStream fromDeliveryStreamArn(@NotNull Construct scope, @NotNull String id, @NotNull String deliveryStreamArn) {
        return (IDeliveryStream)JsiiObject.jsiiStaticCall(DeliveryStream.class, (String)"fromDeliveryStreamArn", (NativeType)NativeType.forClass(IDeliveryStream.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(deliveryStreamArn, "deliveryStreamArn is required")});
    }

    @NotNull
    public static IDeliveryStream fromDeliveryStreamAttributes(@NotNull Construct scope, @NotNull String id, @NotNull DeliveryStreamAttributes attrs) {
        return (IDeliveryStream)JsiiObject.jsiiStaticCall(DeliveryStream.class, (String)"fromDeliveryStreamAttributes", (NativeType)NativeType.forClass(IDeliveryStream.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @NotNull
    public static IDeliveryStream fromDeliveryStreamName(@NotNull Construct scope, @NotNull String id, @NotNull String deliveryStreamName) {
        return (IDeliveryStream)JsiiObject.jsiiStaticCall(DeliveryStream.class, (String)"fromDeliveryStreamName", (NativeType)NativeType.forClass(IDeliveryStream.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(deliveryStreamName, "deliveryStreamName is required")});
    }

    @Override
    @NotNull
    public Grant grant(@NotNull IGrantable grantee, String ... actions) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grant", (NativeType)NativeType.forClass(Grant.class), (Object[])Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(grantee, "grantee is required")}), Arrays.stream(actions)).toArray(Object[]::new)));
    }

    @Override
    @NotNull
    public Grant grantPutRecords(@NotNull IGrantable grantee) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantPutRecords", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")}));
    }

    @Override
    @NotNull
    public Metric metric(@NotNull String metricName, @Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metric", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(metricName, "metricName is required"), props});
    }

    @Override
    @NotNull
    public Metric metric(@NotNull String metricName) {
        return (Metric)Kernel.call((Object)this, (String)"metric", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(metricName, "metricName is required")});
    }

    @Override
    @NotNull
    public Metric metricBackupToS3Bytes(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricBackupToS3Bytes", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricBackupToS3Bytes() {
        return (Metric)Kernel.call((Object)this, (String)"metricBackupToS3Bytes", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricBackupToS3DataFreshness(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricBackupToS3DataFreshness", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricBackupToS3DataFreshness() {
        return (Metric)Kernel.call((Object)this, (String)"metricBackupToS3DataFreshness", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricBackupToS3Records(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricBackupToS3Records", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricBackupToS3Records() {
        return (Metric)Kernel.call((Object)this, (String)"metricBackupToS3Records", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricIncomingBytes(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricIncomingBytes", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricIncomingBytes() {
        return (Metric)Kernel.call((Object)this, (String)"metricIncomingBytes", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricIncomingRecords(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricIncomingRecords", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricIncomingRecords() {
        return (Metric)Kernel.call((Object)this, (String)"metricIncomingRecords", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Connections getConnections() {
        return (Connections)Kernel.get((Object)this, (String)"connections", (NativeType)NativeType.forClass(Connections.class));
    }

    @Override
    @NotNull
    public String getDeliveryStreamArn() {
        return (String)Kernel.get((Object)this, (String)"deliveryStreamArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getDeliveryStreamName() {
        return (String)Kernel.get((Object)this, (String)"deliveryStreamName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public IPrincipal getGrantPrincipal() {
        return (IPrincipal)Kernel.get((Object)this, (String)"grantPrincipal", (NativeType)NativeType.forClass(IPrincipal.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<DeliveryStream> {
        private final Construct scope;
        private final String id;
        private final DeliveryStreamProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new DeliveryStreamProps.Builder();
        }

        public Builder destination(IDestination destination) {
            this.props.destination(destination);
            return this;
        }

        public Builder deliveryStreamName(String deliveryStreamName) {
            this.props.deliveryStreamName(deliveryStreamName);
            return this;
        }

        public Builder encryption(StreamEncryption encryption) {
            this.props.encryption(encryption);
            return this;
        }

        public Builder role(IRole role) {
            this.props.role(role);
            return this;
        }

        public Builder source(ISource source) {
            this.props.source(source);
            return this;
        }

        public DeliveryStream build() {
            return new DeliveryStream(this.scope, this.id, this.props.build());
        }
    }
}

