/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.batch;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.batch.FairshareSchedulingPolicyProps;
import software.amazon.awscdk.services.batch.IFairshareSchedulingPolicy;
import software.amazon.awscdk.services.batch.ISchedulingPolicy;
import software.amazon.awscdk.services.batch.Share;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_batch.FairshareSchedulingPolicy")
public class FairshareSchedulingPolicy
extends Resource
implements IFairshareSchedulingPolicy,
ISchedulingPolicy {
    protected FairshareSchedulingPolicy(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected FairshareSchedulingPolicy(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public FairshareSchedulingPolicy(@NotNull Construct scope, @NotNull String id, @Nullable FairshareSchedulingPolicyProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public FairshareSchedulingPolicy(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public static IFairshareSchedulingPolicy fromFairshareSchedulingPolicyArn(@NotNull Construct scope, @NotNull String id, @NotNull String fairshareSchedulingPolicyArn) {
        return (IFairshareSchedulingPolicy)JsiiObject.jsiiStaticCall(FairshareSchedulingPolicy.class, (String)"fromFairshareSchedulingPolicyArn", (NativeType)NativeType.forClass(IFairshareSchedulingPolicy.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(fairshareSchedulingPolicyArn, "fairshareSchedulingPolicyArn is required")});
    }

    public void addShare(@NotNull Share share) {
        Kernel.call((Object)this, (String)"addShare", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(share, "share is required")});
    }

    @Override
    @NotNull
    public String getSchedulingPolicyArn() {
        return (String)Kernel.get((Object)this, (String)"schedulingPolicyArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getSchedulingPolicyName() {
        return (String)Kernel.get((Object)this, (String)"schedulingPolicyName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public List<Share> getShares() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"shares", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Share.class))));
    }

    @Override
    @Nullable
    public Number getComputeReservation() {
        return (Number)Kernel.get((Object)this, (String)"computeReservation", (NativeType)NativeType.forClass(Number.class));
    }

    @Override
    @Nullable
    public Duration getShareDecay() {
        return (Duration)((Object)Kernel.get((Object)this, (String)"shareDecay", (NativeType)NativeType.forClass(Duration.class)));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<FairshareSchedulingPolicy> {
        private final Construct scope;
        private final String id;
        private FairshareSchedulingPolicyProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder computeReservation(Number computeReservation) {
            this.props().computeReservation(computeReservation);
            return this;
        }

        public Builder schedulingPolicyName(String schedulingPolicyName) {
            this.props().schedulingPolicyName(schedulingPolicyName);
            return this;
        }

        public Builder shareDecay(Duration shareDecay) {
            this.props().shareDecay(shareDecay);
            return this;
        }

        public Builder shares(List<? extends Share> shares) {
            this.props().shares(shares);
            return this;
        }

        public FairshareSchedulingPolicy build() {
            return new FairshareSchedulingPolicy(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private FairshareSchedulingPolicyProps.Builder props() {
            if (this.props == null) {
                this.props = new FairshareSchedulingPolicyProps.Builder();
            }
            return this.props;
        }
    }
}

