/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.codepipeline;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.IResource;
import software.amazon.awscdk.services.codepipeline.ActionArtifactBounds;
import software.amazon.awscdk.services.codepipeline.ActionCategory;
import software.amazon.awscdk.services.codepipeline.ActionProperties;
import software.amazon.awscdk.services.codepipeline.Artifact;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_codepipeline.ActionProperties")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface ActionProperties
extends JsiiSerializable {
    @NotNull
    public String getActionName();

    @NotNull
    public ActionArtifactBounds getArtifactBounds();

    @NotNull
    public ActionCategory getCategory();

    @NotNull
    public String getProvider();

    @Nullable
    default public String getAccount() {
        return null;
    }

    @Nullable
    default public List<String> getCommands() {
        return null;
    }

    @Nullable
    default public List<Artifact> getInputs() {
        return null;
    }

    @Nullable
    default public List<Artifact> getOutputs() {
        return null;
    }

    @Nullable
    default public List<String> getOutputVariables() {
        return null;
    }

    @Nullable
    default public String getOwner() {
        return null;
    }

    @Nullable
    default public String getRegion() {
        return null;
    }

    @Nullable
    default public IResource getResource() {
        return null;
    }

    @Nullable
    default public IRole getRole() {
        return null;
    }

    @Nullable
    default public Number getRunOrder() {
        return null;
    }

    @Nullable
    default public Duration getTimeout() {
        return null;
    }

    @Nullable
    default public String getVariablesNamespace() {
        return null;
    }

    @Nullable
    default public String getVersion() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<ActionProperties> {
        String actionName;
        ActionArtifactBounds artifactBounds;
        ActionCategory category;
        String provider;
        String account;
        List<String> commands;
        List<Artifact> inputs;
        List<Artifact> outputs;
        List<String> outputVariables;
        String owner;
        String region;
        IResource resource;
        IRole role;
        Number runOrder;
        Duration timeout;
        String variablesNamespace;
        String version;

        public Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public Builder artifactBounds(ActionArtifactBounds artifactBounds) {
            this.artifactBounds = artifactBounds;
            return this;
        }

        public Builder category(ActionCategory category) {
            this.category = category;
            return this;
        }

        public Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public Builder account(String account) {
            this.account = account;
            return this;
        }

        public Builder commands(List<String> commands) {
            this.commands = commands;
            return this;
        }

        public Builder inputs(List<? extends Artifact> inputs) {
            this.inputs = inputs;
            return this;
        }

        public Builder outputs(List<? extends Artifact> outputs) {
            this.outputs = outputs;
            return this;
        }

        public Builder outputVariables(List<String> outputVariables) {
            this.outputVariables = outputVariables;
            return this;
        }

        public Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public Builder region(String region) {
            this.region = region;
            return this;
        }

        public Builder resource(IResource resource) {
            this.resource = resource;
            return this;
        }

        public Builder role(IRole role) {
            this.role = role;
            return this;
        }

        public Builder runOrder(Number runOrder) {
            this.runOrder = runOrder;
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder variablesNamespace(String variablesNamespace) {
            this.variablesNamespace = variablesNamespace;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public ActionProperties build() {
            return new Jsii.Proxy(this);
        }
    }
}

