/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.cognito.identitypool;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.cognito.identitypool.IIdentityPool;
import software.amazon.awscdk.services.cognito.identitypool.IUserPoolAuthenticationProvider;
import software.amazon.awscdk.services.cognito.identitypool.IdentityPoolAuthenticationProviders;
import software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProps;
import software.amazon.awscdk.services.cognito.identitypool.IdentityPoolRoleMapping;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_cognito_identitypool.IdentityPool")
public class IdentityPool
extends Resource
implements IIdentityPool {
    protected IdentityPool(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected IdentityPool(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public IdentityPool(@NotNull Construct scope, @NotNull String id, @Nullable IdentityPoolProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public IdentityPool(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public static IIdentityPool fromIdentityPoolArn(@NotNull Construct scope, @NotNull String id, @NotNull String identityPoolArn) {
        return (IIdentityPool)JsiiObject.jsiiStaticCall(IdentityPool.class, (String)"fromIdentityPoolArn", (NativeType)NativeType.forClass(IIdentityPool.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(identityPoolArn, "identityPoolArn is required")});
    }

    @NotNull
    public static IIdentityPool fromIdentityPoolId(@NotNull Construct scope, @NotNull String id, @NotNull String identityPoolId) {
        return (IIdentityPool)JsiiObject.jsiiStaticCall(IdentityPool.class, (String)"fromIdentityPoolId", (NativeType)NativeType.forClass(IIdentityPool.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(identityPoolId, "identityPoolId is required")});
    }

    public void addUserPoolAuthentication(@NotNull IUserPoolAuthenticationProvider userPool) {
        Kernel.call((Object)this, (String)"addUserPoolAuthentication", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(userPool, "userPool is required")});
    }

    @NotNull
    public IRole getAuthenticatedRole() {
        return (IRole)Kernel.get((Object)this, (String)"authenticatedRole", (NativeType)NativeType.forClass(IRole.class));
    }

    @Override
    @NotNull
    public String getIdentityPoolArn() {
        return (String)Kernel.get((Object)this, (String)"identityPoolArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getIdentityPoolId() {
        return (String)Kernel.get((Object)this, (String)"identityPoolId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getIdentityPoolName() {
        return (String)Kernel.get((Object)this, (String)"identityPoolName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public IRole getUnauthenticatedRole() {
        return (IRole)Kernel.get((Object)this, (String)"unauthenticatedRole", (NativeType)NativeType.forClass(IRole.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<IdentityPool> {
        private final Construct scope;
        private final String id;
        private IdentityPoolProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder allowClassicFlow(Boolean allowClassicFlow) {
            this.props().allowClassicFlow(allowClassicFlow);
            return this;
        }

        public Builder allowUnauthenticatedIdentities(Boolean allowUnauthenticatedIdentities) {
            this.props().allowUnauthenticatedIdentities(allowUnauthenticatedIdentities);
            return this;
        }

        public Builder authenticatedRole(IRole authenticatedRole) {
            this.props().authenticatedRole(authenticatedRole);
            return this;
        }

        public Builder authenticationProviders(IdentityPoolAuthenticationProviders authenticationProviders) {
            this.props().authenticationProviders(authenticationProviders);
            return this;
        }

        public Builder identityPoolName(String identityPoolName) {
            this.props().identityPoolName(identityPoolName);
            return this;
        }

        public Builder roleMappings(List<? extends IdentityPoolRoleMapping> roleMappings) {
            this.props().roleMappings(roleMappings);
            return this;
        }

        public Builder unauthenticatedRole(IRole unauthenticatedRole) {
            this.props().unauthenticatedRole(unauthenticatedRole);
            return this;
        }

        public IdentityPool build() {
            return new IdentityPool(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private IdentityPoolProps.Builder props() {
            if (this.props == null) {
                this.props = new IdentityPoolProps.Builder();
            }
            return this.props;
        }
    }
}

