/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.scheduler.targets;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.ecs.CapacityProviderStrategy;
import software.amazon.awscdk.services.ecs.ICluster;
import software.amazon.awscdk.services.ecs.PlacementConstraint;
import software.amazon.awscdk.services.ecs.PlacementStrategy;
import software.amazon.awscdk.services.ecs.TaskDefinition;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.scheduler.ISchedule;
import software.amazon.awscdk.services.scheduler.ScheduleTargetConfig;
import software.amazon.awscdk.services.scheduler.ScheduleTargetInput;
import software.amazon.awscdk.services.scheduler.targets.Ec2TaskProps;
import software.amazon.awscdk.services.scheduler.targets.EcsRunTask;
import software.amazon.awscdk.services.scheduler.targets.Tag;
import software.amazon.awscdk.services.sqs.IQueue;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_scheduler_targets.EcsRunEc2Task")
public class EcsRunEc2Task
extends EcsRunTask {
    protected EcsRunEc2Task(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EcsRunEc2Task(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public EcsRunEc2Task(@NotNull ICluster cluster, @NotNull Ec2TaskProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(cluster, "cluster is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    @NotNull
    protected ScheduleTargetConfig bindBaseTargetConfig(@NotNull ISchedule _schedule) {
        return (ScheduleTargetConfig)Kernel.call((Object)this, (String)"bindBaseTargetConfig", (NativeType)NativeType.forClass(ScheduleTargetConfig.class), (Object[])new Object[]{Objects.requireNonNull(_schedule, "_schedule is required")});
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<EcsRunEc2Task> {
        private final ICluster cluster;
        private final Ec2TaskProps.Builder props;

        public static Builder create(ICluster cluster) {
            return new Builder(cluster);
        }

        private Builder(ICluster cluster) {
            this.cluster = cluster;
            this.props = new Ec2TaskProps.Builder();
        }

        public Builder deadLetterQueue(IQueue deadLetterQueue) {
            this.props.deadLetterQueue(deadLetterQueue);
            return this;
        }

        public Builder input(ScheduleTargetInput input) {
            this.props.input(input);
            return this;
        }

        public Builder maxEventAge(Duration maxEventAge) {
            this.props.maxEventAge(maxEventAge);
            return this;
        }

        public Builder retryAttempts(Number retryAttempts) {
            this.props.retryAttempts(retryAttempts);
            return this;
        }

        public Builder role(IRole role) {
            this.props.role(role);
            return this;
        }

        public Builder taskDefinition(TaskDefinition taskDefinition) {
            this.props.taskDefinition(taskDefinition);
            return this;
        }

        public Builder capacityProviderStrategies(List<? extends CapacityProviderStrategy> capacityProviderStrategies) {
            this.props.capacityProviderStrategies(capacityProviderStrategies);
            return this;
        }

        public Builder enableEcsManagedTags(Boolean enableEcsManagedTags) {
            this.props.enableEcsManagedTags(enableEcsManagedTags);
            return this;
        }

        public Builder enableExecuteCommand(Boolean enableExecuteCommand) {
            this.props.enableExecuteCommand(enableExecuteCommand);
            return this;
        }

        public Builder group(String group) {
            this.props.group(group);
            return this;
        }

        public Builder propagateTags(Boolean propagateTags) {
            this.props.propagateTags(propagateTags);
            return this;
        }

        public Builder referenceId(String referenceId) {
            this.props.referenceId(referenceId);
            return this;
        }

        public Builder securityGroups(List<? extends ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        public Builder tags(List<? extends Tag> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder taskCount(Number taskCount) {
            this.props.taskCount(taskCount);
            return this;
        }

        public Builder vpcSubnets(SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        public Builder placementConstraints(List<? extends PlacementConstraint> placementConstraints) {
            this.props.placementConstraints(placementConstraints);
            return this;
        }

        public Builder placementStrategies(List<? extends PlacementStrategy> placementStrategies) {
            this.props.placementStrategies(placementStrategies);
            return this;
        }

        public EcsRunEc2Task build() {
            return new EcsRunEc2Task(this.cluster, this.props.build());
        }
    }
}

