/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.scheduler.targets;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.scheduler.IScheduleTarget;
import software.amazon.awscdk.services.scheduler.ScheduleTargetInput;
import software.amazon.awscdk.services.scheduler.targets.ScheduleTargetBase;
import software.amazon.awscdk.services.scheduler.targets.ScheduleTargetBaseProps;
import software.amazon.awscdk.services.sqs.IQueue;
import software.amazon.awscdk.services.stepfunctions.IStateMachine;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_scheduler_targets.StepFunctionsStartExecution")
public class StepFunctionsStartExecution
extends ScheduleTargetBase
implements IScheduleTarget {
    protected StepFunctionsStartExecution(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected StepFunctionsStartExecution(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public StepFunctionsStartExecution(@NotNull IStateMachine stateMachine, @NotNull ScheduleTargetBaseProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(stateMachine, "stateMachine is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    protected void addTargetActionToRole(@NotNull IRole role) {
        Kernel.call((Object)this, (String)"addTargetActionToRole", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(role, "role is required")});
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<StepFunctionsStartExecution> {
        private final IStateMachine stateMachine;
        private final ScheduleTargetBaseProps.Builder props;

        public static Builder create(IStateMachine stateMachine) {
            return new Builder(stateMachine);
        }

        private Builder(IStateMachine stateMachine) {
            this.stateMachine = stateMachine;
            this.props = new ScheduleTargetBaseProps.Builder();
        }

        public Builder deadLetterQueue(IQueue deadLetterQueue) {
            this.props.deadLetterQueue(deadLetterQueue);
            return this;
        }

        public Builder input(ScheduleTargetInput input) {
            this.props.input(input);
            return this;
        }

        public Builder maxEventAge(Duration maxEventAge) {
            this.props.maxEventAge(maxEventAge);
            return this;
        }

        public Builder retryAttempts(Number retryAttempts) {
            this.props.retryAttempts(retryAttempts);
            return this;
        }

        public Builder role(IRole role) {
            this.props.role(role);
            return this;
        }

        public StepFunctionsStartExecution build() {
            return new StepFunctionsStartExecution(this.stateMachine, this.props.build());
        }
    }
}

