/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.AssetHashType;
import software.amazon.awscdk.BundlingOptions;
import software.amazon.awscdk.IgnoreMode;
import software.amazon.awscdk.SymlinkFollowMode;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.awscdk.services.iam.IPrincipal;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.s3.assets.AssetOptions;
import software.amazon.awscdk.services.stepfunctions.DefinitionBody;
import software.amazon.awscdk.services.stepfunctions.DefinitionConfig;
import software.amazon.awscdk.services.stepfunctions.StateGraph;
import software.amazon.awscdk.services.stepfunctions.StateMachineProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_stepfunctions.FileDefinitionBody")
public class FileDefinitionBody
extends DefinitionBody {
    protected FileDefinitionBody(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected FileDefinitionBody(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public FileDefinitionBody(@NotNull String path, @Nullable AssetOptions options) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(path, "path is required"), options});
    }

    public FileDefinitionBody(@NotNull String path) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(path, "path is required")});
    }

    @Override
    @NotNull
    public DefinitionConfig bind(@NotNull Construct scope, @NotNull IPrincipal _sfnPrincipal, @NotNull StateMachineProps _sfnProps, @Nullable StateGraph _graph) {
        return (DefinitionConfig)Kernel.call((Object)((Object)this), (String)"bind", (NativeType)NativeType.forClass(DefinitionConfig.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(_sfnPrincipal, "_sfnPrincipal is required"), Objects.requireNonNull(_sfnProps, "_sfnProps is required"), _graph});
    }

    @Override
    @NotNull
    public DefinitionConfig bind(@NotNull Construct scope, @NotNull IPrincipal _sfnPrincipal, @NotNull StateMachineProps _sfnProps) {
        return (DefinitionConfig)Kernel.call((Object)((Object)this), (String)"bind", (NativeType)NativeType.forClass(DefinitionConfig.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(_sfnPrincipal, "_sfnPrincipal is required"), Objects.requireNonNull(_sfnProps, "_sfnProps is required")});
    }

    @NotNull
    public String getPath() {
        return (String)Kernel.get((Object)((Object)this), (String)"path", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<FileDefinitionBody> {
        private final String path;
        private AssetOptions.Builder options;

        public static Builder create(String path) {
            return new Builder(path);
        }

        private Builder(String path) {
            this.path = path;
        }

        public Builder assetHash(String assetHash) {
            this.options().assetHash(assetHash);
            return this;
        }

        public Builder assetHashType(AssetHashType assetHashType) {
            this.options().assetHashType(assetHashType);
            return this;
        }

        public Builder bundling(BundlingOptions bundling) {
            this.options().bundling(bundling);
            return this;
        }

        public Builder exclude(List<String> exclude) {
            this.options().exclude(exclude);
            return this;
        }

        public Builder followSymlinks(SymlinkFollowMode followSymlinks) {
            this.options().followSymlinks(followSymlinks);
            return this;
        }

        public Builder ignoreMode(IgnoreMode ignoreMode) {
            this.options().ignoreMode(ignoreMode);
            return this;
        }

        public Builder deployTime(Boolean deployTime) {
            this.options().deployTime(deployTime);
            return this;
        }

        public Builder displayName(String displayName) {
            this.options().displayName(displayName);
            return this;
        }

        public Builder readers(List<? extends IGrantable> readers) {
            this.options().readers(readers);
            return this;
        }

        public Builder sourceKmsKey(IKey sourceKmsKey) {
            this.options().sourceKmsKey(sourceKmsKey);
            return this;
        }

        public FileDefinitionBody build() {
            return new FileDefinitionBody(this.path, this.options != null ? this.options.build() : null);
        }

        private AssetOptions.Builder options() {
            if (this.options == null) {
                this.options = new AssetOptions.Builder();
            }
            return this.options;
        }
    }
}

