/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.pipelines;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.;
import software.amazon.awscdk.pipelines.CodeBuildOptions;
import software.amazon.awscdk.pipelines.CodePipelineProps;
import software.amazon.awscdk.pipelines.DockerCredential;
import software.amazon.awscdk.pipelines.IFileSetProducer;
import software.amazon.awscdk.pipelines.PipelineBase;
import software.amazon.awscdk.services.codebuild.IProject;
import software.amazon.awscdk.services.codepipeline.Pipeline;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.pipelines.CodePipeline")
public class CodePipeline
extends PipelineBase {
    protected CodePipeline(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CodePipeline(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CodePipeline(@NotNull Construct scope, @NotNull String id, @NotNull CodePipelineProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    protected void doBuildPipeline() {
        Kernel.call((Object)((Object)this), (String)"doBuildPipeline", (NativeType)NativeType.VOID, (Object[])new Object[0]);
    }

    @NotNull
    public Pipeline getPipeline() {
        return (Pipeline)Kernel.get((Object)((Object)this), (String)"pipeline", (NativeType)NativeType.forClass(Pipeline.class));
    }

    @NotNull
    public Boolean getSelfMutationEnabled() {
        return (Boolean)Kernel.get((Object)((Object)this), (String)"selfMutationEnabled", (NativeType)NativeType.forClass(Boolean.class));
    }

    @NotNull
    public IProject getSelfMutationProject() {
        return (IProject)Kernel.get((Object)((Object)this), (String)"selfMutationProject", (NativeType)NativeType.forClass(IProject.class));
    }

    @NotNull
    public IProject getSynthProject() {
        return (IProject)Kernel.get((Object)((Object)this), (String)"synthProject", (NativeType)NativeType.forClass(IProject.class));
    }

    @NotNull
    public Boolean getUsePipelineRoleForActions() {
        return (Boolean)Kernel.get((Object)((Object)this), (String)"usePipelineRoleForActions", (NativeType)NativeType.forClass(Boolean.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CodePipeline> {
        private final Construct scope;
        private final String id;
        private final CodePipelineProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CodePipelineProps.Builder();
        }

        public Builder synth(IFileSetProducer synth) {
            this.props.synth(synth);
            return this;
        }

        public Builder artifactBucket(IBucket artifactBucket) {
            this.props.artifactBucket(artifactBucket);
            return this;
        }

        public Builder assetPublishingCodeBuildDefaults(CodeBuildOptions assetPublishingCodeBuildDefaults) {
            this.props.assetPublishingCodeBuildDefaults(assetPublishingCodeBuildDefaults);
            return this;
        }

        public Builder cliVersion(String cliVersion) {
            this.props.cliVersion(cliVersion);
            return this;
        }

        public Builder codeBuildDefaults(CodeBuildOptions codeBuildDefaults) {
            this.props.codeBuildDefaults(codeBuildDefaults);
            return this;
        }

        public Builder codePipeline(Pipeline codePipeline) {
            this.props.codePipeline(codePipeline);
            return this;
        }

        public Builder crossAccountKeys(Boolean crossAccountKeys) {
            this.props.crossAccountKeys(crossAccountKeys);
            return this;
        }

        public Builder crossRegionReplicationBuckets(Map<String, ? extends IBucket> crossRegionReplicationBuckets) {
            this.props.crossRegionReplicationBuckets(crossRegionReplicationBuckets);
            return this;
        }

        public Builder dockerCredentials(List<? extends DockerCredential> dockerCredentials) {
            this.props.dockerCredentials(dockerCredentials);
            return this;
        }

        public Builder dockerEnabledForSelfMutation(Boolean dockerEnabledForSelfMutation) {
            this.props.dockerEnabledForSelfMutation(dockerEnabledForSelfMutation);
            return this;
        }

        public Builder dockerEnabledForSynth(Boolean dockerEnabledForSynth) {
            this.props.dockerEnabledForSynth(dockerEnabledForSynth);
            return this;
        }

        public Builder enableKeyRotation(Boolean enableKeyRotation) {
            this.props.enableKeyRotation(enableKeyRotation);
            return this;
        }

        public Builder pipelineName(String pipelineName) {
            this.props.pipelineName(pipelineName);
            return this;
        }

        public Builder publishAssetsInParallel(Boolean publishAssetsInParallel) {
            this.props.publishAssetsInParallel(publishAssetsInParallel);
            return this;
        }

        public Builder reuseCrossRegionSupportStacks(Boolean reuseCrossRegionSupportStacks) {
            this.props.reuseCrossRegionSupportStacks(reuseCrossRegionSupportStacks);
            return this;
        }

        public Builder role(IRole role) {
            this.props.role(role);
            return this;
        }

        public Builder selfMutation(Boolean selfMutation) {
            this.props.selfMutation(selfMutation);
            return this;
        }

        public Builder selfMutationCodeBuildDefaults(CodeBuildOptions selfMutationCodeBuildDefaults) {
            this.props.selfMutationCodeBuildDefaults(selfMutationCodeBuildDefaults);
            return this;
        }

        public Builder synthCodeBuildDefaults(CodeBuildOptions synthCodeBuildDefaults) {
            this.props.synthCodeBuildDefaults(synthCodeBuildDefaults);
            return this;
        }

        public Builder useChangeSets(Boolean useChangeSets) {
            this.props.useChangeSets(useChangeSets);
            return this;
        }

        public Builder usePipelineRoleForActions(Boolean usePipelineRoleForActions) {
            this.props.usePipelineRoleForActions(usePipelineRoleForActions);
            return this;
        }

        public CodePipeline build() {
            return new CodePipeline(this.scope, this.id, this.props.build());
        }
    }
}

