/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.apigateway;

import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.RemovalPolicy;
import software.amazon.awscdk.Size;
import software.amazon.awscdk.services.apigateway.ApiKeySourceType;
import software.amazon.awscdk.services.apigateway.CorsOptions;
import software.amazon.awscdk.services.apigateway.DomainNameOptions;
import software.amazon.awscdk.services.apigateway.EndpointConfiguration;
import software.amazon.awscdk.services.apigateway.EndpointType;
import software.amazon.awscdk.services.apigateway.IRestApi;
import software.amazon.awscdk.services.apigateway.Integration;
import software.amazon.awscdk.services.apigateway.LambdaIntegrationOptions;
import software.amazon.awscdk.services.apigateway.LambdaRestApiProps;
import software.amazon.awscdk.services.apigateway.MethodOptions;
import software.amazon.awscdk.services.apigateway.RestApiProps;
import software.amazon.awscdk.services.apigateway.StageOptions;
import software.amazon.awscdk.services.iam.PolicyDocument;
import software.amazon.awscdk.services.lambda.IFunction;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_apigateway.LambdaRestApiProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface LambdaRestApiProps
extends JsiiSerializable,
RestApiProps {
    @NotNull
    public IFunction getHandler();

    @Nullable
    default public LambdaIntegrationOptions getIntegrationOptions() {
        return null;
    }

    @Nullable
    default public Boolean getProxy() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<LambdaRestApiProps> {
        IFunction handler;
        LambdaIntegrationOptions integrationOptions;
        Boolean proxy;
        ApiKeySourceType apiKeySourceType;
        List<String> binaryMediaTypes;
        IRestApi cloneFrom;
        Size minCompressionSize;
        Number minimumCompressionSize;
        CorsOptions defaultCorsPreflightOptions;
        Integration defaultIntegration;
        MethodOptions defaultMethodOptions;
        Boolean cloudWatchRole;
        RemovalPolicy cloudWatchRoleRemovalPolicy;
        Boolean deploy;
        StageOptions deployOptions;
        String description;
        Boolean disableExecuteApiEndpoint;
        DomainNameOptions domainName;
        EndpointConfiguration endpointConfiguration;
        String endpointExportName;
        List<EndpointType> endpointTypes;
        Boolean failOnWarnings;
        Map<String, String> parameters;
        PolicyDocument policy;
        String restApiName;
        Boolean retainDeployments;

        public Builder handler(IFunction handler) {
            this.handler = handler;
            return this;
        }

        public Builder integrationOptions(LambdaIntegrationOptions integrationOptions) {
            this.integrationOptions = integrationOptions;
            return this;
        }

        public Builder proxy(Boolean proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder apiKeySourceType(ApiKeySourceType apiKeySourceType) {
            this.apiKeySourceType = apiKeySourceType;
            return this;
        }

        public Builder binaryMediaTypes(List<String> binaryMediaTypes) {
            this.binaryMediaTypes = binaryMediaTypes;
            return this;
        }

        public Builder cloneFrom(IRestApi cloneFrom) {
            this.cloneFrom = cloneFrom;
            return this;
        }

        public Builder minCompressionSize(Size minCompressionSize) {
            this.minCompressionSize = minCompressionSize;
            return this;
        }

        @Deprecated
        public Builder minimumCompressionSize(Number minimumCompressionSize) {
            this.minimumCompressionSize = minimumCompressionSize;
            return this;
        }

        public Builder defaultCorsPreflightOptions(CorsOptions defaultCorsPreflightOptions) {
            this.defaultCorsPreflightOptions = defaultCorsPreflightOptions;
            return this;
        }

        public Builder defaultIntegration(Integration defaultIntegration) {
            this.defaultIntegration = defaultIntegration;
            return this;
        }

        public Builder defaultMethodOptions(MethodOptions defaultMethodOptions) {
            this.defaultMethodOptions = defaultMethodOptions;
            return this;
        }

        public Builder cloudWatchRole(Boolean cloudWatchRole) {
            this.cloudWatchRole = cloudWatchRole;
            return this;
        }

        public Builder cloudWatchRoleRemovalPolicy(RemovalPolicy cloudWatchRoleRemovalPolicy) {
            this.cloudWatchRoleRemovalPolicy = cloudWatchRoleRemovalPolicy;
            return this;
        }

        public Builder deploy(Boolean deploy) {
            this.deploy = deploy;
            return this;
        }

        public Builder deployOptions(StageOptions deployOptions) {
            this.deployOptions = deployOptions;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder disableExecuteApiEndpoint(Boolean disableExecuteApiEndpoint) {
            this.disableExecuteApiEndpoint = disableExecuteApiEndpoint;
            return this;
        }

        public Builder domainName(DomainNameOptions domainName) {
            this.domainName = domainName;
            return this;
        }

        public Builder endpointConfiguration(EndpointConfiguration endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration;
            return this;
        }

        public Builder endpointExportName(String endpointExportName) {
            this.endpointExportName = endpointExportName;
            return this;
        }

        public Builder endpointTypes(List<? extends EndpointType> endpointTypes) {
            this.endpointTypes = endpointTypes;
            return this;
        }

        public Builder failOnWarnings(Boolean failOnWarnings) {
            this.failOnWarnings = failOnWarnings;
            return this;
        }

        public Builder parameters(Map<String, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder policy(PolicyDocument policy) {
            this.policy = policy;
            return this;
        }

        public Builder restApiName(String restApiName) {
            this.restApiName = restApiName;
            return this;
        }

        public Builder retainDeployments(Boolean retainDeployments) {
            this.retainDeployments = retainDeployments;
            return this;
        }

        public LambdaRestApiProps build() {
            return new Jsii.Proxy(this);
        }
    }
}

