/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.appsync;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.;
import software.amazon.awscdk.services.appsync.AppSyncAuthorizationType;
import software.amazon.awscdk.services.appsync.AppSyncDomainOptions;
import software.amazon.awscdk.services.appsync.AppSyncLogConfig;
import software.amazon.awscdk.services.appsync.CfnApiKey;
import software.amazon.awscdk.services.appsync.EventApiAttributes;
import software.amazon.awscdk.services.appsync.EventApiAuthConfig;
import software.amazon.awscdk.services.appsync.EventApiBase;
import software.amazon.awscdk.services.appsync.EventApiProps;
import software.amazon.awscdk.services.appsync.IEventApi;
import software.amazon.awscdk.services.logs.ILogGroup;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_appsync.EventApi")
public class EventApi
extends EventApiBase {
    protected EventApi(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EventApi(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public EventApi(@NotNull Construct scope, @NotNull String id, @NotNull EventApiProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IEventApi fromEventApiAttributes(@NotNull Construct scope, @NotNull String id, @NotNull EventApiAttributes attrs) {
        return (IEventApi)JsiiObject.jsiiStaticCall(EventApi.class, (String)"fromEventApiAttributes", (NativeType)NativeType.forClass(IEventApi.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @Override
    @NotNull
    public String getApiArn() {
        return (String)Kernel.get((Object)this, (String)"apiArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getApiId() {
        return (String)Kernel.get((Object)this, (String)"apiId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public Map<String, CfnApiKey> getApiKeys() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"apiKeys", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(CfnApiKey.class))));
    }

    @NotNull
    public String getAppSyncDomainName() {
        return (String)Kernel.get((Object)this, (String)"appSyncDomainName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public List<AppSyncAuthorizationType> getAuthProviderTypes() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"authProviderTypes", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(AppSyncAuthorizationType.class))));
    }

    @NotNull
    public List<AppSyncAuthorizationType> getConnectionModeTypes() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"connectionModeTypes", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(AppSyncAuthorizationType.class))));
    }

    @NotNull
    public String getCustomHttpEndpoint() {
        return (String)Kernel.get((Object)this, (String)"customHttpEndpoint", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getCustomRealtimeEndpoint() {
        return (String)Kernel.get((Object)this, (String)"customRealtimeEndpoint", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public List<AppSyncAuthorizationType> getDefaultPublishModeTypes() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"defaultPublishModeTypes", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(AppSyncAuthorizationType.class))));
    }

    @NotNull
    public List<AppSyncAuthorizationType> getDefaultSubscribeModeTypes() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"defaultSubscribeModeTypes", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(AppSyncAuthorizationType.class))));
    }

    @Override
    @NotNull
    public String getHttpDns() {
        return (String)Kernel.get((Object)this, (String)"httpDns", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public ILogGroup getLogGroup() {
        return (ILogGroup)Kernel.get((Object)this, (String)"logGroup", (NativeType)NativeType.forClass(ILogGroup.class));
    }

    @Override
    @NotNull
    public String getRealtimeDns() {
        return (String)Kernel.get((Object)this, (String)"realtimeDns", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<EventApi> {
        private final Construct scope;
        private final String id;
        private final EventApiProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new EventApiProps.Builder();
        }

        public Builder apiName(String apiName) {
            this.props.apiName(apiName);
            return this;
        }

        public Builder authorizationConfig(EventApiAuthConfig authorizationConfig) {
            this.props.authorizationConfig(authorizationConfig);
            return this;
        }

        public Builder domainName(AppSyncDomainOptions domainName) {
            this.props.domainName(domainName);
            return this;
        }

        public Builder logConfig(AppSyncLogConfig logConfig) {
            this.props.logConfig(logConfig);
            return this;
        }

        public Builder ownerContact(String ownerContact) {
            this.props.ownerContact(ownerContact);
            return this;
        }

        public EventApi build() {
            return new EventApi(this.scope, this.id, this.props.build());
        }
    }
}

